(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     30903,       1199]
NotebookOptionsPosition[     24133,        947]
NotebookOutlinePosition[     25357,        983]
CellTagsIndexPosition[     25272,        978]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Expressions as Trees" :> 
          Documentation`HelpLookup["paclet:tutorial/ExpressionsAsTrees"], 
          "Levels in Expressions" :> 
          Documentation`HelpLookup["paclet:tutorial/LevelsInExpressions"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Expressions as Trees\"\>", 
       2->"\<\"Levels in Expressions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ArrayDepth" :> 
          Documentation`HelpLookup["paclet:ref/ArrayDepth"], "Level" :> 
          Documentation`HelpLookup["paclet:ref/Level"], "LeafCount" :> 
          Documentation`HelpLookup["paclet:ref/LeafCount"], "Length" :> 
          Documentation`HelpLookup["paclet:ref/Length"], "Nest" :> 
          Documentation`HelpLookup["paclet:ref/Nest"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ArrayDepth\"\>", 2->"\<\"Level\"\>", 
       3->"\<\"LeafCount\"\>", 4->"\<\"Length\"\>", 
       5->"\<\"Nest\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Expressions" :> 
          Documentation`HelpLookup["paclet:guide/Expressions"], 
          "Expression Structure" :> 
          Documentation`HelpLookup["paclet:guide/ExpressionStructure"], 
          "Memory Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/MemoryMeasurementAndOptimization"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Expressions\"\>", 
       2->"\<\"Expression Structure\"\>", 
       3->"\<\"Memory Measurement & Optimization\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Depth", "ObjectName",
 CellID->1804],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Depth",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Depth"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the maximum number of indices needed to specify \
any part of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", plus one. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30807]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Raw objects have depth ",
 Cell[BoxData["1"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3952],

Cell[TextData[{
 "The computation of ",
 Cell[BoxData[
  ButtonBox["Depth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Depth"]], "InlineFormula"],
 " does not include heads of expressions. "
}], "Notes",
 CellID->27626],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Depth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Depth"]], "InlineFormula"],
 " treats ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects just like the corresponding ordinary lists. "
}], "Notes",
 CellID->2331]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->95332124],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->840094319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Depth", "[", "a", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17330],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30961]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Depth", "[", 
  RowBox[{"{", "a", "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30047],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24770]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Depth", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"{", "a", "}"}], "}"}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->7426],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->19387]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Depth", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "a", "}"}], ",", "b"}], "}"}], "}"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->14614],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->22686]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19539],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Depth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Depth"]], "InlineFormula"],
 " works on any expression, not just lists:"
}], "ExampleText",
 CellID->27365],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Depth", "[", 
  RowBox[{"1", "+", "x", "+", 
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"x", "^", "5"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25521],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21044]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14502],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Depth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Depth"]], "InlineFormula"],
 " does not distinguish heads:"
}], "ExampleText",
 CellID->31057],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Depth", "[", 
  RowBox[{"f", "[", 
   RowBox[{"g", "[", 
    RowBox[{"h", "[", "x", "]"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32120],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30716]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10038],

Cell["All numbers have depth 1:", "ExampleText",
 CellID->25131],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Depth", "[", "12345", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10388],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15344]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Depth", "[", 
  RowBox[{"3", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10439],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7535]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15901],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Depth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Depth"]], "InlineFormula"],
 " works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->3988],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", "x", "}"}], "}"}], "}"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12891],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "1", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 1, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{203, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12140]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Depth", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18232],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21834]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9765],

Cell["Find how deeply nested results from integrals are:", "ExampleText",
 CellID->5356],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Depth", "[", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"x", "^", "n"}], "-", "1"}], ")"}]}], ",", "x"}], "]"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26833],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3", ",", "5", ",", "7", ",", "5", ",", "10", ",", "8", ",", "8", ",", "8", 
   ",", "9", ",", "10"}], "}"}]], "Output",
 ImageSize->{203, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31786]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1528],

Cell[TextData[{
 "Find the depths of combinator expressions ",
 ButtonBox["[more info]:",
  BaseStyle->"NKSLink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/page-1122a-text"], None}]
}], "ExampleText",
 CellID->2609],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "/.", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"s", "[", "x_", "]"}], "[", "y_", "]"}], "[", "z_", "]"}], 
      "\[Rule]", 
      RowBox[{
       RowBox[{"x", "[", "z", "]"}], "[", 
       RowBox[{"y", "[", "z", "]"}], "]"}]}]}], "&"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"s", "[", "s", "]"}], "[", "s", "]"}], "[", 
      RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "[", "s", "]"}], 
   ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4363],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWdtuAiEQRddLW61p00t8tD/TPvUjNqaJPjRtrN/b/RQLi1qDKJcZYFjX
RJYFZpgbMMt5L9eLj89yvZyXs7dV+b1Yzn9mr18r3lR0GOv8MsZepozXN7xW
/8Wv4n9ZlbV7XnZ551h5jrbP/vY5MLSr9K58zvWzYif9ht058j/1DpX3nB6H
8j7trXzYOnJ87xneoeNTy2OiL7bWdbUjVE7X/tR2dB3/KAp2xcueJna7SO0m
KbDpqMvty2dATC/oOOp+8qX7X1Wsv2+t25h2jrijbLSOxaWp2vtzFafcsCFW
CUnV1MjB4SJ3oLGOt3KehOw3SRmaPnf9XPmp2TF1fbHH5+5vV3o1L3kQBbvm
pWhUewukdpMW2HTU5bblMyGmB3Qcdb/40rXZ+6XnYH5cbxtijTZrT5u1i/O7
p6EukNpt9k1MOupy2/KZENMDOo66X3zp5CpqERcY/XNk+S4DaaGOtk4d+dFA
V0W1AtdUj9046upqK19k22RT6PyuvoX4VN3vmSwB6xq6j2DvY7GQayi/WHqG
3vdD7/M7PetxR9EKRS5DIao23y+Y8qVGqrHnoWavWHFDFXGvv7e1qy/UvUH6
W5HUtz05I9MxJcrdL/Qin9IdnZtfZE6r4nhDHU/lNDjXrzs9MMdTw4Gp49qh
56du39TxSB23Fzf6x9kKFCcNhd/a3MtC5k2Ng2PPk9o+seKCCn6vX01t7h9K
wlxx7abm/Jj+oBfp+eX6p093CIoaCt0NPW9qlBx7ntT2iRUXVNB9/WrKHQUK
jaanRn9M+mH7JzbqI6NSHRUaIbZF47EQ4amjPlAEuLZybczKosY6f4lvjIQ=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{478, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->235245649]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Depth", "/@", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27005],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "2", ",", "2", ",", "2", ",", "3"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->19530]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Depth", "/@", 
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"#", "/.", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"s", "[", "x_", "]"}], "[", "y_", "]"}], "[", "z_", "]"}], 
       "\[Rule]", 
       RowBox[{
        RowBox[{"x", "[", "z", "]"}], "[", 
        RowBox[{"y", "[", "z", "]"}], "]"}]}]}], "&"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"s", "[", "s", "]"}], "[", "s", "]"}], "[", 
       RowBox[{"s", "[", "s", "]"}], "]"}], "[", "s", "]"}], "[", "s", "]"}], 
    ",", "30"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->16131],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "2", ",", "2", ",", "2", ",", "3", ",", "3", ",", "3", ",", "4", 
   ",", "5", ",", "6", ",", "6", ",", "6", ",", "7", ",", "8", ",", "8", ",", 
   "8", ",", "9", ",", "10", ",", "11", ",", "11", ",", "11", ",", "12", ",", 
   "13", ",", "13", ",", "13", ",", "14", ",", "14", ",", "14", ",", "14", 
   ",", "14", ",", "14"}], "}"}]], "Output",
 ImageSize->{378, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->810]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22705],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Depth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Depth"]], "InlineFormula"],
 " gives the length of the maximum index, plus 1:"
}], "ExampleText",
 CellID->19797],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"2", "+", 
      RowBox[{"y", "^", "3"}]}], ")"}]}], ",", "_"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15918],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "0", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", "}"}]}], "}"}]], "Output",
 ImageSize->{371, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13316]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Depth", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], 
   RowBox[{"(", 
    RowBox[{"2", "+", 
     RowBox[{"y", "^", "3"}]}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6996],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->25889]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14833],

Cell[TextData[{
 "Successive elements from ",
 Cell[BoxData[
  ButtonBox["NestList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NestList"]], "InlineFormula"],
 " have larger depths:"
}], "ExampleText",
 CellID->20618],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{"f", ",", "x", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2703],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{"f", "[", "x", "]"}], "]"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{"f", "[", 
      RowBox[{"f", "[", "x", "]"}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{"f", "[", 
      RowBox[{"f", "[", 
       RowBox[{"f", "[", "x", "]"}], "]"}], "]"}], "]"}], "]"}]}], 
  "}"}]], "Output",
 ImageSize->{431, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27711]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Depth", "/@", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15460],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->16135]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9690],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Depth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Depth"]], "InlineFormula"],
 " does not count depth in the head:"
}], "ExampleText",
 CellID->3420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Depth", "[", 
  RowBox[{
   RowBox[{"h", "[", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", "a", "}"}], "}"}], "}"}], "]"}], "[", 
   RowBox[{"x", ",", "y"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2646],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8860]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27707],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArrayDepth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayDepth"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Level",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Level"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LeafCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LeafCount"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Length",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Length"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Nest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Nest"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1146]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4569],

Cell[TextData[ButtonBox["Expressions as Trees",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExpressionsAsTrees"]], "Tutorials",
 CellID->15179],

Cell[TextData[ButtonBox["Levels in Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LevelsInExpressions"]], "Tutorials",
 CellID->11808]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->374750723],

Cell[TextData[ButtonBox["Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Expressions"]], "MoreAbout",
 CellID->472826162],

Cell[TextData[ButtonBox["Expression Structure",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExpressionStructure"]], "MoreAbout",
 CellID->133504285],

Cell[TextData[ButtonBox["Memory Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MemoryMeasurementAndOptimization"]], "MoreAbout",
 CellID->2685011]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Depth"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Depth - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 37, 57.7575810}", "context" -> "System`", 
    "keywords" -> {"nesting level"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Depth[expr] gives the maximum number of indices needed to specify any \
part of expr, plus one. ", "synonyms" -> {}, "title" -> "Depth", "type" -> 
    "Symbol", "uri" -> "ref/Depth"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5106, 165, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->95332124]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25130, 971}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2593, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3216, 87, 42, 1, 70, "ObjectName",
 CellID->1804],
Cell[3261, 90, 596, 19, 70, "Usage",
 CellID->30807]
}, Open  ]],
Cell[CellGroupData[{
Cell[3894, 114, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4372, 131, 115, 5, 70, "Notes",
 CellID->3952],
Cell[4490, 138, 225, 8, 70, "Notes",
 CellID->27626],
Cell[4718, 148, 351, 12, 70, "Notes",
 CellID->2331]
}, Closed]],
Cell[CellGroupData[{
Cell[5106, 165, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->95332124],
Cell[CellGroupData[{
Cell[5490, 179, 148, 5, 70, "ExampleSection",
 CellID->840094319],
Cell[CellGroupData[{
Cell[5663, 188, 97, 3, 28, "Input",
 CellID->17330],
Cell[5763, 193, 154, 5, 36, "Output",
 CellID->30961]
}, Open  ]],
Cell[CellGroupData[{
Cell[5954, 203, 120, 4, 28, "Input",
 CellID->30047],
Cell[6077, 209, 154, 5, 36, "Output",
 CellID->24770]
}, Open  ]],
Cell[CellGroupData[{
Cell[6268, 219, 168, 6, 28, "Input",
 CellID->7426],
Cell[6439, 227, 154, 5, 36, "Output",
 CellID->19387]
}, Open  ]],
Cell[CellGroupData[{
Cell[6630, 237, 195, 7, 28, "Input",
 CellID->14614],
Cell[6828, 246, 154, 5, 36, "Output",
 CellID->22686]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7031, 257, 216, 7, 70, "ExampleSection",
 CellID->19539],
Cell[7250, 266, 208, 7, 70, "ExampleText",
 CellID->27365],
Cell[CellGroupData[{
Cell[7483, 277, 188, 6, 70, "Input",
 CellID->25521],
Cell[7674, 285, 154, 5, 36, "Output",
 CellID->21044]
}, Open  ]],
Cell[7843, 293, 121, 3, 70, "ExampleDelimiter",
 CellID->14502],
Cell[7967, 298, 195, 7, 70, "ExampleText",
 CellID->31057],
Cell[CellGroupData[{
Cell[8187, 309, 184, 6, 70, "Input",
 CellID->32120],
Cell[8374, 317, 154, 5, 36, "Output",
 CellID->30716]
}, Open  ]],
Cell[8543, 325, 121, 3, 70, "ExampleDelimiter",
 CellID->10038],
Cell[8667, 330, 64, 1, 70, "ExampleText",
 CellID->25131],
Cell[CellGroupData[{
Cell[8756, 335, 101, 3, 70, "Input",
 CellID->10388],
Cell[8860, 340, 154, 5, 36, "Output",
 CellID->15344]
}, Open  ]],
Cell[CellGroupData[{
Cell[9051, 350, 120, 4, 70, "Input",
 CellID->10439],
Cell[9174, 356, 153, 5, 36, "Output",
 CellID->7535]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9376, 367, 239, 7, 70, "ExampleSection",
 CellID->15901],
Cell[9618, 376, 317, 12, 70, "ExampleText",
 CellID->3988],
Cell[CellGroupData[{
Cell[9960, 392, 201, 7, 70, "Input",
 CellID->12891],
Cell[10164, 401, 495, 17, 36, "Output",
 CellID->12140]
}, Open  ]],
Cell[CellGroupData[{
Cell[10696, 423, 97, 3, 70, "Input",
 CellID->18232],
Cell[10796, 428, 154, 5, 36, "Output",
 CellID->21834]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10999, 439, 222, 7, 70, "ExampleSection",
 CellID->9765],
Cell[11224, 448, 88, 1, 70, "ExampleText",
 CellID->5356],
Cell[CellGroupData[{
Cell[11337, 453, 386, 14, 70, "Input",
 CellID->26833],
Cell[11726, 469, 289, 9, 36, "Output",
 CellID->31786]
}, Open  ]],
Cell[12030, 481, 120, 3, 70, "ExampleDelimiter",
 CellID->1528],
Cell[12153, 486, 238, 7, 70, "ExampleText",
 CellID->2609],
Cell[CellGroupData[{
Cell[12416, 497, 607, 21, 70, "Input",
 CellID->4363],
Cell[13026, 520, 1066, 22, 70, "Output",
 Evaluatable->False,
 CellID->235245649]
}, Open  ]],
Cell[CellGroupData[{
Cell[14129, 547, 93, 3, 70, "Input",
 CellID->27005],
Cell[14225, 552, 229, 7, 36, "Output",
 CellID->19530]
}, Open  ]],
Cell[CellGroupData[{
Cell[14491, 564, 655, 22, 70, "Input",
 CellID->16131],
Cell[15149, 588, 521, 12, 54, "Output",
 CellID->810]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15719, 606, 233, 7, 70, "ExampleSection",
 CellID->22705],
Cell[15955, 615, 214, 7, 70, "ExampleText",
 CellID->19797],
Cell[CellGroupData[{
Cell[16194, 626, 271, 10, 70, "Input",
 CellID->15918],
Cell[16468, 638, 872, 29, 54, "Output",
 CellID->13316]
}, Open  ]],
Cell[CellGroupData[{
Cell[17377, 672, 238, 9, 70, "Input",
 CellID->6996],
Cell[17618, 683, 154, 5, 36, "Output",
 CellID->25889]
}, Open  ]],
Cell[17787, 691, 121, 3, 70, "ExampleDelimiter",
 CellID->14833],
Cell[17911, 696, 223, 8, 70, "ExampleText",
 CellID->20618],
Cell[CellGroupData[{
Cell[18159, 708, 132, 4, 70, "Input",
 CellID->2703],
Cell[18294, 714, 698, 23, 36, "Output",
 CellID->27711]
}, Open  ]],
Cell[CellGroupData[{
Cell[19029, 742, 93, 3, 70, "Input",
 CellID->15460],
Cell[19125, 747, 243, 8, 36, "Output",
 CellID->16135]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19417, 761, 225, 7, 70, "ExampleSection",
 CellID->9690],
Cell[19645, 770, 200, 7, 70, "ExampleText",
 CellID->3420],
Cell[CellGroupData[{
Cell[19870, 781, 255, 9, 70, "Input",
 CellID->2646],
Cell[20128, 792, 153, 5, 36, "Output",
 CellID->8860]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20342, 804, 311, 9, 70, "SeeAlsoSection",
 CellID->27707],
Cell[20656, 815, 1173, 44, 70, "SeeAlso",
 CellID->1146]
}, Open  ]],
Cell[CellGroupData[{
Cell[21866, 864, 313, 9, 70, "TutorialsSection",
 CellID->4569],
Cell[22182, 875, 149, 3, 70, "Tutorials",
 CellID->15179],
Cell[22334, 880, 151, 3, 70, "Tutorials",
 CellID->11808]
}, Open  ]],
Cell[CellGroupData[{
Cell[22522, 888, 319, 9, 70, "MoreAboutSection",
 CellID->374750723],
Cell[22844, 899, 134, 3, 70, "MoreAbout",
 CellID->472826162],
Cell[22981, 904, 151, 3, 70, "MoreAbout",
 CellID->133504285],
Cell[23135, 909, 175, 3, 70, "MoreAbout",
 CellID->2685011]
}, Open  ]],
Cell[CellGroupData[{
Cell[23347, 917, 305, 8, 70, "RelatedLinksSection"],
Cell[23655, 927, 383, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[24053, 943, 50, 0, 70, "History"],
Cell[24106, 945, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

