(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17830,        621]
NotebookOptionsPosition[     14109,        496]
NotebookOutlinePosition[     15384,        533]
CellTagsIndexPosition[     15299,        528]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DiagonalMatrix" :> 
          Documentation`HelpLookup["paclet:ref/DiagonalMatrix"], "Tr" :> 
          Documentation`HelpLookup["paclet:ref/Tr"], "Band" :> 
          Documentation`HelpLookup["paclet:ref/Band"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"DiagonalMatrix\"\>", 2->"\<\"Tr\"\>", 
       3->"\<\"Band\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Parts of Matrices" :> 
          Documentation`HelpLookup["paclet:guide/PartsOfMatrices"], 
          "New in 6.0: List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60ListManipulation"], 
          "New in 6.0: Matrix & Linear Algebra Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Matrices and Linear Algebra\"\>", 
       2->"\<\"Parts of Matrices\"\>", 
       3->"\<\"New in 6.0: List Manipulation\"\>", 
       4->"\<\"New in 6.0: Matrix & Linear Algebra Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Diagonal", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Diagonal",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Diagonal"], "[", 
       StyleBox["m", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the list of elements on the leading diagonal of \
the matrix ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Diagonal",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Diagonal"], "[", 
       RowBox[{
        StyleBox["m", "TI"], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the elements on the ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " diagonal of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Diagonal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Diagonal"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 " works even if ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is not a square matrix."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "For positive ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Diagonal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Diagonal"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
 " gives diagonals above the leading diagonal. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Diagonal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Diagonal"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    RowBox[{"-", 
     StyleBox["k", "TI"]}]}], "]"}]], "InlineFormula"],
 " gives diagonals below."
}], "Notes",
 CellID->18190670]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->377001660],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->80783414],

Cell["Give the diagonal elements of a matrix:", "ExampleText",
 CellID->2976897],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Diagonal", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"g", ",", "h", ",", "i"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->554885826],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "e", ",", "i"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->89185784]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->456546702],

Cell["\<\
Give diagonals one element above and below the leading diagonal:\
\>", "ExampleText",
 CellID->98201484],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Diagonal", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "h", ",", "i"}], "}"}]}], "}"}], ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->440981976],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "f"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39289143]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Diagonal", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "h", ",", "i"}], "}"}]}], "}"}], ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->356593220],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"d", ",", "h"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->631454416]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7791153],

Cell["Give a diagonal of non-square matrix:", "ExampleText",
 CellID->210659477],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Diagonal", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "6", ",", "7", ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"9", ",", "10", ",", "11", ",", "12"}], "}"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->180241764],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "6", ",", "11"}], "}"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->403439322]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->589267740],

Cell["Sub and super diagonals: ", "ExampleText",
 CellID->1103530],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "@", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Diagonal", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{"x", ",", 
        RowBox[{"{", "10", "}"}], ",", 
        RowBox[{"{", "10", "}"}]}], "]"}], ",", "k"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", 
      RowBox[{"-", "9"}], ",", "9"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->522170972],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAw9DEwMEpLMADZ/4E8
MO77/x9IY5JMQEkmIAtEd4BFGFgh1H8wADIYOiEqoaq6sPBw6sEwHZc78JPI
5nBCaRi/EocLuEE0C7JQFYrLeaF0NR5REkwl6ELq+xydn0W0mzFFsrGGAozO
IUKWIntJ9iXtQxOdH02BLzFFYvCGKIyOJUEVlV1GcUjRP4bQ+T5UDRdMEV+i
YgdG+5GhmuZup3poD3yso/NtaRySmCJ2JMU0jLanQNcA+I7mMTb4UhI6X4/u
YY8pok9WqoHRBlTQPSj8T/dYH/ypE50vPwhiC1NEgaIUCKMVqWjKIA2hAU85
Qy/Fo/MFBmX8YooI/qdGaobRQjQwbciE4aBLfUM/F6HzGYdIisAUYfpPzZwB
o5lpaOoQDuVBlGKxp+ChnzNH67fR+m2gU9/Qy0XygzLGR/tFo/2i0XGq0XGq
4TdONToeTxPf0TzGBj4ljc7nEXQ71UN7dJ4dXdXIm2cfXVdCSWiOnPVJA7N+
jIERALbIigs=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{142, 283},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->471374130]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DiagonalMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DiagonalMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tr",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tr"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Band",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Band"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->236404323],

Cell[TextData[ButtonBox["Parts of Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfMatrices"]], "MoreAbout",
 CellID->370945391],

Cell[TextData[ButtonBox["New in 6.0: List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ListManipulation"]], "MoreAbout",
 CellID->343341047],

Cell[TextData[ButtonBox["New in 6.0: Matrix & Linear Algebra Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]], "MoreAbout",
 CellID->31534170]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Diagonal - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 37, 59.8982608}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Diagonal[m] gives the list of elements on the leading diagonal of the \
matrix m. Diagonal[m, k] gives the elements on the k\\[Null]^th diagonal of \
m.", "synonyms" -> {}, "title" -> "Diagonal", "type" -> "Symbol", "uri" -> 
    "ref/Diagonal"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6826, 214, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->377001660]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15156, 521}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1906, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2529, 70, 1573, 37, 70, "ObjectNameGrid"],
Cell[4105, 109, 1183, 39, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5325, 153, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5803, 170, 324, 12, 70, "Notes",
 CellID->1067943069],
Cell[6130, 184, 659, 25, 70, "Notes",
 CellID->18190670]
}, Closed]],
Cell[CellGroupData[{
Cell[6826, 214, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->377001660],
Cell[CellGroupData[{
Cell[7211, 228, 147, 5, 70, "ExampleSection",
 CellID->80783414],
Cell[7361, 235, 80, 1, 70, "ExampleText",
 CellID->2976897],
Cell[CellGroupData[{
Cell[7466, 240, 344, 11, 28, "Input",
 CellID->554885826],
Cell[7813, 253, 212, 7, 36, "Output",
 CellID->89185784]
}, Open  ]],
Cell[8040, 263, 125, 3, 70, "ExampleDelimiter",
 CellID->456546702],
Cell[8168, 268, 114, 3, 70, "ExampleText",
 CellID->98201484],
Cell[CellGroupData[{
Cell[8307, 275, 378, 13, 70, "Input",
 CellID->440981976],
Cell[8688, 290, 202, 7, 36, "Output",
 CellID->39289143]
}, Open  ]],
Cell[CellGroupData[{
Cell[8927, 302, 394, 13, 70, "Input",
 CellID->356593220],
Cell[9324, 317, 203, 7, 36, "Output",
 CellID->631454416]
}, Open  ]],
Cell[9542, 327, 123, 3, 70, "ExampleDelimiter",
 CellID->7791153],
Cell[9668, 332, 80, 1, 70, "ExampleText",
 CellID->210659477],
Cell[CellGroupData[{
Cell[9773, 337, 380, 12, 70, "Input",
 CellID->180241764],
Cell[10156, 351, 214, 7, 36, "Output",
 CellID->403439322]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10419, 364, 228, 7, 70, "ExampleSection",
 CellID->589267740],
Cell[10650, 373, 66, 1, 70, "ExampleText",
 CellID->1103530],
Cell[CellGroupData[{
Cell[10741, 378, 431, 14, 70, "Input",
 CellID->522170972],
Cell[11175, 394, 774, 17, 70, "Output",
 Evaluatable->False,
 CellID->471374130]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12010, 418, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[12329, 429, 692, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[13058, 460, 299, 8, 70, "MoreAboutSection"],
Cell[13360, 470, 163, 3, 70, "MoreAbout",
 CellID->236404323],
Cell[13526, 475, 144, 3, 70, "MoreAbout",
 CellID->370945391],
Cell[13673, 480, 164, 3, 70, "MoreAbout",
 CellID->343341047],
Cell[13840, 485, 197, 4, 70, "MoreAbout",
 CellID->31534170]
}, Open  ]],
Cell[14052, 492, 27, 0, 70, "History"],
Cell[14082, 494, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

