(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35646,       1024]
NotebookOptionsPosition[     31367,        881]
NotebookOutlinePosition[     32677,        918]
CellTagsIndexPosition[     32592,        913]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CreateDialog" :> 
          Documentation`HelpLookup["paclet:ref/CreateDialog"], "DialogInput" :> 
          Documentation`HelpLookup["paclet:ref/DialogInput"], 
          "PaletteNotebook" :> 
          Documentation`HelpLookup["paclet:ref/PaletteNotebook"], 
          "DocumentNotebook" :> 
          Documentation`HelpLookup["paclet:ref/DocumentNotebook"], 
          "NotebookPut" :> 
          Documentation`HelpLookup["paclet:ref/NotebookPut"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CreateDialog\"\>", 
       2->"\<\"DialogInput\"\>", 3->"\<\"PaletteNotebook\"\>", 
       4->"\<\"DocumentNotebook\"\>", 
       5->"\<\"NotebookPut\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dialog Boxes" :> 
          Documentation`HelpLookup["paclet:guide/DialogBoxes"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Dialog Boxes\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["DialogNotebook", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DialogNotebook",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DialogNotebook"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["cell", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["cell", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a dialog notebook that can be manipulated by \
the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " front end. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19942]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CreateWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreateWindow"]], "InlineFormula"],
 " takes a ",
 Cell[BoxData[
  ButtonBox["DialogNotebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DialogNotebook"]], "InlineFormula"],
 " expression and displays it in a separate window."
}], "Notes",
 CellID->261149465],

Cell[TextData[{
 "If generated as output within a notebook, ",
 Cell[BoxData[
  ButtonBox["DialogNotebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DialogNotebook"]], "InlineFormula"],
 " displays as an in-cell representation of a dialog notebook."
}], "Notes",
 CellID->264608945],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DialogNotebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DialogNotebook"]], "InlineFormula"],
 " can take any notebook option."
}], "Notes",
 CellID->208297439]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->40880449],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->441782677],

Cell["Make a dialog notebook:", "ExampleText",
 CellID->109343385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateWindow", "[", 
   RowBox[{"DialogNotebook", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"TextCell", "[", "\"\<Click OK to close\>\"", "]"}], ",", 
      RowBox[{"DefaultButton", "[", "]"}]}], "}"}], "]"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->185067965],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnMlPG1ccx5F6r3LqvYco/0RPba+0UhVFVSs1EBUIjaKqVQ+tquQQhaQJ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   "], {{0, 0}, {125, 88}}, {0, 255}],
  ImageSize->{125 0.75, 88 0.75},
  PlotRange->{{0, 125}, {0, 88}}]], "NotebookImage",
 CellID->205180802]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2744093],

Cell["Make a dialog notebook that accepts input text:", "ExampleText",
 CellID->595373735],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateWindow", "[", 
   RowBox[{"DialogNotebook", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"TextCell", "[", "\"\<Enter a name: \>\"", "]"}], ",", 
      RowBox[{"InputField", "[", 
       RowBox[{
        RowBox[{"Dynamic", "[", "nm", "]"}], ",", "String"}], "]"}], ",", 
      RowBox[{"DefaultButton", "[", 
       RowBox[{"DialogReturn", "[", 
        RowBox[{"ret", "=", "nm"}], "]"}], "]"}]}], "}"}], "]"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->517681080],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3N1PW+cdB3Cm3U+92vV2UfWf2NW227TSVPWik9YQDdKsqqpNvVg1tRdR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   "], {{0, 0}, {288, 121}}, {0, 255}],
  ImageSize->{288 0.75, 121 0.75},
  PlotRange->{{0, 288}, {0, 121}}]], "NotebookImage",
 CellID->444366747]
}, Open  ]],

Cell["Type something in the input field:", "ExampleText",
 CellID->487644555],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnN9PW+cZx5l2P/Vq19tF1X9iV9tu00pT1YtNWkM0SLOqqjbtYtW0XkQh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   "], {{0, 0}, {288, 121}}, {0, 255}],
  ImageSize->{288 0.75, 121 0.75},
  PlotRange->{{0, 288}, {0, 121}}]], "NotebookImage",
 CellID->590888211],

Cell[TextData[{
 "Click OK to assign the input to ",
 Cell[BoxData["ret"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->240822304],

Cell[CellGroupData[{

Cell[BoxData["ret"], "Input",
 CellLabel->"In[2]:=",
 CellID->410771003],

Cell[BoxData["\<\"Edison\"\>"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->38067525]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->194148013],

Cell["A dialog notebook with a variety of control objects:", "ExampleText",
 CellID->415488511],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DialogNotebook", "[", 
  RowBox[{"{", 
   RowBox[{"Grid", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Column", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Row", "[", 
            RowBox[{"{", 
             RowBox[{"\"\<x \>\"", ",", 
              RowBox[{"Slider", "[", 
               RowBox[{"0", ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "1"}], "}"}]}], "]"}]}], "}"}], "]"}], ",",
            
           RowBox[{"Row", "[", 
            RowBox[{"{", 
             RowBox[{"\"\<n \>\"", ",", 
              RowBox[{"Slider", "[", 
               RowBox[{"1", ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "8", ",", "1"}], "}"}]}], "]"}]}], "}"}], 
            "]"}]}], "}"}], "]"}], ",", 
        RowBox[{"Slider2D", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", 
              RowBox[{"-", "1"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"InputField", "[", "]"}], ",", 
        RowBox[{"Row", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"RadioButton", "[", 
            RowBox[{"1", ",", "1"}], "]"}], ",", 
           RowBox[{"RadioButton", "[", 
            RowBox[{"1", ",", "2"}], "]"}], ",", 
           RowBox[{"RadioButton", "[", 
            RowBox[{"1", ",", "3"}], "]"}]}], "}"}], "]"}]}], "}"}]}], "}"}], 
    "]"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->86649404],

Cell[BoxData[
 InterpretationBox[
  PanelBox[GridBox[{
     {
      TooltipBox[
       ButtonBox[
        DynamicBox[FEPrivate`FrontEndResource[
         "FEBitmaps", "ManipulatePasteIcon"],
         ImageSizeCache->{13., {4., 9.}}],
        ButtonFrame->None,
        ButtonFunction:>FrontEndExecute[{
           FrontEnd`NotebookOpen[
            Notebook[{
              Cell[
               BoxData[
                FormBox[
                 TagBox[
                  GridBox[{{
                    TagBox[
                    GridBox[{{
                    InterpretationBox[
                    RowBox[{"\"x \"", "\[InvisibleSpace]", 
                    SliderBox[0, {0, 1}]}], 
                    Row[{"x ", 
                    Slider[0, {0, 1}]}]]}, {
                    InterpretationBox[
                    RowBox[{"\"n \"", "\[InvisibleSpace]", 
                    SliderBox[1, {1, 8, 1}]}], 
                    Row[{"n ", 
                    Slider[1, {1, 8, 1}]}]]}}, 
                    GridBoxAlignment -> {"Columns" -> {{Left}}}], "Column"], 
                    Slider2DBox[{0, 0}, {{-1, -1}, {1, 1}}]}, {
                    TagBox[
                    DynamicModuleBox[{Typeset`i$$ = Null}, 
                    InputFieldBox[
                    Dynamic[Typeset`i$$]], DynamicModuleValues -> Automatic], 
                    InputField[
                    Setting[#]]& ], 
                    InterpretationBox[
                    RowBox[{
                    RadioButtonBox[1, {1}], "\[InvisibleSpace]", 
                    RadioButtonBox[1, {2}], "\[InvisibleSpace]", 
                    RadioButtonBox[1, {3}]}], 
                    Row[{
                    RadioButton[1, 1], 
                    RadioButton[1, 2], 
                    RadioButton[1, 3]}]]}}], "Grid"], StandardForm]]]}, 
             Active -> True, CellMargins -> {{8, 8}, {8, 8}}, ClosingAutoSave -> 
             False, Editable -> False, ImageMargins -> {{0, 0}, {0, 0}}, 
             Magnification -> 1., 
             PrivateNotebookOptions -> {"FileOutlineCache" -> False}, 
             Saveable -> False, 
             ScrollingOptions -> {"VerticalScrollRange" -> Fit}, Selectable -> 
             False, ShowCellBracket -> False, ShowCellLabel -> False, 
             ShowCellTags -> False, WindowElements -> {}, WindowFloating -> 
             False, WindowFrameElements -> "CloseBox", WindowSize -> All, 
             WindowToolbars -> {}]]}],
        DefaultBaseStyle->{},
        Evaluator->None,
        Method->"Queued"],
       "Open this notebook in a new window"]},
     {GridBox[{
        {Cell[BoxData[
          TagBox[GridBox[{
             {
              TagBox[GridBox[{
                 {
                  InterpretationBox[
                   RowBox[{"\<\"x \"\>", "\[InvisibleSpace]", 
                    SliderBox[0, {0, 1}]}],
                   Row[{"x ", 
                    Slider[0, {0, 1}]}]]},
                 {
                  InterpretationBox[
                   RowBox[{"\<\"n \"\>", "\[InvisibleSpace]", 
                    SliderBox[1, {1, 8, 1}]}],
                   Row[{"n ", 
                    Slider[1, {1, 8, 1}]}]]}
                },
                GridBoxAlignment->{"Columns" -> {{Left}}}],
               "Column"], 
              Slider2DBox[{0, 0}, {{-1, -1}, {1, 1}}]},
             {
              TagBox[
               DynamicModuleBox[{Typeset`i$$ = Null}, 
                InputFieldBox[Dynamic[Typeset`i$$]],
                DynamicModuleValues:>{}],
               InputField[
                Setting[#]]& ], 
              InterpretationBox[
               RowBox[{
                RadioButtonBox[1, {1}], "\[InvisibleSpace]", 
                RadioButtonBox[1, {2}], "\[InvisibleSpace]", 
                RadioButtonBox[1, {3}]}],
               Row[{
                 RadioButton[1, 1], 
                 RadioButton[1, 2], 
                 RadioButton[1, 3]}]]}
            }],
           "Grid"]]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxBackground->{
     "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {Inherited, {
         GrayLevel[1]}}, "RowsIndexed" -> {}}],
   DefaultBaseStyle->{}],
  DialogNotebook[{
    Grid[{{
       Column[{
         Row[{"x ", 
           Slider[0, {0, 1}]}], 
         Row[{"n ", 
           Slider[1, {1, 8, 1}]}]}], 
       Slider2D[{0, 0}, {{-1, -1}, {1, 1}}]}, {
       InputField[], 
       Row[{
         RadioButton[1, 1], 
         RadioButton[1, 2], 
         RadioButton[1, 3]}]}}]}]]], "Output",
 ImageSize->{375, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->823024239]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->49467406],

Cell["The following are equivalent: ", "ExampleText",
 CellID->478205352],

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDialog", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"TextCell", "[", "\"\<text\>\"", "]"}], ",", 
     RowBox[{"DefaultButton", "[", "]"}]}], "}"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->240577067],

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateWindow", "[", 
   RowBox[{"DialogNotebook", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"TextCell", "[", "\"\<text\>\"", "]"}], ",", 
      RowBox[{"DefaultButton", "[", "]"}]}], "}"}], "]"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1438284],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->883419135],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PaletteNotebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PaletteNotebook"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["DialogNotebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DialogNotebook"]], "InlineFormula"],
 " use different default settings:"
}], "ExampleText",
 CellID->366891146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", 
  RowBox[{
   RowBox[{"CreateWindow", "[", 
    RowBox[{"DialogNotebook", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"TextCell", "[", "\"\<Click OK to close\>\"", "]"}], ",", 
       RowBox[{"DefaultButton", "[", "]"}]}], "}"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "Editable", ",", "Saveable", ",", "WindowClickSelect", ",", 
     "WindowFloating", ",", "WindowMargins"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->304228367],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Editable", "\[Rule]", "False"}], ",", 
   RowBox[{"Saveable", "\[Rule]", "False"}], ",", 
   RowBox[{"WindowClickSelect", "\[Rule]", "True"}], ",", 
   RowBox[{"WindowFloating", "\[Rule]", "False"}], ",", 
   RowBox[{"WindowMargins", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"514", ",", "Automatic"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "342"}], "}"}]}], "}"}]}]}], "}"}]], "Output",\

 ImageSize->{529, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->193241483]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", 
  RowBox[{
   RowBox[{"CreateWindow", "[", 
    RowBox[{"PaletteNotebook", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"TextCell", "[", "\"\<Click OK to close\>\"", "]"}], ",", 
       RowBox[{"DefaultButton", "[", "]"}]}], "}"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "Editable", ",", "Saveable", ",", "WindowClickSelect", ",", 
     "WindowFloating", ",", "WindowMargins"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->175284950],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Editable", "\[Rule]", "True"}], ",", 
   RowBox[{"Saveable", "\[Rule]", "True"}], ",", 
   RowBox[{"WindowClickSelect", "\[Rule]", "False"}], ",", 
   RowBox[{"WindowFloating", "\[Rule]", "True"}], ",", 
   RowBox[{"WindowMargins", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "0"}], "}"}]}], "}"}]}]}], "}"}]], "Output",
 ImageSize->{494, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->427350115]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30600],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreateDialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateDialog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DialogInput",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DialogInput"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PaletteNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PaletteNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DocumentNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DocumentNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookPut",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookPut"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23498]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->188536750],

Cell[TextData[ButtonBox["Dialog Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DialogBoxes"]], "MoreAbout",
 CellID->351237095]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DialogNotebook - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 4.5702554}", "context" -> "System`", 
    "keywords" -> {"graphical user interface"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "DialogNotebook[{cell_1, cell_2, ...}] represents a dialog notebook that \
can be manipulated by the Mathematica front end. ", 
    "synonyms" -> {"dialog notebook"}, "title" -> "DialogNotebook", "type" -> 
    "Symbol", "uri" -> "ref/DialogNotebook"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6131, 191, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->40880449]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 32450, 906}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1647, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2270, 67, 1579, 37, 70, "ObjectNameGrid"],
Cell[3852, 106, 845, 27, 70, "Usage",
 CellID->19942]
}, Open  ]],
Cell[CellGroupData[{
Cell[4734, 138, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5212, 155, 373, 12, 70, "Notes",
 CellID->261149465],
Cell[5588, 169, 290, 8, 70, "Notes",
 CellID->264608945],
Cell[5881, 179, 213, 7, 70, "Notes",
 CellID->208297439]
}, Closed]],
Cell[CellGroupData[{
Cell[6131, 191, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->40880449],
Cell[CellGroupData[{
Cell[6515, 205, 148, 5, 70, "ExampleSection",
 CellID->441782677],
Cell[6666, 212, 66, 1, 70, "ExampleText",
 CellID->109343385],
Cell[CellGroupData[{
Cell[6757, 217, 324, 10, 70, "Input",
 CellID->185067965],
Cell[7084, 229, 2955, 51, 70, "NotebookImage",
 CellID->205180802]
}, Open  ]],
Cell[10054, 283, 123, 3, 70, "ExampleDelimiter",
 CellID->2744093],
Cell[10180, 288, 90, 1, 70, "ExampleText",
 CellID->595373735],
Cell[CellGroupData[{
Cell[10295, 293, 527, 15, 70, "Input",
 CellID->517681080],
Cell[10825, 310, 3413, 58, 70, "NotebookImage",
 CellID->444366747]
}, Open  ]],
Cell[14253, 371, 77, 1, 70, "ExampleText",
 CellID->487644555],
Cell[14333, 374, 3551, 60, 70, "NotebookImage",
 CellID->590888211],
Cell[17887, 436, 136, 5, 70, "ExampleText",
 CellID->240822304],
Cell[CellGroupData[{
Cell[18048, 445, 72, 2, 70, "Input",
 CellID->410771003],
Cell[18123, 449, 170, 5, 36, "Output",
 CellID->38067525]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18342, 460, 220, 7, 70, "ExampleSection",
 CellID->194148013],
Cell[18565, 469, 95, 1, 70, "ExampleText",
 CellID->415488511],
Cell[CellGroupData[{
Cell[18685, 474, 1783, 53, 70, "Input",
 CellID->86649404],
Cell[20471, 529, 4929, 129, 70, "Output",
 CellID->823024239]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25449, 664, 236, 7, 70, "ExampleSection",
 CellID->49467406],
Cell[25688, 673, 73, 1, 70, "ExampleText",
 CellID->478205352],
Cell[25764, 676, 262, 8, 70, "Input",
 CellID->240577067],
Cell[26029, 686, 309, 10, 70, "Input",
 CellID->1438284],
Cell[26341, 698, 125, 3, 70, "ExampleDelimiter",
 CellID->883419135],
Cell[26469, 703, 364, 12, 70, "ExampleText",
 CellID->366891146],
Cell[CellGroupData[{
Cell[26858, 719, 511, 14, 70, "Input",
 CellID->304228367],
Cell[27372, 735, 637, 19, 54, "Output",
 CellID->193241483]
}, Open  ]],
Cell[CellGroupData[{
Cell[28046, 759, 512, 14, 70, "Input",
 CellID->175284950],
Cell[28561, 775, 629, 18, 54, "Output",
 CellID->427350115]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29251, 800, 311, 9, 70, "SeeAlsoSection",
 CellID->30600],
Cell[29565, 811, 1236, 44, 70, "SeeAlso",
 CellID->23498]
}, Open  ]],
Cell[CellGroupData[{
Cell[30838, 860, 319, 9, 70, "MoreAboutSection",
 CellID->188536750],
Cell[31160, 871, 135, 3, 70, "MoreAbout",
 CellID->351237095]
}, Open  ]],
Cell[31310, 877, 27, 0, 70, "History"],
Cell[31340, 879, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

