(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     52481,       1404]
NotebookOptionsPosition[     46281,       1196]
NotebookOutlinePosition[     47738,       1236]
CellTagsIndexPosition[     47652,       1231]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DialogInput" :> 
          Documentation`HelpLookup["paclet:ref/DialogInput"], "DefaultButton" :> 
          Documentation`HelpLookup["paclet:ref/DefaultButton"], 
          "CancelButton" :> 
          Documentation`HelpLookup["paclet:ref/CancelButton"], "Exit" :> 
          Documentation`HelpLookup["paclet:ref/Exit"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"DialogInput\"\>", 2->"\<\"DefaultButton\"\>", 
       3->"\<\"CancelButton\"\>", 4->"\<\"Exit\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Custom Interface Construction" :> 
          Documentation`HelpLookup[
           "paclet:guide/CustomInterfaceConstruction"], "Dialog Boxes" :> 
          Documentation`HelpLookup["paclet:guide/DialogBoxes"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Custom Interface Construction\"\>", 
       2->"\<\"Dialog Boxes\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["DialogReturn", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DialogReturn",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DialogReturn"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]closes a dialog window, returning the expression ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " from the dialog."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DialogReturn",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DialogReturn"], "[", "]"}]], "InlineFormula"],
     
     " \[LineSeparator]closes a dialog window, returning ",
     Cell[BoxData[
      ButtonBox["Null",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Null"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DialogReturn",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DialogReturn"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " is used inside a dialog put up by ",
 Cell[BoxData[
  ButtonBox["DialogInput",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DialogInput"]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " will be the value returned by ",
 Cell[BoxData[
  ButtonBox["DialogInput",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DialogInput"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DialogReturn",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DialogReturn"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " is used inside a dialog created by ",
 Cell[BoxData[
  ButtonBox["CreateDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreateDialog"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " will be evaluated and then discarded. "
}], "Notes",
 CellID->11478]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->33295630],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->201057691],

Cell[TextData[{
 "Put up a dialog window that returns ",
 Cell[BoxData["123"], "InlineFormula"],
 " when the button is clicked:"
}], "ExampleText",
 CellID->37432141],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{"DialogInput", "[", 
    RowBox[{"Button", "[", 
     RowBox[{"\"\<text\>\"", ",", 
      RowBox[{"DialogReturn", "[", "123", "]"}]}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31958333],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztmdtTE1ccx5np/9D3PvhHdKZPbR86nWmd6Vgf2pkKTgGtYzt2+tBORx8c
wFZqRwSDKFCJgIIoEipSbEgEEnOBILkn5ALJhvslCSxCCT397Z7NYQmJbmgg
iZydDzvf39nvLp7PLHkw75z87rOTbxUUFLwLP+fhh8slJRcoWWEztkU5SIj2
e21PKQdDgvas/9EdBpJqn/AHkzI5wUyFZhbml8LhaDS6urLyGtZfrqci3mFX
V1mWXVtdYUPMTKrf+4ZBPs8lavd6/Exg4ufajiPHywre+yEjvP3JhTOVLZHI
YjSyknUhuand7XQVlzd9fK5aoRzUahwZQa3VfPTt1dOX7ywvR7IuJDe1O212
eDlVzw2Zco7pUSrhsfNzi1kXkqvabfCxgBAaGfZnEHggPHZmei7rQnJcu3mM
ySBY+/TUbNaF5Lh2u2M6g1DtErW73NMZhGrfg/YC/hBn8Siu7e5T7Wlp9/kX
MCDw1RmHhDEBql2i9mAojAGNSbOY13aodonaZ+dZDGgUZ/GRqkMygWqXqD0c
iWFA46szDgljAlS7RO2r7BaGvNupRnFzdwFDtUvUvvZyCwMCSZZC0j7VLlH7
emwLAxpJlkLSPtUuUftWRg+qPYvap6j2FH2H1bJ/2kMh+u1S8j687UeOl6lM
HpTRQ2Uah8dOTjJZF5Kz2n+safv8vFw96s2Uc5t/Bh74U027zzuRdSG5qd1l
d/rHHWA+s9+lllQ0TfhcnnFP1oXkpnZ4IcE8fMLbLZIwm4ypIB14GvwRwWPp
2571f9ibDdVOtR8eqHaq/fBAtVPthweqPevaz5yt9Homurp1lyubKfvN5j+b
Wp3j3PdVJWevgHbA5fJR9huxdpczyP+fboyyr/y7FRNrt9sCm5sxdm0dWOMR
MgvnDTKyrFCARVImWcxaHo48aW/2Rn1bw7H3W49+0HL0w93AOlyFDr5xfX2D
ZTeIdvOYPxJlFxYjC4th/hyJ53BiXhIXSJ8sRndeza9xL5tVHPs0Vl2DbstR
Y2MSbsvhKnTwjYtL3C1E++ioZ2pmMcDMB4KzgeAcB84MZk4gyOegCOHSLNdn
yMq8EPJs3Mtmx0uLUM9j1Nmekp7H0MH3BkPzQWaBaDcOuz3+Kdd4MAG3EJjt
RffOkcsBUSfg3vGEfBzT26y7pAgputD9u8KXNxAwZFR0QYe/hXF7mHHvFNGu
0zstNv+YxQu8sPJny/ZZHJLhIx1xP+/GMdG69M0maoejQ5Tj2vFdZqvXap8k
2iEYTU7DiEM/4jAMO/TDTp3RqecCjBCc+MyvQHYY8FUjV9CPOIUwzN/LZ10e
job4NtParLukECk6UXsLR8LR+gdqaUQP20C7Hj9zxGl64SHaNVrbkNYyyGEe
1Ji5oLEMaHGAFe7SAC5o4uc4A8Jojhe4/kAejngX6W7W9fUJTrj8FpLfRE11
284bZaihBt26BuZdxSfit5h1Bqfq2RjWPqS19atHCcpnfHhm4kfurFSbxAWh
Fr+Ka8odK/k47mWznPbmBlRXhW5UJb7t1VfQtd9QQx1oJ88Z0lr/7NFh7YMa
a2+f/q+nBh5jPHD0chiFxT4uc2Ofkb8EmfSN8aYhT8fe7TGNzbqKC1FjXexq
JZG98ft2Xvv1Eqq97i4u7MW/os+gHnhxr71f0D5k7e7RPn6i+x88F50TFvNr
TG+z3Gd77fXopQrsefWXiigPHpfLy9H1GuiQe5UqU31jd1y7rbPreVe3jpIu
3lNFSCZbuHhxubxsN7COamXe0kJcfqTQ9f09WlXdLmgftHfcH3r4QEtJF9Pp
L9DNWlQLyJIgk6Gb9cPffIXLDzq0T3pMlyubsXa12iJvUrY2qyjpcqO+bbT4
S9/pk57Sot34ThWZSougg8std/ofdeqo9gOGaqfaDw8J2gcGLc1y5d1WFWVf
aW3pV3Rtaw8yS17fnNc3S9lvQqEw0U45YED7f8xreQ8=
   "], {{0, 0}, {125, 57}}, {0, 255}],
  ImageSize->{125 0.75, 57 0.75},
  PlotRange->{{0, 125}, {0, 57}}]], "NotebookImage",
 CellID->524510670]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["res"], "Input",
 CellLabel->"In[2]:=",
 CellID->20250299],

Cell[BoxData["123"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->321754606]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->65426314],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DialogReturn",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DialogReturn"], "[", "]"}]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->382269922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{"DialogInput", "[", 
    RowBox[{"Button", "[", 
     RowBox[{"\"\<text\>\"", ",", 
      RowBox[{"DialogReturn", "[", "]"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->414518405],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztmdtTE1ccx5np/9D3PvhHdKZPbR86nWmd6Vgf2pkKTgGtYzt2+tBORx8c
wFZqRwSDKFCJgIIoEipSbEgEEnOBILkn5ALJhvslCSxCCT397Z7NYQmJbmgg
iZydDzvf39nvLp7PLHkw75z87rOTbxUUFLwLP+fhh8slJRcoWWEztkU5SIj2
e21PKQdDgvas/9EdBpJqn/AHkzI5wUyFZhbml8LhaDS6urLyGtZfrqci3mFX
V1mWXVtdYUPMTKrf+4ZBPs8lavd6/Exg4ufajiPHywre+yEjvP3JhTOVLZHI
YjSyknUhuand7XQVlzd9fK5aoRzUahwZQa3VfPTt1dOX7ywvR7IuJDe1O212
eDlVzw2Zco7pUSrhsfNzi1kXkqvabfCxgBAaGfZnEHggPHZmei7rQnJcu3mM
ySBY+/TUbNaF5Lh2u2M6g1DtErW73NMZhGrfg/YC/hBn8Siu7e5T7Wlp9/kX
MCDw1RmHhDEBql2i9mAojAGNSbOY13aodonaZ+dZDGgUZ/GRqkMygWqXqD0c
iWFA46szDgljAlS7RO2r7BaGvNupRnFzdwFDtUvUvvZyCwMCSZZC0j7VLlH7
emwLAxpJlkLSPtUuUftWRg+qPYvap6j2FH2H1bJ/2kMh+u1S8j687UeOl6lM
HpTRQ2Uah8dOTjJZF5Kz2n+safv8vFw96s2Uc5t/Bh74U027zzuRdSG5qd1l
d/rHHWA+s9+lllQ0TfhcnnFP1oXkpnZ4IcE8fMLbLZIwm4ypIB14GvwRwWPp
2571f9ibDdVOtR8eqHaq/fBAtVPthweqPevaz5yt9Homurp1lyubKfvN5j+b
Wp3j3PdVJWevgHbA5fJR9huxdpczyP+fboyyr/y7FRNrt9sCm5sxdm0dWOMR
MgvnDTKyrFCARVImWcxaHo48aW/2Rn1bw7H3W49+0HL0w93AOlyFDr5xfX2D
ZTeIdvOYPxJlFxYjC4th/hyJ53BiXhIXSJ8sRndeza9xL5tVHPs0Vl2DbstR
Y2MSbsvhKnTwjYtL3C1E++ioZ2pmMcDMB4KzgeAcB84MZk4gyOegCOHSLNdn
yMq8EPJs3Mtmx0uLUM9j1Nmekp7H0MH3BkPzQWaBaDcOuz3+Kdd4MAG3EJjt
RffOkcsBUSfg3vGEfBzT26y7pAgputD9u8KXNxAwZFR0QYe/hXF7mHHvFNGu
0zstNv+YxQu8sPJny/ZZHJLhIx1xP+/GMdG69M0maoejQ5Tj2vFdZqvXap8k
2iEYTU7DiEM/4jAMO/TDTp3RqecCjBCc+MyvQHYY8FUjV9CPOIUwzN/LZ10e
job4NtParLukECk6UXsLR8LR+gdqaUQP20C7Hj9zxGl64SHaNVrbkNYyyGEe
1Ji5oLEMaHGAFe7SAC5o4uc4A8Jojhe4/kAejngX6W7W9fUJTrj8FpLfRE11
284bZaihBt26BuZdxSfit5h1Bqfq2RjWPqS19atHCcpnfHhm4kfurFSbxAWh
Fr+Ka8odK/k47mWznPbmBlRXhW5UJb7t1VfQtd9QQx1oJ88Z0lr/7NFh7YMa
a2+f/q+nBh5jPHD0chiFxT4uc2Ofkb8EmfSN8aYhT8fe7TGNzbqKC1FjXexq
JZG98ft2Xvv1Eqq97i4u7MW/os+gHnhxr71f0D5k7e7RPn6i+x88F50TFvNr
TG+z3Gd77fXopQrsefWXiigPHpfLy9H1GuiQe5UqU31jd1y7rbPreVe3jpIu
3lNFSCZbuHhxubxsN7COamXe0kJcfqTQ9f09WlXdLmgftHfcH3r4QEtJF9Pp
L9DNWlQLyJIgk6Gb9cPffIXLDzq0T3pMlyubsXa12iJvUrY2qyjpcqO+bbT4
S9/pk57Sot34ThWZSougg8std/ofdeqo9gOGaqfaDw8J2gcGLc1y5d1WFWVf
aW3pV3Rtaw8yS17fnNc3S9lvQqEw0U45YED7f8xreQ8=
   "], {{0, 0}, {125, 57}}, {0, 255}],
  ImageSize->{125 0.75, 57 0.75},
  PlotRange->{{0, 125}, {0, 57}}]], "NotebookImage",
 CellID->94404623]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"res", "//", "FullForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->774605689],

Cell[BoxData[
 TagBox[
  StyleBox["Null",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->70372724]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->79015024],

Cell["Create a dialog input window that returns a user input:", "ExampleText",
 CellID->19666913],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{"DialogInput", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"name", "=", "\"\<\>\""}], "}"}], ",", 
     RowBox[{"DialogNotebook", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"TextCell", "[", "\"\<Type a name\>\"", "]"}], ",", 
        RowBox[{"InputField", "[", 
         RowBox[{
          RowBox[{"Dynamic", "[", "name", "]"}], ",", "String"}], "]"}], ",", 
        
        RowBox[{"Button", "[", 
         RowBox[{"\"\<Proceed\>\"", ",", 
          RowBox[{"DialogReturn", "[", "name", "]"}]}], "]"}]}], "}"}], 
      "]"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->482517212],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3N1TG9cZx3F1+j/0rhe9yH/Rq7YXnc60memkuWhnGuMpOG4myaTTi2Y6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   "], {{0, 0}, {285, 121}}, {0, 255}],
  ImageSize->{285 0.75, 121 0.75},
  PlotRange->{{0, 285}, {0, 121}}]], "NotebookImage",
 CellID->103960546]
}, Open  ]],

Cell["\<\
Enter a string in the field and click \"Proceed\" to return the string:\
\>", "ExampleText",
 CellID->270420005],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3N1TG9cZx3F1+j/0rhe9yH/Rq7YXnc60memkuWhnGuMpOG4m7aTTi2Y6
zUXGdlrTdOIYg+3YNCZAAiFxwDVxSTGYF1m8CfMugQQYCcyrDRgRXKDbIx1p
WXYlgVZH0rr9PvOx5pyzz65kzfnNSiTmOyd/+9OT33S5XG+KP9/+hssVHZeU
vAVAud29fQCq6LH6pO4rANkzxargN03geZc0VrMzoaQezoYX5hdXVx6vr29u
bm49fWrfztc79iSuENnaikQi21tPI/PhxVQvGMi/ksT3qWPGKhiYCc/N/rGi
4YWXz7i++/vC+taP33qttGZjY21z42nB30lAl2msJn3+4rM3fvTGxabWTnf3
RGG1u7t/+Jv3Tp//6MmTjYK/k4Au01j5xsbFPaLtfm/BMyU1t7aK17OyvFbw
dxLQZR6rMfHpS9O0gf4ZJxCvRLyexUfLBX8nAZ3tWA0PhZ1AxurRwlLB30lA
ZztW4xOPnIBYwYFsx8o/+cgJiBUcKPtYuVwu01Y3rbgSlWrlyAbjiunixAoO
ZDtW0zOrktjn+ti6Yh2b+tM3pFrRESs4kO1YhebXJbHP9bF1xTo29ac/Pf0F
BWIFB7Idq6WViGT8eKavGI+axsYV0+l6g3Ul6QUFYgUHsh2r9Y09Sexz01jG
Ic1RfeXIhlQrOmIFB7Idq63IviT2uWlsfJQDWcY248qRDcYV46JArOBAtmO1
/fW+JPZ50nGOmJ6CWMGBbMdqZ29fMt5H9MXcMT0LsYID2Y7VfoFKxMo4JVZw
oOcuVqaSsVogVnCSTGM1MTriwFjNz/Ovg+EgNu5WL7x8ps0b0JxRbd4p8Xoe
PgwX/J0EdDZi9Yeyup/9qap9MFjoSGljM4vilbxZVj8dnC34OwnoMo2Vf9w3
MzUhkuWQ32VRcu7G7LQ/MBUo+DsJ6DKNlbgviGSJb1jjI9ka9vbZo19BvAxx
9xSvh7sVHCXTWAE4ErEClCNWgHLEClCOWAHKEStAOWIFKEesAOWIFaAcsQKU
I1aAcsQKUI5YAcoRK0A5YgUoR6wA5TKNVU1DEwBJYawK/RssKMoRRawoSnkR
K4pSXrmLlctSaV6GPGpss55u7El6zaRtpjFF5aFyercy7uQjY2UMlHFgfExz
NetzHf/ZKUpt5S1Wx6/sY2VdIVZUPisPscp0SxMr6nmvXMfq+F9qrM3Zx8r6
wZKi8lAOuVulCkXSb0lpflhhjRI/rKDyX875kYU+yPIb2TGfkaJyVw75Abtm
CJS9u1uqq1FU/ov/HExRyotYUZTyIlYUpbyIFUUpL7WxAiCpihWAIxErQDli
BShHrADliBWgHLEClCNWgHLEClCOWAHKEStAOWIFKEesAOWIFaAcsQKUI1aA
csQKUE5VrOQvQUq6aF0H/repvVslTVbB/45Anin/EGjKEbHC/yF7sUrz6S5p
rEzNac61Xtm4YhqYytqQ5rmA3LF9t0qTqVQJMh1NdV9L80ky1RVSDdJcE8id
PMQqzdGkF8xFrIB8UhirpLlIGqtUnyHTrFsH1vugdZDmuYDcyUWsZi3737ho
70Og8dxUKTtOJ5AHqmJlvCm4Dtfs4XBZp+nXTUmxdlobjvNcQO6o/W4FYDbz
WKX5OgNAshEraxX8bwE4Cv+rLaAcsQKUI1aAcsQKUI5YAcoRK0A5YgUoR6wA
5YgVoByxApQjVoByxli99nppMDDbeMtzvrQaQDZ2/73r9ky88bsLJa+/K2Il
+P3TALJhjJXfF9K0/f39PQC2/Wd/zxir8bG53d29yPaOsB0TH0fE4zN9GonE
G8Si3qyPjbaZMnXYNCbjzXz5Wt31l75X++L3a178gZVYF0dFjzxxZ+dZJPJM
j9Xw0MzGZmR1bWN1bT32uJEYr5vHj40Ner++uHn4KFOmzpna2cxNL/1k72KZ
9mGVVlmZxIdV4qjokSeuPY6eosdqcDCwsLg2F16ZCy3NhZaj5DgsLceFYuOQ
QfzQUrQ/rK+sxAdMmTpoamczT50q0ppvazfrU2q+LXrkuaH5lVB4VY9VX/9k
YGbBPxUymYwPwgeLk4en0fGcoWdu8tAVmDJ12jSzzTxZUqQ1NWqffqzJEgNJ
nzY1ip7YKeHJQHgquKDHytPjGxmbGRoJCg9GY48jB4/GQTLTeo+xnylTR02H
DOvH38zmWIlqMIwTsZJnDY8GR8cf6rESgz6vr3dgomdgord/oqff5+nz9UQH
YioGPvkYWxHjiV55tC/a0DPgiw/6Y+fGxh6mTB027U1s44w282TJCa3pplZf
E2Wq2r9rNZXa53UiVj3ymgM+74OAHqtu91iXe6Qzarizezg66B7pcMuBWIke
6pAN3YnHhI74dDjREO3vYMrUYVO5SzPdzP5fvRINVNUHWtVV7caVg0xVlmvX
y7QP3hfJ8he/kjhl2NPra7s3JGPV5R672z6oa70XG9zzxqbRx9Z2r7Eh3pY4
KttaD60wZeq0qZ3NHI1V9XXtygXt8gXz3eriu9r7f9WuXxGx0q/T5R79R7NH
xqqze/ROS88/v+qN6UsMou5E9cUXW6Lj6LSlL3ZIjPX+vkRnL1OmDpzeOZhm
sJn9xSe0yit775XqYXr2t4Px9l/e0SouTRafuCOfoqW3vePBJ/V347HqGr3V
7L79pScL9w2PpkWmTJ0zPY6DzRz9blVxafOdczJHW38+txkjp0/OntUulYke
/dzWNu+1yluJWI3dbLzfeMsDwCj4apFWXr769ttPzp6xEutaRXnw1AnZ/EWT
p+Vfgxcu1sdj1Tne8GnX55+5ARh5T/9cu1qhVQjlSZSXa1ev9f/6l7L5swb3
l83e86XVMlbt7SNVN1prq9sAGF2+VjdY/Ivp0ycDp4qspl8t8p4qEj2yueaj
u1/c9BArQCFiBShHrADlTLHq6Byprmr9uLYNgG21NXebGg9iFQo/Dk4vB6eX
AGRjfn5djxUAhUSs/gv4BL7S
   "], {{0, 0}, {285, 121}}, {0, 255}],
  ImageSize->{285 0.75, 121 0.75},
  PlotRange->{{0, 285}, {0, 121}}]], "NotebookImage",
 CellID->3398430],

Cell[CellGroupData[{

Cell[BoxData["res"], "Input",
 CellLabel->"In[2]:=",
 CellID->849964624],

Cell[BoxData["\<\"E Smith\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->508553961]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28859496],

Cell["\<\
This input puts up a dialog window and does not wait for a return value:\
\>", "ExampleText",
 CellID->472921728],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"name", "=", "\"\<\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{"CreateDialog", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"TextCell", "[", "\"\<Type a name\>\"", "]"}], ",", 
     RowBox[{"InputField", "[", 
      RowBox[{
       RowBox[{"Dynamic", "[", "name", "]"}], ",", "String"}], "]"}], ",", 
     RowBox[{"Button", "[", 
      RowBox[{"\"\<Proceed\>\"", ",", 
       RowBox[{"DialogReturn", "[", 
        RowBox[{"res", "=", "name"}], "]"}]}], "]"}]}], "}"}], "]"}], 
  ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->303189131],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztndtPFFccxzfp/9D3Pvhf9KntQ9OkNWmsD21SwRTQGtvYtEmbpj4YL63U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   "], {{0, 0}, {194, 117}}, {0, 255}],
  ImageSize->{194 0.75, 117 0.75},
  PlotRange->{{0, 194}, {0, 117}}]], "NotebookImage",
 CellID->148838028]
}, Open  ]],

Cell[TextData[{
 "Typing in the dialog window dynamically changes ",
 Cell[BoxData["name"], "InlineFormula"],
 " but has no immediate effect on ",
 Cell[BoxData["res"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->25916621],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztndtTE1ccxzPT/6HvffC/6FPbh05nWmc61od2popTUOvYjp12pp1OfXC8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   "], {{0, 0}, {194, 117}}, {0, 255}],
  ImageSize->{194 0.75, 117 0.75},
  PlotRange->{{0, 194}, {0, 117}}]], "NotebookImage",
 CellID->129633480],

Cell["\<\
The kernel evaluate other inputs while the dialog window is open:\
\>", "ExampleText",
 CellID->127353683],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"res", ",", "name"}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->338880489],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"res", ",", "\<\"E Smith\"\>"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->195873371]
}, Open  ]],

Cell[TextData[{
 "After the \"Proceed\" button is clicked, the effect of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DialogReturn",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DialogReturn"], "[", 
   RowBox[{"res", "=", "name"}], 
   StyleBox["]", "TI"]}]], "InlineFormula"],
 " can be seen:"
}], "ExampleText",
 CellID->64721871],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"res", ",", "name"}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->558129723],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"E Smith\"\>", ",", "\<\"E Smith\"\>"}], "}"}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->710813402]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->716627469],

Cell["Return different values, depending which button is clicked:", \
"ExampleText",
 CellID->248467481],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{"DialogInput", "[", 
    RowBox[{"DialogNotebook", "[", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"Row", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"DefaultButton", "[", 
          RowBox[{"DialogReturn", "[", "True", "]"}], "]"}], ",", 
         RowBox[{"CancelButton", "[", 
          RowBox[{"DialogReturn", "[", "False", "]"}], "]"}]}], "}"}], "]"}], 
      "\[IndentingNewLine]", "}"}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13124466],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztmVtPG0cUgJH6H/rehyi/oVKf2j5UlWikKs1DKzUQFQiJ0ipVH1pVyUMU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   "], {{0, 0}, {125, 57}}, {0, 255}],
  ImageSize->{125 0.75, 57 0.75},
  PlotRange->{{0, 125}, {0, 57}}]], "NotebookImage",
 CellID->170486274]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->385259461],

Cell[TextData[{
 "This uses ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DialogReturn",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DialogReturn"], "[", "]"}]], "InlineFormula"],
 " to return from the dialog notebook:"
}], "ExampleText",
 CellID->364029511],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DialogInput", "[", 
  RowBox[{"DialogNotebook", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"TextCell", "[", "\"\<Click to proceed\>\"", "]"}], ",", 
     RowBox[{"Button", "[", 
      RowBox[{"\"\<OK\>\"", ",", 
       RowBox[{"DialogReturn", "[", "]"}]}], "]"}]}], "}"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->621833756],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnN1PU2cYwEl2v3i1+10Y/4ldbbtlJosxy5ZMMANkxixbdrFl0QsjOmWa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   "], {{0, 0}, {125, 88}}, {0, 255}],
  ImageSize->{125 0.75, 88 0.75},
  PlotRange->{{0, 125}, {0, 88}}]], "NotebookImage",
 CellID->537354237]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->111046164],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DefaultButton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DefaultButton"], "[", "]"}]], "InlineFormula"],
 " can be used instead of an explicit ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DialogReturn",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DialogReturn"], "[", "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->248069216],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DialogInput", "[", 
  RowBox[{"DialogNotebook", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"TextCell", "[", "\"\<Click to proceed\>\"", "]"}], ",", 
     RowBox[{"DefaultButton", "[", "]"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->126551530],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnN1PU2cYwEl2v3i1+10Y/4ldbbtlJosxy5ZMMANkxixbdrFl0QsjOmWa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   "], {{0, 0}, {125, 88}}, {0, 255}],
  ImageSize->{125 0.75, 88 0.75},
  PlotRange->{{0, 125}, {0, 88}}]], "NotebookImage",
 CellID->906803923]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->226616514],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CancelButton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CancelButton"], "[", "]"}]], "InlineFormula"],
 " implicitly uses ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DialogReturn",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DialogReturn"], "[", "$Canceled", "]"}]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->577289620],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{"DialogInput", "[", 
    RowBox[{"DialogNotebook", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"TextCell", "[", "\"\<Click to proceed\>\"", "]"}], ",", 
       RowBox[{"CancelButton", "[", "]"}]}], "}"}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->465056428],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnNtP21YYwJH2P+x9D/0v9rTtYZq0VZq6PmzSCtWAdVU3ddrDpql9qEq7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   "], {{0, 0}, {125, 84}}, {0, 255}],
  ImageSize->{125 0.75, 84 0.75},
  PlotRange->{{0, 125}, {0, 84}}]], "NotebookImage",
 CellID->246273586]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["res"], "Input",
 CellLabel->"In[2]:=",
 CellID->86276198],

Cell[BoxData["$Canceled"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->111923134]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DialogInput",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DialogInput"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DefaultButton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DefaultButton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CancelButton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CancelButton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Exit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exit"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->859173987],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "MoreAbout",
 CellID->538727231],

Cell[TextData[ButtonBox["Dialog Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DialogBoxes"]], "MoreAbout",
 CellID->460561470]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DialogReturn - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 5.0858936}", "context" -> "System`", 
    "keywords" -> {
     "return control from dialog", "return from dialog", 
      "dialog control flow", "modal return", "ok button", "cancel button", 
      "default button"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "DialogReturn[expr] closes a dialog window, returning the expression expr \
from the dialog. DialogReturn[] closes a dialog window, returning Null.", 
    "synonyms" -> {"dialog return"}, "title" -> "DialogReturn", "type" -> 
    "Symbol", "uri" -> "ref/DialogReturn"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6560, 205, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->33295630]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 47510, 1224}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1633, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2256, 64, 1577, 37, 70, "ObjectNameGrid"],
Cell[3836, 103, 1016, 32, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4889, 140, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5367, 157, 642, 23, 70, "Notes",
 CellID->1067943069],
Cell[6012, 182, 511, 18, 70, "Notes",
 CellID->11478]
}, Closed]],
Cell[CellGroupData[{
Cell[6560, 205, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->33295630],
Cell[CellGroupData[{
Cell[6944, 219, 148, 5, 70, "ExampleSection",
 CellID->201057691],
Cell[7095, 226, 166, 5, 70, "ExampleText",
 CellID->37432141],
Cell[CellGroupData[{
Cell[7286, 235, 270, 9, 70, "Input",
 CellID->31958333],
Cell[7559, 246, 2198, 38, 70, "NotebookImage",
 CellID->524510670]
}, Open  ]],
Cell[CellGroupData[{
Cell[9794, 289, 71, 2, 28, "Input",
 CellID->20250299],
Cell[9868, 293, 160, 5, 36, "Output",
 CellID->321754606]
}, Open  ]],
Cell[10043, 301, 124, 3, 70, "ExampleDelimiter",
 CellID->65426314],
Cell[10170, 306, 337, 13, 70, "ExampleText",
 CellID->382269922],
Cell[CellGroupData[{
Cell[10532, 323, 261, 8, 70, "Input",
 CellID->414518405],
Cell[10796, 333, 2197, 38, 70, "NotebookImage",
 CellID->94404623]
}, Open  ]],
Cell[CellGroupData[{
Cell[13030, 376, 102, 3, 70, "Input",
 CellID->774605689],
Cell[13135, 381, 291, 11, 50, "Output",
 CellID->70372724]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13475, 398, 219, 7, 70, "ExampleSection",
 CellID->79015024],
Cell[13697, 407, 97, 1, 70, "ExampleText",
 CellID->19666913],
Cell[CellGroupData[{
Cell[13819, 412, 679, 20, 70, "Input",
 CellID->482517212],
Cell[14501, 434, 3072, 53, 70, "NotebookImage",
 CellID->103960546]
}, Open  ]],
Cell[17588, 490, 122, 3, 70, "ExampleText",
 CellID->270420005],
Cell[17713, 495, 3216, 55, 70, "NotebookImage",
 CellID->3398430],
Cell[CellGroupData[{
Cell[20954, 554, 72, 2, 70, "Input",
 CellID->849964624],
Cell[21029, 558, 172, 5, 36, "Output",
 CellID->508553961]
}, Open  ]],
Cell[21216, 566, 124, 3, 70, "ExampleDelimiter",
 CellID->28859496],
Cell[21343, 571, 123, 3, 70, "ExampleText",
 CellID->472921728],
Cell[CellGroupData[{
Cell[21491, 578, 576, 17, 70, "Input",
 CellID->303189131],
Cell[22070, 597, 2872, 49, 70, "NotebookImage",
 CellID->148838028]
}, Open  ]],
Cell[24957, 649, 229, 7, 70, "ExampleText",
 CellID->25916621],
Cell[25189, 658, 2962, 51, 70, "NotebookImage",
 CellID->129633480],
Cell[28154, 711, 116, 3, 70, "ExampleText",
 CellID->127353683],
Cell[CellGroupData[{
Cell[28295, 718, 120, 4, 70, "Input",
 CellID->338880489],
Cell[28418, 724, 220, 7, 36, "Output",
 CellID->195873371]
}, Open  ]],
Cell[28653, 734, 337, 11, 70, "ExampleText",
 CellID->64721871],
Cell[CellGroupData[{
Cell[29015, 749, 120, 4, 70, "Input",
 CellID->558129723],
Cell[29138, 755, 232, 7, 36, "Output",
 CellID->710813402]
}, Open  ]],
Cell[29385, 765, 125, 3, 70, "ExampleDelimiter",
 CellID->716627469],
Cell[29513, 770, 104, 2, 70, "ExampleText",
 CellID->248467481],
Cell[CellGroupData[{
Cell[29642, 776, 557, 15, 70, "Input",
 CellID->13124466],
Cell[30202, 793, 2593, 45, 70, "NotebookImage",
 CellID->170486274]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[32844, 844, 237, 7, 70, "ExampleSection",
 CellID->385259461],
Cell[33084, 853, 262, 9, 70, "ExampleText",
 CellID->364029511],
Cell[CellGroupData[{
Cell[33371, 866, 372, 11, 70, "Input",
 CellID->621833756],
Cell[33746, 879, 2938, 50, 70, "NotebookImage",
 CellID->537354237]
}, Open  ]],
Cell[36699, 932, 125, 3, 70, "ExampleDelimiter",
 CellID->111046164],
Cell[36827, 937, 408, 14, 70, "ExampleText",
 CellID->248069216],
Cell[CellGroupData[{
Cell[37260, 955, 296, 8, 70, "Input",
 CellID->126551530],
Cell[37559, 965, 2938, 50, 70, "NotebookImage",
 CellID->906803923]
}, Open  ]],
Cell[40512, 1018, 125, 3, 70, "ExampleDelimiter",
 CellID->226616514],
Cell[40640, 1023, 403, 15, 70, "ExampleText",
 CellID->577289620],
Cell[CellGroupData[{
Cell[41068, 1042, 352, 11, 70, "Input",
 CellID->465056428],
Cell[41423, 1055, 2503, 43, 70, "NotebookImage",
 CellID->246273586]
}, Open  ]],
Cell[CellGroupData[{
Cell[43963, 1103, 71, 2, 70, "Input",
 CellID->86276198],
Cell[44037, 1107, 166, 5, 36, "Output",
 CellID->111923134]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[44264, 1119, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[44583, 1130, 961, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[45581, 1170, 319, 9, 70, "MoreAboutSection",
 CellID->859173987],
Cell[45903, 1181, 168, 3, 70, "MoreAbout",
 CellID->538727231],
Cell[46074, 1186, 135, 3, 70, "MoreAbout",
 CellID->460561470]
}, Open  ]],
Cell[46224, 1192, 27, 0, 70, "History"],
Cell[46254, 1194, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

