(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12228,        470]
NotebookOptionsPosition[      8984,        360]
NotebookOutlinePosition[     10349,        399]
CellTagsIndexPosition[     10264,        394]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dialogs" :> 
          Documentation`HelpLookup["paclet:tutorial/Dialogs"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Dialogs\"\>"}, "\<\"tutorials\"\>", 
       
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dialog" :> Documentation`HelpLookup["paclet:ref/Dialog"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Dialog\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DialogSymbols", "ObjectName",
 CellID->21891],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["DialogSymbols",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DialogSymbols"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Dialog",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Dialog"]], "InlineFormula"],
     " which gives a list of symbols whose values should be localized in the \
dialog. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15323]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"DialogSymbols", ":>", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " specifies that ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
 " should have local values for the duration of the dialog. "
}], "Notes",
 CellID->29246],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"DialogSymbols", ":>", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      StyleBox["x", "TI"], "=", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["0", "TR"]]}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " defines initial values for variables. "
}], "Notes",
 CellID->19778],

Cell[TextData[{
 "In addition to any symbols you specify, ",
 Cell[BoxData[
  ButtonBox["Dialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dialog"]], "InlineFormula"],
 " always uses local values for ",
 Cell[BoxData[
  ButtonBox["$Epilog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Epilog"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["$Line",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Line"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["$MessageList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MessageList"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21089],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["DialogSymbols",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DialogSymbols"]], "InlineFormula"],
 " option sets up local values in a dialog in the same way that a ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 " enclosing the dialog would. "
}], "Notes",
 CellID->3698]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->84983016],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->518084071],

Cell[TextData[{
 "Start a dialog with ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " localized:"
}], "ExampleText",
 CellID->432581319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dialog", "[", 
  RowBox[{"DialogSymbols", "\[RuleDelayed]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "=", "1."}], ",", 
     RowBox[{"a", "=", " ", 
      RowBox[{"1", "/", "2"}]}], ",", 
     RowBox[{"b", "=", "1"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->209086582],

Cell[BoxData["1.4142156862745097`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->516764857]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{
   RowBox[{"a", "*", "x"}], "+", 
   RowBox[{"b", "/", "x"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->294326831],

Cell[BoxData["1.5`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"(Dialog) Out[2]=",
 CellID->682254005]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{
   RowBox[{"a", "*", "x"}], "+", 
   RowBox[{"b", "/", "x"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->367437499],

Cell[BoxData["1.4166666666666665`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"(Dialog) Out[3]=",
 CellID->469564037]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Return", "[", 
  RowBox[{
   RowBox[{"a", "*", "x"}], "+", 
   RowBox[{"b", "/", "x"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->248289652],

Cell[TextData[{
 "The values ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " are not defined outside the dialog since they were localized:"
}], "ExampleText",
 CellID->244367360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "a", ",", "b"}], "}"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->80464791],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "a", ",", "b"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->30393208]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16703],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Dialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dialog"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->32757]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3616],

Cell[TextData[ButtonBox["Dialogs",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Dialogs"]], "Tutorials",
 CellID->28900]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DialogSymbols - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 5.7734112}", "context" -> "System`", 
    "keywords" -> {
     "local variables", "local variables in dialogs", 
      "block variables in dialogs"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "DialogSymbols is an option for Dialog which gives a list of symbols \
whose values should be localized in the dialog. ", 
    "synonyms" -> {"dialog symbols"}, "title" -> "DialogSymbols", "type" -> 
    "Symbol", "uri" -> "ref/DialogSymbols"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4886, 180, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->84983016]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10122, 387}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1106, 30, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1729, 57, 51, 1, 70, "ObjectName",
 CellID->21891],
Cell[1783, 60, 631, 19, 70, "Usage",
 CellID->15323]
}, Open  ]],
Cell[CellGroupData[{
Cell[2451, 84, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2929, 101, 531, 19, 70, "Notes",
 CellID->29246],
Cell[3463, 122, 365, 13, 70, "Notes",
 CellID->19778],
Cell[3831, 137, 619, 23, 70, "Notes",
 CellID->21089],
Cell[4453, 162, 396, 13, 70, "Notes",
 CellID->3698]
}, Closed]],
Cell[CellGroupData[{
Cell[4886, 180, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->84983016],
Cell[CellGroupData[{
Cell[5270, 194, 148, 5, 70, "ExampleSection",
 CellID->518084071],
Cell[5421, 201, 282, 12, 70, "ExampleText",
 CellID->432581319],
Cell[CellGroupData[{
Cell[5728, 217, 320, 10, 28, "Input",
 CellID->209086582],
Cell[6051, 229, 176, 5, 36, "Output",
 CellID->516764857]
}, Open  ]],
Cell[CellGroupData[{
Cell[6264, 239, 163, 6, 28, "Input",
 CellID->294326831],
Cell[6430, 247, 170, 5, 50, "Output",
 CellID->682254005]
}, Open  ]],
Cell[CellGroupData[{
Cell[6637, 257, 163, 6, 28, "Input",
 CellID->367437499],
Cell[6803, 265, 185, 5, 50, "Output",
 CellID->469564037]
}, Open  ]],
Cell[7003, 273, 173, 6, 70, "Input",
 CellID->248289652],
Cell[7179, 281, 324, 12, 70, "ExampleText",
 CellID->244367360],
Cell[CellGroupData[{
Cell[7528, 297, 124, 4, 70, "Input",
 CellID->80464791],
Cell[7655, 303, 212, 7, 36, "Output",
 CellID->30393208]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7928, 317, 311, 9, 70, "SeeAlsoSection",
 CellID->16703],
Cell[8242, 328, 192, 6, 70, "SeeAlso",
 CellID->32757]
}, Open  ]],
Cell[CellGroupData[{
Cell[8471, 339, 313, 9, 70, "TutorialsSection",
 CellID->3616],
Cell[8787, 350, 125, 3, 70, "Tutorials",
 CellID->28900]
}, Open  ]],
Cell[8927, 356, 27, 0, 70, "History"],
Cell[8957, 358, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

