(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33343,       1105]
NotebookOptionsPosition[     26633,        874]
NotebookOutlinePosition[     27969,        912]
CellTagsIndexPosition[     27884,        907]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"WordData" :> Documentation`HelpLookup["paclet:ref/WordData"], 
          "StringCases" :> Documentation`HelpLookup["paclet:ref/StringCases"],
           "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"WordData\"\>", 
       2->"\<\"StringCases\"\>", 
       3->"\<\"StringExpression\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integrated Data Sources" :> 
          Documentation`HelpLookup["paclet:guide/DataCollections"], 
          "Processing Textual Data" :> 
          Documentation`HelpLookup["paclet:guide/ProcessingTextualData"], 
          "String Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/StringManipulation"], 
          "New in 6.0: Core Language" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60CoreLanguage"], 
          "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Integrated Data Sources\"\>", 
       2->"\<\"Processing Textual Data\"\>", 3->"\<\"String Manipulation\"\>",
        4->"\<\"New in 6.0: Core Language\"\>", 
       5->"\<\"New in 6.0: Data Handling & Data Sources\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["DictionaryLookup", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DictionaryLookup",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DictionaryLookup"], "[", 
       StyleBox["patt", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]finds all words in an English dictionary that match \
the string pattern ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DictionaryLookup",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DictionaryLookup"], "[", 
       RowBox[{
        StyleBox["patt", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives only the first ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " words found."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
No word stemming is done by default, so words like \
\[OpenCurlyDoubleQuote]jump\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]jumps\[CloseCurlyDoubleQuote] and \"jumping\" appear \
separately.\
\>", "Notes",
 CellID->1067943069],

Cell[TextData[{
 "By default, words appear as they would within a sentence. Setting the \
option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IgnoreCase",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IgnoreCase"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " retrieves words whose letters appear in different cases. "
}], "Notes",
 CellID->27102957],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DictionaryLookup",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DictionaryLookup"], "[", "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " gives a list of all words in the dictionary."
}], "Notes",
 CellID->748969]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->142715134],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->9847487],

Cell["\<\
Look up all words beginning with \[OpenCurlyDoubleQuote]abb\
\[CloseCurlyDoubleQuote]:\
\>", "ExampleText",
 CellID->756620383],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DictionaryLookup", "[", 
  RowBox[{"\"\<abb\>\"", "~~", "___"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->281677552],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"abbe\"\>", ",", "\<\"abb\[EAcute]\"\>", ",", "\<\"abbes\"\>", 
   ",", "\<\"abb\[EAcute]s\"\>", ",", "\<\"abbess\"\>", 
   ",", "\<\"abbesses\"\>", ",", "\<\"abbey\"\>", ",", "\<\"abbeys\"\>", 
   ",", "\<\"abbot\"\>", ",", "\<\"abbots\"\>", ",", "\<\"abbrev\"\>", 
   ",", "\<\"abbreviate\"\>", ",", "\<\"abbreviated\"\>", 
   ",", "\<\"abbreviates\"\>", ",", "\<\"abbreviating\"\>", 
   ",", "\<\"abbreviation\"\>", ",", "\<\"abbreviations\"\>", 
   ",", "\<\"abbrevs\"\>"}], "}"}]], "Output",
 ImageSize->{448, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23244926]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Variants such as \"jumps\" and \"jumping\" appear separately:", \
"ExampleText",
 CellID->324218126],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DictionaryLookup", "[", 
  RowBox[{"\"\<jump\>\"", "~~", "___"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70492267],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"jump\"\>", ",", "\<\"jumped\"\>", ",", "\<\"jumper\"\>", 
   ",", "\<\"jumpers\"\>", ",", "\<\"jumpier\"\>", ",", "\<\"jumpiest\"\>", 
   ",", "\<\"jumpily\"\>", ",", "\<\"jumpiness\"\>", ",", "\<\"jumping\"\>", 
   ",", "\<\"jumps\"\>", ",", "\<\"jumpsuit\"\>", ",", "\<\"jumpsuits\"\>", 
   ",", "\<\"jumpy\"\>"}], "}"}]], "Output",
 ImageSize->{436, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->100595170]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->784591946],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DictionaryLookup",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DictionaryLookup"]], "InlineFormula"],
 " supports in-string patterns:"
}], "ExampleText",
 CellID->360175090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DictionaryLookup", "[", "\"\<jump*\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28322199],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"jump\"\>", ",", "\<\"jumped\"\>", ",", "\<\"jumper\"\>", 
   ",", "\<\"jumpers\"\>", ",", "\<\"jumpier\"\>", ",", "\<\"jumpiest\"\>", 
   ",", "\<\"jumpily\"\>", ",", "\<\"jumpiness\"\>", ",", "\<\"jumping\"\>", 
   ",", "\<\"jumps\"\>", ",", "\<\"jumpsuit\"\>", ",", "\<\"jumpsuits\"\>", 
   ",", "\<\"jumpy\"\>"}], "}"}]], "Output",
 ImageSize->{436, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->95791957]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->552034402],

Cell["The first 10 words beginning with \"z\":", "ExampleText",
 CellID->83170880],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DictionaryLookup", "[", 
  RowBox[{
   RowBox[{"\"\<z\>\"", "~~", "___"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->317527658],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"zanied\"\>", ",", "\<\"zanier\"\>", ",", "\<\"zanies\"\>", 
   ",", "\<\"zaniest\"\>", ",", "\<\"zaniness\"\>", ",", "\<\"zany\"\>", 
   ",", "\<\"zanying\"\>", ",", "\<\"zap\"\>", ",", "\<\"zapped\"\>", 
   ",", "\<\"zapper\"\>"}], "}"}]], "Output",
 ImageSize->{532, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->91800913]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["\<\
Find the number of words in the dictionary starting with each letter:\
\>", "ExampleText",
 CellID->165474145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Length", "[", 
    RowBox[{"DictionaryLookup", "[", 
     RowBox[{"#", "~~", "___"}], "]"}], "]"}], "&"}], "/@", 
  RowBox[{"CharacterRange", "[", 
   RowBox[{"\"\<a\>\"", ",", "\"\<z\>\""}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->716962109],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4499", ",", "4746", ",", "7847", ",", "5218", ",", "3253", ",", "3484", 
   ",", "2651", ",", "2952", ",", "3357", ",", "715", ",", "589", ",", "2403",
    ",", "4208", ",", "1720", ",", "2109", ",", "6547", ",", "410", ",", 
   "5144", ",", "9615", ",", "4168", ",", "2559", ",", "1211", ",", "2223", 
   ",", "25", ",", "248", ",", "148"}], "}"}]], "Output",
 ImageSize->{503, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->470277401]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->464233066],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW8tPE0EYX7ot0gs18vYiF/XgSfBqPCgaTTwJePDUEBNI5BHkb/DtH4Av
jIp/ACJefRzER/QoHjiIBw5oIgJBbbDOzszuN/t1lu5uZ9pd2ybd6bcz8z1+
3zff7MxOT2cnBs8PZyeGBrKdJ8azY4NDAxc7j4+Ok1tmnWEYs+Q71m6Q33ny
i35n83lSiteD5GqSqg5eJkiZIGUbp40kbcY/LYRICq1s2t2qgRKHrKvFIk8/
lKORBJpxEVu0INpEdJN1STHauRZwaRJoRzWhPqVJu+aiHJqLcNClmVgvQwz3
x/VMr6488/luf/pAC96vPagWTiR1oZoOfxqkRA0sia1WWS/2k/feVZT/Dnq7
W7DMKs08jJ0Ejzx7lIj1raiecSscm21I6i3pXebttbXfLu9tbf3dWP8D9Ra9
IdC53NbmZg5oQpBbQJPGpItAr7tpkFdt8hn/6UcfjxyevHnjFc8vMvlMHqXp
2J8iTquT+jBh68Rj0tHh69IPoFdXfy0v/7TpxLeVDSe3kSpoRzq5bCX1Ltt8
yHXRXnLJTdVyt7GX9ieygfYvn8l7M79Ebj2bW+D1Dx98ILTlQ0b39z4mPu05
eof7zNNLi4vfg3upmLaEqQutzwsrVSKXZnnzbJ+Nvml7a3TkieWtmjdALolZ
nnf0egPQb3DQt+ew6KJ+7+47AR11cnFsqre3KYYx3ndmWkBFnVyIvWpG+/7U
e9dIJ6iMDDuoqJDbUMXowohO19AsGU0YsfFBM0qzWSY2qEUxBiuNnrgivHrl
BV8R1tALgh7k4xp6wdGjzwYzVv6toRdE/7QnWrXZwQ9KcYqpYlm6hlaQrKwX
LfEdk4nKVCyR9M7QepE06lkhXsW3GfhNjOzNjJyOLuIYCb0IU6083xb5xdd0
7kcXV4Yby6DXr73kkawLVzMAiv9D1OJdcFXoYq81VzG6sE+hFl3wGkO32Fvm
uCNsmLcn37p2J4F/RimysOvJkTU5XJIngzg8IeBdcx3I7aEQRXEVU7i3X7r1
7D7Lb5cvPTc6HevLEQPiqkI2J2K5LUqthrxTCau95yq9VkMMVcJqHMFwEgSP
NFVW7yurlfK38Tqt0pmlhFlkBnwWdR/hnJZEVjXGyAqcJbAVcKIhylawCJp7
+snDCjg7FE0r0kJEWbtfGcEqa1xEa1SnUeTsjzCmMB+o1RLtK+T1Put269S9
gqsftXbRs+7suC5e3sXUogKNA65cbUtK2b9SYZG4It3LLePqlmiZCp+xE+ww
n+8MZSGsHKNqIWTscBbOv/7CV/vMwvLmQGYD5POgNhygOstnl+DnNntCS4eZ
N/i5xfBSC23GKyV8ok2XdNYLnsjKIQ3bqktao5ZoyQTi6u1H/zqL+fqYVIq3
/4JI6e+1c6ZcirffgkgBLlgKbu+P6ynfXGTe89+7dB3EOQjnZa/8HFKShj31
ympikXHHwnnuU/DsUVoEOhwrpol9YsHvyQW1o/4kpWE3Etf7G/WMCzw3lMIF
smI4LucU95KhplpG9HtFE4Xw8wj858eDs7ZcCaNEr2SYJ2BEFUdRVS68UDZU
Ky4pRAzKOdnjbNiz1h+P8reKu9aQDbbjAWuL7VrBaJO3Yv/HN+r+AefpqMg=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->57173162]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->394830759],

Cell["Find all palindromes in the dictionary:", "ExampleText",
 CellID->100188410],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DictionaryLookup", "[", 
  RowBox[{"x__", "/;", 
   RowBox[{"x", "===", 
    RowBox[{"StringReverse", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->399438762],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"aha\"\>", ",", "\<\"aka\"\>", 
   ",", "\<\"bib\"\>", ",", "\<\"bob\"\>", ",", "\<\"boob\"\>", 
   ",", "\<\"bub\"\>", ",", "\<\"CFC\"\>", ",", "\<\"civic\"\>", 
   ",", "\<\"dad\"\>", ",", "\<\"dd\"\>", ",", "\<\"deed\"\>", 
   ",", "\<\"deified\"\>", ",", "\<\"did\"\>", ",", "\<\"dud\"\>", 
   ",", "\<\"DVD\"\>", ",", "\<\"eke\"\>", ",", "\<\"ere\"\>", 
   ",", "\<\"eve\"\>", ",", "\<\"ewe\"\>", ",", "\<\"eye\"\>", 
   ",", "\<\"gag\"\>", ",", "\<\"gig\"\>", ",", "\<\"huh\"\>", 
   ",", "\<\"I\"\>", ",", "\<\"kayak\"\>", ",", "\<\"kook\"\>", 
   ",", "\<\"level\"\>", ",", "\<\"ma'am\"\>", ",", "\<\"madam\"\>", 
   ",", "\<\"mam\"\>", ",", "\<\"MGM\"\>", ",", "\<\"minim\"\>", 
   ",", "\<\"mom\"\>", ",", "\<\"mum\"\>", ",", "\<\"nan\"\>", 
   ",", "\<\"non\"\>", ",", "\<\"noon\"\>", ",", "\<\"nun\"\>", 
   ",", "\<\"oho\"\>", ",", "\<\"pap\"\>", ",", "\<\"peep\"\>", 
   ",", "\<\"pep\"\>", ",", "\<\"pip\"\>", ",", "\<\"poop\"\>", 
   ",", "\<\"pop\"\>", ",", "\<\"pup\"\>", ",", "\<\"radar\"\>", 
   ",", "\<\"redder\"\>", ",", "\<\"refer\"\>", ",", "\<\"repaper\"\>", 
   ",", "\<\"reviver\"\>", ",", "\<\"rotor\"\>", ",", "\<\"sagas\"\>", 
   ",", "\<\"sees\"\>", ",", "\<\"seres\"\>", ",", "\<\"sexes\"\>", 
   ",", "\<\"shahs\"\>", ",", "\<\"sis\"\>", ",", "\<\"solos\"\>", 
   ",", "\<\"SOS\"\>", ",", "\<\"stats\"\>", ",", "\<\"stets\"\>", 
   ",", "\<\"tat\"\>", ",", "\<\"tenet\"\>", ",", "\<\"TNT\"\>", 
   ",", "\<\"toot\"\>", ",", "\<\"tot\"\>", ",", "\<\"tut\"\>", 
   ",", "\<\"wow\"\>", ",", "\<\"WWW\"\>"}], "}"}]], "Output",
 ImageSize->{557, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->98020527]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->347908609],

Cell["\<\
Find how many words contain each of the possible permutations of \"a\", \"b\" \
and \"c\":\
\>", "ExampleText",
 CellID->582161658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringJoin", "/@", 
  RowBox[{"Permutations", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<a\>\"", ",", "\"\<b\>\"", ",", "\"\<c\>\""}], "}"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->317876666],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"abc\"\>", ",", "\<\"acb\"\>", ",", "\<\"bac\"\>", 
   ",", "\<\"bca\"\>", ",", "\<\"cab\"\>", ",", "\<\"cba\"\>"}], 
  "}"}]], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->189102701]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Length", "[", 
    RowBox[{"DictionaryLookup", "[", 
     RowBox[{"___", "~~", "#", "~~", "___"}], "]"}], "]"}], "&"}], "/@", 
  "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->64587067],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "291", ",", "7", ",", "121", ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->673873067]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->75560609],

Cell["Find all 4-letter words formed from a through e:", "ExampleText",
 CellID->173238798],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"StringJoin", "/@", 
    RowBox[{"Tuples", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "\"\<a\>\"", ",", "\"\<b\>\"", ",", "\"\<c\>\"", ",", "\"\<d\>\"", 
        ",", "\"\<e\>\""}], "}"}], ",", "4"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Length", "[", 
      RowBox[{"DictionaryLookup", "[", "#", "]"}], "]"}], "\[NotEqual]", 
     "0"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->260339553],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"abbe\"\>", ",", "\<\"abed\"\>", ",", "\<\"aced\"\>", 
   ",", "\<\"babe\"\>", ",", "\<\"bade\"\>", ",", "\<\"bead\"\>", 
   ",", "\<\"ceca\"\>", ",", "\<\"cede\"\>", ",", "\<\"dace\"\>", 
   ",", "\<\"dded\"\>", ",", "\<\"dead\"\>", ",", "\<\"deed\"\>"}], 
  "}"}]], "Output",
 ImageSize->{478, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->142946099]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->479357292],

Cell["Create a nearest function from all words in the dictionary:", \
"ExampleText",
 CellID->247949843],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nf", "=", 
  RowBox[{"Nearest", "[", 
   RowBox[{"DictionaryLookup", "[", "__", "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->122449866],

Cell[BoxData[
 TagBox[
  RowBox[{"NearestFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"92836", ",", "1"}], "}"}], ",", 
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", ">"],
     Editable->False]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{218, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->316627137]
}, Open  ]],

Cell["Look up words closest to a given word:", "ExampleText",
 CellID->61215524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nf", "[", "\"\<pickel\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29255790],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"nickel\"\>", ",", "\<\"picked\"\>", ",", "\<\"picker\"\>", 
   ",", "\<\"picket\"\>"}], "}"}]], "Output",
 ImageSize->{220, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->491876457]
}, Open  ]],

Cell["Go further:", "ExampleText",
 CellID->591465096],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nf", "[", 
  RowBox[{"\"\<pickel\>\"", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->267433761],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"nickel\"\>", ",", "\<\"picked\"\>", ",", "\<\"picker\"\>", 
   ",", "\<\"picket\"\>", ",", "\<\"bicker\"\>", ",", "\<\"dicker\"\>", 
   ",", "\<\"dickey\"\>", ",", "\<\"hickey\"\>", ",", "\<\"kicked\"\>", 
   ",", "\<\"kicker\"\>"}], "}"}]], "Output",
 ImageSize->{539, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->7390452]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->589267740],

Cell["Find what words might be confused with genomic sequences:", \
"ExampleText",
 CellID->507808988],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DictionaryLookup", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
     "\"\<a\>\"", "|", "\"\<g\>\"", "|", "\"\<c\>\"", "|", "\"\<t\>\""}], 
     ")"}], ".."}], ",", 
   RowBox[{"IgnoreCase", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->284413836],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"AC\"\>", ",", "\<\"act\"\>", 
   ",", "\<\"at\"\>", ",", "\<\"cat\"\>", ",", "\<\"Catt\"\>", 
   ",", "\<\"gag\"\>", ",", "\<\"gaga\"\>", ",", "\<\"ta\"\>", 
   ",", "\<\"tact\"\>", ",", "\<\"tag\"\>", ",", "\<\"tat\"\>"}], 
  "}"}]], "Output",
 ImageSize->{380, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->296349294]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->129922722],

Cell["Pick 10 random words beginning with \"a\" from the dictionary:", \
"ExampleText",
 CellID->622971423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomChoice", "[", 
  RowBox[{
   RowBox[{"DictionaryLookup", "[", 
    RowBox[{"\"\<a\>\"", "~~", "___"}], "]"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20778882],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"appliqued\"\>", ",", "\<\"alluviums\"\>", 
   ",", "\<\"appeasement\"\>", ",", "\<\"apiarists\"\>", 
   ",", "\<\"averse\"\>", ",", "\<\"ayes\"\>", ",", "\<\"ambergris\"\>", 
   ",", "\<\"aperitif\"\>", ",", "\<\"atilt\"\>", ",", "\<\"aspirates\"\>"}], 
  "}"}]], "Output",
 ImageSize->{361, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->375919537]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["WordData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WordData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringCases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringCases"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with DictionaryLookup",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
DictionaryLookup"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->446322857],

Cell[TextData[ButtonBox["Integrated Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataCollections"]], "MoreAbout",
 CellID->283089393],

Cell[TextData[ButtonBox["Processing Textual Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProcessingTextualData"]], "MoreAbout",
 CellID->381759035],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->489459881],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "MoreAbout",
 CellID->36703540],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataHandlingAndDataSources"]], "MoreAbout",
 CellID->793660]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DictionaryLookup - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 11.4454314}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "DictionaryLookup[patt] finds all words in an English dictionary that \
match the string pattern patt. DictionaryLookup[patt, n] gives only the first \
n words found.", "synonyms" -> {"dictionary lookup"}, "title" -> 
    "DictionaryLookup", "type" -> "Symbol", "uri" -> 
    "ref/DictionaryLookup"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6837, 204, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->142715134]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 27741, 900}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2075, 46, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2698, 73, 1581, 37, 70, "ObjectNameGrid"],
Cell[4282, 112, 1056, 33, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5375, 150, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5853, 167, 243, 6, 70, "Notes",
 CellID->1067943069],
Cell[6099, 175, 419, 13, 70, "Notes",
 CellID->27102957],
Cell[6521, 190, 279, 9, 70, "Notes",
 CellID->748969]
}, Closed]],
Cell[CellGroupData[{
Cell[6837, 204, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->142715134],
Cell[CellGroupData[{
Cell[7222, 218, 146, 5, 70, "ExampleSection",
 CellID->9847487],
Cell[7371, 225, 137, 4, 70, "ExampleText",
 CellID->756620383],
Cell[CellGroupData[{
Cell[7533, 233, 148, 4, 28, "Input",
 CellID->281677552],
Cell[7684, 239, 669, 14, 71, "Output",
 CellID->23244926]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8402, 259, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[8626, 268, 106, 2, 70, "ExampleText",
 CellID->324218126],
Cell[CellGroupData[{
Cell[8757, 274, 148, 4, 70, "Input",
 CellID->70492267],
Cell[8908, 280, 509, 11, 54, "Output",
 CellID->100595170]
}, Open  ]],
Cell[9432, 294, 125, 3, 70, "ExampleDelimiter",
 CellID->784591946],
Cell[9560, 299, 222, 7, 70, "ExampleText",
 CellID->360175090],
Cell[CellGroupData[{
Cell[9807, 310, 123, 3, 70, "Input",
 CellID->28322199],
Cell[9933, 315, 508, 11, 54, "Output",
 CellID->95791957]
}, Open  ]],
Cell[10456, 329, 125, 3, 70, "ExampleDelimiter",
 CellID->552034402],
Cell[10584, 334, 82, 1, 70, "ExampleText",
 CellID->83170880],
Cell[CellGroupData[{
Cell[10691, 339, 171, 5, 70, "Input",
 CellID->317527658],
Cell[10865, 346, 424, 10, 36, "Output",
 CellID->91800913]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11338, 362, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[11568, 371, 120, 3, 70, "ExampleText",
 CellID->165474145],
Cell[CellGroupData[{
Cell[11713, 378, 300, 9, 70, "Input",
 CellID->716962109],
Cell[12016, 389, 534, 12, 54, "Output",
 CellID->470277401]
}, Open  ]],
Cell[CellGroupData[{
Cell[12587, 406, 166, 5, 70, "Input",
 CellID->464233066],
Cell[12756, 413, 1859, 35, 70, "Output",
 Evaluatable->False,
 CellID->57173162]
}, Open  ]],
Cell[14630, 451, 125, 3, 70, "ExampleDelimiter",
 CellID->394830759],
Cell[14758, 456, 82, 1, 70, "ExampleText",
 CellID->100188410],
Cell[CellGroupData[{
Cell[14865, 461, 206, 6, 70, "Input",
 CellID->399438762],
Cell[15074, 469, 1747, 30, 105, "Output",
 CellID->98020527]
}, Open  ]],
Cell[16836, 502, 125, 3, 70, "ExampleDelimiter",
 CellID->347908609],
Cell[16964, 507, 141, 4, 70, "ExampleText",
 CellID->582161658],
Cell[CellGroupData[{
Cell[17130, 515, 228, 7, 70, "Input",
 CellID->317876666],
Cell[17361, 524, 311, 9, 36, "Output",
 CellID->189102701]
}, Open  ]],
Cell[CellGroupData[{
Cell[17709, 538, 234, 8, 70, "Input",
 CellID->64587067],
Cell[17946, 548, 251, 8, 36, "Output",
 CellID->673873067]
}, Open  ]],
Cell[18212, 559, 124, 3, 70, "ExampleDelimiter",
 CellID->75560609],
Cell[18339, 564, 91, 1, 70, "ExampleText",
 CellID->173238798],
Cell[CellGroupData[{
Cell[18455, 569, 505, 16, 70, "Input",
 CellID->260339553],
Cell[18963, 587, 451, 11, 36, "Output",
 CellID->142946099]
}, Open  ]],
Cell[19429, 601, 125, 3, 70, "ExampleDelimiter",
 CellID->479357292],
Cell[19557, 606, 104, 2, 70, "ExampleText",
 CellID->247949843],
Cell[CellGroupData[{
Cell[19686, 612, 172, 5, 70, "Input",
 CellID->122449866],
Cell[19861, 619, 451, 16, 36, "Output",
 CellID->316627137]
}, Open  ]],
Cell[20327, 638, 80, 1, 70, "ExampleText",
 CellID->61215524],
Cell[CellGroupData[{
Cell[20432, 643, 110, 3, 70, "Input",
 CellID->29255790],
Cell[20545, 648, 280, 8, 36, "Output",
 CellID->491876457]
}, Open  ]],
Cell[20840, 659, 54, 1, 70, "ExampleText",
 CellID->591465096],
Cell[CellGroupData[{
Cell[20919, 664, 135, 4, 70, "Input",
 CellID->267433761],
Cell[21057, 670, 424, 10, 36, "Output",
 CellID->7390452]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21530, 686, 228, 7, 70, "ExampleSection",
 CellID->589267740],
Cell[21761, 695, 102, 2, 70, "ExampleText",
 CellID->507808988],
Cell[CellGroupData[{
Cell[21888, 701, 312, 10, 70, "Input",
 CellID->284413836],
Cell[22203, 713, 437, 11, 36, "Output",
 CellID->296349294]
}, Open  ]],
Cell[22655, 727, 125, 3, 70, "ExampleDelimiter",
 CellID->129922722],
Cell[22783, 732, 107, 2, 70, "ExampleText",
 CellID->622971423],
Cell[CellGroupData[{
Cell[22915, 738, 211, 6, 70, "Input",
 CellID->20778882],
Cell[23129, 746, 448, 11, 54, "Output",
 CellID->375919537]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23638, 764, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[23957, 775, 722, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[24716, 806, 305, 8, 70, "RelatedLinksSection"],
Cell[25024, 816, 374, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25435, 833, 319, 9, 70, "MoreAboutSection",
 CellID->446322857],
Cell[25757, 844, 150, 3, 70, "MoreAbout",
 CellID->283089393],
Cell[25910, 849, 156, 3, 70, "MoreAbout",
 CellID->381759035],
Cell[26069, 854, 149, 3, 70, "MoreAbout",
 CellID->489459881],
Cell[26221, 859, 155, 3, 70, "MoreAbout",
 CellID->36703540],
Cell[26379, 864, 182, 3, 70, "MoreAbout",
 CellID->793660]
}, Open  ]],
Cell[26576, 870, 27, 0, 70, "History"],
Cell[26606, 872, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

