(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     78118,       2098]
NotebookOptionsPosition[     70590,       1833]
NotebookOutlinePosition[     71978,       1871]
CellTagsIndexPosition[     71892,       1866]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ListConvolve" :> 
          Documentation`HelpLookup["paclet:ref/ListConvolve"], "Subtract" :> 
          Documentation`HelpLookup["paclet:ref/Subtract"], "Accumulate" :> 
          Documentation`HelpLookup["paclet:ref/Accumulate"], "FoldList" :> 
          Documentation`HelpLookup["paclet:ref/FoldList"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ListConvolve\"\>", 
       2->"\<\"Subtract\"\>", 3->"\<\"Accumulate\"\>", 
       4->"\<\"FoldList\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Functions to Lists" :> 
          Documentation`HelpLookup["paclet:guide/ApplyingFunctionsToLists"], 
          "Arithmetic Functions" :> 
          Documentation`HelpLookup["paclet:guide/ArithmeticFunctions"], 
          "Discrete & Integer Data" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteAndIntegerData"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Math & Counting Operations on Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicalAndCountingOperationsOnLists"], 
          "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"], 
          "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"], 
          "New in 6.0: List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60ListManipulation"], 
          "New in 6.0: Numerical Data Handling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumericalDataHandling"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Applying Functions to Lists\"\>", 
       2->"\<\"Arithmetic Functions\"\>", 
       3->"\<\"Discrete & Integer Data\"\>", 4->"\<\"List Manipulation\"\>", 
       5->"\<\"Math & Counting Operations on Lists\"\>", 
       6->"\<\"Numerical Data\"\>", 
       7->"\<\"New in 6.0: Data Handling & Data Sources\"\>", 
       8->"\<\"New in 6.0: List Manipulation\"\>", 
       9->"\<\"New in 6.0: Numerical Data Handling\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Differences", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Differences",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Differences"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the successive differences of elements in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Differences",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Differences"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " differences of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Differences",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Differences"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the successive ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["k", "TI"]]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " differences at level ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " in a nested list. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->4047]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Differences",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Differences"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListConvolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListConvolve"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "}"}], ",", 
    StyleBox["list", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27981],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " has length ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Differences",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Differences"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " has length ",
 Cell[BoxData[
  RowBox[{
   StyleBox["s", "TI"], "-", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->31620,
  ButtonNote->"31620"]
}], "Notes",
 CellID->25455],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Differences",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Differences"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}]}], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Differences",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Differences"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", "1"}], "]"}]], "InlineFormula"],
 " finds the successive differences of rows in a 2D array or matrix ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Differences",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Differences"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], "]"}]], "InlineFormula"],
 " finds the differences of columns. "
}], "Notes",
 CellID->13674],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Differences",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Differences"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Differences",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Differences"], "[", 
   RowBox[{
    RowBox[{"Differences", "[", 
     RowBox[{
      StyleBox["list", "TI"], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16838]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->10288911],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->817246788],

Cell["First differences:", "ExampleText",
 CellID->2608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Differences", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19974],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "a"}], "+", "b"}], ",", 
   RowBox[{
    RowBox[{"-", "b"}], "+", "c"}], ",", 
   RowBox[{
    RowBox[{"-", "c"}], "+", "d"}], ",", 
   RowBox[{
    RowBox[{"-", "d"}], "+", "e"}]}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1348767971]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20452],

Cell["Second differences:", "ExampleText",
 CellID->17016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Differences", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18664],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "-", 
    RowBox[{"2", " ", "b"}], "+", "c"}], ",", 
   RowBox[{"b", "-", 
    RowBox[{"2", " ", "c"}], "+", "d"}], ",", 
   RowBox[{"c", "-", 
    RowBox[{"2", " ", "d"}], "+", "e"}]}], "}"}]], "Output",
 ImageSize->{210, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2053394512]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18551],

Cell["Differences of rows, within each column:", "ExampleText",
 CellID->29087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Differences", "[", 
   TagBox[
    RowBox[{"(", "\:f3a2", GridBox[{
       {
        SubscriptBox["a", "11"], 
        SubscriptBox["a", "12"], 
        SubscriptBox["a", "13"]},
       {
        SubscriptBox["a", "21"], 
        SubscriptBox["a", "22"], 
        SubscriptBox["a", "23"]},
       {
        SubscriptBox["a", "31"], 
        SubscriptBox["a", "32"], 
        SubscriptBox["a", "33"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{
       "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
        "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}], "\:f3a2", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10872],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWO1OwjAULVsHCmgi42OIRp5Gf/kQCzGBH0aDvJ4x/uedam/ppBwudAMW
ILqEdqe999y7fu2M53Q2fnlNZ5NROnyapu/jyehj+Pg21U1hRQgx17+7ROh7
pe/Mb66Urvu6DDUUoYHmItzRMNB1oOtILO0CW3dtf2jxrdNP7T2nn+prQx9R
SWbKXOIGcAiYWET0i22KA7AKACdUyCXWjw4WEnDXw4j2Bq+1Nu1YoTfiKoPz
+MVnzo9+ITuKDcXNOa4MH3fEski2tX2iERHj7tkScUveyMLPArVGWU5rMVxO
LnNpvfkMfd71QrERR4ViI24cMXaNnRkcnStdyCxD6cagc/YCrKtbrTtub8Ed
n8cvLpkfRyxgR6zJzga+e/g5uz+SbyvXk9FaIDiw9YMHx7lYv/+tbCvNQt3u
E04lkdKgqbOCwF5dtaqV+pmV491Tq3rpMlc+bc7KwR3A6E8qbX2tJR5W1Fu+
rPBdgrt781o+Z3VTNv8+Z91htIyPpXXysXdTVD6WfOs700S8svA9X5mKyrTW
oNX2lammyouLKmjziSPF8gzOvlV301AZi+/0K6qdDs371zQT95VeRDMhK/+9
9LWHFZ5Cn4AX4mLxf42o/AC0TEjp\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{204, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->501708302]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Differences", "[", 
   RowBox[{
    TagBox[
     RowBox[{"(", "\:f3a2", GridBox[{
        {
         SubscriptBox["a", "11"], 
         SubscriptBox["a", "12"], 
         SubscriptBox["a", "13"]},
        {
         SubscriptBox["a", "21"], 
         SubscriptBox["a", "22"], 
         SubscriptBox["a", "23"]},
        {
         SubscriptBox["a", "31"], 
         SubscriptBox["a", "32"], 
         SubscriptBox["a", "33"]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{
        "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
         "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}], "\:f3a2", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10963],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWO1OwjAULVsHCmgi42OIRp5Gf/kQCzGBH0aDvJ4x/uedam/ppBwudAMW
ILqEdqe999y7fu2M53Q2fnlNZ5NROnyapu/jyehj+Pg21U1hRQgx17+7ROh7
pe/Mb66Urvu6DDUUoYHmItzRMNB1oOtILO0CW3dtf2jxrdNP7T2nn+prQx9R
SWbKXOIGcAiYWET0i22KA7AKACdUyCXWjw4WEnDXw4j2Bq+1Nu1YoTfiKoPz
+MVnzo9+ITuKDcXNOa4MH3fEski2tX2iERHj7tkScUveyMLPArVGWU5rMVxO
LnNpvfkMfd71QrERR4ViI24cMXaNnRkcnStdyCxD6cagc/YCrKtbrTtub8Ed
n8cvLpkfRyxgR6zJzga+e/g5uz+SbyvXk9FaIDiw9YMHx7lYv/+tbCvNQt3u
E04lkdKgqbOCwF5dtaqV+pmV491Tq3rpMlc+bc7KwR3A6E8qbX2tJR5W1Fu+
rPBdgrt781o+Z3VTNv8+Z91htIyPpXXysXdTVD6WfOs700S8svA9X5mKyrTW
oNX2lammyouLKmjziSPF8gzOvlV301AZi+/0K6qdDs371zQT95VeRDMhK/+9
9LWHFZ5Cn4AX4mLxf42o/AC0TEjp\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{204, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->337271689]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23901],

Cell["Differences of columns, within each row:", "ExampleText",
 CellID->30813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Differences", "[", 
   RowBox[{
    TagBox[
     RowBox[{"(", "\:f3a2", GridBox[{
        {
         SubscriptBox["a", "11"], 
         SubscriptBox["a", "12"], 
         SubscriptBox["a", "13"]},
        {
         SubscriptBox["a", "21"], 
         SubscriptBox["a", "22"], 
         SubscriptBox["a", "23"]},
        {
         SubscriptBox["a", "31"], 
         SubscriptBox["a", "32"], 
         SubscriptBox["a", "33"]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{
        "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
         "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}], "\:f3a2", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28889],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWD9vWjEQN+8PJKStVB6gkKpt9n6PduqHQFGlMFSNkgxMQerCEomRkY/A
yMjIyMjIyMjI6Nz5D88cfn6OEEkIT+LZd+/ubJ/v7mfzu3l//edv87511bz8
ddu8uW5d3V3+/HcLrLDAGHuE349zBn0OPfF75Bxa+W7AOwBmAG0MbU3RIbQh
tBeErhs0tp+ElRjf4WAw4OJhCb7QHNcP9MVYLFpzofNti3MhLKWcgNBypE6n
o+hQqEWiO5vNRqMRdj+o1VBtShcttI9esmf7Re3P6XRKV9nv95XUmdXLkZV7
YvOjp251P+Pk7vJqtWq32+n6Q82VLhBWYhWL22OYNpmWMsbQ2vYZUm1Knz1r
bErHO40tfdztdsEVa+/JjJxMJpiRkZ5ZZNoOLPtTNKVzIt5HzhbxPnolQUP6
QhJvrklE/GKx4Cqvt/31mdiye/XrDroVvllfzNmltegjlzXyi2q/E1pURYxf
WSgzrPzXa1Z0wSGV0u9RKlF+U+kvHqRrih/wFKNMum7QGPNl79HMSKARWyM0
jeA85KoTmtbAktcsMcYOGdlOvFZpz/Pn1h57LudZqbzg2JT2i4Fjxb1TL+9g
hhwe/u2SF/vHv8Tb8y78q3pZeato9PJSWInKym+4JRIy9NOwcmuaa2CmxL9e
r+ccTe5OdoQK/PKMqgbRtde59L5ozghOPsvlkvPDxzq5yvl8PhwO19/VKuEg
qe52x4p10sp4PLac+CEAlM/cWJc3UzfWCe0S4apvbpxzaboxzqUpMQDydONe
R2/9GC8RS0+3+p+YLGTTcvS8meR8z0KyLHl6dklnH0CkvxZyoVQAsSSLZEx8
ibvsQqwKkQ8NK/JKit0HQksp8182VngCeFCzEg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{140, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->61752136]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29539],

Cell["\<\
Deduce the degree of a sequence by seeing when successive differences become \
constant:\
\>", "ExampleText",
 CellID->14990],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"n", "^", "5"}], "+", 
    RowBox[{"2", "n"}], "-", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "8"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13657],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "35", ",", "248", ",", "1031", ",", "3134", ",", "7787", ",", 
   "16820", ",", "32783"}], "}"}]], "Output",
 ImageSize->{297, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1760263935]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPointList", "[", 
  RowBox[{"Differences", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15615],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "2", ",", "35", ",", "248", ",", "1031", ",", "3134", ",", "7787", ",", 
     "16820", ",", "32783"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "33", ",", "213", ",", "783", ",", "2103", ",", "4653", ",", "9033", ",", 
     "15963"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "180", ",", "570", ",", "1320", ",", "2550", ",", "4380", ",", "6930"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"390", ",", "750", ",", "1230", ",", "1830", ",", "2550"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"360", ",", "480", ",", "600", ",", "720"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"120", ",", "120", ",", "120"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", "0", "}"}], ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "}"}]}], "}"}]], "Output",
 ImageSize->{580, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1021234473]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11859],

Cell["\<\
Finite difference approximation to the Laplacian of a Gaussian:\
\>", "ExampleText",
 CellID->14072],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"x", "^", "2"}]}], "-", 
       RowBox[{"y", "^", "2"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0.1"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13645],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListDensityPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Drop", "[", 
     RowBox[{
      RowBox[{"Differences", "[", 
       RowBox[{"t", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "2"}], "}"}]}], "]"}], ",", "2", ",", "0"}], "]"}],
     "+", 
    RowBox[{"Drop", "[", 
     RowBox[{
      RowBox[{"Differences", "[", 
       RowBox[{"t", ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "0"}], "}"}]}], "]"}], ",", "0", ",", "2"}], 
     "]"}]}], ",", 
   RowBox[{"PlotRange", "->", "All"}], ",", 
   RowBox[{"DataRange", "->", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22449],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 227},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[2]=",
 CellID->356127773]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1171]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9606],

Cell["First differences are constant for a linear function:", "ExampleText",
 CellID->11852],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"3", "i"}], "+", "6"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5386],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "9", ",", "12", ",", "15", ",", "18", ",", "21", ",", "24", ",", "27", ",", 
   "30", ",", "33", ",", "36"}], "}"}]], "Output",
 ImageSize->{252, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1619142596]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Differences", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11240],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", 
   ",", "3"}], "}"}]], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->16836188]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20778],

Cell["Second differences are constant for a quadratic function:", \
"ExampleText",
 CellID->12879],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"3", 
     RowBox[{"i", "^", "2"}]}], "+", "6"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6673],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "9", ",", "18", ",", "33", ",", "54", ",", "81", ",", "114", ",", "153", 
   ",", "198", ",", "249", ",", "306"}], "}"}]], "Output",
 ImageSize->{287, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1645453959]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Differences", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2792],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "9", ",", "15", ",", "21", ",", "27", ",", "33", ",", "39", ",", "45", ",", 
   "51", ",", "57"}], "}"}]], "Output",
 ImageSize->{227, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1997766494]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Differences", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->22387],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "6", ",", "6", ",", "6", ",", "6", ",", "6", ",", "6", ",", "6", ",", "6"}],
   "}"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->554643813]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26602],

Cell["Successive differences are progressively shorter:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->31620],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Differences", "[", 
     RowBox[{
      RowBox[{"Range", "[", "10", "]"}], ",", "n"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20116],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWF1OwkAQLlQEMQr4k/jIi3oF9QCa+HMDNSHEBB4UghxAPYL4oh6AY65t
N/gwfCOz/WFbWRNaZro7883szDfUm8649/DYGfe7nfbFqDPs9bvP7fPBKFD5
Jc/zpsFncuAF31XwLfpMlQrua+HVD+XozysT+Tta5RMt3fWV+iqKY53In5Zw
yVbJsjr980ptbBD5A+LZJPIErgrlUKyIVkfoK79ytGYe3wSemw/3Ur/vif0W
cS+qEh+s1iedrFoaRH6D6OvBpRyILaJ/hau5KqoyemyFz1iIpCrKp7Ysq70t
qKVYXwywYosY42pa5Cq9oXDF6+pMt+KpPISxzjqgqXAnDOAu007g9Nh63A6R
94/2m6R/ZF31ZBCfiR8cj/MTz8+ibuW6VndUtl1L5XuYGdrFXDffwd1pdTOn
x16z6XI5B2hU6XOAjBluDXKS3DuO3Xm35V3KOBzzaBZYLvNQ+RrmkWMijpGu
oJWsGYnTYzQ2mErOYxrzsnhMxm6XBnnMChPOk8NUXEymrMmxp2Yuu+xJ5TOY
9UVsyrHqKbRmi1U5PUaZP7aVc7GOyC4Xyxj6xCD3y0WKc+qQrjLSuMzPTQDN
tvmaAE0iH8Mzkk6E2X2H7D+CVvM2GWqMHqMv2sQIn9bYp/Px5nGebEMtPa9D
lVeewfhx/h1+hz8J/qTTq6nwFNMTIt9TjD7fV+hETadaS+H3nj1ovSjTjVuP
o/pfU0/+jqWzUZyZKHsf21XFYjrZr3eTynVRuaiyiiqtCcy9T+qpVqxJTOXo
5FObzNx/JsvQS6itgLyuW9JXU7KDo6WrZvOPVsSy9PUU7MxHTSc0nXi2653i
KYnOyjbqeBXmUK86aqRNwuuzO+0iPUX0xPNKP6txi7g=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{167, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->262588311]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31622],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FoldList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FoldList"]], "InlineFormula"],
 " acts as an inverse of ",
 Cell[BoxData[
  ButtonBox["Differences",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Differences"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->13925],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Differences", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10002],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "a"}], "+", "b"}], ",", 
   RowBox[{
    RowBox[{"-", "b"}], "+", "c"}], ",", 
   RowBox[{
    RowBox[{"-", "c"}], "+", "d"}], ",", 
   RowBox[{
    RowBox[{"-", "d"}], "+", "e"}]}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->793091297]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{"Plus", ",", "a", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28899],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->54431750]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8283],

Cell["\<\
Successive differences mod 2 of a sequence based on the primes:\
\>", "ExampleText",
 CellID->28568],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Mod", "[", 
   RowBox[{
    RowBox[{"PadLeft", "[", 
     RowBox[{"NestList", "[", 
      RowBox[{"Differences", ",", 
       RowBox[{"Array", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Prime", "[", "#", "]"}], "-", "1"}], ")"}], "/", "2"}], 
          "&"}], ",", "100"}], "]"}], ",", "100"}], "]"}], "]"}], ",", "2"}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13538],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztXUluHEcQJPQTvYR/8BME8ewv+wk+6igBQsIA7XJlLNnbRAJCgENNTy2x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   "], {{0, 0}, {100, 101}}, {0, 1.5}],
  Frame->Automatic,
  FrameTicks->{None, None}]], "Output",
 ImageSize->{184, 181},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6388628]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5156],

Cell["Pascal-triangle-like pattern:", "ExampleText",
 CellID->29017],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{"Differences", ",", 
   RowBox[{"Normal", "[", 
    RowBox[{"SparseArray", "[", 
     RowBox[{
      RowBox[{"10", "->", "1"}], ",", "21"}], "]"}], "]"}], ",", "11"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24200],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "1", ",", 
     RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1",
      ",", 
     RowBox[{"-", "2"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
     RowBox[{"-", "3"}], ",", "3", ",", 
     RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
     RowBox[{"-", "4"}], ",", "6", ",", 
     RowBox[{"-", "4"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
     RowBox[{"-", "5"}], ",", "10", ",", 
     RowBox[{"-", "10"}], ",", "5", ",", 
     RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", 
     RowBox[{"-", "6"}], ",", "15", ",", 
     RowBox[{"-", "20"}], ",", "15", ",", 
     RowBox[{"-", "6"}], ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", 
     RowBox[{"-", "7"}], ",", "21", ",", 
     RowBox[{"-", "35"}], ",", "35", ",", 
     RowBox[{"-", "21"}], ",", "7", ",", 
     RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", 
     RowBox[{"-", "8"}], ",", "28", ",", 
     RowBox[{"-", "56"}], ",", "70", ",", 
     RowBox[{"-", "56"}], ",", "28", ",", 
     RowBox[{"-", "8"}], ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "9"}], ",", "36", ",", 
     RowBox[{"-", "84"}], ",", "126", ",", 
     RowBox[{"-", "126"}], ",", "84", ",", 
     RowBox[{"-", "36"}], ",", "9", ",", 
     RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "10"}], ",", "45", ",", 
     RowBox[{"-", "120"}], ",", "210", ",", 
     RowBox[{"-", "252"}], ",", "210", ",", 
     RowBox[{"-", "120"}], ",", "45", ",", 
     RowBox[{"-", "10"}], ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"55", ",", 
     RowBox[{"-", "165"}], ",", "330", ",", 
     RowBox[{"-", "462"}], ",", "462", ",", 
     RowBox[{"-", "330"}], ",", "165", ",", 
     RowBox[{"-", "55"}], ",", "11", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{403, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2146972093]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15315],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListConvolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListConvolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Subtract",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subtract"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Accumulate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Accumulate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FoldList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FoldList"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13312]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->202113172],

Cell[TextData[ButtonBox["Applying Functions to Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ApplyingFunctionsToLists"]], "MoreAbout",
 CellID->39965321],

Cell[TextData[ButtonBox["Arithmetic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ArithmeticFunctions"]], "MoreAbout",
 CellID->26881160],

Cell[TextData[ButtonBox["Discrete & Integer Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteAndIntegerData"]], "MoreAbout",
 CellID->149107719],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->267978630],

Cell[TextData[ButtonBox["Math & Counting Operations on Lists",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathematicalAndCountingOperationsOnLists"]], "MoreAbout",
 CellID->327595247],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout",
 CellID->158921986],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataHandlingAndDataSources"]], "MoreAbout",
 CellID->104096446],

Cell[TextData[ButtonBox["New in 6.0: List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ListManipulation"]], "MoreAbout",
 CellID->48559270],

Cell[TextData[ButtonBox["New in 6.0: Numerical Data Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NumericalDataHandling"]], "MoreAbout",
 CellID->50532583]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Differences - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 11.8360664}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Differences[list] gives the successive differences of elements in list. \
Differences[list, n] gives the n\\[Null]^th differences of list. \
Differences[list, {n_1, n_2, ...}] gives the successive n_k\\[Null]^th \
differences at level k in a nested list. ", "synonyms" -> {}, "title" -> 
    "Differences", "type" -> "Symbol", "uri" -> "ref/Differences"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10810, 344, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->10288911]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 71749, 1859}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2889, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3512, 88, 1576, 37, 70, "ObjectNameGrid"],
Cell[5091, 127, 2100, 68, 70, "Usage",
 CellID->4047]
}, Open  ]],
Cell[CellGroupData[{
Cell[7228, 200, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7706, 217, 531, 20, 70, "Notes",
 CellID->27981],
Cell[8240, 239, 648, 27, 70, "Notes",
 CellID->25455],
Cell[8891, 268, 932, 33, 70, "Notes",
 CellID->13674],
Cell[9826, 303, 947, 36, 70, "Notes",
 CellID->16838]
}, Closed]],
Cell[CellGroupData[{
Cell[10810, 344, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->10288911],
Cell[CellGroupData[{
Cell[11194, 358, 148, 5, 70, "ExampleSection",
 CellID->817246788],
Cell[11345, 365, 56, 1, 70, "ExampleText",
 CellID->2608],
Cell[CellGroupData[{
Cell[11426, 370, 183, 6, 28, "Input",
 CellID->19974],
Cell[11612, 378, 401, 15, 36, "Output",
 CellID->1348767971]
}, Open  ]],
Cell[12028, 396, 121, 3, 70, "ExampleDelimiter",
 CellID->20452],
Cell[12152, 401, 58, 1, 70, "ExampleText",
 CellID->17016],
Cell[CellGroupData[{
Cell[12235, 406, 208, 7, 70, "Input",
 CellID->18664],
Cell[12446, 415, 392, 13, 36, "Output",
 CellID->2053394512]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12887, 434, 216, 7, 70, "ExampleSection",
 CellID->18551],
Cell[13106, 443, 79, 1, 70, "ExampleText",
 CellID->29087],
Cell[CellGroupData[{
Cell[13210, 448, 881, 27, 70, "Input",
 CellID->10872],
Cell[14094, 477, 862, 18, 70, "Output",
 Evaluatable->False,
 CellID->501708302]
}, Open  ]],
Cell[CellGroupData[{
Cell[14993, 500, 979, 30, 70, "Input",
 CellID->10963],
Cell[15975, 532, 862, 18, 70, "Output",
 Evaluatable->False,
 CellID->337271689]
}, Open  ]],
Cell[16852, 553, 121, 3, 70, "ExampleDelimiter",
 CellID->23901],
Cell[16976, 558, 79, 1, 70, "ExampleText",
 CellID->30813],
Cell[CellGroupData[{
Cell[17080, 563, 979, 30, 70, "Input",
 CellID->28889],
Cell[18062, 595, 1117, 22, 70, "Output",
 Evaluatable->False,
 CellID->61752136]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19228, 623, 223, 7, 70, "ExampleSection",
 CellID->29539],
Cell[19454, 632, 135, 4, 70, "ExampleText",
 CellID->14990],
Cell[CellGroupData[{
Cell[19614, 640, 248, 9, 70, "Input",
 CellID->13657],
Cell[19865, 651, 292, 9, 36, "Output",
 CellID->1760263935]
}, Open  ]],
Cell[CellGroupData[{
Cell[20194, 665, 139, 4, 70, "Input",
 CellID->15615],
Cell[20336, 671, 1017, 31, 71, "Output",
 CellID->1021234473]
}, Open  ]],
Cell[21368, 705, 121, 3, 70, "ExampleDelimiter",
 CellID->11859],
Cell[21492, 710, 110, 3, 70, "ExampleText",
 CellID->14072],
Cell[21605, 715, 513, 18, 70, "Input",
 CellID->13645],
Cell[CellGroupData[{
Cell[22143, 737, 639, 21, 70, "Input",
 CellID->22449],
Cell[22785, 760, 30358, 502, 70, "Output",
 Evaluatable->False,
 CellID->356127773]
}, Open  ]],
Cell[53158, 1265, 120, 3, 70, "ExampleDelimiter",
 CellID->1171]
}, Closed]],
Cell[CellGroupData[{
Cell[53315, 1273, 232, 7, 70, "ExampleSection",
 CellID->9606],
Cell[53550, 1282, 92, 1, 70, "ExampleText",
 CellID->11852],
Cell[CellGroupData[{
Cell[53667, 1287, 213, 8, 70, "Input",
 CellID->5386],
Cell[53883, 1297, 301, 9, 36, "Output",
 CellID->1619142596]
}, Open  ]],
Cell[CellGroupData[{
Cell[54221, 1311, 103, 3, 70, "Input",
 CellID->11240],
Cell[54327, 1316, 280, 9, 36, "Output",
 CellID->16836188]
}, Open  ]],
Cell[54622, 1328, 121, 3, 70, "ExampleDelimiter",
 CellID->20778],
Cell[54746, 1333, 98, 2, 70, "ExampleText",
 CellID->12879],
Cell[CellGroupData[{
Cell[54869, 1339, 239, 9, 70, "Input",
 CellID->6673],
Cell[55111, 1350, 306, 9, 36, "Output",
 CellID->1645453959]
}, Open  ]],
Cell[CellGroupData[{
Cell[55454, 1364, 102, 3, 70, "Input",
 CellID->2792],
Cell[55559, 1369, 290, 9, 36, "Output",
 CellID->1997766494]
}, Open  ]],
Cell[CellGroupData[{
Cell[55886, 1383, 103, 3, 70, "Input",
 CellID->22387],
Cell[55992, 1388, 270, 9, 36, "Output",
 CellID->554643813]
}, Open  ]],
Cell[56277, 1400, 121, 3, 70, "ExampleDelimiter",
 CellID->26602],
Cell[56401, 1405, 136, 2, 70, "ExampleText",
 CellID->31620],
Cell[CellGroupData[{
Cell[56562, 1411, 309, 10, 70, "Input",
 CellID->20116],
Cell[56874, 1423, 1111, 22, 70, "Output",
 Evaluatable->False,
 CellID->262588311]
}, Open  ]],
Cell[58000, 1448, 121, 3, 70, "ExampleDelimiter",
 CellID->31622],
Cell[58124, 1453, 327, 12, 70, "ExampleText",
 CellID->13925],
Cell[CellGroupData[{
Cell[58476, 1469, 183, 6, 70, "Input",
 CellID->10002],
Cell[58662, 1477, 400, 15, 36, "Output",
 CellID->793091297]
}, Open  ]],
Cell[CellGroupData[{
Cell[59099, 1497, 136, 4, 70, "Input",
 CellID->28899],
Cell[59238, 1503, 232, 7, 36, "Output",
 CellID->54431750]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[59519, 1516, 223, 7, 70, "ExampleSection",
 CellID->8283],
Cell[59745, 1525, 110, 3, 70, "ExampleText",
 CellID->28568],
Cell[CellGroupData[{
Cell[59880, 1532, 525, 17, 70, "Input",
 CellID->13538],
Cell[60408, 1551, 3031, 55, 202, "Output",
 CellID->6388628]
}, Open  ]],
Cell[63454, 1609, 120, 3, 70, "ExampleDelimiter",
 CellID->5156],
Cell[63577, 1614, 68, 1, 70, "ExampleText",
 CellID->29017],
Cell[CellGroupData[{
Cell[63670, 1619, 277, 9, 70, "Input",
 CellID->24200],
Cell[63950, 1630, 3392, 83, 224, "Output",
 CellID->2146972093]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[67403, 1720, 311, 9, 70, "SeeAlsoSection",
 CellID->15315],
Cell[67717, 1731, 953, 35, 70, "SeeAlso",
 CellID->13312]
}, Open  ]],
Cell[CellGroupData[{
Cell[68707, 1771, 319, 9, 70, "MoreAboutSection",
 CellID->202113172],
Cell[69029, 1782, 162, 3, 70, "MoreAbout",
 CellID->39965321],
Cell[69194, 1787, 150, 3, 70, "MoreAbout",
 CellID->26881160],
Cell[69347, 1792, 157, 3, 70, "MoreAbout",
 CellID->149107719],
Cell[69507, 1797, 145, 3, 70, "MoreAbout",
 CellID->267978630],
Cell[69655, 1802, 190, 4, 70, "MoreAbout",
 CellID->327595247],
Cell[69848, 1808, 139, 3, 70, "MoreAbout",
 CellID->158921986],
Cell[69990, 1813, 185, 3, 70, "MoreAbout",
 CellID->104096446],
Cell[70178, 1818, 163, 3, 70, "MoreAbout",
 CellID->48559270],
Cell[70344, 1823, 174, 3, 70, "MoreAbout",
 CellID->50532583]
}, Open  ]],
Cell[70533, 1829, 27, 0, 70, "History"],
Cell[70563, 1831, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

