(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15193,        558]
NotebookOptionsPosition[     11603,        438]
NotebookOutlinePosition[     12935,        476]
CellTagsIndexPosition[     12850,        471]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators without Built\[Hyphen]in Meanings" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OperatorsWithoutBuiltInMeanings"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators without Built\[Hyphen]in Meanings\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CapitalDifferentialD" :> 
          Documentation`HelpLookup["paclet:ref/CapitalDifferentialD"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"CapitalDifferentialD\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "DifferentialD ",
     StyleBox["(\[DifferentialD])", "OperatorCharacter"]
    }], "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DifferentialD",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DifferentialD"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]displays as ",
     Cell[BoxData[
      RowBox[{"\[DifferentialD]", 
       StyleBox["x", "TI"]}]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DifferentialD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DifferentialD"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " has no built-in meaning."
}], "Notes",
 CellID->10989299],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"\[DifferentialD]", 
   StyleBox["x", "TI"]}]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DifferentialD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DifferentialD"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->237513406],

Cell[TextData[{
 Cell[BoxData["\[DifferentialD]"], "InlineFormula"],
 " can be entered as ",
 Cell[TextData[ButtonBox["\\[DifferentialD]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DifferentialD"]], "InlineCharacterName"],
 " or ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]dd\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->1162865834]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->101097672],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->118078770],

Cell[TextData[{
 "Use ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]int\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " to enter ",
 Cell[BoxData["\[Integral]"], "InlineFormula"],
 " and ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]dd\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " to enter ",
 Cell[BoxData["\[DifferentialD]"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->17338],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Sqrt", "[", "x", "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9575],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SuperscriptBox["x", 
    RowBox[{"3", "/", "2"}]]}], "3"]], "Output",
 ImageSize->{41, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->786853620]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->28690388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->474918478],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SuperscriptBox["x", 
    RowBox[{"3", "/", "2"}]]}], "3"]], "Output",
 ImageSize->{41, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->395365052]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->100619983],

Cell[TextData[{
 "Use ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["_", "KeyEvent"],
 " to enter the lower limit, then ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["%", "KeyEvent"],
 " for the upper limit:"
}], "ExampleText",
 CellID->21935],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], " ", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     SuperscriptBox["x", "2"]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1825],

Cell[BoxData[
 FractionBox[
  SqrtBox["\[Pi]"], "2"]], "Output",
 ImageSize->{33, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->403286274]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->106181863],

Cell[TextData[{
 "A multiple integral with ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " integration outermost:"
}], "ExampleText",
 CellID->816087565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "1"], 
  RowBox[{
   SubsuperscriptBox["\[Integral]", "0", "x"], 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"x", " ", "y"}], "]"}], 
    RowBox[{"\[DifferentialD]", "y"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30573],

Cell[BoxData[
 FractionBox[
  RowBox[{"SinIntegral", "[", "1", "]"}], "2"]], "Output",
 ImageSize->{107, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->183910996]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->61882064],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "x"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13002104],

Cell[BoxData[
 FractionBox[
  RowBox[{"SinIntegral", "[", "1", "]"}], "2"]], "Output",
 ImageSize->{107, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->199449023]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["CapitalDifferentialD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CapitalDifferentialD"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->37400691]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Operators without Built\[Hyphen]in Meanings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OperatorsWithoutBuiltInMeanings"]], "Tutorials",\

 CellID->341631938]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DifferentialD (\[DifferentialD]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 12.6329618}", "context" -> "System`", 
    "keywords" -> {
     "differential", "integration measure", "Stieltjes measure", "Leibniz d", 
      "infinitesimal", "differential form"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "DifferentialD[x] displays as \\[DifferentialD]x.", "synonyms" -> {}, 
    "title" -> "DifferentialD", "type" -> "Symbol", "uri" -> 
    "ref/DifferentialD"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5710, 186, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->101097672]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12707, 464}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1269, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1892, 60, 1660, 40, 70, "ObjectNameGrid"],
Cell[3555, 102, 582, 19, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4174, 126, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4652, 143, 256, 9, 70, "Notes",
 CellID->10989299],
Cell[4911, 154, 359, 13, 70, "Notes",
 CellID->237513406],
Cell[5273, 169, 400, 12, 70, "Notes",
 CellID->1162865834]
}, Closed]],
Cell[CellGroupData[{
Cell[5710, 186, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->101097672],
Cell[CellGroupData[{
Cell[6095, 200, 148, 5, 70, "ExampleSection",
 CellID->118078770],
Cell[6246, 207, 436, 15, 70, "ExampleText",
 CellID->17338],
Cell[CellGroupData[{
Cell[6707, 226, 176, 6, 41, "Input",
 CellID->9575],
Cell[6886, 234, 251, 9, 54, "Output",
 CellID->786853620]
}, Open  ]],
Cell[7152, 246, 188, 8, 70, "ExampleText",
 CellID->28690388],
Cell[CellGroupData[{
Cell[7365, 258, 160, 5, 28, "Input",
 CellID->474918478],
Cell[7528, 265, 251, 9, 54, "Output",
 CellID->395365052]
}, Open  ]],
Cell[7794, 277, 125, 3, 70, "ExampleDelimiter",
 CellID->100619983],
Cell[7922, 282, 313, 11, 70, "ExampleText",
 CellID->21935],
Cell[CellGroupData[{
Cell[8260, 297, 269, 9, 70, "Input",
 CellID->1825],
Cell[8532, 308, 194, 7, 56, "Output",
 CellID->403286274]
}, Open  ]],
Cell[8741, 318, 125, 3, 70, "ExampleDelimiter",
 CellID->106181863],
Cell[8869, 323, 168, 6, 70, "ExampleText",
 CellID->816087565],
Cell[CellGroupData[{
Cell[9062, 333, 338, 11, 70, "Input",
 CellID->30573],
Cell[9403, 346, 217, 7, 51, "Output",
 CellID->183910996]
}, Open  ]],
Cell[9635, 356, 188, 8, 70, "ExampleText",
 CellID->61882064],
Cell[CellGroupData[{
Cell[9848, 368, 311, 10, 70, "Input",
 CellID->13002104],
Cell[10162, 380, 217, 7, 51, "Output",
 CellID->199449023]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10440, 394, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[10759, 405, 223, 6, 70, "SeeAlso",
 CellID->37400691]
}, Open  ]],
Cell[CellGroupData[{
Cell[11019, 416, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[11340, 427, 191, 4, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[11546, 434, 27, 0, 70, "History"],
Cell[11576, 436, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

