(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25689,        914]
NotebookOptionsPosition[     20204,        729]
NotebookOutlinePosition[     21807,        771]
CellTagsIndexPosition[     21722,        766]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"IntegerLength" :> 
          Documentation`HelpLookup["paclet:ref/IntegerLength"], 
          "IntegerDigits" :> 
          Documentation`HelpLookup["paclet:ref/IntegerDigits"], "FromDigits" :> 
          Documentation`HelpLookup["paclet:ref/FromDigits"], "BitAnd" :> 
          Documentation`HelpLookup["paclet:ref/BitAnd"], "IntegerExponent" :> 
          Documentation`HelpLookup["paclet:ref/IntegerExponent"], 
          "HammingDistance" :> 
          Documentation`HelpLookup["paclet:ref/HammingDistance"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"IntegerLength\"\>", 
       2->"\<\"IntegerDigits\"\>", 3->"\<\"FromDigits\"\>", 
       4->"\<\"BitAnd\"\>", 5->"\<\"IntegerExponent\"\>", 
       6->"\<\"HammingDistance\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Number Digits" :> 
          Documentation`HelpLookup["paclet:guide/NumberDigits"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"], 
          "Representation of Numbers" :> 
          Documentation`HelpLookup[
           "paclet:guide/RepresentationOfNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Integer Functions\"\>", 
       2->"\<\"Mathematical Functions\"\>", 3->"\<\"Number Digits\"\>", 
       4->"\<\"Number Theoretic Functions\"\>", 5->"\<\"Number Theory\"\>", 
       6->"\<\"Representation of Numbers\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DigitCount", "ObjectName",
 CellID->27397],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DigitCount",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DigitCount"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["b", "TI"], ",", 
        StyleBox["d", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the number of ",
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"],
     " digits in the base ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     " representation of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DigitCount",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DigitCount"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the numbers of 1, 2, ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{
       StyleBox["b", "TI"], "-", "1"}]], "InlineFormula"],
     ", 0 digits in the base ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     " representation of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DigitCount",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DigitCount"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the numbers of 1, 2, ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     ", 9, 0 digits in the base 10 representation of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->9025]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Integer mathematical function, suitable for both symbolic and numerical \
manipulation.\
\>", "Notes",
 CellID->126685801],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DigitCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DigitCount"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DigitCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DigitCount"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", "10", ",", 
    RowBox[{
     ButtonBox["Mod",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Mod"], "[", 
     RowBox[{
      RowBox[{
       ButtonBox["Range",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Range"], "[", "10", "]"}], ",", "10"}], 
     "]"}]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13707]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->189421780],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->217495706],

Cell["Binary representation:", "ExampleText",
 CellID->13947],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerDigits", "[", 
  RowBox[{"2147", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6361],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", 
   ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{226, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->135601504]
}, Open  ]],

Cell["Number of 1s in binary representation:", "ExampleText",
 CellID->3959],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DigitCount", "[", 
  RowBox[{"2147", ",", "2", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4415],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->106353167]
}, Open  ]],

Cell["Number of 1s and 0s:", "ExampleText",
 CellID->15],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DigitCount", "[", 
  RowBox[{"2147", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->31466],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", "7"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->459080706]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27292],

Cell["Number of each digit 1, 2, 3, ..., 0 in 100!:", "ExampleText",
 CellID->26058],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DigitCount", "[", 
  RowBox[{"100", "!"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2398],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "15", ",", "19", ",", "10", ",", "10", ",", "14", ",", "19", ",", "7", ",", 
   "14", ",", "20", ",", "30"}], "}"}]], "Output",
 ImageSize->{252, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23158643]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31188],

Cell["\<\
Count the number of digits 1 and 2 in ternary representation:\
\>", "ExampleText",
 CellID->30073],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DigitCount", "[", 
  RowBox[{"242442422", ",", "3", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13946],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", "7"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2396614]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16500],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"DigitCount", "[", 
     RowBox[{"n", ",", "2", ",", "1"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "127"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18880],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxdk0tOQkEQRTuOHDpw4ICBGmOMMcb/X2kRURFRQEBAICFx7BKspdWSXIIa
3x3UISGdw6nbt/u9sDL7bH/MpZS+fr9/6//nuxzXlCPP5/j7Avwi/BK4lOM+
y8ivYn4NvI78Bvwm/BZ4G+feQf8u9tsD72O/A/hD+CPwMfpPkD/F/Bn4HPkL
+Ev4K3C5WPWecrEW9zexznMd2cTqq8BX4G8im1jnqSJfjfPpFnmx8jX4Gvxd
ZBPr/vfoF6v/AfuLtX8dvg7/iH6x+hvIN+J8ekJerHwTvgn/HNnE+l++FGvx
/rNYzwPsYj2fVvS5Fb2BXaz7tZFvx3kDu1j5TvS5E72BXazn84p+sfrBLlZ/
F/3d6A3sYvX3kO/FeQO7WPl+9LkfvYFdrPf/Vqy6v1j3B7tY9x/g/IPoDexi
nX+I/DDOG9jFyo+iz6PoDexi3f8d/WL1g12s/jH6x9Eb2MXqnyA/ifMGdrHy
0+jzNHoDu7iUfwCpx5K1
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotRange->{{0., 127.}, {1., 7.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->583349032]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1341],

Cell[TextData[{
 "Thue-Morse sequence ",
 ButtonBox["[more info]:",
  BaseStyle->"NKSLink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/page-889c-text"], None}]
}], "ExampleText",
 CellID->18261],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{"Mod", "[", 
     RowBox[{
      RowBox[{"DigitCount", "[", 
       RowBox[{
        RowBox[{"n", "-", "1"}], ",", "2", ",", "1"}], "]"}], ",", "2"}], 
     "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "25"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28241],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "1", ",", "1", ",", "0", 
   ",", "0", ",", "1", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", 
   "1", ",", "0", ",", "1", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", 
   ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{462, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7582719]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31689],

Cell[TextData[{
 "Number of black cells at step ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " in the rule 90 cellular automaton (binomial coefficients mod 2):"
}], "ExampleText",
 CellID->25573],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"2", "^", 
    RowBox[{"DigitCount", "[", 
     RowBox[{"t", ",", "2", ",", "1"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3908],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "2", ",", "4", ",", "2", ",", "4", ",", "4", ",", "8", 
   ",", "2", ",", "4", ",", "4"}], "}"}]], "Output",
 ImageSize->{207, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6092005]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "/@", 
  RowBox[{"CellularAutomaton", "[", 
   RowBox[{"90", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "10"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3950],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "2", ",", "4", ",", "2", ",", "4", ",", "4", ",", "8", 
   ",", "2", ",", "4", ",", "4"}], "}"}]], "Output",
 ImageSize->{207, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->176017762]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20873],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerLength",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerLength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerDigits"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FromDigits"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitAnd",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitAnd"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerExponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerExponent"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HammingDistance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HammingDistance"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29404]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11444],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->23022]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->29073],

Cell[TextData[{
 ButtonBox["Demonstrations with DigitCount",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=DigitCount"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/index.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/NumberTheoryFunctions/DigitCount/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
DigitCount"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->89077718],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->55753898],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->10178340],

Cell[TextData[ButtonBox["Number Digits",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberDigits"]], "MoreAbout",
 CellID->137510948],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->22430193],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->34032229],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "MoreAbout",
 CellID->232133234]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DigitCount - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 13.4611080}", "context" -> "System`", 
    "keywords" -> {
     "bit count", "count of digits", "digital sums", "digits count", 
      "fractal", "Hamming weight", "ones", "population count", 
      "self-similar"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "DigitCount[n, b, d] gives the number of d digits in the base b \
representation of n. DigitCount[n, b] gives a list of the numbers of 1, 2, \
..., b - 1, 0 digits in the base b representation of n. DigitCount[n] gives a \
list of the numbers of 1, 2, ..., 9, 0 digits in the base 10 representation \
of n. ", "synonyms" -> {"digit count"}, "title" -> "DigitCount", "type" -> 
    "Symbol", "uri" -> "ref/DigitCount"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7295, 226, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->189421780]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21579, 759}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3155, 70, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3778, 97, 48, 1, 70, "ObjectName",
 CellID->27397],
Cell[3829, 100, 2056, 66, 70, "Usage",
 CellID->9025]
}, Open  ]],
Cell[CellGroupData[{
Cell[5922, 171, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6400, 188, 132, 4, 70, "Notes",
 CellID->126685801],
Cell[6535, 194, 723, 27, 70, "Notes",
 CellID->13707]
}, Closed]],
Cell[CellGroupData[{
Cell[7295, 226, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->189421780],
Cell[CellGroupData[{
Cell[7680, 240, 148, 5, 70, "ExampleSection",
 CellID->217495706],
Cell[7831, 247, 61, 1, 70, "ExampleText",
 CellID->13947],
Cell[CellGroupData[{
Cell[7917, 252, 130, 4, 28, "Input",
 CellID->6361],
Cell[8050, 258, 311, 9, 36, "Output",
 CellID->135601504]
}, Open  ]],
Cell[8376, 270, 76, 1, 70, "ExampleText",
 CellID->3959],
Cell[CellGroupData[{
Cell[8477, 275, 137, 4, 28, "Input",
 CellID->4415],
Cell[8617, 281, 158, 5, 36, "Output",
 CellID->106353167]
}, Open  ]],
Cell[8790, 289, 56, 1, 70, "ExampleText",
 CellID->15],
Cell[CellGroupData[{
Cell[8871, 294, 128, 4, 70, "Input",
 CellID->31466],
Cell[9002, 300, 203, 7, 36, "Output",
 CellID->459080706]
}, Open  ]],
Cell[9220, 310, 121, 3, 70, "ExampleDelimiter",
 CellID->27292],
Cell[9344, 315, 84, 1, 70, "ExampleText",
 CellID->26058],
Cell[CellGroupData[{
Cell[9453, 320, 121, 4, 70, "Input",
 CellID->2398],
Cell[9577, 326, 299, 9, 36, "Output",
 CellID->23158643]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9925, 341, 216, 7, 70, "ExampleSection",
 CellID->31188],
Cell[10144, 350, 108, 3, 70, "ExampleText",
 CellID->30073],
Cell[CellGroupData[{
Cell[10277, 357, 192, 6, 70, "Input",
 CellID->13946],
Cell[10472, 365, 201, 7, 36, "Output",
 CellID->2396614]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10722, 378, 223, 7, 70, "ExampleSection",
 CellID->16500],
Cell[CellGroupData[{
Cell[10970, 389, 288, 9, 70, "Input",
 CellID->18880],
Cell[11261, 400, 952, 24, 146, "Output",
 CellID->583349032]
}, Open  ]],
Cell[12228, 427, 120, 3, 70, "ExampleDelimiter",
 CellID->1341],
Cell[12351, 432, 216, 7, 70, "ExampleText",
 CellID->18261],
Cell[CellGroupData[{
Cell[12592, 443, 366, 13, 70, "Input",
 CellID->28241],
Cell[12961, 458, 447, 11, 36, "Output",
 CellID->7582719]
}, Open  ]],
Cell[13423, 472, 121, 3, 70, "ExampleDelimiter",
 CellID->31689],
Cell[13547, 477, 211, 6, 70, "ExampleText",
 CellID->25573],
Cell[CellGroupData[{
Cell[13783, 487, 278, 9, 70, "Input",
 CellID->3908],
Cell[14064, 498, 299, 9, 36, "Output",
 CellID->6092005]
}, Open  ]],
Cell[CellGroupData[{
Cell[14400, 512, 254, 9, 70, "Input",
 CellID->3950],
Cell[14657, 523, 301, 9, 36, "Output",
 CellID->176017762]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15019, 539, 311, 9, 70, "SeeAlsoSection",
 CellID->20873],
Cell[15333, 550, 1479, 53, 70, "SeeAlso",
 CellID->29404]
}, Open  ]],
Cell[CellGroupData[{
Cell[16849, 608, 314, 9, 70, "TutorialsSection",
 CellID->11444],
Cell[17166, 619, 198, 4, 70, "Tutorials",
 CellID->23022]
}, Open  ]],
Cell[CellGroupData[{
Cell[17401, 628, 321, 9, 70, "RelatedLinksSection",
 CellID->29073],
Cell[17725, 639, 365, 12, 70, "RelatedLinks"],
Cell[18093, 653, 176, 4, 70, "RelatedLinks"],
Cell[18272, 659, 204, 4, 70, "RelatedLinks"],
Cell[18479, 665, 388, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18904, 683, 318, 9, 70, "MoreAboutSection",
 CellID->89077718],
Cell[19225, 694, 144, 3, 70, "MoreAbout",
 CellID->55753898],
Cell[19372, 699, 154, 3, 70, "MoreAbout",
 CellID->10178340],
Cell[19529, 704, 137, 3, 70, "MoreAbout",
 CellID->137510948],
Cell[19669, 709, 161, 3, 70, "MoreAbout",
 CellID->22430193],
Cell[19833, 714, 136, 3, 70, "MoreAbout",
 CellID->34032229],
Cell[19972, 719, 160, 3, 70, "MoreAbout",
 CellID->232133234]
}, Open  ]],
Cell[20147, 725, 27, 0, 70, "History"],
Cell[20177, 727, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

