(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12185,        441]
NotebookOptionsPosition[      8989,        330]
NotebookOutlinePosition[     10292,        367]
CellTagsIndexPosition[     10207,        362]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Characters in Strings" :> 
          Documentation`HelpLookup["paclet:tutorial/CharactersInStrings"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Characters in Strings\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LetterQ" :> Documentation`HelpLookup["paclet:ref/LetterQ"], 
          "Number" :> Documentation`HelpLookup["paclet:ref/Number"], 
          "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"LetterQ\"\>", 2->"\<\"Number\"\>", 
       3->"\<\"StringExpression\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Character Operations" :> 
          Documentation`HelpLookup["paclet:guide/CharacterOperations"], 
          "Testing Expressions" :> 
          Documentation`HelpLookup["paclet:guide/TestingExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Character Operations\"\>", 
       2->"\<\"Testing Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DigitQ", "ObjectName",
 CellID->31465],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DigitQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DigitQ"], "[", 
       StyleBox["string", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if all the characters in the string are digits in the range ",
     Cell[BoxData["0"], "InlineFormula"],
     " through\[NonBreakingSpace]",
     Cell[BoxData["9"], "InlineFormula"],
     ", and yields ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23829]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->219945909],

Cell["Test whether a character is a digit:", "ExampleText",
 CellID->22734],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DigitQ", "[", "\"\<5\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13384],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10215]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DigitQ", "[", "\"\<.\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24022],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24787]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1842],

Cell["Test whether all characters in a string are digits:", "ExampleText",
 CellID->26022],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DigitQ", "[", "\"\<02553352000242\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18316],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10122]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26271],

Cell["Only ordinary digit characters are treated as digits:", "ExampleText",
 CellID->3871],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"Characters", "[", 
    RowBox[{"FromCharacterCode", "[", 
     RowBox[{"Range", "[", 
      RowBox[{
       RowBox[{"2", "^", "16"}], "-", "1"}], "]"}], "]"}], "]"}], ",", 
   "DigitQ"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14904],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"0\"\>", ",", "\<\"1\"\>", ",", "\<\"2\"\>", ",", "\<\"3\"\>", 
   ",", "\<\"4\"\>", ",", "\<\"5\"\>", ",", "\<\"6\"\>", ",", "\<\"7\"\>", 
   ",", "\<\"8\"\>", ",", "\<\"9\"\>"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->896477952]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27883],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LetterQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LetterQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Number",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Number"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30749]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2650],

Cell[TextData[ButtonBox["Characters in Strings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CharactersInStrings"]], "Tutorials",
 CellID->16736]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->3398956],

Cell[TextData[ButtonBox["Character Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CharacterOperations"]], "MoreAbout",
 CellID->8653129],

Cell[TextData[ButtonBox["Testing Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TestingExpressions"]], "MoreAbout",
 CellID->22036720]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DigitQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 18.9924996}", "context" -> "System`", 
    "keywords" -> {"strings consisting of numbers", "test if a digit"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "DigitQ[string] yields True if all the characters in the string are \
digits in the range 0 through 9, and yields False otherwise. ", 
    "synonyms" -> {"digit q"}, "title" -> "DigitQ", "type" -> "Symbol", "uri" -> 
    "ref/DigitQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3735, 114, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10072, 355}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2089, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2712, 77, 44, 1, 70, "ObjectName",
 CellID->31465],
Cell[2759, 80, 939, 29, 70, "Usage",
 CellID->23829]
}, Open  ]],
Cell[CellGroupData[{
Cell[3735, 114, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4112, 128, 148, 5, 70, "ExampleSection",
 CellID->219945909],
Cell[4263, 135, 75, 1, 70, "ExampleText",
 CellID->22734],
Cell[CellGroupData[{
Cell[4363, 140, 106, 3, 28, "Input",
 CellID->13384],
Cell[4472, 145, 157, 5, 36, "Output",
 CellID->10215]
}, Open  ]],
Cell[CellGroupData[{
Cell[4666, 155, 106, 3, 28, "Input",
 CellID->24022],
Cell[4775, 160, 158, 5, 36, "Output",
 CellID->24787]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4982, 171, 215, 7, 70, "ExampleSection",
 CellID->1842],
Cell[5200, 180, 90, 1, 70, "ExampleText",
 CellID->26022],
Cell[CellGroupData[{
Cell[5315, 185, 119, 3, 70, "Input",
 CellID->18316],
Cell[5437, 190, 157, 5, 36, "Output",
 CellID->10122]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[5643, 201, 233, 7, 70, "ExampleSection",
 CellID->26271],
Cell[5879, 210, 91, 1, 70, "ExampleText",
 CellID->3871],
Cell[CellGroupData[{
Cell[5995, 215, 305, 10, 70, "Input",
 CellID->14904],
Cell[6303, 227, 372, 9, 36, "Output",
 CellID->896477952]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6736, 243, 311, 9, 70, "SeeAlsoSection",
 CellID->27883],
Cell[7050, 254, 706, 26, 70, "SeeAlso",
 CellID->30749]
}, Open  ]],
Cell[CellGroupData[{
Cell[7793, 285, 313, 9, 70, "TutorialsSection",
 CellID->2650],
Cell[8109, 296, 151, 3, 70, "Tutorials",
 CellID->16736]
}, Open  ]],
Cell[CellGroupData[{
Cell[8297, 304, 317, 9, 70, "MoreAboutSection",
 CellID->3398956],
Cell[8617, 315, 149, 3, 70, "MoreAbout",
 CellID->8653129],
Cell[8769, 320, 148, 3, 70, "MoreAbout",
 CellID->22036720]
}, Open  ]],
Cell[8932, 326, 27, 0, 70, "History"],
Cell[8962, 328, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

