(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25030,        923]
NotebookOptionsPosition[     19529,        727]
NotebookOutlinePosition[     20862,        765]
CellTagsIndexPosition[     20777,        760]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vectors and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/VectorsAndMatrices"], 
          "Scalars, Vectors and Matrices" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ScalarsVectorsAndMatrices"], "Nested Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/NestedLists"], "Tensors" :> 
          Documentation`HelpLookup["paclet:tutorial/Tensors"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Vectors and Matrices\"\>", 
       2->"\<\"Scalars, Vectors and Matrices\"\>", 3->"\<\"Nested Lists\"\>", 
       4->"\<\"Tensors\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ArrayDepth" :> 
          Documentation`HelpLookup["paclet:ref/ArrayDepth"], "VectorQ" :> 
          Documentation`HelpLookup["paclet:ref/VectorQ"], "MatrixQ" :> 
          Documentation`HelpLookup["paclet:ref/MatrixQ"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ArrayDepth\"\>", 2->"\<\"VectorQ\"\>", 
       3->"\<\"MatrixQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"], 
          "Handling Arrays of Data" :> 
          Documentation`HelpLookup["paclet:guide/HandlingArraysOfData"], 
          "Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Parts of Matrices" :> 
          Documentation`HelpLookup["paclet:guide/PartsOfMatrices"], "Tensors" :> 
          Documentation`HelpLookup["paclet:guide/Tensors"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Elements of Lists\"\>", 
       2->"\<\"Handling Arrays of Data\"\>", 
       3->"\<\"Matrices and Linear Algebra\"\>", 
       4->"\<\"Parts of Matrices\"\>", 
       5->"\<\"Tensors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Dimensions", "ObjectName",
 CellID->28615],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Dimensions",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Dimensions"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the dimensions of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Dimensions",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Dimensions"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the dimensions of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " down to level ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->21256]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " must be a ",
 StyleBox["full array",
  FontSlant->"Italic"],
 ", with all the pieces of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " at a particular level having the same length. (The elements of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " can then be thought of as filling up a hyper\[Hyphen]rectangular region.) \
"
}], "Notes",
 CellID->11928],

Cell[TextData[{
 "Each successive level in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " sampled by ",
 Cell[BoxData[
  ButtonBox["Dimensions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dimensions"]], "InlineFormula"],
 " must have the same head. "
}], "Notes",
 CellID->14115],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects, ",
 Cell[BoxData[
  ButtonBox["Dimensions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dimensions"]], "InlineFormula"],
 " yields the dimensions of the corresponding ordinary lists. "
}], "Notes",
 CellID->2619]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->24080289],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->204891138],

Cell["Dimensions of a matrix:", "ExampleText",
 CellID->3217],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "e", ",", "f"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26068],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13235]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20032],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dimensions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dimensions"]], "InlineFormula"],
 " counts only dimensions at which an expression is not \
\[OpenCurlyDoubleQuote]ragged",
 "\[CloseCurlyDoubleQuote]",
 ":"
}], "ExampleText",
 CellID->15816],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "e"}], "}"}], ",", 
    RowBox[{"{", "f", "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17691],

Cell[BoxData[
 RowBox[{"{", "3", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13197]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2146],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dimensions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dimensions"]], "InlineFormula"],
 " works with arrays of any depth:"
}], "ExampleText",
 CellID->24853],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], "}"}], "}"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27223],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "1", ",", "2"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2478]
}, Open  ]],

Cell["Give dimensions only down to level 2:", "ExampleText",
 CellID->23233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], "}"}], "}"}], "}"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30962],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->19990]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21428],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dimensions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dimensions"]], "InlineFormula"],
 " works with any head, not just ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->14124],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"a", ",", "b"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"s", ",", "t"}], "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25981],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "2"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28489]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30425],

Cell["\<\
The \[OpenCurlyDoubleQuote]array\[CloseCurlyDoubleQuote] is considered full \
only when it has the same head as at the top:\
\>", "ExampleText",
 CellID->1984],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"g", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", 
    RowBox[{"g", "[", 
     RowBox[{"a", ",", "b"}], "]"}], ",", 
    RowBox[{"g", "[", 
     RowBox[{"s", ",", "t"}], "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23286],

Cell[BoxData[
 RowBox[{"{", "3", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6535]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5996],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dimensions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dimensions"]], "InlineFormula"],
 " works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->2662],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], "}"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24363],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "2"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{185, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15535]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8667],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "2"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1437]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26575],

Cell["\<\
Find dimensions of regions filled by 10 steps of cellular automaton \
evolution:\
\>", "ExampleText",
 CellID->27154],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Dimensions", "[", 
    RowBox[{"CellularAutomaton", "[", 
     RowBox[{"n", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "10"}], "]"}], "]"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14970],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW81OGzEQdnYJtFRtCYdCbzwDD9GeKrUcCtcIIcGhKqI8XHm6ZcchVfrF
y3j8OxstUjaeXc94PP52Yn8235aPtze/lo9318uzrw/L+9u76z9nX34/9Lfa
mTGzv8aY81PTl7u+ZD/099R/VsVV6R1d2/XTzhyB/AnkPZAPK+tz/n+s7D/K
qdtv6bJlZdFfml48ddSm+7nr46is6y8y+3McaR+j2zijS3fnvbj+Rq195jnK
b0Zu/63Q/kF/IXE+srgcKIm3G5WcFsmEeRytSc+dI3z1CBVm/u++HRv3GMZ4
599K6ZiUHqvtNwGtcHmFmxOg/vuR2/8gtG/92cJarNecF7H2ceZUOsr4fGbj
Js0qXKu7Vp+bH/thc+y9zN1+mhmEtqjWHjUXNvccmTK23bZwvyY0aqwflCk3
5P3I9nHt3hTu34RKjfWlqORmgdL2/eYDu4lNZNnobvPy+0PfRyBjrF1vdEl9
ZOtQn+zTY/z982m3fUFBiN+LQD2uvziKK+6WisjKy0u5efDcPLr2fYjcPL7V
H+Sppbx5Kp59iMfPva8Qy+P/538wf89l4VCeN5fdXHy9tv2GsfL2Nu7KeWYf
vZT2G1Gvpj2P8LhUHjUxS48rBVy/xvK5qflhnKWiv1IWXtsugjY+nou3rZ98
/Z56padtfa6NXxjbSt22L0Ydx/hqQx2+q+jvhLoK8RajjmN0taEOMzz6O6Gu
QrzFqKuzgxtrz2/GOyGwWtS92PDWoS1hdUP1XO1y7Hdt9j4FCz4YbyvEs95S
fNY+Dc61r53FP2H0f9hR4c4rlDoNPmQ/1el0af3PA/UvvKK2y6eqffwOZa1r
+RvKUvvG+XvngxofWRe7nFJP1quc7HK5XpQ+/77K+dxpIO5tceXSTVkbu+l3
RjqW8431MnVUufk+6v+0cYnNUaV5itj6fivc1GvF1Of5cjPNl10KbJCXrlWK
Rky4zgbXRkGq+NUZ/VFmhg0ZGbbaaNiNnDDO/xHh5gq1sZEnqmEI4Wrl4P5C
OTR6jIiWcH9Sf0P6uehe7+eVjToVfVg5M3sGRSJCTg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{440, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->359152729]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27460],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", 
  RowBox[{"Array", "[", 
   RowBox[{"a", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "4", ",", "3"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21763],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1", ",", "4", ",", "3"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14316]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18040],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArrayDepth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayDepth"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VectorQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VectorQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MatrixQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MatrixQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8337]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20343],

Cell[TextData[ButtonBox["Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VectorsAndMatrices"]], "Tutorials",
 CellID->30248],

Cell[TextData[ButtonBox["Scalars, Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ScalarsVectorsAndMatrices"]], "Tutorials",
 CellID->15544],

Cell[TextData[ButtonBox["Nested Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NestedLists"]], "Tutorials",
 CellID->18710],

Cell[TextData[ButtonBox["Tensors",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Tensors"]], "Tutorials",
 CellID->493403696]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->83505719],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->216755200],

Cell[TextData[ButtonBox["Handling Arrays of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HandlingArraysOfData"]], "MoreAbout",
 CellID->242354108],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->499545283],

Cell[TextData[ButtonBox["Parts of Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfMatrices"]], "MoreAbout",
 CellID->276176885],

Cell[TextData[ButtonBox["Tensors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Tensors"]], "MoreAbout",
 CellID->139892475]
}, Open  ]],

Cell["New in 1  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Dimensions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 19.2112552}", "context" -> "System`", 
    "keywords" -> {
     "array shape", "array size", "tensors", "matrix dimensions"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Dimensions[expr] gives a list of the dimensions of expr. \
Dimensions[expr, n] gives a list of the dimensions of expr down to level n. ",
     "synonyms" -> {}, "title" -> "Dimensions", "type" -> "Symbol", "uri" -> 
    "ref/Dimensions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6358, 199, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->24080289]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20635, 753}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2892, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3515, 91, 48, 1, 70, "ObjectName",
 CellID->28615],
Cell[3566, 94, 1083, 35, 70, "Usage",
 CellID->21256]
}, Open  ]],
Cell[CellGroupData[{
Cell[4686, 134, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5164, 151, 468, 15, 70, "Notes",
 CellID->11928],
Cell[5635, 168, 304, 11, 70, "Notes",
 CellID->14115],
Cell[5942, 181, 379, 13, 70, "Notes",
 CellID->2619]
}, Closed]],
Cell[CellGroupData[{
Cell[6358, 199, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->24080289],
Cell[CellGroupData[{
Cell[6742, 213, 148, 5, 70, "ExampleSection",
 CellID->204891138],
Cell[6893, 220, 61, 1, 70, "ExampleText",
 CellID->3217],
Cell[CellGroupData[{
Cell[6979, 225, 271, 9, 28, "Input",
 CellID->26068],
Cell[7253, 236, 199, 7, 36, "Output",
 CellID->13235]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7501, 249, 216, 7, 70, "ExampleSection",
 CellID->20032],
Cell[7720, 258, 297, 10, 70, "ExampleText",
 CellID->15816],
Cell[CellGroupData[{
Cell[8042, 272, 296, 10, 70, "Input",
 CellID->17691],
Cell[8341, 284, 176, 6, 36, "Output",
 CellID->13197]
}, Open  ]],
Cell[8532, 293, 120, 3, 70, "ExampleDelimiter",
 CellID->2146],
Cell[8655, 298, 209, 7, 70, "ExampleText",
 CellID->24853],
Cell[CellGroupData[{
Cell[8889, 309, 227, 8, 70, "Input",
 CellID->27223],
Cell[9119, 319, 218, 7, 36, "Output",
 CellID->2478]
}, Open  ]],
Cell[9352, 329, 76, 1, 70, "ExampleText",
 CellID->23233],
Cell[CellGroupData[{
Cell[9453, 334, 258, 10, 70, "Input",
 CellID->30962],
Cell[9714, 346, 199, 7, 36, "Output",
 CellID->19990]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9962, 359, 239, 7, 70, "ExampleSection",
 CellID->21428],
Cell[10204, 368, 325, 12, 70, "ExampleText",
 CellID->14124],
Cell[CellGroupData[{
Cell[10554, 384, 332, 11, 70, "Input",
 CellID->25981],
Cell[10889, 397, 199, 7, 36, "Output",
 CellID->28489]
}, Open  ]],
Cell[11103, 407, 121, 3, 70, "ExampleDelimiter",
 CellID->30425],
Cell[11227, 412, 169, 4, 70, "ExampleText",
 CellID->1984],
Cell[CellGroupData[{
Cell[11421, 420, 332, 11, 70, "Input",
 CellID->23286],
Cell[11756, 433, 175, 6, 36, "Output",
 CellID->6535]
}, Open  ]],
Cell[11946, 442, 120, 3, 70, "ExampleDelimiter",
 CellID->5996],
Cell[12069, 447, 327, 12, 70, "ExampleText",
 CellID->2662],
Cell[CellGroupData[{
Cell[12421, 463, 201, 7, 70, "Input",
 CellID->24363],
Cell[12625, 472, 485, 17, 36, "Output",
 CellID->15535]
}, Open  ]],
Cell[CellGroupData[{
Cell[13147, 494, 101, 3, 70, "Input",
 CellID->8667],
Cell[13251, 499, 208, 7, 36, "Output",
 CellID->1437]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13508, 512, 223, 7, 70, "ExampleSection",
 CellID->26575],
Cell[13734, 521, 127, 4, 70, "ExampleText",
 CellID->27154],
Cell[CellGroupData[{
Cell[13886, 529, 379, 13, 70, "Input",
 CellID->14970],
Cell[14268, 544, 1293, 25, 70, "Output",
 Evaluatable->False,
 CellID->359152729]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15610, 575, 233, 7, 70, "ExampleSection",
 CellID->27460],
Cell[CellGroupData[{
Cell[15868, 586, 232, 8, 70, "Input",
 CellID->21763],
Cell[16103, 596, 219, 7, 36, "Output",
 CellID->14316]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16383, 610, 311, 9, 70, "SeeAlsoSection",
 CellID->18040],
Cell[16697, 621, 695, 26, 70, "SeeAlso",
 CellID->8337]
}, Open  ]],
Cell[CellGroupData[{
Cell[17429, 652, 314, 9, 70, "TutorialsSection",
 CellID->20343],
Cell[17746, 663, 149, 3, 70, "Tutorials",
 CellID->30248],
Cell[17898, 668, 165, 3, 70, "Tutorials",
 CellID->15544],
Cell[18066, 673, 134, 3, 70, "Tutorials",
 CellID->18710],
Cell[18203, 678, 129, 3, 70, "Tutorials",
 CellID->493403696]
}, Open  ]],
Cell[CellGroupData[{
Cell[18369, 686, 318, 9, 70, "MoreAboutSection",
 CellID->83505719],
Cell[18690, 697, 144, 3, 70, "MoreAbout",
 CellID->216755200],
Cell[18837, 702, 155, 3, 70, "MoreAbout",
 CellID->242354108],
Cell[18995, 707, 163, 3, 70, "MoreAbout",
 CellID->499545283],
Cell[19161, 712, 144, 3, 70, "MoreAbout",
 CellID->276176885],
Cell[19308, 717, 126, 3, 70, "MoreAbout",
 CellID->139892475]
}, Open  ]],
Cell[19449, 723, 50, 0, 70, "History"],
Cell[19502, 725, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

