(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    134835,       4140]
NotebookOptionsPosition[    117652,       3538]
NotebookOutlinePosition[    119148,       3578]
CellTagsIndexPosition[    119061,       3573]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Generalized Functions and Related Objects" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GeneralizedFunctionsAndRelatedObjects"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Generalized Functions and Related Objects\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"HeavisideTheta" :> 
          Documentation`HelpLookup["paclet:ref/HeavisideTheta"], "If" :> 
          Documentation`HelpLookup["paclet:ref/If"], "PrincipalValue" :> 
          Documentation`HelpLookup["paclet:ref/PrincipalValue"], "Limit" :> 
          Documentation`HelpLookup["paclet:ref/Limit"], "KroneckerDelta" :> 
          Documentation`HelpLookup["paclet:ref/KroneckerDelta"], 
          "DiscreteDelta" :> 
          Documentation`HelpLookup["paclet:ref/DiscreteDelta"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"HeavisideTheta\"\>", 
       2->"\<\"If\"\>", 3->"\<\"PrincipalValue\"\>", 4->"\<\"Limit\"\>", 
       5->"\<\"KroneckerDelta\"\>", 
       6->"\<\"DiscreteDelta\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calculus" :> Documentation`HelpLookup["paclet:guide/Calculus"],
           "Generalized Functions" :> 
          Documentation`HelpLookup["paclet:guide/GeneralizedFunctions"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Calculus\"\>", 
       2->"\<\"Generalized Functions\"\>", 
       3->"\<\"Mathematical Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DiracDelta", "ObjectName",
 CellID->7985],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DiracDelta",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DiracDelta"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the Dirac delta function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Delta]", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DiracDelta",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DiracDelta"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the multidimensional Dirac delta function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Delta]", "(", 
        RowBox[{
         SubscriptBox["x", "1"], ",", 
         SubscriptBox["x", "2"], ",", "\[Ellipsis]"}], ")"}], 
       TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->17684]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DiracDelta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DiracDelta"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " returns ",
 Cell[BoxData["0"], "InlineFormula"],
 " for all numeric ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " other than ",
 Cell[BoxData["0"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23301],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DiracDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiracDelta"]], "InlineFormula"],
 " can be used in integrals, integral transforms and differential equations. \
"
}], "Notes",
 CellID->24535],

Cell[TextData[{
 "Some transformations are done automatically when ",
 Cell[BoxData[
  ButtonBox["DiracDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiracDelta"]], "InlineFormula"],
 " appears in a product of terms. "
}], "Notes",
 CellID->9502],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DiracDelta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DiracDelta"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " returns 0 if any of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are numeric and not ",
 Cell[BoxData["0"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8963],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DiracDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiracDelta"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["Orderless",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orderless"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9564],

Cell[TextData[{
 "For exact numeric quantities, ",
 Cell[BoxData[
  ButtonBox["DiracDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiracDelta"]], "InlineFormula"],
 " internally uses numerical approximations to establish its result. This \
process can be affected by the setting of the global variable ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15012]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->249641545],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->88478720],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"DiracDelta", "[", "x", "]"}], " ", 
    RowBox[{"Cos", "[", "x", "]"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"-", "Infinity"}], ",", " ", "Infinity"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49659756],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->535207307]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->46207547],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracDelta", "[", "1", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->506048238],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->173416507]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DiracDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiracDelta"]], "InlineFormula"],
 " stays unevaluated for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[LongEqual]", "0"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->572194292],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracDelta", "[", "0", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->56255554],

Cell[BoxData[
 RowBox[{"DiracDelta", "[", "0", "]"}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->48912880]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->291610979],

Cell["Canonicalize arguments:", "ExampleText",
 CellID->3561391],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"DiracDelta", "[", 
   RowBox[{
    RowBox[{"x", "^", "5"}], "-", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->296958439],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "5"], " ", 
  RowBox[{"DiracDelta", "[", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}], "]"}]}]], "Output",
 ImageSize->{137, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5806625]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7507],

Cell[TextData[{
 "Integrate integrands containing ",
 Cell[BoxData[
  ButtonBox["DiracDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiracDelta"]], "InlineFormula"],
 " over infinite and finite domains:"
}], "ExampleText",
 CellID->1031947],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"DiracDelta", "[", 
     RowBox[{"x", "-", "a"}], "]"}], " ", 
    RowBox[{"f", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"a", "\[Element]", "Reals"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->399314628],

Cell[BoxData[
 RowBox[{"f", "[", "a", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->707264772]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"DiracDelta", "[", 
    RowBox[{"x", "-", "a"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"Assumptions", " ", "->", " ", 
    RowBox[{
     RowBox[{"Element", "[", 
      RowBox[{"a", ",", " ", "Reals"}], "]"}], "&&", 
     RowBox[{"b", " ", "<", " ", "c"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->92770994],

Cell[BoxData[
 RowBox[{
  RowBox[{"HeavisideTheta", "[", 
   RowBox[{"a", "-", "b"}], "]"}], " ", 
  RowBox[{"HeavisideTheta", "[", 
   RowBox[{
    RowBox[{"-", "a"}], "+", "c"}], "]"}]}]], "Output",
 ImageSize->{292, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->355604880]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"DiracDelta", "[", 
    RowBox[{"x", "-", "a"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "b", ",", "c"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Assumptions", " ", "->", " ", 
    RowBox[{"Element", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", " ", "Reals"}], 
     "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->99766472],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"HeavisideTheta", "[", 
      RowBox[{
       RowBox[{"-", "b"}], "+", "c"}], "]"}]}]}], ")"}], " ", 
  RowBox[{"HeavisideTheta", "[", 
   RowBox[{"a", "-", 
    RowBox[{"c", " ", 
     RowBox[{"HeavisideTheta", "[", 
      RowBox[{"b", "-", "c"}], "]"}]}], "-", 
    RowBox[{"b", " ", 
     RowBox[{"HeavisideTheta", "[", 
      RowBox[{
       RowBox[{"-", "b"}], "+", "c"}], "]"}]}]}], "]"}], " ", 
  RowBox[{"HeavisideTheta", "[", 
   RowBox[{
    RowBox[{"-", "a"}], "+", 
    RowBox[{"b", " ", 
     RowBox[{"HeavisideTheta", "[", 
      RowBox[{"b", "-", "c"}], "]"}]}], "+", 
    RowBox[{"c", " ", 
     RowBox[{"HeavisideTheta", "[", 
      RowBox[{
       RowBox[{"-", "b"}], "+", "c"}], "]"}]}]}], "]"}]}]], "Output",
 ImageSize->{468, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->338046146]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->271162569],

Cell[TextData[{
 "Integrate expressions containing derivatives of ",
 Cell[BoxData[
  ButtonBox["DiracDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiracDelta"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->62712159],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"DiracDelta", "'''"}], "[", 
     RowBox[{"x", "-", "a"}], "]"}], " ", 
    RowBox[{"f", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"a", "\[Element]", "Reals"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->819314460],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   SuperscriptBox["f", 
    TagBox[
     RowBox[{"(", "3", ")"}],
     Derivative],
    MultilineFunction->None], "[", "a", "]"}]}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->364293150]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->554184098],

Cell["Interpret as the indefinite integral for real arguments:", "ExampleText",
 CellID->45844422],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"DiracDelta", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50930038],

Cell[BoxData[
 RowBox[{"HeavisideTheta", "[", "x", "]"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->146680573]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->70205023],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->173502],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DiracDelta", "[", "x", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->385997720],

Cell[BoxData[
 FormBox[
  RowBox[{
   InterpretationBox["\[Delta]",
    DiracDelta,
    Editable->False,
    Selectable->False], "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{23, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->159635163]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6349],

Cell[TextData[{
 "Multivariate ",
 Cell[BoxData[
  ButtonBox["DiracDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiracDelta"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->65634992],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracDelta", "[", 
  RowBox[{"1", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->512770906],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->141571282]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->161664622],

Cell[TextData[{
 "Differentiate the multivariate ",
 Cell[BoxData[
  ButtonBox["DiracDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiracDelta"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->963595505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"DiracDelta", "[", 
    RowBox[{"x", ",", 
     RowBox[{"f", "[", "y", "]"}], ",", "z"}], "]"}], ",", "y"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->428676162],

Cell[BoxData[
 RowBox[{
  RowBox[{"DiracDelta", "[", "x", "]"}], " ", 
  RowBox[{"DiracDelta", "[", "z", "]"}], " ", 
  RowBox[{
   SuperscriptBox["DiracDelta", "\[Prime]",
    MultilineFunction->None], "[", 
   RowBox[{"f", "[", "y", "]"}], "]"}], " ", 
  RowBox[{
   SuperscriptBox["f", "\[Prime]",
    MultilineFunction->None], "[", "y", "]"}]}]], "Output",
 ImageSize->{342, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11278327]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11350],

Cell["Find classical harmonic oscillator Green function:", "ExampleText",
 CellID->287492792],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"gf", "[", "z_", "]"}], "=", 
  RowBox[{
   RowBox[{"w", "[", "z", "]"}], "/.", 
   RowBox[{
    RowBox[{"DSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"w", "''"}], "[", "z", "]"}], "+", 
          RowBox[{
           SuperscriptBox["k", "2"], " ", 
           RowBox[{"w", "[", "z", "]"}]}]}], "==", 
         RowBox[{"DiracDelta", "[", "z", "]"}]}], ",", 
        RowBox[{
         RowBox[{"w", "[", "0", "]"}], "==", "0"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"w", "'"}], "[", "0", "]"}], "==", "1"}]}], "}"}], ",", 
      RowBox[{"w", "[", "z", "]"}], ",", "z"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->86268258],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"HeavisideTheta", "[", "z", "]"}], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"k", " ", "z"}], "]"}]}], "k"]], "Output",
 ImageSize->{183, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->98535972]
}, Open  ]],

Cell["\<\
Solve the inhomogeneous ODE through convolution with the Green's function:\
\>", "ExampleText",
 CellID->630427126],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ds", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"gf", "[", 
      RowBox[{"z", "-", "\[Zeta]"}], "]"}], 
     RowBox[{"Exp", "[", 
      RowBox[{"-", "\[Zeta]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Zeta]", ",", "0", ",", "z"}], "}"}], ",", 
    RowBox[{"Assumptions", "->", 
     RowBox[{"z", ">", "0"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4400197],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "z"}]], " ", "k"}], "-", 
   RowBox[{"k", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"k", " ", "z"}], "]"}]}], "+", 
   RowBox[{"Sin", "[", 
    RowBox[{"k", " ", "z"}], "]"}]}], 
  RowBox[{"k", "+", 
   SuperscriptBox["k", "3"]}]]], "Output",
 ImageSize->{175, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->622019414]
}, Open  ]],

Cell[TextData[{
 "Compare with the direct result from ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->669087629],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"gf", "[", "z_", "]"}], "=", 
  RowBox[{
   RowBox[{
    RowBox[{"w", "[", "z", "]"}], "/.", 
    RowBox[{"First", "[", 
     RowBox[{"DSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"w", "''"}], "[", "z", "]"}], "+", 
           RowBox[{
            SuperscriptBox["k", "2"], " ", 
            RowBox[{"w", "[", "z", "]"}]}]}], "==", 
          RowBox[{"Exp", "[", 
           RowBox[{"-", "z"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"w", "[", "0", "]"}], "==", "0"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"w", "'"}], "[", "0", "]"}], "==", "0"}]}], "}"}], ",", 
       " ", 
       RowBox[{"w", "[", "z", "]"}], ",", "z"}], "]"}], "]"}]}], " ", "//", 
   "Simplify"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->37487348],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "z"}]], " ", "k"}], "-", 
   RowBox[{"k", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"k", " ", "z"}], "]"}]}], "+", 
   RowBox[{"Sin", "[", 
    RowBox[{"k", " ", "z"}], "]"}]}], 
  RowBox[{"k", "+", 
   SuperscriptBox["k", "3"]}]]], "Output",
 ImageSize->{175, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->215100142]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->733192504],

Cell["Define a functional derivative:", "ExampleText",
 CellID->241292424],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptCapitalD]", "[", 
   RowBox[{"functional_", ",", " ", 
    RowBox[{"f_", "[", "y_", "]"}]}], "]"}], " ", ":=", " ", 
  RowBox[{"Assuming", "[", " ", 
   RowBox[{
    RowBox[{"Element", "[", 
     RowBox[{"y", ",", " ", "Reals"}], "]"}], ",", " ", "\n", " ", 
    RowBox[{"Limit", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"functional", " ", "/.", " ", 
           RowBox[{"f", " ", ":>", " ", 
            RowBox[{"Function", "[", 
             RowBox[{"x", ",", " ", 
              RowBox[{
               RowBox[{"f", "[", "x", "]"}], " ", "+", " ", "\n", 
               "                ", 
               RowBox[{"\[CurlyEpsilon]", " ", 
                RowBox[{"DiracDelta", "[", 
                 RowBox[{"x", " ", "-", " ", "y"}], "]"}]}]}]}], "]"}]}]}], 
          ")"}], " ", "-", " ", "functional"}], ")"}], "/", 
       "\[CurlyEpsilon]"}], ",", 
      RowBox[{"\[CurlyEpsilon]", "->", "0"}]}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->272474856],

Cell["\<\
Calculate the functional derivative for an example functional:\
\>", "ExampleText",
 CellID->911473740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptCapitalD]", "[", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"f", "[", "x", "]"}], "2"], ",", " ", 
    RowBox[{"f", "[", "y", "]"}]}], "]"}], " "}]], "Input",
 CellLabel->"In[2]:=",
 CellID->223832199],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"DiracDelta", "[", 
   RowBox[{"x", "-", "y"}], "]"}], " ", 
  RowBox[{"f", "[", "x", "]"}]}]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5857789]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->145309049],

Cell["Calculate the phase space volume of a harmonic oscillator:", \
"ExampleText",
 CellID->142082126],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"DiracDelta", "[", 
    RowBox[{
     RowBox[{"q", "^", "2"}], "+", 
     RowBox[{"p", "^", "2"}], "-", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->447417020],

Cell[BoxData["\[Pi]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->889378419]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->329460098],

Cell["\<\
Find the distribution for the third power of a normally distributed random \
variable:\
\>", "ExampleText",
 CellID->384138054],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"PDF", "[", 
     RowBox[{
      RowBox[{"NormalDistribution", "[", 
       RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "x"}], "]"}], 
    RowBox[{"DiracDelta", "[", 
     RowBox[{
      RowBox[{"x", "^", "3"}], "-", "y"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{
     RowBox[{"\[Mu]", "\[Element]", "Reals"}], "&&", 
     RowBox[{"\[Sigma]", ">", "0"}], "&&", 
     RowBox[{"y", "\[Element]", "Reals"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30784595],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["y", 
          RowBox[{"1", "/", "3"}]], "-", "\[Mu]"}], ")"}], "2"], 
      RowBox[{"2", " ", 
       SuperscriptBox["\[Sigma]", "2"]}]]}]], "+", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], 
           RowBox[{"1", "/", "3"}]], " ", 
          SuperscriptBox["y", 
           RowBox[{"1", "/", "3"}]]}], "+", "\[Mu]"}], ")"}], "2"], 
      RowBox[{"2", " ", 
       SuperscriptBox["\[Sigma]", "2"]}]]}]], "+", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], 
            RowBox[{"2", "/", "3"}]]}], " ", 
          SuperscriptBox["y", 
           RowBox[{"1", "/", "3"}]]}], "+", "\[Mu]"}], ")"}], "2"], 
      RowBox[{"2", " ", 
       SuperscriptBox["\[Sigma]", "2"]}]]}]]}], 
  RowBox[{"3", " ", 
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]], " ", "\[Sigma]", " ", 
   SuperscriptBox[
    RowBox[{"Abs", "[", "y", "]"}], 
    RowBox[{"2", "/", "3"}]]}]]], "Output",
 ImageSize->{298, 58},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->257505318]
}, Open  ]],

Cell["Plot the resulting PDF:", "ExampleText",
 CellID->274289697],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"%", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Mu]", "->", "0"}], ",", 
      RowBox[{"\[Sigma]", "->", "1"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->185633906],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->266563303]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->99550026],

Cell[TextData[{
 "Fundamental solution of the Klein\[Dash]Gordon operator ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Delta]", 
     RowBox[{"t", " ", "t"}]], "-", "\[CapitalDelta]", "+", 
    SuperscriptBox["m", "2"]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->109021056],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptCapitalD]", "[", 
   RowBox[{"t_", ",", " ", "x_List"}], "]"}], " ", ":=", 
  RowBox[{
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", "\[Pi]"}]], 
    RowBox[{"HeavisideTheta", "[", "t", "]"}], 
    RowBox[{"DiracDelta", "[", 
     RowBox[{
      SuperscriptBox["t", "2"], "-", 
      RowBox[{"x", ".", "x"}]}], "]"}]}], "-", 
   RowBox[{
    FractionBox["m", 
     RowBox[{"4", "\[Pi]"}]], 
    RowBox[{"HeavisideTheta", "[", 
     RowBox[{"t", "-", 
      SqrtBox[
       RowBox[{"x", ".", "x"}]]}], "]"}], 
    FractionBox[
     RowBox[{"BesselJ", "[", 
      RowBox[{"1", ",", 
       RowBox[{"m", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["t", "2"], "-", 
          RowBox[{"x", ".", "x"}]}]]}]}], "]"}], 
     SqrtBox[
      RowBox[{
       SuperscriptBox["t", "2"], "-", 
       RowBox[{"x", ".", "x"}]}]]]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49554612],

Cell["\<\
Visualize the fundamental solution. It is nonvanishing only in the forward \
light cone:\
\>", "ExampleText",
 CellID->339947024],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"\[ScriptCapitalD]", "[", 
      RowBox[{"t", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "z"}], "}"}]}], "]"}]}], "/.", 
    RowBox[{"m", "\[Rule]", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "3"}], ",", "3.02"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "3"}], ",", "3.01"}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"t", "^", "2"}], "\[Equal]", 
        RowBox[{"z", "^", "2"}]}], ",", 
       RowBox[{"t", "\[GreaterEqual]", "0"}]}], "}"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->141472592],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot3D", "::", "\<\"nlnum\"\>"}], ":", 
  " ", "\<\"The function value \\!\\({Indeterminate}\\) is not a list of \
numbers with dimensions \\!\\({1}\\) at \\!\\({z, t}\\) = \\!\\({3.`, \
\\(\\(-3.`\\)\\)}\\).\"\>"}]], "Message", "MSG",
 CellID->698226120],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot3D", "::", "\<\"nlnum\"\>"}], ":", 
  " ", "\<\"The function value \\!\\({Indeterminate}\\) is not a list of \
numbers with dimensions \\!\\({1}\\) at \\!\\({z, t}\\) = \
\\!\\({\\(\\(-2.785178719866999`\\)\\), \
\\(\\(-2.785178719866999`\\)\\)}\\).\"\>"}]], "Message", "MSG",
 CellID->140816110],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot3D", "::", "\<\"nlnum\"\>"}], ":", 
  " ", "\<\"The function value \\!\\({Indeterminate}\\) is not a list of \
numbers with dimensions \\!\\({1}\\) at \\!\\({z, t}\\) = \
\\!\\({2.795170407315046`, \\(\\(-2.795170407315046`\\)\\)}\\).\"\>"}]], \
"Message", "MSG",
 CellID->65275024],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"stop\"\>"}], ":", 
  " ", "\<\"Further output of \\!\\(Plot3D :: \\\"nlnum\\\"\\) will be \
suppressed during this calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\
\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->29507986],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 227},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->179317038]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->87989254],

Cell["\<\
A cusp\[Hyphen]containing solution of the Camassa\[Dash]Holm equation:\
\>", "ExampleText",
 CellID->1547553],

Cell[BoxData[
 RowBox[{
  RowBox[{"chOp", "[", 
   RowBox[{"x_", ",", "t_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[PartialD]", "t"], "#"}], "-", 
     RowBox[{
      SubscriptBox["\[PartialD]", 
       RowBox[{"x", ",", "x", ",", "t"}]], "#"}], "+", 
     RowBox[{"3", " ", "#", " ", 
      RowBox[{
       SubscriptBox["\[PartialD]", "x"], "#"}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{
       SubscriptBox["\[PartialD]", "x"], "#"}], " ", 
      RowBox[{
       SubscriptBox["\[PartialD]", 
        RowBox[{"x", ",", "x"}]], "#"}]}], "-", 
     RowBox[{"#", " ", 
      RowBox[{
       SubscriptBox["\[PartialD]", 
        RowBox[{"x", ",", "x", ",", "x"}]], "#"}]}]}], ")"}], 
   "&"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38711986],

Cell[BoxData[
 RowBox[{
  RowBox[{"u", "[", 
   RowBox[{"x_", ",", " ", "t_"}], "]"}], " ", ":=", " ", 
  RowBox[{"Exp", "[", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{"x", "-", "t"}], ")"}]}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"HeavisideTheta", "[", 
       RowBox[{"x", "-", "t"}], "]"}], "-", 
      RowBox[{"HeavisideTheta", "[", 
       RowBox[{"t", "-", "x"}], "]"}]}], ")"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->68162009],

Cell[TextData[{
 "Higher derivatives will contain ",
 Cell[BoxData[
  ButtonBox["DiracDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiracDelta"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->279166185],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"u", "[", 
     RowBox[{"x", ",", " ", "t"}], "]"}], ",", "x", ",", "x"}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->375509904],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"t", "-", "x"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"HeavisideTheta", "[", 
         RowBox[{"t", "-", "x"}], "]"}]}], "+", 
       RowBox[{"HeavisideTheta", "[", 
        RowBox[{
         RowBox[{"-", "t"}], "+", "x"}], "]"}]}], ")"}]}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"t", "-", "x"}], ")"}], " ", 
       RowBox[{"DiracDelta", "[", 
        RowBox[{"t", "-", "x"}], "]"}]}], "+", 
      RowBox[{"HeavisideTheta", "[", 
       RowBox[{"t", "-", "x"}], "]"}], "-", 
      RowBox[{"HeavisideTheta", "[", 
       RowBox[{
        RowBox[{"-", "t"}], "+", "x"}], "]"}]}], ")"}], "2"]}], "+", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"t", "-", "x"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"HeavisideTheta", "[", 
         RowBox[{"t", "-", "x"}], "]"}]}], "+", 
       RowBox[{"HeavisideTheta", "[", 
        RowBox[{
         RowBox[{"-", "t"}], "+", "x"}], "]"}]}], ")"}]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"DiracDelta", "[", 
       RowBox[{"t", "-", "x"}], "]"}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"DiracDelta", "[", 
       RowBox[{
        RowBox[{"-", "t"}], "+", "x"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"t", "-", "x"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{
          SuperscriptBox["DiracDelta", "\[Prime]",
           MultilineFunction->None], "[", 
          RowBox[{"t", "-", "x"}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["DiracDelta", "\[Prime]",
          MultilineFunction->None], "[", 
         RowBox[{
          RowBox[{"-", "t"}], "+", "x"}], "]"}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 ImageSize->{522, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->818936838]
}, Open  ]],

Cell["Plot the solution and its derivative:", "ExampleText",
 CellID->405639488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Plot3D", "[", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", " ", "t"}], "]"}], " ", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "3"}], "}"}]}], "]"}], ",", 
    RowBox[{"Plot3D", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"x", ",", " ", "t"}], "]"}], ",", "x", ",", "t"}], "]"}], 
       "]"}], " ", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "3"}], "}"}]}], "]"}]}], "}"}], "//", 
  "Quiet"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->125312260],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->64254157]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13787062],

Cell["\<\
Differentiate and integrate a piecewise defined function in a lossless \
manner:\
\>", "ExampleText",
 CellID->91664871],

Cell[BoxData[
 RowBox[{
  RowBox[{"pwF", "[", "x_", "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"HeavisideTheta", "[", 
     RowBox[{"x", "-", "1"}], "]"}]}], "-", 
   RowBox[{"2", 
    RowBox[{"HeavisideTheta", "[", 
     RowBox[{
      RowBox[{"-", "x"}], "-", "1"}], "]"}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->122419067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"pwF", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->172123373],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWc1OwkAQXmgRvXgUDx4QFQr6CoSDUU8e9WRMKjGBg2KQoyd/IsYnIDF6
Vy/G1/DkG/AEPkLdX1qnu9Si2FK3aZudnW9m52c723a37U7j8MjuNOt2fqtt
nzSa9dP8ZquNu4wUQqk5hNDLPMJtB7foRY4cvlgTts7x3cSwDKEMgXdQl3Iv
PL1IiTrjOkzAhTRDT9He1vFrrdrDJ9olN+Pp8Z2jloCUwbVfU+l9fE8/3L+t
SFD+sQS6QM1xuSpPBJ7YkEbCVhVqNUIuse4mNtZoP3UUkuUnqQBGYJ1YBlx5
xRPoBSdMnRw2hr8ehrMkHFpXw7hw/4uf0UeBzHXSWXbY02aRXhPDkTjKQK7E
JSyPBKGzVN+MBO19s7K4NV6MBWSG0UQH9MRk/QZn4yMtqT6L3F74BlXg/VQA
W8Z8rwTYBKMC8cymLM/iGuAWR4gCHKHEdbO4TwegVSOmJRkO8j0jzXSRuu3S
o+W65NMiz7aYt5UvPrjzVhUtL96dtXF42v1c4n2OegNXpLA0XN1/qu+v9SfN
nyD97hwPo3V2wqMybvt/Wz/UJ88arK5B1TYID2k26q0UVav2OL0XIUrU3bjY
E1eUjpOOpo5TMIr8rSUguB7J0ZcABb8Lxi01+KqK1DISM9m/jbjkNMnzVcdp
8lE6mkmNk2pnUF1HBQqNeQ26AiixQ8hWk/rBM99Z3KE7ixvrd/3+x0C7VNpL
dwfef2fHULV+8D8VzrC9V5T6BBPMNqs=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{278, 177},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->147490112]
}, Open  ]],

Cell["\<\
Differentiating and integrating recovers the original function:\
\>", "ExampleText",
 CellID->212405061],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"pwF", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->232439455],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   RowBox[{"DiracDelta", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"DiracDelta", "[", 
    RowBox[{"1", "+", "x"}], "]"}]}]}]], "Output",
 ImageSize->{266, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->145716404]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{"%", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->68003722],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   RowBox[{"HeavisideTheta", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"HeavisideTheta", "[", 
    RowBox[{"1", "+", "x"}], "]"}]}]}]], "Output",
 ImageSize->{322, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->357836046]
}, Open  ]],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["Piecewise",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
 " does not recover the original function:"
}], "ExampleText",
 CellID->257238890],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"pwF2", "[", "x_", "]"}], "=", 
  RowBox[{"PiecewiseExpand", "[", 
   RowBox[{
    RowBox[{"pwF", "[", "x", "]"}], "/.", 
    RowBox[{"HeavisideTheta", "->", "UnitStep"}]}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->27119470],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylVNtuwjAMdQldAbXjUkBIvPR9nzG2iYd9RIWQ4AGBoP8fnNRpg+NtRavU
nB5fjhwn7ndZHfansjruyuLrWl4Ox92t+Dxf0aQiANjiu14Bfmv8su9Wa0R/
VbgqdL0gxog5Yg+xRxiT3flHTRaYNG0f64W44TYGYG6w30bVKn7eSOKBesL4
kmobEHZTGTC+8LKd2t8qQ8bzYI/JU1XxqKnQ/+c7Jp/HW+duK4o2FaRi1Lu1
uio/GubHbH6xynr/sWa6vqGp0EFjd371Y3bYsSw4Xd7/jHFZ3U0Pt4+pxiFh
QnH9Tqpjxl89FYOzTioTxtNgz27OeGSrZ4xT5nVz5c6BT47cuVw8B35z69i5
frypdlbovwbRHS27lQo=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{73, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->56551579]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"pwF2", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->120043306],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9V7tOwzAUdeO47weUBehSJpj4CSSY+AYaVUjtgEClc0dgZ0H8bLBdO01O
ruOkKY2UJvd17r0nftSP0Xrx/BKtl/No+rCK3hbL+fv0/nUlVbzBWOOUMTY5
Z/I9lm/6VtdY3ttXfOPyl0u3pnwK+WRCq82l3pU1MFb1DOUzNFHcyNauFSYW
Ze5F54A6SMnWHgCqregj6UZD6q5j1gZZeevCYntZDIc2FatLb4GX8W2BL08h
7rzCGtXwguxjKnuBHBDdfR2Hv4KqSPvhOSyo4KQMj94+/4dJ4ajfpd+XOTv3
XLmGe3MkKs3SZIyGOz3LWsp9X9IrsHyUYomuhUYXpJZiDWvIspXXFnAXpn1x
hQxBZ7vCldXKQUKDvozFFU1lo5BHDl6zmSzTQSry0913Sh547Lcgn+W+J87j
HzKv3Sf7psprsCtZLdO/ZLT66WuL7VJphokGfQceixsfLd8g4zi/89ivjoiq
dlMlzuLsiOiAX898C9x9McvA+GE89+CHJfERp0n0k6zT5IjKz/ZZjOOzbdBx
l/JVhzOvZXBazgzIgy9DWBqpCgNRqk6LJVh+hfZVJ0wc/r8QBrcLeXp74Nu4
hNeaPXfiw37rNuBW/cLCE19vZHchDtfyql1T87g4IzVjq414jHAzZE9beWae
4uw6clGThxHg4Tmh6rpGnjP0TpjvZVOzdtxXffETsjZ7gtzE7hU+LQ+N301J
/0vjtz3WKtX2VM0af8yQ/9s=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{273, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->52838701]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{"%", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->4508777],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->12405103]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->197833296],

Cell["\<\
Solve a classical second\[Hyphen]order initial value problem:\
\>", "ExampleText",
 CellID->316966747],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
        RowBox[{"y", "[", "x", "]"}]}], "==", 
       RowBox[{"Sin", "[", "x", "]"}]}], ",", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "==", "y0"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "0", "]"}], "==", "y1"}]}], "}"}], ",", 
    RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->129855973],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "x"}], " ", 
        RowBox[{"Cos", "[", "x", "]"}]}], "+", 
       RowBox[{"2", " ", "y0", " ", 
        RowBox[{"Cos", "[", "x", "]"}]}], "+", 
       RowBox[{"Sin", "[", "x", "]"}], "+", 
       RowBox[{"2", " ", "y1", " ", 
        RowBox[{"Sin", "[", "x", "]"}]}]}], ")"}]}]}], "}"}], "}"}]], "Output",\

 ImageSize->{382, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->884073201]
}, Open  ]],

Cell[TextData[{
 "Incorporate the initial values in the right\[Hyphen]hand side through \
derivatives of ",
 Cell[BoxData[
  ButtonBox["DiracDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiracDelta"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->64724494],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
        RowBox[{"y", "[", "x", "]"}]}], "==", 
       RowBox[{
        RowBox[{
         RowBox[{"HeavisideTheta", "[", "x", "]"}], "  ", 
         RowBox[{"Sin", "[", "x", "]"}]}], "+", 
        RowBox[{"y0", " ", 
         RowBox[{
          RowBox[{"DiracDelta", "'"}], "[", "x", "]"}]}], "+", 
        RowBox[{"y1", " ", 
         RowBox[{"DiracDelta", "[", "x", "]"}]}]}]}], "}"}], ",", 
     RowBox[{"y", "[", "x", "]"}], ",", " ", "x"}], "]"}], "/.", 
   RowBox[{"_C", "->", "0"}]}], " ", "//", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{"#", ",", 
     RowBox[{"x", ">", "0"}]}], "]"}], "&"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->154426543],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "x"}], " ", 
        RowBox[{"Cos", "[", "x", "]"}]}], "+", 
       RowBox[{"2", " ", "y0", " ", 
        RowBox[{"Cos", "[", "x", "]"}]}], "+", 
       RowBox[{"Sin", "[", "x", "]"}], "+", 
       RowBox[{"2", " ", "y1", " ", 
        RowBox[{"Sin", "[", "x", "]"}]}]}], ")"}]}]}], "}"}], "}"}]], "Output",\

 ImageSize->{382, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->560042254]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27606],

Cell[TextData[{
 "Expand ",
 Cell[BoxData[
  ButtonBox["DiracDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiracDelta"]], "InlineFormula"],
 " into ",
 Cell[BoxData[
  ButtonBox["DiracDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiracDelta"]], "InlineFormula"],
 " with linear arguments:"
}], "ExampleText",
 CellID->291877107],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DiracDelta", "[", 
   RowBox[{
    RowBox[{"x", "^", "3"}], "+", 
    RowBox[{"x", "^", "2"}], "+", "1"}], "]"}], "//", 
  "FunctionExpand"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->366370095],

Cell[BoxData[
 FractionBox[
  RowBox[{"DiracDelta", "[", 
   RowBox[{"x", "-", 
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "+", 
        SuperscriptBox["#1", "2"], "+", 
        SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}], "]"}], 
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "+", 
        SuperscriptBox["#1", "2"], "+", 
        SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}], "+", 
   RowBox[{"3", " ", 
    SuperscriptBox[
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         SuperscriptBox["#1", "2"], "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], 
     "2"]}]}]]], "Output",
 ImageSize->{331, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->190170187]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->575948634],

Cell[TextData[{
 "Simplify expressions containing ",
 Cell[BoxData[
  ButtonBox["DiracDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiracDelta"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->247413793],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"DiracDelta", "[", "x", "]"}]}], ",", 
   RowBox[{"x", " ", 
    RowBox[{
     RowBox[{"DiracDelta", "'"}], "[", "x", "]"}]}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1005635858],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"DiracDelta", "[", "x", "]"}]}], ",", 
   RowBox[{"x", " ", 
    RowBox[{
     SuperscriptBox["DiracDelta", "\[Prime]",
      MultilineFunction->None], "[", "x", "]"}]}]}], "}"}]], "Output",
 ImageSize->{235, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37041149]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1743933],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"-", 
    RowBox[{"DiracDelta", "[", "x", "]"}]}]}], "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->206477284]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->37048928],

Cell["Fourier transforms:", "ExampleText",
 CellID->495347534],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"FourierTransform", "[", 
   RowBox[{
    RowBox[{"DiracDelta", "[", "y", "]"}], ",", "y", ",", "x"}], "]"}], 
  " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->138531881],

Cell[BoxData[
 FractionBox["1", 
  SqrtBox[
   RowBox[{"2", " ", "\[Pi]"}]]]], "Output",
 ImageSize->{43, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->123163867]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{"%", ",", "y", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32762273],

Cell[BoxData[
 RowBox[{"DiracDelta", "[", "x", "]"}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->484931763]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->117353512],

Cell["Laplace transforms:", "ExampleText",
 CellID->290615520],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"DiracDelta", "[", "x", "]"}], ",", "x", ",", "s"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->489770314],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37854095]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{"%", ",", "s", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->362274436],

Cell[BoxData[
 RowBox[{"DiracDelta", "[", "x", "]"}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->644928794]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24795],

Cell[TextData[{
 "Only ",
 Cell[BoxData[
  ButtonBox["HeavisideTheta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HeavisideTheta"]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["DiracDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiracDelta"]], "InlineFormula"],
 " after differentiation:"
}], "ExampleText",
 CellID->117705841],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HeavisideTheta", "[", "x", "]"}], ",", 
   RowBox[{"UnitStep", "[", "x", "]"}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"x", "^", "2"}], "]"}], "/", "x"}], "+", "1"}], ")"}], "/", 
    "2"}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Abs", "[", "x", "]"}], "/", "x"}], "+", "1"}], ")"}], "/", 
    "2"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->67180088],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HeavisideTheta", "[", "x", "]"}], ",", 
   RowBox[{"UnitStep", "[", "x", "]"}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox[
       SqrtBox[
        SuperscriptBox["x", "2"]], "x"]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"Abs", "[", "x", "]"}], "x"]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{425, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->251919947]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{"#", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], "&"}], "/@", 
  "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29359108],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWs1OFEEQ7t0ZwChiOCwaE9g9+RZGo0YvglFMRERxIRqIMRrkCfQpvMBZ
43pTL3rRK9GrN0+Guy8wdk33sD013dM9f7uzSxFm+u+r+qpru2t7Zmuxu7v1
5Hl3d3uz27mx0325tb35qnP9xQ7v8hqMNV7zi51jvB4wJi74e8MvUTXXZvjd
4wJNaHmRZMCavNrmFSg9ZYwBll/XUsbaKTpbA+Y7FeLOoJFQi99vMzaf6JlC
MpetiHkrS6smdpwMixP87iOf6vFnJbI5EOtmamqX8BqtpbK8MhGIPX3VONKp
xAtl8BabtSpzxYpoV+aFsu0QXpmRXpyUZVuWU4rf1fYCwrcKyouYDyaZv/c2
0Fy+ovajEDUb9n75/Ht/74D/syW4Kahn4fiP73/w+OHhv74W8Mc73jnHy/dH
9s0iRuztBdQ+bcEb279+/oXqhYzyeE2dR+2s+nAbz2euoD7sr2mtl5eQV/Sf
+0bJKFiV32S5XgkDWZvV2uVAf6KEqo809FywMe134G6MpkzD8cFdwsI0iXCe
lckoYWHCpwU4h0EzyWBCZtGcPgejhGUOvr4nlStFJsYWrbHomwnH5J5pPKaF
du4oWxuLMxNHo2LZGFeEBS277qnrZiCR4D5qNw3MsB98570UQ+ZgUqMk+EIf
g0xIV6bo6QB/ZvrIrdvPRZlWkPztgszR2sSxE6+TFYmz4lPZ8H7BqMfOWsCG
VVl2ZfkAoRtaTrxHQarBm4B2k1jNxePmEXcpNRphi4rqrr9U8dnHI6fuLBjq
skVoE1b2DePMUU+2lIisxaZp95xicAJpsRvjsp3PYxIxJjVmNjW+75nGY1ro
VDXK1lJ8KY9NPeHoowpG1MPucXzO7Ht3FHbteFu7HJh/BdWtBys2pv0u6k2+
+8er+aO7RK2ZAHDr0sW3zBN0MLKWUXJ/70COTGedo+wZgDcLMuEY9Am1n4Yo
EHDJSxhWjfIhhKLj+Bs25UPk8RqtJcqHoHyINK9QPgTlQ1A+xPF76zNa1lI+
hIOEhYnyIRIyMTbKhyBrfSmzGFSXFyGY8K69GQwqMtiZi+dHZGFSo6b5vbkJ
6cqkvne3R3Lz/s7PlD8/Akt6WkuiNVt2vkSE97Wsa0h7vrwJHP8fBvo8iqgt
PBAVcF9Hduj3t47HLmWbc9VSyWg2bIuGO/soSrvppN83q2ZLidiUP0H5E2Nu
LcWX8tjUE5A+qmBEPewex+fSvndHYdeOt7WUP1ENEwAofyJ7DCqWP8Ea/wEX
nCPk\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 256},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->112428283]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{"%%", ",", "x"}], "]"}], " ", "//", " ", "Together"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->423883182],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"DiracDelta", "[", "x", "]"}], ",", 
   FractionBox[
    RowBox[{"1", "+", 
     RowBox[{"DiscreteDelta", "[", "x", "]"}], "-", 
     RowBox[{"UnitStep", "[", 
      RowBox[{"-", "x"}], "]"}], "-", 
     RowBox[{"UnitStep", "[", "x", "]"}]}], 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"DiscreteDelta", "[", "x", "]"}]}]], ",", "0", ",", 
   FractionBox[
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Abs", "[", "x", "]"}]}], "+", 
     RowBox[{"x", " ", 
      RowBox[{
       SuperscriptBox["Abs", "\[Prime]",
        MultilineFunction->None], "[", "x", "]"}]}]}], 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "2"]}]]}], "}"}]], "Output",
 ImageSize->{492, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->330755076]
}, Open  ]],

Cell["This also holds for the multivariate case:", "ExampleText",
 CellID->568758120],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"#", ",", "x", ",", "x"}], "]"}], "+", 
      RowBox[{"D", "[", 
       RowBox[{"#", ",", "y", ",", "y"}], "]"}], "+", 
      RowBox[{"D", "[", 
       RowBox[{"#", ",", "z", ",", "z"}], "]"}]}], ")"}], "&"}], "[", 
   FractionBox["1", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"], "+", 
      SuperscriptBox["z", "2"]}]]], "]"}], "//", "Together"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->677398629],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->11285967]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->386226876],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DiracDelta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DiracDelta"], "[", "0", "]"}]], "InlineFormula"],
 " is not an \"infinite\" quantity:"
}], "ExampleText",
 CellID->39301929],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DiracDelta", "[", "0", "]"}], ">", "20"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->329698435],

Cell[BoxData[
 RowBox[{
  RowBox[{"DiracDelta", "[", "0", "]"}], ">", "20"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->444966193]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->45625273],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DiracDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiracDelta"]], "InlineFormula"],
 " can stay unevaluated for numeric arguments:"
}], "ExampleText",
 CellID->91931744],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracDelta", "[", 
  RowBox[{
   RowBox[{"-", "1"}], "-", 
   RowBox[{"2", " ", "\[ExponentialE]"}], "-", 
   SuperscriptBox["\[ExponentialE]", "2"], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "\[ExponentialE]"}], ")"}], "2"], "+", 
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{
      RowBox[{"Exp", "[", "E", "]"}], "^", "2"}]}], "]"}]}], " ", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->593669047],

Cell[BoxData[
 RowBox[{"DiracDelta", "[", 
  RowBox[{
   RowBox[{"-", "1"}], "-", 
   RowBox[{"2", " ", "\[ExponentialE]"}], "-", 
   SuperscriptBox["\[ExponentialE]", "2"], "+", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", " ", "\[ExponentialE]"}]]}]], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "\[ExponentialE]"}], ")"}], "2"]}], "]"}]], "Output",
 ImageSize->{259, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->389044586]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->794093517],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->899840235]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->83538643],

Cell["\<\
Products of distributions with coinciding singular support cannot be defined:\
\
\>", "ExampleText",
 CellID->607601722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"HeavisideTheta", "[", "x", "]"}], " ", 
    RowBox[{"DiracDelta", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->195216580],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", 
   RowBox[{"-", "1"}], "1"], 
  RowBox[{
   RowBox[{
    RowBox[{"DiracDelta", "[", "x", "]"}], " ", 
    RowBox[{"HeavisideTheta", "[", "x", "]"}]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 ImageSize->{254, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->118441129]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"DiracDelta", "[", "x", "]"}], "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->53837969],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", 
   RowBox[{"-", "1"}], "1"], 
  RowBox[{
   SqrtBox[
    SuperscriptBox[
     RowBox[{"DiracDelta", "[", "x", "]"}], "2"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 ImageSize->{157, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->75993922]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->132311334],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DiracDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiracDelta"]], "InlineFormula"],
 " cannot be uniquely defined with complex arguments:"
}], "ExampleText",
 CellID->153922402],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracDelta", "[", 
  RowBox[{"1", "+", 
   RowBox[{"2", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->171887576],

Cell[BoxData[
 RowBox[{"DiracDelta", "[", 
  RowBox[{"1", "+", 
   RowBox[{"2", " ", "\[ImaginaryI]"}]}], "]"}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->563807695]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->35129186],

Cell["\<\
Numerical routines will typically miss the contributions from measures at \
single points:\
\>", "ExampleText",
 CellID->302264015],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"DiracDelta", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->619195889],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"ncvb\"\>"}], ":", 
  " ", "\<\"NIntegrate failed to converge to prescribed accuracy after \
\\!\\(9\\) recursive bisections in \\!\\(x\\) near \\!\\({x}\\) = \
\\!\\({\\(-0.001906500078402859`\\)}\\). NIntegrate obtained \\!\\(0.`\\) and \
\\!\\(0.`\\) for the integral and error estimates. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->338456116],

Cell[BoxData["0.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->672497386]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->166078942],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Limit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Limit"]], "InlineFormula"],
 " does not produce ",
 Cell[BoxData[
  ButtonBox["DiracDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiracDelta"]], "InlineFormula"],
 " as a limit of smooth functions:"
}], "ExampleText",
 CellID->139629828],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"\[CurlyEpsilon]", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"\[CurlyEpsilon]", "^", "2"}]}], ")"}]}], ",", 
   RowBox[{"\[CurlyEpsilon]", "->", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->437387148],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->176236976]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3599265],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " never gives ",
 Cell[BoxData[
  ButtonBox["DiracDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiracDelta"]], "InlineFormula"],
 " as an integral of smooth functions:"
}], "ExampleText",
 CellID->5131038],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"I", " ", "k", " ", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"k", "\[Element]", "Reals"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69542255],

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "::", "\<\"idiv\"\>"}], ":", 
  " ", "\<\"Integral of \\!\\(\[ExponentialE]\\^\\(\[ImaginaryI]\\\\ k\\\\ \
x\\)\\) does not converge on \\!\\({\\(\\(-\[Infinity]\\)\\), \
\[Infinity]}\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Integrate/idiv\\\", ButtonNote -> \
\\\"Integrate::idiv\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->339627462],

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[ImaginaryI]", " ", "k", " ", "x"}]], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"k", "\[Element]", "Reals"}]}]}], "]"}]], "Output",
 ImageSize->{347, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->906474126]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FourierTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierTransform"]], "InlineFormula"],
 " can give ",
 Cell[BoxData[
  ButtonBox["DiracDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiracDelta"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->401435220],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"I", " ", "k", " ", "x"}], "]"}], ",", "x", ",", "y"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->346156],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"2", " ", "\[Pi]"}]], " ", 
  RowBox[{"DiracDelta", "[", 
   RowBox[{"k", "+", "y"}], "]"}]}]], "Output",
 ImageSize->{153, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->118708304]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3621],

Cell["Calculate the moments of a Gaussian bell curve:", "ExampleText",
 CellID->944461611],

Cell[BoxData[
 RowBox[{
  RowBox[{"moment", "[", 
   RowBox[{"n_", "?", "EvenQ"}], "]"}], ":=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "n"], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", 
       SuperscriptBox["x", "2"]}]]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"n", "\[GreaterEqual]", "0"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23182263],

Cell[TextData[{
 "Do it using the dual Taylor expansion expressed in derivatives of ",
 Cell[BoxData[
  ButtonBox["DiracDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiracDelta"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->14429038],

Cell[BoxData[
 RowBox[{
  RowBox[{"dualMoment", "[", 
   RowBox[{"n_", "?", "EvenQ"}], "]"}], ":=", 
  RowBox[{"Integrate", "[", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "n"], 
     FractionBox[
      SqrtBox["\[Pi]"], 
      RowBox[{
       SuperscriptBox["2", "n"], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "/", "2"}], ")"}], "!"}]}]], 
     RowBox[{
      RowBox[{
       RowBox[{"Derivative", "[", "n", "]"}], "[", "DiracDelta", "]"}], "[", 
      "x", "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->54936232],

Cell["The two sequences of moments are identical:", "ExampleText",
 CellID->180403379],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"moment", "[", "n", "]"}], ",", " ", 
     RowBox[{"dualMoment", "[", "n", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "10", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->5961288],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SqrtBox["\[Pi]"], ",", 
     SqrtBox["\[Pi]"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      SqrtBox["\[Pi]"], "2"], ",", 
     FractionBox[
      SqrtBox["\[Pi]"], "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"3", " ", 
       SqrtBox["\[Pi]"]}], "4"], ",", 
     FractionBox[
      RowBox[{"3", " ", 
       SqrtBox["\[Pi]"]}], "4"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"15", " ", 
       SqrtBox["\[Pi]"]}], "8"], ",", 
     FractionBox[
      RowBox[{"15", " ", 
       SqrtBox["\[Pi]"]}], "8"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"105", " ", 
       SqrtBox["\[Pi]"]}], "16"], ",", 
     FractionBox[
      RowBox[{"105", " ", 
       SqrtBox["\[Pi]"]}], "16"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"945", " ", 
       SqrtBox["\[Pi]"]}], "32"], ",", 
     FractionBox[
      RowBox[{"945", " ", 
       SqrtBox["\[Pi]"]}], "32"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{420, 70},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->198823215]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14781],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["HeavisideTheta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HeavisideTheta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["If",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/If"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrincipalValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrincipalValue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Limit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Limit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["KroneckerDelta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/KroneckerDelta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DiscreteDelta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DiscreteDelta"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20334]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13440],

Cell[TextData[ButtonBox["Generalized Functions and Related Objects",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/GeneralizedFunctionsAndRelatedObjects"]], "Tutorials",
 CellID->11711]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->4537],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/DeltaFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/GeneralizedFunctions/DiracDelta/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->914731578],

Cell[TextData[ButtonBox["Calculus",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Calculus"]], "MoreAbout",
 CellID->39900477],

Cell[TextData[ButtonBox["Generalized Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GeneralizedFunctions"]], "MoreAbout",
 CellID->276119494],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->240900949]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DiracDelta - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 19.7112680}", "context" -> "System`", 
    "keywords" -> {
     "delta function", "generalized functions", "Green's functions", 
      "improper functions", "impulse function", "Lebesgue integration", 
      "limiting functions", "spike"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "DiracDelta[x] represents the Dirac delta function \\[Delta](x). \
DiracDelta[x_1, x_2, ...] represents the multidimensional Dirac delta \
function \\[Delta](x_1, x_2, ...). ", "synonyms" -> {"dirac delta"}, "title" -> 
    "DiracDelta", "type" -> "Symbol", "uri" -> "ref/DiracDelta"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7544, 251, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->249641545]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 118918, 3566}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2624, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3247, 87, 47, 1, 70, "ObjectName",
 CellID->7985],
Cell[3297, 90, 1367, 43, 70, "Usage",
 CellID->17684]
}, Open  ]],
Cell[CellGroupData[{
Cell[4701, 138, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5179, 155, 410, 16, 70, "Notes",
 CellID->23301],
Cell[5592, 173, 248, 8, 70, "Notes",
 CellID->24535],
Cell[5843, 183, 256, 8, 70, "Notes",
 CellID->9502],
Cell[6102, 193, 598, 23, 70, "Notes",
 CellID->8963],
Cell[6703, 218, 313, 12, 70, "Notes",
 CellID->9564],
Cell[7019, 232, 488, 14, 70, "Notes",
 CellID->15012]
}, Closed]],
Cell[CellGroupData[{
Cell[7544, 251, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->249641545],
Cell[CellGroupData[{
Cell[7929, 265, 147, 5, 70, "ExampleSection",
 CellID->88478720],
Cell[CellGroupData[{
Cell[8101, 274, 334, 11, 28, "Input",
 CellID->49659756],
Cell[8438, 287, 158, 5, 36, "Output",
 CellID->535207307]
}, Open  ]],
Cell[8611, 295, 124, 3, 70, "ExampleDelimiter",
 CellID->46207547],
Cell[CellGroupData[{
Cell[8760, 302, 106, 3, 28, "Input",
 CellID->506048238],
Cell[8869, 307, 158, 5, 36, "Output",
 CellID->173416507]
}, Open  ]],
Cell[9042, 315, 309, 11, 70, "ExampleText",
 CellID->572194292],
Cell[CellGroupData[{
Cell[9376, 330, 105, 3, 70, "Input",
 CellID->56255554],
Cell[9484, 335, 193, 6, 36, "Output",
 CellID->48912880]
}, Open  ]],
Cell[9692, 344, 125, 3, 70, "ExampleDelimiter",
 CellID->291610979],
Cell[9820, 349, 64, 1, 70, "ExampleText",
 CellID->3561391],
Cell[CellGroupData[{
Cell[9909, 354, 196, 6, 70, "Input",
 CellID->296958439],
Cell[10108, 362, 281, 10, 51, "Output",
 CellID->5806625]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10438, 378, 215, 7, 70, "ExampleSection",
 CellID->7507],
Cell[10656, 387, 250, 8, 70, "ExampleText",
 CellID->1031947],
Cell[CellGroupData[{
Cell[10931, 399, 430, 13, 70, "Input",
 CellID->399314628],
Cell[11364, 414, 185, 6, 36, "Output",
 CellID->707264772]
}, Open  ]],
Cell[CellGroupData[{
Cell[11586, 425, 444, 13, 70, "Input",
 CellID->92770994],
Cell[12033, 440, 331, 11, 36, "Output",
 CellID->355604880]
}, Open  ]],
Cell[CellGroupData[{
Cell[12401, 456, 474, 14, 70, "Input",
 CellID->99766472],
Cell[12878, 472, 977, 32, 71, "Output",
 CellID->338046146]
}, Open  ]],
Cell[13870, 507, 125, 3, 70, "ExampleDelimiter",
 CellID->271162569],
Cell[13998, 512, 234, 8, 70, "ExampleText",
 CellID->62712159],
Cell[CellGroupData[{
Cell[14257, 524, 447, 14, 70, "Input",
 CellID->819314460],
Cell[14707, 540, 313, 12, 36, "Output",
 CellID->364293150]
}, Open  ]],
Cell[15035, 555, 125, 3, 70, "ExampleDelimiter",
 CellID->554184098],
Cell[15163, 560, 98, 1, 70, "ExampleText",
 CellID->45844422],
Cell[CellGroupData[{
Cell[15286, 565, 165, 5, 70, "Input",
 CellID->50930038],
Cell[15454, 572, 199, 6, 36, "Output",
 CellID->146680573]
}, Open  ]],
Cell[15668, 581, 124, 3, 70, "ExampleDelimiter",
 CellID->70205023],
Cell[15795, 586, 200, 7, 70, "ExampleText",
 CellID->173502],
Cell[CellGroupData[{
Cell[16020, 597, 144, 4, 70, "Input",
 CellID->385997720],
Cell[16167, 603, 321, 11, 50, "Output",
 CellID->159635163]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16537, 620, 238, 7, 70, "ExampleSection",
 CellID->6349],
Cell[16778, 629, 199, 8, 70, "ExampleText",
 CellID->65634992],
Cell[CellGroupData[{
Cell[17002, 641, 129, 4, 70, "Input",
 CellID->512770906],
Cell[17134, 647, 158, 5, 36, "Output",
 CellID->141571282]
}, Open  ]],
Cell[17307, 655, 125, 3, 70, "ExampleDelimiter",
 CellID->161664622],
Cell[17435, 660, 218, 8, 70, "ExampleText",
 CellID->963595505],
Cell[CellGroupData[{
Cell[17678, 672, 227, 8, 70, "Input",
 CellID->428676162],
Cell[17908, 682, 490, 15, 36, "Output",
 CellID->11278327]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18447, 703, 223, 7, 70, "ExampleSection",
 CellID->11350],
Cell[18673, 712, 93, 1, 70, "ExampleText",
 CellID->287492792],
Cell[CellGroupData[{
Cell[18791, 717, 821, 26, 70, "Input",
 CellID->86268258],
Cell[19615, 745, 299, 10, 51, "Output",
 CellID->98535972]
}, Open  ]],
Cell[19929, 758, 125, 3, 70, "ExampleText",
 CellID->630427126],
Cell[CellGroupData[{
Cell[20079, 765, 436, 14, 70, "Input",
 CellID->4400197],
Cell[20518, 781, 483, 17, 53, "Output",
 CellID->622019414]
}, Open  ]],
Cell[21016, 801, 215, 8, 70, "ExampleText",
 CellID->669087629],
Cell[CellGroupData[{
Cell[21256, 813, 894, 29, 70, "Input",
 CellID->37487348],
Cell[22153, 844, 483, 17, 53, "Output",
 CellID->215100142]
}, Open  ]],
Cell[22651, 864, 125, 3, 70, "ExampleDelimiter",
 CellID->733192504],
Cell[22779, 869, 74, 1, 70, "ExampleText",
 CellID->241292424],
Cell[22856, 872, 1092, 29, 70, "Input",
 CellID->272474856],
Cell[23951, 903, 113, 3, 70, "ExampleText",
 CellID->911473740],
Cell[CellGroupData[{
Cell[24089, 910, 247, 8, 70, "Input",
 CellID->223832199],
Cell[24339, 920, 278, 9, 36, "Output",
 CellID->5857789]
}, Open  ]],
Cell[24632, 932, 125, 3, 70, "ExampleDelimiter",
 CellID->145309049],
Cell[24760, 937, 103, 2, 70, "ExampleText",
 CellID->142082126],
Cell[CellGroupData[{
Cell[24888, 943, 466, 15, 70, "Input",
 CellID->447417020],
Cell[25357, 960, 162, 5, 36, "Output",
 CellID->889378419]
}, Open  ]],
Cell[25534, 968, 125, 3, 70, "ExampleDelimiter",
 CellID->329460098],
Cell[25662, 973, 137, 4, 70, "ExampleText",
 CellID->384138054],
Cell[CellGroupData[{
Cell[25824, 981, 681, 20, 70, "Input",
 CellID->30784595],
Cell[26508, 1003, 1619, 54, 79, "Output",
 CellID->257505318]
}, Open  ]],
Cell[28142, 1060, 66, 1, 70, "ExampleText",
 CellID->274289697],
Cell[CellGroupData[{
Cell[28233, 1065, 346, 12, 70, "Input",
 CellID->185633906],
Cell[28582, 1079, 3328, 59, 70, "Output",
 Evaluatable->False,
 CellID->266563303]
}, Open  ]],
Cell[31925, 1141, 124, 3, 70, "ExampleDelimiter",
 CellID->99550026],
Cell[32052, 1146, 315, 10, 70, "ExampleText",
 CellID->109021056],
Cell[32370, 1158, 939, 33, 70, "Input",
 CellID->49554612],
Cell[33312, 1193, 139, 4, 70, "ExampleText",
 CellID->339947024],
Cell[CellGroupData[{
Cell[33476, 1201, 783, 26, 70, "Input",
 CellID->141472592],
Cell[34262, 1229, 290, 6, 70, "Message",
 CellID->698226120],
Cell[34555, 1237, 335, 7, 70, "Message",
 CellID->140816110],
Cell[34893, 1246, 321, 7, 70, "Message",
 CellID->65275024],
Cell[35217, 1255, 419, 8, 70, "Message",
 CellID->29507986],
Cell[35639, 1265, 12624, 211, 70, "Output",
 Evaluatable->False,
 CellID->179317038]
}, Open  ]],
Cell[48278, 1479, 124, 3, 70, "ExampleDelimiter",
 CellID->87989254],
Cell[48405, 1484, 119, 3, 70, "ExampleText",
 CellID->1547553],
Cell[48527, 1489, 804, 27, 70, "Input",
 CellID->38711986],
Cell[49334, 1518, 480, 16, 70, "Input",
 CellID->68162009],
Cell[49817, 1536, 219, 8, 70, "ExampleText",
 CellID->279166185],
Cell[CellGroupData[{
Cell[50061, 1548, 230, 8, 70, "Input",
 CellID->375509904],
Cell[50294, 1558, 2170, 71, 88, "Output",
 CellID->818936838]
}, Open  ]],
Cell[52479, 1632, 80, 1, 70, "ExampleText",
 CellID->405639488],
Cell[CellGroupData[{
Cell[52584, 1637, 862, 28, 70, "Input",
 CellID->125312260],
Cell[53449, 1667, 26718, 442, 70, "Output",
 Evaluatable->False,
 CellID->64254157]
}, Open  ]],
Cell[80182, 2112, 124, 3, 70, "ExampleDelimiter",
 CellID->13787062],
Cell[80309, 2117, 130, 4, 70, "ExampleText",
 CellID->91664871],
Cell[80442, 2123, 355, 12, 70, "Input",
 CellID->122419067],
Cell[CellGroupData[{
Cell[80822, 2139, 234, 8, 70, "Input",
 CellID->172123373],
Cell[81059, 2149, 977, 20, 70, "Output",
 Evaluatable->False,
 CellID->147490112]
}, Open  ]],
Cell[82051, 2172, 114, 3, 70, "ExampleText",
 CellID->212405061],
Cell[CellGroupData[{
Cell[82190, 2179, 151, 5, 70, "Input",
 CellID->232439455],
Cell[82344, 2186, 374, 13, 36, "Output",
 CellID->145716404]
}, Open  ]],
Cell[CellGroupData[{
Cell[82755, 2204, 127, 4, 70, "Input",
 CellID->68003722],
Cell[82885, 2210, 382, 13, 36, "Output",
 CellID->357836046]
}, Open  ]],
Cell[83282, 2226, 230, 8, 70, "ExampleText",
 CellID->257238890],
Cell[CellGroupData[{
Cell[83537, 2238, 268, 8, 70, "Input",
 CellID->27119470],
Cell[83808, 2248, 596, 14, 70, "Output",
 Evaluatable->False,
 CellID->56551579]
}, Open  ]],
Cell[CellGroupData[{
Cell[84441, 2267, 152, 5, 70, "Input",
 CellID->120043306],
Cell[84596, 2274, 967, 20, 70, "Output",
 Evaluatable->False,
 CellID->52838701]
}, Open  ]],
Cell[CellGroupData[{
Cell[85600, 2299, 126, 4, 70, "Input",
 CellID->4508777],
Cell[85729, 2305, 157, 5, 36, "Output",
 CellID->12405103]
}, Open  ]],
Cell[85901, 2313, 125, 3, 70, "ExampleDelimiter",
 CellID->197833296],
Cell[86029, 2318, 112, 3, 70, "ExampleText",
 CellID->316966747],
Cell[CellGroupData[{
Cell[86166, 2325, 594, 20, 70, "Input",
 CellID->129855973],
Cell[86763, 2347, 661, 22, 51, "Output",
 CellID->884073201]
}, Open  ]],
Cell[87439, 2372, 273, 9, 70, "ExampleText",
 CellID->64724494],
Cell[CellGroupData[{
Cell[87737, 2385, 861, 27, 70, "Input",
 CellID->154426543],
Cell[88601, 2414, 661, 22, 51, "Output",
 CellID->560042254]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[89311, 2442, 233, 7, 70, "ExampleSection",
 CellID->27606],
Cell[89547, 2451, 350, 13, 70, "ExampleText",
 CellID->291877107],
Cell[CellGroupData[{
Cell[89922, 2468, 230, 8, 70, "Input",
 CellID->366370095],
Cell[90155, 2478, 892, 31, 63, "Output",
 CellID->190170187]
}, Open  ]],
Cell[91062, 2512, 125, 3, 70, "ExampleDelimiter",
 CellID->575948634],
Cell[91190, 2517, 219, 8, 70, "ExampleText",
 CellID->247413793],
Cell[CellGroupData[{
Cell[91434, 2529, 263, 9, 70, "Input",
 CellID->1005635858],
Cell[91700, 2540, 394, 13, 36, "Output",
 CellID->37041149]
}, Open  ]],
Cell[CellGroupData[{
Cell[92131, 2558, 102, 3, 70, "Input",
 CellID->1743933],
Cell[92236, 2563, 262, 9, 36, "Output",
 CellID->206477284]
}, Open  ]],
Cell[92513, 2575, 124, 3, 70, "ExampleDelimiter",
 CellID->37048928],
Cell[92640, 2580, 62, 1, 70, "ExampleText",
 CellID->495347534],
Cell[CellGroupData[{
Cell[92727, 2585, 211, 7, 70, "Input",
 CellID->138531881],
Cell[92941, 2594, 218, 8, 55, "Output",
 CellID->123163867]
}, Open  ]],
Cell[CellGroupData[{
Cell[93196, 2607, 151, 4, 70, "Input",
 CellID->32762273],
Cell[93350, 2613, 194, 6, 36, "Output",
 CellID->484931763]
}, Open  ]],
Cell[93559, 2622, 125, 3, 70, "ExampleDelimiter",
 CellID->117353512],
Cell[93687, 2627, 62, 1, 70, "ExampleText",
 CellID->290615520],
Cell[CellGroupData[{
Cell[93774, 2632, 186, 6, 70, "Input",
 CellID->489770314],
Cell[93963, 2640, 157, 5, 36, "Output",
 CellID->37854095]
}, Open  ]],
Cell[CellGroupData[{
Cell[94157, 2650, 152, 4, 70, "Input",
 CellID->362274436],
Cell[94312, 2656, 194, 6, 36, "Output",
 CellID->644928794]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[94555, 2668, 226, 7, 70, "ExampleSection",
 CellID->24795],
Cell[94784, 2677, 357, 13, 70, "ExampleText",
 CellID->117705841],
Cell[CellGroupData[{
Cell[95166, 2694, 526, 19, 70, "Input",
 CellID->67180088],
Cell[95695, 2715, 630, 22, 70, "Output",
 CellID->251919947]
}, Open  ]],
Cell[CellGroupData[{
Cell[96362, 2742, 256, 10, 70, "Input",
 CellID->29359108],
Cell[96621, 2754, 1498, 29, 70, "Output",
 Evaluatable->False,
 CellID->112428283]
}, Open  ]],
Cell[CellGroupData[{
Cell[98156, 2788, 163, 5, 70, "Input",
 CellID->423883182],
Cell[98322, 2795, 842, 27, 75, "Output",
 CellID->330755076]
}, Open  ]],
Cell[99179, 2825, 85, 1, 70, "ExampleText",
 CellID->568758120],
Cell[CellGroupData[{
Cell[99289, 2830, 574, 19, 70, "Input",
 CellID->677398629],
Cell[99866, 2851, 157, 5, 36, "Output",
 CellID->11285967]
}, Open  ]],
Cell[100038, 2859, 125, 3, 70, "ExampleDelimiter",
 CellID->386226876],
Cell[100166, 2864, 244, 8, 70, "ExampleText",
 CellID->39301929],
Cell[CellGroupData[{
Cell[100435, 2876, 130, 4, 70, "Input",
 CellID->329698435],
Cell[100568, 2882, 219, 7, 36, "Output",
 CellID->444966193]
}, Open  ]],
Cell[100802, 2892, 124, 3, 70, "ExampleDelimiter",
 CellID->45625273],
Cell[100929, 2897, 224, 7, 70, "ExampleText",
 CellID->91931744],
Cell[CellGroupData[{
Cell[101178, 2908, 464, 15, 70, "Input",
 CellID->593669047],
Cell[101645, 2925, 575, 17, 45, "Output",
 CellID->389044586]
}, Open  ]],
Cell[CellGroupData[{
Cell[102257, 2947, 104, 3, 70, "Input",
 CellID->794093517],
Cell[102364, 2952, 158, 5, 36, "Output",
 CellID->899840235]
}, Open  ]],
Cell[102537, 2960, 124, 3, 70, "ExampleDelimiter",
 CellID->83538643],
Cell[102664, 2965, 130, 4, 70, "ExampleText",
 CellID->607601722],
Cell[CellGroupData[{
Cell[102819, 2973, 314, 10, 70, "Input",
 CellID->195216580],
Cell[103136, 2985, 395, 13, 51, "Output",
 CellID->118441129]
}, Open  ]],
Cell[CellGroupData[{
Cell[103568, 3003, 304, 10, 70, "Input",
 CellID->53837969],
Cell[103875, 3015, 367, 13, 52, "Output",
 CellID->75993922]
}, Open  ]],
Cell[104257, 3031, 125, 3, 70, "ExampleDelimiter",
 CellID->132311334],
Cell[104385, 3036, 232, 7, 70, "ExampleText",
 CellID->153922402],
Cell[CellGroupData[{
Cell[104642, 3047, 148, 5, 70, "Input",
 CellID->171887576],
Cell[104793, 3054, 254, 8, 36, "Output",
 CellID->563807695]
}, Open  ]],
Cell[105062, 3065, 124, 3, 70, "ExampleDelimiter",
 CellID->35129186],
Cell[105189, 3070, 141, 4, 70, "ExampleText",
 CellID->302264015],
Cell[CellGroupData[{
Cell[105355, 3078, 247, 8, 70, "Input",
 CellID->619195889],
Cell[105605, 3088, 592, 10, 70, "Message",
 CellID->338456116],
Cell[106200, 3100, 160, 5, 36, "Output",
 CellID->672497386]
}, Open  ]],
Cell[106375, 3108, 125, 3, 70, "ExampleDelimiter",
 CellID->166078942],
Cell[106503, 3113, 349, 12, 70, "ExampleText",
 CellID->139629828],
Cell[CellGroupData[{
Cell[106877, 3129, 320, 10, 70, "Input",
 CellID->437387148],
Cell[107200, 3141, 158, 5, 36, "Output",
 CellID->176236976]
}, Open  ]],
Cell[107373, 3149, 123, 3, 70, "ExampleDelimiter",
 CellID->3599265],
Cell[107499, 3154, 354, 12, 70, "ExampleText",
 CellID->5131038],
Cell[CellGroupData[{
Cell[107878, 3170, 376, 11, 70, "Input",
 CellID->69542255],
Cell[108257, 3183, 475, 9, 70, "Message",
 CellID->339627462],
Cell[108735, 3194, 491, 14, 41, "Output",
 CellID->906474126]
}, Open  ]],
Cell[109241, 3211, 332, 12, 70, "ExampleText",
 CellID->401435220],
Cell[CellGroupData[{
Cell[109598, 3227, 211, 7, 70, "Input",
 CellID->346156],
Cell[109812, 3236, 282, 10, 38, "Output",
 CellID->118708304]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[110143, 3252, 223, 7, 70, "ExampleSection",
 CellID->3621],
Cell[110369, 3261, 90, 1, 70, "ExampleText",
 CellID->944461611],
Cell[110462, 3264, 552, 17, 70, "Input",
 CellID->23182263],
Cell[111017, 3283, 252, 8, 70, "ExampleText",
 CellID->14429038],
Cell[111272, 3293, 680, 24, 70, "Input",
 CellID->54936232],
Cell[111955, 3319, 86, 1, 70, "ExampleText",
 CellID->180403379],
Cell[CellGroupData[{
Cell[112066, 3324, 327, 10, 70, "Input",
 CellID->5961288],
Cell[112396, 3336, 1254, 49, 91, "Output",
 CellID->198823215]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[113711, 3392, 311, 9, 70, "SeeAlsoSection",
 CellID->14781],
Cell[114025, 3403, 1459, 53, 70, "SeeAlso",
 CellID->20334]
}, Open  ]],
Cell[CellGroupData[{
Cell[115521, 3461, 314, 9, 70, "TutorialsSection",
 CellID->13440],
Cell[115838, 3472, 192, 4, 70, "Tutorials",
 CellID->11711]
}, Open  ]],
Cell[CellGroupData[{
Cell[116067, 3481, 320, 9, 70, "RelatedLinksSection",
 CellID->4537],
Cell[116390, 3492, 184, 4, 70, "RelatedLinks"],
Cell[116577, 3498, 203, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[116817, 3507, 319, 9, 70, "MoreAboutSection",
 CellID->914731578],
Cell[117139, 3518, 127, 3, 70, "MoreAbout",
 CellID->39900477],
Cell[117269, 3523, 153, 3, 70, "MoreAbout",
 CellID->276119494],
Cell[117425, 3528, 155, 3, 70, "MoreAbout",
 CellID->240900949]
}, Open  ]],
Cell[117595, 3534, 27, 0, 70, "History"],
Cell[117625, 3536, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

