(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29770,        935]
NotebookOptionsPosition[     25556,        797]
NotebookOutlinePosition[     26950,        835]
CellTagsIndexPosition[     26865,        830]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"General Graph Drawing" :> 
          Documentation`HelpLookup["paclet:tutorial/GraphDrawing"], 
          "Hierarchical Drawing of Directed Graphs" :> 
          Documentation`HelpLookup["paclet:tutorial/LayeredGraphDrawing"], 
          "Tree Drawing" :> 
          Documentation`HelpLookup["paclet:tutorial/TreeDrawing"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"General Graph Drawing\"\>", 
       2->"\<\"Hierarchical Drawing of Directed Graphs\"\>", 
       3->"\<\"Tree Drawing\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EdgeLabeling" :> 
          Documentation`HelpLookup["paclet:ref/EdgeLabeling"], 
          "VertexLabeling" :> 
          Documentation`HelpLookup["paclet:ref/VertexLabeling"], 
          "EdgeRenderingFunction" :> 
          Documentation`HelpLookup["paclet:ref/EdgeRenderingFunction"], 
          "Arrowheads" :> 
          Documentation`HelpLookup["paclet:ref/Arrowheads"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"EdgeLabeling\"\>", 
       2->"\<\"VertexLabeling\"\>", 3->"\<\"EdgeRenderingFunction\"\>", 
       4->"\<\"Arrowheads\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["DirectedEdges", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["DirectedEdges",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DirectedEdges"]], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["GraphPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
     " and related functions which specifies whether edges should by default \
be drawn as directed arrows, or as undirected lines."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"DirectedEdges", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " specifies that edges should be drawn as directed arrows. "
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"DirectedEdges", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " specifies that edges should be drawn as undirected lines."
}], "Notes",
 CellID->636852794],

Cell[TextData[{
 "The form of lines or arrows can be specified by graphics directives given \
in ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->659927552],

Cell[TextData[{
 "Any explicit setting for ",
 Cell[BoxData[
  ButtonBox["EdgeRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeRenderingFunction"]], "InlineFormula"],
 " overrides the setting for ",
 Cell[BoxData[
  ButtonBox["DirectedEdges",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DirectedEdges"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->200462403]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->405887715],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->111071823],

Cell[TextData[{
 "Show edges as arrows in ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->502812571],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"4", "\[Rule]", "6"}]}], "}"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->275915656],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.2312931380591906, 0.}, {0., 
    0.7513817279246584}, {0.23073382739826498`, 1.502373405355722}, {
    0.9689956822146361, 0.7514590347407663}, {1.851447178263418, 
    0.026651360567214732`}, {1.8511613647434726`, 1.4764886649994748`}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.034768475478212886`, 0.8}}], 
      ArrowBox[{1, 2}], ArrowBox[{2, 3}], ArrowBox[{2, 4}], ArrowBox[{3, 4}], 
      ArrowBox[{4, 1}], ArrowBox[{4, 5}], ArrowBox[{4, 6}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.2312931380591906, 0.}, {0., 
     0.7513817279246584}, {0.23073382739826498`, 1.502373405355722}, {
     0.9689956822146361, 0.7514590347407663}, {1.851447178263418, 
     0.026651360567214732`}, {1.8511613647434726`, 1.4764886649994748`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1233816003]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4492989],

Cell[TextData[{
 "Do not show edges as arrows in ",
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2058444472],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"4", "\[Rule]", "6"}]}], "}"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->573837420],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJyN0ntIU1EYAPC7x713JtuVTC0ipYSWj4ZhNq3wfviqIDPMWVOK1I2il0YW
SWlJhZlLi2m+cr4fRZklWZmVZZL2Mq0sU3E6E5ejfGyma2qb5gnsnz6+w8fv
nnM+LnxnaXhkoJSJYZifcZnqnICZwvlTB+mZagH/d272+9zKmePZfv/0R+d3
hG2JXlE7u88BxaE3VFLqEHILP9aYw8g62c6ayZgRZGL6gvavQyvw0AodsrZu
mVSpHkV+97l+IFc4hpyVaYpxWi6yotvGSPATX79bN6Wn/YNFBomKhMZ97IQF
IQZawKwVFj4hYenbUq6sbIJeIxYNyS+SsPVM6ibHgUlaEmrlIPQnwdFXmvPT
AoP7HKxLNklA+lBR1MESDFaHWVmm5RPwwy9RMerGgFaJqD5gDQGuvvP58icM
yLWs1dXU4BCmoed5ezOB0+SfL2ljw5jLnV3Zy1lwUtiEWxNsONvgolePs2Bi
s499sxcLWJUPOwSP2HCBujmelsKEY4OBxL4oHOxPmSVKNAzoPD16LNuSgIZs
cfN6MQPcJSWCuhICYqQ5LbatGCRkha/sdiBB2PFBNi8Cg0Z7pyO6qySan97x
dSIPL0Pz61K3Gio2PkCWe6qNWYd8bY+mR9f0CnnR8Wo32rkF2frAU2O2Ipum
HV/ajqy4nfSJjlQiu06HCrlqt7kx+5A9klXuyap+5JqHphhAnv49+XfkMNP1
qr/vcdl0DCOburknjyAXB+iLAvRa5Nn3kuRx2Es7SkHPy4iheL2edu57btbc
ToFw1bejXF8D3Yv/El0ppyDztTN/fcwEfSfDku8TSYFZjhPOS5+kryh4sV+W
UHCuoI86o5iiL9lotoureXD+e3nhmw0Y5LFu3Kv14cG2kgaR010MXoRvuWrx
iAvFx0ERYsMAttt7fJM9F+Kk1rGhhxjgKKSD1rLMYb9E+TE8jgkuFXY5z7hm
0M+Pum0bw4KFedHKbi8StLfqqZRdbOghPG0zCnBIMSgHKwU4yHpPBH91ZkM1
91nQRTUONh6CxMZuJkSr9q5bnELAWbaoyucpAx7HfizaaUdCs99gZ/ArDNI7
yMtBWST8BlKYY6g=
    "], {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 3}, {2, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
         21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 4}, {3, 
        36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 
        53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
        70, 4}, {4, 1}, {4, 5}, {4, 6}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.}, {3., 1.}, {4., 0.}, {2., 3.}, {1., 
     2.}, {2., 2.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1870222530]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[TextData[{
 "By default, edges are shown as lines in ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TreePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreePlot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->912955084],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"2", "\[Rule]", "3"}], ",", 
    RowBox[{"3", "\[Rule]", "4"}], ",", 
    RowBox[{"4", "\[Rule]", "1"}], ",", 
    RowBox[{"2", "\[Rule]", "4"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1575850861],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.8675355367152218`, 0.43547689032484677`}, {
    0.9335045214257117, 0.8695704000258524}, {0., 0.4348238932910126}, {
    0.9349065648054304, 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 3}, {2, 4}, {3, 4}, {4, 1}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.8675355367152218`, 0.43547689032484677`}, {
     0.9335045214257117, 0.8695704000258524}, {0., 0.4348238932910126}, {
     0.9349065648054304, 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->217311597]
}, Open  ]],

Cell["Show edges as arrows:", "ExampleText",
 CellID->928470380],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}]}], "}"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1480502994],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.8675355367152218`, 0.43547689032484677`}, {
    0.9335045214257117, 0.8695704000258524}, {0., 0.4348238932910126}, {
    0.9349065648054304, 0.}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.03466547939129392, 0.8}}], 
      ArrowBox[{1, 2}], ArrowBox[{2, 3}], ArrowBox[{2, 4}], ArrowBox[{3, 4}], 
      ArrowBox[{4, 1}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.8675355367152218`, 0.43547689032484677`}, {
     0.9335045214257117, 0.8695704000258524}, {0., 0.4348238932910126}, {
     0.9349065648054304, 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1704932953]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1148795811],

Cell[TextData[{
 "By default, edges are shown as arrows in ",
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2112634824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"2", "\[Rule]", "3"}], ",", 
    RowBox[{"3", "\[Rule]", "4"}], ",", 
    RowBox[{"1", "\[Rule]", "4"}], ",", 
    RowBox[{"2", "\[Rule]", "5"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1679766667],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 3.}, {0., 2.}, {-1., 1.}, {1., 0.}, {0., 
    1.}, {1., 2.}, {1., 1.}, {0.04835996651265902, 2.9516400334873407`}, {
    0.10455097716174719`, 2.895449022838253}, {0.16857303194726453`, 
    2.8314269680527353`}, {0.24042613086921105`, 2.7595738691307887`}, {
    0.32011027392758673`, 2.679889726072413}, {0.4076254611223915, 
    2.5923745388776083`}, {0.5029716924536255, 2.4970283075463744`}, {
    0.6061489679212887, 2.393851032078711}, {0.717157287525381, 
    2.282842712474619}, {0.7765193382916591, 2.2185423901034027`}, {
    0.8288976183795514, 2.151349295200695}, {0.8742921277890582, 
    2.081263427766497}, {0.9127028665201793, 2.0082847878008083`}, {
    0.9441298345729148, 1.9324133753036286`}, {0.9685730319472645, 
    1.8536491902749577`}, {0.9860324586432286, 1.7719922327147961`}, {
    0.9965081146608071, 1.6874425026231434`}, {1., 1.4}, {1., 
    1.3111111111111111`}, {1., 1.222222222222222}, {1., 
    1.1333333333333333`}, {1., 1.0444444444444445`}, {1., 
    0.9555555555555555}, {1., 0.8666666666666667}, {1., 0.7777777777777778}, {
    1., 0.6888888888888889}, {1., 0.6}, {1., 0.5135802469135802}, {1., 
    0.43209876543209874`}, {1., 0.3555555555555555}, {1., 
    0.2839506172839506}, {1., 0.21728395061728392`}, {1., 
    0.15555555555555553`}, {1., 0.09876543209876541}, {1., 
    0.04691358024691357}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.8}}], 
      ArrowBox[{1, 2}], 
      ArrowBox[{1, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
       23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40,
        41, 42, 4}], ArrowBox[{2, 3}], ArrowBox[{2, 5}], ArrowBox[{3, 4}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 3.}, {0., 2.}, {-1., 1.}, {1., 0.}, {0., 
     1.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{148, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1591715662]
}, Open  ]],

Cell["This shows edges as lines:", "ExampleText",
 CellID->1234815803],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->508219463],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 3.}, {0., 2.}, {-1., 1.}, {1., 0.}, {0., 
    1.}, {1., 2.}, {1., 1.}, {0.04835996651265902, 2.9516400334873407`}, {
    0.10455097716174719`, 2.895449022838253}, {0.16857303194726453`, 
    2.8314269680527353`}, {0.24042613086921105`, 2.7595738691307887`}, {
    0.32011027392758673`, 2.679889726072413}, {0.4076254611223915, 
    2.5923745388776083`}, {0.5029716924536255, 2.4970283075463744`}, {
    0.6061489679212887, 2.393851032078711}, {0.717157287525381, 
    2.282842712474619}, {0.7765193382916591, 2.2185423901034027`}, {
    0.8288976183795514, 2.151349295200695}, {0.8742921277890582, 
    2.081263427766497}, {0.9127028665201793, 2.0082847878008083`}, {
    0.9441298345729148, 1.9324133753036286`}, {0.9685730319472645, 
    1.8536491902749577`}, {0.9860324586432286, 1.7719922327147961`}, {
    0.9965081146608071, 1.6874425026231434`}, {1., 1.4}, {1., 
    1.3111111111111111`}, {1., 1.222222222222222}, {1., 
    1.1333333333333333`}, {1., 1.0444444444444445`}, {1., 
    0.9555555555555555}, {1., 0.8666666666666667}, {1., 0.7777777777777778}, {
    1., 0.6888888888888889}, {1., 0.6}, {1., 0.5135802469135802}, {1., 
    0.43209876543209874`}, {1., 0.3555555555555555}, {1., 
    0.2839506172839506}, {1., 0.21728395061728392`}, {1., 
    0.15555555555555553`}, {1., 0.09876543209876541}, {1., 
    0.04691358024691357}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
        21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 
        38, 39, 40, 41, 42, 4}, {2, 3}, {2, 5}, {3, 4}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 3.}, {0., 2.}, {-1., 1.}, {1., 0.}, {0., 
     1.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{148, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->657169205]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EdgeLabeling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EdgeLabeling"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VertexLabeling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexLabeling"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EdgeRenderingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EdgeRenderingFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Arrowheads",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Arrowheads"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["General Graph Drawing",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphDrawing"]], "Tutorials",
 CellID->99260146],

Cell[TextData[ButtonBox["Hierarchical Drawing of Directed Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LayeredGraphDrawing"]], "Tutorials",
 CellID->106430589],

Cell[TextData[ButtonBox["Tree Drawing",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TreeDrawing"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DirectedEdges - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 21.1331794}", "context" -> "System`", 
    "keywords" -> {
     "directed graph edges", "directed graph plot", "directed tree plot"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "DirectedEdges is an option for GraphPlot and related functions which \
specifies whether edges should by default be drawn as directed arrows, or as \
undirected lines.", "synonyms" -> {"directed edges"}, "title" -> 
    "DirectedEdges", "type" -> "Symbol", "uri" -> "ref/DirectedEdges"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6501, 199, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->405887715]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26722, 823}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1880, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2503, 70, 1578, 37, 70, "ObjectNameGrid"],
Cell[4084, 109, 686, 19, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4807, 133, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5285, 150, 261, 8, 70, "Notes",
 CellID->1067943069],
Cell[5549, 160, 262, 8, 70, "Notes",
 CellID->636852794],
Cell[5814, 170, 258, 9, 70, "Notes",
 CellID->659927552],
Cell[6075, 181, 389, 13, 70, "Notes",
 CellID->200462403]
}, Closed]],
Cell[CellGroupData[{
Cell[6501, 199, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->405887715],
Cell[CellGroupData[{
Cell[6886, 213, 148, 5, 70, "ExampleSection",
 CellID->111071823],
Cell[7037, 220, 209, 8, 70, "ExampleText",
 CellID->502812571],
Cell[CellGroupData[{
Cell[7271, 232, 496, 14, 28, "Input",
 CellID->275915656],
Cell[7770, 248, 1676, 47, 167, "Output",
 CellID->1233816003]
}, Open  ]],
Cell[9461, 298, 123, 3, 70, "ExampleDelimiter",
 CellID->4492989],
Cell[9587, 303, 231, 8, 70, "ExampleText",
 CellID->2058444472],
Cell[CellGroupData[{
Cell[9843, 315, 504, 14, 70, "Input",
 CellID->573837420],
Cell[10350, 331, 2569, 65, 70, "Output",
 CellID->1870222530]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12968, 402, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[13192, 411, 354, 13, 70, "ExampleText",
 CellID->912955084],
Cell[CellGroupData[{
Cell[13571, 428, 338, 10, 70, "Input",
 CellID->1575850861],
Cell[13912, 440, 1167, 36, 70, "Output",
 CellID->217311597]
}, Open  ]],
Cell[15094, 479, 64, 1, 70, "ExampleText",
 CellID->928470380],
Cell[CellGroupData[{
Cell[15183, 484, 413, 12, 70, "Input",
 CellID->1480502994],
Cell[15599, 498, 1256, 37, 70, "Output",
 CellID->1704932953]
}, Open  ]],
Cell[16870, 538, 126, 3, 70, "ExampleDelimiter",
 CellID->1148795811],
Cell[16999, 543, 241, 8, 70, "ExampleText",
 CellID->2112634824],
Cell[CellGroupData[{
Cell[17265, 555, 345, 10, 70, "Input",
 CellID->1679766667],
Cell[17613, 567, 2615, 60, 70, "Output",
 CellID->1591715662]
}, Open  ]],
Cell[20243, 630, 70, 1, 70, "ExampleText",
 CellID->1234815803],
Cell[CellGroupData[{
Cell[20338, 635, 420, 12, 70, "Input",
 CellID->508219463],
Cell[20761, 649, 2526, 59, 70, "Output",
 CellID->657169205]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23348, 715, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[23667, 726, 995, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[24699, 766, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[25020, 777, 147, 3, 70, "Tutorials",
 CellID->99260146],
Cell[25170, 782, 173, 3, 70, "Tutorials",
 CellID->106430589],
Cell[25346, 787, 138, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[25499, 793, 27, 0, 70, "History"],
Cell[25529, 795, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

