(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12531,        443]
NotebookOptionsPosition[      9436,        335]
NotebookOutlinePosition[     10654,        371]
CellTagsIndexPosition[     10569,        366]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Assumptions" :> 
         Documentation`HelpLookup["paclet:ref/Assumptions"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Assumptions\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Direction", "ObjectName",
 CellID->32454],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Direction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Direction"]], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Limit",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Limit"]], "InlineFormula"],
     " that specifies the direction in which the limit is taken."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21003]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Direction", "->", "1"}]], "InlineFormula"],
 " takes variables to approach their limits by increasing from smaller \
values."
}], "Notes",
 CellID->9001],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Direction", "->", 
   RowBox[{"-", "1"}]}]], "InlineFormula"],
 " takes variables to approach their limits by decreasing from larger \
values."
}], "Notes",
 CellID->474802472],

Cell[TextData[{
 "The default setting is ",
 Cell[BoxData[
  RowBox[{"Direction", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", which determines the direction from assumptions that have been given, \
using ",
 Cell[BoxData[
  RowBox[{"Direction", "->", 
   RowBox[{"-", "1"}]}]], "InlineFormula"],
 " as the default. For limit points at infinity, the direction is determined \
from the direction of the infinity."
}], "Notes",
 CellID->21341854]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->300856327],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->120227237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"1", "/", "x"}], ",", 
   RowBox[{"x", "->", "0"}], ",", 
   RowBox[{"Direction", "->", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16395073],

Cell[BoxData[
 RowBox[{"-", "\[Infinity]"}]], "Output",
 ImageSize->{20, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->200764843]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"1", "/", "x"}], ",", 
   RowBox[{"x", "->", "0"}], ",", 
   RowBox[{"Direction", "\[Rule]", 
    RowBox[{"-", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->156975479],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6297331]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"1", "/", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->51920037],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFmDtMHEcYx8e3y90BSYych1EUm7OURKRJUIqEKJGD88AYgyEvB8kNyIqE
I0VBjgs6SkpKSkqkNDSWKCkpKSkpKSkpL7/v+2bZ3bnZBWwnWen2Zmf+3/sx
szu79Gz5tz+Wnj15vNS5+3RpZfnJ4786k38+ZSq54px7zu/3Yce4y0h/z7td
/h/JPZFnvdxDnf1ZZ7e3tw8PD2WYcmsA+rWwurCwACBbVR57e3shj/Hx8f39
/fNQQ0NDJycn1aifdPb4+Hh4eFiGfSV9bBWCiYmJbLWXxwPuMtnwtM0oak7u
rdwfzi0vL29ubjKo4DvFPWUy6aEcGxs7ODjIKIWwSgb2n56eVsvopYC3DS5M
gR21FA+8Xxq6uri46OyK++lHne10OkdHRzJsliLyg66yBEAVifIw1NbWFsLO
QwEBWI2a11mcSIaQSq5d0mc+yJB2DQ+LdzVqLpOEbWSk669BUSCUiQz7S/rY
6tTU1O7ubrYaj0gx6wdqUCsrKxsbG9Wo2Swio6OjkmqDJX1sdX5+fmdnR4aD
UR4zgRcTn9XxDLmf+YlUpY3kcfMZmdRQmTWSfQJIL0Q5rbMYgBml6BWo8hq8
p1O0JmwRf7S6dV1hSmcpZtBZdhV5xyvqbsFfQjXgZcTRkzqL2R59rRSh77Jc
IGnwjnsryuNbnV1fXyfKpJZ7O4q6I/eU3CQyq6urCHsnirutprFM5ZHsZLK0
s+GSXq1u3lWLHhHEiEcmhTWJ6VmX6UMc5QZvypvcdO8GenRqOIzUSFZ8NANc
WuyJN3pmNP5N8Z1zlB2xoBnggvcCzUZ6KMP8vnGu9Ib9Jd4ob1dyLt31ru04
jTjHFiqSAiQKM3aXPjXyr1lwQT/3MyCBSCYGnAu4414SULwdRvGmj3znP9TS
mizuoYmsra2R7+hne61th7SL7CR061xvZmeUzivT72rX94A9vVwDJd0AEUZN
ThDmT7of0xS3IHqrI8yuM+1q7ShSjFzQnmJHzbqeNEPXpKLW9DIPkwoNbfVW
b+JztSwhL8BLL8x4Zf+h1p1g/WYg20pMd8bUgstFG01FWGq+syuRmSZNyTDm
R+L+VSDxYYEjGW1omncqFiZ2mJXFyW6xWz6KcrnMrFj4d9mi2D70gs/NV8wv
3On+N/mXee7x6ofB8weBVZXrJa7VUZb80J1b9tq97CL1XKJ1YGWidSG3xBgI
QRrl/Lk+02qtlVk1pWdcSHettz4GE9nFqpdmKa/9hVsrKuETFU5ZUKIQ0cNF
M6tiuqW1IS/3jF92zujh9lHX913qB1ZQ0wlsj6C5wYTdTHS5FaV+X6mxFmra
NOKtEVLe0AGiYY6WfK182pxJoUBAu92GCDh1DJuPo1J0l2mxjIKjekGA9XJ2
/DRKoWeZJkbbcQwRDBD6WRRtr7Us03qwHilyZv6ipPd1xWAOwYIjbVSkfxnl
p+fDlHU4cb4iCLejuDcVhyycjX4QfB3FXdNnRPqX2jslzWwVj6C96PRNlMeQ
PhMj/6aiOa9v74nrPRVfzXh6tJ6ArWqKp72A6g19xhLsluH3lVTy+LrOE0bS
QIaTF5Lxmj4TB3whJys95+uXjNjp3tD515IcXZQRfvewN7D8bUbVc794GXG0
hSZHZ9EZzGLnPwHci0bH3kHz99rpGlT+XluHyvWZLuljq3QPck6G96M82kH8
61BUDCpXo1qBxJmSPvqtgDYzW0Obf8eaiaJs56LaaaoyjPNqBlGdLenRCiyu
45H71lBz3fLXrfjOS3T9pyb9amBfPHrPbjW53xd48uX4YCjmXpZP3i3yqno5
Peim/kvni/JJM/+ym8hw7iwq2fkzFhWjIpD+c95cKR8MnddavtrLI+94daj8
21aA8tVjKPZB/zW2rE9whvWesHOMu/IPSZB+cg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->609882876]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31465],

Cell["By default, the limit is taken from above:", "ExampleText",
 CellID->399676876],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"1", "/", "x"}], ",", 
   RowBox[{"x", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->396317569],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->99857783]
}, Open  ]],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"Direction", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
 " can affect the direction:"
}], "ExampleText",
 CellID->128454799],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"1", "/", "x"}], ",", 
   RowBox[{"x", "\[Rule]", "0"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"x", "<", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->345908986],

Cell[BoxData[
 RowBox[{"-", "\[Infinity]"}]], "Output",
 ImageSize->{20, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->369873974]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8828],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->29993]
}, Open  ]],

Cell["New in 2  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Direction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 21.9300748}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Direction is an option for Limit that specifies the direction in which \
the limit is taken.", "synonyms" -> {}, "title" -> "Direction", "type" -> 
    "Symbol", "uri" -> "ref/Direction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3338, 122, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->300856327]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10426, 359}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 574, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1197, 42, 47, 1, 70, "ObjectName",
 CellID->32454],
Cell[1247, 45, 599, 18, 70, "Usage",
 CellID->21003]
}, Open  ]],
Cell[CellGroupData[{
Cell[1883, 68, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2361, 85, 195, 6, 70, "Notes",
 CellID->9001],
Cell[2559, 93, 218, 7, 70, "Notes",
 CellID->474802472],
Cell[2780, 102, 521, 15, 70, "Notes",
 CellID->21341854]
}, Closed]],
Cell[CellGroupData[{
Cell[3338, 122, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->300856327],
Cell[CellGroupData[{
Cell[3723, 136, 148, 5, 70, "ExampleSection",
 CellID->120227237],
Cell[CellGroupData[{
Cell[3896, 145, 215, 7, 28, "Input",
 CellID->16395073],
Cell[4114, 154, 185, 6, 36, "Output",
 CellID->200764843]
}, Open  ]],
Cell[CellGroupData[{
Cell[4336, 165, 241, 8, 28, "Input",
 CellID->156975479],
Cell[4580, 175, 166, 5, 36, "Output",
 CellID->6297331]
}, Open  ]],
Cell[CellGroupData[{
Cell[4783, 185, 226, 8, 28, "Input",
 CellID->51920037],
Cell[5012, 195, 2144, 39, 127, "Output",
 Evaluatable->False,
 CellID->609882876]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7205, 240, 216, 7, 70, "ExampleSection",
 CellID->31465],
Cell[7424, 249, 85, 1, 70, "ExampleText",
 CellID->399676876],
Cell[CellGroupData[{
Cell[7534, 254, 178, 6, 70, "Input",
 CellID->396317569],
Cell[7715, 262, 167, 5, 36, "Output",
 CellID->99857783]
}, Open  ]],
Cell[7897, 270, 402, 14, 70, "ExampleText",
 CellID->128454799],
Cell[CellGroupData[{
Cell[8324, 288, 253, 8, 70, "Input",
 CellID->345908986],
Cell[8580, 298, 185, 6, 36, "Output",
 CellID->369873974]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8826, 311, 310, 9, 70, "SeeAlsoSection",
 CellID->8828],
Cell[9139, 322, 202, 6, 70, "SeeAlso",
 CellID->29993]
}, Open  ]],
Cell[9356, 331, 50, 0, 70, "History"],
Cell[9409, 333, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

