(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    113921,       2241]
NotebookOptionsPosition[    109874,       2104]
NotebookOutlinePosition[    111197,       2142]
CellTagsIndexPosition[    111110,       2137]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics" :> Documentation`HelpLookup["paclet:ref/Graphics"], 
          "Style" :> Documentation`HelpLookup["paclet:ref/Style"], 
          "PlotStyle" :> Documentation`HelpLookup["paclet:ref/PlotStyle"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Graphics\"\>", 
       2->"\<\"Style\"\>", 3->"\<\"PlotStyle\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combining Graphics" :> 
          Documentation`HelpLookup["paclet:guide/CombiningGraphics"], 
          "Graphics Directives" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsDirectives"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Combining Graphics\"\>", 
       2->"\<\"Graphics Directives\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Directive", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Directive",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Directive"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a single graphics directive composed of the \
directives ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25582]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Any directives supported by ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " can appear inside ",
 Cell[BoxData[
  ButtonBox["Directive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Directive"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20931],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Directive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Directive"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["g", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["g", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Directive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Directive"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["g", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["g", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->22090]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->859527212],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->381674907],

Cell["Give composite directives for primitives in a graphic:", "ExampleText",
 CellID->632644587],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Directive", "[", 
     RowBox[{"Red", ",", "Thick"}], "]"}], ",", 
    RowBox[{"Circle", "[", "]"}], ",", 
    RowBox[{"Directive", "[", 
     RowBox[{"Blue", ",", 
      RowBox[{"Opacity", "[", "0.5", "]"}]}], "]"}], ",", 
    RowBox[{"Rectangle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->99521974],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0, 0], Thickness[Large], CircleBox[{0, 0}], 
   {RGBColor[0, 0, 1], Opacity[0.5], 
    RectangleBox[{0, -1}, {2, 1}]}}]], "Output",
 ImageSize->{154, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->141105470]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->531239412],

Cell["\<\
Give a composite directive for a single curve or surface in a plot:\
\>", "ExampleText",
 CellID->8552],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"Directive", "[", 
     RowBox[{"Orange", ",", "Thick", ",", "Dashed"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31498],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->283849579]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "+", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Orange", ",", 
      RowBox[{"Specularity", "[", 
       RowBox[{"White", ",", "10"}], "]"}]}], "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->339707856],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->503065113]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->471506395],

Cell["Give a composite directive for each curve in a plot:", "ExampleText",
 CellID->374927076],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Directive", "[", 
       RowBox[{"Red", ",", "Dashed"}], "]"}], ",", 
      RowBox[{"Directive", "[", 
       RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->218169481],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8173479]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->182645607],

Cell["Combine font styles:", "ExampleText",
 CellID->102068611],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"2", 
       RowBox[{"Sin", "[", "x", "]"}]}]}], "}"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Medium", ",", "Italic"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24833615],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->226402282]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17903],

Cell["Mesh shading with composite directives:", "ExampleText",
 CellID->311925579],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", "\[Phi]", "]"}], 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "\[Phi]", "]"}], 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", "Pi"}], "}"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Directive", "[", 
         RowBox[{"Red", ",", 
          RowBox[{"Specularity", "[", 
           RowBox[{"White", ",", "10"}], "]"}]}], "]"}], ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Green", ",", 
          RowBox[{"Opacity", "[", "0.5", "]"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", "Yellow"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->213177498],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 337},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[1]=",
 CellID->745142260]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10158],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotStyle"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7504]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->482674554],

Cell[TextData[ButtonBox["Combining Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CombiningGraphics"]], "MoreAbout",
 CellID->75518614],

Cell[TextData[ButtonBox["Graphics Directives",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsDirectives"]], "MoreAbout",
 CellID->93240495]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Directive - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 22.3519606}", "context" -> "System`", 
    "keywords" -> {
     "graphics directive", "composite graphics directive", 
      "multiple directives"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Directive[g_1, g_2, ...] represents a single graphics directive composed \
of the directives g_1, g_2, ....", "synonyms" -> {}, "title" -> "Directive", 
    "type" -> "Symbol", "uri" -> "ref/Directive"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6579, 214, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->859527212]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 110967, 2130}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1474, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2097, 61, 1574, 37, 70, "ObjectNameGrid"],
Cell[3674, 100, 1061, 36, 70, "Usage",
 CellID->25582]
}, Open  ]],
Cell[CellGroupData[{
Cell[4772, 141, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5250, 158, 479, 18, 70, "Notes",
 CellID->20931],
Cell[5732, 178, 810, 31, 70, "Notes",
 CellID->22090]
}, Closed]],
Cell[CellGroupData[{
Cell[6579, 214, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->859527212],
Cell[CellGroupData[{
Cell[6964, 228, 148, 5, 70, "ExampleSection",
 CellID->381674907],
Cell[7115, 235, 97, 1, 70, "ExampleText",
 CellID->632644587],
Cell[CellGroupData[{
Cell[7237, 240, 575, 18, 47, "Input",
 CellID->99521974],
Cell[7815, 260, 358, 10, 123, "Output",
 CellID->141105470]
}, Open  ]],
Cell[8188, 273, 125, 3, 70, "ExampleDelimiter",
 CellID->531239412],
Cell[8316, 278, 113, 3, 70, "ExampleText",
 CellID->8552],
Cell[CellGroupData[{
Cell[8454, 285, 344, 11, 28, "Input",
 CellID->31498],
Cell[8801, 298, 3059, 54, 127, "Output",
 Evaluatable->False,
 CellID->283849579]
}, Open  ]],
Cell[CellGroupData[{
Cell[11897, 357, 620, 19, 47, "Input",
 CellID->339707856],
Cell[12520, 378, 27069, 448, 159, "Output",
 Evaluatable->False,
 CellID->503065113]
}, Open  ]],
Cell[39604, 829, 125, 3, 70, "ExampleDelimiter",
 CellID->471506395],
Cell[39732, 834, 95, 1, 70, "ExampleText",
 CellID->374927076],
Cell[CellGroupData[{
Cell[39852, 839, 547, 17, 47, "Input",
 CellID->218169481],
Cell[40402, 858, 4647, 80, 127, "Output",
 Evaluatable->False,
 CellID->8173479]
}, Open  ]],
Cell[45064, 941, 125, 3, 70, "ExampleDelimiter",
 CellID->182645607],
Cell[45192, 946, 63, 1, 70, "ExampleText",
 CellID->102068611],
Cell[CellGroupData[{
Cell[45280, 951, 560, 17, 47, "Input",
 CellID->24833615],
Cell[45843, 970, 3080, 55, 151, "Output",
 Evaluatable->False,
 CellID->226402282]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[48972, 1031, 224, 7, 70, "ExampleSection",
 CellID->17903],
Cell[49199, 1040, 82, 1, 70, "ExampleText",
 CellID->311925579],
Cell[CellGroupData[{
Cell[49306, 1045, 1095, 32, 70, "Input",
 CellID->213177498],
Cell[50404, 1079, 57676, 950, 70, "Output",
 Evaluatable->False,
 CellID->745142260]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[108141, 2036, 311, 9, 70, "SeeAlsoSection",
 CellID->10158],
Cell[108455, 2047, 691, 26, 70, "SeeAlso",
 CellID->7504]
}, Open  ]],
Cell[CellGroupData[{
Cell[109183, 2078, 319, 9, 70, "MoreAboutSection",
 CellID->482674554],
Cell[109505, 2089, 146, 3, 70, "MoreAbout",
 CellID->75518614],
Cell[109654, 2094, 148, 3, 70, "MoreAbout",
 CellID->93240495]
}, Open  ]],
Cell[109817, 2100, 27, 0, 70, "History"],
Cell[109847, 2102, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

