(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14531,        511]
NotebookOptionsPosition[     11382,        406]
NotebookOutlinePosition[     12723,        444]
CellTagsIndexPosition[     12638,        439]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Naming and Finding Files" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NamingAndFindingFiles"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Naming and Finding Files\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$Input" :> Documentation`HelpLookup["paclet:ref/$Input"], 
          "Directory" :> Documentation`HelpLookup["paclet:ref/Directory"], 
          "ParentDirectory" :> 
          Documentation`HelpLookup["paclet:ref/ParentDirectory"], 
          "SetDirectory" :> 
          Documentation`HelpLookup["paclet:ref/SetDirectory"], "ToFileName" :> 
          Documentation`HelpLookup["paclet:ref/ToFileName"], "$Path" :> 
          Documentation`HelpLookup["paclet:ref/$Path"], "$PathnameSeparator" :> 
          Documentation`HelpLookup["paclet:ref/$PathnameSeparator"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"$Input\"\>", 
       2->"\<\"Directory\"\>", 3->"\<\"ParentDirectory\"\>", 
       4->"\<\"SetDirectory\"\>", 5->"\<\"ToFileName\"\>", 6->"\<\"$Path\"\>",
        7->"\<\"$PathnameSeparator\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Directories & Directory Operations" :> 
          Documentation`HelpLookup[
           "paclet:guide/DirectoriesAndDirectoryOperations"], 
          "File Operations" :> 
          Documentation`HelpLookup["paclet:guide/FileOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Directories & Directory Operations\"\>", 
       2->"\<\"File Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DirectoryName", "ObjectName",
 CellID->25084],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DirectoryName",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DirectoryName"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]extracts the directory name from the specification for \
a file. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17915]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DirectoryName",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DirectoryName"]], "InlineFormula"],
 " works differently on different computer systems. "
}], "Notes",
 CellID->30667],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DirectoryName",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectoryName"], "[", "\"\<\!\(\*
StyleBox[\"directory\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " is normally equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ParentDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ParentDirectory"], "[", "\"\<\!\(\*
StyleBox[\"directory\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31010],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DirectoryName",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectoryName"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula", "TemplateInclusion"],
 " applies ",
 Cell[BoxData[
  RowBox[{"DirectoryName", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " times to ",
 Cell[BoxData[
  StyleBox["name", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24637],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DirectoryName",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DirectoryName"]], "InlineFormula"],
 " yields output appropriate for use in ",
 Cell[BoxData[
  ButtonBox["SetDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDirectory"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ToFileName",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToFileName"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6969],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["name", "TI"]], "InlineFormula"],
 " contains no directory specification, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DirectoryName",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectoryName"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " returns ",
 Cell[BoxData["\"\<\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17484]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->534093573],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->349000476],

Cell["On Windows get the directory string:", "ExampleText",
 CellID->570158568],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DirectoryName", "[", "\"\<a\\\\b\\\\c\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->228155901],

Cell[BoxData["\<\"a\\\\b\\\\\"\>"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->559085161]
}, Open  ]],

Cell[TextData[{
 "Apply ",
 Cell[BoxData[
  ButtonBox["DirectoryName",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DirectoryName"]], "InlineFormula"],
 " two times:"
}], "ExampleText",
 CellID->383849760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DirectoryName", "[", 
  RowBox[{"\"\<a\\\\b\\\\c\>\"", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->847279139],

Cell[BoxData["\<\"a\\\\\"\>"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->11294321]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14904],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Input",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Input"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Directory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Directory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ParentDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ParentDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToFileName",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToFileName"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Path",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Path"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$PathnameSeparator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$PathnameSeparator"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1445]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31282],

Cell[TextData[ButtonBox["Naming and Finding Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NamingAndFindingFiles"]], "Tutorials",
 CellID->18326]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->67490228],

Cell[TextData[ButtonBox["Directories & Directory Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DirectoriesAndDirectoryOperations"]], "MoreAbout",
 CellID->130636280],

Cell[TextData[ButtonBox["File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FileOperations"]], "MoreAbout",
 CellID->456777539]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DirectoryName - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 23.3832370}", "context" -> "System`", 
    "keywords" -> {
     "file name parts", "file path", "directory path", "file utilities", 
      "file operations"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "DirectoryName[\"name\"] extracts the directory name from the \
specification for a file. ", "synonyms" -> {"directory name"}, "title" -> 
    "DirectoryName", "type" -> "Symbol", "uri" -> "ref/DirectoryName"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6515, 214, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->534093573]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12495, 432}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2614, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3237, 87, 51, 1, 70, "ObjectName",
 CellID->25084],
Cell[3291, 90, 535, 16, 70, "Usage",
 CellID->17915]
}, Open  ]],
Cell[CellGroupData[{
Cell[3863, 111, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4341, 128, 227, 7, 70, "Notes",
 CellID->30667],
Cell[4571, 137, 500, 16, 70, "Notes",
 CellID->31010],
Cell[5074, 155, 495, 18, 70, "Notes",
 CellID->24637],
Cell[5572, 175, 481, 17, 70, "Notes",
 CellID->6969],
Cell[6056, 194, 422, 15, 70, "Notes",
 CellID->17484]
}, Closed]],
Cell[CellGroupData[{
Cell[6515, 214, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->534093573],
Cell[CellGroupData[{
Cell[6900, 228, 148, 5, 70, "ExampleSection",
 CellID->349000476],
Cell[7051, 235, 79, 1, 70, "ExampleText",
 CellID->570158568],
Cell[CellGroupData[{
Cell[7155, 240, 127, 3, 28, "Input",
 CellID->228155901],
Cell[7285, 245, 175, 5, 36, "Output",
 CellID->559085161]
}, Open  ]],
Cell[7475, 253, 209, 8, 70, "ExampleText",
 CellID->383849760],
Cell[CellGroupData[{
Cell[7709, 265, 150, 4, 28, "Input",
 CellID->847279139],
Cell[7862, 271, 169, 5, 36, "Output",
 CellID->11294321]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8092, 283, 311, 9, 70, "SeeAlsoSection",
 CellID->14904],
Cell[8406, 294, 1713, 62, 70, "SeeAlso",
 CellID->1445]
}, Open  ]],
Cell[CellGroupData[{
Cell[10156, 361, 314, 9, 70, "TutorialsSection",
 CellID->31282],
Cell[10473, 372, 156, 3, 70, "Tutorials",
 CellID->18326]
}, Open  ]],
Cell[CellGroupData[{
Cell[10666, 380, 318, 9, 70, "MoreAboutSection",
 CellID->67490228],
Cell[10987, 391, 179, 3, 70, "MoreAbout",
 CellID->130636280],
Cell[11169, 396, 141, 3, 70, "MoreAbout",
 CellID->456777539]
}, Open  ]],
Cell[11325, 402, 27, 0, 70, "History"],
Cell[11355, 404, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

