(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     32702,       1221]
NotebookOptionsPosition[     25835,        983]
NotebookOutlinePosition[     27203,       1021]
CellTagsIndexPosition[     27117,       1016]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Generalized Functions and Related Objects" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GeneralizedFunctionsAndRelatedObjects"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Generalized Functions and Related Objects\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"IdentityMatrix" :> 
          Documentation`HelpLookup["paclet:ref/IdentityMatrix"], "UnitStep" :> 
          Documentation`HelpLookup["paclet:ref/UnitStep"], "If" :> 
          Documentation`HelpLookup["paclet:ref/If"], "Boole" :> 
          Documentation`HelpLookup["paclet:ref/Boole"], "Signature" :> 
          Documentation`HelpLookup["paclet:ref/Signature"], "DiracDelta" :> 
          Documentation`HelpLookup["paclet:ref/DiracDelta"], "KroneckerDelta" :> 
          Documentation`HelpLookup["paclet:ref/KroneckerDelta"], 
          "HeavisideTheta" :> 
          Documentation`HelpLookup["paclet:ref/HeavisideTheta"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"IdentityMatrix\"\>", 
       2->"\<\"UnitStep\"\>", 3->"\<\"If\"\>", 4->"\<\"Boole\"\>", 
       5->"\<\"Signature\"\>", 6->"\<\"DiracDelta\"\>", 
       7->"\<\"KroneckerDelta\"\>", 
       8->"\<\"HeavisideTheta\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Discrete Mathematics" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteMathematics"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Discrete Mathematics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DiscreteDelta", "ObjectName",
 CellID->8181],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DiscreteDelta",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DiscreteDelta"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the discrete delta function ",
     Cell[BoxData[
      RowBox[{"\[Delta]", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox[
          StyleBox["n", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["n", "TI"], 
          StyleBox["2", "TR"]], ",", "\[Ellipsis]"}], ")"}]}]], 
      "InlineFormula"],
     ", equal to ",
     Cell[BoxData["1"], "InlineFormula"],
     " if all the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " are zero, and ",
     Cell[BoxData["0"], "InlineFormula"],
     " otherwise. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17760]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DiscreteDelta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DiscreteDelta"], "[", "0", "]"}]], 
  "InlineFormula"],
 " gives ",
 Cell[BoxData["1"], "InlineFormula"],
 "; ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DiscreteDelta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DiscreteDelta"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData["0"], "InlineFormula"],
 " for other numeric ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8874],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DiscreteDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiscreteDelta"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["Orderless",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orderless"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32351]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->98199246],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->260604430],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"DiscreteDelta", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->72084557],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->611699766]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->202811536],

Cell["Use in sums:", "ExampleText",
 CellID->15982272],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"DiscreteDelta", "[", 
     RowBox[{"a", "-", "n"}], "]"}], " ", 
    RowBox[{"f", "[", "a", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26625622],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "n", "]"}], " ", 
  RowBox[{"UnitStep", "[", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "n"}], "]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->128481266]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8690],

Cell["One\[Hyphen]argument form:", "ExampleText",
 CellID->34423497],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiscreteDelta", "[", "0", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->169200984],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->280153289]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->642218688],

Cell["Multi\[Hyphen]argument form:", "ExampleText",
 CellID->427740456],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiscreteDelta", "[", 
  RowBox[{"1", ",", "1", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->93338508],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->88677368]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->372679278],

Cell["Arguments can be approximate numbers:", "ExampleText",
 CellID->390080926],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiscreteDelta", "[", 
  RowBox[{"0", ",", "0.", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->510907269],

Cell[BoxData["1"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6089495]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->36716272],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " typesetting:"
}], "ExampleText",
 CellID->51281577],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DiscreteDelta", "[", 
   RowBox[{"n", ",", "m"}], "]"}], " ", "//", " ", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->578979733],

Cell[BoxData[
 FormBox[
  RowBox[{
   InterpretationBox["\[Delta]",
    DiscreteDelta,
    Editable->False,
    Selectable->False], "(", 
   RowBox[{"m", ",", "n"}], ")"}], TraditionalForm]], "Output",
 ImageSize->{40, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->768942082]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4447],

Cell["Use in sums to pick out terms:", "ExampleText",
 CellID->450176856],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"DiscreteDelta", "[", 
     RowBox[{"k", "-", "j", "-", " ", "3"}], "]"}], "/", 
    RowBox[{"j", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "Infinity"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->98506651],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[Pi]", "2"], "6"]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{22, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->506453988]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->355599840],

Cell["Pick out elements:", "ExampleText",
 CellID->222935971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"DiscreteDelta", "[", 
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{"Fibonacci", "[", 
        RowBox[{
         RowBox[{"2", "m"}], ",", 
         RowBox[{"3", "n"}]}], "]"}], ",", "5"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", "120", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", "60"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->34357131],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGCwgWJGRkoQ+QQlgBJ7Bw6NhtVoWI2G1WhYjYbVaFiNhtVo
WI2G1WhYjYbVaFgNrrACABq5CmE=
   "], {{0, 0}, {60, 60}}, {0, 1}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  PlotRangeClipping->True]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->155861804]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->63545126],

Cell["\<\
Patch pointwise values of piecewise\[Hyphen]defined functions: \
\>", "ExampleText",
 CellID->278376007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListLinePlot", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{
         RowBox[{"UnitStep", "[", "x", "]"}], "+", 
         RowBox[{"UnitStep", "[", 
          RowBox[{"-", "x"}], "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{
         RowBox[{"UnitStep", "[", "x", "]"}], "+", 
         RowBox[{"UnitStep", "[", 
          RowBox[{"-", "x"}], "]"}], "-", 
         RowBox[{"DiscreteDelta", "[", "x", "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->803712154],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{-5., 1.}, {-4., 1.}, {-3., 1.}, {-2., 1.}, {-1., 1.}, {0., 
       2.}, {1., 1.}, {2., 1.}, {3., 1.}, {4., 1.}, {5., 1.}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 1.},
    PlotRange->{{-5., 5.}, {1., 2.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{-5., 1.}, {-4., 1.}, {-3., 1.}, {-2., 1.}, {-1., 1.}, {0., 
       1.}, {1., 1.}, {2., 1.}, {3., 1.}, {4., 1.}, {5., 1.}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{-5., 5.}, {1., 1.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{390, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->542330575]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32009],

Cell[TextData[{
 "Reduce an equation containing ",
 Cell[BoxData[
  ButtonBox["DiscreteDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiscreteDelta"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->296890723],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", "-", 
      RowBox[{"DiscreteDelta", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"a", "^", "2"}], "+", "4"}], ",", 
        RowBox[{
         RowBox[{"2", "a"}], "-", "2"}]}], "]"}]}], "==", "2"}], " ", "&&", 
    " ", 
    RowBox[{
     RowBox[{"-", "10"}], "<", "a", "<", "10"}]}], ",", "a", ",", 
   "Integers"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->701382552],

Cell[BoxData[
 RowBox[{"a", "\[Equal]", "2"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{35, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->674075660]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->44093004],

Cell[TextData[{
 "The support of ",
 Cell[BoxData[
  ButtonBox["DiscreteDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiscreteDelta"]], "InlineFormula"],
 " has measure zero:"
}], "ExampleText",
 CellID->230684756],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"DiscreteDelta", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->310261885],

Cell[BoxData["0"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8730458]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14635],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DiscreteDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiscreteDelta"]], "InlineFormula"],
 " can stay unevaluated with numeric arguments: "
}], "ExampleText",
 CellID->216960259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiscreteDelta", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"2", "-", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"2", "+", 
        RowBox[{"Sqrt", "[", "2", "]"}]}], "]"}]}], "]"}], "/", "2"}], "-", 
   RowBox[{"Sin", "[", 
    RowBox[{"Pi", "/", "16"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->216748861],

Cell[BoxData[
 RowBox[{"DiscreteDelta", "[", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    SqrtBox[
     RowBox[{"2", "-", 
      SqrtBox[
       RowBox[{"2", "+", 
        SqrtBox["2"]}]]}]]}], "-", 
   RowBox[{"Sin", "[", 
    FractionBox["\[Pi]", "16"], "]"}]}], "]"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{291, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->275455653]
}, Open  ]],

Cell[TextData[{
 "A larger setting for ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " can be needed: "
}], "ExampleText",
 CellID->570393886],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"%", ",", " ", "20"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18466422],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(DiscreteDelta[\\(\\(\\(\\(1\\/2\\\\ \\@\\(2 - \
\\@\\(Plus[\\(\\(\[LeftSkeleton] 2 \[RightSkeleton]\\)\\)]\\)\\)\\)\\) - \
\\(\\(Sin[\\(\\(\[Pi]\\/16\\)\\)]\\)\\)\\)\\)]\\). \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->64237062],

Cell[BoxData["1"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->74184667]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "1000"}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"DiscreteDelta", "[", 
    RowBox[{"1", " ", "-", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"2", "-", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"2", "+", 
          RowBox[{"Sqrt", "[", "2", "]"}]}], "]"}]}], "]"}], "/", "2"}], "+", 
     
     RowBox[{"Sin", "[", 
      RowBox[{"Pi", "/", "16"}], "]"}], "+", 
     RowBox[{"10", "^", 
      RowBox[{"-", "100"}]}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->824331862],

Cell[BoxData["0"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->56109436]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21720241],

Cell["\<\
Equality testing of the arguments takes numerical precision into account:\
\>", "ExampleText",
 CellID->240197713],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiscreteDelta", "[", 
  RowBox[{"1", ",", " ", "1.00000000000001"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->171464433],

Cell[BoxData["0"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->281052960]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17818],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["IdentityMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IdentityMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UnitStep",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UnitStep"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["If",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/If"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Boole",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Boole"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Signature",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Signature"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DiracDelta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DiracDelta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["KroneckerDelta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/KroneckerDelta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HeavisideTheta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HeavisideTheta"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5154]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15347],

Cell[TextData[ButtonBox["Generalized Functions and Related Objects",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/GeneralizedFunctionsAndRelatedObjects"]], "Tutorials",
 CellID->20173]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->14959],

Cell[TextData[{
 ButtonBox["Demonstrations with DiscreteDelta",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=DiscreteDelta"],
     None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/KroneckerDelta.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/IntegerFunctions/DiscreteDelta/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->208519358],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "MoreAbout",
 CellID->213287608]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DiscreteDelta - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 27.2427108}", "context" -> "System`", 
    "keywords" -> {
     "delta function", "delta sequence", "discrete Dirac delta"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "DiscreteDelta[n_1, n_2, ...] gives the discrete delta function \\[Delta] \
(n_1, n_2, ...), equal to 1 if all the n_i are zero, and 0 otherwise. ", 
    "synonyms" -> {"discrete delta"}, "title" -> "DiscreteDelta", "type" -> 
    "Symbol", "uri" -> "ref/DiscreteDelta"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5992, 196, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->98199246]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26975, 1009}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2559, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3182, 86, 50, 1, 70, "ObjectName",
 CellID->8181],
Cell[3235, 89, 1302, 43, 70, "Usage",
 CellID->17760]
}, Open  ]],
Cell[CellGroupData[{
Cell[4574, 137, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5052, 154, 580, 23, 70, "Notes",
 CellID->8874],
Cell[5635, 179, 320, 12, 70, "Notes",
 CellID->32351]
}, Closed]],
Cell[CellGroupData[{
Cell[5992, 196, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->98199246],
Cell[CellGroupData[{
Cell[6376, 210, 148, 5, 70, "ExampleSection",
 CellID->260604430],
Cell[CellGroupData[{
Cell[6549, 219, 244, 8, 28, "Input",
 CellID->72084557],
Cell[6796, 229, 233, 7, 36, "Output",
 CellID->611699766]
}, Open  ]],
Cell[7044, 239, 125, 3, 70, "ExampleDelimiter",
 CellID->202811536],
Cell[7172, 244, 54, 1, 70, "ExampleText",
 CellID->15982272],
Cell[CellGroupData[{
Cell[7251, 249, 299, 10, 28, "Input",
 CellID->26625622],
Cell[7553, 261, 336, 12, 36, "Output",
 CellID->128481266]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7938, 279, 215, 7, 70, "ExampleSection",
 CellID->8690],
Cell[8156, 288, 68, 1, 70, "ExampleText",
 CellID->34423497],
Cell[CellGroupData[{
Cell[8249, 293, 109, 3, 70, "Input",
 CellID->169200984],
Cell[8361, 298, 158, 5, 36, "Output",
 CellID->280153289]
}, Open  ]],
Cell[8534, 306, 125, 3, 70, "ExampleDelimiter",
 CellID->642218688],
Cell[8662, 311, 71, 1, 70, "ExampleText",
 CellID->427740456],
Cell[CellGroupData[{
Cell[8758, 316, 141, 4, 70, "Input",
 CellID->93338508],
Cell[8902, 322, 157, 5, 36, "Output",
 CellID->88677368]
}, Open  ]],
Cell[9074, 330, 125, 3, 70, "ExampleDelimiter",
 CellID->372679278],
Cell[9202, 335, 80, 1, 70, "ExampleText",
 CellID->390080926],
Cell[CellGroupData[{
Cell[9307, 340, 143, 4, 70, "Input",
 CellID->510907269],
Cell[9453, 346, 204, 7, 36, "Output",
 CellID->6089495]
}, Open  ]],
Cell[9672, 356, 124, 3, 70, "ExampleDelimiter",
 CellID->36716272],
Cell[9799, 361, 203, 7, 70, "ExampleText",
 CellID->51281577],
Cell[CellGroupData[{
Cell[10027, 372, 184, 6, 70, "Input",
 CellID->578979733],
Cell[10214, 380, 348, 12, 50, "Output",
 CellID->768942082]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10611, 398, 222, 7, 70, "ExampleSection",
 CellID->4447],
Cell[10836, 407, 73, 1, 70, "ExampleText",
 CellID->450176856],
Cell[CellGroupData[{
Cell[10934, 412, 375, 12, 70, "Input",
 CellID->98506651],
Cell[11312, 426, 254, 9, 54, "Output",
 CellID->506453988]
}, Open  ]],
Cell[11581, 438, 125, 3, 70, "ExampleDelimiter",
 CellID->355599840],
Cell[11709, 443, 61, 1, 70, "ExampleText",
 CellID->222935971],
Cell[CellGroupData[{
Cell[11795, 448, 517, 16, 70, "Input",
 CellID->34357131],
Cell[12315, 466, 444, 13, 201, "Output",
 CellID->155861804]
}, Open  ]],
Cell[12774, 482, 124, 3, 70, "ExampleDelimiter",
 CellID->63545126],
Cell[12901, 487, 114, 3, 70, "ExampleText",
 CellID->278376007],
Cell[CellGroupData[{
Cell[13040, 494, 941, 30, 70, "Input",
 CellID->803712154],
Cell[13984, 526, 1062, 31, 151, "Output",
 CellID->542330575]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15095, 563, 233, 7, 70, "ExampleSection",
 CellID->32009],
Cell[15331, 572, 223, 8, 70, "ExampleText",
 CellID->296890723],
Cell[CellGroupData[{
Cell[15579, 584, 481, 17, 70, "Input",
 CellID->701382552],
Cell[16063, 603, 235, 8, 36, "Output",
 CellID->674075660]
}, Open  ]],
Cell[16313, 614, 124, 3, 70, "ExampleDelimiter",
 CellID->44093004],
Cell[16440, 619, 225, 8, 70, "ExampleText",
 CellID->230684756],
Cell[CellGroupData[{
Cell[16690, 631, 249, 8, 70, "Input",
 CellID->310261885],
Cell[16942, 641, 204, 7, 36, "Output",
 CellID->8730458]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17195, 654, 226, 7, 70, "ExampleSection",
 CellID->14635],
Cell[17424, 663, 233, 7, 70, "ExampleText",
 CellID->216960259],
Cell[CellGroupData[{
Cell[17682, 674, 373, 12, 70, "Input",
 CellID->216748861],
Cell[18058, 688, 477, 18, 63, "Output",
 CellID->275455653]
}, Open  ]],
Cell[18550, 709, 247, 8, 70, "ExampleText",
 CellID->570393886],
Cell[CellGroupData[{
Cell[18822, 721, 125, 4, 70, "Input",
 CellID->18466422],
Cell[18950, 727, 583, 10, 70, "Message",
 CellID->64237062],
Cell[19536, 739, 205, 7, 36, "Output",
 CellID->74184667]
}, Open  ]],
Cell[CellGroupData[{
Cell[19778, 751, 625, 20, 70, "Input",
 CellID->824331862],
Cell[20406, 773, 205, 7, 36, "Output",
 CellID->56109436]
}, Open  ]],
Cell[20626, 783, 124, 3, 70, "ExampleDelimiter",
 CellID->21720241],
Cell[20753, 788, 124, 3, 70, "ExampleText",
 CellID->240197713],
Cell[CellGroupData[{
Cell[20902, 795, 152, 4, 70, "Input",
 CellID->171464433],
Cell[21057, 801, 206, 7, 36, "Output",
 CellID->281052960]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21324, 815, 311, 9, 70, "SeeAlsoSection",
 CellID->17818],
Cell[21638, 826, 1944, 71, 70, "SeeAlso",
 CellID->5154]
}, Open  ]],
Cell[CellGroupData[{
Cell[23619, 902, 314, 9, 70, "TutorialsSection",
 CellID->15347],
Cell[23936, 913, 192, 4, 70, "Tutorials",
 CellID->20173]
}, Open  ]],
Cell[CellGroupData[{
Cell[24165, 922, 321, 9, 70, "RelatedLinksSection",
 CellID->14959],
Cell[24489, 933, 371, 12, 70, "RelatedLinks"],
Cell[24863, 947, 185, 4, 70, "RelatedLinks"],
Cell[25051, 953, 202, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25290, 962, 319, 9, 70, "MoreAboutSection",
 CellID->208519358],
Cell[25612, 973, 151, 3, 70, "MoreAbout",
 CellID->213287608]
}, Open  ]],
Cell[25778, 979, 27, 0, 70, "History"],
Cell[25808, 981, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

