(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11571,        430]
NotebookOptionsPosition[      8165,        317]
NotebookOutlinePosition[      9491,        354]
CellTagsIndexPosition[      9407,        349]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink and External Program Communication" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]}\
, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"MathLink and External Program Communication\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DisplayPacket" :> 
          Documentation`HelpLookup["paclet:ref/DisplayPacket"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"DisplayPacket\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DisplayEndPacket", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DisplayEndPacket",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DisplayEndPacket"], "[", "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]is a ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " packet that indicates the end of a series of expressions relating to a \
postscript graphic."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->170637006],

Cell[TextData[{
 "Launch a subsidiary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel process:"
}], "ExampleText",
 CellID->1215824468],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"link", "=", 
  RowBox[{"LinkLaunch", "[", 
   RowBox[{
    RowBox[{"First", "[", "$CommandLine", "]"}], " ", "<>", " ", 
    "\"\< -mathlink\>\""}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->312144257],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"MathKernel -mathlink\"\>", ",", "904", ",", "7"}], 
  "]"}]], "Output",
 ImageSize->{279, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->169330410]
}, Open  ]],

Cell["Read the first packet:", "ExampleText",
 CellID->625050465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2053461425],

Cell[BoxData[
 RowBox[{"InputNamePacket", "[", "\<\"In[1]:= \"\>", "]"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->202580023]
}, Open  ]],

Cell["Write an expression that generates a postscript graphic:", "ExampleText",
 CellID->316479038],

Cell[BoxData[
 RowBox[{"LinkWrite", "[", 
  RowBox[{"link", ",", 
   RowBox[{"Unevaluated", "[", 
    RowBox[{
     RowBox[{"Off", "[", 
      RowBox[{"FrontEndObject", "::", "notavail"}], "]"}], ";", 
     RowBox[{"Get", "[", "\"\<Version5`Graphics`\>\"", "]"}], ";", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "Pi"}], "}"}]}], "]"}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->216242856],

Cell[TextData[{
 "Read the ",
 Cell[BoxData[
  ButtonBox["DisplayPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DisplayPacket"]], "InlineFormula"],
 " expression:"
}], "ExampleText",
 CellID->1400582518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1420596703],

Cell[BoxData[
 RowBox[{"DisplayPacket", "[", "\<\"\"\>", "]"}]], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->382292476]
}, Open  ]],

Cell["Read the series of expressions for the postscript graphic:", \
"ExampleText",
 CellID->2032750524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{"LinkRead", "[", "link", "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1041227580],

Cell[BoxData[
 TagBox[
  RowBox[{"DisplayPacket", "[", 
   RowBox[{"\<\"%!\\n%%Creator: Mathematica\\n%\"\>", 
    "\[Ellipsis]", "\<\"of Graphics\\nMathPictureEnd\\n\"\>"}], "]"}],
  Short]], "Output",
 ImageSize->{158, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//Short=",
 CellID->35446123]
}, Open  ]],

Cell[TextData[{
 "Read the ",
 Cell[BoxData[
  ButtonBox["DisplayEndPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DisplayEndPacket"]], "InlineFormula"],
 " expression:"
}], "ExampleText",
 CellID->120716745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1775671936],

Cell[BoxData[
 RowBox[{"DisplayEndPacket", "[", "\<\"\"\>", "]"}]], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->131823113]
}, Open  ]],

Cell["Close the link:", "ExampleText",
 CellID->1054932471],

Cell[BoxData[
 RowBox[{"LinkClose", "[", "link", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1396673512]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["DisplayPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DisplayPacket"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]
}], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DisplayEndPacket - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 31.0865592}", "context" -> "", 
    "keywords" -> {"MathLink packet", "postscript graphic packet"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "DisplayEndPacket[] is a MathLink packet that indicates the end of a \
series of expressions relating to a postscript graphic.", 
    "synonyms" -> {"display end packet"}, "title" -> "DisplayEndPacket", 
    "type" -> "Symbol", "uri" -> "ref/DisplayEndPacket"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2580, 87, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9273, 342}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1256, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1879, 60, 59, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[1941, 63, 602, 19, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[2580, 87, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[2957, 101, 148, 5, 70, "ExampleSection",
 CellID->170637006],
Cell[3108, 108, 149, 6, 70, "ExampleText",
 CellID->1215824468],
Cell[CellGroupData[{
Cell[3282, 118, 234, 7, 28, "Input",
 CellID->312144257],
Cell[3519, 127, 260, 8, 36, "Output",
 CellID->169330410]
}, Open  ]],
Cell[3794, 138, 65, 1, 70, "ExampleText",
 CellID->625050465],
Cell[CellGroupData[{
Cell[3884, 143, 108, 3, 28, "Input",
 CellID->2053461425],
Cell[3995, 148, 215, 6, 36, "Output",
 CellID->202580023]
}, Open  ]],
Cell[4225, 157, 99, 1, 70, "ExampleText",
 CellID->316479038],
Cell[4327, 160, 511, 15, 70, "Input",
 CellID->216242856],
Cell[4841, 177, 214, 8, 70, "ExampleText",
 CellID->1400582518],
Cell[CellGroupData[{
Cell[5080, 189, 108, 3, 70, "Input",
 CellID->1420596703],
Cell[5191, 194, 205, 6, 36, "Output",
 CellID->382292476]
}, Open  ]],
Cell[5411, 203, 104, 2, 70, "ExampleText",
 CellID->2032750524],
Cell[CellGroupData[{
Cell[5540, 209, 140, 4, 70, "Input",
 CellID->1041227580],
Cell[5683, 215, 339, 10, 105, "Output",
 CellID->35446123]
}, Open  ]],
Cell[6037, 228, 219, 8, 70, "ExampleText",
 CellID->120716745],
Cell[CellGroupData[{
Cell[6281, 240, 108, 3, 70, "Input",
 CellID->1775671936],
Cell[6392, 245, 208, 6, 36, "Output",
 CellID->131823113]
}, Open  ]],
Cell[6615, 254, 59, 1, 70, "ExampleText",
 CellID->1054932471],
Cell[6677, 257, 109, 3, 70, "Input",
 CellID->1396673512]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6835, 266, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[7154, 277, 210, 6, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[7401, 288, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[7722, 299, 371, 11, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[8108, 313, 27, 0, 70, "History"],
Cell[8138, 315, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

