(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19268,        641]
NotebookOptionsPosition[     15598,        520]
NotebookOutlinePosition[     16973,        558]
CellTagsIndexPosition[     16888,        553]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Using Nearest" :> 
          Documentation`HelpLookup["paclet:tutorial/UsingNearest"], 
          "Partitioning Data into Clusters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PartitioningDataIntoClusters"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Using Nearest\"\>", 
       2->"\<\"Partitioning Data into Clusters\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Norm" :> Documentation`HelpLookup["paclet:ref/Norm"], 
          "NormFunction" :> 
          Documentation`HelpLookup["paclet:ref/NormFunction"], 
          "EuclideanDistance" :> 
          Documentation`HelpLookup["paclet:ref/EuclideanDistance"], 
          "EditDistance" :> 
          Documentation`HelpLookup["paclet:ref/EditDistance"], 
          "JaccardDissimilarity" :> 
          Documentation`HelpLookup["paclet:ref/JaccardDissimilarity"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Norm\"\>", 
       2->"\<\"NormFunction\"\>", 3->"\<\"EuclideanDistance\"\>", 
       4->"\<\"EditDistance\"\>", 
       5->"\<\"JaccardDissimilarity\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Exploratory Data Analysis" :> 
          Documentation`HelpLookup["paclet:guide/DataClassification"], 
          "Distance and Dissimilarity Measures" :> 
          Documentation`HelpLookup[
           "paclet:guide/DistanceAndDissimilarityMeasures"], 
          "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Exploratory Data Analysis\"\>", 
       2->"\<\"Distance and Dissimilarity Measures\"\>", 
       3->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["DistanceFunction", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["DistanceFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DistanceFunction"]], "InlineFormula"],
     " \[LineSeparator]is an option for functions such as ",
     Cell[BoxData[
      ButtonBox["Nearest",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Nearest"]], "InlineFormula"],
     " that specifies the distance value to assume between any two specified \
points."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13399]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"DistanceFunction", "->", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 " specifies that the distance assumed between ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " should be ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "y"}], "]"}], TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellID->3686]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->444602798],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->23129892],

Cell[TextData[{
 "Find points closest to {5,5} using ",
 Cell[BoxData[
  ButtonBox["ChebyshevDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChebyshevDistance"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->112782676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nearest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "5"}], "}"}], ",", 
   RowBox[{"DistanceFunction", "\[Rule]", "ChebyshevDistance"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150200091],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->209292619]
}, Open  ]],

Cell["Use the default distance:", "ExampleText",
 CellID->711117746],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nearest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->295341319],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"5", ",", "2"}], "}"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->474581968]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->253108872],

Cell[TextData[{
 "Find clusters in Boolean data using ",
 Cell[BoxData[
  ButtonBox["DiceDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiceDissimilarity"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->148336777],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->341042888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{"data", ",", 
   RowBox[{"DistanceFunction", "\[Rule]", "DiceDissimilarity"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->34892062],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWctOwzAQ3MSE8lBp4cSxXwMnPiKqkNoDArX9ZfobwZu2IG0mXTsOcRCu
FNdr747H63HqpC/lbvX6Vu7Wy3LxvCk/VuvldvH0vrFNJiPKPolo9ki2Xtla
ffFnby+iCy7Nqa1S7WthzxT/m8jxtyPnP//l8TW80PUNza+0DReH0nNWuTXv
ARq3y1n37S+zMBSfh0B8lH0U75tv13xo65pXXdTAUQU1722XLe3Svho5ntxj
Y+Pnisd+bBaeeKYlzpWfho92BRpv4shfrlcoXj+7BNm8RyXbv+qn3cNi83P1
q9VZfLez1aJxhJq3Rrty6ML9/KgTrxnJdewLW99RuWeU3Lfy7CP7p5Hj70bO
v+bXWEsNxcAojYtcS4kKz6mNUaZOjGXeQ7A0TWZ1XOhvg3aKj92vPUXF5oeV
rKHgO53vE5Xmj0fB6tPyHoI1zCknthKSkn+ikpKTkpOSUX9S8pj6k5L/i5K7
RPFT5/z4LU/n8n1n3/7y/e9QfLjdgCwjf3NUFcLX4lG+T3hofJSPc/6affg3
gqt7hxplX5AuBLA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{485, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->187046012]
}, Open  ]],

Cell["Clusters obtained with the default distance function:", "ExampleText",
 CellID->486847666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", "data", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->189917055],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWU1TwjAQTRsrqMOHnjzya/Tkj+gwzsDB0QH+udxrtlQPy5a3CcHUMcy0
ZJPsy+btS2jKS71bvb7Vu/WyXjxv6o/VerldPL1vXJUtjCk+jTGzR+PKjSu1
F3327jLmiu72u66B9g2zZ6D/bWL/u8TjIzzE73zg/CK+z9UPty3dDndP1ktn
3gtoVM9ZiN2fsxILX2JH8u/j4+GX+eiLF6lGi8ftsglRC3lV5nhvvO6p5/Z4
4Hh8DQ4tPoQvqYjMSvCT6hF+H94oMl4oHzx/Wv1q44+ziiSb1jCK/q/0Q3ts
yvhC/NosVz82WZ2GyHvc26oZ6zT26ILYoWxpsiv56eeCV1zp6cXXNX+24u2T
xP7TxONz/jie+Ox5lNupWItilbEmEbF8Z8+zgdSlixVptmj9zv1tQaeI1O3o
FHfp8X37y3uqrHSELWPJ6gnD8p09yoa4L0Ta07PSs9Kz0jV2aiVnpWelZ6Vr
uM1K/y9KD/GiU/G8++anA/4+N3Z//n47Nj6fL3o/TXi2w7NCFqTxbacR3/6a
eDk/p/InjY/sw781VNwrSqb4AhF8uNw=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{499, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->469122791]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31323],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Norm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Norm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NormFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NormFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EuclideanDistance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EuclideanDistance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EditDistance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EditDistance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JaccardDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JaccardDissimilarity"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31380]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7785],

Cell[TextData[ButtonBox["Using Nearest",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/UsingNearest"]], "Tutorials",
 CellID->510394019],

Cell[TextData[ButtonBox["Partitioning Data into Clusters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartitioningDataIntoClusters"]], "Tutorials",
 CellID->22256]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Exploratory Data Analysis",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataClassification"]], "MoreAbout",
 CellID->122657553],

Cell[TextData[ButtonBox["Distance and Dissimilarity Measures",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DistanceAndDissimilarityMeasures"]], "MoreAbout",
 CellID->55680883],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->121731412]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DistanceFunction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 36.0866872}", "context" -> "System`", 
    "keywords" -> {
     "dissimilarity", "similarity", "distance measure", "metric"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "DistanceFunction is an option for functions such as Nearest that \
specifies the distance value to assume between any two specified points.", 
    "synonyms" -> {"distance function"}, "title" -> "DistanceFunction", 
    "type" -> "Symbol", "uri" -> "ref/DistanceFunction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6673, 194, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->444602798]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16745, 546}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2790, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3413, 92, 1581, 37, 70, "ObjectNameGrid"],
Cell[4997, 131, 657, 19, 70, "Usage",
 CellID->13399]
}, Open  ]],
Cell[CellGroupData[{
Cell[5691, 155, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6169, 172, 467, 17, 70, "Notes",
 CellID->3686]
}, Closed]],
Cell[CellGroupData[{
Cell[6673, 194, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->444602798],
Cell[CellGroupData[{
Cell[7058, 208, 147, 5, 70, "ExampleSection",
 CellID->23129892],
Cell[7208, 215, 236, 8, 70, "ExampleText",
 CellID->112782676],
Cell[CellGroupData[{
Cell[7469, 227, 593, 20, 47, "Input",
 CellID->150200091],
Cell[8065, 249, 361, 13, 36, "Output",
 CellID->209292619]
}, Open  ]],
Cell[8441, 265, 68, 1, 70, "ExampleText",
 CellID->711117746],
Cell[CellGroupData[{
Cell[8534, 270, 519, 18, 28, "Input",
 CellID->295341319],
Cell[9056, 290, 227, 8, 36, "Output",
 CellID->474581968]
}, Open  ]],
Cell[9298, 301, 125, 3, 70, "ExampleDelimiter",
 CellID->253108872],
Cell[9426, 306, 237, 8, 70, "ExampleText",
 CellID->148336777],
Cell[9666, 316, 709, 24, 70, "Input",
 CellID->341042888],
Cell[CellGroupData[{
Cell[10400, 344, 197, 6, 28, "Input",
 CellID->34892062],
Cell[10600, 352, 777, 17, 36, "Output",
 Evaluatable->False,
 CellID->187046012]
}, Open  ]],
Cell[11392, 372, 96, 1, 70, "ExampleText",
 CellID->486847666],
Cell[CellGroupData[{
Cell[11513, 377, 111, 3, 28, "Input",
 CellID->189917055],
Cell[11627, 382, 793, 17, 36, "Output",
 Evaluatable->False,
 CellID->469122791]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12481, 406, 311, 9, 70, "SeeAlsoSection",
 CellID->31323],
Cell[12795, 417, 1236, 44, 70, "SeeAlso",
 CellID->31380]
}, Open  ]],
Cell[CellGroupData[{
Cell[14068, 466, 313, 9, 70, "TutorialsSection",
 CellID->7785],
Cell[14384, 477, 140, 3, 70, "Tutorials",
 CellID->510394019],
Cell[14527, 482, 170, 3, 70, "Tutorials",
 CellID->22256]
}, Open  ]],
Cell[CellGroupData[{
Cell[14734, 490, 299, 8, 70, "MoreAboutSection"],
Cell[15036, 500, 155, 3, 70, "MoreAbout",
 CellID->122657553],
Cell[15194, 505, 178, 3, 70, "MoreAbout",
 CellID->55680883],
Cell[15375, 510, 151, 3, 70, "MoreAbout",
 CellID->121731412]
}, Open  ]],
Cell[15541, 516, 27, 0, 70, "History"],
Cell[15571, 518, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

