(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     47911,       1800]
NotebookOptionsPosition[     38697,       1474]
NotebookOutlinePosition[     40148,       1513]
CellTagsIndexPosition[     40062,       1508]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralOperations"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Structural Operations\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Expand" :> Documentation`HelpLookup["paclet:ref/Expand"], 
          "Thread" :> Documentation`HelpLookup["paclet:ref/Thread"], "Outer" :> 
          Documentation`HelpLookup["paclet:ref/Outer"], "Inner" :> 
          Documentation`HelpLookup["paclet:ref/Inner"], "Tuples" :> 
          Documentation`HelpLookup["paclet:ref/Tuples"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Expand\"\>", 2->"\<\"Thread\"\>", 
       3->"\<\"Outer\"\>", 4->"\<\"Inner\"\>", 
       5->"\<\"Tuples\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Expressions" :> 
          Documentation`HelpLookup["paclet:guide/Expressions"], 
          "Functional Programming" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalProgramming"], 
          "Structural Operations on Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/StructuralOperationsOnExpressions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Expressions\"\>", 
       2->"\<\"Functional Programming\"\>", 
       3->"\<\"Structural Operations on Expressions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Distribute", "ObjectName",
 CellID->24500],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Distribute",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Distribute"], "[", 
       RowBox[{
        StyleBox["f", "TI"], "[", 
        RowBox[{
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "]"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]distributes ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " over ",
     Cell[BoxData[
      ButtonBox["Plus",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
     " appearing in any of the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["i", "TI"]], TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Distribute",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Distribute"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["g", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]distributes over ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Distribute",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Distribute"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["g", "TI"], ",", 
        StyleBox["f", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]performs the distribution only if the head of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->26008]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Distribute",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Distribute"]], "InlineFormula"],
 " effectively implements the distributive law for operators ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4224],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Distribute",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Distribute"]], "InlineFormula"],
 " explicitly constructs the complete result of a distribution; ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 ", on the other hand, builds up results iteratively, simplifying at each \
stage. "
}], "Notes",
 CellID->703],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Distribute",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Distribute"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["g", "TI"], ",", 
    StyleBox["f", "TI"], ",", 
    StyleBox["gp", "TI"], ",", 
    StyleBox["fp", "TI"]}], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  StyleBox["gp", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["fp", "TI"]], "InlineFormula"],
 " in place of ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " respectively in the result of the distribution. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->459322731,
  ButtonNote->"459322731"]
}], "Notes",
 CellID->6408]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->562666664],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->498333021],

Cell["Apply the distributive law:", "ExampleText",
 CellID->28007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Distribute", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}], ".", 
   RowBox[{"(", 
    RowBox[{"x", "+", "y", "+", "z"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17646],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", ".", "x"}], "+", 
  RowBox[{"a", ".", "y"}], "+", 
  RowBox[{"a", ".", "z"}], "+", 
  RowBox[{"b", ".", "x"}], "+", 
  RowBox[{"b", ".", "y"}], "+", 
  RowBox[{"b", ".", "z"}]}]], "Output",
 ImageSize->{194, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12436]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25126],

Cell[TextData[{
 "Distribute ",
 Cell[BoxData["f"], "InlineFormula"],
 " over ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->20049],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Distribute", "[", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"a", "+", "b"}], ",", 
    RowBox[{"c", "+", "d", "+", "e"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11227],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"a", ",", "c"}], "]"}], "+", 
  RowBox[{"f", "[", 
   RowBox[{"a", ",", "d"}], "]"}], "+", 
  RowBox[{"f", "[", 
   RowBox[{"a", ",", "e"}], "]"}], "+", 
  RowBox[{"f", "[", 
   RowBox[{"b", ",", "c"}], "]"}], "+", 
  RowBox[{"f", "[", 
   RowBox[{"b", ",", "d"}], "]"}], "+", 
  RowBox[{"f", "[", 
   RowBox[{"b", ",", "e"}], "]"}]}]], "Output",
 ImageSize->{345, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32522]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3144],

Cell[TextData[{
 "Distribute ",
 Cell[BoxData["f"], "InlineFormula"],
 " over ",
 Cell[BoxData["g"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->12705],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Distribute", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"g", "[", 
      RowBox[{"a", ",", "b"}], "]"}], ",", 
     RowBox[{"g", "[", 
      RowBox[{"c", ",", "d", ",", "e"}], "]"}]}], "]"}], ",", "g"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30220],

Cell[BoxData[
 RowBox[{"g", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "c"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "d"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "e"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "c"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "d"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "e"}], "]"}]}], "]"}]], "Output",
 ImageSize->{359, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30809]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->57190080],

Cell[TextData[{
 "By default, distribute over ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1392884857],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Distribute", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", "b", "+", "c"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"u", "+", "v"}], ")"}]}], ",", "Plus"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->665834745],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "u"}], "+", 
  RowBox[{"b", " ", "u"}], "+", 
  RowBox[{"c", " ", "u"}], "+", 
  RowBox[{"a", " ", "v"}], "+", 
  RowBox[{"b", " ", "v"}], "+", 
  RowBox[{"c", " ", "v"}]}]], "Output",
 ImageSize->{170, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->348029125]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Distribute", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "+", "b", "+", "c"}], ")"}], 
   RowBox[{"(", 
    RowBox[{"u", "+", "v"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->402081026],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->559223137],

Cell["Distribute only a product of sums:", "ExampleText",
 CellID->1241275237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Distribute", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", "b", "+", "c"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"u", "+", "v"}], ")"}]}], ",", "Plus", ",", "Times"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->718596547],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "u"}], "+", 
  RowBox[{"b", " ", "u"}], "+", 
  RowBox[{"c", " ", "u"}], "+", 
  RowBox[{"a", " ", "v"}], "+", 
  RowBox[{"b", " ", "v"}], "+", 
  RowBox[{"c", " ", "v"}]}]], "Output",
 ImageSize->{170, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1612619019]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Distribute", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", "b", "+", "c"}], ")"}], "^", 
    RowBox[{"(", 
     RowBox[{"u", "+", "v"}], ")"}]}], ",", "Plus", ",", "Times"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5165729],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"a", "+", "b", "+", "c"}], ")"}], 
  RowBox[{"u", "+", "v"}]]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->954814747]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->281599653],

Cell["Distributive laws for logical operators: ", "ExampleText",
 CellID->341682976],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Distribute", "[", 
  RowBox[{
   RowBox[{"And", "[", 
    RowBox[{
     RowBox[{"Or", "[", 
      RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", 
     RowBox[{"Or", "[", 
      RowBox[{"u", ",", "v"}], "]"}]}], "]"}], ",", "Or", ",", "And"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->855863],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "&&", "u"}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"a", "&&", "v"}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"b", "&&", "u"}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"b", "&&", "v"}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"c", "&&", "u"}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"c", "&&", "v"}], ")"}]}]], "Output",
 ImageSize->{388, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->343670195]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Distribute", "[", 
  RowBox[{
   RowBox[{"Or", "[", 
    RowBox[{
     RowBox[{"And", "[", 
      RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", 
     RowBox[{"And", "[", 
      RowBox[{"u", ",", "v"}], "]"}]}], "]"}], ",", "And", ",", "Or"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->259510903],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "||", "u"}], ")"}], "&&", 
  RowBox[{"(", 
   RowBox[{"a", "||", "v"}], ")"}], "&&", 
  RowBox[{"(", 
   RowBox[{"b", "||", "u"}], ")"}], "&&", 
  RowBox[{"(", 
   RowBox[{"b", "||", "v"}], ")"}], "&&", 
  RowBox[{"(", 
   RowBox[{"c", "||", "u"}], ")"}], "&&", 
  RowBox[{"(", 
   RowBox[{"c", "||", "v"}], ")"}]}]], "Output",
 ImageSize->{388, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->487573341]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Distribute", "[", 
  RowBox[{
   RowBox[{"And", "[", 
    RowBox[{
     RowBox[{"Xor", "[", 
      RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", 
     RowBox[{"Xor", "[", 
      RowBox[{"u", ",", "v"}], "]"}]}], "]"}], ",", "Xor", ",", "And"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->402446513],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "&&", "u"}], ")"}], "\[Xor]", 
  RowBox[{"(", 
   RowBox[{"a", "&&", "v"}], ")"}], "\[Xor]", 
  RowBox[{"(", 
   RowBox[{"b", "&&", "u"}], ")"}], "\[Xor]", 
  RowBox[{"(", 
   RowBox[{"b", "&&", "v"}], ")"}], "\[Xor]", 
  RowBox[{"(", 
   RowBox[{"c", "&&", "u"}], ")"}], "\[Xor]", 
  RowBox[{"(", 
   RowBox[{"c", "&&", "v"}], ")"}]}]], "Output",
 ImageSize->{363, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->49882906]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->371456859],

Cell["Apply the distributive law to arbitrary operators:", "ExampleText",
 CellID->1534826572],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Distribute", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "\[CirclePlus]", "b", "\[CirclePlus]", "c"}], ")"}], 
    "\[CircleTimes]", 
    RowBox[{"(", 
     RowBox[{"u", "\[CirclePlus]", "v"}], ")"}]}], ",", "CirclePlus", ",", 
   "CircleTimes"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1703619424],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "\[CircleTimes]", "u"}], "\[CirclePlus]", 
  RowBox[{"a", "\[CircleTimes]", "v"}], "\[CirclePlus]", 
  RowBox[{"b", "\[CircleTimes]", "u"}], "\[CirclePlus]", 
  RowBox[{"b", "\[CircleTimes]", "v"}], "\[CirclePlus]", 
  RowBox[{"c", "\[CircleTimes]", "u"}], "\[CirclePlus]", 
  RowBox[{"c", "\[CircleTimes]", "v"}]}]], "Output",
 ImageSize->{212, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->69092218]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19563],

Cell[TextData[{
 "Distribute ",
 Cell[BoxData["f"], "InlineFormula"],
 " over ",
 Cell[BoxData["g"], "InlineFormula"],
 " to give ",
 Cell[BoxData["fp"], "InlineFormula"],
 " and ",
 Cell[BoxData["gp"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->25611],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Distribute", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"g", "[", 
      RowBox[{"a", ",", "b"}], "]"}], ",", 
     RowBox[{"g", "[", 
      RowBox[{"c", ",", "d", ",", "e"}], "]"}]}], "]"}], ",", "g", ",", "f", 
   ",", "gp", ",", "fp"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21425],

Cell[BoxData[
 RowBox[{"gp", "[", 
  RowBox[{
   RowBox[{"fp", "[", 
    RowBox[{"a", ",", "c"}], "]"}], ",", 
   RowBox[{"fp", "[", 
    RowBox[{"a", ",", "d"}], "]"}], ",", 
   RowBox[{"fp", "[", 
    RowBox[{"a", ",", "e"}], "]"}], ",", 
   RowBox[{"fp", "[", 
    RowBox[{"b", ",", "c"}], "]"}], ",", 
   RowBox[{"fp", "[", 
    RowBox[{"b", ",", "d"}], "]"}], ",", 
   RowBox[{"fp", "[", 
    RowBox[{"b", ",", "e"}], "]"}]}], "]"}]], "Output",
 ImageSize->{408, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6298]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Distribute", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", "b", "+", "c"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"u", "+", "v"}], ")"}]}], ",", "Plus", ",", "Times", ",", "plus",
    ",", "times"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->350703848],

Cell[BoxData[
 RowBox[{"plus", "[", 
  RowBox[{
   RowBox[{"times", "[", 
    RowBox[{"a", ",", "u"}], "]"}], ",", 
   RowBox[{"times", "[", 
    RowBox[{"a", ",", "v"}], "]"}], ",", 
   RowBox[{"times", "[", 
    RowBox[{"b", ",", "u"}], "]"}], ",", 
   RowBox[{"times", "[", 
    RowBox[{"b", ",", "v"}], "]"}], ",", 
   RowBox[{"times", "[", 
    RowBox[{"c", ",", "u"}], "]"}], ",", 
   RowBox[{"times", "[", 
    RowBox[{"c", ",", "v"}], "]"}]}], "]"}]], "Output",
 ImageSize->{548, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1023496094]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21086],

Cell["Expand symbolic matrix and vector expressions: ", "ExampleText",
 CellID->291126522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Distribute", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"m1", "+", "m2"}], ")"}], ".", 
   RowBox[{"(", 
    RowBox[{"m3", "+", "m4"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15181243],

Cell[BoxData[
 RowBox[{
  RowBox[{"m1", ".", "m3"}], "+", 
  RowBox[{"m1", ".", "m4"}], "+", 
  RowBox[{"m2", ".", "m3"}], "+", 
  RowBox[{"m2", ".", "m4"}]}]], "Output",
 ImageSize->{182, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24635107]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Distribute", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"v1", "+", "v2"}], ")"}], "\[Cross]", 
   RowBox[{"(", 
    RowBox[{"v3", "+", "v4"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->338465933],

Cell[BoxData[
 RowBox[{
  RowBox[{"v1", "\[Cross]", "v3"}], "+", 
  RowBox[{"v1", "\[Cross]", "v4"}], "+", 
  RowBox[{"v2", "\[Cross]", "v3"}], "+", 
  RowBox[{"v2", "\[Cross]", "v4"}]}]], "Output",
 ImageSize->{193, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->632038719]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->297443477],

Cell["Apply the distributive law with any operator:", "ExampleText",
 CellID->12483],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Distribute", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}], "\[CirclePlus]", 
   RowBox[{"(", 
    RowBox[{"x", "+", "y", "+", "z"}], ")"}], "\[CirclePlus]", 
   RowBox[{"(", 
    RowBox[{"s", "+", "t"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1925],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "\[CirclePlus]", "x", "\[CirclePlus]", "s"}], "+", 
  RowBox[{"a", "\[CirclePlus]", "x", "\[CirclePlus]", "t"}], "+", 
  RowBox[{"a", "\[CirclePlus]", "y", "\[CirclePlus]", "s"}], "+", 
  RowBox[{"a", "\[CirclePlus]", "y", "\[CirclePlus]", "t"}], "+", 
  RowBox[{"a", "\[CirclePlus]", "z", "\[CirclePlus]", "s"}], "+", 
  RowBox[{"a", "\[CirclePlus]", "z", "\[CirclePlus]", "t"}], "+", 
  RowBox[{"b", "\[CirclePlus]", "x", "\[CirclePlus]", "s"}], "+", 
  RowBox[{"b", "\[CirclePlus]", "x", "\[CirclePlus]", "t"}], "+", 
  RowBox[{"b", "\[CirclePlus]", "y", "\[CirclePlus]", "s"}], "+", 
  RowBox[{"b", "\[CirclePlus]", "y", "\[CirclePlus]", "t"}], "+", 
  RowBox[{"b", "\[CirclePlus]", "z", "\[CirclePlus]", "s"}], "+", 
  RowBox[{"b", "\[CirclePlus]", "z", "\[CirclePlus]", "t"}]}]], "Output",
 ImageSize->{392, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->466412005]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30627],

Cell["Find the list of all possible combinations of elements:", "ExampleText",
 CellID->10573],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Distribute", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", " ", "b"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "t"}], "}"}]}], "}"}], ",", " ", "List"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22304],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "x", ",", "s"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "x", ",", "t"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "y", ",", "s"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "y", ",", "t"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "z", ",", "s"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "z", ",", "t"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "x", ",", "s"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "x", ",", "t"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "y", ",", "s"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "y", ",", "t"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "z", ",", "s"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "z", ",", "t"}], "}"}]}], "}"}]], "Output",
 ImageSize->{419, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->599019247]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22244],

Cell["Generate a powerset:", "ExampleText",
 CellID->23615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Distribute", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "#", "}"}]}], "}"}], "&"}], "/@", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], ",", "List", ",", "List", 
   ",", "List", ",", "Join"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29294],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "c", "}"}], ",", 
   RowBox[{"{", "b", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "}"}]], "Output",
 ImageSize->{349, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87886891]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32713],

Cell["\<\
Find intermediate terms from a direct application of the distributive law:\
\>", "ExampleText",
 CellID->18352],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Distribute", "[", 
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{
     RowBox[{"x", "^", "6"}], "-", "1"}], "]"}], ",", "Plus", ",", "Times", 
   ",", "List", ",", "Times"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6134],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWVlvE0EMnmSzBUrvJNuQsxKUUHgBRAM/gOMB8SOiCql9QKDSHw480Mdh
j5lm+40dz+yuSqV019fYHs84tvNleXX+9dvy6uJsefTpcvnj/OLs59HH75cp
Kmop1fqrlDoeqPRdp2/5J/u7Tj/F66/0007R8Q3mT/YWWU6t2gJlAthdgPsA
9wBG+bEA43rS+hI/wpJ+tFfSl7C7lu37nnkm5tk3z6l5TuCZMPyITxj5KSN3
SFq5Y6ht89wErhjoHYEuyT8A+rYgj3RJHukbAr2u/U2vj/Sthvfnrv0rTlme
MTorrFIPDf89hxKzFF5m01B4PS6Fl7GU+yylim3NrGYpO4142rzVbuyzFeIU
Genb+QjzYs/wdfQqf5VhpEv5EfF9sMN3fVxvG7xs5V6iNwhjdsZs7+uFtA7K
bZExcU9Cz8G4J8zlGTmYsQePu07Xg6eaVFMW+minzz9+wx4AjBke6Y8AHgp0
lN8X6KH8de2R9NHfIFi9PE3/RaVzPjFw+X5EJm72Xlh+rO3KfIcGHhl4ZmCq
RqXW6xq5DdKLcqWY/ldz4EIvhwDPAJYqZ6xcu6BfqmSlyhkr5SGsj/6g/h7A
MblrAyL2dazMYtthYtdRytkF3EUK7hBnZGzwqJ/Tc+C1GzbDnwixGwE8DYwV
WmNvGvJRu1iWQ70joI/16oZS+uxTvlHZ65xYBbWV4QkBtwm5PoFH76kTbaOF
eqcE3kaR0oNnzlYx8c0uZMRnQmykmxHa+XaNXunGVDmbEZM/ylk//67Iidfw
Zqu4DPM7x0SwVhXKPsBoH+7vXuB+SvFBuqQ/NJ6h9jxhdynb+4G+XaNavG9N
i/LcZINb55i0LutgbZ2/rlOW6FKnLE1KQjvtup1+qHyo//970lDXvsfkacGa
3uYVt4OKWQrfS/OzDrn/rtLnh8jI/tzFPKGqBUVmakP0suhyd7/c++9qehbg
O7PwnTGgHpTnunpp3dfa5yzbVQd6vZfchJnL05zVKOdnZd+JceJgmppeVJsW
uPY0NVHw0f7Kaxdtf2uzH8J1pxKhUwHUX3dqIOl76bVLC13Ul3NNTxdsrzIz
8CngE5BLgG6nEs9Ja2xWewf40CkBVtNYtb0R+Lt6vb7Q3/dOSG8/CF6G/mpn
u+2FwCfVvLY756YGdOwkb6QOiNJW7hffCvxSx4Xd/AzoOA14kT/t98l7oIZ2
2Vz3uxD4qC6c6sq5Lr7w4rMQm9CThvflVOCv+/s0xrq4T6r1Dwh6bL4=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{502, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->134026293]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plus", "@@", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25532],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  SuperscriptBox["x", "6"]}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->395324748]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30731],

Cell[TextData[{
 "For pure products, ",
 Cell[BoxData[
  ButtonBox["Distribute",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Distribute"]], "InlineFormula"],
 " gives the same results as ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->14777],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"x", "^", "10"}], "-", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1612],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "-", "x", "+", 
    SuperscriptBox["x", "2"], "-", 
    SuperscriptBox["x", "3"], "+", 
    SuperscriptBox["x", "4"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x", "+", 
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["x", "3"], "+", 
    SuperscriptBox["x", "4"]}], ")"}]}]], "Output",
 ImageSize->{334, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->142541144]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Distribute", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2129],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  SuperscriptBox["x", "10"]}]], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->8810886]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12413],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " corresponds to distribution over ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->10233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", " ", "y", " ", "z"}], ")"}], "^", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29004],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "n"], " ", 
  SuperscriptBox["y", "n"], " ", 
  SuperscriptBox["z", "n"]}]], "Output",
 ImageSize->{48, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->108549545]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Distribute", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", " ", "y", " ", "z"}], ")"}], "^", "n"}], ",", "Times"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13404],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "n"], " ", 
  SuperscriptBox["y", "n"], " ", 
  SuperscriptBox["z", "n"]}]], "Output",
 ImageSize->{48, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->307898977]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1984520998],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Outer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Outer"]], "InlineFormula"],
 " forms the same combinations of all elements, but in a nested structure:"
}], "ExampleText",
 CellID->515193634],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"List", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1501362825],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "y"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "y"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "y"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{352, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->175107360]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Distribute", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "}"}], ",", "List"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->952047024],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "y"}], "}"}]}], "}"}]], "Output",
 ImageSize->{310, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->788094810]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32535],

Cell["Find all possible sums of sublists of a list:", "ExampleText",
 CellID->2008954928],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{"Distribute", "[", 
   RowBox[{
    RowBox[{"Thread", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "2", ",", "8"}], "}"}], ",", "0"}], "}"}],
      "]"}], ",", "List", ",", "List", ",", "List", ",", "Plus"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1662119665],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "8", ",", "9", 
   ",", "10", ",", "11", ",", "12", ",", "13"}], "}"}]], "Output",
 ImageSize->{254, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->144566243]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26691],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Expand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Expand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Thread",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Thread"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Outer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Outer"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inner",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inner"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tuples",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tuples"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28491]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32077],

Cell[TextData[ButtonBox["Structural Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StructuralOperations"]], "Tutorials",
 CellID->20627]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Distribute"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Expressions"]], "MoreAbout",
 CellID->169668646],

Cell[TextData[ButtonBox["Functional Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalProgramming"]], "MoreAbout",
 CellID->59489892],

Cell[TextData[ButtonBox["Structural Operations on Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StructuralOperationsOnExpressions"]], "MoreAbout",
 CellID->743454426]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Distribute - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 36.4460714}", "context" -> "System`", 
    "keywords" -> {
     "distribution of operations", "distributive property", "expansion", 
      "expand non-commutative operators"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Distribute[f[x_1, x_2, ...]] distributes f over Plus appearing in any of \
the x_i. Distribute[expr, g] distributes over g. Distribute[expr, g, f] \
performs the distribution only if the head of expr is f. ", "synonyms" -> {}, 
    "title" -> "Distribute", "type" -> "Symbol", "uri" -> "ref/Distribute"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7371, 245, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->562666664]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 39919, 1501}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2436, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3059, 85, 48, 1, 70, "ObjectName",
 CellID->24500],
Cell[3110, 88, 2103, 70, 70, "Usage",
 CellID->26008]
}, Open  ]],
Cell[CellGroupData[{
Cell[5250, 163, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5728, 180, 360, 13, 70, "Notes",
 CellID->4224],
Cell[6091, 195, 432, 13, 70, "Notes",
 CellID->703],
Cell[6526, 210, 808, 30, 70, "Notes",
 CellID->6408]
}, Closed]],
Cell[CellGroupData[{
Cell[7371, 245, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->562666664],
Cell[CellGroupData[{
Cell[7756, 259, 148, 5, 70, "ExampleSection",
 CellID->498333021],
Cell[7907, 266, 66, 1, 70, "ExampleText",
 CellID->28007],
Cell[CellGroupData[{
Cell[7998, 271, 233, 8, 28, "Input",
 CellID->17646],
Cell[8234, 281, 355, 12, 36, "Output",
 CellID->12436]
}, Open  ]],
Cell[8604, 296, 121, 3, 70, "ExampleDelimiter",
 CellID->25126],
Cell[8728, 301, 231, 10, 70, "ExampleText",
 CellID->20049],
Cell[CellGroupData[{
Cell[8984, 315, 214, 7, 70, "Input",
 CellID->11227],
Cell[9201, 324, 529, 18, 36, "Output",
 CellID->32522]
}, Open  ]],
Cell[9745, 345, 120, 3, 70, "ExampleDelimiter",
 CellID->3144],
Cell[9868, 350, 158, 7, 70, "ExampleText",
 CellID->12705],
Cell[CellGroupData[{
Cell[10051, 361, 308, 11, 70, "Input",
 CellID->30220],
Cell[10362, 374, 569, 19, 36, "Output",
 CellID->30809]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10980, 399, 219, 7, 70, "ExampleSection",
 CellID->57190080],
Cell[11202, 408, 204, 8, 70, "ExampleText",
 CellID->1392884857],
Cell[CellGroupData[{
Cell[11431, 420, 263, 9, 70, "Input",
 CellID->665834745],
Cell[11697, 431, 359, 12, 36, "Output",
 CellID->348029125]
}, Open  ]],
Cell[12071, 446, 232, 8, 70, "Input",
 CellID->402081026],
Cell[12306, 456, 125, 3, 70, "ExampleDelimiter",
 CellID->559223137],
Cell[12434, 461, 78, 1, 70, "ExampleText",
 CellID->1241275237],
Cell[CellGroupData[{
Cell[12537, 466, 280, 10, 70, "Input",
 CellID->718596547],
Cell[12820, 478, 360, 12, 36, "Output",
 CellID->1612619019]
}, Open  ]],
Cell[CellGroupData[{
Cell[13217, 495, 283, 10, 70, "Input",
 CellID->5165729],
Cell[13503, 507, 261, 9, 36, "Output",
 CellID->954814747]
}, Open  ]],
Cell[13779, 519, 125, 3, 70, "ExampleDelimiter",
 CellID->281599653],
Cell[13907, 524, 84, 1, 70, "ExampleText",
 CellID->341682976],
Cell[CellGroupData[{
Cell[14016, 529, 326, 11, 70, "Input",
 CellID->855863],
Cell[14345, 542, 514, 18, 36, "Output",
 CellID->343670195]
}, Open  ]],
Cell[CellGroupData[{
Cell[14896, 565, 330, 11, 70, "Input",
 CellID->259510903],
Cell[15229, 578, 514, 18, 36, "Output",
 CellID->487573341]
}, Open  ]],
Cell[CellGroupData[{
Cell[15780, 601, 332, 11, 70, "Input",
 CellID->402446513],
Cell[16115, 614, 533, 18, 36, "Output",
 CellID->49882906]
}, Open  ]],
Cell[16663, 635, 125, 3, 70, "ExampleDelimiter",
 CellID->371456859],
Cell[16791, 640, 94, 1, 70, "ExampleText",
 CellID->1534826572],
Cell[CellGroupData[{
Cell[16910, 645, 353, 11, 70, "Input",
 CellID->1703619424],
Cell[17266, 658, 496, 12, 36, "Output",
 CellID->69092218]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17811, 676, 239, 7, 70, "ExampleSection",
 CellID->19563],
Cell[18053, 685, 260, 11, 70, "ExampleText",
 CellID->25611],
Cell[CellGroupData[{
Cell[18338, 700, 341, 11, 70, "Input",
 CellID->21425],
Cell[18682, 713, 575, 19, 36, "Output",
 CellID->6298]
}, Open  ]],
Cell[CellGroupData[{
Cell[19294, 737, 308, 10, 70, "Input",
 CellID->350703848],
Cell[19605, 749, 601, 19, 36, "Output",
 CellID->1023496094]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20255, 774, 223, 7, 70, "ExampleSection",
 CellID->21086],
Cell[20481, 783, 90, 1, 70, "ExampleText",
 CellID->291126522],
Cell[CellGroupData[{
Cell[20596, 788, 230, 8, 70, "Input",
 CellID->15181243],
Cell[20829, 798, 300, 10, 36, "Output",
 CellID->24635107]
}, Open  ]],
Cell[CellGroupData[{
Cell[21166, 813, 238, 8, 70, "Input",
 CellID->338465933],
Cell[21407, 823, 329, 10, 36, "Output",
 CellID->632038719]
}, Open  ]],
Cell[21751, 836, 125, 3, 70, "ExampleDelimiter",
 CellID->297443477],
Cell[21879, 841, 84, 1, 70, "ExampleText",
 CellID->12483],
Cell[CellGroupData[{
Cell[21988, 846, 315, 10, 70, "Input",
 CellID->1925],
Cell[22306, 858, 965, 18, 54, "Output",
 CellID->466412005]
}, Open  ]],
Cell[23286, 879, 121, 3, 70, "ExampleDelimiter",
 CellID->30627],
Cell[23410, 884, 94, 1, 70, "ExampleText",
 CellID->10573],
Cell[CellGroupData[{
Cell[23529, 889, 374, 13, 70, "Input",
 CellID->22304],
Cell[23906, 904, 1012, 31, 54, "Output",
 CellID->599019247]
}, Open  ]],
Cell[24933, 938, 121, 3, 70, "ExampleDelimiter",
 CellID->22244],
Cell[25057, 943, 59, 1, 70, "ExampleText",
 CellID->23615],
Cell[CellGroupData[{
Cell[25141, 948, 381, 13, 70, "Input",
 CellID->29294],
Cell[25525, 963, 560, 19, 36, "Output",
 CellID->87886891]
}, Open  ]],
Cell[26100, 985, 121, 3, 70, "ExampleDelimiter",
 CellID->32713],
Cell[26224, 990, 121, 3, 70, "ExampleText",
 CellID->18352],
Cell[CellGroupData[{
Cell[26370, 997, 257, 8, 70, "Input",
 CellID->6134],
Cell[26630, 1007, 1488, 28, 70, "Output",
 Evaluatable->False,
 CellID->134026293]
}, Open  ]],
Cell[CellGroupData[{
Cell[28155, 1040, 92, 3, 70, "Input",
 CellID->25532],
Cell[28250, 1045, 222, 8, 36, "Output",
 CellID->395324748]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28521, 1059, 233, 7, 70, "ExampleSection",
 CellID->30731],
Cell[28757, 1068, 349, 13, 70, "ExampleText",
 CellID->14777],
Cell[CellGroupData[{
Cell[29131, 1085, 145, 5, 70, "Input",
 CellID->1612],
Cell[29279, 1092, 625, 21, 39, "Output",
 CellID->142541144]
}, Open  ]],
Cell[CellGroupData[{
Cell[29941, 1118, 101, 3, 70, "Input",
 CellID->2129],
Cell[30045, 1123, 221, 8, 36, "Output",
 CellID->8810886]
}, Open  ]],
Cell[30281, 1134, 121, 3, 70, "ExampleDelimiter",
 CellID->12413],
Cell[30405, 1139, 332, 12, 70, "ExampleText",
 CellID->10233],
Cell[CellGroupData[{
Cell[30762, 1155, 185, 6, 70, "Input",
 CellID->29004],
Cell[30950, 1163, 262, 9, 36, "Output",
 CellID->108549545]
}, Open  ]],
Cell[CellGroupData[{
Cell[31249, 1177, 217, 8, 70, "Input",
 CellID->13404],
Cell[31469, 1187, 262, 9, 36, "Output",
 CellID->307898977]
}, Open  ]],
Cell[31746, 1199, 126, 3, 70, "ExampleDelimiter",
 CellID->1984520998],
Cell[31875, 1204, 243, 7, 70, "ExampleText",
 CellID->515193634],
Cell[CellGroupData[{
Cell[32143, 1215, 246, 8, 70, "Input",
 CellID->1501362825],
Cell[32392, 1225, 679, 25, 36, "Output",
 CellID->175107360]
}, Open  ]],
Cell[CellGroupData[{
Cell[33108, 1255, 299, 11, 70, "Input",
 CellID->952047024],
Cell[33410, 1268, 538, 19, 36, "Output",
 CellID->788094810]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33997, 1293, 224, 7, 70, "ExampleSection",
 CellID->32535],
Cell[34224, 1302, 89, 1, 70, "ExampleText",
 CellID->2008954928],
Cell[CellGroupData[{
Cell[34338, 1307, 379, 12, 70, "Input",
 CellID->1662119665],
Cell[34720, 1321, 315, 9, 36, "Output",
 CellID->144566243]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[35096, 1337, 311, 9, 70, "SeeAlsoSection",
 CellID->26691],
Cell[35410, 1348, 1162, 44, 70, "SeeAlso",
 CellID->28491]
}, Open  ]],
Cell[CellGroupData[{
Cell[36609, 1397, 314, 9, 70, "TutorialsSection",
 CellID->32077],
Cell[36926, 1408, 152, 3, 70, "Tutorials",
 CellID->20627]
}, Open  ]],
Cell[CellGroupData[{
Cell[37115, 1416, 305, 8, 70, "RelatedLinksSection"],
Cell[37423, 1426, 388, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37848, 1444, 299, 8, 70, "MoreAboutSection"],
Cell[38150, 1454, 134, 3, 70, "MoreAbout",
 CellID->169668646],
Cell[38287, 1459, 154, 3, 70, "MoreAbout",
 CellID->59489892],
Cell[38444, 1464, 181, 3, 70, "MoreAbout",
 CellID->743454426]
}, Open  ]],
Cell[38640, 1470, 27, 0, 70, "History"],
Cell[38670, 1472, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

