(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35921,       1439]
NotebookOptionsPosition[     27827,       1139]
NotebookOutlinePosition[     29028,       1174]
CellTagsIndexPosition[     28942,       1169]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Arithmetic" :> 
          Documentation`HelpLookup["paclet:tutorial/Arithmetic"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Arithmetic\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Times" :> Documentation`HelpLookup["paclet:ref/Times"], 
          "DivideBy" :> Documentation`HelpLookup["paclet:ref/DivideBy"], 
          "GCD" :> Documentation`HelpLookup["paclet:ref/GCD"], "Quotient" :> 
          Documentation`HelpLookup["paclet:ref/Quotient"], "Mod" :> 
          Documentation`HelpLookup["paclet:ref/Mod"], "Convergents" :> 
          Documentation`HelpLookup["paclet:ref/Convergents"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Times\"\>", 2->"\<\"DivideBy\"\>", 
       3->"\<\"GCD\"\>", 4->"\<\"Quotient\"\>", 5->"\<\"Mod\"\>", 
       6->"\<\"Convergents\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Arithmetic Functions" :> 
          Documentation`HelpLookup["paclet:guide/ArithmeticFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Arithmetic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Divide ",
 StyleBox["(/, \[Divide])", "OperatorCharacter"]
}], "ObjectName",
 CellID->30095],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "/", 
       StyleBox["y", "TI"]}]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Divide",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Divide"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is equivalent to ",
     Cell[BoxData[
      FormBox[
       RowBox[{"x", " ", 
        RowBox[{"y", "^", 
         RowBox[{"-", "1"}]}]}], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20985]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "/", "y"}], TraditionalForm]], "InlineMath"],
 " is converted to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", " ", 
    RowBox[{"y", "^", 
     RowBox[{"-", "1"}]}]}], TraditionalForm]], "InlineMath"],
 " on input. "
}], "Notes",
 CellID->27846],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Divide",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Divide"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " can be entered in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[Divide]", "y"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]div\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["x", "TI"], "\[Backslash]", 
    RowBox[{"[", "Divide", "]"}]}], 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2032]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1510058],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(7)", "ExampleCount"]
}], "ExampleSection",
 CellID->83312172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"77", "/", "11"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6003],

Cell[BoxData["7"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3751]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28276],

Cell[TextData[{
 "Enter in 2D form using ",
 StyleBox["Control", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["/", "KeyEvent"],
 ":"
}], "ExampleText",
 CellID->32642],

Cell[CellGroupData[{

Cell[BoxData[
 FractionBox["77", "11"]], "Input",
 CellLabel->"In[1]:=",
 CellID->30950],

Cell[BoxData["7"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3398]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31728],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Divide",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Divide"]], "InlineFormula"],
 " reduces fractions to lowest terms:"
}], "ExampleText",
 CellID->25668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"616", "/", "33"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10049],

Cell[BoxData[
 FractionBox["56", "3"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24456]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4973],

Cell["\<\
Force a numerical result by including a decimal point in the input:\
\>", "ExampleText",
 CellID->68],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"616.", "/", "33"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1046],

Cell[BoxData["18.666666666666668`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11723]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5278],

Cell[TextData[{
 Cell[BoxData["/"], "InlineFormula"],
 " is applied sequentially:"
}], "ExampleText",
 CellID->27137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"a", "/", "b"}], "/", "c"}], "/", "d"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27445],

Cell[BoxData[
 FractionBox["a", 
  RowBox[{"b", " ", "c", " ", "d"}]]], "Output",
 ImageSize->{36, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18093]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11644],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "/", "y"}], TraditionalForm]], "InlineMath"],
 " is always converted to products and powers:"
}], "ExampleText",
 CellID->2585],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{
   RowBox[{"a", "^", "2"}], "/", 
   RowBox[{"b", "^", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2837],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Times", "[", 
    RowBox[{
     RowBox[{"Power", "[", 
      RowBox[{"a", ",", "2"}], "]"}], ",", 
     RowBox[{"Power", "[", 
      RowBox[{"b", ",", 
       RowBox[{"-", "3"}]}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->9690]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5587],

Cell[TextData[{
 "Enter \[Divide] using ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]div\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ":"
}], "ExampleText",
 CellID->30908],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"20", "\[Divide]", "4"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7285],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23842]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20319],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Divide",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Divide"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->5071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"2", ",", "3", ",", "4", ",", "5"}], "}"}], "/", "3"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7930],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["2", "3"], ",", "1", ",", 
   FractionBox["4", "3"], ",", 
   FractionBox["5", "3"]}], "}"}]], "Output",
 ImageSize->{92, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17077]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}], "/", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29372],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["x", "a"], ",", 
   FractionBox["y", "b"], ",", 
   FractionBox["z", "c"]}], "}"}]], "Output",
 ImageSize->{74, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4149]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5845],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{"Divide", ",", "1", ",", 
   RowBox[{"Range", "[", "10", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32650],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", 
   FractionBox["1", "2"], ",", 
   FractionBox["1", "6"], ",", 
   FractionBox["1", "24"], ",", 
   FractionBox["1", "120"], ",", 
   FractionBox["1", "720"], ",", 
   FractionBox["1", "5040"], ",", 
   FractionBox["1", "40320"], ",", 
   FractionBox["1", "362880"], ",", 
   FractionBox["1", "3628800"]}], "}"}]], "Output",
 ImageSize->{414, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8946]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20435],

Cell["Successive ratios in a list:", "ExampleText",
 CellID->13529],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Divide", "@@@", 
  RowBox[{"Partition", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", "2", 
    ",", "1"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28664],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["a", "b"], ",", 
   FractionBox["b", "c"], ",", 
   FractionBox["c", "d"], ",", 
   FractionBox["d", "e"]}], "}"}]], "Output",
 ImageSize->{97, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14450]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2099],

Cell["Expand quotients:", "ExampleText",
 CellID->6484],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"x", "+", "y"}], ")"}], "/", "z"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12529],

Cell[BoxData[
 FractionBox[
  RowBox[{"x", "+", "y"}], "z"]], "Output",
 ImageSize->{35, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25739]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2078],

Cell[BoxData[
 RowBox[{
  FractionBox["x", "z"], "+", 
  FractionBox["y", "z"]}]], "Output",
 ImageSize->{39, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6449]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3523],

Cell["Cancel common factors in rational expressions:", "ExampleText",
 CellID->10018],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cancel", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"x", "^", "2"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"1", "-", "x"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27252],

Cell[BoxData[
 RowBox[{"1", "+", "x"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21535]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5740],

Cell["Split into partial fractions:", "ExampleText",
 CellID->17164],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart", "[", 
  RowBox[{"1", "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", "1"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20038],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}]}]], "-", 
  FractionBox["1", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}]}]]}]], "Output",
 ImageSize->{134, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30265]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27311],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", "0"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11473],

Cell[BoxData[
 RowBox[{
  RowBox[{"Power", "::", "\<\"infy\"\>"}], ":", 
  " ", "\<\"Infinite expression \\!\\(1\\/0\\) encountered. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/infy\\\", \
ButtonNote -> \\\"Power::infy\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->23102676],

Cell[BoxData["ComplexInfinity"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->70297830]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"0", "/", "0"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15207],

Cell[BoxData[
 RowBox[{
  RowBox[{"Power", "::", "\<\"infy\"\>"}], ":", 
  " ", "\<\"Infinite expression \\!\\(1\\/0\\) encountered. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/infy\\\", \
ButtonNote -> \\\"Power::infy\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->135276664],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Infinity]", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"Indeterminate expression \\!\\(0\\\\ ComplexInfinity\\) \
encountered. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/indet\\\", ButtonNote -> \
\\\"Infinity::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->197390237],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->487855270]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", "Infinity"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->30236],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->35228604]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29649],

Cell[TextData[{
 "Pattern matching relies on ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->22572],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Replace", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "/", 
    RowBox[{"y", "^", "3"}]}], ",", 
   RowBox[{
    RowBox[{"a_", "/", "b_"}], "->", 
    RowBox[{"f", "[", 
     RowBox[{"a", ",", "b"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20180],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["x", "2"], 
  SuperscriptBox["y", "3"]]], "Output",
 ImageSize->{21, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23843]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "/", 
   RowBox[{"y", "^", "3"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->787],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Times", "[", 
    RowBox[{
     RowBox[{"Power", "[", 
      RowBox[{"x", ",", "2"}], "]"}], ",", 
     RowBox[{"Power", "[", 
      RowBox[{"y", ",", 
       RowBox[{"-", "3"}]}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->26523]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Replace", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "/", 
    RowBox[{"y", "^", "3"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", ":", 
       RowBox[{"(", 
        RowBox[{"_", "^", "_."}], ")"}]}], ")"}], 
     RowBox[{"(", 
      RowBox[{"b", ":", 
       RowBox[{"(", 
        RowBox[{"_", "^", "_."}], ")"}]}], ")"}]}], "->", 
    RowBox[{"f", "[", 
     RowBox[{"a", ",", "b"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->7211],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   SuperscriptBox["x", "2"], ",", 
   FractionBox["1", 
    SuperscriptBox["y", "3"]]}], "]"}]], "Output",
 ImageSize->{66, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->26735]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12749],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"1", "+", "#"}], ")"}]}], "&"}], ",", "x", ",", "5"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14758],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   FractionBox["1", 
    RowBox[{"1", "+", "x"}]], ",", 
   FractionBox["1", 
    RowBox[{"1", "+", 
     FractionBox["1", 
      RowBox[{"1", "+", "x"}]]}]], ",", 
   FractionBox["1", 
    RowBox[{"1", "+", 
     FractionBox["1", 
      RowBox[{"1", "+", 
       FractionBox["1", 
        RowBox[{"1", "+", "x"}]]}]]}]], ",", 
   FractionBox["1", 
    RowBox[{"1", "+", 
     FractionBox["1", 
      RowBox[{"1", "+", 
       FractionBox["1", 
        RowBox[{"1", "+", 
         FractionBox["1", 
          RowBox[{"1", "+", "x"}]]}]]}]]}]], ",", 
   FractionBox["1", 
    RowBox[{"1", "+", 
     FractionBox["1", 
      RowBox[{"1", "+", 
       FractionBox["1", 
        RowBox[{"1", "+", 
         FractionBox["1", 
          RowBox[{"1", "+", 
           FractionBox["1", 
            RowBox[{"1", "+", "x"}]]}]]}]]}]]}]]}], "}"}]], "Output",
 ImageSize->{362, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30217]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27335],

Cell["Array of possible fractions:", "ExampleText",
 CellID->24008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{"Divide", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25669],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     FractionBox["1", "2"], ",", 
     FractionBox["1", "3"], ",", 
     FractionBox["1", "4"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", 
     FractionBox["2", "3"], ",", 
     FractionBox["1", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     FractionBox["3", "2"], ",", "1", ",", 
     FractionBox["3", "4"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2", ",", 
     FractionBox["4", "3"], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{387, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30914]
}, Open  ]],

Cell["Integers that divide exactly:", "ExampleText",
 CellID->12320],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Position", "[", 
   RowBox[{
    RowBox[{"Array", "[", 
     RowBox[{"Divide", ",", 
      RowBox[{"{", 
       RowBox[{"20", ",", "20"}], "}"}]}], "]"}], ",", "_Integer"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9590],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJx1krEKwjAURYNTxgwZOnSIpYiIiLXdLX6CnyA4++t+goo5gwdbKIfz7stL
SLu+Pa73VQjh8n4//D6H+T9z5bHyef7N7VH9RW4Gearcaf5O9W1lI4f7ylZu
Mh/nPJPySfmofFSd/l5uJjn3fdJ8nP0H5YPq9HdyM8obMcjZD2d9Vp5Vb8Wi
fu/bKuccMCo3g3LumXoSo0id9ZsFh3znLIf8l1Ge5MzHOW8RO/WXhX7m9+rv
1c+8KO/mF+BXQ/0=
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  Axes->True,
  PlotRange->{{0., 20.}, {0., 20.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->79920488]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7799],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Times",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Times"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DivideBy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DivideBy"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GCD"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quotient",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quotient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mod"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Convergents",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Convergents"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8723]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16567],

Cell[TextData[ButtonBox["Arithmetic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Arithmetic"]], "Tutorials",
 CellID->20676],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->400354195]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->241982306],

Cell[TextData[ButtonBox["Arithmetic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ArithmeticFunctions"]], "MoreAbout",
 CellID->449926733]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Divide (/, \[Divide]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 43.3056220}", "context" -> "System`", 
    "keywords" -> {"divide", "reciprocal"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "x/y or Divide[x, y] is equivalent to x y^-1. ", "synonyms" -> {"/"}, 
    "title" -> "Divide", "type" -> "Symbol", "uri" -> "ref/Divide"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5743, 196, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1510058]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28801, 1162}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2263, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2886, 79, 110, 4, 70, "ObjectName",
 CellID->30095],
Cell[2999, 85, 804, 28, 70, "Usage",
 CellID->20985]
}, Open  ]],
Cell[CellGroupData[{
Cell[3840, 118, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4318, 135, 303, 12, 70, "Notes",
 CellID->27846],
Cell[4624, 149, 1082, 42, 70, "Notes",
 CellID->2032]
}, Closed]],
Cell[CellGroupData[{
Cell[5743, 196, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1510058],
Cell[CellGroupData[{
Cell[6126, 210, 147, 5, 70, "ExampleSection",
 CellID->83312172],
Cell[CellGroupData[{
Cell[6298, 219, 89, 3, 28, "Input",
 CellID->6003],
Cell[6390, 224, 153, 5, 36, "Output",
 CellID->3751]
}, Open  ]],
Cell[6558, 232, 121, 3, 70, "ExampleDelimiter",
 CellID->28276],
Cell[6682, 237, 182, 7, 70, "ExampleText",
 CellID->32642],
Cell[CellGroupData[{
Cell[6889, 248, 88, 3, 42, "Input",
 CellID->30950],
Cell[6980, 253, 153, 5, 36, "Output",
 CellID->3398]
}, Open  ]],
Cell[7148, 261, 121, 3, 70, "ExampleDelimiter",
 CellID->31728],
Cell[7272, 266, 204, 7, 70, "ExampleText",
 CellID->25668],
Cell[CellGroupData[{
Cell[7501, 277, 91, 3, 70, "Input",
 CellID->10049],
Cell[7595, 282, 175, 6, 51, "Output",
 CellID->24456]
}, Open  ]],
Cell[7785, 291, 120, 3, 70, "ExampleDelimiter",
 CellID->4973],
Cell[7908, 296, 111, 3, 70, "ExampleText",
 CellID->68],
Cell[CellGroupData[{
Cell[8044, 303, 91, 3, 70, "Input",
 CellID->1046],
Cell[8138, 308, 172, 5, 36, "Output",
 CellID->11723]
}, Open  ]],
Cell[8325, 316, 120, 3, 70, "ExampleDelimiter",
 CellID->5278],
Cell[8448, 321, 117, 4, 70, "ExampleText",
 CellID->27137],
Cell[CellGroupData[{
Cell[8590, 329, 135, 5, 70, "Input",
 CellID->27445],
Cell[8728, 336, 207, 7, 50, "Output",
 CellID->18093]
}, Open  ]],
Cell[8950, 346, 121, 3, 70, "ExampleDelimiter",
 CellID->11644],
Cell[9074, 351, 185, 6, 70, "ExampleText",
 CellID->2585],
Cell[CellGroupData[{
Cell[9284, 361, 170, 6, 70, "Input",
 CellID->2837],
Cell[9457, 369, 490, 18, 50, "Output",
 CellID->9690]
}, Open  ]],
Cell[9962, 390, 120, 3, 70, "ExampleDelimiter",
 CellID->5587],
Cell[10085, 395, 198, 7, 70, "ExampleText",
 CellID->30908],
Cell[CellGroupData[{
Cell[10308, 406, 96, 3, 70, "Input",
 CellID->7285],
Cell[10407, 411, 154, 5, 36, "Output",
 CellID->23842]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10610, 422, 216, 7, 70, "ExampleSection",
 CellID->20319],
Cell[10829, 431, 201, 7, 70, "ExampleText",
 CellID->5071],
Cell[CellGroupData[{
Cell[11055, 442, 154, 5, 70, "Input",
 CellID->7930],
Cell[11212, 449, 285, 10, 51, "Output",
 CellID->17077]
}, Open  ]],
Cell[CellGroupData[{
Cell[11534, 464, 202, 7, 70, "Input",
 CellID->29372],
Cell[11739, 473, 274, 10, 49, "Output",
 CellID->4149]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12062, 489, 222, 7, 70, "ExampleSection",
 CellID->5845],
Cell[CellGroupData[{
Cell[12309, 500, 172, 5, 70, "Input",
 CellID->32650],
Cell[12484, 507, 510, 16, 51, "Output",
 CellID->8946]
}, Open  ]],
Cell[13009, 526, 121, 3, 70, "ExampleDelimiter",
 CellID->20435],
Cell[13133, 531, 67, 1, 70, "ExampleText",
 CellID->13529],
Cell[CellGroupData[{
Cell[13225, 536, 251, 8, 70, "Input",
 CellID->28664],
Cell[13479, 546, 307, 11, 51, "Output",
 CellID->14450]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13835, 563, 232, 7, 70, "ExampleSection",
 CellID->2099],
Cell[14070, 572, 55, 1, 70, "ExampleText",
 CellID->6484],
Cell[CellGroupData[{
Cell[14150, 577, 135, 5, 70, "Input",
 CellID->12529],
Cell[14288, 584, 197, 7, 49, "Output",
 CellID->25739]
}, Open  ]],
Cell[CellGroupData[{
Cell[14522, 596, 97, 3, 70, "Input",
 CellID->2078],
Cell[14622, 601, 217, 8, 49, "Output",
 CellID->6449]
}, Open  ]],
Cell[14854, 612, 120, 3, 70, "ExampleDelimiter",
 CellID->3523],
Cell[14977, 617, 85, 1, 70, "ExampleText",
 CellID->10018],
Cell[CellGroupData[{
Cell[15087, 622, 245, 9, 70, "Input",
 CellID->27252],
Cell[15335, 633, 176, 6, 36, "Output",
 CellID->21535]
}, Open  ]],
Cell[15526, 642, 120, 3, 70, "ExampleDelimiter",
 CellID->5740],
Cell[15649, 647, 68, 1, 70, "ExampleText",
 CellID->17164],
Cell[CellGroupData[{
Cell[15742, 652, 195, 7, 70, "Input",
 CellID->20038],
Cell[15940, 661, 391, 15, 53, "Output",
 CellID->30265]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16380, 682, 226, 7, 70, "ExampleSection",
 CellID->27311],
Cell[CellGroupData[{
Cell[16631, 693, 88, 3, 70, "Input",
 CellID->11473],
Cell[16722, 698, 366, 7, 70, "Message",
 CellID->23102676],
Cell[17091, 707, 172, 5, 36, "Output",
 CellID->70297830]
}, Open  ]],
Cell[CellGroupData[{
Cell[17300, 717, 88, 3, 70, "Input",
 CellID->15207],
Cell[17391, 722, 367, 7, 70, "Message",
 CellID->135276664],
Cell[17761, 731, 402, 8, 70, "Message",
 CellID->197390237],
Cell[18166, 741, 170, 5, 36, "Output",
 CellID->487855270]
}, Open  ]],
Cell[CellGroupData[{
Cell[18373, 751, 95, 3, 70, "Input",
 CellID->30236],
Cell[18471, 756, 157, 5, 36, "Output",
 CellID->35228604]
}, Open  ]],
Cell[18643, 764, 121, 3, 70, "ExampleDelimiter",
 CellID->29649],
Cell[18767, 769, 206, 8, 70, "ExampleText",
 CellID->22572],
Cell[CellGroupData[{
Cell[18998, 781, 304, 11, 70, "Input",
 CellID->20180],
Cell[19305, 794, 222, 8, 57, "Output",
 CellID->23843]
}, Open  ]],
Cell[CellGroupData[{
Cell[19564, 807, 169, 6, 70, "Input",
 CellID->787],
Cell[19736, 815, 491, 18, 50, "Output",
 CellID->26523]
}, Open  ]],
Cell[CellGroupData[{
Cell[20264, 838, 518, 19, 70, "Input",
 CellID->7211],
Cell[20785, 859, 277, 10, 54, "Output",
 CellID->26735]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21111, 875, 224, 7, 70, "ExampleSection",
 CellID->12749],
Cell[CellGroupData[{
Cell[21360, 886, 233, 9, 70, "Input",
 CellID->14758],
Cell[21596, 897, 1025, 37, 88, "Output",
 CellID->30217]
}, Open  ]],
Cell[22636, 937, 121, 3, 70, "ExampleDelimiter",
 CellID->27335],
Cell[22760, 942, 67, 1, 70, "ExampleText",
 CellID->24008],
Cell[CellGroupData[{
Cell[22852, 947, 174, 6, 70, "Input",
 CellID->25669],
Cell[23029, 955, 688, 23, 51, "Output",
 CellID->30914]
}, Open  ]],
Cell[23732, 981, 68, 1, 70, "ExampleText",
 CellID->12320],
Cell[CellGroupData[{
Cell[23825, 986, 290, 10, 70, "Input",
 CellID->9590],
Cell[24118, 998, 699, 20, 143, "Output",
 CellID->79920488]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24878, 1025, 310, 9, 70, "SeeAlsoSection",
 CellID->7799],
Cell[25191, 1036, 1410, 53, 70, "SeeAlso",
 CellID->8723]
}, Open  ]],
Cell[CellGroupData[{
Cell[26638, 1094, 314, 9, 70, "TutorialsSection",
 CellID->16567],
Cell[26955, 1105, 131, 3, 70, "Tutorials",
 CellID->20676],
Cell[27089, 1110, 133, 3, 70, "Tutorials",
 CellID->400354195]
}, Open  ]],
Cell[CellGroupData[{
Cell[27259, 1118, 319, 9, 70, "MoreAboutSection",
 CellID->241982306],
Cell[27581, 1129, 151, 3, 70, "MoreAbout",
 CellID->449926733]
}, Open  ]],
Cell[27747, 1135, 50, 0, 70, "History"],
Cell[27800, 1137, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

