(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39752,       1364]
NotebookOptionsPosition[     34128,       1173]
NotebookOutlinePosition[     35360,       1209]
CellTagsIndexPosition[     35274,       1204]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tables and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/TablesAndMatrices"], 
          "Grids, Rows, and Columns in Mathematica" :> 
          Documentation`HelpLookup["paclet:tutorial/GridsRowsAndColumns"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Tables and Matrices\"\>", 
       2->"\<\"Grids, Rows, and Columns in Mathematica\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Frame" :> Documentation`HelpLookup["paclet:ref/Frame"], 
          "Delimiter" :> Documentation`HelpLookup["paclet:ref/Delimiter"], 
          "Item" :> Documentation`HelpLookup["paclet:ref/Item"], "Spacings" :> 
          Documentation`HelpLookup["paclet:ref/Spacings"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Frame\"\>", 2->"\<\"Delimiter\"\>", 
       3->"\<\"Item\"\>", 4->"\<\"Spacings\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Grids & Tables" :> 
          Documentation`HelpLookup["paclet:guide/GridsAndTables"], 
          "Layout & Tables" :> 
          Documentation`HelpLookup["paclet:guide/LayoutAndTables"], 
          "User Interface Structuring & Layout" :> 
          Documentation`HelpLookup[
           "paclet:guide/UserInterfaceStructuringAndLayout"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Grids & Tables\"\>", 
       2->"\<\"Layout & Tables\"\>", 
       3->"\<\"User Interface Structuring & Layout\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Dividers", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Dividers",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Dividers"]], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Grid",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
     " and related constructs that specifies where and how to draw divider \
lines."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following basic settings can be given: ", "Notes",
 CellID->31854],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell["draw all dividers", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["None",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/None"], " ", "or", " ", 
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"]}], Cell[
    "draw no dividers", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "draw dividers around the exterior only", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Center",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Center"], Cell[
    "draw dividers between interior items only", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["g", "TI"], Cell[TextData[{
     "draw all dividers using graphics directive ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->1017368999],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " and related constructs, lists of settings can be given. Common cases \
include:"
}], "Notes",
 CellID->24136695],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["All",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/All"], ",", 
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]}], "}"}], Cell[
    "put dividers at every horizontal position (column lines) ", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"], ",", 
      ButtonBox["All",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/All"]}], "}"}], Cell[
    "put dividers at every vertical position (row lines)", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        ButtonBox["False",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/False"], ",", 
        ButtonBox["True",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/True"]}], "}"}], ",", 
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]}], "}"}], Cell[
    "a divider before the second column  ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"], ",", 
      RowBox[{"{", 
       RowBox[{
        ButtonBox["False",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/False"], ",", 
        ButtonBox["True",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/True"]}], "}"}]}], "}"}], Cell[
    "a divider before the second row", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->5388],

Cell[TextData[{
 "General settings for ",
 Cell[BoxData[
  ButtonBox["Dividers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dividers"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " and related constructs can be given as:"
}], "Notes",
 CellID->46514975],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["x", "TI"]], ",", 
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["y", "TI"]]}], "}"}], Cell[TextData[{
     "use the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at successive ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " positions"
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->3275027],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["spec", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can have the following forms:"
}], "Notes",
 CellID->247188],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], "1"], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], "2"], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]], "InlineFormula"],
     "; then use defaults "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"{", 
      StyleBox["c", "TI"], "}"}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     " in all cases "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["c", "TI"], "1"], ",", 
       SubscriptBox[
        StyleBox["c", "TI"], "2"]}], "}"}], "}"}], Cell[TextData[{
     "alternate between ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["c", "TI"], "1"], ",", 
       SubscriptBox[
        StyleBox["c", "TI"], "2"], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}], Cell[TextData[{
     "cycle through all ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["s", "TI"], ",", 
      RowBox[{"{", 
       StyleBox["c", "TI"], "}"}]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     ", then repeatedly use ",
     StyleBox["c", "TI"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]], ",", 
      RowBox[{"{", 
       StyleBox["c", "TI"], "}"}], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", then repeatedly use ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     ", but use ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]], "InlineFormula"],
     " at the end "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox[
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        RowBox[{"{", 
         SubscriptBox[
          StyleBox["c", "TI"], 
          StyleBox["1", "TR"]]}]}]}], Cell[", ", "TableText"], 
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["2", "TR"]], Cell[", \[Ellipsis] }, ", "TableText"], 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["m", "TI"]], Cell[", \[Ellipsis] , ", "TableText"], 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]], Cell["}", "TableText"], 
      StyleBox[" ", "TR"]}],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]"},
   {Cell["      ", "TableRowIcon"], "", Cell[TextData[{
     "use the first sequence of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at the beginning, then cyclically use the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ", then use the last sequence of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at the end "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      RowBox[{"{", "}"}], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["m", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]}], "}"}], Cell[TextData[{
     "use the first sequence of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at the beginning and the last sequence at the end"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], "2"], "->", 
       SubscriptBox[
        StyleBox["v", "TI"], "2"]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "specify what to use at positions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["k", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["spec", "TI"], ",", 
      StyleBox["rules", "TI"]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      StyleBox["rules", "TI"]], "InlineFormula"],
     " to override specifications in ",
     StyleBox["spec", "TI"],
     " "
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, False, True, True, True, 
      True}}}},
 CellID->16534],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["c", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can be ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", or an explicit graphics directive."
}], "Notes",
 CellID->4909400],

Cell[TextData[{
 "Possible graphics directives include ",
 Cell[BoxData[
  ButtonBox["Thick",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thick"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Thin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thin"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Dashed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashed"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Dotted",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dotted"]], "InlineFormula"],
 ", as well as color, thickness and dashing directives, and composite \
directives specified by ",
 Cell[BoxData[
  ButtonBox["Directive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Directive"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->423998128],

Cell[TextData[{
 "For a grid with ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " items in a particular direction, ",
 Cell[BoxData[
  ButtonBox["Dividers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dividers"]], "InlineFormula"],
 " can specify settings for dividers in the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "+", "1"}], TraditionalForm]], "InlineMath"],
 " gaps between items, starting before the first element, and ending after \
the last element."
}], "Notes",
 CellID->49335815],

Cell["\<\
Dividers are always placed at the center of the gaps between items.\
\>", "Notes",
 CellID->64547217],

Cell["Dividers never extend into items that span rows or columns.", "Notes",
 CellID->505522466]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->127070255],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->113317243],

Cell["Draw all the interior dividers in a grid:", "ExampleText",
 CellID->1206206043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Dividers", "\[Rule]", "Center"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->459337021],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxDividers->{
    "Columns" -> {False, {True}, False}, "Rows" -> {False, {True}, False}}],
  "Grid"]], "Output",
 ImageSize->{107, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2021084629]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1100980617],

Cell["Put dividers at all horizontal positions:", "ExampleText",
 CellID->324771918],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"All", ",", "False"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->750408934],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxDividers->{"Columns" -> {{True}}, "Rows" -> {{False}}}],
  "Grid"]], "Output",
 ImageSize->{117, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2140044321]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["\<\
Put dividers at the third horizontal and second vertical positions:\
\>", "ExampleText",
 CellID->23932850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"False", ",", "False", ",", "True"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"False", ",", "True"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->659967961],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxDividers->{
    "Columns" -> {False, False, True}, "Rows" -> {False, True}}],
  "Grid"]], "Output",
 ImageSize->{102, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->120249719]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1605034596],

Cell["Draw a divider at every other horizontal position:", "ExampleText",
 CellID->1237013789],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "11", "}"}]}], "]"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"True", ",", "False"}], "}"}], "}"}], ",", "False"}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1897885587],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmkEOgjAQRUtLFGPcu9CEa3gBXXmIhpjAwmiQO3HM2lI0ChsTF5b6SNrO
dAY++Wlm/qJH3ZSns26qQueHWl/Lqrjl+0ttt1QihGjt2K2FtY21utEa41bl
7O4RWze9+Jsv/ewHCNJO0rqPdTHwZy4pfeZHkp2MeFDv+dZYjnbmAzZl9O/I
EU9pz+CqX7PBN1QgcRXRn3M2Pzub1DLPQwx9CQQQpoNA5fE80KlQUWHEUVGo
KFQUCCBMB4HK43mgU6GiwoijolBRqCgQQJgOApXH80CnQkWFEUdFoaL+U0X1
d2aSO9yX8pU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{167, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->391330964]
}, Open  ]],

Cell["Include the final position:", "ExampleText",
 CellID->1519682582],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "11", "}"}]}], "]"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"True", ",", "False"}], "}"}], "}"}], ",", 
        RowBox[{
         RowBox[{"-", "1"}], "\[Rule]", "True"}]}], "}"}], ",", "False"}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->564304379],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWkEOgjAQLC2CRr17kIRv+AE9+YiGmMDBaJBn8ce6JdVq5WDiQbsOSdvd
0jKbyWZ3Dux1Vx+OumsqXe5afa6b6lJuTy1tqUQI0dPYrATZhqxh9MbYVVl7
eERhpwd//aG/oMmCfwNF0iTJva2zwM/sofR+nsnpySgX6vkOGfOXnTxgVbK/
k41ylToml26dBt9RP/I+Zxg98vT9PEV981xw6ltAAQoPFFQozwU6GxRYDNEj
T6HAoMCAAhQOKKhQngt0NiiwGKJHnkKBQYEBBSgcUFChPBfobFBgMUSPPIUC
+0cF5v4HSq5ykfO3\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{172, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->14748340]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2112736797],

Cell["Draw dividers with specified styles:", "ExampleText",
 CellID->125244034],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"2", "\[Rule]", "Red"}], ",", 
        RowBox[{
         RowBox[{"-", "2"}], "\[Rule]", "Blue"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"2", "\[Rule]", "Red"}], ",", 
        RowBox[{
         RowBox[{"-", "2"}], "\[Rule]", "Blue"}]}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->442505378],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWM0OwiAM7kDdjHr3uPfwrvHgzYNXQky2g9HMvT+WAv7gQY2LdgkkrD+U
Utr1y7KNaqv9QbW1VuWqUaeq1udyeWxQJTMA0DgXc0DeIEdTG4N0ap8SGUMD
1iQH0UDxgZVAtwI5S0dWM7ju8NqwOv5Sdt7vnD+sZhQNDB3xIeLIo1sI7+Vm
MulIk0f5eT5JuIz5iIsoMun1sxe0iM4J++QPvPciv6zeyC57rVMriwiSSmhN
YUuUbbRvWfGqfC96xSQsSlgUbsG7u7la8apxL7rCJNRJqBNu8a++3dmEkZY+
fVBrq8k12oRFCYsSFnHCIvcvBbILvaD1ZQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{99, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4864243]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dividers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dividers"]], "InlineFormula"],
 " acts in addition to any ",
 Cell[BoxData[
  ButtonBox["Frame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Frame"]], "InlineFormula"],
 " specification:"
}], "ExampleText",
 CellID->2105676845],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"2", "\[Rule]", "Red"}], ",", 
        RowBox[{
         RowBox[{"-", "2"}], "\[Rule]", "Blue"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"2", "\[Rule]", "Red"}], ",", 
        RowBox[{
         RowBox[{"-", "2"}], "\[Rule]", "Blue"}]}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->498668451],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWD0PgjAQPSgCRnR25K+4aBzcjRshJjAQDfL/6/WLaCFRotFr0oZe+668
tkePN/RQdNW5Kbq6LPJdW1yrurzl20uLLhYAQIN1swbsc+zJ2nDO1QAWJjyy
wEoYxnu8l9hADhmawEFWiCZEaNpYOKN+Fmt0/iFWsz9M/jQ6G90h0xyDARIr
0nDwxuJLnsT6hsOV4tE9Rzqi1Nop0/7liza11jW8hMBqLp4H/SynrxQTWVJP
kSWMYGl8RONUHH9g0c9WFzXAazKt86Cf5fSVwrO82poYaP3dXm1pnQf9LKev
FFNZ8oETV5hrnKFxK47fs+hnq4sa4DWZ1nnQz3L6SvE+S93pqvtdCO7FLdKV
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{109, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->156506157]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1727715002],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FrameStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameStyle"]], "InlineFormula"],
 " will set the default style for all lines in the grid:"
}], "ExampleText",
 CellID->1579647527],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"2", "\[Rule]", "Red"}], ",", 
        RowBox[{
         RowBox[{"-", "2"}], "\[Rule]", "Blue"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"2", "\[Rule]", "Red"}], ",", 
        RowBox[{
         RowBox[{"-", "2"}], "\[Rule]", "Blue"}]}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Thickness", "[", "2", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->51272619],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwFAKxqwQDkP0fyALj
wv///0MkYCQTEAsARZmA4t4gGqiKD0LTXJYFymOC0mxQ1cxo4pwU8tmgtqOb
y4riGhCPgQUUSmAAZLBD3cOCIcNNJRF2qMswbWBDcRuMxwF1EczlvARoDqj5
MPXsdDB1MIfj4EpxA5XvBIAiINloEE1IdKDciFd2cMXjYE7xoyUHdcJxcKW4
wZkrR0uDwZ6KR0sD6oTj4EpxA5XvYv+DaaAohI9PdLTkGC05RkuOwZbiBiLf
IY8+QMYjGBgBZQ6xUQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{113, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39102532]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Frame",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Frame"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Delimiter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Delimiter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Item",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Item"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Spacings",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Spacings"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Tables and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TablesAndMatrices"]], "Tutorials",
 CellID->22605],

Cell[TextData[{
 ButtonBox["Grids, Rows, and Columns in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
  FontSlant->"Italic"]
}], "Tutorials",
 CellID->542584750]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->445080535],

Cell[TextData[ButtonBox["Grids & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GridsAndTables"]], "MoreAbout",
 CellID->406895861],

Cell[TextData[ButtonBox["Layout & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LayoutAndTables"]], "MoreAbout",
 CellID->38476025],

Cell[TextData[ButtonBox["User Interface Structuring & Layout",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/UserInterfaceStructuringAndLayout"]], "MoreAbout",
 CellID->373073565]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Dividers - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 43.7743840}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Dividers is an option for Grid and related constructs that specifies \
where and how to draw divider lines.", "synonyms" -> {}, "title" -> 
    "Dividers", "type" -> "Symbol", "uri" -> "ref/Dividers"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[19985, 652, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->127070255]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 35130, 1197}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2506, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3129, 85, 1573, 37, 70, "ObjectNameGrid"],
Cell[4705, 124, 618, 19, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5360, 148, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5838, 165, 76, 1, 70, "Notes",
 CellID->31854],
Cell[5917, 168, 1344, 36, 70, "2ColumnTableMod",
 CellID->1017368999],
Cell[7264, 206, 251, 9, 70, "Notes",
 CellID->24136695],
Cell[7518, 217, 2067, 61, 70, "2ColumnTableMod",
 CellID->5388],
Cell[9588, 280, 356, 13, 70, "Notes",
 CellID->46514975],
Cell[9947, 295, 984, 32, 70, "2ColumnTableMod",
 CellID->3275027],
Cell[10934, 329, 191, 8, 70, "Notes",
 CellID->247188],
Cell[11128, 339, 6745, 226, 70, "2ColumnTableMod",
 CellID->16534],
Cell[17876, 567, 549, 23, 70, "Notes",
 CellID->4909400],
Cell[18428, 592, 790, 29, 70, "Notes",
 CellID->423998128],
Cell[19221, 623, 514, 16, 70, "Notes",
 CellID->49335815],
Cell[19738, 641, 111, 3, 70, "Notes",
 CellID->64547217],
Cell[19852, 646, 96, 1, 70, "Notes",
 CellID->505522466]
}, Closed]],
Cell[CellGroupData[{
Cell[19985, 652, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->127070255],
Cell[CellGroupData[{
Cell[20370, 666, 148, 5, 70, "ExampleSection",
 CellID->113317243],
Cell[20521, 673, 85, 1, 70, "ExampleText",
 CellID->1206206043],
Cell[CellGroupData[{
Cell[20631, 678, 285, 9, 28, "Input",
 CellID->459337021],
Cell[20919, 689, 412, 13, 66, "Output",
 CellID->2021084629]
}, Open  ]],
Cell[21346, 705, 126, 3, 70, "ExampleDelimiter",
 CellID->1100980617],
Cell[21475, 710, 84, 1, 70, "ExampleText",
 CellID->324771918],
Cell[CellGroupData[{
Cell[21584, 715, 337, 11, 70, "Input",
 CellID->750408934],
Cell[21924, 728, 380, 12, 64, "Output",
 CellID->2140044321]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22353, 746, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[22577, 755, 117, 3, 70, "ExampleText",
 CellID->23932850],
Cell[CellGroupData[{
Cell[22719, 762, 469, 15, 70, "Input",
 CellID->659967961],
Cell[23191, 779, 400, 13, 64, "Output",
 CellID->120249719]
}, Open  ]],
Cell[23606, 795, 126, 3, 70, "ExampleDelimiter",
 CellID->1605034596],
Cell[23735, 800, 94, 1, 70, "ExampleText",
 CellID->1237013789],
Cell[CellGroupData[{
Cell[23854, 805, 434, 15, 70, "Input",
 CellID->1897885587],
Cell[24291, 822, 529, 13, 70, "Output",
 Evaluatable->False,
 CellID->391330964]
}, Open  ]],
Cell[24835, 838, 71, 1, 70, "ExampleText",
 CellID->1519682582],
Cell[CellGroupData[{
Cell[24931, 843, 557, 19, 70, "Input",
 CellID->564304379],
Cell[25491, 864, 532, 13, 70, "Output",
 Evaluatable->False,
 CellID->14748340]
}, Open  ]],
Cell[26038, 880, 126, 3, 70, "ExampleDelimiter",
 CellID->2112736797],
Cell[26167, 885, 79, 1, 70, "ExampleText",
 CellID->125244034],
Cell[CellGroupData[{
Cell[26271, 890, 644, 22, 70, "Input",
 CellID->442505378],
Cell[26918, 914, 550, 13, 70, "Output",
 Evaluatable->False,
 CellID->4864243]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27517, 933, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[27758, 942, 336, 12, 70, "ExampleText",
 CellID->2105676845],
Cell[CellGroupData[{
Cell[28119, 958, 688, 22, 70, "Input",
 CellID->498668451],
Cell[28810, 982, 578, 14, 70, "Output",
 Evaluatable->False,
 CellID->156506157]
}, Open  ]],
Cell[29403, 999, 126, 3, 70, "ExampleDelimiter",
 CellID->1727715002],
Cell[29532, 1004, 236, 7, 70, "ExampleText",
 CellID->1579647527],
Cell[CellGroupData[{
Cell[29793, 1015, 774, 24, 70, "Input",
 CellID->51272619],
Cell[30570, 1041, 536, 13, 70, "Output",
 Evaluatable->False,
 CellID->39102532]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31167, 1061, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[31486, 1072, 933, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[32456, 1112, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[32777, 1123, 147, 3, 70, "Tutorials",
 CellID->22605],
Cell[32927, 1128, 303, 9, 70, "Tutorials",
 CellID->542584750]
}, Open  ]],
Cell[CellGroupData[{
Cell[33267, 1142, 319, 9, 70, "MoreAboutSection",
 CellID->445080535],
Cell[33589, 1153, 140, 3, 70, "MoreAbout",
 CellID->406895861],
Cell[33732, 1158, 141, 3, 70, "MoreAbout",
 CellID->38476025],
Cell[33876, 1163, 180, 3, 70, "MoreAbout",
 CellID->373073565]
}, Open  ]],
Cell[34071, 1169, 27, 0, 70, "History"],
Cell[34101, 1171, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

