(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     43228,       1564]
NotebookOptionsPosition[     34536,       1254]
NotebookOutlinePosition[     35720,       1290]
CellTagsIndexPosition[     35634,       1285]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FactorInteger" :> 
          Documentation`HelpLookup["paclet:ref/FactorInteger"], "EulerPhi" :> 
          Documentation`HelpLookup["paclet:ref/EulerPhi"], "Divisible" :> 
          Documentation`HelpLookup["paclet:ref/Divisible"], "DivisorSigma" :> 
          Documentation`HelpLookup["paclet:ref/DivisorSigma"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FactorInteger\"\>", 
       2->"\<\"EulerPhi\"\>", 3->"\<\"Divisible\"\>", 
       4->"\<\"DivisorSigma\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Integer Functions\"\>", 
       2->"\<\"Number Theoretic Functions\"\>", 
       3->"\<\"Number Theory\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Divisors", "ObjectName",
 CellID->25878],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Divisors",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Divisors"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the integers that divide ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9951]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Divisors",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Divisors"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    RowBox[{
     ButtonBox["GaussianIntegers",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GaussianIntegers"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}]}], "]"}]], "InlineFormula"],
 " includes divisors that are Gaussian integers. "
}], "Notes",
 CellID->32737]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->69796950],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->331695660],

Cell["The divisors of 1729:", "ExampleText",
 CellID->2118567642],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Divisors", "[", "1729", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->52282846],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "7", ",", "13", ",", "19", ",", "91", ",", "133", ",", "247", ",",
    "1729"}], "}"}]], "Output",
 ImageSize->{223, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1420260094]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1729", "/", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->36171775],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1729", ",", "247", ",", "133", ",", "91", ",", "19", ",", "13", ",", "7", 
   ",", "1"}], "}"}]], "Output",
 ImageSize->{223, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1030663453]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24763],

Cell["For integer input integer divisors are returned:", "ExampleText",
 CellID->232514639],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Divisors", "[", "6", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->648457269],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3", ",", "6"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->757557869]
}, Open  ]],

Cell["For Gaussian integer input Gaussian divisors are produced:", \
"ExampleText",
 CellID->452041641],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Divisors", "[", 
  RowBox[{"6", "+", 
   RowBox[{"4", "I"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->324718659],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"1", "+", "\[ImaginaryI]"}], ",", 
   RowBox[{"1", "+", 
    RowBox[{"5", " ", "\[ImaginaryI]"}]}], ",", "2", ",", 
   RowBox[{"3", "+", 
    RowBox[{"2", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"6", "+", 
    RowBox[{"4", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 ImageSize->{229, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1992044867]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->966540591],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Divisors",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Divisors"]], "InlineFormula"],
 " threads element\[Hyphen]wise over list arguments:"
}], "ExampleText",
 CellID->105985070],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Divisors", "[", 
  RowBox[{"{", 
   RowBox[{"605", ",", "871", ",", "824"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->735322318],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "5", ",", "11", ",", "55", ",", "121", ",", "605"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "13", ",", "67", ",", "871"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "4", ",", "8", ",", "103", ",", "206", ",", "412", 
     ",", "824"}], "}"}]}], "}"}]], "Output",
 ImageSize->{503, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1028022939]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10704],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "GaussianIntegers",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->26899],

Cell["This will produce Gaussian divisors for integer input:", "ExampleText",
 CellID->728146825],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Divisors", "[", 
  RowBox[{"2", ",", 
   RowBox[{"GaussianIntegers", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69704290],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"1", "+", "\[ImaginaryI]"}], ",", "2"}], "}"}]], "Output",
 ImageSize->{82, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1475595658]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->161379826],

Cell["Some primes are also Gaussian primes:", "ExampleText",
 CellID->556349679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Divisors", "[", "3", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->98718507],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "3"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1195068450]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Divisors", "[", 
  RowBox[{"3", ",", 
   RowBox[{"GaussianIntegers", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->101050867],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "3"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->100888759]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->426954849],

Cell["The ratio of Gaussian divisors to integer divisors:", "ExampleText",
 CellID->118299612],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Length", "[", 
       RowBox[{"Divisors", "[", 
        RowBox[{"n", ",", 
         RowBox[{"GaussianIntegers", "\[Rule]", "True"}]}], "]"}], "]"}], "/",
       
      RowBox[{"Length", "[", 
       RowBox[{"Divisors", "[", "n", "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "200"}], "}"}]}], "]"}], ",", " ", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16242495],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->80329439]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14985],

Cell[TextData[{
 "Find all ",
 ButtonBox["perfect numbers",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://mathworld.wolfram.com/PerfectNumber.html"], None}],
 " less than ",
 "10000",
 ":"
}], "ExampleText",
 CellID->7769529],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"Range", "[", 
    RowBox[{
     RowBox[{"10", "^", "4"}], "-", "1"}], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Total", "[", 
      RowBox[{"Divisors", "[", "#", "]"}], "]"}], "\[Equal]", 
     RowBox[{"2", "#"}]}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->85912603],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", "28", ",", "496", ",", "8128"}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->445321443]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1850635972],

Cell["Representation of 25 as sum of two squares:", "ExampleText",
 CellID->1166872880],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", "#", "]"}], ",", 
     RowBox[{"Im", "[", "#", "]"}]}], "}"}], "&"}], "/@", " ", 
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{"Divisors", "[", 
     RowBox[{"25", ",", 
      RowBox[{"GaussianIntegers", "->", "True"}]}], "]"}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"Abs", "[", "#", "]"}], "2"], "\[Equal]", "25"}], "&"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->228354313],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->536982706]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PowersRepresentations",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowersRepresentations"]], "InlineFormula"],
 " generates an ordered representation:"
}], "ExampleText",
 CellID->1595108839],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowersRepresentations", "[", 
  RowBox[{"25", ",", "2", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1768396749],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1342055048]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->257706385],

Cell["\<\
Number of representations of a number as a sum of four squares:\
\>", "ExampleText",
 CellID->144028142],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"8", " ", 
  RowBox[{"Total", "[", 
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"Divisors", "[", "20", "]"}], ",", 
     RowBox[{
      RowBox[{"!", 
       RowBox[{"Divisible", "[", 
        RowBox[{"#", ",", "4"}], "]"}]}], "&"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->281364420],

Cell[BoxData["144"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->898447295]
}, Open  ]],

Cell[TextData[{
 "Computation by ",
 Cell[BoxData[
  ButtonBox["SquaresR",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SquaresR"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->100230783],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SquaresR", "[", 
  RowBox[{"4", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->73445099],

Cell[BoxData["144"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1246165008]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22939],

Cell["This counts the number of divisors: ", "ExampleText",
 CellID->113104473],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", 
     RowBox[{"Divisors", "[", 
      RowBox[{
       RowBox[{"2", "^", "12"}], "-", "1"}], "]"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->623274890],

Cell[BoxData["24"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2034763912]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DivisorSigma", "[", 
  RowBox[{"0", ",", 
   RowBox[{
    RowBox[{"2", "^", "12"}], "-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->573809136],

Cell[BoxData["24"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1747474156]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->732380565],

Cell[TextData[{
 "In general, ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["DivisorSigma",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DivisorSigma"], "[", 
    RowBox[{
     StyleBox["d", "TI"], ",", 
     StyleBox["n", "TI"]}], "]"}], "==", 
   RowBox[{
    SubscriptBox[
     StyleBox["\[Sum]", "TR"], 
     RowBox[{
      StyleBox["k", "TI"], "|", 
      StyleBox["n", "TI"]}]], 
    SuperscriptBox[
     StyleBox["k", "TI"], 
     StyleBox["d", "TI"]]}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->757894279],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"DivisorSigma", "[", 
       RowBox[{"d", ",", 
        RowBox[{
         RowBox[{"2", "^", "12"}], "-", "1"}]}], "]"}], ",", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{"k", "^", "d"}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", 
          RowBox[{"Divisors", "[", 
           RowBox[{
            RowBox[{"2", "^", "12"}], "-", "1"}], "]"}]}], "}"}]}], "]"}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "0", ",", "5"}], "}"}]}], "]"}], "//", 
  "Grid"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->34409933],

Cell[BoxData[
 TagBox[GridBox[{
    {"24", "24"},
    {"8736", "8736"},
    {"20111000", "20111000"},
    {"72119474784", "72119474784"},
    {"285298969860632", "285298969860632"},
    {"1156715003725016736", "1156715003725016736"}
   }],
  "Grid"]], "Output",
 ImageSize->{304, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->811783520]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->52660838],

Cell[TextData[{
 "Similarly, ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["EulerPhi",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EulerPhi"], "[", 
    StyleBox["n", "TI"], "]"}], "==", 
   RowBox[{
    StyleBox["n", "TI"], 
    RowBox[{
     SubscriptBox[
      StyleBox["\[Product]", "TR"], 
      RowBox[{
       StyleBox["p", "TI"], "|", 
       StyleBox["n", "TI"]}]], 
     RowBox[{"(", 
      RowBox[{
       StyleBox["1", "TR"], "-", 
       RowBox[{
        StyleBox["1", "TR"], "/", 
        StyleBox["p", "TI"]}]}], ")"}]}]}]}]], "InlineFormula"],
 " where ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " prime:"
}], "ExampleText",
 CellID->305474779],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"100", " ", 
  RowBox[{"Product", "[", 
   RowBox[{
    RowBox[{"1", "-", 
     RowBox[{"1", "/", "k"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", 
      RowBox[{"Select", "[", 
       RowBox[{
        RowBox[{"Divisors", "[", "100", "]"}], ",", " ", "PrimeQ"}], "]"}]}], 
     "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1650164],

Cell[BoxData["40"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->682011249]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EulerPhi", "[", "100", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->156961754],

Cell[BoxData["40"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1442837904]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->124705484],

Cell[TextData[{
 "Alternatively, ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["EulerPhi",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EulerPhi"], "[", 
    StyleBox["n", "TI"], "]"}], "==", 
   RowBox[{
    StyleBox["n", "TI"], 
    RowBox[{
     SubscriptBox[
      StyleBox["\[Sum]", "TR"], 
      RowBox[{
       StyleBox["k", "TI"], "|", 
       StyleBox["n", "TI"]}]], 
     RowBox[{
      RowBox[{
       ButtonBox["MoebiusMu",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MoebiusMu"], "[", 
       StyleBox["k", "TI"], "]"}], "/", 
      StyleBox["k", "TI"]}]}]}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->68549989],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"35", " ", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"MoebiusMu", "[", "k", "]"}], "/", "k"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", 
      RowBox[{"Divisors", "[", "35", "]"}]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->80051438],

Cell[BoxData["24"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->391310604]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EulerPhi", "[", "35", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->548372406],

Cell[BoxData["24"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1162394314]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15992],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Divisors",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Divisors"]], "InlineFormula"],
 " gives all divisors except for multiplication by units, that is, they lie \
in the first quadrant:"
}], "ExampleText",
 CellID->58909578],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "=", 
  RowBox[{"Divisors", "[", 
   RowBox[{"2", ",", 
    RowBox[{"GaussianIntegers", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->293651853],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"1", "+", "\[ImaginaryI]"}], ",", "2"}], "}"}]], "Output",
 ImageSize->{82, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->702498639]
}, Open  ]],

Cell["Get all divisors:", "ExampleText",
 CellID->114954886],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{"Outer", "[", 
   RowBox[{"Times", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}], ",", "I", ",", 
      RowBox[{"-", "I"}]}], "}"}], ",", "d"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->787701598],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"1", "+", "\[ImaginaryI]"}], ",", "2", ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "-", "\[ImaginaryI]"}], ",", 
   RowBox[{"-", "2"}], ",", "\[ImaginaryI]", ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "\[ImaginaryI]"}], ",", 
   RowBox[{"2", " ", "\[ImaginaryI]"}], ",", 
   RowBox[{"-", "\[ImaginaryI]"}], ",", 
   RowBox[{"1", "-", "\[ImaginaryI]"}], ",", 
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[ImaginaryI]"}]}], "}"}]], "Output",
 ImageSize->{378, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29534467]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Divisible", "[", 
  RowBox[{"2", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->151124722],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True"}], "}"}]], "Output",
 ImageSize->{478, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->317064412]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22060],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FactorInteger",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FactorInteger"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EulerPhi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EulerPhi"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Divisible",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Divisible"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DivisorSigma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DivisorSigma"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20610]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8961],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->17318]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->6043],

Cell[TextData[{
 ButtonBox["Demonstrations with Divisors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Divisors"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/Divisors.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/NumberTheoryFunctions/Divisors/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Divisors"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->401740038],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->53446554],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->37905770],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->402701209]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Divisors - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 45.5869304}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Divisors[n] gives a list of the integers that divide n. ", 
    "synonyms" -> {}, "title" -> "Divisors", "type" -> "Symbol", "uri" -> 
    "ref/Divisors"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4721, 149, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->69796950]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 35492, 1278}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2435, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3058, 84, 46, 1, 70, "ObjectName",
 CellID->25878],
Cell[3107, 87, 558, 18, 70, "Usage",
 CellID->9951]
}, Open  ]],
Cell[CellGroupData[{
Cell[3702, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4180, 127, 504, 17, 70, "Notes",
 CellID->32737]
}, Closed]],
Cell[CellGroupData[{
Cell[4721, 149, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->69796950],
Cell[CellGroupData[{
Cell[5105, 163, 148, 5, 70, "ExampleSection",
 CellID->331695660],
Cell[5256, 170, 65, 1, 70, "ExampleText",
 CellID->2118567642],
Cell[CellGroupData[{
Cell[5346, 175, 106, 3, 28, "Input",
 CellID->52282846],
Cell[5455, 180, 282, 9, 36, "Output",
 CellID->1420260094]
}, Open  ]],
Cell[CellGroupData[{
Cell[5774, 194, 94, 3, 28, "Input",
 CellID->36171775],
Cell[5871, 199, 282, 9, 36, "Output",
 CellID->1030663453]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6202, 214, 216, 7, 70, "ExampleSection",
 CellID->24763],
Cell[6421, 223, 91, 1, 70, "ExampleText",
 CellID->232514639],
Cell[CellGroupData[{
Cell[6537, 228, 104, 3, 70, "Input",
 CellID->648457269],
Cell[6644, 233, 223, 7, 36, "Output",
 CellID->757557869]
}, Open  ]],
Cell[6882, 243, 103, 2, 70, "ExampleText",
 CellID->452041641],
Cell[CellGroupData[{
Cell[7010, 249, 146, 5, 70, "Input",
 CellID->324718659],
Cell[7159, 256, 464, 14, 36, "Output",
 CellID->1992044867]
}, Open  ]],
Cell[7638, 273, 125, 3, 70, "ExampleDelimiter",
 CellID->966540591],
Cell[7766, 278, 227, 7, 70, "ExampleText",
 CellID->105985070],
Cell[CellGroupData[{
Cell[8018, 289, 167, 5, 70, "Input",
 CellID->735322318],
Cell[8188, 296, 516, 16, 36, "Output",
 CellID->1028022939]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8753, 318, 218, 7, 70, "ExampleSection",
 CellID->10704],
Cell[CellGroupData[{
Cell[8996, 329, 233, 7, 70, "ExampleSubsection",
 CellID->26899],
Cell[9232, 338, 97, 1, 70, "ExampleText",
 CellID->728146825],
Cell[CellGroupData[{
Cell[9354, 343, 174, 5, 70, "Input",
 CellID->69704290],
Cell[9531, 350, 250, 8, 36, "Output",
 CellID->1475595658]
}, Open  ]],
Cell[9796, 361, 125, 3, 70, "ExampleDelimiter",
 CellID->161379826],
Cell[9924, 366, 80, 1, 70, "ExampleText",
 CellID->556349679],
Cell[CellGroupData[{
Cell[10029, 371, 103, 3, 70, "Input",
 CellID->98718507],
Cell[10135, 376, 204, 7, 36, "Output",
 CellID->1195068450]
}, Open  ]],
Cell[CellGroupData[{
Cell[10376, 388, 175, 5, 70, "Input",
 CellID->101050867],
Cell[10554, 395, 203, 7, 36, "Output",
 CellID->100888759]
}, Open  ]],
Cell[10772, 405, 125, 3, 70, "ExampleDelimiter",
 CellID->426954849],
Cell[10900, 410, 94, 1, 70, "ExampleText",
 CellID->118299612],
Cell[CellGroupData[{
Cell[11019, 415, 553, 17, 70, "Input",
 CellID->16242495],
Cell[11575, 434, 5498, 94, 70, "Output",
 Evaluatable->False,
 CellID->80329439]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[17134, 535, 223, 7, 70, "ExampleSection",
 CellID->14985],
Cell[17360, 544, 237, 10, 70, "ExampleText",
 CellID->7769529],
Cell[CellGroupData[{
Cell[17622, 558, 355, 12, 70, "Input",
 CellID->85912603],
Cell[17980, 572, 230, 7, 36, "Output",
 CellID->445321443]
}, Open  ]],
Cell[18225, 582, 126, 3, 70, "ExampleDelimiter",
 CellID->1850635972],
Cell[18354, 587, 87, 1, 70, "ExampleText",
 CellID->1166872880],
Cell[CellGroupData[{
Cell[18466, 592, 517, 18, 70, "Input",
 CellID->228354313],
Cell[18986, 612, 361, 13, 36, "Output",
 CellID->536982706]
}, Open  ]],
Cell[19362, 628, 241, 7, 70, "ExampleText",
 CellID->1595108839],
Cell[CellGroupData[{
Cell[19628, 639, 152, 4, 70, "Input",
 CellID->1768396749],
Cell[19783, 645, 303, 11, 36, "Output",
 CellID->1342055048]
}, Open  ]],
Cell[20101, 659, 125, 3, 70, "ExampleDelimiter",
 CellID->257706385],
Cell[20229, 664, 114, 3, 70, "ExampleText",
 CellID->144028142],
Cell[CellGroupData[{
Cell[20368, 671, 335, 11, 70, "Input",
 CellID->281364420],
Cell[20706, 684, 160, 5, 36, "Output",
 CellID->898447295]
}, Open  ]],
Cell[20881, 692, 198, 8, 70, "ExampleText",
 CellID->100230783],
Cell[CellGroupData[{
Cell[21104, 704, 127, 4, 70, "Input",
 CellID->73445099],
Cell[21234, 710, 161, 5, 36, "Output",
 CellID->1246165008]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21444, 721, 233, 7, 70, "ExampleSection",
 CellID->22939],
Cell[21680, 730, 79, 1, 70, "ExampleText",
 CellID->113104473],
Cell[CellGroupData[{
Cell[21784, 735, 267, 10, 70, "Input",
 CellID->623274890],
Cell[22054, 747, 160, 5, 36, "Output",
 CellID->2034763912]
}, Open  ]],
Cell[CellGroupData[{
Cell[22251, 757, 181, 6, 70, "Input",
 CellID->573809136],
Cell[22435, 765, 160, 5, 36, "Output",
 CellID->1747474156]
}, Open  ]],
Cell[22610, 773, 125, 3, 70, "ExampleDelimiter",
 CellID->732380565],
Cell[22738, 778, 543, 22, 70, "ExampleText",
 CellID->757894279],
Cell[CellGroupData[{
Cell[23306, 804, 662, 23, 70, "Input",
 CellID->34409933],
Cell[23971, 829, 392, 14, 108, "Output",
 CellID->811783520]
}, Open  ]],
Cell[24378, 846, 124, 3, 70, "ExampleDelimiter",
 CellID->52660838],
Cell[24505, 851, 696, 28, 70, "ExampleText",
 CellID->305474779],
Cell[CellGroupData[{
Cell[25226, 883, 376, 13, 70, "Input",
 CellID->1650164],
Cell[25605, 898, 159, 5, 36, "Output",
 CellID->682011249]
}, Open  ]],
Cell[CellGroupData[{
Cell[25801, 908, 106, 3, 70, "Input",
 CellID->156961754],
Cell[25910, 913, 160, 5, 36, "Output",
 CellID->1442837904]
}, Open  ]],
Cell[26085, 921, 125, 3, 70, "ExampleDelimiter",
 CellID->124705484],
Cell[26213, 926, 668, 26, 70, "ExampleText",
 CellID->68549989],
Cell[CellGroupData[{
Cell[26906, 956, 301, 10, 70, "Input",
 CellID->80051438],
Cell[27210, 968, 159, 5, 36, "Output",
 CellID->391310604]
}, Open  ]],
Cell[CellGroupData[{
Cell[27406, 978, 105, 3, 70, "Input",
 CellID->548372406],
Cell[27514, 983, 160, 5, 36, "Output",
 CellID->1162394314]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27723, 994, 226, 7, 70, "ExampleSection",
 CellID->15992],
Cell[27952, 1003, 274, 8, 70, "ExampleText",
 CellID->58909578],
Cell[CellGroupData[{
Cell[28251, 1015, 200, 6, 70, "Input",
 CellID->293651853],
Cell[28454, 1023, 249, 8, 36, "Output",
 CellID->702498639]
}, Open  ]],
Cell[28718, 1034, 60, 1, 70, "ExampleText",
 CellID->114954886],
Cell[CellGroupData[{
Cell[28803, 1039, 288, 9, 70, "Input",
 CellID->787701598],
Cell[29094, 1050, 660, 19, 36, "Output",
 CellID->29534467]
}, Open  ]],
Cell[CellGroupData[{
Cell[29791, 1074, 128, 4, 70, "Input",
 CellID->151124722],
Cell[29922, 1080, 351, 10, 36, "Output",
 CellID->317064412]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30334, 1097, 311, 9, 70, "SeeAlsoSection",
 CellID->22060],
Cell[30648, 1108, 961, 35, 70, "SeeAlso",
 CellID->20610]
}, Open  ]],
Cell[CellGroupData[{
Cell[31646, 1148, 313, 9, 70, "TutorialsSection",
 CellID->8961],
Cell[31962, 1159, 198, 4, 70, "Tutorials",
 CellID->17318]
}, Open  ]],
Cell[CellGroupData[{
Cell[32197, 1168, 320, 9, 70, "RelatedLinksSection",
 CellID->6043],
Cell[32520, 1179, 361, 12, 70, "RelatedLinks"],
Cell[32884, 1193, 179, 4, 70, "RelatedLinks"],
Cell[33066, 1199, 202, 4, 70, "RelatedLinks"],
Cell[33271, 1205, 386, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33694, 1223, 319, 9, 70, "MoreAboutSection",
 CellID->401740038],
Cell[34016, 1234, 144, 3, 70, "MoreAbout",
 CellID->53446554],
Cell[34163, 1239, 161, 3, 70, "MoreAbout",
 CellID->37905770],
Cell[34327, 1244, 137, 3, 70, "MoreAbout",
 CellID->402701209]
}, Open  ]],
Cell[34479, 1250, 27, 0, 70, "History"],
Cell[34509, 1252, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

