(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    162904,       3547]
NotebookOptionsPosition[    154790,       3270]
NotebookOutlinePosition[    156314,       3311]
CellTagsIndexPosition[    156227,       3306]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CreateDocument" :> 
          Documentation`HelpLookup["paclet:ref/CreateDocument"], 
          "PaletteNotebook" :> 
          Documentation`HelpLookup["paclet:ref/PaletteNotebook"], 
          "DialogNotebook" :> 
          Documentation`HelpLookup["paclet:ref/DialogNotebook"], 
          "CreateWindow" :> 
          Documentation`HelpLookup["paclet:ref/CreateWindow"], "Export" :> 
          Documentation`HelpLookup["paclet:ref/Export"], "Notebook" :> 
          Documentation`HelpLookup["paclet:ref/Notebook"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CreateDocument\"\>", 
       2->"\<\"PaletteNotebook\"\>", 3->"\<\"DialogNotebook\"\>", 
       4->"\<\"CreateWindow\"\>", 5->"\<\"Export\"\>", 
       6->"\<\"Notebook\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Document Generation" :> 
          Documentation`HelpLookup["paclet:guide/DocumentGeneration"], 
          "New in 6.0: Notebooks & Documents" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NotebooksAndDocuments"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Document Generation\"\>", 
       2->"\<\"New in 6.0: Notebooks & Documents\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["DocumentNotebook", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DocumentNotebook",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DocumentNotebook"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["cell", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["cell", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a complete document notebook in the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " front end. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19942]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CreateWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreateWindow"]], "InlineFormula"],
 " takes a ",
 Cell[BoxData[
  ButtonBox["DocumentNotebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DocumentNotebook"]], "InlineFormula"],
 " expression and displays it in a separate window."
}], "Notes",
 CellID->261149465],

Cell[TextData[{
 "If generated as output within a notebook, ",
 Cell[BoxData[
  ButtonBox["DocumentNotebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DocumentNotebook"]], "InlineFormula"],
 " displays as an in-cell representation of a notebook."
}], "Notes",
 CellID->264608945],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DocumentNotebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DocumentNotebook"]], "InlineFormula"],
 " can take any notebook option."
}], "Notes",
 CellID->208297439]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->291909234],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->264204688],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DocumentNotebook", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "+", "y"}], ",", 
    RowBox[{
     RowBox[{"1", "/", "x"}], "+", 
     RowBox[{"1", "/", "y"}]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->56057613],

Cell[BoxData[
 InterpretationBox[
  PanelBox[GridBox[{
     {
      TooltipBox[
       ButtonBox[
        DynamicBox[FEPrivate`FrontEndResource[
         "FEBitmaps", "ManipulatePasteIcon"],
         ImageSizeCache->{13., {4., 9.}}],
        BaseStyle->{},
        ButtonFrame->None,
        ButtonFunction:>FrontEndExecute[{
           FrontEnd`NotebookOpen[
            Notebook[{
              Cell[
               BoxData[
                FormBox[
                 RowBox[{"x", "+", "y"}], StandardForm]]], 
              Cell[
               BoxData[
                FormBox[
                 RowBox[{
                   FractionBox["1", "x"], "+", 
                   FractionBox["1", "y"]}], StandardForm]]]}]]}],
        Evaluator->None,
        Method->"Queued"],
       "Open this notebook in a new window"]},
     {GridBox[{
        {Cell[BoxData[
          RowBox[{"x", "+", "y"}]]]},
        {Cell[BoxData[
          RowBox[{
           FractionBox["1", "x"], "+", 
           FractionBox["1", "y"]}]]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxBackground->{
     "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {Inherited, {
         GrayLevel[1]}}, "RowsIndexed" -> {}}],
   BaseStyle->{}],
  DocumentNotebook[{$CellContext`x + $CellContext`y, $CellContext`x^(-1) + \
$CellContext`y^(-1)}]]], "Output",
 ImageSize->{59, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->223294064]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->46740633],

Cell["Specify styles for cells:", "ExampleText",
 CellID->7382880],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DocumentNotebook", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"TextCell", "[", 
     RowBox[{"\"\<The head\>\"", ",", "\"\<Section\>\""}], "]"}], ",", 
    RowBox[{"TextCell", "[", "\"\<first cell\>\"", "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18467],

Cell[BoxData[
 InterpretationBox[
  PanelBox[GridBox[{
     {
      TooltipBox[
       ButtonBox[
        DynamicBox[FEPrivate`FrontEndResource[
         "FEBitmaps", "ManipulatePasteIcon"],
         ImageSizeCache->{13., {4., 9.}}],
        BaseStyle->{},
        ButtonFrame->None,
        ButtonFunction:>FrontEndExecute[{
           FrontEnd`NotebookOpen[
            Notebook[{
              Cell["The head", "Section"], 
              Cell["first cell"]}]]}],
        Evaluator->None,
        Method->"Queued"],
       "Open this notebook in a new window"]},
     {GridBox[{
        {Cell["The head", "Section"]},
        {Cell["first cell"]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxBackground->{
     "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {Inherited, {
         GrayLevel[1]}}, "RowsIndexed" -> {}}],
   BaseStyle->{}],
  DocumentNotebook[{
    TextCell["The head", "Section"], 
    TextCell["first cell"]}]]], "Output",
 ImageSize->{110, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6334]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->681180700],

Cell["A notebook with a two-dimensional typeset expression:", "ExampleText",
 CellID->339165482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DocumentNotebook", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"TextCell", "[", 
     RowBox[{"\"\<S1\>\"", ",", "\"\<Section\>\""}], "]"}], ",", 
    RowBox[{"ExpressionCell", "[", 
     RowBox[{
      RowBox[{"x", "^", "2"}], ",", "\"\<Input\>\""}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->132857053],

Cell[BoxData[
 InterpretationBox[
  PanelBox[GridBox[{
     {
      TooltipBox[
       ButtonBox[
        DynamicBox[FEPrivate`FrontEndResource[
         "FEBitmaps", "ManipulatePasteIcon"],
         ImageSizeCache->{13., {4., 9.}}],
        ButtonFrame->None,
        ButtonFunction:>FrontEndExecute[{
           FrontEnd`NotebookOpen[
            Notebook[{
              Cell["S1", "Section"], 
              Cell[
               BoxData[
                FormBox[
                 SuperscriptBox["x", "2"], StandardForm]], "Input"]}]]}],
        DefaultBaseStyle->{},
        Evaluator->None,
        Method->"Queued"],
       "Open this notebook in a new window"]},
     {GridBox[{
        {Cell["S1", "Section"]},
        {Cell[BoxData[
          SuperscriptBox["x", "2"]], "Input"]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxBackground->{
     "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {Inherited, {
         GrayLevel[1]}}, "RowsIndexed" -> {}}],
   DefaultBaseStyle->{}],
  DocumentNotebook[{
    TextCell["S1", "Section"], 
    ExpressionCell[$CellContext`x^2, "Input"]}]]], "Output",
 ImageSize->{49, 81},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->749796]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->108652450],

Cell["A notebook with a graphic:", "ExampleText",
 CellID->673890765],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DocumentNotebook", "[", 
  RowBox[{"{", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], "}"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->140915099],

Cell[BoxData[
 InterpretationBox[
  PanelBox[GridBox[{
     {
      TooltipBox[
       ButtonBox[
        DynamicBox[FEPrivate`FrontEndResource[
         "FEBitmaps", "ManipulatePasteIcon"],
         ImageSizeCache->{13., {4., 9.}}],
        ButtonFrame->None,
        ButtonFunction:>FrontEndExecute[{
           FrontEnd`NotebookOpen[
            Notebook[{
              Cell[
               BoxData[
                FormBox[
                 GraphicsBox[{{{}, {}, {
                    Hue[0.67, 0.6, 0.6], 
                    LineBox[CompressedData["
1:eJw1mHc8Ff73x83I5pP6KHysxCUrKZV7KEk+IZKIrEJRkr3pkoyMkL1HRuZF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                    "]]}}}, {
                  AspectRatio -> NCache[GoldenRatio^(-1), 0.6180339887498948],
                    Axes -> True, AxesOrigin -> {0, 0}, 
                   PlotRange -> {{-1, 1}, {0., 0.9999999183673486}}, 
                   PlotRangeClipping -> True, PlotRangePadding -> {
                    Scaled[0.02], 
                    Scaled[0.02]}}], StandardForm]]]}]]}],
        DefaultBaseStyle->{},
        Evaluator->None,
        Method->"Queued"],
       "Open this notebook in a new window"]},
     {GridBox[{
        {Cell[BoxData[
          GraphicsBox[{{}, {}, 
            {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw1mHc8Ff73x83I5pP6KHysxCUrKZV7KEk+IZKIrEJRkr3pkoyMkL1HRuZF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              "]]}},
           AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
           Axes->True,
           AxesOrigin->{0, 0},
           PlotRange->{{-1, 1}, {0., 0.9999999183673486}},
           PlotRangeClipping->True,
           PlotRangePadding->{
             Scaled[0.02], 
             Scaled[0.02]}]]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxBackground->{
     "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {Inherited, {
         GrayLevel[1]}}, "RowsIndexed" -> {}}],
   DefaultBaseStyle->{}],
  DocumentNotebook[{
    Graphics[{{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Line[CompressedData["
1:eJw1mHc8Ff73x83I5pP6KHysxCUrKZV7KEk+IZKIrEJRkr3pkoyMkL1HRuZF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         "]]}}}, {
     AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
      PlotRange -> {{-1, 1}, {0., 0.9999999183673486}}, PlotRangeClipping -> 
      True, PlotRangePadding -> {
        Scaled[0.02], 
        Scaled[0.02]}}]}]]], "Output",
 ImageSize->{206, 165},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->147745344]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->75487687],

Cell["A notebook with a grid:", "ExampleText",
 CellID->195972657],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DocumentNotebook", "[", 
  RowBox[{"{", 
   RowBox[{"Grid", "[", 
    RowBox[{"Array", "[", 
     RowBox[{"a", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}], "}"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->250450915],

Cell[BoxData[
 InterpretationBox[
  PanelBox[GridBox[{
     {
      TooltipBox[
       ButtonBox[
        DynamicBox[FEPrivate`FrontEndResource[
         "FEBitmaps", "ManipulatePasteIcon"],
         ImageSizeCache->{13., {4., 9.}}],
        ButtonFrame->None,
        ButtonFunction:>FrontEndExecute[{
           FrontEnd`NotebookOpen[
            Notebook[{
              Cell[
               BoxData[
                FormBox[
                 TagBox[
                  GridBox[{{
                    RowBox[{"a", "[", 
                    RowBox[{"1", ",", "1"}], "]"}], 
                    RowBox[{"a", "[", 
                    RowBox[{"1", ",", "2"}], "]"}], 
                    RowBox[{"a", "[", 
                    RowBox[{"1", ",", "3"}], "]"}]}, {
                    RowBox[{"a", "[", 
                    RowBox[{"2", ",", "1"}], "]"}], 
                    RowBox[{"a", "[", 
                    RowBox[{"2", ",", "2"}], "]"}], 
                    RowBox[{"a", "[", 
                    RowBox[{"2", ",", "3"}], "]"}]}}], "Grid"], 
                 StandardForm]]]}]]}],
        DefaultBaseStyle->{},
        Evaluator->None,
        Method->"Queued"],
       "Open this notebook in a new window"]},
     {GridBox[{
        {Cell[BoxData[
          TagBox[GridBox[{
             {
              RowBox[{"a", "[", 
               RowBox[{"1", ",", "1"}], "]"}], 
              RowBox[{"a", "[", 
               RowBox[{"1", ",", "2"}], "]"}], 
              RowBox[{"a", "[", 
               RowBox[{"1", ",", "3"}], "]"}]},
             {
              RowBox[{"a", "[", 
               RowBox[{"2", ",", "1"}], "]"}], 
              RowBox[{"a", "[", 
               RowBox[{"2", ",", "2"}], "]"}], 
              RowBox[{"a", "[", 
               RowBox[{"2", ",", "3"}], "]"}]}
            }],
           "Grid"]]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxBackground->{
     "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {Inherited, {
         GrayLevel[1]}}, "RowsIndexed" -> {}}],
   DefaultBaseStyle->{}],
  DocumentNotebook[{
    Grid[{{
       $CellContext`a[1, 1], 
       $CellContext`a[1, 2], 
       $CellContext`a[1, 3]}, {
       $CellContext`a[2, 1], 
       $CellContext`a[2, 2], 
       $CellContext`a[2, 3]}}]}]]], "Output",
 ImageSize->{183, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->189665355]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->118178494],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->224578665],

Cell["Set a background color:", "ExampleText",
 CellID->82889571],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateWindow", "[", 
   RowBox[{"DocumentNotebook", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"Background", "\[Rule]", 
      RowBox[{"RGBColor", "[", 
       RowBox[{"1", ",", ".9", ",", ".7"}], "]"}]}]}], "]"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->522940521],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3etPFFccxnGavm/8F/qv9PJW28akSZtUMAXUxjT28rYvTNVWalO8gCBQ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   "], {{0, 0}, {458, 80}}, {0, 255}],
  ImageSize->{458 0.75, 80 0.75},
  PlotRange->{{0, 458}, {0, 80}}]], "NotebookImage",
 CellID->561246926]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "CellDingbat",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->47814540],

Cell["Set a cell dingbat:", "ExampleText",
 CellID->518136766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateWindow", "[", 
   RowBox[{"DocumentNotebook", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"CellDingbat", "\[Rule]", "\"\<\[MathematicaIcon]\>\""}]}], 
    "]"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->213796355],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVtPVFcYhml63/Qv9K/0cCtp441t0oqpqG2MselFkya9MLUn26aeQBRQ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   "], {{0, 0}, {458, 79}}, {0, 255}],
  ImageSize->{458 0.75, 79 0.75},
  PlotRange->{{0, 458}, {0, 79}}]], "NotebookImage",
 CellID->246099541]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "CellGrouping",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->346566584],

Cell["Make a document with manually grouped cells:", "ExampleText",
 CellID->555911444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateWindow", "[", 
   RowBox[{"DocumentNotebook", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"CellGroup", "[", 
        RowBox[{"{", 
         RowBox[{"a", ",", "b"}], "}"}], "]"}], ",", "c"}], "}"}], ",", 
     RowBox[{"CellGrouping", "\[Rule]", "Manual"}]}], "]"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49046929],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3d1PFFccxnGa3jf+C/1X+nKrqfGmNaliCmobY2x60aRJL0zVVmtT38AX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   "], {{0, 0}, {458, 101}}, {0, 255}],
  ImageSize->{458 0.75, 101 0.75},
  PlotRange->{{0, 458}, {0, 101}}]], "NotebookImage",
 CellID->344828343]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TextAlignment",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->803896],

Cell["Align contents on the right:", "ExampleText",
 CellID->147918168],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateWindow", "[", 
   RowBox[{"DocumentNotebook", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"TextAlignment", "\[Rule]", "Right"}]}], "]"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->450162015],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3dtPlEccxnGa3jf+C/1XerjVtPWmbVLBVLRtjLHpRZMmvTBVW6lNPYEH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   "], {{0, 0}, {458, 83}}, {0, 255}],
  ImageSize->{458 0.75, 83 0.75},
  PlotRange->{{0, 458}, {0, 83}}]], "NotebookImage",
 CellID->135921978]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Visible",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->98180737],

Cell["Create a notebook that is not visible:", "ExampleText",
 CellID->54936393],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateWindow", "[", 
    RowBox[{"DocumentNotebook", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", 
      RowBox[{"Visible", "\[Rule]", "False"}]}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->698794166],

Cell["Make the notebook appear:", "ExampleText",
 CellID->143624510],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{"nb", ",", 
   RowBox[{"Visible", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->113871627],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3etPFFccxnGavm/8F/qv9PJWU9M3bZMKpoC2McamL5o06QtTtZXaFC8g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   "], {{0, 0}, {458, 82}}, {0, 255}],
  ImageSize->{458 0.75, 82 0.75},
  PlotRange->{{0, 458}, {0, 82}}]], "NotebookImage",
 CellID->43159920]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->773900122],

Cell["Define a template for a standard document:", "ExampleText",
 CellID->114403074],

Cell[BoxData[
 RowBox[{
  RowBox[{"mammalPage", "[", 
   RowBox[{
   "common_", ",", "picture_", ",", "order_", ",", "family_", ",", 
    "species_"}], "]"}], ":=", 
  RowBox[{"DocumentNotebook", "[", 
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"Grid", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"common", ",", 
             RowBox[{"FontSize", "\[Rule]", "18"}]}], "]"}], ",", 
           "SpanFromLeft"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"picture", ",", 
           RowBox[{"Column", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Row", "[", 
               RowBox[{"{", 
                RowBox[{"#1", ",", "\"\<: \>\"", ",", " ", 
                 RowBox[{"Style", "[", 
                  RowBox[{"#2", ",", 
                   RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]}], 
                "}"}], "]"}], "&"}], "@@@", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"\"\<Order\>\"", ",", "order"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"\"\<Family\>\"", ",", "family"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"\"\<Species\>\"", ",", "species"}], "}"}]}], "}"}]}],
             "]"}]}], "}"}]}], "}"}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
     RowBox[{"ShowStringCharacters", "\[Rule]", "False"}]}], "]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->560716824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateWindow", "[", 
   RowBox[{"mammalPage", "[", 
    RowBox[{"\"\<Ocelot\>\"", ",", 
     RowBox[{"Import", "[", "\"\<ExampleData/ocelot.jpg\>\"", "]"}], ",", 
     "\"\<Carnivora\>\"", ",", "\"\<Felidae\>\"", ",", 
     "\"\<Leopardus pardalis\>\""}], "]"}], "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->59601917],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzs3QfYbkV56H1r9GgSTTyxa7BEYzcqdpEiinRUBBVRwIJSNiBdNh1rJIlR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   "], {{0, 0}, {458, 272}}, {0, 255}],
  ImageSize->{458 0.75, 272 0.75},
  PlotRange->{{0, 458}, {0, 272}}]], "NotebookImage",
 CellID->430811653]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->121917827],

Cell["Turn a list structure into document structure:", "ExampleText",
 CellID->8301637],

Cell[BoxData[
 RowBox[{
  RowBox[{"outline", "[", "l_List", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"l", "//.", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"s_String", ",", "r___"}], "}"}], "\[RuleDelayed]", 
      RowBox[{"f", "[", 
       RowBox[{"s", ",", "r"}], "]"}]}]}], "/.", 
    RowBox[{"s_String", "\[RuleDelayed]", 
     RowBox[{"TextCell", "[", "s", "]"}]}]}], "//.", 
   RowBox[{
    RowBox[{"f", "[", "c__", "]"}], "\[RuleDelayed]", 
    RowBox[{"CellGroup", "[", 
     RowBox[{"{", "c", "}"}], "]"}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->71457598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"outline", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<Chap. 1\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Sec. 1\>\"", ",", "\"\<a\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Sec. 2\>\"", ",", "\"\<b\>\"", ",", "\"\<c\>\""}], "}"}]}],
     "}"}], "]"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->419597453],

Cell["\<\
CellGroup[{TextCell[\"Chap. 1\"], CellGroup[{TextCell[\"Sec. 1\"], 
    TextCell[\"a\"]}], CellGroup[{TextCell[\"Sec. 2\"], TextCell[\"b\"], 
    TextCell[\"c\"]}]}]\
\>", "Output",
 ImageSize->{469, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->306944815]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateWindow", "[", 
   RowBox[{"DocumentNotebook", "[", 
    RowBox[{"%", ",", 
     RowBox[{"CellGrouping", "\[Rule]", "Manual"}]}], "]"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->215604073],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3etzFeUdB3A6fd/xX+i/0stbnTq+aZ2p4BTQdhynnb7rTF84VVupneIF
RAGVAgqiCFREbAC5hCRguAQkRBLaEJ2C4IVpGCnQ7Z7sOZs9e06Sczjn2Zwk
n8/8zDy/Z59d4pvvbPZcnu8//Pj9D3930aJF2+P/+r6zaFFpvGzZ75VSSoWo
W7fvKKWUamOl6frmlg+VUkq1pXLpOuu30EopNQ+qbrpGALRgWeVZq3QFaCPp
ChCCdAUIQboChCBdAUKQrgAhSFeAEKQrQAjSFSAE6QoQgnQFCEG6AoQgXQFC
kK4AIUhXgJzf/m7Xj+9dk9RPfvpqs5MJ6QowjTg2725SugJMo7B0XTSh9V8Y
YE4oJl3TXBWwwAJRcLoCLBDSFSAETwYAQij4VS3pCiwQ3pEFEIJ0BQhBugKE
IF0B2mjyCwTuk64A7efeFaBdst989cjj22oXSFeAEKQrQAjSFSAE6QoQwv0P
vj7jpHQFaJZ7V4AQpCtACNIVIATpCnAXptlHOyFdAVrkk7AAIdibACCE4nct
FLDAQiBdAUKQrgAhFJauNt0GFpQi7129qgUsHMU/GQBYCKQrQAjSFSAEn9UC
aCM7bgME5d4VoF3suA0wK6QrQAjSFSAE6QoQgh23AUJw7woQgnQFCEG6AoQg
XQHugh23AULzSViAEIrc+SW3N8GM7VRX8H2GQOebrV0Lc9tsNbLrlp25gDmk
+CcDuTjNTjZ4LkDnm8V0zf6Z33hsClhgTigyXevuu934k4HsdWZcAzC7CkvX
2kis+6qWdAXmh7m4a6F0BTrfbL1noFmtXwGgSEU+GWjx3are7ArMIT6rBdBG
dtwGCMq9K0C71N1xu9ltuKUrQFtIV4AQpCtACNIVIAQ7bgOE4N4VIATpChCC
dAUIQboCTK/ujtvNbsMtXQGm4ZOwACHMoW8gBJhDCv72bNEKLBDSFSCE4p8M
tP47A3Q+964AIRR879r6LwwwJ3hHFkAI0hUgBOkKEIJ0BWgjO24DBOXeFaBd
mt1cu+6kdAVolnQFCEG6AoQgXQFCyG2uXXdSugI0y70rQAjSFSAE6QoQgnQF
uAvNbq5dd1K6AkzDJ2EBQihs55fafbVmbKe6SAP/WwCzrOB9tdJxbqetBjfe
Eq3AXFH8k4FcnGYnGzwXoPPNYrpm/9KXrsA8U2S6Zp+aejIAzG9F7rhdO1P7
qpZ0BeaH4l/VaoV0BeaK2XrPwF3wdixgDinyyUDrb1iVrsBc4bNaAG1kx22A
oNy7ArRL3R23m92GW7oCtIV0BQhBugKEIF0BQrDjNkAI7l0BQpCuACFIV4AQ
ZiVd7aUFzHXNbsNd2L2raAXmjY76JKx0BeaNoDu/TLUfQW6Q23LLftzAPBB6
55e646k22Kq7G9eM/wRABypg55fGty9sfF8D6Qp0uCL31ZrqZlW6AvNPwema
e76aO8WTAWDeKP7etfalrty4kVespCvQ4WbluWvrpCvQ4Qp4z0Db09XbsYDO
V8D7XRv/e79x0hXocB31WS2Aua6pbbilK0Cz3LsCtEuz23BLV4AQpCtACNIV
IATpChBCNl1/9diK4Qv/3LGr55kVG5VSSrVYt/57q7vn3K9/s3LZY8/G6RrX
+fMjSimlWqxsup4fvBRFd+7cua2UUqqV+t+d29l0/eTs6K1bt8dvfBvXjYkq
j8fjnzfTdny8vCCeTBen42zd0Gq12g5tm860l9ZuWffADzbf98NN9/2otuL5
+Gi8Jjnx229vjo/fTNP19KmL31wfv3rtm6vXvp74+U1l/HV+/GV2Qbo+nbxe
fVSr1Wo7qr2bTNv5wL23n38hem1DtH59nXptQ3w0XpOceO3L0ilpup44ceHz
f18bHfti9NLl791zT7ZGxy6Pjl0pjy9lx1fiyiz7ojK4ko6TdnI+s77u4skr
TyxOjiaD/FnVR7VarbahthRilycmk5nLlflKlQ9dLp1VucKny5dEu9+Ltm+d
sna/F69Jzr302ReXxq6m6Xrs+NCFi5+f//RSEl/xIKlKOzY5PzS5pjIYnVhc
XjNUdZHRbJu7eO5o3FYvKB3NLp7+qFar1c7YVgZjk5ND1W1pPJpZU7rC0LIl
0c4d0VtvlN90FQ+SStudO+I1E6eMDV0Y+3T48zRde3oHB85ePDUwnCRYPDg5
MJxt00G9yZG68yerL3Ky+uK1R09Wj5Oj2cXTH9VqtdoG21PV45oayZ4VD/Lp
GtuWGVfSNTnr9JnhM5/8K03XeHCsf7Dv43NJgvUeH+w5Nth7fLKtDM5lx+XB
x4O9x85NtsfSs871xeszbe4JQO3iZNxTvbKn9I9WHU2vHA+0Wq228bbv+GBc
vZWfvaX5wdL8ROIli9NMS68wtGxxtHN7tHVTqXI2vxptWh+9syVO197kmh8P
9p+8kKbrke6zh7sHDnUPJAkWDw4dGTjYfbrcHqmaz00enJg8dCRdfHpyvnsg
26YnHpxicXl85HR6brK4kaNarVbbQFueiceTM+X5cqWZll7h/C8eKuXqhlei
DS9Hr2e+b3D9qmjdC9Erz8UBe37pQ5VTTvf0De7/6FSSroe7z+47cCKuJMG6
PiqN933Un7TpfFrZxZWZ/twg13YdONFVfUpX6SL99S7enyxOjqbt9Ee1Wq22
gbY801Wer6rM+qorlNJ147pozcropZX5e9fnn42e+3O0bk2crul1Dnef+fvu
niRdDx05s2dv7wcf9iUJFg+SSto9Hx77oFR9H+zti8eldu+xzOKJQ6X5vomV
6Vn129zibJtesPZomr1TnavVarUztnsm5+tkWnK0NtPOL10crV9z+68r0ky9
+ZfJ8Y0/PR2tfnFo6eKJc/v27O07cPDkm1v3ldP18Jldu7vfe78nSbB4kFSu
zVX10aNpm5k/WttmKt/mLtjUUa1Wq22ynb6Opj9Lz11Xv3j96aeSOP3PH5+6
PlFJ+9WTT0YvvhCvSc/t2t+/dv2uSrqe3b7j6I5dPSEqScX2rlRKqcJq+JEl
0apVV5944qsn/1Bb8Xy0etXw8sXJ4nd39uz9x4mVz28tp+uhT7a9dfidt7uV
Ukrlqv/Rn0Uvr45Wx7WqTq1aFb289vgvf54sfntb9/u7+59ZsTFJ1wMHBja8
3rV5436llFK5emntlhNLHxx59OELy5fU1sgjS/qXL4nXJIs3/W3fu9t7pKtS
SrW3pKtSSoUo6aqUUiEql64HDw1s3ND1xub9SimlWqnNm/bt3DGZrpfGvhwe
uTI8clkppVSL9dlnX6fpqpRSqr0Vp+v/AfmqsNw=
   "], {{0, 0}, {458, 175}}, {0, 255}],
  ImageSize->{458 0.75, 175 0.75},
  PlotRange->{{0, 458}, {0, 175}}]], "NotebookImage",
 CellID->380582325]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->59996108],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["CreateWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreateWindow"]], "InlineFormula"],
 " to get a ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->95582197],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateWindow", "[", 
    RowBox[{"DocumentNotebook", "[", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->555501666],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3d1PFFccxnGa3jf+C/1X+nKraeNN26SCKaBtjLHpRZMmvTBVW6lN8QVE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   "], {{0, 0}, {458, 98}}, {0, 255}],
  ImageSize->{458 0.75, 98 0.75},
  PlotRange->{{0, 458}, {0, 98}}]], "NotebookImage",
 CellID->388012563]
}, Open  ]],

Cell[TextData[{
 "Use the ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 " in commands that act on the notebook:"
}], "ExampleText",
 CellID->656802484],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "Next", ",", "Cell"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->517890219],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3d1PVEccxvFtmvSmTWPSv8D0r+htX+5aTVtv2iYVbAHbxhibXjRp0gvj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   "], {{0, 0}, {458, 103}}, {0, 255}],
  ImageSize->{458 0.75, 103 0.75},
  PlotRange->{{0, 458}, {0, 103}}]], "NotebookImage",
 CellID->53620339]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookRead", "[", "nb", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->399145710],

Cell[BoxData[
 RowBox[{"Cell", "[", 
  RowBox[{"BoxData", "[", "\<\"a\"\>", "]"}], "]"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->22209929]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookDelete", "[", "nb", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->109649067],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3etPVEccxnGavm/8F/qv9PJW08Y3bZMKpoC2McamL5o06QtTtZXaFC8g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   "], {{0, 0}, {458, 103}}, {0, 255}],
  ImageSize->{458 0.75, 103 0.75},
  PlotRange->{{0, 458}, {0, 103}}]], "NotebookImage",
 CellID->635974527]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->652699660],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PaletteNotebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PaletteNotebook"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["DialogNotebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DialogNotebook"]], "InlineFormula"],
 " objects are mainly used as user-interface tools:"
}], "ExampleText",
 CellID->11954673],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PaletteNotebook", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<Square root\>\"", ",", 
    RowBox[{"Button", "[", 
     RowBox[{
      SqrtBox["\[Pi]"], ",", 
      RowBox[{"p", "=", 
       RowBox[{"N", "[", 
        SqrtBox["\[Pi]"], "]"}]}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->168656848],

Cell[BoxData[
 InterpretationBox[
  PanelBox[GridBox[{
     {
      TooltipBox[
       ButtonBox[
        DynamicBox[FEPrivate`FrontEndResource[
         "FEBitmaps", "ManipulatePasteIcon"],
         ImageSizeCache->{13., {4., 9.}}],
        ButtonFrame->None,
        ButtonFunction:>FrontEndExecute[{
           FrontEnd`NotebookOpen[
            Notebook[{
              Cell[
               BoxData[
                FormBox["\"Square root\"", StandardForm]]], 
              Cell[
               BoxData[
                FormBox[
                 ButtonBox[
                  SqrtBox["\[Pi]"], 
                  ButtonFunction :> ($CellContext`p = N[Pi^Rational[1, 2]]), 
                  Appearance -> Automatic, ButtonFrame -> "DialogBox", 
                  Evaluator -> Automatic, Method -> "Preemptive"], 
                 StandardForm]]]}, Active -> True, 
             CellMargins -> {{0, 0}, {0, 0}}, CellOpen -> True, 
             ClosingAutoSave -> False, ImageMargins -> {{0, 0}, {0, 0}}, 
             Magnification -> 1., 
             ScrollingOptions -> {"VerticalScrollRange" -> Fit}, 
             ShowCellBracket -> False, ShowCellLabel -> False, ShowCellTags -> 
             False, WindowClickSelect -> False, WindowElements -> {}, 
             WindowFloating -> True, WindowFrame -> "Palette", 
             WindowFrameElements -> "CloseBox", 
             WindowMargins -> {{Automatic, 0}, {Automatic, 0}}, WindowSize -> 
             All, WindowToolbars -> {}]]}],
        DefaultBaseStyle->{},
        Evaluator->None,
        Method->"Queued"],
       "Open this notebook in a new window"]},
     {GridBox[{
        {Cell[BoxData["\<\"Square root\"\>"]]},
        {Cell[BoxData[
          ButtonBox[
           SqrtBox["\[Pi]"],
           Appearance->Automatic,
           ButtonFrame->"DialogBox",
           ButtonFunction:>($CellContext`p = N[Pi^Rational[1, 2]]),
           Evaluator->Automatic,
           Method->"Preemptive"]]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxBackground->{
     "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {Inherited, {
         GrayLevel[1]}}, "RowsIndexed" -> {}}],
   DefaultBaseStyle->{}],
  PaletteNotebook[{"Square root", 
    Button[
    Pi^Rational[1, 2], $CellContext`p = N[Pi^Rational[1, 2]]]}]]], "Output",
 ImageSize->{103, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->111793638]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DialogNotebook", "[", 
  RowBox[{"{", 
   RowBox[{"TextCell", "[", 
    RowBox[{"Row", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<Your name:\>\"", ",", 
       RowBox[{"InputField", "[", "]"}]}], "}"}], "]"}], "]"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3322274],

Cell[BoxData[
 InterpretationBox[
  PanelBox[GridBox[{
     {
      TooltipBox[
       ButtonBox[
        DynamicBox[FEPrivate`FrontEndResource[
         "FEBitmaps", "ManipulatePasteIcon"],
         ImageSizeCache->{13., {4., 9.}}],
        ButtonFrame->None,
        ButtonFunction:>FrontEndExecute[{
           FrontEnd`NotebookOpen[
            Notebook[{
              Cell[
               TextData[{"Your name:", 
                 Cell[
                  BoxData[
                   FormBox[
                    TagBox[
                    DynamicModuleBox[{Typeset`i$$ = Null}, 
                    InputFieldBox[
                    Dynamic[Typeset`i$$]], DynamicModuleValues -> Automatic], 
                    InputField[
                    Setting[#]]& ], StandardForm]]]}]]}, Active -> True, 
             CellMargins -> {{8, 8}, {8, 8}}, ClosingAutoSave -> False, 
             Editable -> False, ImageMargins -> {{0, 0}, {0, 0}}, 
             Magnification -> 1., 
             PrivateNotebookOptions -> {"FileOutlineCache" -> False}, 
             Saveable -> False, 
             ScrollingOptions -> {"VerticalScrollRange" -> Fit}, Selectable -> 
             False, ShowCellBracket -> False, ShowCellLabel -> False, 
             ShowCellTags -> False, WindowElements -> {}, WindowFloating -> 
             False, WindowFrameElements -> "CloseBox", WindowSize -> All, 
             WindowToolbars -> {}]]}],
        DefaultBaseStyle->{},
        Evaluator->None,
        Method->"Queued"],
       "Open this notebook in a new window"]},
     {GridBox[{
        {Cell[TextData[{
          "Your name:",
          Cell[BoxData[
           TagBox[
            DynamicModuleBox[{Typeset`i$$ = Null}, 
             InputFieldBox[Dynamic[Typeset`i$$]],
             DynamicModuleValues:>{}],
            InputField[
             Setting[#]]& ]]]
         }]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxBackground->{
     "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {Inherited, {
         GrayLevel[1]}}, "RowsIndexed" -> {}}],
   DefaultBaseStyle->{}],
  DialogNotebook[{
    TextCell[
     Row[{"Your name:", 
       InputField[]}]]}]]], "Output",
 ImageSize->{358, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->319808140]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21654],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreateDocument",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateDocument"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PaletteNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PaletteNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DialogNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DialogNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreateWindow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateWindow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Notebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Notebook"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31474]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->55793773],

Cell[TextData[ButtonBox["Document Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentGeneration"]], "MoreAbout",
 CellID->535595479],

Cell[TextData[ButtonBox["New in 6.0: Notebooks & Documents",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NotebooksAndDocuments"]], "MoreAbout",
 CellID->81720909]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DocumentNotebook - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 51.0714458}", "context" -> "System`", 
    "keywords" -> {
     "in-cell notebook", "inline notebook", "notebook expression", 
      "generating documents", "document generation", "template documents", 
      "programmatically create documents", "report generation", 
      "document construction"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "DocumentNotebook[{cell_1, cell_2, ...}] represents a complete document \
notebook in the Mathematica front end. ", "synonyms" -> {"document notebook"},
     "title" -> "DocumentNotebook", "type" -> "Symbol", "uri" -> 
    "ref/DocumentNotebook"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6433, 195, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->291909234]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 156084, 3299}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1953, 45, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2576, 72, 1581, 37, 70, "ObjectNameGrid"],
Cell[4160, 111, 834, 26, 70, "Usage",
 CellID->19942]
}, Open  ]],
Cell[CellGroupData[{
Cell[5031, 142, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5509, 159, 377, 12, 70, "Notes",
 CellID->261149465],
Cell[5889, 173, 287, 8, 70, "Notes",
 CellID->264608945],
Cell[6179, 183, 217, 7, 70, "Notes",
 CellID->208297439]
}, Closed]],
Cell[CellGroupData[{
Cell[6433, 195, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->291909234],
Cell[CellGroupData[{
Cell[6818, 209, 148, 5, 70, "ExampleSection",
 CellID->264204688],
Cell[CellGroupData[{
Cell[6991, 218, 260, 9, 28, "Input",
 CellID->56057613],
Cell[7254, 229, 1711, 52, 104, "Output",
 CellID->223294064]
}, Open  ]],
Cell[8980, 284, 124, 3, 70, "ExampleDelimiter",
 CellID->46740633],
Cell[9107, 289, 66, 1, 70, "ExampleText",
 CellID->7382880],
Cell[CellGroupData[{
Cell[9198, 294, 304, 9, 70, "Input",
 CellID->18467],
Cell[9505, 305, 1328, 41, 70, "Output",
 CellID->6334]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10882, 352, 220, 7, 70, "ExampleSection",
 CellID->681180700],
Cell[11105, 361, 96, 1, 70, "ExampleText",
 CellID->339165482],
Cell[CellGroupData[{
Cell[11226, 366, 356, 11, 70, "Input",
 CellID->132857053],
Cell[11585, 379, 1489, 45, 70, "Output",
 CellID->749796]
}, Open  ]],
Cell[13089, 427, 125, 3, 70, "ExampleDelimiter",
 CellID->108652450],
Cell[13217, 432, 69, 1, 70, "ExampleText",
 CellID->673890765],
Cell[CellGroupData[{
Cell[13311, 437, 306, 11, 70, "Input",
 CellID->140915099],
Cell[13620, 450, 19756, 354, 70, "Output",
 CellID->147745344]
}, Open  ]],
Cell[33391, 807, 124, 3, 70, "ExampleDelimiter",
 CellID->75487687],
Cell[33518, 812, 66, 1, 70, "ExampleText",
 CellID->195972657],
Cell[CellGroupData[{
Cell[33609, 817, 284, 10, 70, "Input",
 CellID->250450915],
Cell[33896, 829, 2657, 78, 70, "Output",
 CellID->189665355]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[36602, 913, 222, 7, 70, "ExampleSection",
 CellID->118178494],
Cell[CellGroupData[{
Cell[36849, 924, 231, 7, 70, "ExampleSubsection",
 CellID->224578665],
Cell[37083, 933, 65, 1, 70, "ExampleText",
 CellID->82889571],
Cell[CellGroupData[{
Cell[37173, 938, 371, 12, 70, "Input",
 CellID->522940521],
Cell[37547, 952, 2479, 43, 70, "NotebookImage",
 CellID->561246926]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40075, 1001, 231, 7, 70, "ExampleSubsection",
 CellID->47814540],
Cell[40309, 1010, 62, 1, 70, "ExampleText",
 CellID->518136766],
Cell[CellGroupData[{
Cell[40396, 1015, 320, 10, 70, "Input",
 CellID->213796355],
Cell[40719, 1027, 2731, 47, 70, "NotebookImage",
 CellID->246099541]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[43499, 1080, 233, 7, 70, "ExampleSubsection",
 CellID->346566584],
Cell[43735, 1089, 87, 1, 70, "ExampleText",
 CellID->555911444],
Cell[CellGroupData[{
Cell[43847, 1094, 398, 13, 70, "Input",
 CellID->49046929],
Cell[44248, 1109, 2779, 48, 70, "NotebookImage",
 CellID->344828343]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[47076, 1163, 231, 7, 70, "ExampleSubsection",
 CellID->803896],
Cell[47310, 1172, 71, 1, 70, "ExampleText",
 CellID->147918168],
Cell[CellGroupData[{
Cell[47406, 1177, 299, 10, 70, "Input",
 CellID->450162015],
Cell[47708, 1189, 2552, 44, 70, "NotebookImage",
 CellID->135921978]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[50309, 1239, 227, 7, 70, "ExampleSubsection",
 CellID->98180737],
Cell[50539, 1248, 80, 1, 70, "ExampleText",
 CellID->54936393],
Cell[50622, 1251, 323, 11, 70, "Input",
 CellID->698794166],
Cell[50948, 1264, 68, 1, 70, "ExampleText",
 CellID->143624510],
Cell[CellGroupData[{
Cell[51041, 1269, 169, 5, 70, "Input",
 CellID->113871627],
Cell[51213, 1276, 2555, 44, 70, "NotebookImage",
 CellID->43159920]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[53829, 1327, 227, 7, 70, "ExampleSection",
 CellID->773900122],
Cell[54059, 1336, 85, 1, 70, "ExampleText",
 CellID->114403074],
Cell[54147, 1339, 1657, 45, 70, "Input",
 CellID->560716824],
Cell[CellGroupData[{
Cell[55829, 1388, 363, 9, 70, "Input",
 CellID->59601917],
Cell[56195, 1399, 74076, 1217, 70, "NotebookImage",
 CellID->430811653]
}, Open  ]],
Cell[130286, 2619, 125, 3, 70, "ExampleDelimiter",
 CellID->121917827],
Cell[130414, 2624, 87, 1, 70, "ExampleText",
 CellID->8301637],
Cell[130504, 2627, 588, 18, 70, "Input",
 CellID->71457598],
Cell[CellGroupData[{
Cell[131117, 2649, 379, 11, 70, "Input",
 CellID->419597453],
Cell[131499, 2662, 333, 9, 82, "Output",
 CellID->306944815]
}, Open  ]],
Cell[CellGroupData[{
Cell[131869, 2676, 246, 8, 70, "Input",
 CellID->215604073],
Cell[132118, 2686, 3539, 60, 70, "NotebookImage",
 CellID->380582325]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[135706, 2752, 236, 7, 70, "ExampleSection",
 CellID->59996108],
Cell[135945, 2761, 340, 13, 70, "ExampleText",
 CellID->95582197],
Cell[CellGroupData[{
Cell[136310, 2778, 262, 9, 70, "Input",
 CellID->555501666],
Cell[136575, 2789, 2678, 46, 70, "NotebookImage",
 CellID->388012563]
}, Open  ]],
Cell[139268, 2838, 240, 8, 70, "ExampleText",
 CellID->656802484],
Cell[CellGroupData[{
Cell[139533, 2850, 149, 4, 70, "Input",
 CellID->517890219],
Cell[139685, 2856, 2818, 48, 70, "NotebookImage",
 CellID->53620339]
}, Open  ]],
Cell[CellGroupData[{
Cell[142540, 2909, 109, 3, 70, "Input",
 CellID->399145710],
Cell[142652, 2914, 230, 7, 36, "Output",
 CellID->22209929]
}, Open  ]],
Cell[CellGroupData[{
Cell[142919, 2926, 111, 3, 70, "Input",
 CellID->109649067],
Cell[143033, 2931, 2673, 46, 70, "NotebookImage",
 CellID->635974527]
}, Open  ]],
Cell[145721, 2980, 125, 3, 70, "ExampleDelimiter",
 CellID->652699660],
Cell[145849, 2985, 380, 12, 70, "ExampleText",
 CellID->11954673],
Cell[CellGroupData[{
Cell[146254, 3001, 339, 11, 70, "Input",
 CellID->168656848],
Cell[146596, 3014, 2684, 68, 70, "Output",
 CellID->111793638]
}, Open  ]],
Cell[CellGroupData[{
Cell[149317, 3087, 309, 10, 70, "Input",
 CellID->3322274],
Cell[149629, 3099, 2559, 69, 70, "Output",
 CellID->319808140]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[152249, 3175, 311, 9, 70, "SeeAlsoSection",
 CellID->21654],
Cell[152563, 3186, 1473, 53, 70, "SeeAlso",
 CellID->31474]
}, Open  ]],
Cell[CellGroupData[{
Cell[154073, 3244, 318, 9, 70, "MoreAboutSection",
 CellID->55793773],
Cell[154394, 3255, 149, 3, 70, "MoreAbout",
 CellID->535595479],
Cell[154546, 3260, 172, 3, 70, "MoreAbout",
 CellID->81720909]
}, Open  ]],
Cell[154733, 3266, 27, 0, 70, "History"],
Cell[154763, 3268, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

