(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     60685,       2251]
NotebookOptionsPosition[     50376,       1889]
NotebookOutlinePosition[     51764,       1928]
CellTagsIndexPosition[     51678,       1923]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vectors and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/VectorsAndMatrices"], 
          "Multiplying Vectors and Matrices" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MultiplyingVectorsAndMatrices"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Vectors and Matrices\"\>", 
       2->"\<\"Multiplying Vectors and Matrices\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MatrixPower" :> 
          Documentation`HelpLookup["paclet:ref/MatrixPower"], "Cross" :> 
          Documentation`HelpLookup["paclet:ref/Cross"], "Norm" :> 
          Documentation`HelpLookup["paclet:ref/Norm"], "KroneckerProduct" :> 
          Documentation`HelpLookup["paclet:ref/KroneckerProduct"], "Inner" :> 
          Documentation`HelpLookup["paclet:ref/Inner"], "Outer" :> 
          Documentation`HelpLookup["paclet:ref/Outer"], "AffineTransform" :> 
          Documentation`HelpLookup["paclet:ref/AffineTransform"], 
          "NonCommutativeMultiply" :> 
          Documentation`HelpLookup["paclet:ref/NonCommutativeMultiply"], 
          "VectorAngle" :> Documentation`HelpLookup["paclet:ref/VectorAngle"],
           "Covariance" :> 
          Documentation`HelpLookup["paclet:ref/Covariance"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MatrixPower\"\>", 
       2->"\<\"Cross\"\>", 3->"\<\"Norm\"\>", 4->"\<\"KroneckerProduct\"\>", 
       5->"\<\"Inner\"\>", 6->"\<\"Outer\"\>", 7->"\<\"AffineTransform\"\>", 
       8->"\<\"NonCommutativeMultiply\"\>", 9->"\<\"VectorAngle\"\>", 
       10->"\<\"Covariance\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Matrix Operations" :> 
          Documentation`HelpLookup["paclet:guide/MatrixOperations"], 
          "Operations on Vectors" :> 
          Documentation`HelpLookup["paclet:guide/OperationsOnVectors"], 
          "Sparse Arrays" :> 
          Documentation`HelpLookup["paclet:guide/SparseArrays"], "Tensors" :> 
          Documentation`HelpLookup["paclet:guide/Tensors"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Matrices and Linear Algebra\"\>", 
       2->"\<\"Matrix Operations\"\>", 3->"\<\"Operations on Vectors\"\>", 
       4->"\<\"Sparse Arrays\"\>", 
       5->"\<\"Tensors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Dot ",
 StyleBox["(.)", "OperatorCharacter"]
}], "ObjectName",
 CellID->9554],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["a", "TI"], ".", 
       StyleBox["b", "TI"], ".", 
       StyleBox["c", "TI"]}]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Dot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Dot"], "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"], ",", 
        StyleBox["c", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]",
     "gives products of vectors, matrices and tensors. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28963]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"a", ".", "b"}], TraditionalForm]], "InlineMath"],
 " gives an explicit result when ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 " are lists with appropriate dimensions. It contracts the last index in ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " with the first index in ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->18799],

Cell[TextData[{
 "Various applications of ",
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 ": "
}], "Notes",
 CellID->29442],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["2", "TR"]]}], "}"}], ".", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["b", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["b", "TI"], 
        StyleBox["2", "TR"]]}], "}"}]}], Cell[
    "scalar product of vectors ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox[
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["2", "TR"]]}], "}"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["m", "TI"], 
           StyleBox["11", "TR"]], ",", 
          SubscriptBox[
           StyleBox["m", "TI"], 
           StyleBox["12", "TR"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["m", "TI"], 
           StyleBox["21", "TR"]], ",", 
          SubscriptBox[
           StyleBox["m", "TI"], 
           StyleBox["22", "TR"]]}], "}"}]}], "}"}]}],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]"},
   {Cell["      ", "TableRowIcon"], "", Cell[
    "product of a vector and a matrix ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox[
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["m", "TI"], 
           StyleBox["11", "TR"]], ",", 
          SubscriptBox[
           StyleBox["m", "TI"], 
           StyleBox["12", "TR"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["m", "TI"], 
           StyleBox["21", "TR"]], ",", 
          SubscriptBox[
           StyleBox["m", "TI"], 
           StyleBox["22", "TR"]]}], "}"}]}], "}"}], ".", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["2", "TR"]]}], "}"}]}],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]"},
   {Cell["      ", "TableRowIcon"], "", Cell[
    "product of a matrix and a vector ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox[
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["m", "TI"], 
           StyleBox["11", "TR"]], ",", 
          SubscriptBox[
           StyleBox["m", "TI"], 
           StyleBox["12", "TR"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["m", "TI"], 
           StyleBox["21", "TR"]], ",", 
          SubscriptBox[
           StyleBox["m", "TI"], 
           StyleBox["22", "TR"]]}], "}"}]}], "}"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["11", "TR"]], ",", 
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["12", "TR"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["21", "TR"]], ",", 
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["22", "TR"]]}], "}"}]}], "}"}]}],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]"},
   {Cell["      ", "TableRowIcon"], "", Cell[
    "product of two matrices ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, False, True, False, True, False, True}}}},
 CellID->28115],

Cell[TextData[{
 "The result of applying ",
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 " to two tensors ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["T", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["i", "1"], " ", 
       SubscriptBox["i", "2"]}], "..."}], " ", 
     SubscriptBox["i", "n"]}]], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["U", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["j", "1"], " ", 
       SubscriptBox["j", "2"]}], "..."}], " ", 
     SubscriptBox["j", "m"]}]], TraditionalForm]], "InlineMath"],
 " is the tensor ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderscriptBox["\[Sum]", "k",
     LimitsPositioning->True], " ", 
    RowBox[{
     SubscriptBox["T", 
      RowBox[{
       SubscriptBox["i", "1"], 
       SubscriptBox["i", "2"], "...", 
       SubscriptBox["i", 
        RowBox[{"n", "-", "1"}]], "k"}]], " ", 
     SubscriptBox["U", 
      RowBox[{"k", 
       SubscriptBox["j", "2"], "...", 
       SubscriptBox["j", "m"]}]]}]}], TraditionalForm]], "InlineMath"],
 ". Applying ",
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 " to a rank ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " tensor and a rank ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " tensor gives a rank ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "+", "n", "-", "2"}], TraditionalForm]], "InlineMath"],
 " tensor. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->311970608,
  ButtonNote->"311970608"]
}], "Notes",
 CellID->184025481],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 " can be used on ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects, returning a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " object when possible. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->60441903,
  ButtonNote->"60441903"]
}], "Notes",
 CellID->9954],

Cell[TextData[{
 "When its arguments are not lists or sparse arrays, ",
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 " remains unevaluated. It has the attribute ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18079]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->7070582],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->821226626],

Cell["Scalar product of vectors:", "ExampleText",
 CellID->517197648],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], " ", ".", " ", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->252651345],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "x"}], "+", 
  RowBox[{"b", " ", "y"}], "+", 
  RowBox[{"c", " ", "z"}]}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->126527441]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->117234303],

Cell["Products of matrices and vectors:", "ExampleText",
 CellID->190587092],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}], " ", ".", " ", 
  RowBox[{"{", 
   RowBox[{"x", ",", " ", "y"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->246009328],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", 
    RowBox[{"b", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"c", " ", "x"}], "+", 
    RowBox[{"d", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->81129031]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], " ", ".", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->240589143],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", 
    RowBox[{"c", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"d", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->200853172]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], " ", ".", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}], " ", ".", " ", 
  RowBox[{"{", 
   RowBox[{"r", ",", "s"}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->128018105],

Cell[BoxData[
 RowBox[{
  RowBox[{"r", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"a", " ", "x"}], "+", 
     RowBox[{"c", " ", "y"}]}], ")"}]}], "+", 
  RowBox[{"s", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"d", " ", "y"}]}], ")"}]}]}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->263810391]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->88772612],

Cell["Matrix product:", "ExampleText",
 CellID->423919133],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}], " ", ".", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"r", ",", "s"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "u"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->399756513],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", " ", "r"}], "+", 
      RowBox[{"b", " ", "t"}]}], ",", 
     RowBox[{
      RowBox[{"a", " ", "s"}], "+", 
      RowBox[{"b", " ", "u"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"c", " ", "r"}], "+", 
      RowBox[{"d", " ", "t"}]}], ",", 
     RowBox[{
      RowBox[{"c", " ", "s"}], "+", 
      RowBox[{"d", " ", "u"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{267, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->290511158]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10781],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " are 5\[Times]5 random matrices of zeros and ones:"
}], "ExampleText",
 CellID->826090865],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", " ", "=", " ", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", " ", "=", " ", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", " ", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->172026680],

Cell[TextData[{
 "Use exact arithmetic to find the matrix product of ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->426425331],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"a", ".", "b"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->378737485],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "3", "1", "0", "3"},
     {"2", "3", "1", "1", "3"},
     {"2", "3", "0", "1", "3"},
     {"1", "2", "1", "0", "2"},
     {"2", "2", "1", "0", "2"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{91, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->12521703]
}, Open  ]],

Cell["Use machine arithmetic:", "ExampleText",
 CellID->155440393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{
   RowBox[{"N", "[", "a", "]"}], ".", 
   RowBox[{"N", "[", "b", "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->55202422],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1.`", "3.`", "1.`", "0.`", "3.`"},
     {"2.`", "3.`", "1.`", "1.`", "3.`"},
     {"2.`", "3.`", "0.`", "1.`", "3.`"},
     {"1.`", "2.`", "1.`", "0.`", "2.`"},
     {"2.`", "2.`", "1.`", "0.`", "2.`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{126, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->469383133]
}, Open  ]],

Cell["Use higher-precision arithmetic:", "ExampleText",
 CellID->585219168],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"a", ",", " ", "20"}], "]"}], ".", 
   RowBox[{"N", "[", 
    RowBox[{"b", ",", " ", "20"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->190573384],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1.`19.69897000433602", "3.`19.69897000433602", "1.`19.69897000433602", 
      "0", "3.`19.69897000433602"},
     {"2.`19.69897000433602", "3.`19.69897000433602", "1.`19.69897000433602", 
      "1.`19.69897000433602", "3.`19.69897000433602"},
     {"2.`19.69897000433602", "3.`19.69897000433602", "0", 
      "1.`19.69897000433602", "3.`19.69897000433602"},
     {"1.`19.69897000433602", "2.`19.69897000433602", "1.`19.69897000433602", 
      "0", "2.`19.69897000433602"},
     {"2.`19.69897000433602", "2.`19.69897000433602", "1.`19.69897000433602", 
      "0", "2.`19.69897000433602"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{791, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->217959057]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->60441903],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", "a", "]"}], ".", 
  RowBox[{"SparseArray", "[", "b", "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->290048376],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "21", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 21, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->401383126]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->234737393],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "1", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "1", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "0", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "1", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "1", ",", "0", ",", "2"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{532, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->316960952]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->238575060],

Cell["\<\
Compute the matrix product of a random real and complex rectangular matrices:\
\
\>", "ExampleText",
 CellID->177609861],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", " ", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}]}], "]"}], ".", 
   RowBox[{"RandomComplex", "[", 
    RowBox[{
     RowBox[{"4", " ", "+", " ", 
      RowBox[{"5", " ", "I"}]}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->148267258],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"0.790050270869308`", "\[InvisibleSpace]", "+", 
       RowBox[{"7.1267264118485265`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{"2.717186272698517`", "\[InvisibleSpace]", "+", 
       RowBox[{"4.951343423129745`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{"4.419825081911801`", "\[InvisibleSpace]", "+", 
       RowBox[{"1.4694667103339865`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{"5.616520909614398`", "\[InvisibleSpace]", "+", 
       RowBox[{"1.3368717322685484`", " ", "\[ImaginaryI]"}]}]},
     {
      RowBox[{"1.3231213323803`", "\[InvisibleSpace]", "+", 
       RowBox[{"5.60334752968024`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{"1.9540200686898332`", "\[InvisibleSpace]", "+", 
       RowBox[{"5.118211305797642`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{"2.01811678501017`", "\[InvisibleSpace]", "+", 
       RowBox[{"2.8280868095982656`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{"3.8439299579487414`", "\[InvisibleSpace]", "+", 
       RowBox[{"2.3029129070916183`", " ", "\[ImaginaryI]"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{536, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->777125440]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17310],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " is a 2\[Times]3\[Times]4 tensor and ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " is a 4\[Times]5 random matrix:"
}], "ExampleText",
 CellID->51609467],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", " ", "=", " ", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"9", ",", " ", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "4"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", " ", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"9", ",", " ", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->669516617],

Cell[TextData[{
 "The result of applying ",
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 " to two tensors ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["T", 
    RowBox[{
     SubscriptBox["i", "1"], 
     SubscriptBox["i", "2"], "...", 
     SubscriptBox["i", "n"]}]], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["U", 
    RowBox[{
     SubscriptBox["j", "1"], 
     SubscriptBox["j", "2"], "...", 
     SubscriptBox["j", "m"]}]], TraditionalForm]], "InlineMath"],
 " is the tensor ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderscriptBox["\[Sum]", "k",
     LimitsPositioning->True], " ", 
    RowBox[{
     SubscriptBox["T", 
      RowBox[{
       SubscriptBox["i", "1"], 
       SubscriptBox["i", "2"], "...", 
       SubscriptBox["i", 
        RowBox[{"n", "-", "1"}]], "k"}]], " ", 
     SubscriptBox["U", 
      RowBox[{"k", 
       SubscriptBox["j", "2"], "...", 
       SubscriptBox["j", "m"]}]]}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->311970608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", 
       RowBox[{"[", 
        RowBox[{"i1", ",", " ", "i2", ",", " ", "k"}], "]"}], "]"}], " ", 
      RowBox[{"b", "[", 
       RowBox[{"[", 
        RowBox[{"k", ",", " ", "j2"}], "]"}], "]"}]}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"k", ",", " ", "4"}], "}"}]}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"i1", ",", " ", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", " ", "3"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"j2", ",", " ", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19413676],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"60", ",", "70", ",", "74", ",", "85", ",", "108"}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{"39", ",", "31", ",", "41", ",", "37", ",", "59"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"54", ",", "31", ",", "41", ",", "40", ",", "68"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "40", ",", "67", ",", "63", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"63", ",", "32", ",", "27", ",", "61", ",", "74"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"32", ",", "29", ",", "3", ",", "50", ",", "38"}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{448, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->502889008]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", ".", "b"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->427480902],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"60", ",", "70", ",", "74", ",", "85", ",", "108"}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{"39", ",", "31", ",", "41", ",", "37", ",", "59"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"54", ",", "31", ",", "41", ",", "40", ",", "68"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "40", ",", "67", ",", "63", ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"63", ",", "32", ",", "27", ",", "61", ",", "74"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"32", ",", "29", ",", "3", ",", "50", ",", "38"}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{448, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->81680627]
}, Open  ]],

Cell[TextData[{
 "Applying ",
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 " to a rank ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " tensor and a rank ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " tensor gives a rank ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "+", "m", "-", "2"}], TraditionalForm]], "InlineMath"],
 " tensor."
}], "ExampleText",
 CellID->167371185],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArrayDepth", "[", 
   RowBox[{"a", ".", "b"}], "]"}], " ", "\[Equal]", " ", 
  RowBox[{"3", " ", "+", " ", "2", " ", "-", " ", "2"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->885908866],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->307758488]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->289390508],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " is a random complex vector:"
}], "ExampleText",
 CellID->458115342],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", " ", "=", " ", 
  RowBox[{"RandomComplex", "[", 
   RowBox[{
    RowBox[{"1", " ", "+", " ", 
     RowBox[{"2", " ", "I"}]}], ",", " ", 
    RowBox[{"{", "3", "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->862877960],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.7349655919412494`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.31954214793326186`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.4434654937114302`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.018648631379648783`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.7658720467130224`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.29254926332428033`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{455, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->874526000]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Norm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Norm"], "[", 
   StyleBox["v", "TI"], "]"}]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Sqrt]", 
    RowBox[{"(", 
     RowBox[{"v", ".", 
      SuperscriptBox["v", "\[Conjugate]"]}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->158417559],

Cell[CellGroupData[{

Cell[BoxData[
 SqrtBox[
  RowBox[{"v", ".", 
   RowBox[{"Conjugate", "[", "v", "]"}]}]]], "Input",
 CellLabel->"In[2]:=",
 CellID->19084429],

Cell[BoxData[
 RowBox[{"1.229404768421037`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->236342314]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", "v", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->308986473],

Cell[BoxData["1.229404768421037`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->68713598]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->80744195],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " is a 3\[Times]3 matrix:"
}], "ExampleText",
 CellID->37961922],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->576883249],

Cell[TextData[{
 StyleBox["Compute the matrix product ", "ExampleText"],
 Cell[BoxData[
  FormBox[
   RowBox[{"a", ".", "a", ".", "a"}], TraditionalForm]], "InlineMath"],
 StyleBox[":", "ExampleText"]
}], "ExampleText",
 CellID->701429728],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"b", " ", "=", " ", 
  RowBox[{"Dot", "[", 
   RowBox[{"a", ",", "a", ",", "a"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->359744597],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->129045858]
}, Open  ]],

Cell[TextData[{
 "This is the same as ",
 Cell[BoxData[
  ButtonBox["MatrixPower",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPower"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->335748556],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPower", "[", 
  RowBox[{"a", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->40326806],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->31750567]
}, Open  ]],

Cell[TextData[{
 "This is equivalent to composing the action of ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " on a vector three times:"
}], "ExampleText",
 CellID->828193158],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"x", " ", "=", " ", 
     RowBox[{"a", ".", "x"}]}], ",", " ", 
    RowBox[{"{", "3", "}"}]}], "]"}], ";"}], "\n", "x"}], "Input",
 CellLabel->"In[4]:=",
 CellID->3690209],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"16", ",", "11", ",", "3"}], "}"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->535851651]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"b", ".", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->170879328],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"16", ",", "11", ",", "3"}], "}"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->615876396]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->554580082],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["Inner",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inner"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->219168728],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inner", "[", 
  RowBox[{"Times", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Plus"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->470263749],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "x"}], "+", 
  RowBox[{"b", " ", "y"}], "+", 
  RowBox[{"c", " ", "z"}]}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4289507]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1094629800],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "x"}], "+", 
  RowBox[{"b", " ", "y"}], "+", 
  RowBox[{"c", " ", "z"}]}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->54561284]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11119],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 " effectively treats vectors multiplied from the right as column vectors: "
}], "ExampleText",
 CellID->604780430],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "6"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->79247032],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", ".", 
  RowBox[{"{", 
   RowBox[{"1", ",", "1"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->538181367],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "7", ",", "11"}], "}"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->20062564]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", ".", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "1", "}"}], ",", 
    RowBox[{"{", "1", "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->680633972],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"{", "7", "}"}], ",", 
   RowBox[{"{", "11", "}"}]}], "}"}]], "Output",
 ImageSize->{111, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->36904323]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 " effectively treats vectors multiplied from the left as row vectors: "
}], "ExampleText",
 CellID->20183280],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", "1", ",", "1"}], "}"}], ".", "a"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->5038968],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"9", ",", "12"}], "}"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->40270845]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], "}"}], ".", "a"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->611091127],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"9", ",", "12"}], "}"}], "}"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->333878634]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->409460687],

Cell["\<\
To get an outer product, you need to form the inputs as matrices:\
\>", "ExampleText",
 CellID->511282955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "1", "}"}], ",", 
    RowBox[{"{", "2", "}"}], ",", 
    RowBox[{"{", "3", "}"}]}], "}"}], ".", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->390179790],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "10", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "15", ",", "18"}], "}"}]}], "}"}]], "Output",
 ImageSize->{248, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->441991053]
}, Open  ]],

Cell[TextData[{
 "Or you can use ",
 Cell[BoxData[
  ButtonBox["KroneckerProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/KroneckerProduct"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->193969932],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KroneckerProduct", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->49176080],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "10", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "15", ",", "18"}], "}"}]}], "}"}]], "Output",
 ImageSize->{248, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6506760]
}, Open  ]],

Cell[TextData[{
 "Or ",
 Cell[BoxData[
  ButtonBox["Outer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Outer"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->111206312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"Times", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->148094263],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "10", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "15", ",", "18"}], "}"}]}], "}"}]], "Output",
 ImageSize->{248, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->170423155]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20164],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MatrixPower",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MatrixPower"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cross",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cross"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Norm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Norm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["KroneckerProduct",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/KroneckerProduct"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inner",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inner"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Outer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Outer"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AffineTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AffineTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NonCommutativeMultiply",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NonCommutativeMultiply"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VectorAngle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VectorAngle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Covariance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Covariance"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3749]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19196],

Cell[TextData[ButtonBox["Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VectorsAndMatrices"]], "Tutorials",
 CellID->14040],

Cell[TextData[ButtonBox["Multiplying Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MultiplyingVectorsAndMatrices"]], "Tutorials",
 CellID->23906]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->649648313],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->283828819],

Cell[TextData[ButtonBox["Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixOperations"]], "MoreAbout",
 CellID->151526398],

Cell[TextData[ButtonBox["Operations on Vectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OperationsOnVectors"]], "MoreAbout",
 CellID->61399715],

Cell[TextData[ButtonBox["Sparse Arrays",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SparseArrays"]], "MoreAbout",
 CellID->117942624],

Cell[TextData[ButtonBox["Tensors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Tensors"]], "MoreAbout",
 CellID->58100926]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Dot (.) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 53.1652494}", "context" -> "System`", 
    "keywords" -> {
     "dot product", "inner products", "matrices", "matrix multiplication", 
      "matrix multiply", "matrix vector multiplication", "multiplication", 
      "scalar product", "tensors", "vectors"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "a.b.c or Dot[a, b, c] gives products of vectors, matrices and tensors. ",
     "synonyms" -> {"."}, "title" -> "Dot", "type" -> "Symbol", "uri" -> 
    "ref/Dot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[13212, 431, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->7070582]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 51536, 1916}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3457, 72, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4080, 99, 95, 4, 70, "ObjectName",
 CellID->9554],
Cell[4178, 105, 743, 25, 70, "Usage",
 CellID->28963]
}, Open  ]],
Cell[CellGroupData[{
Cell[4958, 135, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5436, 152, 546, 18, 70, "Notes",
 CellID->18799],
Cell[5985, 172, 188, 8, 70, "Notes",
 CellID->29442],
Cell[6176, 182, 4304, 140, 70, "2ColumnTableMod",
 CellID->28115],
Cell[10483, 324, 1723, 64, 70, "Notes",
 CellID->184025481],
Cell[12209, 390, 589, 21, 70, "Notes",
 CellID->9954],
Cell[12801, 413, 374, 13, 70, "Notes",
 CellID->18079]
}, Closed]],
Cell[CellGroupData[{
Cell[13212, 431, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->7070582],
Cell[CellGroupData[{
Cell[13595, 445, 148, 5, 70, "ExampleSection",
 CellID->821226626],
Cell[13746, 452, 69, 1, 70, "ExampleText",
 CellID->517197648],
Cell[CellGroupData[{
Cell[13840, 457, 216, 7, 28, "Input",
 CellID->252651345],
Cell[14059, 466, 259, 9, 36, "Output",
 CellID->126527441]
}, Open  ]],
Cell[14333, 478, 125, 3, 70, "ExampleDelimiter",
 CellID->117234303],
Cell[14461, 483, 76, 1, 70, "ExampleText",
 CellID->190587092],
Cell[CellGroupData[{
Cell[14562, 488, 303, 11, 70, "Input",
 CellID->246009328],
Cell[14868, 501, 351, 13, 36, "Output",
 CellID->81129031]
}, Open  ]],
Cell[CellGroupData[{
Cell[15256, 519, 298, 11, 70, "Input",
 CellID->240589143],
Cell[15557, 532, 352, 13, 36, "Output",
 CellID->200853172]
}, Open  ]],
Cell[CellGroupData[{
Cell[15946, 550, 365, 13, 70, "Input",
 CellID->128018105],
Cell[16314, 565, 429, 16, 36, "Output",
 CellID->263810391]
}, Open  ]],
Cell[16758, 584, 124, 3, 70, "ExampleDelimiter",
 CellID->88772612],
Cell[16885, 589, 58, 1, 70, "ExampleText",
 CellID->423919133],
Cell[CellGroupData[{
Cell[16968, 594, 400, 15, 70, "Input",
 CellID->399756513],
Cell[17371, 611, 622, 23, 36, "Output",
 CellID->290511158]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18042, 640, 216, 7, 70, "ExampleSection",
 CellID->10781],
Cell[18261, 649, 232, 8, 70, "ExampleText",
 CellID->826090865],
Cell[18496, 659, 426, 14, 70, "Input",
 CellID->172026680],
Cell[18925, 675, 239, 9, 70, "ExampleText",
 CellID->426425331],
Cell[CellGroupData[{
Cell[19189, 688, 129, 4, 70, "Input",
 CellID->378737485],
Cell[19321, 694, 850, 25, 108, "Output",
 CellID->12521703]
}, Open  ]],
Cell[20186, 722, 66, 1, 70, "ExampleText",
 CellID->155440393],
Cell[CellGroupData[{
Cell[20277, 727, 186, 6, 70, "Input",
 CellID->55202422],
Cell[20466, 735, 902, 25, 108, "Output",
 CellID->469383133]
}, Open  ]],
Cell[21383, 763, 75, 1, 70, "ExampleText",
 CellID->585219168],
Cell[CellGroupData[{
Cell[21483, 768, 249, 8, 70, "Input",
 CellID->190573384],
Cell[21735, 778, 1286, 30, 108, "Output",
 CellID->217959057]
}, Open  ]],
Cell[23036, 811, 248, 9, 70, "ExampleText",
 CellID->60441903],
Cell[CellGroupData[{
Cell[23309, 824, 168, 5, 70, "Input",
 CellID->290048376],
Cell[23480, 831, 481, 17, 36, "Output",
 CellID->401383126]
}, Open  ]],
Cell[CellGroupData[{
Cell[23998, 853, 102, 3, 70, "Input",
 CellID->234737393],
Cell[24103, 858, 632, 18, 36, "Output",
 CellID->316960952]
}, Open  ]],
Cell[24750, 879, 125, 3, 70, "ExampleDelimiter",
 CellID->238575060],
Cell[24878, 884, 130, 4, 70, "ExampleText",
 CellID->177609861],
Cell[CellGroupData[{
Cell[25033, 892, 437, 14, 70, "Input",
 CellID->148267258],
Cell[25473, 908, 1725, 38, 63, "Output",
 CellID->777125440]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27247, 952, 233, 7, 70, "ExampleSection",
 CellID->17310],
Cell[27483, 961, 244, 8, 70, "ExampleText",
 CellID->51609467],
Cell[27730, 971, 436, 14, 70, "Input",
 CellID->669516617],
Cell[28169, 987, 1144, 42, 70, "ExampleText",
 CellID->311970608],
Cell[CellGroupData[{
Cell[29338, 1033, 669, 21, 70, "Input",
 CellID->19413676],
Cell[30010, 1056, 877, 28, 54, "Output",
 CellID->502889008]
}, Open  ]],
Cell[CellGroupData[{
Cell[30924, 1089, 92, 3, 70, "Input",
 CellID->427480902],
Cell[31019, 1094, 876, 28, 54, "Output",
 CellID->81680627]
}, Open  ]],
Cell[31910, 1125, 467, 18, 70, "ExampleText",
 CellID->167371185],
Cell[CellGroupData[{
Cell[32402, 1147, 223, 6, 70, "Input",
 CellID->885908866],
Cell[32628, 1155, 161, 5, 36, "Output",
 CellID->307758488]
}, Open  ]],
Cell[32804, 1163, 125, 3, 70, "ExampleDelimiter",
 CellID->289390508],
Cell[32932, 1168, 143, 5, 70, "ExampleText",
 CellID->458115342],
Cell[CellGroupData[{
Cell[33100, 1177, 257, 8, 70, "Input",
 CellID->862877960],
Cell[33360, 1187, 575, 14, 36, "Output",
 CellID->874526000]
}, Open  ]],
Cell[33950, 1204, 421, 17, 70, "ExampleText",
 CellID->158417559],
Cell[CellGroupData[{
Cell[34396, 1225, 140, 5, 70, "Input",
 CellID->19084429],
Cell[34539, 1232, 255, 7, 36, "Output",
 CellID->236342314]
}, Open  ]],
Cell[CellGroupData[{
Cell[34831, 1244, 100, 3, 70, "Input",
 CellID->308986473],
Cell[34934, 1249, 174, 5, 36, "Output",
 CellID->68713598]
}, Open  ]],
Cell[35123, 1257, 124, 3, 70, "ExampleDelimiter",
 CellID->80744195],
Cell[35250, 1262, 138, 5, 70, "ExampleText",
 CellID->37961922],
Cell[35391, 1269, 368, 12, 70, "Input",
 CellID->576883249],
Cell[35762, 1283, 239, 7, 70, "ExampleText",
 CellID->701429728],
Cell[CellGroupData[{
Cell[36026, 1294, 166, 5, 70, "Input",
 CellID->359744597],
Cell[36195, 1301, 391, 13, 36, "Output",
 CellID->129045858]
}, Open  ]],
Cell[36601, 1317, 209, 8, 70, "ExampleText",
 CellID->335748556],
Cell[CellGroupData[{
Cell[36835, 1329, 129, 4, 70, "Input",
 CellID->40326806],
Cell[36967, 1335, 390, 13, 36, "Output",
 CellID->31750567]
}, Open  ]],
Cell[37372, 1351, 191, 6, 70, "ExampleText",
 CellID->828193158],
Cell[CellGroupData[{
Cell[37588, 1361, 362, 12, 70, "Input",
 CellID->3690209],
Cell[37953, 1375, 215, 7, 36, "Output",
 CellID->535851651]
}, Open  ]],
Cell[CellGroupData[{
Cell[38205, 1387, 149, 5, 70, "Input",
 CellID->170879328],
Cell[38357, 1394, 215, 7, 36, "Output",
 CellID->615876396]
}, Open  ]],
Cell[38587, 1404, 125, 3, 70, "ExampleDelimiter",
 CellID->554580082],
Cell[38715, 1409, 308, 12, 70, "ExampleText",
 CellID->219168728],
Cell[CellGroupData[{
Cell[39048, 1425, 269, 8, 70, "Input",
 CellID->470263749],
Cell[39320, 1435, 257, 9, 36, "Output",
 CellID->4289507]
}, Open  ]],
Cell[CellGroupData[{
Cell[39614, 1449, 241, 8, 70, "Input",
 CellID->1094629800],
Cell[39858, 1459, 258, 9, 36, "Output",
 CellID->54561284]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40165, 1474, 226, 7, 70, "ExampleSection",
 CellID->11119],
Cell[40394, 1483, 240, 7, 70, "ExampleText",
 CellID->604780430],
Cell[40637, 1492, 332, 12, 70, "Input",
 CellID->79247032],
Cell[CellGroupData[{
Cell[40994, 1508, 139, 5, 70, "Input",
 CellID->538181367],
Cell[41136, 1515, 213, 7, 36, "Output",
 CellID->20062564]
}, Open  ]],
Cell[CellGroupData[{
Cell[41386, 1527, 189, 7, 70, "Input",
 CellID->680633972],
Cell[41578, 1536, 286, 10, 36, "Output",
 CellID->36904323]
}, Open  ]],
Cell[41879, 1549, 235, 7, 70, "ExampleText",
 CellID->20183280],
Cell[CellGroupData[{
Cell[42139, 1560, 147, 5, 70, "Input",
 CellID->5038968],
Cell[42289, 1567, 203, 7, 36, "Output",
 CellID->40270845]
}, Open  ]],
Cell[CellGroupData[{
Cell[42529, 1579, 174, 6, 70, "Input",
 CellID->611091127],
Cell[42706, 1587, 228, 8, 36, "Output",
 CellID->333878634]
}, Open  ]],
Cell[42949, 1598, 125, 3, 70, "ExampleDelimiter",
 CellID->409460687],
Cell[43077, 1603, 116, 3, 70, "ExampleText",
 CellID->511282955],
Cell[CellGroupData[{
Cell[43218, 1610, 306, 11, 70, "Input",
 CellID->390179790],
Cell[43527, 1623, 396, 13, 36, "Output",
 CellID->441991053]
}, Open  ]],
Cell[43938, 1639, 214, 8, 70, "ExampleText",
 CellID->193969932],
Cell[CellGroupData[{
Cell[44177, 1651, 252, 8, 70, "Input",
 CellID->49176080],
Cell[44432, 1661, 394, 13, 36, "Output",
 CellID->6506760]
}, Open  ]],
Cell[44841, 1677, 180, 8, 70, "ExampleText",
 CellID->111206312],
Cell[CellGroupData[{
Cell[45046, 1689, 256, 8, 70, "Input",
 CellID->148094263],
Cell[45305, 1699, 396, 13, 36, "Output",
 CellID->170423155]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[45762, 1719, 311, 9, 70, "SeeAlsoSection",
 CellID->20164],
Cell[46076, 1730, 2458, 89, 70, "SeeAlso",
 CellID->3749]
}, Open  ]],
Cell[CellGroupData[{
Cell[48571, 1824, 314, 9, 70, "TutorialsSection",
 CellID->19196],
Cell[48888, 1835, 149, 3, 70, "Tutorials",
 CellID->14040],
Cell[49040, 1840, 172, 3, 70, "Tutorials",
 CellID->23906]
}, Open  ]],
Cell[CellGroupData[{
Cell[49249, 1848, 319, 9, 70, "MoreAboutSection",
 CellID->649648313],
Cell[49571, 1859, 163, 3, 70, "MoreAbout",
 CellID->283828819],
Cell[49737, 1864, 145, 3, 70, "MoreAbout",
 CellID->151526398],
Cell[49885, 1869, 151, 3, 70, "MoreAbout",
 CellID->61399715],
Cell[50039, 1874, 137, 3, 70, "MoreAbout",
 CellID->117942624],
Cell[50179, 1879, 125, 3, 70, "MoreAbout",
 CellID->58100926]
}, Open  ]],
Cell[50319, 1885, 27, 0, 70, "History"],
Cell[50349, 1887, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

