(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27049,        886]
NotebookOptionsPosition[     22217,        727]
NotebookOutlinePosition[     23750,        768]
CellTagsIndexPosition[     23665,        763]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dotted" :> Documentation`HelpLookup["paclet:ref/Dotted"], 
          "Dashed" :> Documentation`HelpLookup["paclet:ref/Dashed"], 
          "Dashing" :> Documentation`HelpLookup["paclet:ref/Dashing"], 
          "AbsoluteDashing" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteDashing"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Dotted\"\>", 2->"\<\"Dashed\"\>", 
       3->"\<\"Dashing\"\>", 
       4->"\<\"AbsoluteDashing\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Directives" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsDirectives"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Graphics Directives\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["DotDashed", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["DotDashed",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DotDashed"]], "InlineFormula"],
     " \[LineSeparator]is a graphics directive that specifies that lines \
which follow should be drawn dot-dashed."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->291626361],

Cell["Dot-dashed lines:", "ExampleText",
 CellID->568660478],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"DotDashed", ",", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->543815691],

Cell[BoxData[
 GraphicsBox[
  {Dashing[{0, Small, Small, Small}], LineBox[{{0, 0}, {2, 1}}]}]], "Output",
 ImageSize->{104, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->196978340]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"DotDashed", ",", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->494817468],

Cell[BoxData[
 Graphics3DBox[
  {Dashing[{0, Small, Small, Small}], 
   Line3DBox[{{0, 0, 0}, {2, 1, 1}}]}]], "Output",
 ImageSize->{104, 81},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->523225627,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydV21PE0EQ3vaOdyociAhJFQhERQkEQbGKIgK+hQ/+hAabwAejQf7+RW9n
n+1tnx17h03a3uw8+8zszM7c7nn35rL3o3tzddFd+Xjd/XV5dfF75ezndTGU
NIwx34vvt/umeP5TPMn3PM/zZq/XWyj+jfkKySTFQ/FvB++K5lPxmxQjCRBu
9BSjo1ZK3AQ7fV60x9BOqNojME1bKXVaB5gT/SFm37HSSF8PjkwwHWCyIZiD
0OOkjzFNksWO2QfjYgW6JehdoJdrobeBbpM2IVkiYrbg90ot9Ca410ibkjwl
6EdAb5B2hORJQW/Ak8e10Gvg3iTtKMmyK8xDoLdIO0byuKDb8GSnFnoZ3Lua
lmebRaD3NT95HVIVdvBVBbdDz8HvNxXcElEzA+63Wnw5t5J/O/i+FnoSnpyQ
dopk2WUSGTt4pvhtRedvCumzsnYrcjUk/VkyatyHZyd53FtyX1sDVWA5vvBs
6js0c6DfiKXCgw+wOP3veVGPcTVQTAb2sPhJfdca6nV/NNrHJZvvRmrNV7Kz
3IFvXC2ce52NO8kEouY7D7PUY7Xx678FgpWv50H3vzUrr3ALbLOwxqwNYeFs
8P5pkY9LAau2z9lX3QrXaUZWMrLCXbeeFUZlyF4LrLbnpErNsHc6O+/HdsCq
ZZGt6KwtkpeINfsvVvZlAWxoS8avx44tEJa7u25hRos1Mmdj7rvqEuF41+rs
s0qUwqi0FdZGIVo2nZHjaFfpe1gqkSl3YzV7dHakHhL6yueP0aFsnI2QaRqx
5ZPYyFDGe7nrB56FTyFp5WyusTKvZcy0KNRnHUMW9nj1t2LxkZeznHEnEu6j
FWzlOzMPT3jlOnlnhpwxn6XbJQatu4cMpcafv+QcE72VY7yvQd77B4jHxOAK
VZsteM0duAOOsDvoXkzm8Y3IPp5UzvQ9gzvtEUXQrq+peh/WXmzbMQS2o2xz
lzgbsGThvM+PEa8k8oUr+R1sjOVVNf8anO6u4VfLll/mwSksOrnwSvZg3d07
Obu8q3fA7W7MfDrl6D4DWnqCZLGp5OBJHvTu6D3GOd8Ap9wMozc019Aq0OuC
Zi3PfgBP5K4nlps+2gFqGZxPBcVvVH6P+WrfFjSvnSM4Dw+eC5qjz9nx55YX
gs7gr3ZGsqiOoOZJyz1hPA/uX657D3QG35HlxtU/PyQYPZXRRUhyqzGm8RdS
k0gW\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->255849672],

Cell["Dot-dashed frame:", "ExampleText",
 CellID->273114951],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", "DotDashed"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->340435630],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   ColumnsEqual->False,
   FrameStyle->Dashing[{0, Small, Small, Small}],
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{117, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143666869]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["EdgeForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeForm"]], "InlineFormula"],
 " to draw dot-dashed edges:"
}], "ExampleText",
 CellID->386942407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Pink", ",", 
    RowBox[{"EdgeForm", "[", "DotDashed", "]"}], ",", 
    RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->425061707],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], EdgeForm[Dashing[{0, Small, Small, Small}]], 
   RectangleBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->345854115]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"EdgeForm", "[", "DotDashed", "]"}], ",", 
     RowBox[{"Cuboid", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->913846666],

Cell[BoxData[
 Graphics3DBox[
  {EdgeForm[Dashing[{0, Small, Small, Small}]], CuboidBox[{0, 0, 0}]},
  Boxed->False]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->249551571,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy1V+tOE0EUXrrb7fZK6V0oUMWCEAFFBOSm8YcaCd7eoAETSDSYyn+fBR/J
99noOTMn0+FzhlQSG3rYznc53+xuuzPHg8uzz18Hl+cng97r4eDb2fnJ996r
iyENhRNBEJzS+0snoOPfdKTep2maEmDVF1RDgu6qT4dUo4vVH0GYXg1T9Qrm
FbLPlYmEKoKTtUs1ISRDQE+NbFHNkKyg+HTAkquh8DcFLTEajdAgmFP4BtXq
dYz+NPYIEk1CB84wq5hrVBuEZs3IivRtgYYn1FWMB8LoOBj6s573HcVepNoF
ZgTMjmLeh9QzoOKM04p5j2rPi85JvgViJDSqc3RltC+jdv+WYrB6mdA8oE2F
diDdEvRnz7ZisttDL1qTHOsOhs5RFcZjYHAunaVC9akDtVPXFLMEqTdBVaDS
UMwC1WcO1Pac8jKLVOoGtTtuAbNERWfLA3ObyiR0nPQyq8CsOJk7Dk8/kz2r
3o72LNjTnw2ZdvfSWCqcXVGpEkdmWzVFpWz8dx2o7VnwMmtUSqbjHqB1KqM8
+w6t3SVxJsf7hz11nhwwOVsLPHNeZpuY+Vv4HECexo0+t2fa3eN/9I+BidfF
73/omHt849z/Zsbicztmk0oy1ixGzCwwD+T62h2z/40Z22eG/9OLmTmnD38T
+WPm568UZ+NW8O9iAuyGl70h/gVStAwrAhY/U3g5UAFf/E5Gpgcr+FlTBwX+
VowUq3zGxmJzXZbcM6Rwp+Dal9zzxPJ72TPtSe6FsRVd61py/CWYQ4WKvn9D
UE7LHFbGVrQl3Tooyl5FUxRPSOH3rQprB3yLXkVZsu+BAp/soVNdEPVzUONa
Q6szoM6rM87SIOD6kgo//bOmVyz+bwgpXkMimemRIHa3zKhbJF9M9XoPKXN+
XagjseAjqGKniu+mT2MxY2G6uzPK8/oAXrgi1uwEsr5zqPTdzs9O9AwNWhQ0
a0ZK4HxMBTNMKCavlvjM4upeo7xaYu31HUpoMLvHkZUvMKwasN7aszBnou5k
pWaPpdPw6njUxUZ4Zc13GZ97fQba4HjIcwxkZab2LgfC1yuhGapbMjJlRvjT
mij16n0WfJd1UoY4kux1eI+3CEn17or3hnN8NQK9z5H9p+XYAce+Olyg2pR8
K2qE91NlcVpXI31wyoHThjpcUt8swxLPbYXZ++Ng4g8Vs60g\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->101466395],

Cell["A plot with dot-dashed line:", "ExampleText",
 CellID->77058257],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "DotDashed"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->325230780],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWG+IVFUUvzuz466uhdW4zUKlZJEfQoxto2gjKFLCwiw3F3dF10ncxTZj
277Uh/6iRC2UEdgGGVlB5QdDUQSDSJCESIiEqCAMwj4kQdKHBeH5O+eeM/e9
O2feNCMEDbsz97x3/v+7596Hx6bHt02OTU9Ux5aunhp7enyi+szSVTun8KjY
4Zw7jP8dFYd1ghX/H04S/Ka/u/BdxKsCQbRI+OMKWO5njO7oTZG+OgPsXCnC
mPWPi/6HPgUFW+IzSV+lc+f+/vij0/ve/xZ/p7/73S1vQStC8FxOffPbzBsn
Ahevzc8//Xnhwhwtb2zT1nGGwXFi/ODc3EW3gGGIOnv2r8vhO8Hw+fP/CLyi
Fi3y5bzUb5pqG8PeJFpeRXiff/b9Eqa+Vqg81tEjP24Y+oSWV7M2ULi69cDu
XV/BjOtr+GnuVYbhQNAhKq6s0p6dPvLSi8edTbWVYc8duK6XYQgRD12XQwUs
ic+AifWCRlHgSsbOLRobKEtL1q8IZQWumDw3M/zFwTNIGVreaWLNmk9fZvjM
D39AcVouNrFGFUs8sIxheBDOz1KRFaOaCevW7qfMvUk9s2nkU6jYQMYIwzuf
OoRw0fJmlQkulKdlk2ojwye+/hWEtLyFYe8uWl6TI8ubTMvBJh4jq3Zr5N7e
czKRTK2n2aC2S3XdqpIkNp5KqyLdYbTrxBUyrNko8L2My1iZeuyK6OLuZfc4
X8YpNiYfAl9jAGZIDlzZph5DGjFfBO62RLL3+eeO5fEtJXYHWa8eR42Dpetn
GKULEbS8Iodfmk8Me74I9rt7T9GyX/UG68BXI6m/MZfHNHrQjvJhIIrmwloW
EfWQ2iJv76+9bV7JMwx/efwXT+77eh3WOo0iCouWdzGMhitRbUIlWKsyWr9n
0rzJcOjsXSYW1SeB1BMoPGWB5yfZOu6J6BSvV3TgrimR6TYllSN4cQomBjF+
SWOx5sF9tAssjN7H+LwnzUtnmM/BoE1B7ExT9TaBOeuRhD3in4oltSstFSIl
12yPx36wIqIZrfbjOxMB8ldfU03wDc2Jtj1N4vc+IkhBpGsitVNwWd8Ses+/
ksZwpiM08kT8PI6hXTNp6rR2MZ5msP4GbgQ9xNhhp3ogka6EYYgNMGWvYRgz
HdpBoAq1aFPZfcV++o7GQrosT+Ps0w+cVU1107oFl2qwD4jXs1Uu/40UqfSw
Hwif/5MNLcIdZmR5L6A6QpL6jhdX2ooItvvzaoaRsOLPRwKWVCl2d2xBHi/s
kWtreH4fAJZMjHsDh+AvTBloH+l3oWfXSO9jGWFGedTihA/y3+/RdDapw228
N9o1VVSpsoPfk2Srdn0OFQ6cIn9Q/YO+TV4YMqm8hegQMt0ELNLavw2efNzk
4Sex0Jv43EETu3Qdm6qkWBLnPTm8wxT3Vg4Wdn7Z8e6IcmM4Y5U/08JgOU0N
qAyBh00ZPlbdSeOJ3b5N4D0vdzKOa2xBFO+ZFviEmQkOkxPKSvWOwCNt6jUY
xaIRH53QY3/czTAmfDmjjebQp+ninub54GAlmT6aiYxO4DGVn9twUJWJ9/VM
TvAUT10HZ1PKoPA2zcNj4bwr1cI3OqnM35xDhWxEzyHengrBgCsaU1EVFYC+
xXybPZPyzJU6TewyaRYpFgygJd3wFHDKrprYt2sWofZpdrOx+pUnugyd8Z8w
sfxO4I++tOSbE5rqpUMEKrKmrP5CNUO+ezWHJyRDP7pNeMXE8jMaEkW6TEV9
L+fw7SbVSuUttyHbM/rZvbxP/SVVtkhtFht3JJqlRGTdWsZ536fZJfsAn4g7
ASCJkabI4yeZ5/yIrv6OLq6FG1RXgbkjdvqbGewFaD2TbXLmm6oSdIS/ET74
ItxZIt7iz4JaJlStSCOEJcoP2YsiEv7Ye6WiptrUfvay6LQD6R3nh/y0/uba
dVwC+E8r4g==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->118034475]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DotDashed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DotDashed"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dashing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dashing"], "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", " ", 
     ButtonBox["Small",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Small"], ",", " ", 
     ButtonBox["Small",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Small"], ",", " ", 
     ButtonBox["Small",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Small"]}], "}"}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->18697713],

Cell[CellGroupData[{

Cell[BoxData["DotDashed"], "Input",
 CellLabel->"In[1]:=",
 CellID->297549763],

Cell[BoxData[
 RowBox[{"Dashing", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "Small", ",", "Small", ",", "Small"}], "}"}], 
  "]"}]], "Output",
 ImageSize->{227, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->85587994]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->256887701],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashing"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["AbsoluteDashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteDashing"]], "InlineFormula"],
 " provide richer specification of dashing: "
}], "ExampleText",
 CellID->3146420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Dashing", "[", 
       RowBox[{"{", 
        RowBox[{"r", ",", 
         RowBox[{"0.1", "-", "r"}]}], "}"}], "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.03", ",", "0.05", ",", "0.08"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->487066461],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Dashing[{0.01, 0.09000000000000001}], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Dashing[{0.03, 0.07}], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Dashing[{0.05, 0.05}], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Dashing[{0.08, 0.020000000000000004`}], LineBox[{{0, 0}, {2, 1}}]}]}], 
  "}"}]], "Output",
 ImageSize->{452, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->154933809]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"AbsoluteDashing", "[", 
       RowBox[{"{", 
        RowBox[{"d", ",", 
         RowBox[{"15", "-", "d"}]}], "}"}], "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"d", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5", ",", "8", ",", "12"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->302616010],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {AbsoluteDashing[{2, 13}], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {AbsoluteDashing[{5, 10}], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {AbsoluteDashing[{8, 7}], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {AbsoluteDashing[{12, 3}], LineBox[{{0, 0}, {2, 1}}]}]}], "}"}]], "Output",\

 ImageSize->{452, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->109723155]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->72811268],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DotDashed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DotDashed"]], "InlineFormula"],
 " is absolute dashing, independent of the image size:"
}], "ExampleText",
 CellID->72097842],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"DotDashed", ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "70", ",", "100"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->540741371],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Dashing[{0, Small, Small, Small}], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->50], ",", 
   GraphicsBox[
    {Dashing[{0, Small, Small, Small}], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->70], ",", 
   GraphicsBox[
    {Dashing[{0, Small, Small, Small}], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->100]}], "}"}]], "Output",
 ImageSize->{261, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->109341211]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dotted",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dotted"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dashed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dashed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dashing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dashing"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteDashing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteDashing"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->68866538],

Cell[TextData[ButtonBox["Graphics Directives",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsDirectives"]], "MoreAbout",
 CellID->286673708]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DotDashed - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 52.3527286}", "context" -> "System`", 
    "keywords" -> {
     "dot-dashed", "dot-dashed lines", "dot-dashed edges", 
      "dot-dashed 3D lines", "dot-dashed 2D lines", "dot-dashed grid lines", 
      "dot-dashed frame", "dot-dashed mesh", "dot-dashed contour", 
      "dot-dashed curve", "dot-dashed arrow", "dot-dashed grid", 
      "dot-dashed gridlines"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "DotDashed is a graphics directive that specifies that lines which follow \
should be drawn dot-dashed.", "synonyms" -> {"dot dashed"}, "title" -> 
    "DotDashed", "type" -> "Symbol", "uri" -> "ref/DotDashed"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4181, 120, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 23530, 756}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1462, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2085, 62, 1574, 37, 70, "ObjectNameGrid"],
Cell[3662, 101, 482, 14, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4181, 120, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4558, 134, 148, 5, 70, "ExampleSection",
 CellID->291626361],
Cell[4709, 141, 60, 1, 70, "ExampleText",
 CellID->568660478],
Cell[CellGroupData[{
Cell[4794, 146, 362, 13, 28, "Input",
 CellID->543815691],
Cell[5159, 161, 288, 8, 73, "Output",
 CellID->196978340]
}, Open  ]],
Cell[CellGroupData[{
Cell[5484, 174, 384, 13, 28, "Input",
 CellID->494817468],
Cell[5871, 189, 1587, 32, 102, 119, 3, "CachedBoxData", "BoxData", "Output",
 CellID->523225627]
}, Open  ]],
Cell[7473, 224, 125, 3, 70, "ExampleDelimiter",
 CellID->255849672],
Cell[7601, 229, 60, 1, 70, "ExampleText",
 CellID->273114951],
Cell[CellGroupData[{
Cell[7686, 234, 336, 10, 70, "Input",
 CellID->340435630],
Cell[8025, 246, 586, 17, 88, "Output",
 CellID->143666869]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8660, 269, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[8884, 278, 212, 8, 70, "ExampleText",
 CellID->386942407],
Cell[CellGroupData[{
Cell[9121, 290, 242, 7, 70, "Input",
 CellID->425061707],
Cell[9366, 299, 321, 9, 121, "Output",
 CellID->345854115]
}, Open  ]],
Cell[CellGroupData[{
Cell[9724, 313, 293, 9, 70, "Input",
 CellID->913846666],
Cell[10020, 324, 1580, 31, 129, 128, 3, "CachedBoxData", "BoxData", "Output",
 CellID->249551571]
}, Open  ]],
Cell[11615, 358, 125, 3, 70, "ExampleDelimiter",
 CellID->101466395],
Cell[11743, 363, 70, 1, 70, "ExampleText",
 CellID->77058257],
Cell[CellGroupData[{
Cell[11838, 368, 291, 9, 70, "Input",
 CellID->325230780],
Cell[12132, 379, 2177, 40, 70, "Output",
 Evaluatable->False,
 CellID->118034475]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14358, 425, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[14599, 434, 686, 24, 70, "ExampleText",
 CellID->18697713],
Cell[CellGroupData[{
Cell[15310, 462, 78, 2, 70, "Input",
 CellID->297549763],
Cell[15391, 466, 273, 9, 36, "Output",
 CellID->85587994]
}, Open  ]],
Cell[15679, 478, 125, 3, 70, "ExampleDelimiter",
 CellID->256887701],
Cell[15807, 483, 358, 12, 70, "ExampleText",
 CellID->3146420],
Cell[CellGroupData[{
Cell[16190, 499, 695, 24, 70, "Input",
 CellID->487066461],
Cell[16888, 525, 587, 17, 75, "Output",
 CellID->154933809]
}, Open  ]],
Cell[CellGroupData[{
Cell[17512, 547, 689, 24, 70, "Input",
 CellID->302616010],
Cell[18204, 573, 565, 17, 75, "Output",
 CellID->109723155]
}, Open  ]],
Cell[18784, 593, 124, 3, 70, "ExampleDelimiter",
 CellID->72811268],
Cell[18911, 598, 230, 7, 70, "ExampleText",
 CellID->72097842],
Cell[CellGroupData[{
Cell[19166, 609, 625, 21, 70, "Input",
 CellID->540741371],
Cell[19794, 632, 515, 16, 75, "Output",
 CellID->109341211]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20370, 655, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[20689, 666, 949, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[21675, 706, 318, 9, 70, "MoreAboutSection",
 CellID->68866538],
Cell[21996, 717, 149, 3, 70, "MoreAbout",
 CellID->286673708]
}, Open  ]],
Cell[22160, 723, 27, 0, 70, "History"],
Cell[22190, 725, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

