(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     49069,       1817]
NotebookOptionsPosition[     39608,       1485]
NotebookOutlinePosition[     41283,       1528]
CellTagsIndexPosition[     41197,       1523]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Getting Pieces of Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/GettingPiecesOfLists"], 
          "Manipulating Lists by Their Indices" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingListsByTheirIndices"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Getting Pieces of Lists\"\>", 
       2->"\<\"Manipulating Lists by Their Indices\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Rest" :> Documentation`HelpLookup["paclet:ref/Rest"], "Most" :> 
          Documentation`HelpLookup["paclet:ref/Most"], "StringDrop" :> 
          Documentation`HelpLookup["paclet:ref/StringDrop"], "Take" :> 
          Documentation`HelpLookup["paclet:ref/Take"], "Span" :> 
          Documentation`HelpLookup["paclet:ref/Span"], "Cases" :> 
          Documentation`HelpLookup["paclet:ref/Cases"], "Delete" :> 
          Documentation`HelpLookup["paclet:ref/Delete"], "Insert" :> 
          Documentation`HelpLookup["paclet:ref/Insert"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Rest\"\>", 2->"\<\"Most\"\>", 
       3->"\<\"StringDrop\"\>", 4->"\<\"Take\"\>", 5->"\<\"Span\"\>", 
       6->"\<\"Cases\"\>", 7->"\<\"Delete\"\>", 
       8->"\<\"Insert\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"], 
          "Handling Arrays of Data" :> 
          Documentation`HelpLookup["paclet:guide/HandlingArraysOfData"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Parts of Expressions" :> 
          Documentation`HelpLookup["paclet:guide/PartsOfExpressions"], 
          "Parts of Matrices" :> 
          Documentation`HelpLookup["paclet:guide/PartsOfMatrices"], 
          "Rearranging & Restructuring Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/RearrangingAndRestructuringLists"], 
          "Structural Operations on Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/StructuralOperationsOnExpressions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Elements of Lists\"\>", 
       2->"\<\"Handling Arrays of Data\"\>", 3->"\<\"List Manipulation\"\>", 
       4->"\<\"Parts of Expressions\"\>", 5->"\<\"Parts of Matrices\"\>", 
       6->"\<\"Rearranging & Restructuring Lists\"\>", 
       7->"\<\"Structural Operations on Expressions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Drop", "ObjectName",
 CellID->16281],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Drop",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Drop"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " with its first ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " elements dropped. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Drop",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Drop"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        RowBox[{"-", 
         StyleBox["n", "TI"]}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " with its last ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " elements dropped. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Drop",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Drop"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        RowBox[{"{", 
         StyleBox["n", "TI"], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " with its ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " element dropped. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Drop",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Drop"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["m", "TI"], ",", 
          StyleBox["n", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " with elements ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " dropped. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Drop",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Drop"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["m", "TI"], ",", 
          StyleBox["n", "TI"], ",", 
          StyleBox["s", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " with elements ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " in steps of ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " dropped. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Drop",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Drop"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        SubscriptBox[
         StyleBox["seq", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["seq", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a nested list in which elements specified by ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["seq", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " have been dropped at level ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->24213]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Drop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Drop"]], "InlineFormula"],
 " uses the standard sequence specification:"
}], "Notes",
 CellID->10967],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell["all elements", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["no elements", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["n", "TI"], Cell[TextData[{
     "elements 1 through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", 
     StyleBox["n", "TI"]}], Cell[TextData[{
     "last ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " elements"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     StyleBox["n", "TI"], "}"}], Cell[TextData[{
     "element ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " only"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["m", "TI"], ",", 
      StyleBox["n", "TI"]}], "}"}], Cell[TextData[{
     "elements ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " inclusive"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["m", "TI"], ",", 
      StyleBox["n", "TI"], ",", 
      StyleBox["s", "TI"]}], "}"}], Cell[TextData[{
     "elements ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " in steps of ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->30179],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Drop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Drop"]], "InlineFormula"],
 " can be used on an object with any head, not necessarily ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17141],

Cell[TextData[{
 "For a matrix, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Drop",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Drop"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    SubscriptBox[
     StyleBox["seq", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["seq", "TI"], 
     StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
 " effectively drops all elements except those in a submatrix of ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22544],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Drop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Drop"]], "InlineFormula"],
 " works on ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->20219]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->66930267],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->180562975],

Cell["Drop the first two elements from a list:", "ExampleText",
 CellID->13633],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Drop", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
   ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1722],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"c", ",", "d", ",", "e", ",", "f"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1636898745]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17222],

Cell["Drop the last 3 elements:", "ExampleText",
 CellID->9375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Drop", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
   ",", 
   RowBox[{"-", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5580],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2091689145]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26530],

Cell["Drop elements 2 through 4:", "ExampleText",
 CellID->13516],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Drop", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7354],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "e", ",", "f"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->712158625]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1629],

Cell["Drop elements from the third to the third-to-last:", "ExampleText",
 CellID->476],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Drop", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"-", "3"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3447],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "e", ",", "f"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1323645644]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->257],

Cell["Drop every other element:", "ExampleText",
 CellID->23346],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Drop", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16368],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "d", ",", "f"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->729239435]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28841],

Cell["Drop the first row of a matrix:", "ExampleText",
 CellID->9977],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Drop", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"11", ",", "12", ",", "13"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"21", ",", "22", ",", "23"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"31", ",", "32", ",", "33"}], "}"}]}], "}"}], ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23200],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"21", ",", "22", ",", "23"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"31", ",", "32", ",", "33"}], "}"}]}], "}"}]], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->638010616]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32236],

Cell["Drop the first row, and the first two columns:", "ExampleText",
 CellID->29308],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Drop", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"11", ",", "12", ",", "13"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"21", ",", "22", ",", "23"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"31", ",", "32", ",", "33"}], "}"}]}], "}"}], ",", "1", ",", 
   "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24692],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "23", "}"}], ",", 
   RowBox[{"{", "33", "}"}]}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->658573641]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1449],

Cell["Drop none of the rows, but the first two columns: ", "ExampleText",
 CellID->25389],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Drop", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"11", ",", "12", ",", "13"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"21", ",", "22", ",", "23"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"31", ",", "32", ",", "33"}], "}"}]}], "}"}], ",", "None", ",", 
   "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27880],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "13", "}"}], ",", 
   RowBox[{"{", "23", "}"}], ",", 
   RowBox[{"{", "33", "}"}]}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->516467649]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5102],

Cell["Drop rows 2 through 4 and columns 3 through 5:", "ExampleText",
 CellID->22004],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Drop", "[", 
   RowBox[{
    TagBox[
     RowBox[{"(", "\:f3a2", GridBox[{
        {"11", "12", "13", "14", "15"},
        {"21", "22", "23", "24", "25"},
        {"31", "32", "33", "34", "35"},
        {"41", "42", "43", "44", "45"},
        {"51", "52", "53", "54", "55"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{
        "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
         "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}], "\:f3a2", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "5"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9745],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVT0PgjAQLS31A9TZwYHVwZ1foJM/oiEmMBgN8v+xLcWYxwlFHCUp13cc
7zXt3fWsqvxyVVWRqeRUqnteZI/keCu1SwSMsVSP3Zbpea1ndqR1rW3zluYt
jNc+bA84tFEh4TVQaCu1jQHPIF6QLNYrX9jGdKMiMoqTXj/dOWAOeENyL0lu
Ad6FD3fPd3JtHRXp9htPrz0H3AfEn1n7cDywVoz/jQqdJf77FLq85Nqu37AJ
I0+rw3L4RzmvqSTpqs/YCLDfqWA2Yn2uKJYvM2Csllc9T1bx6kiTVbCy6C6A
LPjXkMrQqugePFZlSr83mLtu2XaBFgsikxoWv5uxuUVZ8AS9XgYR\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{56, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->429978243]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1560],

Cell["Drop every other row and every third column:", "ExampleText",
 CellID->2247],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Drop", "[", 
   RowBox[{
    TagBox[
     RowBox[{"(", "\:f3a2", GridBox[{
        {"11", "12", "13", "14", "15"},
        {"21", "22", "23", "24", "25"},
        {"31", "32", "33", "34", "35"},
        {"41", "42", "43", "44", "45"},
        {"51", "52", "53", "54", "55"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{
        "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
         "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}], "\:f3a2", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}], ",", "3"}], "}"}]}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4065],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVk1Pg0AQ3S4LrRR79uCh/8SDiZ7sfyCNSXswNrX/H3eWQcnjwW7ReJKE
HeZjZx7zsfBSXw6vb/XluK+3z+f6dDjuP7ZP72cvyhbGmJ2/7++Mf278U7h3
TeNpu+ayZiINl3kA3gUrB9LCL8KaLKjDJfytyq3SDfBL8JNR78HKffMapmdR
/YIFRuVYRFroG/Tla5Vj/lYjch6NYsq/eE0u7i2pVUGQxK0Qp6W48kE2cV85
sBDU1lNeCdm6SordR8zeoLxSj/7nobA0u9Usq3mIlprfLpubCd6R2eNeH/+t
VCr9m2sNhZZKu/yugU+rGp9w3id8zn9um9YJsROsAh693kT0aScPTnMMxdT0
M30aCsQeQyH7rc4geh/vFfodvCIq1Q+qj3UZ/+79XZ/G8s0xOs1mR6sJXk5A
rH3rNe0PqP1bMotPeGTlsQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{78, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->204249797]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6204],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Drop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Drop"]], "InlineFormula"],
 " works with any head, not just ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->635],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Drop", "[", 
  RowBox[{
   RowBox[{"a", "+", "b", "+", "c", "+", "d", "+", "e", "+", "f"}], ",", 
   "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9383],

Cell[BoxData[
 RowBox[{"d", "+", "e", "+", "f"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->699985889]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Drop", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "+", "b", "+", "c"}], ",", 
     RowBox[{"t", "+", "u", "+", "v"}], ",", 
     RowBox[{"x", "+", "y", "+", "z"}]}], "}"}], ",", "2", ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25030],

Cell[BoxData[
 RowBox[{"{", "z", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->747418157]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Drop", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", "b", "+", "c"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"t", "+", "u", "+", "v"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "+", "y", "+", "z"}], ")"}]}], ",", "2", ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->22229],

Cell[BoxData["z"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1225113396]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1376],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Drop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Drop"]], "InlineFormula"],
 " works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->21749],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Drop", "[", 
  RowBox[{
   RowBox[{"SparseArray", "[", 
    RowBox[{"Range", "[", "1000", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"-", "4"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24582],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "5", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 5, ">"],
     Editable->False], ",", 
    RowBox[{"{", "5", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->407639136]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6166],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "998", ",", "999", ",", "1000"}], 
  "}"}]], "Output",
 ImageSize->{147, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->718124822]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13828],

Cell["Pick out a subimage:", "ExampleText",
 CellID->951],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"CellularAutomaton", "[", 
   RowBox[{"150", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "50"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28875],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJy1VUsWgyAMDL1Jz9Cb9Ai+13Xvv6tWI5oPCSRQLYZBJ0TGeS7f9/IAgNd6
ftYTyvarjca09eJ7vPHcZkHrGf34HtN72s/ox+Hguh9sIIgjF9z+QRiL4LVu
WMtrr1334rVucLmWxiI4rqXW8tpn4cjLayrpZxTHXHhNM3HMRe6zcMylHDsC
hHrGceTGHSF/n6I45gKF7+88HHOR9ncejrlI+zsPx1xa9YzjmEuun2i5zMUx
l/ZhGYqvWY5hzXCyNLzCwvyt5RUW1sFi+IY1z7uWtm9Y87xrafuGNc/JQno6
bs1zsii60OKxpulCiwdZFF1o8ehafDqJcOi60OJBFqdOgixOnQRZOuNBFiKM
Mf8wWYg2xvzDZCHaoGNJLIV/o+L6YCzEN3L0wViEd5LNwX0j932cLEqfzJLi
HyZLin+YLCn+YbKUGfpgLFP0wVimvo+TZfo6/iz9t/wAriwTHQ==
   "], {{0, 0}, {101, 51}}, {0, 1}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{None, None},
  ImageMargins->0.,
  PlotRangeClipping->True]], "Output",
 ImageSize->{229, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->665787214]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Drop", "[", 
   RowBox[{
    RowBox[{"CellularAutomaton", "[", 
     RowBox[{"150", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "50"}], "]"}], ",", 
    "20", ",", 
    RowBox[{"{", 
     RowBox[{"20", ",", 
      RowBox[{"-", "20"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16497],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztkksOgCAMRKdexLjxQB6BC3j/nYgSynTEvbF8ApMJfRSWtG9pAjDnseYB
O1uLvAtCEb1mBiEUs5HKQpXHvaV2M2271BUHbkHQns+lYOirItTVRQQXm0xz
xZBcwnYDUZ3iaahnKSbPhlgnxSYfV7MNTeJ/PbK9m8T/+uMzcQBQqwXg
   "], {{0, 0}, {38, 31}}, {0, 1}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{None, None},
  ImageMargins->0.,
  PlotRangeClipping->True]], "Output",
 ImageSize->{229, 185},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[2]=",
 CellID->1495904828]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22919],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Drop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Drop"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Take",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Take"]], "InlineFormula"],
 " are complementary:"
}], "ExampleText",
 CellID->12112],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Drop", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", 
     "h"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "4"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17910],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "c", ",", "e", ",", "f", ",", "g", ",", "h"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1081388767]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", 
     "h"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "4"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13930],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "d"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->746902408]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5124],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Rest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rest"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["Drop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Drop"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->21258],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rest", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31899],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "c", ",", "d", ",", "e"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1146854541]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Drop", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26140],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "c", ",", "d", ",", "e"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1518538762]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18882],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Most",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Most"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["Drop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Drop"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->10977],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Most", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32321],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1385311986]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Drop", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24602],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2068331575]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8621],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Drop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Drop"]], "InlineFormula"],
 " always gives a list, even if only one element remains:"
}], "ExampleText",
 CellID->7034],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Drop", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", "4"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10440],

Cell[BoxData[
 RowBox[{"{", "e", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1130987036]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31569],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Most",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Most"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringDrop",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringDrop"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Take",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Take"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Span",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Span"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cases"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Delete",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Delete"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Insert",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Insert"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1882]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1524],

Cell[TextData[ButtonBox["Getting Pieces of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GettingPiecesOfLists"]], "Tutorials",
 CellID->4749],

Cell[TextData[ButtonBox["Manipulating Lists by Their Indices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingListsByTheirIndices"]], "Tutorials",\

 CellID->2597]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->312728440],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->156235842],

Cell[TextData[ButtonBox["Handling Arrays of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HandlingArraysOfData"]], "MoreAbout",
 CellID->420152802],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->10602003],

Cell[TextData[ButtonBox["Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfExpressions"]], "MoreAbout",
 CellID->300042436],

Cell[TextData[ButtonBox["Parts of Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfMatrices"]], "MoreAbout",
 CellID->112672877],

Cell[TextData[ButtonBox["Rearranging & Restructuring Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RearrangingAndRestructuringLists"]], "MoreAbout",
 CellID->154605306],

Cell[TextData[ButtonBox["Structural Operations on Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StructuralOperationsOnExpressions"]], "MoreAbout",
 CellID->5341272]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Drop"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1  |  Last modified in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Drop - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 39, 16.8846066}", "context" -> "System`", 
    "keywords" -> {
     "deleting elements", "discard elements", "lists", 
      "removing elements from lists"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Drop[list, n] gives list with its first n elements dropped. Drop[list, \
-n] gives list with its last n elements dropped. Drop[list, {n}] gives list \
with its n\\[Null]^th element dropped. Drop[list, {m, n}] gives list with \
elements m through n dropped. Drop[list, {m, n, s}] gives list with elements \
m through n in steps of s dropped. Drop[list, seq_1, seq_2, ...] gives a \
nested list in which elements specified by seq_i have been dropped at level i \
in list. ", "synonyms" -> {}, "title" -> "Drop", "type" -> "Symbol", "uri" -> 
    "ref/Drop"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12387, 400, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->66930267]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 41054, 1516}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3554, 76, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4177, 103, 42, 1, 70, "ObjectName",
 CellID->16281],
Cell[4222, 106, 4130, 140, 70, "Usage",
 CellID->24213]
}, Open  ]],
Cell[CellGroupData[{
Cell[8389, 251, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8867, 268, 201, 7, 70, "Notes",
 CellID->10967],
Cell[9071, 277, 2090, 68, 70, "2ColumnTableMod",
 CellID->30179],
Cell[11164, 347, 334, 12, 70, "Notes",
 CellID->17141],
Cell[11501, 361, 537, 20, 70, "Notes",
 CellID->22544],
Cell[12041, 383, 309, 12, 70, "Notes",
 CellID->20219]
}, Closed]],
Cell[CellGroupData[{
Cell[12387, 400, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->66930267],
Cell[CellGroupData[{
Cell[12771, 414, 148, 5, 70, "ExampleSection",
 CellID->180562975],
Cell[12922, 421, 79, 1, 70, "ExampleText",
 CellID->13633],
Cell[CellGroupData[{
Cell[13026, 426, 211, 7, 28, "Input",
 CellID->1722],
Cell[13240, 435, 224, 7, 36, "Output",
 CellID->1636898745]
}, Open  ]],
Cell[13479, 445, 121, 3, 70, "ExampleDelimiter",
 CellID->17222],
Cell[13603, 450, 63, 1, 70, "ExampleText",
 CellID->9375],
Cell[CellGroupData[{
Cell[13691, 455, 230, 8, 70, "Input",
 CellID->5580],
Cell[13924, 465, 214, 7, 36, "Output",
 CellID->2091689145]
}, Open  ]],
Cell[14153, 475, 121, 3, 70, "ExampleDelimiter",
 CellID->26530],
Cell[14277, 480, 65, 1, 70, "ExampleText",
 CellID->13516],
Cell[CellGroupData[{
Cell[14367, 485, 260, 9, 70, "Input",
 CellID->7354],
Cell[14630, 496, 213, 7, 36, "Output",
 CellID->712158625]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14892, 509, 215, 7, 70, "ExampleSection",
 CellID->1629],
Cell[15110, 518, 87, 1, 70, "ExampleText",
 CellID->476],
Cell[CellGroupData[{
Cell[15222, 523, 281, 10, 70, "Input",
 CellID->3447],
Cell[15506, 535, 224, 7, 36, "Output",
 CellID->1323645644]
}, Open  ]],
Cell[15745, 545, 119, 3, 70, "ExampleDelimiter",
 CellID->257],
Cell[15867, 550, 64, 1, 70, "ExampleText",
 CellID->23346],
Cell[CellGroupData[{
Cell[15956, 555, 292, 10, 70, "Input",
 CellID->16368],
Cell[16251, 567, 213, 7, 36, "Output",
 CellID->729239435]
}, Open  ]],
Cell[16479, 577, 121, 3, 70, "ExampleDelimiter",
 CellID->28841],
Cell[16603, 582, 69, 1, 70, "ExampleText",
 CellID->9977],
Cell[CellGroupData[{
Cell[16697, 587, 379, 13, 70, "Input",
 CellID->23200],
Cell[17079, 602, 328, 11, 36, "Output",
 CellID->638010616]
}, Open  ]],
Cell[17422, 616, 121, 3, 70, "ExampleDelimiter",
 CellID->32236],
Cell[17546, 621, 85, 1, 70, "ExampleText",
 CellID->29308],
Cell[CellGroupData[{
Cell[17656, 626, 390, 13, 70, "Input",
 CellID->24692],
Cell[18049, 641, 253, 9, 36, "Output",
 CellID->658573641]
}, Open  ]],
Cell[18317, 653, 120, 3, 70, "ExampleDelimiter",
 CellID->1449],
Cell[18440, 658, 89, 1, 70, "ExampleText",
 CellID->25389],
Cell[CellGroupData[{
Cell[18554, 663, 393, 13, 70, "Input",
 CellID->27880],
Cell[18950, 678, 289, 10, 36, "Output",
 CellID->516467649]
}, Open  ]],
Cell[19254, 691, 120, 3, 70, "ExampleDelimiter",
 CellID->5102],
Cell[19377, 696, 85, 1, 70, "ExampleText",
 CellID->22004],
Cell[CellGroupData[{
Cell[19487, 701, 887, 25, 70, "Input",
 CellID->9745],
Cell[20377, 728, 580, 13, 70, "Output",
 Evaluatable->False,
 CellID->429978243]
}, Open  ]],
Cell[20972, 744, 120, 3, 70, "ExampleDelimiter",
 CellID->1560],
Cell[21095, 749, 82, 1, 70, "ExampleText",
 CellID->2247],
Cell[CellGroupData[{
Cell[21202, 754, 954, 28, 70, "Input",
 CellID->4065],
Cell[22159, 784, 674, 15, 70, "Output",
 Evaluatable->False,
 CellID->204249797]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22882, 805, 238, 7, 70, "ExampleSection",
 CellID->6204],
Cell[23123, 814, 311, 12, 70, "ExampleText",
 CellID->635],
Cell[CellGroupData[{
Cell[23459, 830, 186, 6, 70, "Input",
 CellID->9383],
Cell[23648, 838, 190, 6, 36, "Output",
 CellID->699985889]
}, Open  ]],
Cell[CellGroupData[{
Cell[23875, 849, 299, 10, 70, "Input",
 CellID->25030],
Cell[24177, 861, 180, 6, 36, "Output",
 CellID->747418157]
}, Open  ]],
Cell[CellGroupData[{
Cell[24394, 872, 339, 12, 70, "Input",
 CellID->22229],
Cell[24736, 886, 159, 5, 36, "Output",
 CellID->1225113396]
}, Open  ]],
Cell[24910, 894, 120, 3, 70, "ExampleDelimiter",
 CellID->1376],
Cell[25033, 899, 316, 12, 70, "ExampleText",
 CellID->21749],
Cell[CellGroupData[{
Cell[25374, 915, 265, 9, 70, "Input",
 CellID->24582],
Cell[25642, 926, 453, 16, 36, "Output",
 CellID->407639136]
}, Open  ]],
Cell[CellGroupData[{
Cell[26132, 947, 97, 3, 70, "Input",
 CellID->6166],
Cell[26232, 952, 244, 8, 36, "Output",
 CellID->718124822]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26525, 966, 223, 7, 70, "ExampleSection",
 CellID->13828],
Cell[26751, 975, 57, 1, 70, "ExampleText",
 CellID->951],
Cell[CellGroupData[{
Cell[26833, 980, 263, 9, 70, "Input",
 CellID->28875],
Cell[27099, 991, 891, 21, 139, "Output",
 CellID->665787214]
}, Open  ]],
Cell[CellGroupData[{
Cell[28027, 1017, 416, 14, 70, "Input",
 CellID->16497],
Cell[28446, 1033, 590, 16, 206, "Output",
 CellID->1495904828]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29085, 1055, 233, 7, 70, "ExampleSection",
 CellID->22919],
Cell[29321, 1064, 305, 12, 70, "ExampleText",
 CellID->12112],
Cell[CellGroupData[{
Cell[29651, 1080, 319, 11, 70, "Input",
 CellID->17910],
Cell[29973, 1093, 248, 8, 36, "Output",
 CellID->1081388767]
}, Open  ]],
Cell[CellGroupData[{
Cell[30258, 1106, 319, 11, 70, "Input",
 CellID->13930],
Cell[30580, 1119, 203, 7, 36, "Output",
 CellID->746902408]
}, Open  ]],
Cell[30798, 1129, 120, 3, 70, "ExampleDelimiter",
 CellID->5124],
Cell[30921, 1134, 304, 12, 70, "ExampleText",
 CellID->21258],
Cell[CellGroupData[{
Cell[31250, 1150, 176, 6, 70, "Input",
 CellID->31899],
Cell[31429, 1158, 224, 7, 36, "Output",
 CellID->1146854541]
}, Open  ]],
Cell[CellGroupData[{
Cell[31690, 1170, 201, 7, 70, "Input",
 CellID->26140],
Cell[31894, 1179, 224, 7, 36, "Output",
 CellID->1518538762]
}, Open  ]],
Cell[32133, 1189, 121, 3, 70, "ExampleDelimiter",
 CellID->18882],
Cell[32257, 1194, 304, 12, 70, "ExampleText",
 CellID->10977],
Cell[CellGroupData[{
Cell[32586, 1210, 176, 6, 70, "Input",
 CellID->32321],
Cell[32765, 1218, 224, 7, 36, "Output",
 CellID->1385311986]
}, Open  ]],
Cell[CellGroupData[{
Cell[33026, 1230, 217, 7, 70, "Input",
 CellID->24602],
Cell[33246, 1239, 224, 7, 36, "Output",
 CellID->2068331575]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33519, 1252, 225, 7, 70, "ExampleSection",
 CellID->8621],
Cell[33747, 1261, 219, 7, 70, "ExampleText",
 CellID->7034],
Cell[CellGroupData[{
Cell[33991, 1272, 201, 7, 70, "Input",
 CellID->10440],
Cell[34195, 1281, 181, 6, 36, "Output",
 CellID->1130987036]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34437, 1294, 311, 9, 70, "SeeAlsoSection",
 CellID->31569],
Cell[34751, 1305, 1878, 71, 70, "SeeAlso",
 CellID->1882]
}, Open  ]],
Cell[CellGroupData[{
Cell[36666, 1381, 313, 9, 70, "TutorialsSection",
 CellID->1524],
Cell[36982, 1392, 153, 3, 70, "Tutorials",
 CellID->4749],
Cell[37138, 1397, 178, 4, 70, "Tutorials",
 CellID->2597]
}, Open  ]],
Cell[CellGroupData[{
Cell[37353, 1406, 319, 9, 70, "MoreAboutSection",
 CellID->312728440],
Cell[37675, 1417, 144, 3, 70, "MoreAbout",
 CellID->156235842],
Cell[37822, 1422, 155, 3, 70, "MoreAbout",
 CellID->420152802],
Cell[37980, 1427, 144, 3, 70, "MoreAbout",
 CellID->10602003],
Cell[38127, 1432, 150, 3, 70, "MoreAbout",
 CellID->300042436],
Cell[38280, 1437, 144, 3, 70, "MoreAbout",
 CellID->112672877],
Cell[38427, 1442, 177, 3, 70, "MoreAbout",
 CellID->154605306],
Cell[38607, 1447, 179, 3, 70, "MoreAbout",
 CellID->5341272]
}, Open  ]],
Cell[CellGroupData[{
Cell[38823, 1455, 305, 8, 70, "RelatedLinksSection"],
Cell[39131, 1465, 382, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[39528, 1481, 50, 0, 70, "History"],
Cell[39581, 1483, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

