(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15579,        567]
NotebookOptionsPosition[     12303,        459]
NotebookOutlinePosition[     13711,        498]
CellTagsIndexPosition[     13626,        493]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Differentiation" :> 
          Documentation`HelpLookup["paclet:tutorial/Differentiation"], 
          "Total Derivatives" :> 
          Documentation`HelpLookup["paclet:tutorial/TotalDerivatives"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Differentiation\"\>", 
       2->"\<\"Total Derivatives\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"D" :> Documentation`HelpLookup["paclet:ref/D"], "Derivative" :> 
          Documentation`HelpLookup["paclet:ref/Derivative"], "Constants" :> 
          Documentation`HelpLookup["paclet:ref/Constants"], "NonConstants" :> 
          Documentation`HelpLookup["paclet:ref/NonConstants"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"D\"\>", 2->"\<\"Derivative\"\>", 
       3->"\<\"Constants\"\>", 4->"\<\"NonConstants\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calculus" :> 
          Documentation`HelpLookup["paclet:guide/Calculus"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Calculus\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Dt", "ObjectName",
 CellID->30718],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Dt",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Dt"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the total derivative ",
     Cell[BoxData[
      RowBox[{
       StyleBox["d", "TI"], 
       StyleBox["f", "TI"], "/", 
       StyleBox["d", "TI"], 
       StyleBox["x", "TI"]}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Dt",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Dt"], "[", 
       StyleBox["f", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the total differential ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"d", "f"}], "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Dt",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Dt"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["n", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the multiple derivative ",
     Cell[BoxData[
      RowBox[{
       SuperscriptBox[
        StyleBox["d", "TI"], 
        StyleBox["n", "TI"]], 
       StyleBox["f", "TI"], "/", 
       StyleBox["d", "TI"], 
       SuperscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["n", "TI"]]}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Dt",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Dt"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      RowBox[{
       StyleBox["d", "TI"], "/", 
       RowBox[{
        StyleBox["d", "TI"], 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], " ", 
        RowBox[{
         StyleBox["d", "TI"], "/", 
         StyleBox["d", "TI"]}], 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["2", "TR"]], " ", "\[Ellipsis]", " ", "f"}]}]], 
      "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->772]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dt"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["1", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    RowBox[{
     ButtonBox["Constants",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Constants"], "->", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["1", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]}], "]"}]], "InlineFormula"],
 " specifies that the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["c", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are constants, which have zero total derivative. "
}], "Notes",
 CellID->5556],

Cell[TextData[{
 "Symbols with attribute ",
 Cell[BoxData[
  ButtonBox["Constant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Constant"]], "InlineFormula"],
 " are taken to be constants, with zero total derivative. "
}], "Notes",
 CellID->27084],

Cell["\<\
If an object is specified to be a constant, then all functions with that \
object as a head are also taken to be constants. \
\>", "Notes",
 CellID->4800],

Cell[TextData[{
 "All quantities not explicitly specified as constants are assumed to depend \
on the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2846],

Cell[TextData[{
 "You can specify total derivatives by assigning values to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dt"], "[", 
   StyleBox["f", "TI"], "]"}]], "InlineFormula"],
 ", etc. "
}], "Notes",
 CellID->24715]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->425485018],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->329350259],

Cell[TextData[{
 "Find the total derivative with respect to ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->205410074],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "x"}], " ", "+", "b"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->292631913],

Cell[BoxData[
 RowBox[{"a", "+", 
  RowBox[{"x", " ", 
   RowBox[{"Dt", "[", 
    RowBox[{"a", ",", "x"}], "]"}]}], "+", 
  RowBox[{"Dt", "[", 
   RowBox[{"b", ",", "x"}], "]"}]}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->43567313]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->990855401],

Cell[TextData[{
 "Find the total derivative of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", " ", "y"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->537401543],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{"x", " ", "y"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->245225785],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", " ", 
   RowBox[{"Dt", "[", "x", "]"}]}], "+", 
  RowBox[{"x", " ", 
   RowBox[{"Dt", "[", "y", "]"}]}]}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->269868173]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7892],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Derivative",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Derivative"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Constants",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Constants"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NonConstants",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NonConstants"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31317]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22959],

Cell[TextData[ButtonBox["Differentiation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Differentiation"]], "Tutorials",
 CellID->15156],

Cell[TextData[ButtonBox["Total Derivatives",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TotalDerivatives"]], "Tutorials",
 CellID->27972]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->90271533],

Cell[TextData[ButtonBox["Calculus",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Calculus"]], "MoreAbout",
 CellID->133375]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Dt - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 39, 25.6348306}", "context" -> "System`", 
    "keywords" -> {
     "derivatives", "differential", "exact differential", "total derivatives",
       "total differential"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Dt[f, x] gives the total derivative d f/d x. Dt[f] gives the total \
differential d f. Dt[f, {x, n}] gives the multiple derivative d^n f/d x^n. \
Dt[f, x_1, x_2, ...] gives d/d x_1 d/d x_2 ... f. ", "synonyms" -> {}, 
    "title" -> "Dt", "type" -> "Symbol", "uri" -> "ref/Dt"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7801, 271, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->425485018]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13483, 486}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2113, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2736, 78, 40, 1, 70, "ObjectName",
 CellID->30718],
Cell[2779, 81, 2724, 95, 70, "Usage",
 CellID->772]
}, Open  ]],
Cell[CellGroupData[{
Cell[5540, 181, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6018, 198, 806, 29, 70, "Notes",
 CellID->5556],
Cell[6827, 229, 251, 8, 70, "Notes",
 CellID->27084],
Cell[7081, 239, 164, 4, 70, "Notes",
 CellID->4800],
Cell[7248, 245, 238, 9, 70, "Notes",
 CellID->2846],
Cell[7489, 256, 275, 10, 70, "Notes",
 CellID->24715]
}, Closed]],
Cell[CellGroupData[{
Cell[7801, 271, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->425485018],
Cell[CellGroupData[{
Cell[8186, 285, 148, 5, 70, "ExampleSection",
 CellID->329350259],
Cell[8337, 292, 170, 6, 70, "ExampleText",
 CellID->205410074],
Cell[CellGroupData[{
Cell[8532, 302, 175, 6, 28, "Input",
 CellID->292631913],
Cell[8710, 310, 321, 11, 36, "Output",
 CellID->43567313]
}, Open  ]],
Cell[9046, 324, 125, 3, 70, "ExampleDelimiter",
 CellID->990855401],
Cell[9174, 329, 181, 7, 70, "ExampleText",
 CellID->537401543],
Cell[CellGroupData[{
Cell[9380, 340, 121, 4, 70, "Input",
 CellID->245225785],
Cell[9504, 346, 287, 10, 36, "Output",
 CellID->269868173]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9852, 363, 310, 9, 70, "SeeAlsoSection",
 CellID->7892],
Cell[10165, 374, 941, 35, 70, "SeeAlso",
 CellID->31317]
}, Open  ]],
Cell[CellGroupData[{
Cell[11143, 414, 314, 9, 70, "TutorialsSection",
 CellID->22959],
Cell[11460, 425, 141, 3, 70, "Tutorials",
 CellID->15156],
Cell[11604, 430, 144, 3, 70, "Tutorials",
 CellID->27972]
}, Open  ]],
Cell[CellGroupData[{
Cell[11785, 438, 318, 9, 70, "MoreAboutSection",
 CellID->90271533],
Cell[12106, 449, 125, 3, 70, "MoreAbout",
 CellID->133375]
}, Open  ]],
Cell[12246, 455, 27, 0, 70, "History"],
Cell[12276, 457, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

