(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    168867,       5688]
NotebookOptionsPosition[    145820,       4905]
NotebookOutlinePosition[    148010,       4957]
CellTagsIndexPosition[    147888,       4951]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Advanced Dynamic Functionality" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AdvancedDynamicFunctionality"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>", 
       2->"\<\"Advanced Dynamic Functionality\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulate" :> 
          Documentation`HelpLookup["paclet:ref/Manipulate"], "Animate" :> 
          Documentation`HelpLookup["paclet:ref/Animate"], "Monitor" :> 
          Documentation`HelpLookup["paclet:ref/Monitor"], "Refresh" :> 
          Documentation`HelpLookup["paclet:ref/Refresh"], "Deploy" :> 
          Documentation`HelpLookup["paclet:ref/Deploy"], "ContinuousAction" :> 
          Documentation`HelpLookup["paclet:ref/ContinuousAction"], 
          "FinishDynamic" :> 
          Documentation`HelpLookup["paclet:ref/FinishDynamic"], "Button" :> 
          Documentation`HelpLookup["paclet:ref/Button"], "SetDelayed" :> 
          Documentation`HelpLookup["paclet:ref/SetDelayed"], "DynamicModule" :> 
          Documentation`HelpLookup["paclet:ref/DynamicModule"], 
          "DynamicSetting" :> 
          Documentation`HelpLookup["paclet:ref/DynamicSetting"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Manipulate\"\>", 
       2->"\<\"Animate\"\>", 3->"\<\"Monitor\"\>", 4->"\<\"Refresh\"\>", 
       5->"\<\"Deploy\"\>", 6->"\<\"ContinuousAction\"\>", 
       7->"\<\"FinishDynamic\"\>", 8->"\<\"Button\"\>", 
       9->"\<\"SetDelayed\"\>", 10->"\<\"DynamicModule\"\>", 
       11->"\<\"DynamicSetting\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Click-Interactive Panels" :> 
          Documentation`HelpLookup["paclet:guide/ClickInteractivePanels"], 
          "Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "Creating Inspectors" :> 
          Documentation`HelpLookup["paclet:guide/CreatingInspectors"], 
          "Custom Interface Construction" :> 
          Documentation`HelpLookup[
           "paclet:guide/CustomInterfaceConstruction"], "Dialog Boxes" :> 
          Documentation`HelpLookup["paclet:guide/DialogBoxes"], 
          "Dynamic Interactivity Language" :> 
          Documentation`HelpLookup[
           "paclet:guide/DynamicInteractivityLanguage"], "Evaluation Control" :> 
          Documentation`HelpLookup["paclet:guide/EvaluationControl"], 
          "External Operations" :> 
          Documentation`HelpLookup["paclet:guide/ExternalOperations"], 
          "Language Overview" :> 
          Documentation`HelpLookup["paclet:guide/LanguageOverview"], 
          "Low-Level Interface Control" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelInterfaceControl"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup["paclet:guide/SymbolicGraphicsLanguage"], 
          "Toolbars" :> Documentation`HelpLookup["paclet:guide/Toolbars"], 
          "New in 6.0: Core Language" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60CoreLanguage"], 
          "New in 6.0: Dynamic Interactivity" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DynamicInteractivity"], 
          "New in 6.0: System Interfaces & Deployment" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60SystemInterfacesAndDeployment"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Click-Interactive Panels\"\>", 
       2->"\<\"Control Objects\"\>", 3->"\<\"Creating Inspectors\"\>", 
       4->"\<\"Custom Interface Construction\"\>", 5->"\<\"Dialog Boxes\"\>", 
       6->"\<\"Dynamic Interactivity Language\"\>", 
       7->"\<\"Evaluation Control\"\>", 8->"\<\"External Operations\"\>", 
       9->"\<\"Language Overview\"\>", 
       10->"\<\"Low-Level Interface Control\"\>", 
       11->"\<\"Symbolic Graphics Language\"\>", 12->"\<\"Toolbars\"\>", 
       13->"\<\"New in 6.0: Core Language\"\>", 
       14->"\<\"New in 6.0: Dynamic Interactivity\"\>", 
       15->"\<\"New in 6.0: System Interfaces & Deployment\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Dynamic", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Dynamic",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Dynamic"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents an object that displays as the dynamically \
updated current value of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". If the displayed form of ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Dynamic",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Dynamic"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " is interactively changed or edited, an assignment ",
     Cell[BoxData[
      RowBox[{
       StyleBox["expr", "TI"], "=", 
       StyleBox["val", "TI"]}]], "InlineFormula"],
     " is done to give ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " the new value ",
     Cell[BoxData[
      StyleBox["val", "TI"]], "InlineFormula"],
     " that corresponds to the displayed form. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Dynamic",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Dynamic"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        ButtonBox["None",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/None"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]does not allow interactive changing or editing. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Dynamic",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Dynamic"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["f", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]continually evaluates ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "[", 
       RowBox[{
        StyleBox["val", "TI"], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     " during interactive changing or editing of ",
     Cell[BoxData[
      StyleBox["val", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Dynamic",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Dynamic"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["f", "TI"], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["end", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]also evaluates ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["f", "TI"], 
        StyleBox["end", "TI"]], "[", 
       RowBox[{
        StyleBox["val", "TI"], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     " when interactive changing or editing is complete. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Dynamic",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Dynamic"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["start", "TI"]], ",", 
          StyleBox["f", "TI"], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["end", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]also evaluates ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["f", "TI"], 
        StyleBox["start", "TI"]], "[", 
       RowBox[{
        StyleBox["val", "TI"], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     " when interactive changing or editing begins. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->8135]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " can appear not only directly as an expression to display, but also for \
example as a coordinate in a graphics primitive or an object such as a \
slider, or as a setting for an option. "
}], "Notes",
 CellID->3915],

Cell[TextData[{
 "When used to assign values to ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " through interactive operations, the expression in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " will most often be a symbol ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", an object ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "[", 
   StyleBox["i", "TI"], "]"}]], "InlineFormula"],
 ", a part ",
 Cell[BoxData[
  RowBox[{
   StyleBox["e", "TI"], "[", 
   RowBox[{"[", "i", "]"}], "]"}]], "InlineFormula"],
 " or a list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->98],

Cell[TextData[{
 "In graphics for example, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Point",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Point"], "[", 
   RowBox[{"Dynamic", "[", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"]}], "}"}], "]"}], "]"}]], "InlineFormula"],
 " represents a point whose position is dynamically updated to be given by \
the current values of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ". Whenever the point is interactively moved, assignments of the form ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"]}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["x", "TI"]], ",", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["y", "TI"]]}], "}"}]}]], "InlineFormula"],
 " are done. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Point",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Point"], "[", 
   RowBox[{"Dynamic", "[", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"]}], "}"}], "]"}], "]"}]], "InlineFormula"],
 " can be moved interactively; ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   RowBox[{
    ButtonBox["Point",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Point"], "[", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"]}], "}"}], "]"}], "]"}]], "InlineFormula"],
 " cannot. "
}], "Notes",
 CellID->27619],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " evaluates ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " whenever it needs its value and it determines that any type of value of \
symbols on which it depends might have changed. "
}], "Notes",
 CellID->13313],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["Refresh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refresh"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Clock",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Clock"]], "InlineFormula"],
 " objects appear in the evaluation of the expression in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " will always continually be re\[Hyphen]evaluated. "
}], "Notes",
 CellID->9974],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 ", so that ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is not evaluated until its value is needed for display. "
}], "Notes",
 CellID->27296],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       StyleBox["expr", "TI"], "=", "#"}], ")"}], "&"}]}], "]"}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->3764],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["f", "TI"]}], "]"}]], "InlineFormula"],
 " makes interactive operations not change ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " except by virtue of the evaluation of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    StyleBox["val", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18223],

Cell[TextData[{
 "Objects represented by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"]}], "]"}]], "InlineFormula"],
 " cannot be changed interactively, but will change if the value of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " changes for other reasons. "
}], "Notes",
 CellID->6607],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    ButtonBox["Temporary",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Temporary"]}], "]"}]], "InlineFormula"],
 " allows the displayed form of an object to change in the course of \
interactive operations, but assigns an updated value to ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " only when the operations are complete. "
}], "Notes",
 CellID->12074],

Cell[TextData[{
 "For interactive mouse operations ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["start", "TI"]], ",", 
      StyleBox["f", "TI"], ",", 
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["end", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " typically evaluates ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["f", "TI"], 
    StyleBox["start", "TI"]], "[", 
   RowBox[{
    StyleBox["val", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " once when the mouse is pressed, then evaluates ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    StyleBox["val", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " whenever the mouse is moved, and then evaluates ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["f", "TI"], 
    StyleBox["end", "TI"]], "[", 
   RowBox[{
    StyleBox["val", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " once when the mouse is released. "
}], "Notes",
 CellID->790],

Cell[TextData[{
 "If the mouse is not moved, ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["f", "TI"], 
   StyleBox["start", "TI"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["f", "TI"], 
   StyleBox["end", "TI"]]], "InlineFormula"],
 " are each evaluated exactly once. "
}], "Notes",
 CellID->22599],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    StyleBox["val", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " is always evaluated once immediately after the evaluation of ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["f", "TI"], 
    StyleBox["start", "TI"]], "[", 
   RowBox[{
    StyleBox["val", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 ", and when it is last evaluated, the value of ",
 Cell[BoxData[
  StyleBox["val", "TI"]], "InlineFormula"],
 " is always the same as in ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["f", "TI"], 
    StyleBox["end", "TI"]], "[", 
   RowBox[{
    StyleBox["val", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32518],

Cell[TextData[{
 "Interactive operations that can affect ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " objects include dragging of elements in graphics or in objects such as ",
 Cell[BoxData[
  ButtonBox["Slider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider"]], "InlineFormula"],
 ", as well as editing of fields in objects such as ",
 Cell[BoxData[
  ButtonBox["InputField",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputField"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3140],

Cell[TextData[{
 "The functions ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["f", "TI"], 
   StyleBox["start", "TI"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["f", "TI"], 
   StyleBox["end", "TI"]]], "InlineFormula"],
 " can be the following: "
}], "Notes",
 CellID->17103],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "assign values using ",
     Cell[BoxData[
      ButtonBox["Set",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Set"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "perform no action ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Temporary",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Temporary"], Cell[
    "allow interactive operations to make temporary changes ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["func", "TI"], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      RowBox[{
       StyleBox["func", "TI"], "[", 
       RowBox[{
        StyleBox["val", "TI"], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"]
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->7245],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["f", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["None",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/None"], ",", 
      StyleBox["f", "TI"], ",", 
      ButtonBox["None",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/None"]}], "}"}]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4257],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    ButtonBox["Temporary",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Temporary"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["None",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/None"], ",", 
      ButtonBox["Temporary",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Temporary"], ",", 
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]}], "}"}]}], "]"}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->2216],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["f", "TI"]}], "]"}]], "InlineFormula"],
 " can be used to enforce constraints on values assigned to ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23357],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["f", "TI"]}], "]"}]], "InlineFormula"],
 " can be used to do assignments for individual variables when ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is an expression like ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "+", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18037],

Cell[TextData[{
 "A function ",
 Cell[BoxData[
  RowBox[{
   StyleBox["func", "TI"], "[", 
   RowBox[{
    StyleBox["val", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " should have attribute ",
 Cell[BoxData[
  ButtonBox["HoldRest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldRest"]], "InlineFormula"],
 " if it is going to perform an assignment to ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". This can be achieved with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Function",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Function"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["v", "TI"], ",", 
      StyleBox["e", "TI"]}], "}"}], ",", 
    StyleBox["body", "TI"], ",", 
    ButtonBox["HoldRest",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/HoldRest"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25365],

Cell["The following options can be given: ", "Notes",
 CellID->7373],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Deinitialization",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Deinitialization"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "an expression to evaluate when the ",
     Cell[BoxData[
      ButtonBox["Dynamic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
     " can no longer be displayed"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Editable",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Editable"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether to allow the textual display of ",
     Cell[BoxData[
      ButtonBox["Dynamic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
     " to be edited "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Evaluator",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Evaluator"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the kernel to use for evaluations ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Initialization",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Initialization"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "an expression to evaluate when the ",
     Cell[BoxData[
      ButtonBox["Dynamic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
     " is first displayed"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ShrinkingDelay",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ShrinkingDelay"], "0.", Cell["\<\
how long to delay before shrinking if the displayed object gets smaller \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TrackedSymbols",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TrackedSymbols"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "symbols whose changes trigger an update", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["UpdateInterval",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/UpdateInterval"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[
    "time interval at which to do updates", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->397],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   StyleBox["e", "TI"], "]"}]], "InlineFormula"],
 " displays as the dynamically updated current value of ",
 Cell[BoxData[
  StyleBox["e", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ", but just as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   StyleBox["e", "TI"], "]"}]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7048],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " provides an analog of delayed assignment, where values are implicitly \
requested by the need to display, rather than by evaluation of an expression. \
"
}], "Notes",
 CellID->15124]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->253961593],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->127742867],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " simply returns the current value of its argument:"
}], "ExampleText",
 CellID->129669118],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", "x", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->147434189],

Cell[BoxData[
 DynamicBox[ToBoxes[$CellContext`x, StandardForm],
  ImageSizeCache->{7., {0., 6.}}]], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1877769532]
}, Open  ]],

Cell[TextData[{
 "Assign a value to ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " to update the output above:"
}], "ExampleText",
 CellID->1913796441],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", "0.5"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->252848012],

Cell[BoxData["0.5`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1663296061]
}, Open  ]],

Cell[TextData[{
 "Tie the symbol ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " to a ",
 Cell[BoxData[
  ButtonBox["Slider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->166719121],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Slider", "[", 
  RowBox[{"Dynamic", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->504393992],

Cell[BoxData[
 SliderBox[Dynamic[$CellContext`x]]], "Output",
 ImageSize->{204, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1222264228]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(18)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30229],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Basic Dynamic",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1134200337],

Cell[TextData[{
 "Any expression can be wrapped with ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->462656750],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "+", "x"}], ",", "\"\<string\>\"", ",", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"Disk", "[", "]"}]}], "}"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->225929272],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   DynamicBox[ToBoxes[1 + $CellContext`x, StandardForm],
    ImageSizeCache->{26.625, {0., 8.}}], ",", 
   DynamicBox[ToBoxes["string", StandardForm],
    ImageSizeCache->{42., {2., 8.}}], ",", 
   DynamicBox[ToBoxes[
     Graphics[{
       RGBColor[1, 0, 0], 
       Disk[{0, 0}]}, ImageSize -> Tiny], StandardForm],
    ImageSizeCache->{100., {48., 52.}}]}], "}"}]], "Output",
 ImageSize->{209, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->127331943]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " is not shown in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", but still present: "
}], "ExampleText",
 CellID->185017855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "/@", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->235491870],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"Dynamic", "[", 
      RowBox[{"1", " ", "+", " ", "x"}], "]"}],
     ShowStringCharacters->True,
     NumberMarks->True],
    InputForm[
     Dynamic[1 + $CellContext`x]],
    AutoDelete->True,
    Editable->True], ",", 
   InterpretationBox[
    StyleBox[
     RowBox[{"Dynamic", "[", "\"\<string\>\"", "]"}],
     ShowStringCharacters->True,
     NumberMarks->True],
    InputForm[
     Dynamic["string"]],
    AutoDelete->True,
    Editable->True], ",", 
   InterpretationBox[
    StyleBox[
     RowBox[{"Dynamic", "[", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"RGBColor", "[", 
           RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "]"}], ",", " ", 
          RowBox[{"Disk", "[", 
           RowBox[{"{", 
            RowBox[{"0", ",", " ", "0"}], "}"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"ImageSize", " ", "->", " ", "Tiny"}]}], "]"}], "]"}],
     ShowStringCharacters->True,
     NumberMarks->True],
    InputForm[
     Dynamic[
      Graphics[{
        RGBColor[1, 0, 0], 
        Disk[{0, 0}]}, ImageSize -> Tiny]]],
    AutoDelete->True,
    Editable->True]}], "}"}]], "Output",
 ImageSize->{515, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->520030756]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->882718901],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " to link the currently displayed value depending on ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->10553097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", "n", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1981736507],

Cell[BoxData[
 DynamicBox[ToBoxes[$CellContext`n, StandardForm],
  ImageSizeCache->{7., {0., 6.}}]], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->118326615]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Slider", "[", 
  RowBox[{"Dynamic", "[", "n", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->685876508],

Cell[BoxData[
 SliderBox[Dynamic[$CellContext`n]]], "Output",
 ImageSize->{204, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1848039913]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{"Sin", "[", "t", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", 
      RowBox[{"-", "Pi"}], ",", "n"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1884190814],

Cell[BoxData[
 DynamicBox[ToBoxes[
   NIntegrate[
    Sin[$CellContext`t], {$CellContext`t, -Pi, $CellContext`n}], 
   StandardForm],
  ImageSizeCache->{21.6875, {0., 8.}}]], "Output",
 ImageSize->{26, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->286453359]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetterBar", "[", 
  RowBox[{
   RowBox[{"Dynamic", "[", "n", "]"}], ",", 
   RowBox[{"Range", "[", 
    RowBox[{"0", ",", "1", ",", "0.2"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1721591826],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      SetterBox[Dynamic[$CellContext`n], {0.}, "0.`"], 
      SetterBox[Dynamic[$CellContext`n], {0.2}, "0.2`"], 
      SetterBox[Dynamic[$CellContext`n], {0.4}, "0.4`"], 
      SetterBox[Dynamic[$CellContext`n], {0.6000000000000001}, 
       "0.6000000000000001`"], 
      SetterBox[Dynamic[$CellContext`n], {0.8}, "0.8`"], 
      SetterBox[Dynamic[$CellContext`n], {1.}, "1.`"]}
    },
    BaselinePosition->{1, 1},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Deployed->True],
  SetterBar[
   Dynamic[$CellContext`n], {0., 0.2, 0.4, 0.6000000000000001, 0.8, 
   1.}]]], "Output",
 ImageSize->{152, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->950831230]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}], " ", "x"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "6"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1746643551],

Cell[BoxData[
 DynamicBox[ToBoxes[
   Plot[
    Sin[($CellContext`n + 1) $CellContext`x], {$CellContext`x, 0, 6}], 
   StandardForm],
  ImageSizeCache->{180., {51., 56.}}]], "Output",
 ImageSize->{184, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1914795578]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1926829151],

Cell[TextData[{
 "By default, variables inside ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " are not localized:"
}], "ExampleText",
 CellID->1400835531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1352966097],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[Cell$$1022`x]], ",", 
   DynamicBox[ToBoxes[Cell$$1022`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{244, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1744337843]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " to localize variables:"
}], "ExampleText",
 CellID->1786862104],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"DynamicModule", "[", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Slider", "[", 
        RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
       RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1380062280],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   DynamicModuleBox[{Cell$$1022`x$$ = 0.198}, 
    RowBox[{"{", 
     RowBox[{
      SliderBox[Dynamic[Cell$$1022`x$$]], ",", 
      DynamicBox[ToBoxes[Cell$$1022`x$$, StandardForm],
       ImageSizeCache->{35., {0., 8.}}]}], "}"}],
    DynamicModuleValues:>{}], ",", 
   DynamicBox[ToBoxes[Cell$$1022`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{304, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1883352360]
}, Open  ]],

Cell["And to initialize variables:", "ExampleText",
 CellID->1741641387],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"DynamicModule", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", "=", "0.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Slider", "[", 
        RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
       RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1564682699],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   DynamicModuleBox[{Cell$$1022`x$$ = 0.372}, 
    RowBox[{"{", 
     RowBox[{
      SliderBox[Dynamic[Cell$$1022`x$$]], ",", 
      DynamicBox[ToBoxes[Cell$$1022`x$$, StandardForm],
       ImageSizeCache->{35., {0., 8.}}]}], "}"}],
    DynamicModuleValues:>{}], ",", 
   DynamicBox[ToBoxes[Cell$$1022`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{304, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1684864578]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->799593104],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " expression can be self-triggering: "
}], "ExampleText",
 CellID->653348606],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "1"}], "}"}], ",", 
   RowBox[{"Dynamic", "[", 
    RowBox[{"x", "=", 
     RowBox[{"Max", "[", 
      RowBox[{"0", ",", 
       RowBox[{"x", "-", "0.01"}]}], "]"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->675788820],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 0}, 
  DynamicBox[
   ToBoxes[$CellContext`x$$ = Max[0, $CellContext`x$$ - 0.01], StandardForm],
   ImageSizeCache->{7., {0., 8.}}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->615142237]
}, Open  ]],

Cell[TextData[{
 "Use with ",
 Cell[BoxData[
  ButtonBox["Slider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->154406897],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Slider", "[", 
      RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"x", "=", 
       RowBox[{"Max", "[", 
        RowBox[{"0", ",", 
         RowBox[{"x", "-", "0.01"}]}], "]"}]}], "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->956472303],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 0}, 
  RowBox[{"{", 
   RowBox[{
    SliderBox[Dynamic[$CellContext`x$$]], ",", 
    DynamicBox[
     ToBoxes[$CellContext`x$$ = Max[0, $CellContext`x$$ - 0.01], 
      StandardForm],
     ImageSizeCache->{7., {0., 8.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{237, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1458013505]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->126768319],

Cell[TextData[{
 "Expressions such ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
 " do not automatically update: "
}], "ExampleText",
 CellID->409555517],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"RandomReal", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->993957327],

Cell[BoxData[
 DynamicBox[ToBoxes[
   RandomReal[], StandardForm],
  ImageSizeCache->{56., {0., 8.}}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->85148940]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"DateString", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->181826107],

Cell[BoxData[
 DynamicBox[ToBoxes[
   DateString[], StandardForm],
  ImageSizeCache->{168., {2., 8.}}]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->831121464]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["UpdateInterval",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UpdateInterval"]], "InlineFormula"],
 " to force dynamic updating: "
}], "ExampleText",
 CellID->133007559],

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", "]"}], ",", 
   RowBox[{"UpdateInterval", "\[Rule]", 
    RowBox[{"1", "/", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->124520871],

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{
   RowBox[{"DateString", "[", "]"}], ",", 
   RowBox[{"UpdateInterval", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->382801950]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Placing Dynamic",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->325153917],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " needs specific numerical values to create the output:"
}], "ExampleText",
 CellID->1559369472],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Slider", "[", 
      RowBox[{
       RowBox[{"Dynamic", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{
         RowBox[{"Dynamic", "[", "x", "]"}], "i"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", 
         RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->432287916],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 1.}, 
  RowBox[{"{", 
   RowBox[{
    SliderBox[Dynamic[$CellContext`x$$], {1, 5}], ",", 
    GraphicsBox[
     GraphicsComplexBox[{{1.2822827157509358`*^-7, 0.}, {0.1233305156610618, 
      0.}, {0.2570347881802097, 0.}, {0.3818787050494512, 0.}, {
      0.504273679847541, 0.}, {0.6370425397319885, 0.}, {0.7609510439665297, 
      0.}, {0.8952334332874284, 0.}, {1.0270668805371757`, 0.}, {
      1.1500399721370163`, 0.}, {1.2833869488232146`, 0.}, {
      1.4078735698595066`, 0.}, {1.529911248824647, 0.}, {1.662322812876145, 
      0.}, {1.7858740212777366`, 0.}, {1.9197991147656859`, 0.}, {
      2.0512752661824836`, 0.}, {2.1738910619493748`, 0.}, {2.306880742802624,
       0.}, {2.4310100680059663`, 0.}, {2.5655132782956667`, 0.}, {
      2.697567546514215, 0.}, {2.820761459082857, 0.}, {2.954329256737857, 
      0.}, {3.0790366987429505`, 0.}, {3.2012951986768923`, 0.}, {
      3.3339275836971916`, 0.}, {3.4576996130675846`, 0.}, {
      3.5918455275243355`, 0.}, {3.7235424999099345`, 0.}, {3.846379116645627,
       0.}, {3.9795896184676773`, 0.}, {4.103939764639821, 0.}, {
      4.225840968740814, 0.}, {4.358116057928164, 0.}, {4.481530791465609, 
      0.}, {4.615319410089411, 0.}, {4.7402476730633065`, 0.}, {
      4.86272699396605, 0.}, {4.9955801999551515`, 0.}, {5.119573050294346, 
      0.}, {5.253939785719899, 0.}, {5.3858575790743, 0.}, {5.508915016778795,
       0.}, {5.642346339569648, 0.}, {5.766917306710594, 0.}, {
      5.889039331780388, 0.}, {6.02153524193654, 0.}, {6.145170796442786, 
      0.}, {6.279180236035389, 0.}, {6.283185178951315, 0.}}, {}],
     AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
     Axes->True,
     AxesOrigin->{0, 0},
     PlotRange->
      NCache[{{0, 2 Pi}, {0., 0.}}, {{0, 6.283185307179586}, {0., 0.}}],
     PlotRangeClipping->True,
     PlotRangePadding->{
       Scaled[0.02], 
       Scaled[0.02]}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{410, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->750321621]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Slider", "[", 
      RowBox[{
       RowBox[{"Dynamic", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"x", " ", "i"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "0", ",", 
          RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->525826411],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 2.9699999999999998`}, 
  RowBox[{"{", 
   RowBox[{
    SliderBox[Dynamic[$CellContext`x$$], {1, 5}], ",", 
    DynamicBox[ToBoxes[
      Plot[
       Sin[$CellContext`x$$ $CellContext`i], {$CellContext`i, 0, 2 Pi}], 
      StandardForm],
     ImageSizeCache->{180., {51., 56.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{410, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->107802518]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->744802882],

Cell[TextData[{
 "Separate ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " expressions update independently allowing for efficiency:"
}], "ExampleText",
 CellID->219859411],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"n", " ", "m"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"m", ",", "0", ",", "4"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1505247837],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Slider", "[", 
  RowBox[{"Dynamic", "[", "y", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->185253176],

Cell[BoxData[
 SliderBox[Dynamic[$CellContext`y]]], "Output",
 ImageSize->{204, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1846324529]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Dynamic", "[", "x", "]"}], ",", 
      RowBox[{"Dynamic", "[", "y", "]"}]}], "}"}], ",", 
    RowBox[{"Dynamic", "[", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1343034799],

Cell[BoxData[
 TabViewBox[{{1,"1"->
  RowBox[{"{", 
   RowBox[{
    DynamicBox[ToBoxes[$CellContext`x, StandardForm],
     ImageSizeCache->{7., {0., 6.}}], ",", 
    DynamicBox[ToBoxes[$CellContext`y, StandardForm],
     ImageSizeCache->{14., {0., 8.}}]}], "}"}]}, {2,"2"->
  DynamicBox[ToBoxes[{$CellContext`x, $CellContext`y}, StandardForm],
   ImageSizeCache->{46.1875, {2., 8.}}]}}, 2]], "Output",
 ImageSize->{65, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->37659753]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->545449395],

Cell[TextData[{
 "Use graphics coordinates as control input by placing ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " around them:"
}], "ExampleText",
 CellID->4032069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"DynamicModule", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p", "=", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"Framed", "@", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Locator", "[", 
          RowBox[{"Dynamic", "[", "p", "]"}], "]"}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "1"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Dynamic", "[", "p", "]"}]}]}], "]"}]}]}], "]"}], ",", 
   RowBox[{"DynamicModule", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p", "=", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"Framed", "@", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Dynamic", "[", 
          RowBox[{"Locator", "[", "p", "]"}], "]"}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "1"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Dynamic", "[", "p", "]"}]}]}], "]"}]}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->256970229],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   DynamicModuleBox[{$CellContext`p$$ = {0.05369127516778598, 
    0.0536912751677856}}, 
    FrameBox[
     GraphicsBox[LocatorBox[Dynamic[$CellContext`p$$]],
      PlotLabel->FormBox[
        DynamicBox[
         ToBoxes[$CellContext`p$$, TraditionalForm]], TraditionalForm],
      PlotRange->1],
     StripOnInput->False],
    DynamicModuleValues:>{}], ",", 
   DynamicModuleBox[{$CellContext`p$$ = {0, 0}}, 
    FrameBox[
     GraphicsBox[
      DynamicBox[Typeset`ToBoxes[
        Locator[$CellContext`p$$], StandardForm, Graphics],
       ImageSizeCache->{{66., 83.}, {-2., 15.}}],
      PlotLabel->FormBox[
        DynamicBox[
         ToBoxes[$CellContext`p$$, TraditionalForm]], TraditionalForm],
      PlotRange->1],
     StripOnInput->False],
    DynamicModuleValues:>{}]}], "}"}]], "Output",
 ImageSize->{350, 181},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->188011249]
}, Open  ]],

Cell["\<\
Use the graphics coordinates as control input and see effects on 2D sliders: \
\
\>", "ExampleText",
 CellID->421406127],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"p1", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"p2", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], ",", 
     RowBox[{"p3", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Framed", "@", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Dynamic", "[", "p1", "]"}], ",", 
           RowBox[{"Dynamic", "[", "p2", "]"}], ",", 
           RowBox[{"Dynamic", "[", "p3", "]"}]}], "}"}], "]"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}]}], ",", 
     RowBox[{"Column", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Slider2D", "[", 
         RowBox[{"#", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], "&"}], "/@", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Dynamic", "[", "p1", "]"}], ",", 
         RowBox[{"Dynamic", "[", "p2", "]"}], ",", 
         RowBox[{"Dynamic", "[", "p3", "]"}]}], "}"}]}], "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->679412405],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`p1$$ = {0, 0}, $CellContext`p2$$ = {1, 
  0}, $CellContext`p3$$ = {0, 1}}, 
  RowBox[{"{", 
   RowBox[{
    FrameBox[
     GraphicsBox[
      PolygonBox[{
       Dynamic[$CellContext`p1$$], Dynamic[$CellContext`p2$$], 
        Dynamic[$CellContext`p3$$]}],
      PlotRange->1],
     StripOnInput->False], ",", 
    TagBox[GridBox[{
       {
        Slider2DBox[Dynamic[$CellContext`p1$$], {-1, 1}]},
       {
        Slider2DBox[Dynamic[$CellContext`p2$$], {-1, 1}]},
       {
        Slider2DBox[Dynamic[$CellContext`p3$$], {-1, 1}]}
      },
      ColumnsEqual->False,
      GridBoxAlignment->{"Columns" -> {{Left}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
      RowsEqual->False],
     "Column"]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{302, 255},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->99991264]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Interactive Dynamic",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->798486387],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " to connect variables with interactive controls, such as ",
 Cell[BoxData[
  ButtonBox["Slider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1083413066],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->409557349],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`x]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{244, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1392618813]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1654044071],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Slider2D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider2D"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->342890882],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider2D", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1268428873],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Slider2DBox[Dynamic[$CellContext`x]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{124, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->413904742]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1914975007],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InputField",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputField"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1729237152],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InputField", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->745276008],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InputFieldBox[Dynamic[$CellContext`x]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{305, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->647525060]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->797466161],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   ButtonBox["ColorSlider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorSlider"], TraditionalForm]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->568327000],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ColorSlider", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2012110791],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ColorSetterBox[Dynamic[$CellContext`x], "SwatchSpectrum"], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{204, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2033960465]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1033042098],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PopupMenu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupMenu"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2080738738],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PopupMenu", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"Range", "[", "10", "]"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1352261818],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   PopupMenuBox[Dynamic[$CellContext`x], {1->"1", 2->"2", 3->"3", 4->"4", 5->
    "5", 6->"6", 7->"7", 8->"8", 9->"9", 10->"10"}], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{86, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1464436492]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1128842309],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Locator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Locator"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1582149765],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Locator", "[", 
        RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], ",", 
     RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1048583201],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = {0, 0}}, 
  RowBox[{"{", 
   RowBox[{
    GraphicsBox[LocatorBox[Dynamic[$CellContext`x$$]],
     PlotRange->1], ",", 
    DynamicBox[ToBoxes[$CellContext`x$$, StandardForm],
     ImageSizeCache->{39.1875, {2., 8.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{249, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2026410891]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1587276453],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " to control view elements, such as ",
 Cell[BoxData[
  ButtonBox["TabView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TabView"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1012243777],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"Disk", "[", "]"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "t"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "20", ",", "30", ",", "40"}], "}"}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->415708505],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[DiskBox[{0, 0}],
    ImageSize->10], ",", 
   GraphicsBox[DiskBox[{0, 0}],
    ImageSize->20], ",", 
   GraphicsBox[DiskBox[{0, 0}],
    ImageSize->30], ",", 
   GraphicsBox[DiskBox[{0, 0}],
    ImageSize->40]}], "}"}]], "Output",
 ImageSize->{152, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1048539844]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"TabView", "[", 
    RowBox[{"d", ",", 
     RowBox[{"Dynamic", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->558350826],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TabViewBox[{{1,"1"->
    GraphicsBox[DiskBox[{0, 0}],
     ImageSize->10]}, {2,"2"->
    GraphicsBox[DiskBox[{0, 0}],
     ImageSize->20]}, {3,"3"->
    GraphicsBox[DiskBox[{0, 0}],
     ImageSize->30]}, {4,"4"->
    GraphicsBox[DiskBox[{0, 0}],
     ImageSize->40]}}, Dynamic[$CellContext`x]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{134, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1846278839]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FlipView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FlipView"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1669868113],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"FlipView", "[", 
    RowBox[{"d", ",", 
     RowBox[{"Dynamic", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->9592548],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    TogglerBox[Dynamic[$CellContext`x], {1->
     TagBox[
      GraphicsBox[DiskBox[{0, 0}],
       ImageSize->10],
      "ResetImageSizeLevel"], 2->
     TagBox[
      GraphicsBox[DiskBox[{0, 0}],
       ImageSize->20],
      "ResetImageSizeLevel"], 3->
     TagBox[
      GraphicsBox[DiskBox[{0, 0}],
       ImageSize->30],
      "ResetImageSizeLevel"], 4->
     TagBox[
      GraphicsBox[DiskBox[{0, 0}],
       ImageSize->40],
      "ResetImageSizeLevel"]},
     ImageSize->Automatic],
    FlipView[{
      Graphics[
       Disk[{0, 0}], ImageSize -> 10], 
      Graphics[
       Disk[{0, 0}], ImageSize -> 20], 
      Graphics[
       Disk[{0, 0}], ImageSize -> 30], 
      Graphics[
       Disk[{0, 0}], ImageSize -> 40]}, 
     Dynamic[$CellContext`x]]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{59, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->160680711]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PopupView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupView"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1173765498],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PopupView", "[", 
    RowBox[{"d", ",", 
     RowBox[{"Dynamic", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->691943544],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    PopupMenuBox[Dynamic[$CellContext`x], {1->
     TagBox[
      GraphicsBox[DiskBox[{0, 0}],
       ImageSize->10],
      {"ResetImageSizeLevel", 2}], 2->
     TagBox[
      GraphicsBox[DiskBox[{0, 0}],
       ImageSize->20],
      {"ResetImageSizeLevel", 2}], 3->
     TagBox[
      GraphicsBox[DiskBox[{0, 0}],
       ImageSize->30],
      {"ResetImageSizeLevel", 2}], 4->
     TagBox[
      GraphicsBox[DiskBox[{0, 0}],
       ImageSize->40],
      {"ResetImageSizeLevel", 2}]}],
    PopupView[{
      Graphics[
       Disk[{0, 0}], ImageSize -> 10], 
      Graphics[
       Disk[{0, 0}], ImageSize -> 20], 
      Graphics[
       Disk[{0, 0}], ImageSize -> 30], 
      Graphics[
       Disk[{0, 0}], ImageSize -> 40]}, 
     Dynamic[$CellContext`x]]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{114, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->871195503]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OpenerView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenerView"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->639313675],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"OpenerView", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Disk", ",", "d"}], "}"}], ",", 
     RowBox[{"Dynamic", "[", "t", "]"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "t", "]"}]}], "}"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1084249784],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     PaneSelectorBox[{False->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[$CellContext`t],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], "Disk"}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"], True->
      TagBox[GridBox[{
         {
          OpenerBox[Dynamic[$CellContext`t],
           Appearance->Automatic,
           AutoAction->False,
           ContinuousAction->False,
           Enabled->Automatic], "Disk"},
         {"", 
          PaneBox[
           RowBox[{"{", 
            RowBox[{
             GraphicsBox[DiskBox[{0, 0}],
              ImageSize->10], ",", 
             GraphicsBox[DiskBox[{0, 0}],
              ImageSize->20], ",", 
             GraphicsBox[DiskBox[{0, 0}],
              ImageSize->30], ",", 
             GraphicsBox[DiskBox[{0, 0}],
              ImageSize->40]}], "}"}],
           ImageMargins->0]}
        },
        BaselinePosition->{1, 1},
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxBackground->{"Columns" -> {{Automatic}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{0.2}}, "Rows" -> {{0.5}}},
        RowsEqual->False],
       "Grid"]}, Dynamic[$CellContext`t],
      Alignment->Automatic,
      BaselinePosition->Baseline,
      DefaultBaseStyle->"OpenerView",
      ImageMargins->0,
      ImageSize->Automatic],
     Deployed->False,
     StripOnInput->False],
    OpenerView[{Disk, {
       Graphics[
        Disk[{0, 0}], ImageSize -> 10], 
       Graphics[
        Disk[{0, 0}], ImageSize -> 20], 
       Graphics[
        Disk[{0, 0}], ImageSize -> 30], 
       Graphics[
        Disk[{0, 0}], ImageSize -> 40]}}, 
     Dynamic[$CellContext`t]]], ",", 
   DynamicBox[ToBoxes[$CellContext`t, StandardForm],
    ImageSizeCache->{35., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{65, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->185588106]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Advanced Dynamic",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->83214827],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " performs an assignment operation when used in interactive elements:"
}], "ExampleText",
 CellID->1540782990],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1581897404],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`x]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{244, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->370969041]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{"Dynamic", "[", 
     RowBox[{"y", ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"y", "=", "#"}], ")"}], "&"}]}], "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "y", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1102119168],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`y, ($CellContext`y = #)& ]], ",", 
   DynamicBox[ToBoxes[$CellContext`y, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{244, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3018916]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{"Dynamic", "[", 
     RowBox[{"z", ",", "Automatic"}], "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "z", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->297326175],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`z, Automatic]], ",", 
   DynamicBox[ToBoxes[$CellContext`z, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{244, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->82401355]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1270401201],

Cell["\<\
Use the second argument to specify a function to be evaluated during \
interaction:\
\>", "ExampleText",
 CellID->1350566733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"col", "=", "None"}], ";", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Slider", "[", 
     RowBox[{
      RowBox[{"Dynamic", "[", 
       RowBox[{"x", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"col", "=", "Blue"}], ";", 
           RowBox[{"x", "=", "#"}]}], ")"}], "&"}]}], "]"}], ",", 
      RowBox[{"Background", "\[Rule]", 
       RowBox[{"Dynamic", "[", "col", "]"}]}]}], "]"}], ",", 
    RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->72932741],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[
    Dynamic[$CellContext`x, ($CellContext`col = Blue; $CellContext`x = #)& ],
    Background->Dynamic[$CellContext`col]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{244, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->844600452]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2017490552],

Cell["\<\
Supply a list of two functions to be evaluated during and after interaction: \
\
\>", "ExampleText",
 CellID->1344404981],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"col", "=", "None"}], ";", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Slider", "[", 
     RowBox[{
      RowBox[{"Dynamic", "[", 
       RowBox[{"x", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"col", "=", "Blue"}], ";", 
             RowBox[{"x", "=", "#"}]}], ")"}], "&"}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"col", "=", "Green"}], ")"}], "&"}]}], "}"}]}], "]"}], 
      ",", 
      RowBox[{"Background", "\[Rule]", 
       RowBox[{"Dynamic", "[", "col", "]"}]}]}], "]"}], ",", 
    RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1739065580],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[
    Dynamic[$CellContext`x, {($CellContext`col = 
       Blue; $CellContext`x = #)& , ($CellContext`col = Green)& }],
    Background->Dynamic[$CellContext`col]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{244, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->418265062]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1482901561],

Cell["\<\
Supply a list of three functions to be evaluated before, during and after \
interaction:\
\>", "ExampleText",
 CellID->1578812292],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "0.5"}], ";", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Slider", "[", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"x", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"y", "=", "x"}], ")"}], "&"}], ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"x", "=", "#"}], ")"}], "&"}], ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"x", "=", "y"}], ")"}], "&"}]}], "}"}]}], "]"}], "]"}], 
    ",", 
    RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->790249312],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[
    Dynamic[$CellContext`x, {($CellContext`y = $CellContext`x)& , \
($CellContext`x = #)& , ($CellContext`x = $CellContext`y)& }]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{244, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->58576704]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->765482477],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Temporary",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Temporary"]], "InlineFormula"],
 " to update the dynamic variable at the end of interaction:"
}], "ExampleText",
 CellID->2036945409],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{"Dynamic", "[", 
     RowBox[{"x", ",", "Temporary"}], "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1904672236],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`x, Temporary]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{244, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->131294433]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->34927691],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " to disallow updating the dynamic variable:"
}], "ExampleText",
 CellID->766667006],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{"Dynamic", "[", 
     RowBox[{"x", ",", "None"}], "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->470487842],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`x, None]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{244, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->182388948]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->877682495],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Deinitialization",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->631375571],

Cell["\<\
Specify expressions to be evaluated when output is no longer displayed:\
\>", "ExampleText",
 CellID->1669458155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDialog", "[", 
   RowBox[{"Dynamic", "[", 
    RowBox[{
     RowBox[{"f", "[", "Pink", "]"}], ",", 
     RowBox[{"Initialization", "\[RuleDelayed]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"f", "[", "x_", "]"}], ":=", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], ")"}]}], ",", 
     RowBox[{"Deinitialization", "\[RuleDelayed]", 
      RowBox[{"CreateDialog", "[", 
       RowBox[{"f", "[", "Blue", "]"}], "]"}]}]}], "]"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1968973087],

Cell[BoxData[
 RowBox[{
  GraphicsBox[RasterBox[CompressedData["
1:eJztnflTE1ccwJ3pX9J/pe3PdabjT+1MFaeCtuN02p87HUcqFsFWQAIIhJJy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    "], {{0, 0}, {124, 134}}, {0, 255}],
   ImageSize->{124 0.75, 134 0.75},
   PlotRange->{{0, 124}, {0, 134}}], 
  GraphicsBox[RasterBox[CompressedData["
1:eJztnUlMG1cYgJF64JZbblyq3LjllhtSW3GjkSpORWrAKhBaRaQ9JJcmhwiS
NtCqQAKBAAXKmo0AhVASlrA4xmYJBoJxWKbYkLAvwQTCMv1nxh6MWTz7m+Wh
D+u9mTcW7+PNW2bem/nclPyN6bOQkJCb8PsL/FLhhITrGOXZ3tnFKAbrvLLq
OUYBApwjP910z5HOiUkXRibYOhw7x851jFac2wemKyvmrl9bvpy8eu7c5pkz
2yEh5HHAXkiTlLR29coKHGWzziD/+7XifNThLi6aB3Xh4Z9OMMwF+C+YTB/y
chfgf4c8X+p0DqqjojyhoXsiVR9JZORGVuYids7Q2fEOSuPp0ztyqA7g1Knd
mJj15hfvDOscbEdHryug+shi31D/3lDOoaShso3KPELn0ERCJ0SmSlsYULMp
0Miicg6tZFjYSf09VEBrkp62pDPnULyh8ULu9mSgqpGvwCvsHDICoxXkSrkA
XXpo2bXuHBopddYnxwH9SRjGatc5jAEhC8g1CuD6tWUtOr96ZQW5OjFAbxaa
Ia04hz8VRvHIpYnn7NktqVpVuZ2rv4vCS7skpV1W51ATIhclLVCE1OwcRj3I
FcmB+CZVJufNL95ptJcSlNDQPZEdSDmcQ1tz8n0crQPFScxwSQ7nEREfkWuR
GyhUgttTyZ2bTB+QC1GGyMgNNTivfjKLXIWSCLvHJ61z8TeLtcXp0zsCahgJ
neuvN84FqEtRObdZZ/TaOTwZ6DryvaknlXPjNJ2H4duYSuIcCrmqbmsqD6+i
LolzIxdyBl5FXbxzXMgZuE9PEu88NWUJeX7VQFLSmmLOz57dQp5fNQB9dWWc
wwmFPLPqobhoXgHncEIhz6l6iIryKOBcW3Mn5Ab6ElwuBYhx3tmBK5ZAuNzO
EOM8PQ33WAK5nLwqq3N9TKKQFujFyercmBe1ghJ0Goxg5zD8RJ47dVL9ZFYm
59BYIM+dOgk6fV2wczzkP46gFwEEO8ejoeMIOjIS7DwycgN57tRJePgnmZxr
ZbmE8sDYHDvXjXN8peUEsHPdOFdmVb5GweVcN871PdtZDKGhe7jfojC4r6gn
5/ji+XEEvYQu2Pnl5FXkuVMn0dFB1tYJdp6VuYg8d+rk6pUVmZwbbUkFd4Iu
vhDs3D4wjTx36iToHF0x90PxsOgwXKa4iHGup7X8UhER8TGoNzHO83IXkOdR
bXBZmS7GOa7SD8NlwYXI+Yp4IrQ/HKdDi3RuzPWJx8Fx3aJI53hhiz8cV3KJ
dE7gCQA+gt7ul9A5vgjAwP1ZOuKdwxAA36eDCpb72wTEOydwS8pz1b8kzg1e
1HkVcqmcG7yo8320hVTOoagb8640nOB83wsjlXNCvw/3O5nUFN4PS5fQOWG8
vjr3Prl8zo02LBX2CgxpnRNGGiIFve+pmHPCGEswOC4zV8w5ofeKXeQDomVy
Dn+SXp/7B51Dke+5kMk5QT8NQH+DU+ghBF3+idA5Qc+B0Vk3RpKXA8rqnNBX
N0bA4yuROGe066C0c3lghXqcE3Qlo926HQqMtO8bVcY5QTepWuzJhIVtS/6+
RcWcExp8bw70w+V4l7SSzhm0MnFd2vdAoXVO0K2qmp+3AxW45O87Q+6coK9A
qrOeiYj4KPdLolE5Z6ismFPP3SXoWeXlLiiQa7TOCbphTU9bQjuVHWxDZSJT
7a1C5yxIzCtsW23OGeDshnpegXFrZOSGtCMd7TpnsA9Mp6YsybHsF8ZlULDl
6HVr3TkLnPXFRfMm0wcxY1hopmNi1uEMUuA98jpwHgAMw6GrA6MqcAhnwXHA
XkgD/yzx17qxc32AnWPnRgA7x86NAHaOnRsB7Bw7NwLYOVrnP15KGx8jauos
t9NKMbKy/WnbbBn56eeMhEu/g3NgdHQCIyv+zkcdLpLc3d3dwcjH3u6Ov/M3
w1Pb2zuejU1gg8Yb9sDnFhv1eLwJYCObmA37s6HBqICc3suvKoj+ovz8l2Xn
vzoMbIe9kIY5cHNzy+PZYp3bByZX1zwLi6sLiyv056ovvBIYXvJPwKZnN64d
3KuhqJCc1kZ/vZN1hywqIQsLj6CoBPZCGubAxSXqENZ5f//YzPvFKff8lGt2
yjVHwYTdDHNeXHTY5Yd31yyV3s1umfcGNBR1Ccnp28Q4sqGerH5wLA31kIY5
1jU973IvsM5tPc6xyZnRt64AnN6Ae3+j82CUCk/5pZlyHvgGzUX55dSZEEfW
1pAPK0jmBwIMbLS2BtLQh7idY+634zOsc0u3Y3B4cmBwHHg9RH8O7n/6B45i
gk3jn15zUQE5DXQOP4/8wj7nzFH2ofGhN/+xziFg63NYe0e6e0esPSPdPQ6L
zdFNBSAKAQfzSW+B8IiV2WujEnT3OryBHvpYOmzRWtTqyyOvnDoTYsnaavJB
GUXAT/lfZFkh+aQKnHcz39nr6Hs9xjrvMg93mgc7KOwdXXYq0DXYbmYCsIXa
1c4k6PJ9+mj3Ru2+BFT6dg1GBeR09PsLlO2S+2RJHlmcuy+8MJssuEPezwTt
o/EXfIfYLVZH68sBxnmnebilrZ+l+SUdeNlHR6nP5rY+/wTeZL69TLLmA1s0
GeWbU8p5aQGZm0Heywgs51m/k5npZEEuOGe/p9M89E+DhXHe0TXU2NT973Mr
jc0XoGiksHk3NlFhKtpko3dBmE1v86W0ajHauB/mkdPR+FiyMHfnzzTW9NYf
++GN326ROXed8bGNjMkma1v768oHLV7nnUN1Deb6ZxYRvPL7DNiorSiPnFL1
ec7dtVs3Gcnrv95co2Giy6mp5N07kIY9trm1L7+wzud8uLrmVU2dBcOL8Ytx
ZHb2wo0by6kph4HtZE72eGIsk/hpraXpRX9G1gOv8443jx52PnlsxvCiL+lb
Mi+HzAGyjyA7m8zL7/nhOybx40fmZw19t9NKGedtbYMlxc3lpa0YXtzLr+qP
j5lIMo0lxh1m4mJcX2IcpGESl/3d8rTagp0rCXaOnRuBAOftHYOlJc0V5a0Y
+Sgva6mt2Xfuci+NT8yNT8xiZGV6eoV1jlEScP4/uYBilg==
    "], {{0, 0}, {124, 134}}, {0, 255}],
   ImageSize->{124 0.75, 134 0.75},
   PlotRange->{{0, 124}, {0, 134}}]}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->279801952]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Editable",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->29310839],

Cell["By default the output is not editable:", "ExampleText",
 CellID->1599517431],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", "\"\<not editable\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1999327117],

Cell[BoxData[
 DynamicBox[ToBoxes["not editable", StandardForm],
  ImageSizeCache->{84., {1., 8.}}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->464861375]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2083444671],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  ButtonBox["Editable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Editable"]], "InlineFormula"],
 ", force the output to be editable:"
}], "ExampleText",
 CellID->889169671],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"\"\<editable\>\"", ",", 
   RowBox[{"Editable", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1014230810],

Cell[BoxData[
 DynamicBox[ToBoxes["editable", StandardForm],
  Editable->True,
  ImageSizeCache->{56., {0., 8.}}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->70470421]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Initialization",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->164404388],

Cell["\<\
By default, external definitions are lost between kernel sessions:\
\>", "ExampleText",
 CellID->395078386],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"Range", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->313154021],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"f", "[", "10", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->80771275],

Cell[BoxData[
 DynamicBox[ToBoxes[
   $CellContext`f[10], StandardForm],
  ImageSizeCache->{35., {2., 8.}}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1401624836]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->62996978],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Initialization",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Initialization"]], "InlineFormula"],
 " to evaluate expressions necessary for displaying the output:"
}], "ExampleText",
 CellID->753629656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{
   RowBox[{"g", "[", "10", "]"}], ",", 
   RowBox[{"Initialization", "\[RuleDelayed]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"g", "[", "x_", "]"}], ":=", 
      RowBox[{"Range", "[", "x", "]"}]}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1622834690],

Cell[BoxData[
 DynamicBox[ToBoxes[
   $CellContext`g[10], StandardForm],
  ImageSizeCache->{191.6875, {2., 8.}},
  Initialization:>($CellContext`g[
     Pattern[$CellContext`x, 
      Blank[]]] := Range[$CellContext`x])]], "Output",
 ImageSize->{196, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1360494709]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ShrinkingDelay",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->291279474],

Cell[TextData[{
 "Assign a number or graphics to ",
 Cell[BoxData[
  FormBox["h", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->1315474446],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetterBar", "[", 
  RowBox[{
   RowBox[{"Dynamic", "[", "h", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"Disk", "[", "]"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "]"}], "\[Rule]", 
      "\"\<Graphics\>\""}], ",", 
     RowBox[{"1", "\[Rule]", "\"\<Number\>\""}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->959375399],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      SetterBox[Dynamic[$CellContext`h], {Graphics[
        Disk[{0, 0}], ImageSize -> Tiny]}, "\<\"Graphics\"\>"], 
      SetterBox[Dynamic[$CellContext`h], {1}, "\<\"Number\"\>"]}
    },
    BaselinePosition->{1, 1},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Deployed->True],
  SetterBar[
   Dynamic[$CellContext`h], {Graphics[
      Disk[{0, 0}], ImageSize -> Tiny] -> "Graphics", 1 -> 
    "Number"}]]], "Output",
 ImageSize->{114, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->338000284]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ShrinkingDelay",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ShrinkingDelay"]], "InlineFormula"],
 " to allow lapse time before shrinking the size of the output:"
}], "ExampleText",
 CellID->1308167234],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Dynamic", "[", "h", "]"}], ",", 
    RowBox[{"Dynamic", "[", 
     RowBox[{"h", ",", 
      RowBox[{"ShrinkingDelay", "\[Rule]", "2"}]}], "]"}]}], "}"}]}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->1034493938],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    DynamicBox[ToBoxes[$CellContext`h, StandardForm],
     ImageSizeCache->{100., {48., 52.}}],
    StripOnInput->False], ",", 
   FrameBox[
    DynamicBox[ToBoxes[$CellContext`h, StandardForm],
     ImageSizeCache->{100., {48., 52.}},
     ShrinkingDelay->2],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{250, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->294269012]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22275],

Cell["Constrain the coordinates of a point to lie on a circle:", "ExampleText",
 CellID->692267766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Dashed", ",", 
       RowBox[{"Circle", "[", "]"}], ",", 
       RowBox[{"PointSize", "[", "0.1", "]"}], ",", 
       RowBox[{"Point", "[", 
        RowBox[{"Dynamic", "[", 
         RowBox[{"p", ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "=", 
             RowBox[{"Normalize", "[", "#", "]"}]}], ")"}], "&"}]}], "]"}], 
        "]"}]}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1.2"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->711458599],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`p$$ = {0, 1}}, 
  GraphicsBox[
   {Dashing[{Small, Small}], CircleBox[{0, 0}], 
    {PointSize[0.1], 
     PointBox[Dynamic[$CellContext`p$$, ($CellContext`p$$ = 
       Normalize[#])& ]]}},
   ImageSize->Tiny,
   PlotRange->1.2],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1343727000]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23281],

Cell["Construct a dynamic calculating interface: ", "ExampleText",
 CellID->9961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "=", "0"}], ",", 
     RowBox[{"b", "=", "0"}], ",", 
     RowBox[{"s", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"5", ",", "30"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "Infinity"}], "}"}]}], "}"}]}]}], "}"}], ",", 
   RowBox[{"Deploy", "[", 
    RowBox[{"Style", "[", 
     RowBox[{
      RowBox[{"Panel", "[", 
       RowBox[{
        RowBox[{"Grid", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Style", "[", 
                RowBox[{"\"\<input a number\>\"", ",", "Red"}], "]"}], ",", 
               RowBox[{"Style", "[", 
                RowBox[{"\"\<input another number\>\"", ",", "Red"}], "]"}], 
               ",", "\"\<here is their sum\>\"", ",", 
               "\"\<their difference\>\"", ",", "\"\<their product\>\""}], 
              "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"InputField", "[", 
                RowBox[{
                 RowBox[{"Dynamic", "[", "a", "]"}], ",", "Number"}], "]"}], 
               ",", 
               RowBox[{"InputField", "[", 
                RowBox[{
                 RowBox[{"Dynamic", "[", "b", "]"}], ",", "Number"}], "]"}], 
               ",", 
               RowBox[{"InputField", "[", 
                RowBox[{
                 RowBox[{"Dynamic", "[", 
                  RowBox[{"a", "+", "b"}], "]"}], ",", 
                 RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}], ",", 
               RowBox[{"InputField", "[", 
                RowBox[{
                 RowBox[{"Dynamic", "[", 
                  RowBox[{"a", "-", "b"}], "]"}], ",", 
                 RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}], ",", 
               RowBox[{"InputField", "[", 
                RowBox[{
                 RowBox[{"Dynamic", "[", 
                  RowBox[{"a", " ", "b"}], "]"}], ",", 
                 RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]}], "}"}]}], 
            "}"}], "]"}], ",", 
          RowBox[{"Alignment", "\[Rule]", "Right"}]}], "]"}], ",", 
        RowBox[{"ImageMargins", "\[Rule]", "10"}]}], "]"}], ",", 
      RowBox[{"DefaultOptions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"InputField", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ContinuousAction", "\[Rule]", "True"}], ",", 
           RowBox[{"FieldSize", "\[Rule]", "s"}]}], "}"}]}], "}"}]}]}], "]"}],
     "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4671],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`a$$ = 0, $CellContext`b$$ = 
  0, $CellContext`s$$ = {{5, 30}, {1, 
    DirectedInfinity[1]}}}, 
  StyleBox[
   PanelBox[
    TagBox[GridBox[{
       {
        StyleBox["\<\"input a number\"\>",
         StripOnInput->False,
         FrontFaceColor->RGBColor[1, 0, 0],
         BackFaceColor->RGBColor[1, 0, 0],
         GraphicsColor->RGBColor[1, 0, 0],
         FontColor->RGBColor[1, 0, 0]], 
        InputFieldBox[Dynamic[$CellContext`a$$], Number]},
       {
        StyleBox["\<\"input another number\"\>",
         StripOnInput->False,
         FrontFaceColor->RGBColor[1, 0, 0],
         BackFaceColor->RGBColor[1, 0, 0],
         GraphicsColor->RGBColor[1, 0, 0],
         FontColor->RGBColor[1, 0, 0]], 
        InputFieldBox[Dynamic[$CellContext`b$$], Number]},
       {"\<\"here is their sum\"\>", 
        InputFieldBox[Dynamic[$CellContext`a$$ + $CellContext`b$$],
         Enabled->False]},
       {"\<\"their difference\"\>", 
        InputFieldBox[Dynamic[$CellContext`a$$ - $CellContext`b$$],
         Enabled->False]},
       {"\<\"their product\"\>", 
        InputFieldBox[Dynamic[$CellContext`a$$ $CellContext`b$$],
         Enabled->False]}
      },
      GridBoxAlignment->{"Columns" -> {{Right}}}],
     "Grid"],
    ImageMargins->10],
   Deployed->True,
   StripOnInput->False,
   InputFieldBoxOptions->{ContinuousAction->True,
   FieldSize->{{5, 30}, {1, 
      DirectedInfinity[1]}}}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{208, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9314507]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->912011704],

Cell[TextData[{
 "Create a timer to track lapsed minutes and seconds, with ",
 Cell[BoxData[
  ButtonBox["Trigger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trigger"]], "InlineFormula"],
 " for controls:"
}], "ExampleText",
 CellID->1589920489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Trigger", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", 
      RowBox[{"x", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "=", 
           RowBox[{"FractionalPart", "[", "#", "]"}]}], ";", 
          RowBox[{"x", "=", 
           RowBox[{"Round", "[", "#", "]"}]}]}], ")"}], "&"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "Infinity"}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Quotient", "[", 
       RowBox[{"x", ",", "60"}], "]"}], ",", 
      RowBox[{"Mod", "[", 
       RowBox[{"x", ",", "60"}], "]"}], ",", 
      RowBox[{"SetPrecision", "[", 
       RowBox[{
        RowBox[{"10", "a"}], ",", "2"}], "]"}]}], "}"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12320488],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   AnimatorBox[
    Dynamic[$CellContext`x, ($CellContext`a = 
      FractionalPart[#]; $CellContext`x = Round[#])& ], {0, 
     DirectedInfinity[1]},
    AnimationRepetitions->1,
    AppearanceElements->{"ResetPlayButton", "PauseButton", "ResetButton"},
    DefaultBaseStyle->{},
    PausedTime->5.406630516052246], ",", 
   DynamicBox[ToBoxes[{
      Quotient[$CellContext`x, 60], 
      Mod[$CellContext`x, 60], 
      SetPrecision[10 $CellContext`a, 2]}, StandardForm],
    ImageSizeCache->{236.75, {2., 8.}}]}], "}"}]], "Output",
 ImageSize->{331, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->215799883]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->79664374],

Cell["\<\
Create a simple interface that looks up the shapes of countries: \
\>", "ExampleText",
 CellID->194087341],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", "c", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PopupMenu", "[", 
      RowBox[{
       RowBox[{"Dynamic", "[", "c", "]"}], ",", 
       RowBox[{"CountryData", "[", "]"}]}], "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"CountryData", "[", 
       RowBox[{"c", ",", "\"\<Shape\>\""}], "]"}], "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->288435266],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`c$$ = "CentralAfricanRepublic"}, 
  RowBox[{"{", 
   RowBox[{
    PopupMenuBox[Dynamic[$CellContext`c$$], {
     "Afghanistan"->"\<\"Afghanistan\"\>", "Albania"->"\<\"Albania\"\>", 
     "Algeria"->"\<\"Algeria\"\>", "AmericanSamoa"->"\<\"AmericanSamoa\"\>", 
     "Andorra"->"\<\"Andorra\"\>", "Angola"->"\<\"Angola\"\>", 
     "Anguilla"->"\<\"Anguilla\"\>", 
     "AntiguaBarbuda"->"\<\"AntiguaBarbuda\"\>", 
     "Argentina"->"\<\"Argentina\"\>", "Armenia"->"\<\"Armenia\"\>", 
     "Aruba"->"\<\"Aruba\"\>", "Australia"->"\<\"Australia\"\>", 
     "Austria"->"\<\"Austria\"\>", "Azerbaijan"->"\<\"Azerbaijan\"\>", 
     "Bahamas"->"\<\"Bahamas\"\>", "Bahrain"->"\<\"Bahrain\"\>", 
     "Bangladesh"->"\<\"Bangladesh\"\>", "Barbados"->"\<\"Barbados\"\>", 
     "Belarus"->"\<\"Belarus\"\>", "Belgium"->"\<\"Belgium\"\>", 
     "Belize"->"\<\"Belize\"\>", "Benin"->"\<\"Benin\"\>", 
     "Bermuda"->"\<\"Bermuda\"\>", "Bhutan"->"\<\"Bhutan\"\>", 
     "Bolivia"->"\<\"Bolivia\"\>", 
     "BosniaHerzegovina"->"\<\"BosniaHerzegovina\"\>", 
     "Botswana"->"\<\"Botswana\"\>", "Brazil"->"\<\"Brazil\"\>", 
     "BritishVirginIslands"->"\<\"BritishVirginIslands\"\>", 
     "Brunei"->"\<\"Brunei\"\>", "Bulgaria"->"\<\"Bulgaria\"\>", 
     "BurkinaFaso"->"\<\"BurkinaFaso\"\>", "Burundi"->"\<\"Burundi\"\>", 
     "Cambodia"->"\<\"Cambodia\"\>", "Cameroon"->"\<\"Cameroon\"\>", 
     "Canada"->"\<\"Canada\"\>", "CapeVerde"->"\<\"CapeVerde\"\>", 
     "CaymanIslands"->"\<\"CaymanIslands\"\>", 
     "CentralAfricanRepublic"->"\<\"CentralAfricanRepublic\"\>", 
     "Chad"->"\<\"Chad\"\>", "Chile"->"\<\"Chile\"\>", 
     "China"->"\<\"China\"\>", "ChristmasIsland"->"\<\"ChristmasIsland\"\>", 
     "CocosKeelingIslands"->"\<\"CocosKeelingIslands\"\>", 
     "Colombia"->"\<\"Colombia\"\>", "Comoros"->"\<\"Comoros\"\>", 
     "CookIslands"->"\<\"CookIslands\"\>", "CostaRica"->"\<\"CostaRica\"\>", 
     "Croatia"->"\<\"Croatia\"\>", "Cuba"->"\<\"Cuba\"\>", 
     "Cyprus"->"\<\"Cyprus\"\>", "CzechRepublic"->"\<\"CzechRepublic\"\>", 
     "DemocraticRepublicCongo"->"\<\"DemocraticRepublicCongo\"\>", 
     "Denmark"->"\<\"Denmark\"\>", "Djibouti"->"\<\"Djibouti\"\>", 
     "Dominica"->"\<\"Dominica\"\>", 
     "DominicanRepublic"->"\<\"DominicanRepublic\"\>", 
     "EastTimor"->"\<\"EastTimor\"\>", "Ecuador"->"\<\"Ecuador\"\>", 
     "Egypt"->"\<\"Egypt\"\>", "ElSalvador"->"\<\"ElSalvador\"\>", 
     "EquatorialGuinea"->"\<\"EquatorialGuinea\"\>", 
     "Eritrea"->"\<\"Eritrea\"\>", "Estonia"->"\<\"Estonia\"\>", 
     "Ethiopia"->"\<\"Ethiopia\"\>", 
     "FalklandIslands"->"\<\"FalklandIslands\"\>", 
     "FaroeIslands"->"\<\"FaroeIslands\"\>", "Fiji"->"\<\"Fiji\"\>", 
     "Finland"->"\<\"Finland\"\>", "France"->"\<\"France\"\>", 
     "FrenchGuiana"->"\<\"FrenchGuiana\"\>", 
     "FrenchPolynesia"->"\<\"FrenchPolynesia\"\>", "Gabon"->"\<\"Gabon\"\>", 
     "Gambia"->"\<\"Gambia\"\>", "GazaStrip"->"\<\"GazaStrip\"\>", 
     "Georgia"->"\<\"Georgia\"\>", "Germany"->"\<\"Germany\"\>", 
     "Ghana"->"\<\"Ghana\"\>", "Gibraltar"->"\<\"Gibraltar\"\>", 
     "Greece"->"\<\"Greece\"\>", "Greenland"->"\<\"Greenland\"\>", 
     "Grenada"->"\<\"Grenada\"\>", "Guadeloupe"->"\<\"Guadeloupe\"\>", 
     "Guam"->"\<\"Guam\"\>", "Guatemala"->"\<\"Guatemala\"\>", 
     "Guernsey"->"\<\"Guernsey\"\>", "Guinea"->"\<\"Guinea\"\>", 
     "GuineaBissau"->"\<\"GuineaBissau\"\>", "Guyana"->"\<\"Guyana\"\>", 
     "Haiti"->"\<\"Haiti\"\>", "Honduras"->"\<\"Honduras\"\>", 
     "HongKong"->"\<\"HongKong\"\>", "Hungary"->"\<\"Hungary\"\>", 
     "Iceland"->"\<\"Iceland\"\>", "India"->"\<\"India\"\>", 
     "Indonesia"->"\<\"Indonesia\"\>", "Iran"->"\<\"Iran\"\>", 
     "Iraq"->"\<\"Iraq\"\>", "Ireland"->"\<\"Ireland\"\>", 
     "IsleOfMan"->"\<\"IsleOfMan\"\>", "Israel"->"\<\"Israel\"\>", 
     "Italy"->"\<\"Italy\"\>", "IvoryCoast"->"\<\"IvoryCoast\"\>", 
     "Jamaica"->"\<\"Jamaica\"\>", "Japan"->"\<\"Japan\"\>", 
     "Jersey"->"\<\"Jersey\"\>", "Jordan"->"\<\"Jordan\"\>", 
     "Kazakhstan"->"\<\"Kazakhstan\"\>", "Kenya"->"\<\"Kenya\"\>", 
     "Kiribati"->"\<\"Kiribati\"\>", "Kuwait"->"\<\"Kuwait\"\>", 
     "Kyrgyzstan"->"\<\"Kyrgyzstan\"\>", "Laos"->"\<\"Laos\"\>", 
     "Latvia"->"\<\"Latvia\"\>", "Lebanon"->"\<\"Lebanon\"\>", 
     "Lesotho"->"\<\"Lesotho\"\>", "Liberia"->"\<\"Liberia\"\>", 
     "Libya"->"\<\"Libya\"\>", "Liechtenstein"->"\<\"Liechtenstein\"\>", 
     "Lithuania"->"\<\"Lithuania\"\>", "Luxembourg"->"\<\"Luxembourg\"\>", 
     "Macau"->"\<\"Macau\"\>", "Macedonia"->"\<\"Macedonia\"\>", 
     "Madagascar"->"\<\"Madagascar\"\>", "Malawi"->"\<\"Malawi\"\>", 
     "Malaysia"->"\<\"Malaysia\"\>", "Maldives"->"\<\"Maldives\"\>", 
     "Mali"->"\<\"Mali\"\>", "Malta"->"\<\"Malta\"\>", 
     "MarshallIslands"->"\<\"MarshallIslands\"\>", 
     "Martinique"->"\<\"Martinique\"\>", "Mauritania"->"\<\"Mauritania\"\>", 
     "Mauritius"->"\<\"Mauritius\"\>", "Mayotte"->"\<\"Mayotte\"\>", 
     "Mexico"->"\<\"Mexico\"\>", "Micronesia"->"\<\"Micronesia\"\>", 
     "Moldova"->"\<\"Moldova\"\>", "Monaco"->"\<\"Monaco\"\>", 
     "Mongolia"->"\<\"Mongolia\"\>", "Montenegro"->"\<\"Montenegro\"\>", 
     "Montserrat"->"\<\"Montserrat\"\>", "Morocco"->"\<\"Morocco\"\>", 
     "Mozambique"->"\<\"Mozambique\"\>", "Myanmar"->"\<\"Myanmar\"\>", 
     "Namibia"->"\<\"Namibia\"\>", "Nauru"->"\<\"Nauru\"\>", 
     "Nepal"->"\<\"Nepal\"\>", "Netherlands"->"\<\"Netherlands\"\>", 
     "NetherlandsAntilles"->"\<\"NetherlandsAntilles\"\>", 
     "NewCaledonia"->"\<\"NewCaledonia\"\>", 
     "NewZealand"->"\<\"NewZealand\"\>", "Nicaragua"->"\<\"Nicaragua\"\>", 
     "Niger"->"\<\"Niger\"\>", "Nigeria"->"\<\"Nigeria\"\>", 
     "Niue"->"\<\"Niue\"\>", "NorfolkIsland"->"\<\"NorfolkIsland\"\>", 
     "NorthernMarianaIslands"->"\<\"NorthernMarianaIslands\"\>", 
     "NorthKorea"->"\<\"NorthKorea\"\>", "Norway"->"\<\"Norway\"\>", 
     "Oman"->"\<\"Oman\"\>", "Pakistan"->"\<\"Pakistan\"\>", 
     "Palau"->"\<\"Palau\"\>", "Panama"->"\<\"Panama\"\>", 
     "PapuaNewGuinea"->"\<\"PapuaNewGuinea\"\>", 
     "Paraguay"->"\<\"Paraguay\"\>", "Peru"->"\<\"Peru\"\>", 
     "Philippines"->"\<\"Philippines\"\>", 
     "PitcairnIslands"->"\<\"PitcairnIslands\"\>", "Poland"->"\<\"Poland\"\>",
      "Portugal"->"\<\"Portugal\"\>", "PuertoRico"->"\<\"PuertoRico\"\>", 
     "Qatar"->"\<\"Qatar\"\>", "RepublicCongo"->"\<\"RepublicCongo\"\>", 
     "Reunion"->"\<\"Reunion\"\>", "Romania"->"\<\"Romania\"\>", 
     "Russia"->"\<\"Russia\"\>", "Rwanda"->"\<\"Rwanda\"\>", 
     "SaintHelena"->"\<\"SaintHelena\"\>", 
     "SaintKittsNevis"->"\<\"SaintKittsNevis\"\>", 
     "SaintLucia"->"\<\"SaintLucia\"\>", 
     "SaintPierreMiquelon"->"\<\"SaintPierreMiquelon\"\>", 
     "SaintVincentGrenadines"->"\<\"SaintVincentGrenadines\"\>", 
     "Samoa"->"\<\"Samoa\"\>", "SanMarino"->"\<\"SanMarino\"\>", 
     "SaoTomePrincipe"->"\<\"SaoTomePrincipe\"\>", 
     "SaudiArabia"->"\<\"SaudiArabia\"\>", "Senegal"->"\<\"Senegal\"\>", 
     "Serbia"->"\<\"Serbia\"\>", "Seychelles"->"\<\"Seychelles\"\>", 
     "SierraLeone"->"\<\"SierraLeone\"\>", "Singapore"->"\<\"Singapore\"\>", 
     "Slovakia"->"\<\"Slovakia\"\>", "Slovenia"->"\<\"Slovenia\"\>", 
     "SolomonIslands"->"\<\"SolomonIslands\"\>", "Somalia"->"\<\"Somalia\"\>",
      "SouthAfrica"->"\<\"SouthAfrica\"\>", 
     "SouthKorea"->"\<\"SouthKorea\"\>", "Spain"->"\<\"Spain\"\>", 
     "SriLanka"->"\<\"SriLanka\"\>", "Sudan"->"\<\"Sudan\"\>", 
     "Suriname"->"\<\"Suriname\"\>", "Svalbard"->"\<\"Svalbard\"\>", 
     "Swaziland"->"\<\"Swaziland\"\>", "Sweden"->"\<\"Sweden\"\>", 
     "Switzerland"->"\<\"Switzerland\"\>", "Syria"->"\<\"Syria\"\>", 
     "Taiwan"->"\<\"Taiwan\"\>", "Tajikistan"->"\<\"Tajikistan\"\>", 
     "Tanzania"->"\<\"Tanzania\"\>", "Thailand"->"\<\"Thailand\"\>", 
     "Togo"->"\<\"Togo\"\>", "Tokelau"->"\<\"Tokelau\"\>", 
     "Tonga"->"\<\"Tonga\"\>", "TrinidadTobago"->"\<\"TrinidadTobago\"\>", 
     "Tunisia"->"\<\"Tunisia\"\>", "Turkey"->"\<\"Turkey\"\>", 
     "Turkmenistan"->"\<\"Turkmenistan\"\>", 
     "TurksCaicosIslands"->"\<\"TurksCaicosIslands\"\>", 
     "Tuvalu"->"\<\"Tuvalu\"\>", "Uganda"->"\<\"Uganda\"\>", 
     "Ukraine"->"\<\"Ukraine\"\>", 
     "UnitedArabEmirates"->"\<\"UnitedArabEmirates\"\>", 
     "UnitedKingdom"->"\<\"UnitedKingdom\"\>", 
     "UnitedStates"->"\<\"UnitedStates\"\>", 
     "UnitedStatesVirginIslands"->"\<\"UnitedStatesVirginIslands\"\>", 
     "Uruguay"->"\<\"Uruguay\"\>", "Uzbekistan"->"\<\"Uzbekistan\"\>", 
     "Vanuatu"->"\<\"Vanuatu\"\>", "VaticanCity"->"\<\"VaticanCity\"\>", 
     "Venezuela"->"\<\"Venezuela\"\>", "Vietnam"->"\<\"Vietnam\"\>", 
     "WallisFutuna"->"\<\"WallisFutuna\"\>", "WestBank"->"\<\"WestBank\"\>", 
     "WesternSahara"->"\<\"WesternSahara\"\>", "Yemen"->"\<\"Yemen\"\>", 
     "Zambia"->"\<\"Zambia\"\>", "Zimbabwe"->"\<\"Zimbabwe\"\>"}], ",", 
    DynamicBox[ToBoxes[
      CountryData[$CellContext`c$$, "Shape"], StandardForm],
     ImageSizeCache->{212., {68., 72.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{396, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->891795752]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2025427363],

Cell[TextData[{
 "Construct custom controls, i.e., an angular slider with range (",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Pi]"}], TraditionalForm]], "InlineMath"],
 ",",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineMath"],
 "):"
}], "ExampleText",
 CellID->1594401344],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"angle", "=", "0"}], ",", 
     RowBox[{"p", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"LocatorPane", "[", 
      RowBox[{
       RowBox[{"Dynamic", "[", 
        RowBox[{"p", ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"angle", "=", 
             RowBox[{"ArcTan", "@@", "#"}]}], ";", 
            RowBox[{"p", "=", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Cos", "[", "angle", "]"}], ",", 
               RowBox[{"Sin", "[", "angle", "]"}]}], "}"}]}]}], ")"}], 
          "&"}]}], "]"}], ",", 
       RowBox[{"Graphics", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Circle", "[", "]"}], ",", 
           RowBox[{"Arrowheads", "[", "0.15", "]"}], ",", 
           RowBox[{"Arrow", "[", 
            RowBox[{"Dynamic", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], ",", "p"}], "}"}], "]"}], 
            "]"}]}], "}"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "]"}], ",", 
       RowBox[{"Appearance", "\[Rule]", "None"}]}], "]"}], ",", 
     RowBox[{"Dynamic", "[", "angle", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->687926783],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`angle$$ = 
  0.9936041129214356, $CellContext`p$$ = {0.5456731714374327, 
  0.8379980847074856}}, 
  RowBox[{"{", 
   RowBox[{
    LocatorPaneBox[
     Dynamic[$CellContext`p$$, ($CellContext`angle$$ = 
       Apply[ArcTan, #]; $CellContext`p$$ = {
         Cos[$CellContext`angle$$], 
         Sin[$CellContext`angle$$]})& ], 
     GraphicsBox[{CircleBox[{0, 0}], 
       {Arrowheads[0.15], ArrowBox[Dynamic[{{0, 0}, $CellContext`p$$}]]}},
      ImageSize->Tiny],
     Appearance->None], ",", 
    DynamicBox[ToBoxes[$CellContext`angle$$, StandardForm],
     ImageSizeCache->{56., {0., 8.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{186, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->266456499]
}, Open  ]],

Cell[TextData[{
 "An angular slider with range (",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 ",",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
 "):"
}], "ExampleText",
 CellID->945459518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"angle", "=", "0"}], ",", 
     RowBox[{"p", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], ",", "angleCalc"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"LocatorPane", "[", 
      RowBox[{
       RowBox[{"Dynamic", "[", 
        RowBox[{"p", ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"angleCalc", "@@", 
            RowBox[{"Normalize", "/@", 
             RowBox[{"{", 
              RowBox[{"#", ",", "p"}], "}"}]}]}], ")"}], "&"}]}], "]"}], ",", 
       
       RowBox[{"Graphics", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Circle", "[", "]"}], ",", 
           RowBox[{"Arrowheads", "[", "0.15", "]"}], ",", 
           RowBox[{"Arrow", "[", 
            RowBox[{"Dynamic", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], ",", "p"}], "}"}], "]"}], 
            "]"}]}], "}"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "]"}], ",", 
       RowBox[{"Appearance", "\[Rule]", "None"}]}], "]"}], ",", 
     RowBox[{"Dynamic", "[", "angle", "]"}]}], "}"}], ",", 
   RowBox[{"Initialization", "\[RuleDelayed]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"angleCalc", "[", 
       RowBox[{"newp_", ",", "oldp_"}], "]"}], ":=", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"angle", "=", 
         RowBox[{"angle", "+", 
          RowBox[{
           RowBox[{"ArcCos", "[", 
            RowBox[{"newp", ".", "oldp"}], "]"}], 
           RowBox[{"Sign", "[", 
            RowBox[{
             RowBox[{"Cross", "[", "newp", "]"}], ".", 
             RowBox[{"(", 
              RowBox[{"newp", "-", "oldp"}], ")"}]}], "]"}]}]}]}], ";", 
        RowBox[{"p", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Cos", "[", "angle", "]"}], ",", 
           RowBox[{"Sin", "[", "angle", "]"}]}], "}"}]}]}], ")"}]}], 
     ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1106614873],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`angle$$ = 
  15.757305900201937`, $CellContext`p$$ = {-0.9987828992903587, \
-0.04932261231063548}, $CellContext`angleCalc$$}, 
  RowBox[{"{", 
   RowBox[{
    LocatorPaneBox[Dynamic[$CellContext`p$$, Apply[$CellContext`angleCalc$$, 
       Map[Normalize, {#, $CellContext`p$$}]]& ], 
     GraphicsBox[{CircleBox[{0, 0}], 
       {Arrowheads[0.15], ArrowBox[Dynamic[{{0, 0}, $CellContext`p$$}]]}},
      ImageSize->Tiny],
     Appearance->None], ",", 
    DynamicBox[ToBoxes[$CellContext`angle$$, StandardForm],
     ImageSizeCache->{49., {0., 8.}}]}], "}"}],
  DynamicModuleValues:>{{DownValues[$CellContext`angleCalc$$] = {HoldPattern[
         $CellContext`angleCalc$$[
          Pattern[$CellContext`newp$, 
           Blank[]], 
          Pattern[$CellContext`oldp$, 
           Blank[]]]] :> ($CellContext`angle$$ = $CellContext`angle$$ + 
          ArcCos[
             Dot[$CellContext`newp$, $CellContext`oldp$]] Sign[
             Dot[
              
              Cross[$CellContext`newp$], $CellContext`newp$ - \
$CellContext`oldp$]]; $CellContext`p$$ = {
           Cos[$CellContext`angle$$], 
           Sin[$CellContext`angle$$]})}}},
  Initialization:>($CellContext`angleCalc$$[
     Pattern[$CellContext`newp$, 
      Blank[]], 
     Pattern[$CellContext`oldp$, 
      Blank[]]] := ($CellContext`angle$$ = $CellContext`angle$$ + ArcCos[
         Dot[$CellContext`newp$, $CellContext`oldp$]] Sign[
         Dot[
          
          Cross[$CellContext`newp$], $CellContext`newp$ - \
$CellContext`oldp$]]; $CellContext`p$$ = {
       Cos[$CellContext`angle$$], 
       Sin[$CellContext`angle$$]}))]], "Output",
 ImageSize->{179, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->226157848]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21113],

Cell["\<\
The following example does not work because the assignment operation fails:\
\>", "ExampleText",
 CellID->681533112],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{"Dynamic", "[", 
     RowBox[{"1", "-", "x"}], "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1996723933],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[1 - $CellContext`x]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 6.}}]}], "}"}]], "Output",
 ImageSize->{237, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->220595197]
}, Open  ]],

Cell[TextData[{
 "Use the second argument of ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " to control the assignment operation:"
}], "ExampleText",
 CellID->289576182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{"Dynamic", "[", 
     RowBox[{
      RowBox[{"1", "-", "y"}], ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"y", "=", 
         RowBox[{"1", "-", "#"}]}], ")"}], "&"}]}], "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "y", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1458879414],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[1 - $CellContext`y, ($CellContext`y = 1 - #)& ]], ",", 
   DynamicBox[ToBoxes[$CellContext`y, StandardForm],
    ImageSizeCache->{7., {2., 6.}}]}], "}"}]], "Output",
 ImageSize->{237, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->163614118]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1716591846],

Cell[TextData[{
 "Self-triggering ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " can easily cause infinite loops (delete the output to stop it):"
}], "ExampleText",
 CellID->1463841924],

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "1"}], "}"}], ",", 
   RowBox[{"Dynamic", "[", 
    RowBox[{"x", "=", 
     RowBox[{"x", "+", "1"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1218556636]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30234],

Cell[TextData[{
 "Coupled ",
 Cell[BoxData[
  ButtonBox["Slider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->59367188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Slider", "[", 
    RowBox[{"Dynamic", "[", 
     RowBox[{
      RowBox[{"1", "-", "x"}], ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "=", 
         RowBox[{"1", "-", "#"}]}], ")"}], "&"}]}], "]"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->802441342],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`x]], ",", 
   SliderBox[Dynamic[1 - $CellContext`x, ($CellContext`x = 1 - #)& ]]}], 
  "}"}]], "Output",
 ImageSize->{430, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->617226599]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1418623079],

Cell[TextData[{
 "Coupled ",
 Cell[BoxData[
  ButtonBox["Slider2D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider2D"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1351916508],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider2D", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "r", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Slider2D", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", 
      RowBox[{
       RowBox[{"Through", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Cos", ",", "Sin"}], "}"}], "[", 
         RowBox[{"ArcTan", "@@", "r"}], "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"r", "=", 
          RowBox[{"Normalize", "[", "#", "]"}]}], ")"}], "&"}]}], "]"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Slider2D", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"r", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"r", "[", 
            RowBox[{"[", "1", "]"}], "]"}], " ", "Pi"}], "]"}]}], "}"}], ",", 
       
       RowBox[{
        RowBox[{"(", 
         RowBox[{"r", "=", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"Sin", "[", 
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"[", "1", "]"}], "]"}], " ", "Pi"}], "]"}]}], "}"}]}], 
         ")"}], "&"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Slider2D", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"r", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"r", "[", 
            RowBox[{"[", "1", "]"}], "]"}], " ", "Pi"}], "]"}]}], "}"}], ",", 
       
       RowBox[{
        RowBox[{"(", 
         RowBox[{"r", "=", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"Cos", "[", 
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"[", "1", "]"}], "]"}], " ", "Pi"}], "]"}]}], "}"}]}], 
         ")"}], "&"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->518217885],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Slider2DBox[Dynamic[$CellContext`r], {-1, 1}], ",", 
   Slider2DBox[Dynamic[
     Through[
      {Cos, Sin}[
       Apply[ArcTan, $CellContext`r]]], ($CellContext`r = 
     Normalize[#])& ], {-1, 1}], ",", 
   Slider2DBox[Dynamic[{
      Part[$CellContext`r, 1], 
      Sin[Part[$CellContext`r, 1] Pi]}, ($CellContext`r = {
       Part[#, 1], 
       Sin[Part[#, 1] Pi]})& ], {-1, 1}], ",", 
   Slider2DBox[Dynamic[{
      Part[$CellContext`r, 1], 
      Cos[Part[$CellContext`r, 1] Pi]}, ($CellContext`r = {
       Part[#, 1], 
       Cos[Part[#, 1] Pi]})& ], {-1, 1}]}], "}"}]], "Output",
 ImageSize->{372, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2067283028]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1197599715],

Cell[TextData[{
 "A \"droopy\" ",
 Cell[BoxData[
  ButtonBox["Slider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1841670321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Slider", "[", 
      RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"x", "=", 
       RowBox[{"Max", "[", 
        RowBox[{"0", ",", 
         RowBox[{"x", "-", "0.01"}]}], "]"}]}], "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1271280836],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 0}, 
  RowBox[{"{", 
   RowBox[{
    SliderBox[Dynamic[$CellContext`x$$]], ",", 
    DynamicBox[
     ToBoxes[$CellContext`x$$ = Max[0, $CellContext`x$$ - 0.01], 
      StandardForm],
     ImageSizeCache->{7., {0., 8.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{237, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1102206649]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1434639759],

Cell["\<\
Center a disk at mouse position as it moves over the graphics area:\
\>", "ExampleText",
 CellID->44040997],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"Disk", "[", 
     RowBox[{
      RowBox[{"Dynamic", "[", 
       RowBox[{"MousePosition", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Graphics\>\"", ",", "Graphics"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}]}], "]"}], "]"}], ",", "0.2"}], "]"}],
     ",", 
    RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->958983033],

Cell[BoxData[
 FrameBox[
  GraphicsBox[
   DiskBox[Dynamic[MousePosition[{"Graphics", Graphics}, {0, 0}]], 0.2],
   PlotRange->2],
  StripOnInput->False]], "Output",
 ImageSize->{194, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->90806651]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1462662011],

Cell["Remember last mouse position as it leaves the graphics area:", \
"ExampleText",
 CellID->715111668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pt", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"Framed", "@", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"Dynamic", "[", 
         RowBox[{
          RowBox[{"pt", "=", 
           RowBox[{"MousePosition", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\"\<Graphics\>\"", ",", "Graphics"}], "}"}], ",", 
             "pt"}], "]"}]}], ";", "pt"}], "]"}], ",", "0.2"}], "]"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->465044263],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pt$$ = {0.6888888888888891, 
  0.6666666666666667}}, 
  FrameBox[
   GraphicsBox[
    DiskBox[Dynamic[$CellContext`pt$$ = 
       MousePosition[{
         "Graphics", Graphics}, $CellContext`pt$$]; $CellContext`pt$$], 0.2],
    PlotRange->2],
   StripOnInput->False],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{194, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->794615663]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2086411401],

Cell["Click in the framed area to see bouncing balls:", "ExampleText",
 CellID->55944744],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"DynamicModule", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"contents", "=", 
      RowBox[{"{", "}"}]}], "}"}], ",", 
    RowBox[{"EventHandler", "[", 
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PointSize", "[", "0.1", "]"}], ",", 
          RowBox[{"Point", "[", 
           RowBox[{"Dynamic", "[", 
            RowBox[{
             RowBox[{"contents", "=", 
              RowBox[{"Map", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "2"}], "]"}], "]"}], "\[GreaterEqual]", 
                    "0"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "-", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0.001"}], "}"}]}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "0"}], "}"}], 
                    ",", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", 
                    RowBox[{"-", "0.8"}]}], "}"}], 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}]}], "]"}], "&"}],
                 ",", "contents"}], "]"}]}], ";", 
             RowBox[{"Map", "[", 
              RowBox[{"First", ",", "contents"}], "]"}]}], "]"}], "]"}]}], 
         "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}], ",", 
      RowBox[{"\"\<MouseDown\>\"", "\[RuleDelayed]", 
       RowBox[{"(", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"contents", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"MousePosition", "[", "\"\<Graphics\>\"", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], "]"}], ")"}]}]}], 
     "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2115788040],

Cell[BoxData[
 FrameBox[
  DynamicModuleBox[{$CellContext`contents$$ = {}}, 
   TagBox[
    GraphicsBox[
     {PointSize[0.1], 
      PointBox[Dynamic[$CellContext`contents$$ = 
         Map[If[Part[#, 1, 2] >= 0, {
            Part[#, 1] - Part[#, 2], Part[#, 2] + {0, 0.001}}, {{
             Part[#, 1, 1], 0}, {1, -0.8} 
             Part[#, 2]}]& , $CellContext`contents$$]; 
        Map[First, $CellContext`contents$$]]]},
     PlotRange->{{0, 1}, {0, 1}}],
    EventHandlerTag[{"MouseDown" :> AppendTo[$CellContext`contents$$, {
         MousePosition["Graphics"], {0, 0}}], PassEventsDown -> Automatic, 
      PassEventsUp -> True}]],
   DynamicModuleValues:>{}],
  StripOnInput->False]], "Output",
 ImageSize->{194, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->204692973]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18228],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Manipulate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manipulate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Animate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Animate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Monitor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Monitor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Refresh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Refresh"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Deploy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Deploy"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ContinuousAction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContinuousAction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FinishDynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FinishDynamic"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Button",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Button"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetDelayed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetDelayed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DynamicModule",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DynamicModule"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DynamicSetting",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DynamicSetting"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4741]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->360],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Advanced Dynamic Functionality",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality"]], "Tutorials",
 CellID->558945376]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Dynamic",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Dynamic"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->67098491],

Cell[TextData[ButtonBox["Click-Interactive Panels",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ClickInteractivePanels"]], "MoreAbout",
 CellID->685372450],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->537758907],

Cell[TextData[ButtonBox["Creating Inspectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CreatingInspectors"]], "MoreAbout",
 CellID->680829580],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "MoreAbout",
 CellID->310485560],

Cell[TextData[ButtonBox["Dialog Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DialogBoxes"]], "MoreAbout",
 CellID->358434993],

Cell[TextData[ButtonBox["Dynamic Interactivity Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicInteractivityLanguage"]], "MoreAbout",
 CellID->435759593],

Cell[TextData[ButtonBox["Evaluation Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationControl"]], "MoreAbout",
 CellID->25050218],

Cell[TextData[ButtonBox["External Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExternalOperations"]], "MoreAbout",
 CellID->12474860],

Cell[TextData[ButtonBox["Language Overview",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LanguageOverview"]], "MoreAbout",
 CellID->170154651],

Cell[TextData[ButtonBox["Low-Level Interface Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelInterfaceControl"]], "MoreAbout",
 CellID->357747359],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreAbout",
 CellID->288013279],

Cell[TextData[ButtonBox["Toolbars",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Toolbars"]], "MoreAbout",
 CellID->483053350],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "MoreAbout",
 CellID->270800226],

Cell[TextData[ButtonBox["New in 6.0: Dynamic Interactivity",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DynamicInteractivity"]], "MoreAbout",
 CellID->19134556],

Cell[TextData[ButtonBox["New in 6.0: System Interfaces & Deployment",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60SystemInterfacesAndDeployment"]], "MoreAbout",
 CellID->802738112]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Dynamic - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 39, 31.8068636}", "context" -> "System`", 
    "keywords" -> {
     "dynamic variables", "dynamic expressions", "dynamic graphics", 
      "dynamic interfaces", "dynamic typesetting", "real-time updates", 
      "real-time graphics", "real-time interfaces", "reactive programming"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Dynamic[expr] represents an object that displays as the dynamically \
updated current value of expr. If the displayed form of Dynamic[expr] is \
interactively changed or edited, an assignment expr = val is done to give \
expr the new value val that corresponds to the displayed form. Dynamic[expr, \
None] does not allow interactive changing or editing. Dynamic[expr, f] \
continually evaluates f[val, expr] during interactive changing or editing of \
val. Dynamic[expr, {f, f_end}] also evaluates f_end[val, expr] when \
interactive changing or editing is complete. Dynamic[expr, {f_start, f, \
f_end}] also evaluates f_start[val, expr] when interactive changing or \
editing begins. ", "synonyms" -> {}, "title" -> "Dynamic", "type" -> "Symbol",
     "uri" -> "ref/Dynamic"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[31501, 1029, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->253961593]},
 "Notebook Image"->{
  Cell[84869, 3056, 6581, 113, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->279801952]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 147615, 4940},
 {"Notebook Image", 147758, 4944}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 5257, 104, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[5880, 131, 1572, 37, 70, "ObjectNameGrid"],
Cell[7455, 170, 3955, 124, 70, "Usage",
 CellID->8135]
}, Open  ]],
Cell[CellGroupData[{
Cell[11447, 299, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[11925, 316, 404, 11, 70, "Notes",
 CellID->3915],
Cell[12332, 329, 891, 33, 70, "Notes",
 CellID->98],
Cell[13226, 364, 1693, 61, 70, "Notes",
 CellID->27619],
Cell[14922, 427, 418, 13, 70, "Notes",
 CellID->13313],
Cell[15343, 442, 647, 23, 70, "Notes",
 CellID->9974],
Cell[15993, 467, 438, 15, 70, "Notes",
 CellID->27296],
Cell[16434, 484, 542, 22, 70, "Notes",
 CellID->3764],
Cell[16979, 508, 574, 21, 70, "Notes",
 CellID->18223],
Cell[17556, 531, 509, 17, 70, "Notes",
 CellID->6607],
Cell[18068, 550, 563, 17, 70, "Notes",
 CellID->12074],
Cell[18634, 569, 1252, 45, 70, "Notes",
 CellID->790],
Cell[19889, 616, 394, 16, 70, "Notes",
 CellID->22599],
Cell[20286, 634, 825, 30, 70, "Notes",
 CellID->32518],
Cell[21114, 666, 580, 18, 70, "Notes",
 CellID->3140],
Cell[21697, 686, 370, 16, 70, "Notes",
 CellID->17103],
Cell[22070, 704, 1418, 40, 70, "2ColumnTableMod",
 CellID->7245],
Cell[23491, 746, 739, 28, 70, "Notes",
 CellID->4257],
Cell[24233, 776, 892, 33, 70, "Notes",
 CellID->2216],
Cell[25128, 811, 390, 14, 70, "Notes",
 CellID->23357],
Cell[25521, 827, 522, 19, 70, "Notes",
 CellID->18037],
Cell[26046, 848, 907, 33, 70, "Notes",
 CellID->25365],
Cell[26956, 883, 68, 1, 70, "Notes",
 CellID->7373],
Cell[27027, 886, 2997, 84, 70, "3ColumnTableMod",
 CellID->397],
Cell[30027, 972, 1062, 39, 70, "Notes",
 CellID->7048],
Cell[31092, 1013, 372, 11, 70, "Notes",
 CellID->15124]
}, Closed]],
Cell[CellGroupData[{
Cell[31501, 1029, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->253961593],
Cell[CellGroupData[{
Cell[31886, 1043, 148, 5, 70, "ExampleSection",
 CellID->127742867],
Cell[32037, 1050, 225, 7, 70, "ExampleText",
 CellID->129669118],
Cell[CellGroupData[{
Cell[32287, 1061, 103, 3, 28, "Input",
 CellID->147434189],
Cell[32393, 1066, 241, 7, 36, "Output",
 CellID->1877769532]
}, Open  ]],
Cell[32649, 1076, 174, 6, 70, "ExampleText",
 CellID->1913796441],
Cell[CellGroupData[{
Cell[32848, 1086, 94, 3, 28, "Input",
 CellID->252848012],
Cell[32945, 1091, 162, 5, 36, "Output",
 CellID->1663296061]
}, Open  ]],
Cell[33122, 1099, 269, 11, 70, "ExampleText",
 CellID->166719121],
Cell[CellGroupData[{
Cell[33416, 1114, 136, 4, 70, "Input",
 CellID->504393992],
Cell[33555, 1120, 193, 6, 70, "Output",
 CellID->1222264228]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[33797, 1132, 217, 7, 70, "ExampleSection",
 CellID->30229],
Cell[CellGroupData[{
Cell[34039, 1143, 235, 7, 70, "ExampleSubsection",
 CellID->1134200337],
Cell[34277, 1152, 216, 8, 70, "ExampleText",
 CellID->462656750],
Cell[CellGroupData[{
Cell[34518, 1164, 390, 12, 70, "Input",
 CellID->225929272],
Cell[34911, 1178, 550, 16, 70, "Output",
 CellID->127331943]
}, Open  ]],
Cell[35476, 1197, 345, 12, 70, "ExampleText",
 CellID->185017855],
Cell[CellGroupData[{
Cell[35846, 1213, 101, 3, 70, "Input",
 CellID->235491870],
Cell[35950, 1218, 1386, 48, 54, "Output",
 CellID->520030756]
}, Open  ]],
Cell[37351, 1269, 125, 3, 70, "ExampleDelimiter",
 CellID->882718901],
Cell[37479, 1274, 305, 11, 70, "ExampleText",
 CellID->10553097],
Cell[CellGroupData[{
Cell[37809, 1289, 104, 3, 70, "Input",
 CellID->1981736507],
Cell[37916, 1294, 240, 7, 70, "Output",
 CellID->118326615]
}, Open  ]],
Cell[CellGroupData[{
Cell[38193, 1306, 136, 4, 70, "Input",
 CellID->685876508],
Cell[38332, 1312, 193, 6, 70, "Output",
 CellID->1848039913]
}, Open  ]],
Cell[CellGroupData[{
Cell[38562, 1323, 281, 9, 70, "Input",
 CellID->1884190814],
Cell[38846, 1334, 314, 10, 70, "Output",
 CellID->286453359]
}, Open  ]],
Cell[CellGroupData[{
Cell[39197, 1349, 234, 7, 70, "Input",
 CellID->1721591826],
Cell[39434, 1358, 1000, 28, 70, "Output",
 CellID->950831230]
}, Open  ]],
Cell[CellGroupData[{
Cell[40471, 1391, 333, 11, 70, "Input",
 CellID->1746643551],
Cell[40807, 1404, 316, 10, 70, "Output",
 CellID->1914795578]
}, Open  ]],
Cell[41138, 1417, 126, 3, 70, "ExampleDelimiter",
 CellID->1926829151],
Cell[41267, 1422, 229, 8, 70, "ExampleText",
 CellID->1400835531],
Cell[CellGroupData[{
Cell[41521, 1434, 221, 7, 70, "Input",
 CellID->1352966097],
Cell[41745, 1443, 323, 10, 70, "Output",
 CellID->1744337843]
}, Open  ]],
Cell[42083, 1456, 220, 8, 70, "ExampleText",
 CellID->1786862104],
Cell[CellGroupData[{
Cell[42328, 1468, 413, 13, 70, "Input",
 CellID->1380062280],
Cell[42744, 1483, 549, 16, 70, "Output",
 CellID->1883352360]
}, Open  ]],
Cell[43308, 1502, 72, 1, 70, "ExampleText",
 CellID->1741641387],
Cell[CellGroupData[{
Cell[43405, 1507, 442, 14, 70, "Input",
 CellID->1564682699],
Cell[43850, 1523, 549, 16, 70, "Output",
 CellID->1684864578]
}, Open  ]],
Cell[44414, 1542, 125, 3, 70, "ExampleDelimiter",
 CellID->799593104],
Cell[44542, 1547, 211, 7, 70, "ExampleText",
 CellID->653348606],
Cell[CellGroupData[{
Cell[44778, 1558, 332, 11, 70, "Input",
 CellID->675788820],
Cell[45113, 1571, 353, 10, 70, "Output",
 CellID->615142237]
}, Open  ]],
Cell[45481, 1584, 188, 8, 70, "ExampleText",
 CellID->154406897],
Cell[CellGroupData[{
Cell[45694, 1596, 468, 16, 70, "Input",
 CellID->956472303],
Cell[46165, 1614, 453, 14, 70, "Output",
 CellID->1458013505]
}, Open  ]],
Cell[46633, 1631, 125, 3, 70, "ExampleDelimiter",
 CellID->126768319],
Cell[46761, 1636, 362, 13, 70, "ExampleText",
 CellID->409555517],
Cell[CellGroupData[{
Cell[47148, 1653, 135, 4, 70, "Input",
 CellID->993957327],
Cell[47286, 1659, 242, 8, 70, "Output",
 CellID->85148940]
}, Open  ]],
Cell[CellGroupData[{
Cell[47565, 1672, 135, 4, 70, "Input",
 CellID->181826107],
Cell[47703, 1678, 245, 8, 70, "Output",
 CellID->831121464]
}, Open  ]],
Cell[47963, 1689, 226, 8, 70, "ExampleText",
 CellID->133007559],
Cell[48192, 1699, 227, 7, 70, "Input",
 CellID->124520871],
Cell[48422, 1708, 202, 6, 70, "Input",
 CellID->382801950]
}, Closed]],
Cell[CellGroupData[{
Cell[48661, 1719, 236, 7, 70, "ExampleSubsection",
 CellID->325153917],
Cell[48900, 1728, 224, 7, 70, "ExampleText",
 CellID->1559369472],
Cell[CellGroupData[{
Cell[49149, 1739, 618, 20, 70, "Input",
 CellID->432287916],
Cell[49770, 1761, 2126, 41, 70, "Output",
 CellID->750321621]
}, Open  ]],
Cell[CellGroupData[{
Cell[51933, 1807, 629, 21, 70, "Input",
 CellID->525826411],
Cell[52565, 1830, 511, 15, 70, "Output",
 CellID->107802518]
}, Open  ]],
Cell[53091, 1848, 125, 3, 70, "ExampleDelimiter",
 CellID->744802882],
Cell[53219, 1853, 247, 8, 70, "ExampleText",
 CellID->219859411],
Cell[53469, 1863, 366, 12, 70, "Input",
 CellID->1505247837],
Cell[CellGroupData[{
Cell[53860, 1879, 136, 4, 70, "Input",
 CellID->185253176],
Cell[53999, 1885, 193, 6, 70, "Output",
 CellID->1846324529]
}, Open  ]],
Cell[CellGroupData[{
Cell[54229, 1896, 367, 12, 70, "Input",
 CellID->1343034799],
Cell[54599, 1910, 530, 14, 70, "Output",
 CellID->37659753]
}, Open  ]],
Cell[55144, 1927, 125, 3, 70, "ExampleDelimiter",
 CellID->545449395],
Cell[55272, 1932, 244, 8, 70, "ExampleText",
 CellID->4032069],
Cell[CellGroupData[{
Cell[55541, 1944, 1164, 35, 70, "Input",
 CellID->256970229],
Cell[56708, 1981, 1027, 30, 70, "Output",
 CellID->188011249]
}, Open  ]],
Cell[57750, 2014, 130, 4, 70, "ExampleText",
 CellID->421406127],
Cell[CellGroupData[{
Cell[57905, 2022, 1315, 41, 70, "Input",
 CellID->679412405],
Cell[59223, 2065, 963, 30, 70, "Output",
 CellID->99991264]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[60235, 2101, 240, 7, 70, "ExampleSubsection",
 CellID->798486387],
Cell[60478, 2110, 363, 13, 70, "ExampleText",
 CellID->1083413066],
Cell[CellGroupData[{
Cell[60866, 2127, 220, 7, 70, "Input",
 CellID->409557349],
Cell[61089, 2136, 327, 10, 70, "Output",
 CellID->1392618813]
}, Open  ]],
Cell[61431, 2149, 126, 3, 70, "ExampleDelimiter",
 CellID->1654044071],
Cell[61560, 2154, 178, 7, 70, "ExampleText",
 CellID->342890882],
Cell[CellGroupData[{
Cell[61763, 2165, 223, 7, 70, "Input",
 CellID->1268428873],
Cell[61989, 2174, 328, 10, 70, "Output",
 CellID->413904742]
}, Open  ]],
Cell[62332, 2187, 126, 3, 70, "ExampleDelimiter",
 CellID->1914975007],
Cell[62461, 2192, 183, 7, 70, "ExampleText",
 CellID->1729237152],
Cell[CellGroupData[{
Cell[62669, 2203, 224, 7, 70, "Input",
 CellID->745276008],
Cell[62896, 2212, 330, 10, 70, "Output",
 CellID->647525060]
}, Open  ]],
Cell[63241, 2225, 125, 3, 70, "ExampleDelimiter",
 CellID->797466161],
Cell[63369, 2230, 219, 9, 70, "ExampleText",
 CellID->568327000],
Cell[CellGroupData[{
Cell[63613, 2243, 226, 7, 70, "Input",
 CellID->2012110791],
Cell[63842, 2252, 350, 10, 70, "Output",
 CellID->2033960465]
}, Open  ]],
Cell[64207, 2265, 126, 3, 70, "ExampleDelimiter",
 CellID->1033042098],
Cell[64336, 2270, 181, 7, 70, "ExampleText",
 CellID->2080738738],
Cell[CellGroupData[{
Cell[64542, 2281, 286, 9, 70, "Input",
 CellID->1352261818],
Cell[64831, 2292, 418, 11, 70, "Output",
 CellID->1464436492]
}, Open  ]],
Cell[65264, 2306, 126, 3, 70, "ExampleDelimiter",
 CellID->1128842309],
Cell[65393, 2311, 177, 7, 70, "ExampleText",
 CellID->1582149765],
Cell[CellGroupData[{
Cell[65595, 2322, 507, 16, 70, "Input",
 CellID->1048583201],
Cell[66105, 2340, 450, 13, 70, "Output",
 CellID->2026410891]
}, Open  ]],
Cell[66570, 2356, 126, 3, 70, "ExampleDelimiter",
 CellID->1587276453],
Cell[66699, 2361, 343, 13, 70, "ExampleText",
 CellID->1012243777],
Cell[CellGroupData[{
Cell[67067, 2378, 416, 14, 70, "Input",
 CellID->415708505],
Cell[67486, 2394, 417, 15, 63, "Output",
 CellID->1048539844]
}, Open  ]],
Cell[CellGroupData[{
Cell[67940, 2414, 247, 8, 70, "Input",
 CellID->558350826],
Cell[68190, 2424, 586, 18, 70, "Output",
 CellID->1846278839]
}, Open  ]],
Cell[68791, 2445, 179, 7, 70, "ExampleText",
 CellID->1669868113],
Cell[CellGroupData[{
Cell[68995, 2456, 246, 8, 70, "Input",
 CellID->9592548],
Cell[69244, 2466, 1070, 38, 70, "Output",
 CellID->160680711]
}, Open  ]],
Cell[70329, 2507, 181, 7, 70, "ExampleText",
 CellID->1173765498],
Cell[CellGroupData[{
Cell[70535, 2518, 249, 8, 70, "Input",
 CellID->691943544],
Cell[70787, 2528, 1067, 37, 70, "Output",
 CellID->871195503]
}, Open  ]],
Cell[71869, 2568, 182, 7, 70, "ExampleText",
 CellID->639313675],
Cell[CellGroupData[{
Cell[72076, 2579, 307, 10, 70, "Input",
 CellID->1084249784],
Cell[72386, 2591, 2505, 76, 70, "Output",
 CellID->185588106]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[74940, 2673, 236, 7, 70, "ExampleSubsection",
 CellID->83214827],
Cell[75179, 2682, 261, 8, 70, "ExampleText",
 CellID->1540782990],
Cell[CellGroupData[{
Cell[75465, 2694, 221, 7, 70, "Input",
 CellID->1581897404],
Cell[75689, 2703, 326, 10, 70, "Output",
 CellID->370969041]
}, Open  ]],
Cell[CellGroupData[{
Cell[76052, 2718, 326, 11, 70, "Input",
 CellID->1102119168],
Cell[76381, 2731, 348, 10, 70, "Output",
 CellID->3018916]
}, Open  ]],
Cell[CellGroupData[{
Cell[76766, 2746, 254, 8, 70, "Input",
 CellID->297326175],
Cell[77023, 2756, 336, 10, 70, "Output",
 CellID->82401355]
}, Open  ]],
Cell[77374, 2769, 126, 3, 70, "ExampleDelimiter",
 CellID->1270401201],
Cell[77503, 2774, 135, 4, 70, "ExampleText",
 CellID->1350566733],
Cell[CellGroupData[{
Cell[77663, 2782, 566, 18, 70, "Input",
 CellID->72932741],
Cell[78232, 2802, 423, 12, 70, "Output",
 CellID->844600452]
}, Open  ]],
Cell[78670, 2817, 126, 3, 70, "ExampleDelimiter",
 CellID->2017490552],
Cell[78799, 2822, 131, 4, 70, "ExampleText",
 CellID->1344404981],
Cell[CellGroupData[{
Cell[78955, 2830, 741, 24, 70, "Input",
 CellID->1739065580],
Cell[79699, 2856, 463, 13, 70, "Output",
 CellID->418265062]
}, Open  ]],
Cell[80177, 2872, 126, 3, 70, "ExampleDelimiter",
 CellID->1482901561],
Cell[80306, 2877, 140, 4, 70, "ExampleText",
 CellID->1578812292],
Cell[CellGroupData[{
Cell[80471, 2885, 635, 22, 70, "Input",
 CellID->790249312],
Cell[81109, 2909, 432, 12, 70, "Output",
 CellID->58576704]
}, Open  ]],
Cell[81556, 2924, 125, 3, 70, "ExampleDelimiter",
 CellID->765482477],
Cell[81684, 2929, 247, 8, 70, "ExampleText",
 CellID->2036945409],
Cell[CellGroupData[{
Cell[81956, 2941, 255, 8, 70, "Input",
 CellID->1904672236],
Cell[82214, 2951, 337, 10, 70, "Output",
 CellID->131294433]
}, Open  ]],
Cell[82566, 2964, 124, 3, 70, "ExampleDelimiter",
 CellID->34927691],
Cell[82693, 2969, 221, 8, 70, "ExampleText",
 CellID->766667006],
Cell[CellGroupData[{
Cell[82939, 2981, 249, 8, 70, "Input",
 CellID->470487842],
Cell[83191, 2991, 332, 10, 70, "Output",
 CellID->182388948]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[83584, 3008, 222, 7, 70, "ExampleSection",
 CellID->877682495],
Cell[CellGroupData[{
Cell[83831, 3019, 237, 7, 70, "ExampleSubsection",
 CellID->631375571],
Cell[84071, 3028, 123, 3, 70, "ExampleText",
 CellID->1669458155],
Cell[CellGroupData[{
Cell[84219, 3035, 647, 19, 70, "Input",
 CellID->1968973087],
Cell[84869, 3056, 6581, 113, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->279801952]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[91499, 3175, 228, 7, 70, "ExampleSubsection",
 CellID->29310839],
Cell[91730, 3184, 82, 1, 70, "ExampleText",
 CellID->1599517431],
Cell[CellGroupData[{
Cell[91837, 3189, 123, 3, 70, "Input",
 CellID->1999327117],
Cell[91963, 3194, 291, 9, 70, "Output",
 CellID->464861375]
}, Open  ]],
Cell[92269, 3206, 126, 3, 70, "ExampleDelimiter",
 CellID->2083444671],
Cell[92398, 3211, 227, 8, 70, "ExampleText",
 CellID->889169671],
Cell[CellGroupData[{
Cell[92650, 3223, 182, 5, 70, "Input",
 CellID->1014230810],
Cell[92835, 3230, 254, 8, 70, "Output",
 CellID->70470421]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[93138, 3244, 235, 7, 70, "ExampleSubsection",
 CellID->164404388],
Cell[93376, 3253, 117, 3, 70, "ExampleText",
 CellID->395078386],
Cell[93496, 3258, 154, 5, 70, "Input",
 CellID->313154021],
Cell[CellGroupData[{
Cell[93675, 3267, 131, 4, 70, "Input",
 CellID->80771275],
Cell[93809, 3273, 250, 8, 70, "Output",
 CellID->1401624836]
}, Open  ]],
Cell[94074, 3284, 124, 3, 70, "ExampleDelimiter",
 CellID->62996978],
Cell[94201, 3289, 259, 8, 70, "ExampleText",
 CellID->753629656],
Cell[CellGroupData[{
Cell[94485, 3301, 328, 10, 70, "Input",
 CellID->1622834690],
Cell[94816, 3313, 364, 11, 70, "Output",
 CellID->1360494709]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[95229, 3330, 235, 7, 70, "ExampleSubsection",
 CellID->291279474],
Cell[95467, 3339, 160, 6, 70, "ExampleText",
 CellID->1315474446],
Cell[CellGroupData[{
Cell[95652, 3349, 456, 14, 70, "Input",
 CellID->959375399],
Cell[96111, 3365, 838, 25, 70, "Output",
 CellID->338000284]
}, Open  ]],
Cell[96964, 3393, 260, 8, 70, "ExampleText",
 CellID->1308167234],
Cell[CellGroupData[{
Cell[97249, 3405, 292, 10, 70, "Input",
 CellID->1034493938],
Cell[97544, 3417, 491, 16, 70, "Output",
 CellID->294269012]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[98096, 3440, 223, 7, 70, "ExampleSection",
 CellID->22275],
Cell[98322, 3449, 99, 1, 70, "ExampleText",
 CellID->692267766],
Cell[CellGroupData[{
Cell[98446, 3454, 798, 24, 70, "Input",
 CellID->711458599],
Cell[99247, 3480, 448, 14, 70, "Output",
 CellID->1343727000]
}, Open  ]],
Cell[99710, 3497, 121, 3, 70, "ExampleDelimiter",
 CellID->23281],
Cell[99834, 3502, 81, 1, 70, "ExampleText",
 CellID->9961],
Cell[CellGroupData[{
Cell[99940, 3507, 2703, 70, 70, "Input",
 CellID->4671],
Cell[102646, 3579, 1628, 46, 70, "Output",
 CellID->9314507]
}, Open  ]],
Cell[104289, 3628, 125, 3, 70, "ExampleDelimiter",
 CellID->912011704],
Cell[104417, 3633, 252, 8, 70, "ExampleText",
 CellID->1589920489],
Cell[CellGroupData[{
Cell[104694, 3645, 859, 28, 70, "Input",
 CellID->12320488],
Cell[105556, 3675, 705, 20, 70, "Output",
 CellID->215799883]
}, Open  ]],
Cell[106276, 3698, 124, 3, 70, "ExampleDelimiter",
 CellID->79664374],
Cell[106403, 3703, 116, 3, 70, "ExampleText",
 CellID->194087341],
Cell[CellGroupData[{
Cell[106544, 3710, 470, 15, 70, "Input",
 CellID->288435266],
Cell[107017, 3727, 9205, 149, 70, "Output",
 CellID->891795752]
}, Open  ]],
Cell[116237, 3879, 126, 3, 70, "ExampleDelimiter",
 CellID->2025427363],
Cell[116366, 3884, 290, 10, 70, "ExampleText",
 CellID->1594401344],
Cell[CellGroupData[{
Cell[116681, 3898, 1459, 43, 70, "Input",
 CellID->687926783],
Cell[118143, 3943, 819, 22, 70, "Output",
 CellID->266456499]
}, Open  ]],
Cell[118977, 3968, 268, 10, 70, "ExampleText",
 CellID->945459518],
Cell[CellGroupData[{
Cell[119270, 3982, 2115, 62, 70, "Input",
 CellID->1106614873],
Cell[121388, 4046, 1803, 44, 70, "Output",
 CellID->226157848]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[123240, 4096, 226, 7, 70, "ExampleSection",
 CellID->21113],
Cell[123469, 4105, 126, 3, 70, "ExampleText",
 CellID->681533112],
Cell[CellGroupData[{
Cell[123620, 4112, 247, 8, 70, "Input",
 CellID->1996723933],
Cell[123870, 4122, 329, 10, 70, "Output",
 CellID->220595197]
}, Open  ]],
Cell[124214, 4135, 244, 8, 70, "ExampleText",
 CellID->289576182],
Cell[CellGroupData[{
Cell[124483, 4147, 383, 13, 70, "Input",
 CellID->1458879414],
Cell[124869, 4162, 357, 10, 70, "Output",
 CellID->163614118]
}, Open  ]],
Cell[125241, 4175, 126, 3, 70, "ExampleDelimiter",
 CellID->1716591846],
Cell[125370, 4180, 261, 8, 70, "ExampleText",
 CellID->1463841924],
Cell[125634, 4190, 268, 9, 70, "Input",
 CellID->1218556636]
}, Closed]],
Cell[CellGroupData[{
Cell[125939, 4204, 224, 7, 70, "ExampleSection",
 CellID->30234],
Cell[126166, 4213, 186, 8, 70, "ExampleText",
 CellID->59367188],
Cell[CellGroupData[{
Cell[126377, 4225, 420, 15, 70, "Input",
 CellID->802441342],
Cell[126800, 4242, 309, 10, 70, "Output",
 CellID->617226599]
}, Open  ]],
Cell[127124, 4255, 126, 3, 70, "ExampleDelimiter",
 CellID->1418623079],
Cell[127253, 4260, 192, 8, 70, "ExampleText",
 CellID->1351916508],
Cell[CellGroupData[{
Cell[127470, 4272, 2514, 83, 70, "Input",
 CellID->518217885],
Cell[129987, 4357, 765, 23, 70, "Output",
 CellID->2067283028]
}, Open  ]],
Cell[130767, 4383, 126, 3, 70, "ExampleDelimiter",
 CellID->1197599715],
Cell[130896, 4388, 193, 8, 70, "ExampleText",
 CellID->1841670321],
Cell[CellGroupData[{
Cell[131114, 4400, 469, 16, 70, "Input",
 CellID->1271280836],
Cell[131586, 4418, 453, 14, 70, "Output",
 CellID->1102206649]
}, Open  ]],
Cell[132054, 4435, 126, 3, 70, "ExampleDelimiter",
 CellID->1434639759],
Cell[132183, 4440, 117, 3, 70, "ExampleText",
 CellID->44040997],
Cell[CellGroupData[{
Cell[132325, 4447, 517, 16, 70, "Input",
 CellID->958983033],
Cell[132845, 4465, 296, 10, 213, "Output",
 CellID->90806651]
}, Open  ]],
Cell[133156, 4478, 126, 3, 70, "ExampleDelimiter",
 CellID->1462662011],
Cell[133285, 4483, 105, 2, 70, "ExampleText",
 CellID->715111668],
Cell[CellGroupData[{
Cell[133415, 4489, 724, 22, 70, "Input",
 CellID->465044263],
Cell[134142, 4513, 484, 15, 70, "Output",
 CellID->794615663]
}, Open  ]],
Cell[134641, 4531, 126, 3, 70, "ExampleDelimiter",
 CellID->2086411401],
Cell[134770, 4536, 89, 1, 70, "ExampleText",
 CellID->55944744],
Cell[CellGroupData[{
Cell[134884, 4541, 2827, 76, 70, "Input",
 CellID->2115788040],
Cell[137714, 4619, 838, 22, 70, "Output",
 CellID->204692973]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[138613, 4648, 311, 9, 70, "SeeAlsoSection",
 CellID->18228],
Cell[138927, 4659, 2697, 98, 70, "SeeAlso",
 CellID->4741]
}, Open  ]],
Cell[CellGroupData[{
Cell[141661, 4762, 312, 9, 70, "TutorialsSection",
 CellID->360],
Cell[141976, 4773, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[142138, 4778, 173, 3, 70, "Tutorials",
 CellID->558945376]
}, Open  ]],
Cell[CellGroupData[{
Cell[142348, 4786, 305, 8, 70, "RelatedLinksSection"],
Cell[142656, 4796, 359, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[143052, 4813, 318, 9, 70, "MoreAboutSection",
 CellID->67098491],
Cell[143373, 4824, 158, 3, 70, "MoreAbout",
 CellID->685372450],
Cell[143534, 4829, 141, 3, 70, "MoreAbout",
 CellID->537758907],
Cell[143678, 4834, 149, 3, 70, "MoreAbout",
 CellID->680829580],
Cell[143830, 4839, 168, 3, 70, "MoreAbout",
 CellID->310485560],
Cell[144001, 4844, 135, 3, 70, "MoreAbout",
 CellID->358434993],
Cell[144139, 4849, 170, 3, 70, "MoreAbout",
 CellID->435759593],
Cell[144312, 4854, 146, 3, 70, "MoreAbout",
 CellID->25050218],
Cell[144461, 4859, 148, 3, 70, "MoreAbout",
 CellID->12474860],
Cell[144612, 4864, 145, 3, 70, "MoreAbout",
 CellID->170154651],
Cell[144760, 4869, 163, 3, 70, "MoreAbout",
 CellID->357747359],
Cell[144926, 4874, 162, 3, 70, "MoreAbout",
 CellID->288013279],
Cell[145091, 4879, 128, 3, 70, "MoreAbout",
 CellID->483053350],
Cell[145222, 4884, 156, 3, 70, "MoreAbout",
 CellID->270800226],
Cell[145381, 4889, 171, 3, 70, "MoreAbout",
 CellID->19134556],
Cell[145555, 4894, 193, 4, 70, "MoreAbout",
 CellID->802738112]
}, Open  ]],
Cell[145763, 4901, 27, 0, 70, "History"],
Cell[145793, 4903, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

