(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    143611,       3690]
NotebookOptionsPosition[    131813,       3295]
NotebookOutlinePosition[    133927,       3349]
CellTagsIndexPosition[    133805,       3343]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Advanced Dynamic Functionality" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AdvancedDynamicFunctionality"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>", 
       2->"\<\"Advanced Dynamic Functionality\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dynamic" :> Documentation`HelpLookup["paclet:ref/Dynamic"], 
          "Module" :> Documentation`HelpLookup["paclet:ref/Module"], 
          "Manipulate" :> Documentation`HelpLookup["paclet:ref/Manipulate"], 
          "LocalizeVariables" :> 
          Documentation`HelpLookup["paclet:ref/LocalizeVariables"], 
          "Interpretation" :> 
          Documentation`HelpLookup["paclet:ref/Interpretation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Dynamic\"\>", 2->"\<\"Module\"\>", 
       3->"\<\"Manipulate\"\>", 4->"\<\"LocalizeVariables\"\>", 
       5->"\<\"Interpretation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Click-Interactive Panels" :> 
          Documentation`HelpLookup["paclet:guide/ClickInteractivePanels"], 
          "Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "Custom Interface Construction" :> 
          Documentation`HelpLookup[
           "paclet:guide/CustomInterfaceConstruction"], 
          "Dynamic Interactivity Language" :> 
          Documentation`HelpLookup[
           "paclet:guide/DynamicInteractivityLanguage"], 
          "Low-Level Interface Control" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelInterfaceControl"], 
          "Package Development" :> 
          Documentation`HelpLookup["paclet:guide/PackageDevelopment"], 
          "Scoping Constructs" :> 
          Documentation`HelpLookup["paclet:guide/ScopingConstructs"], 
          "New in 6.0: Dynamic Interactivity" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DynamicInteractivity"], 
          "New in 6.0: System Interfaces & Deployment" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60SystemInterfacesAndDeployment"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Click-Interactive Panels\"\>", 
       2->"\<\"Control Objects\"\>", 
       3->"\<\"Custom Interface Construction\"\>", 
       4->"\<\"Dynamic Interactivity Language\"\>", 
       5->"\<\"Low-Level Interface Control\"\>", 
       6->"\<\"Package Development\"\>", 7->"\<\"Scoping Constructs\"\>", 
       8->"\<\"New in 6.0: Dynamic Interactivity\"\>", 
       9->"\<\"New in 6.0: System Interfaces & Deployment\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["DynamicModule", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DynamicModule",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DynamicModule"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents an object which maintains the same local \
instance of the symbols ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", ",
     StyleBox["\[Ellipsis]", "TR"],
     " in the course of all evaluations of ",
     Cell[BoxData[
      ButtonBox["Dynamic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
     " objects in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". Symbols specified in a ",
     Cell[BoxData[
      ButtonBox["DynamicModule",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
     " will by default have their values maintained even across ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " sessions. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DynamicModule",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DynamicModule"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           StyleBox["x", "TI"], "=", 
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["0", "TR"]]}], ",", 
          RowBox[{
           StyleBox["y", "TI"], "=", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["0", "TR"]]}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]specifies initial values for ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", ",
     StyleBox["\[Ellipsis]", "TR"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->12452]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " first gives unique names to local variables in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ", just like ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 ", then evaluates the resulting expression, and then returns a version of \
this wrapped in ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13144],

Cell[TextData[{
 "In a notebook, this returned version will often be displayed in an output \
cell. An example is the output from ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24951],

Cell[TextData[{
 "If interactive changing or editing of ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " objects within the displayed form of a ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " results in changes in any values for local variables, then the ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " object is modified to reflect these. "
}], "Notes",
 CellID->28052],

Cell[TextData[{
 "Values of local variables in a ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " are by default automatically saved when a notebook containing the ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " is saved, so that these values in effect persist across sessions of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Notes",
 CellID->6719],

Cell[TextData[{
 "If you make a copy of a piece of a notebook that contains a ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " object, the local variables in the copy will be independent of the local \
variables in the original, though they will start with the same values. "
}], "Notes",
 CellID->9195],

Cell["The following options can be given: ", "Notes",
 CellID->4048],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Deinitialization",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Deinitialization"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "an expression to evaluate when the ",
     Cell[BoxData[
      ButtonBox["DynamicModule",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
     " can no longer be displayed"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DynamicModuleValues",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DynamicModuleValues"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "dynamically updated data on variable values ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Initialization",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Initialization"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "an expression to evaluate when the ",
     Cell[BoxData[
      ButtonBox["DynamicModule",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
     " is first displayed "
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->18839],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " is first evaluated, initial assignments for local variables are made \
first, and then any setting for the ",
 Cell[BoxData[
  ButtonBox["Initialization",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Initialization"]], "InlineFormula"],
 " option is evaluated. "
}], "Notes",
 CellID->6989],

Cell[TextData[{
 "When a ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " object is displayed for the first time in a particular notebook, saved \
values for local variables are restored, and then any setting for the ",
 Cell[BoxData[
  ButtonBox["Initialization",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Initialization"]], "InlineFormula"],
 " option is evaluated. "
}], "Notes",
 CellID->700],

Cell[TextData[{
 "All values of local variables are saved. Ordinary values of symbols are \
saved in the first argument of the ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 "; other values are saved in the setting for the ",
 Cell[BoxData[
  ButtonBox["DynamicModuleValues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModuleValues"]], "InlineFormula"],
 " option. "
}], "Notes",
 CellID->342420206],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1096],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " constructs can be nested in any way, with inner variables being renamed if \
necessary. "
}], "Notes",
 CellID->4251],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " is a scoping construct that implements lexical scoping. "
}], "Notes",
 CellID->14321]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->15037407],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->650619650],

Cell[TextData[{
 "Create a ",
 Cell[BoxData[
  ButtonBox["Slider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider"]], "InlineFormula"],
 " with a dynamically updating localized variable:"
}], "ExampleText",
 CellID->960015281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Slider", "[", 
      RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
     RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1792754203],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 0.742}, 
  RowBox[{"{", 
   RowBox[{
    SliderBox[Dynamic[$CellContext`x$$]], ",", 
    DynamicBox[ToBoxes[$CellContext`x$$, StandardForm],
     ImageSizeCache->{35., {0., 8.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{265, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->196205302]
}, Open  ]],

Cell["Copy and paste the output above to get standalone object: ", \
"ExampleText",
 CellID->932187856],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 0.232}, 
  RowBox[{"{", 
   RowBox[{
    SliderBox[Dynamic[$CellContext`x$$]], ",", 
    DynamicBox[ToBoxes[$CellContext`x$$, StandardForm],
     ImageSizeCache->{35., {0., 8.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{265, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1235112569],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 0.764}, 
  RowBox[{"{", 
   RowBox[{
    SliderBox[Dynamic[$CellContext`x$$]], ",", 
    DynamicBox[ToBoxes[$CellContext`x$$, StandardForm],
     ImageSizeCache->{35., {0., 8.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{265, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1388090927]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->138743705],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Deinitialization",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1845692940],

Cell["\<\
Specify expressions to be evaluated when output is no longer displayed:\
\>", "ExampleText",
 CellID->1669458155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDialog", "[", 
   RowBox[{"DynamicModule", "[", 
    RowBox[{
     RowBox[{"{", "c", "}"}], ",", 
     RowBox[{"ColorSlider", "[", 
      RowBox[{"Dynamic", "[", "c", "]"}], "]"}], ",", 
     RowBox[{"Initialization", "\[RuleDelayed]", 
      RowBox[{"(", 
       RowBox[{"c", "=", "Pink"}], ")"}]}], ",", 
     RowBox[{"Deinitialization", "\[RuleDelayed]", 
      RowBox[{"(", 
       RowBox[{"CreateDialog", "[", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"c", ",", 
           RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], "]"}], ")"}]}]}], 
    "]"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->540113453],

Cell[BoxData[
 RowBox[{
  GraphicsBox[RasterBox[CompressedData["
1:eJztm3u4T2X+998hhxxXCknKKomR0lLySBrdpdHoYNwdTEnJHT+PDqO6x5hS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    "], {{0, 0}, {184, 71}}, {0, 255}],
   ImageSize->{184 0.75, 71 0.75},
   PlotRange->{{0, 184}, {0, 71}}], 
  GraphicsBox[RasterBox[CompressedData["
1:eJztnflTE1ccwJ3pX9J/pe3PdabjT+1MFaeCtuN02p87HUcqFsFWQAIIhJJy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    "], {{0, 0}, {124, 134}}, {0, 255}],
   ImageSize->{124 0.75, 134 0.75},
   PlotRange->{{0, 124}, {0, 134}}]}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->592883347]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "DynamicModuleValues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1973661258],

Cell[TextData[{
 "Function definitions of local symbols are automatically inserted into ",
 Cell[BoxData[
  ButtonBox["DynamicModuleValues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModuleValues"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->298404015],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", 
  RowBox[{"DynamicModule", "[", 
   RowBox[{
    RowBox[{"{", "c", "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"c", "[", "x_", "]"}], ":=", 
      RowBox[{"{", "x", "}"}]}], ";", 
     RowBox[{"c", "[", "1", "]"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1882730067],

Cell["\<\
DynamicModule[{c}, {1}, DynamicModuleValues :> 
  {{DownValues[c] = {HoldPattern[c[x_]] :> {x}}}}]\
\>", "Output",
 ImageSize->{350, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//InputForm=",
 CellID->6658788]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Initialization",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->904474950],

Cell["\<\
By default, external definitions are lost between kernel session:\
\>", "ExampleText",
 CellID->460779127],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"{", "x", "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->488756407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", "c", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Slider", "[", 
      RowBox[{"Dynamic", "[", "c", "]"}], "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"f", "[", "c", "]"}], "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->403982674],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`c$$ = 0.394}, 
  RowBox[{"{", 
   RowBox[{
    SliderBox[Dynamic[$CellContext`c$$]], ",", 
    DynamicBox[ToBoxes[
      $CellContext`f[$CellContext`c$$], StandardForm],
     ImageSizeCache->{56., {2., 8.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{286, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->308042686]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1556684710],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Initialization",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Initialization"]], "InlineFormula"],
 " to save evaluations necessary for the contect:"
}], "ExampleText",
 CellID->214535166],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", "c", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Slider", "[", 
      RowBox[{"Dynamic", "[", "c", "]"}], "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"g", "[", "c", "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"Initialization", "\[RuleDelayed]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"g", "[", "x_", "]"}], ":=", 
      RowBox[{"{", "x", "}"}]}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->228215644],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`c$$ = 0.388}, 
  RowBox[{"{", 
   RowBox[{
    SliderBox[Dynamic[$CellContext`c$$]], ",", 
    DynamicBox[ToBoxes[
      $CellContext`g[$CellContext`c$$], StandardForm],
     ImageSizeCache->{49., {2., 8.}}]}], "}"}],
  DynamicModuleValues:>{},
  Initialization:>($CellContext`g[
     Pattern[$CellContext`x, 
      Blank[]]] := {$CellContext`x})]], "Output",
 ImageSize->{279, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->277772566]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1266341429],

Cell["Local variables can also be initialzed:", "ExampleText",
 CellID->1837455433],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c", "=", "0.2"}], ",", "g"}], "}"}], ",", "\[IndentingNewLine]",
    
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Slider", "[", 
      RowBox[{"Dynamic", "[", "c", "]"}], "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"g", "[", "c", "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"Initialization", "\[RuleDelayed]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"g", "[", "x_", "]"}], ":=", 
      RowBox[{"{", "x", "}"}]}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1298618571],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`c$$ = 0.2, $CellContext`g$$}, 
  RowBox[{"{", 
   RowBox[{
    SliderBox[Dynamic[$CellContext`c$$]], ",", 
    DynamicBox[ToBoxes[
      $CellContext`g$$[$CellContext`c$$], StandardForm],
     ImageSizeCache->{35., {2., 8.}}]}], "}"}],
  DynamicModuleValues:>{{DownValues[$CellContext`g$$] = {HoldPattern[
         $CellContext`g$$[
          Pattern[$CellContext`x, 
           Blank[]]]] :> {$CellContext`x}}}},
  Initialization:>($CellContext`g$$[
     Pattern[$CellContext`x, 
      Blank[]]] := {$CellContext`x})]], "Output",
 ImageSize->{265, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->138928770]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "SynchronousInitialization",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1621231184],

Cell["\<\
By default, the initializations are evaluated before the output is displayed \
(synchronously):\
\>", "ExampleText",
 CellID->273444537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c", "=", "0.2"}], ",", "g"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Slider", "[", 
      RowBox[{"Dynamic", "[", "c", "]"}], "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"g", "[", "c", "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"Initialization", "\[RuleDelayed]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Pause", "[", "2", "]"}], ";", 
      RowBox[{
       RowBox[{"g", "[", "x_", "]"}], ":=", 
       RowBox[{"{", "x", "}"}]}]}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1948607752],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`c$$ = 0.2, $CellContext`g$$}, 
  RowBox[{"{", 
   RowBox[{
    SliderBox[Dynamic[$CellContext`c$$]], ",", 
    DynamicBox[ToBoxes[
      $CellContext`g$$[$CellContext`c$$], StandardForm],
     ImageSizeCache->{35., {2., 8.}}]}], "}"}],
  DynamicModuleValues:>{{DownValues[$CellContext`g$$] = {HoldPattern[
         $CellContext`g$$[
          Pattern[$CellContext`x, 
           Blank[]]]] :> {$CellContext`x}}}},
  Initialization:>(Pause[2]; $CellContext`g$$[
      Pattern[$CellContext`x, 
       Blank[]]] := {$CellContext`x})]], "Output",
 ImageSize->{265, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->103438097]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1238694730],

Cell["\<\
Force the output to display while the initializations are evaluated \
asynchronously:\
\>", "ExampleText",
 CellID->167328779],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"c", "=", "0.2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Slider", "[", 
      RowBox[{"Dynamic", "[", "c", "]"}], "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"g", "[", "c", "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"Initialization", "\[RuleDelayed]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Pause", "[", "2", "]"}], ";", 
      RowBox[{
       RowBox[{"g", "[", "x_", "]"}], ":=", 
       RowBox[{"{", "x", "}"}]}]}], ")"}]}], ",", 
   RowBox[{"SynchronousInitialization", "\[Rule]", "False"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1120677122],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`c$$ = 0.2}, 
  RowBox[{"{", 
   RowBox[{
    SliderBox[Dynamic[$CellContext`c$$]], ",", 
    DynamicBox[ToBoxes[
      $CellContext`g[$CellContext`c$$], StandardForm],
     ImageSizeCache->{42., {2., 8.}}]}], "}"}],
  DynamicModuleValues:>{},
  Initialization:>(Pause[2]; $CellContext`g[
      Pattern[$CellContext`x, 
       Blank[]]] := {$CellContext`x}),
  SynchronousInitialization->False]], "Output",
 ImageSize->{272, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->294345486]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "UnsavedVariables",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->759996352],

Cell["Specify symbols whose state should not be saved:", "ExampleText",
 CellID->528257342],

Cell[BoxData[
 RowBox[{
  RowBox[{"dm", "=", 
   RowBox[{"DynamicModule", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", 
     RowBox[{"Column", "@", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Slider", "[", 
         RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
        RowBox[{"Slider", "[", 
         RowBox[{"Dynamic", "[", "y", "]"}], "]"}], ",", 
        RowBox[{"Dynamic", "[", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"UnsavedVariables", "\[Rule]", 
      RowBox[{"{", "y", "}"}]}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->163198602],

Cell[TextData[{
 "Evaluate the following and move the two sliders, then hit ",
 StyleBox["Close", "MenuName"],
 ":"
}], "ExampleText",
 CellID->723848264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"DialogInput", "[", 
    RowBox[{"{", 
     RowBox[{"dm", ",", 
      RowBox[{"Button", "[", 
       RowBox[{"\"\<Close\>\"", ",", 
        RowBox[{"DialogReturn", "[", 
         RowBox[{"NotebookGet", "[", "]"}], "]"}]}], "]"}]}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->542286595],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e1PW9cBx3Gk/Q97sSbtNqn/xV6tVRVV6ipNXV+s0hpIgWZV17Wauk5T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   "], {{0, 0}, {224, 142}}, {0, 255}],
  ImageSize->{224 0.75, 142 0.75},
  PlotRange->{{0, 224}, {0, 142}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->150867658]
}, Open  ]],

Cell["\<\
Evaluate the following and note that the second slider does not remember its \
previous state:\
\>", "ExampleText",
 CellID->222912793],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"DialogInput", "[", "nb", "]"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->290204297],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3f9PG+cBx3Gk/Q/7YU3ablL/i/20VVVUqas0df1hldZACjSruq7V1HWa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   "], {{0, 0}, {224, 142}}, {0, 255}],
  ImageSize->{224 0.75, 142 0.75},
  PlotRange->{{0, 224}, {0, 142}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->81061283]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24985],

Cell["Construct a dynamic calculating interface: ", "ExampleText",
 CellID->80083226],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "=", "0"}], ",", 
     RowBox[{"b", "=", "0"}]}], "}"}], ",", 
   RowBox[{"Deploy", "[", 
    RowBox[{"Style", "[", 
     RowBox[{
      RowBox[{"Panel", "[", 
       RowBox[{
        RowBox[{"Grid", "[", 
         RowBox[{
          RowBox[{"Transpose", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Style", "[", 
                RowBox[{"\"\<input a number\>\"", ",", "Red"}], "]"}], ",", 
               RowBox[{"Style", "[", 
                RowBox[{"\"\<input another number\>\"", ",", "Red"}], "]"}], 
               ",", "\"\<here is their sum\>\"", ",", 
               "\"\<their difference\>\"", ",", "\"\<their product\>\""}], 
              "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"InputField", "[", 
                RowBox[{
                 RowBox[{"Dynamic", "[", "a", "]"}], ",", "Number"}], "]"}], 
               ",", 
               RowBox[{"InputField", "[", 
                RowBox[{
                 RowBox[{"Dynamic", "[", "b", "]"}], ",", "Number"}], "]"}], 
               ",", 
               RowBox[{"InputField", "[", 
                RowBox[{
                 RowBox[{"Dynamic", "[", 
                  RowBox[{"a", "+", "b"}], "]"}], ",", 
                 RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}], ",", 
               RowBox[{"InputField", "[", 
                RowBox[{
                 RowBox[{"Dynamic", "[", 
                  RowBox[{"a", "-", "b"}], "]"}], ",", 
                 RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}], ",", 
               RowBox[{"InputField", "[", 
                RowBox[{
                 RowBox[{"Dynamic", "[", 
                  RowBox[{"a", " ", "b"}], "]"}], ",", 
                 RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]}], "}"}]}], 
            "}"}], "]"}], ",", 
          RowBox[{"Alignment", "\[Rule]", "Right"}]}], "]"}], ",", 
        RowBox[{"ImageMargins", "\[Rule]", "10"}]}], "]"}], ",", 
      RowBox[{"DefaultOptions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"InputField", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ContinuousAction", "\[Rule]", "True"}], ",", 
           RowBox[{"FieldSize", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"5", ",", "30"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"1", ",", "Infinity"}], "}"}]}], "}"}]}]}], "}"}]}], 
        "}"}]}]}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4671],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`a$$ = 0, $CellContext`b$$ = 0}, 
  StyleBox[
   StyleBox[
    PanelBox[
     TagBox[GridBox[{
        {
         StyleBox["\<\"input a number\"\>",
          StripOnInput->False,
          FrontFaceColor->RGBColor[1, 0, 0],
          BackFaceColor->RGBColor[1, 0, 0],
          GraphicsColor->RGBColor[1, 0, 0],
          FontColor->RGBColor[1, 0, 0]], 
         InputFieldBox[Dynamic[$CellContext`a$$], Number]},
        {
         StyleBox["\<\"input another number\"\>",
          StripOnInput->False,
          FrontFaceColor->RGBColor[1, 0, 0],
          BackFaceColor->RGBColor[1, 0, 0],
          GraphicsColor->RGBColor[1, 0, 0],
          FontColor->RGBColor[1, 0, 0]], 
         InputFieldBox[Dynamic[$CellContext`b$$], Number]},
        {"\<\"here is their sum\"\>", 
         InputFieldBox[Dynamic[$CellContext`a$$ + $CellContext`b$$],
          Enabled->False]},
        {"\<\"their difference\"\>", 
         InputFieldBox[Dynamic[$CellContext`a$$ - $CellContext`b$$],
          Enabled->False]},
        {"\<\"their product\"\>", 
         InputFieldBox[Dynamic[$CellContext`a$$ $CellContext`b$$],
          Enabled->False]}
       },
       ColumnsEqual->False,
       GridBoxAlignment->{"Columns" -> {{Right}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       RowsEqual->False],
      "Grid"],
     ImageMargins->10],
    StripOnInput->False,
    InputFieldBoxOptions->{ContinuousAction->True,
    FieldSize->{{5, 30}, {1, 
       DirectedInfinity[1]}}}],
   Deployed->True,
   StripOnInput->False],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{208, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->81950854]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->677451917],

Cell["Interactive curve fit plot:", "ExampleText",
 CellID->94935826],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pts", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"LocatorPane", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "pts", "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"InterpolatingPolynomial", "[", 
         RowBox[{"pts", ",", "x"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "3"}]}], "]"}], "]"}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6077861],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`pts$$ = {{0, 0}, {1.025, -1.95}, {2.605, 
   0.15000000000000036`}, {2.93, -0.6499999999999999}}}, 
  LocatorPaneBox[Dynamic[$CellContext`pts$$], 
   DynamicBox[ToBoxes[
     Plot[
      InterpolatingPolynomial[$CellContext`pts$$, $CellContext`x], \
{$CellContext`x, 0, 3}, PlotRange -> 3], StandardForm],
    ImageSizeCache->{180., {55., 59.}}]],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{184, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1218878418]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2025427363],

Cell[TextData[{
 "An angular slider with range (",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 ",",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
 "):"
}], "ExampleText",
 CellID->945459518],

Cell[BoxData[
 RowBox[{
  RowBox[{"angularSlider", "[", 
   RowBox[{"Dynamic", "[", "angle_", "]"}], "]"}], ":=", 
  RowBox[{"DynamicModule", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"p", "=", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], ",", "angleCalc"}], "}"}], ",", 
    RowBox[{"LocatorPane", "[", 
     RowBox[{
      RowBox[{"Dynamic", "[", 
       RowBox[{"p", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"angleCalc", "@@", 
           RowBox[{"Normalize", "/@", 
            RowBox[{"{", 
             RowBox[{"#", ",", "p"}], "}"}]}]}], ")"}], "&"}]}], "]"}], ",", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Circle", "[", "]"}], ",", 
          RowBox[{"Arrowheads", "[", "0.15", "]"}], ",", 
          RowBox[{"Arrow", "[", 
           RowBox[{"Dynamic", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], ",", "p"}], "}"}], "]"}], 
           "]"}]}], "}"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "]"}], ",", 
      RowBox[{"Appearance", "\[Rule]", "None"}]}], "]"}], ",", 
    RowBox[{"Initialization", "\[RuleDelayed]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"angle", "=", "0"}], ";", 
       RowBox[{
        RowBox[{"angleCalc", "[", 
         RowBox[{"newp_", ",", "oldp_"}], "]"}], ":=", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"angle", "=", 
           RowBox[{"angle", "+", 
            RowBox[{
             RowBox[{"ArcCos", "[", 
              RowBox[{"newp", ".", "oldp"}], "]"}], 
             RowBox[{"Sign", "[", 
              RowBox[{
               RowBox[{"Cross", "[", "newp", "]"}], ".", 
               RowBox[{"(", 
                RowBox[{"newp", "-", "oldp"}], ")"}]}], "]"}]}]}]}], ";", 
          RowBox[{"p", "=", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Cos", "[", "angle", "]"}], ",", 
             RowBox[{"Sin", "[", "angle", "]"}]}], "}"}]}]}], ")"}]}]}], 
      ")"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1106614873],

Cell["Connect the slider to a dynamic variable:", "ExampleText",
 CellID->765318648],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"angularSlider", "[", 
    RowBox[{"Dynamic", "[", "\[Theta]", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "\[Theta]", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1547800593],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   DynamicModuleBox[{$CellContext`p$$ = {
    0.3603992792021606, -0.9327981344055974}, $CellContext`angleCalc$$}, 
    LocatorPaneBox[Dynamic[$CellContext`p$$, Apply[$CellContext`angleCalc$$, 
       Map[Normalize, {#, $CellContext`p$$}]]& ], 
     GraphicsBox[{CircleBox[{0, 0}], 
       {Arrowheads[0.15], ArrowBox[Dynamic[{{0, 0}, $CellContext`p$$}]]}},
      ImageSize->Tiny],
     Appearance->None],
    DynamicModuleValues:>{{
      DownValues[$CellContext`angleCalc$$] = {HoldPattern[
           $CellContext`angleCalc$$[
            Pattern[$CellContext`newp$, 
             Blank[]], 
            Pattern[$CellContext`oldp$, 
             Blank[]]]] :> ($CellContext`\[Theta] = $CellContext`\[Theta] + 
            ArcCos[
               Dot[$CellContext`newp$, $CellContext`oldp$]] Sign[
               Dot[
                
                Cross[$CellContext`newp$], $CellContext`newp$ - \
$CellContext`oldp$]]; $CellContext`p$$ = {
             Cos[$CellContext`\[Theta]], 
             Sin[$CellContext`\[Theta]]})}}},
    Initialization:>($CellContext`\[Theta] = 0; $CellContext`angleCalc$$[
        Pattern[$CellContext`newp$, 
         Blank[]], 
        Pattern[$CellContext`oldp$, 
         Blank[]]] := ($CellContext`\[Theta] = $CellContext`\[Theta] + 
         ArcCos[
            Dot[$CellContext`newp$, $CellContext`oldp$]] Sign[
            Dot[
             
             Cross[$CellContext`newp$], $CellContext`newp$ - \
$CellContext`oldp$]]; $CellContext`p$$ = {
          Cos[$CellContext`\[Theta]], 
          Sin[$CellContext`\[Theta]]}))], ",", 
   DynamicBox[ToBoxes[$CellContext`\[Theta], StandardForm],
    ImageSizeCache->{7., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{137, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->30599408]
}, Open  ]],

Cell["Demonstate a sinusoidal relationship:", "ExampleText",
 CellID->1430955053],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]", "=", "0"}], "}"}], ",", 
   RowBox[{"Grid", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"angularSlider", "[", 
         RowBox[{"Dynamic", "[", "\[Theta]", "]"}], "]"}], ",", 
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"Sin", "[", "x", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", 
            RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
          RowBox[{"Epilog", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
             RowBox[{"Dynamic", "@", 
              RowBox[{"Point", "[", 
               RowBox[{"{", 
                RowBox[{"\[Theta]", ",", 
                 RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}], "]"}]}]}], 
            "}"}]}]}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ParametricPlot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", "y", "]"}], ",", "y"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"y", ",", 
            RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
          RowBox[{"AspectRatio", "\[Rule]", "2"}], ",", 
          RowBox[{"Epilog", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
             RowBox[{"Dynamic", "@", 
              RowBox[{"Point", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", "\[Theta]"}], 
                "}"}], "]"}]}]}], "}"}]}]}], "]"}], ",", 
        RowBox[{"Dynamic", "[", "\[Theta]", "]"}]}], "}"}]}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->366453132],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`\[Theta]$$ = -0.21109333322274576`}, 
  TagBox[GridBox[{
     {
      DynamicModuleBox[{$CellContext`p$$ = {
       0.9778024140774096, -0.2095290887308727}, $CellContext`angleCalc$$}, 
       LocatorPaneBox[
        Dynamic[$CellContext`p$$, Apply[$CellContext`angleCalc$$, 
          Map[Normalize, {#, $CellContext`p$$}]]& ], 
        GraphicsBox[{CircleBox[{0, 0}], 
          {Arrowheads[0.15], ArrowBox[Dynamic[{{0, 0}, $CellContext`p$$}]]}},
         ImageSize->Tiny],
        Appearance->None],
       DynamicModuleValues:>{{
         DownValues[$CellContext`angleCalc$$] = {HoldPattern[
              $CellContext`angleCalc$$[
               Pattern[$CellContext`newp$, 
                Blank[]], 
               Pattern[$CellContext`oldp$, 
                
                Blank[]]]] :> ($CellContext`\[Theta]$$ = \
$CellContext`\[Theta]$$ + ArcCos[
                  Dot[$CellContext`newp$, $CellContext`oldp$]] Sign[
                  Dot[
                   
                   Cross[$CellContext`newp$], $CellContext`newp$ - \
$CellContext`oldp$]]; $CellContext`p$$ = {
                Cos[$CellContext`\[Theta]$$], 
                Sin[$CellContext`\[Theta]$$]})}}},
       Initialization:>($CellContext`\[Theta]$$ = 
         0; $CellContext`angleCalc$$[
           Pattern[$CellContext`newp$, 
            Blank[]], 
           Pattern[$CellContext`oldp$, 
            Blank[]]] := ($CellContext`\[Theta]$$ = $CellContext`\[Theta]$$ + 
            ArcCos[
               Dot[$CellContext`newp$, $CellContext`oldp$]] Sign[
               Dot[
                
                Cross[$CellContext`newp$], $CellContext`newp$ - \
$CellContext`oldp$]]; $CellContext`p$$ = {
             Cos[$CellContext`\[Theta]$$], 
             Sin[$CellContext`\[Theta]$$]}))], 
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwte3k41N/7PrKVfQbZZ1CUtSSp5JxWRCUV8kZZCyUpS5GUpRIVEZVkKQll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          "]]}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->True,
       AxesOrigin->{0, 0},
       Epilog->{
         PointSize[Medium], 
         DynamicBox[
          Typeset`ToBoxes[
           Point[{$CellContext`\[Theta]$$, 
             Sin[$CellContext`\[Theta]$$]}], StandardForm, Graphics]]},
       PlotRange->{{-10, 10}, {-0.9999999784391316, 0.9999999998606331}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}]},
     {
      GraphicsBox[{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxdm3lcTN//x9O+b1pm2jQzlmgRpSKcQ7RSQhsKIamUUIgiEi2ixZaoFFG2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          "]]}},
       AspectRatio->2,
       Axes->True,
       AxesOrigin->{0, 0},
       Epilog->{
         PointSize[Medium], 
         DynamicBox[
          Typeset`ToBoxes[
           Point[{
             Cos[$CellContext`\[Theta]$$], $CellContext`\[Theta]$$}], 
           StandardForm, Graphics]]},
       PlotRange->{{-0.9999999493372285, 0.9999998273412389}, {-10., 10.}},
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}], 
      DynamicBox[ToBoxes[$CellContext`\[Theta]$$, StandardForm],
       ImageSizeCache->{63.6875, {0., 8.}}]}
    },
    ColumnsEqual->False,
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
    RowsEqual->False],
   "Grid"],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{311, 339},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->42264777]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PolarPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolarPlot"]], "InlineFormula"],
 " to demonstate spiral curve:"
}], "ExampleText",
 CellID->1450592145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]", "=", "0"}], "}"}], ",", 
   RowBox[{"Grid", "[", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"angularSlider", "[", 
        RowBox[{"Dynamic", "[", "\[Theta]", "]"}], "]"}], ",", 
       RowBox[{"Dynamic", "@", 
        RowBox[{"PolarPlot", "[", 
         RowBox[{"t", ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", 
            RowBox[{"-", "Pi"}], ",", "\[Theta]"}], "}"}], ",", 
          RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "]"}]}]}], "}"}], "}"}],
     "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->676617417],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`\[Theta]$$ = 0}, 
  TagBox[GridBox[{
     {
      DynamicModuleBox[{$CellContext`p$$ = {1, 0}, $CellContext`angleCalc$$}, 
       
       LocatorPaneBox[
        Dynamic[$CellContext`p$$, Apply[$CellContext`angleCalc$$, 
          Map[Normalize, {#, $CellContext`p$$}]]& ], 
        GraphicsBox[{CircleBox[{0, 0}], 
          {Arrowheads[0.15], ArrowBox[Dynamic[{{0, 0}, $CellContext`p$$}]]}},
         ImageSize->Tiny],
        Appearance->None],
       DynamicModuleValues:>{{
         DownValues[$CellContext`angleCalc$$] = {HoldPattern[
              $CellContext`angleCalc$$[
               Pattern[$CellContext`newp$, 
                Blank[]], 
               Pattern[$CellContext`oldp$, 
                
                Blank[]]]] :> ($CellContext`\[Theta]$$ = \
$CellContext`\[Theta]$$ + ArcCos[
                  Dot[$CellContext`newp$, $CellContext`oldp$]] Sign[
                  Dot[
                   
                   Cross[$CellContext`newp$], $CellContext`newp$ - \
$CellContext`oldp$]]; $CellContext`p$$ = {
                Cos[$CellContext`\[Theta]$$], 
                Sin[$CellContext`\[Theta]$$]})}}},
       Initialization:>($CellContext`\[Theta]$$ = 
         0; $CellContext`angleCalc$$[
           Pattern[$CellContext`newp$, 
            Blank[]], 
           Pattern[$CellContext`oldp$, 
            Blank[]]] := ($CellContext`\[Theta]$$ = $CellContext`\[Theta]$$ + 
            ArcCos[
               Dot[$CellContext`newp$, $CellContext`oldp$]] Sign[
               Dot[
                
                Cross[$CellContext`newp$], $CellContext`newp$ - \
$CellContext`oldp$]]; $CellContext`p$$ = {
             Cos[$CellContext`\[Theta]$$], 
             Sin[$CellContext`\[Theta]$$]}))], 
      DynamicBox[ToBoxes[
        PolarPlot[$CellContext`t, {$CellContext`t, -
          Pi, $CellContext`\[Theta]$$}, ImageSize -> Tiny], StandardForm],
       ImageSizeCache->{100., {28., 32.}}]}
    },
    ColumnsEqual->False,
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
    RowsEqual->False],
   "Grid"],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{212, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->76784499]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2130],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " are fundamentally different although they seem similar:"
}], "ExampleText",
 CellID->951884767],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"Slider", "[", 
      RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
     RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1721592466],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 0.}, 
  RowBox[{"{", 
   RowBox[{"x$$", ",", 
    SliderBox[Dynamic[$CellContext`x$$]], ",", 
    DynamicBox[ToBoxes[$CellContext`x$$, StandardForm],
     ImageSizeCache->{14., {0., 8.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{276, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->370589710]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["%"], "Input",
 CellLabel->"In[2]:=",
 CellID->195334211],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 0.}, 
  RowBox[{"{", 
   RowBox[{"x$$", ",", 
    SliderBox[Dynamic[$CellContext`x$$]], ",", 
    DynamicBox[ToBoxes[$CellContext`x$$, StandardForm],
     ImageSizeCache->{14., {0., 8.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{276, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27716186]
}, Open  ]],

Cell["\<\
In this case both sliders will move, and will also not work without \
evaluation when reopened:\
\>", "ExampleText",
 CellID->38933520],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"Slider", "[", 
      RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
     RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->132240179],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x$19797", ",", 
   SliderBox[Dynamic[$CellContext`x$19797]], ",", 
   DynamicBox[ToBoxes[$CellContext`x$19797, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{304, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->608198578]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["%"], "Input",
 CellLabel->"In[4]:=",
 CellID->879052678],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", 
   SliderBox[Dynamic[$CellContext`x$19797]], ",", 
   DynamicBox[ToBoxes[$CellContext`x$19797, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{269, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->43578873]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1394396311],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " relies on ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " to create the output:"
}], "ExampleText",
 CellID->129759266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1168081957],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 0., Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}}, Typeset`size$$ = {14.375, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$4584$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`x$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$4584$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`x$$, 
      "Specifications" :> {{$CellContext`x$$, 0, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{249., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{253, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->822435781]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Slider", "[", 
      RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
     RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1694039188],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 0.738}, 
  RowBox[{"{", 
   RowBox[{
    SliderBox[Dynamic[$CellContext`x$$]], ",", 
    DynamicBox[ToBoxes[$CellContext`x$$, StandardForm],
     ImageSizeCache->{35., {0., 8.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{265, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->369135117]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31354],

Cell["Independent state sliders: ", "ExampleText",
 CellID->94557479],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"DynamicModule", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{"Slider2D", "[", 
        RowBox[{"Dynamic", "[", "x", "]"}], "]"}]}], "]"}], "+", "1"}], ")"}],
    "^", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->415732960],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"3", " ", 
   DynamicModuleBox[{$CellContext`x$$ = {0., 0.04}}, 
    Slider2DBox[Dynamic[$CellContext`x$$]],
    DynamicModuleValues:>{}]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox[
    DynamicModuleBox[{$CellContext`x$$ = {0., 0.}}, 
     Slider2DBox[Dynamic[$CellContext`x$$]],
     DynamicModuleValues:>{}], "2"]}], "+", 
  SuperscriptBox[
   DynamicModuleBox[{$CellContext`x$$ = {0., 0.}}, 
    Slider2DBox[Dynamic[$CellContext`x$$]],
    DynamicModuleValues:>{}], "3"]}]], "Output",
 ImageSize->{320, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->110953972]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2086411401],

Cell["Click in the framed area to see bouncing balls:", "ExampleText",
 CellID->55944744],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"DynamicModule", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"contents", "=", 
      RowBox[{"{", "}"}]}], "}"}], ",", 
    RowBox[{"EventHandler", "[", 
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PointSize", "[", "0.1", "]"}], ",", 
          RowBox[{"Point", "[", 
           RowBox[{"Dynamic", "[", 
            RowBox[{
             RowBox[{"contents", "=", 
              RowBox[{"Map", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "2"}], "]"}], "]"}], "\[GreaterEqual]", 
                    "0"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "-", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0.001"}], "}"}]}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "0"}], "}"}], 
                    ",", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", 
                    RowBox[{"-", "0.8"}]}], "}"}], 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}]}], "]"}], "&"}],
                 ",", "contents"}], "]"}]}], ";", 
             RowBox[{"Map", "[", 
              RowBox[{"First", ",", "contents"}], "]"}]}], "]"}], "]"}]}], 
         "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "80"}]}], "]"}], ",", 
      RowBox[{"\"\<MouseDown\>\"", "\[RuleDelayed]", 
       RowBox[{"(", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"contents", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"MousePosition", "[", "\"\<Graphics\>\"", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], "]"}], ")"}]}]}], 
     "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2115788040],

Cell[BoxData[
 FrameBox[
  DynamicModuleBox[{$CellContext`contents$$ = {}}, 
   TagBox[
    GraphicsBox[
     {PointSize[0.1], 
      PointBox[Dynamic[$CellContext`contents$$ = 
         Map[If[Part[#, 1, 2] >= 0, {
            Part[#, 1] - Part[#, 2], Part[#, 2] + {0, 0.001}}, {{
             Part[#, 1, 1], 0}, {1, -0.8} 
             Part[#, 2]}]& , $CellContext`contents$$]; 
        Map[First, $CellContext`contents$$]]]},
     ImageSize->80,
     PlotRange->{{0, 1}, {0, 1}}],
    EventHandlerTag[{"MouseDown" :> AppendTo[$CellContext`contents$$, {
         MousePosition["Graphics"], {0, 0}}], PassEventsDown -> Automatic, 
      PassEventsUp -> True}]],
   DynamicModuleValues:>{}],
  StripOnInput->False]], "Output",
 ImageSize->{94, 92},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->540168858]
}, Open  ]],

Cell["\<\
Select the output and expand; click in the different frames to create \
additional balls:\
\>", "ExampleText",
 CellID->50354489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"%", "+", "1"}], ")"}], "^", "3"}], "//", "Expand"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->532919221],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"3", " ", 
   FrameBox[
    DynamicModuleBox[{$CellContext`contents$$ = {}}, 
     TagBox[
      GraphicsBox[
       {PointSize[0.1], 
        PointBox[
         Dynamic[$CellContext`contents$$ = 
           Map[If[Part[#, 1, 2] >= 0, {
              Part[#, 1] - Part[#, 2], Part[#, 2] + {0, 0.001}}, {{
               Part[#, 1, 1], 0}, {1, -0.8} 
               Part[#, 2]}]& , $CellContext`contents$$]; 
          Map[First, $CellContext`contents$$]]]},
       ImageSize->80,
       PlotRange->{{0, 1}, {0, 1}}],
      EventHandlerTag[{"MouseDown" :> AppendTo[$CellContext`contents$$, {
           MousePosition["Graphics"], {0, 0}}], PassEventsDown -> Automatic, 
        PassEventsUp -> True}]],
     DynamicModuleValues:>{}],
    StripOnInput->False]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox[
    FrameBox[
     DynamicModuleBox[{$CellContext`contents$$ = {}}, 
      TagBox[
       GraphicsBox[
        {PointSize[0.1], 
         PointBox[
          Dynamic[$CellContext`contents$$ = 
            Map[If[Part[#, 1, 2] >= 0, {
               Part[#, 1] - Part[#, 2], Part[#, 2] + {0, 0.001}}, {{
                Part[#, 1, 1], 0}, {1, -0.8} 
                Part[#, 2]}]& , $CellContext`contents$$]; 
           Map[First, $CellContext`contents$$]]]},
        ImageSize->80,
        PlotRange->{{0, 1}, {0, 1}}],
       EventHandlerTag[{"MouseDown" :> AppendTo[$CellContext`contents$$, {
            MousePosition["Graphics"], {0, 0}}], PassEventsDown -> Automatic, 
         PassEventsUp -> True}]],
      DynamicModuleValues:>{}],
     StripOnInput->False], "2"]}], "+", 
  SuperscriptBox[
   FrameBox[
    DynamicModuleBox[{$CellContext`contents$$ = {}}, 
     TagBox[
      GraphicsBox[
       {PointSize[0.1], 
        PointBox[
         Dynamic[$CellContext`contents$$ = 
           Map[If[Part[#, 1, 2] >= 0, {
              Part[#, 1] - Part[#, 2], Part[#, 2] + {0, 0.001}}, {{
               Part[#, 1, 1], 0}, {1, -0.8} 
               Part[#, 2]}]& , $CellContext`contents$$]; 
          Map[First, $CellContext`contents$$]]]},
       ImageSize->80,
       PlotRange->{{0, 1}, {0, 1}}],
      EventHandlerTag[{"MouseDown" :> AppendTo[$CellContext`contents$$, {
           MousePosition["Graphics"], {0, 0}}], PassEventsDown -> Automatic, 
        PassEventsUp -> True}]],
     DynamicModuleValues:>{}],
    StripOnInput->False], "3"]}]], "Output",
 ImageSize->{350, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->125656365]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31545],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Module",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Module"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Manipulate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manipulate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LocalizeVariables",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LocalizeVariables"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Interpretation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Interpretation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17716]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31475],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Advanced Dynamic Functionality",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality"]], "Tutorials",
 CellID->558945376]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with DynamicModule",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=DynamicModule"],
     None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->97998685],

Cell[TextData[ButtonBox["Click-Interactive Panels",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ClickInteractivePanels"]], "MoreAbout",
 CellID->98190108],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->20745881],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "MoreAbout",
 CellID->295722636],

Cell[TextData[ButtonBox["Dynamic Interactivity Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicInteractivityLanguage"]], "MoreAbout",
 CellID->147693991],

Cell[TextData[ButtonBox["Low-Level Interface Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelInterfaceControl"]], "MoreAbout",
 CellID->329508590],

Cell[TextData[ButtonBox["Package Development",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageDevelopment"]], "MoreAbout",
 CellID->262217766],

Cell[TextData[ButtonBox["Scoping Constructs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ScopingConstructs"]], "MoreAbout",
 CellID->53258868],

Cell[TextData[ButtonBox["New in 6.0: Dynamic Interactivity",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DynamicInteractivity"]], "MoreAbout",
 CellID->398760665],

Cell[TextData[ButtonBox["New in 6.0: System Interfaces & Deployment",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60SystemInterfacesAndDeployment"]], "MoreAbout",
 CellID->132372590]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DynamicModule - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 39, 26.4161006}", "context" -> "System`", 
    "keywords" -> {
     "dynamic scoping", "scoping of dynamic variables", "scoping ", 
      "programmatic scoping", "localize dynamic variables", 
      "copyable dynamic programs", "standalone dynamic programs"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "DynamicModule[{x, y, ...}, expr] represents an object which maintains \
the same local instance of the symbols x, y, ... in the course of all \
evaluations of Dynamic objects in expr. Symbols specified in a DynamicModule \
will by default have their values maintained even across Mathematica \
sessions. DynamicModule[{x = x_0, y = y_0, ...}, expr] specifies initial \
values for x, y, .... ", "synonyms" -> {"dynamic module"}, "title" -> 
    "DynamicModule", "type" -> "Symbol", "uri" -> "ref/DynamicModule"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[15515, 465, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->15037407]},
 "Notebook Image"->{
  Cell[19356, 609, 15952, 267, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->592883347],
  Cell[45913, 1269, 3580, 61, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->150867658],
  Cell[49832, 1348, 3490, 60, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->81061283]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 133325, 3326},
 {"Notebook Image", 133466, 3330}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3794, 82, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4417, 109, 1578, 37, 70, "ObjectNameGrid"],
Cell[5998, 148, 2431, 77, 70, "Usage",
 CellID->12452]
}, Open  ]],
Cell[CellGroupData[{
Cell[8466, 230, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8944, 247, 649, 21, 70, "Notes",
 CellID->13144],
Cell[9596, 270, 290, 9, 70, "Notes",
 CellID->24951],
Cell[9889, 281, 618, 18, 70, "Notes",
 CellID->28052],
Cell[10510, 301, 538, 16, 70, "Notes",
 CellID->6719],
Cell[11051, 319, 389, 9, 70, "Notes",
 CellID->9195],
Cell[11443, 330, 68, 1, 70, "Notes",
 CellID->4048],
Cell[11514, 333, 1693, 46, 70, "3ColumnTableMod",
 CellID->18839],
Cell[13210, 381, 452, 14, 70, "Notes",
 CellID->6989],
Cell[13665, 397, 489, 14, 70, "Notes",
 CellID->700],
Cell[14157, 413, 498, 14, 70, "Notes",
 CellID->342420206],
Cell[14658, 429, 315, 12, 70, "Notes",
 CellID->1096],
Cell[14976, 443, 265, 8, 70, "Notes",
 CellID->4251],
Cell[15244, 453, 234, 7, 70, "Notes",
 CellID->14321]
}, Closed]],
Cell[CellGroupData[{
Cell[15515, 465, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->15037407],
Cell[CellGroupData[{
Cell[15899, 479, 148, 5, 70, "ExampleSection",
 CellID->650619650],
Cell[16050, 486, 235, 8, 70, "ExampleText",
 CellID->960015281],
Cell[CellGroupData[{
Cell[16310, 498, 317, 10, 28, "Input",
 CellID->1792754203],
Cell[16630, 510, 410, 12, 46, "Output",
 CellID->196205302]
}, Open  ]],
Cell[17055, 525, 103, 2, 32, "ExampleText",
 CellID->932187856],
Cell[17161, 529, 411, 12, 46, "Output",
 CellID->1235112569],
Cell[17575, 543, 411, 12, 46, "Output",
 CellID->1388090927]
}, Open  ]],
Cell[CellGroupData[{
Cell[18023, 560, 222, 7, 70, "ExampleSection",
 CellID->138743705],
Cell[CellGroupData[{
Cell[18270, 571, 238, 7, 70, "ExampleSubsection",
 CellID->1845692940],
Cell[18511, 580, 123, 3, 70, "ExampleText",
 CellID->1669458155],
Cell[CellGroupData[{
Cell[18659, 587, 694, 20, 70, "Input",
 CellID->540113453],
Cell[19356, 609, 15952, 267, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->592883347]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[35357, 882, 241, 7, 70, "ExampleSubsection",
 CellID->1973661258],
Cell[35601, 891, 275, 8, 70, "ExampleText",
 CellID->298404015],
Cell[CellGroupData[{
Cell[35901, 903, 338, 11, 70, "Input",
 CellID->1882730067],
Cell[36242, 916, 264, 8, 66, "Output",
 CellID->6658788]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[36555, 930, 235, 7, 70, "ExampleSubsection",
 CellID->904474950],
Cell[36793, 939, 116, 3, 70, "ExampleText",
 CellID->460779127],
Cell[36912, 944, 145, 5, 70, "Input",
 CellID->488756407],
Cell[CellGroupData[{
Cell[37082, 953, 348, 11, 70, "Input",
 CellID->403982674],
Cell[37433, 966, 433, 13, 70, "Output",
 CellID->308042686]
}, Open  ]],
Cell[37881, 982, 126, 3, 70, "ExampleDelimiter",
 CellID->1556684710],
Cell[38010, 987, 245, 8, 70, "ExampleText",
 CellID->214535166],
Cell[CellGroupData[{
Cell[38280, 999, 520, 16, 70, "Input",
 CellID->228215644],
Cell[38803, 1017, 536, 16, 70, "Output",
 CellID->277772566]
}, Open  ]],
Cell[39354, 1036, 126, 3, 70, "ExampleDelimiter",
 CellID->1266341429],
Cell[39483, 1041, 83, 1, 70, "ExampleText",
 CellID->1837455433],
Cell[CellGroupData[{
Cell[39591, 1046, 601, 19, 70, "Input",
 CellID->1298618571],
Cell[40195, 1067, 707, 19, 70, "Output",
 CellID->138928770]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40951, 1092, 247, 7, 70, "ExampleSubsection",
 CellID->1621231184],
Cell[41201, 1101, 146, 4, 70, "ExampleText",
 CellID->273444537],
Cell[CellGroupData[{
Cell[41372, 1109, 639, 20, 70, "Input",
 CellID->1948607752],
Cell[42014, 1131, 719, 19, 70, "Output",
 CellID->103438097]
}, Open  ]],
Cell[42748, 1153, 126, 3, 70, "ExampleDelimiter",
 CellID->1238694730],
Cell[42877, 1158, 136, 4, 70, "ExampleText",
 CellID->167328779],
Cell[CellGroupData[{
Cell[43038, 1166, 684, 21, 70, "Input",
 CellID->1120677122],
Cell[43725, 1189, 582, 17, 70, "Output",
 CellID->294345486]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[44356, 1212, 237, 7, 70, "ExampleSubsection",
 CellID->759996352],
Cell[44596, 1221, 91, 1, 70, "ExampleText",
 CellID->528257342],
Cell[44690, 1224, 671, 20, 70, "Input",
 CellID->163198602],
Cell[45364, 1246, 154, 5, 70, "ExampleText",
 CellID->723848264],
Cell[CellGroupData[{
Cell[45543, 1255, 367, 12, 70, "Input",
 CellID->542286595],
Cell[45913, 1269, 3580, 61, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->150867658]
}, Open  ]],
Cell[49508, 1333, 145, 4, 70, "ExampleText",
 CellID->222912793],
Cell[CellGroupData[{
Cell[49678, 1341, 151, 5, 70, "Input",
 CellID->290204297],
Cell[49832, 1348, 3490, 60, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->81061283]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[53383, 1415, 223, 7, 70, "ExampleSection",
 CellID->24985],
Cell[53609, 1424, 85, 1, 70, "ExampleText",
 CellID->80083226],
Cell[CellGroupData[{
Cell[53719, 1429, 2707, 69, 70, "Input",
 CellID->4671],
Cell[56429, 1500, 1778, 50, 70, "Output",
 CellID->81950854]
}, Open  ]],
Cell[58222, 1553, 125, 3, 70, "ExampleDelimiter",
 CellID->677451917],
Cell[58350, 1558, 69, 1, 70, "ExampleText",
 CellID->94935826],
Cell[CellGroupData[{
Cell[58444, 1563, 898, 28, 70, "Input",
 CellID->6077861],
Cell[59345, 1593, 565, 14, 70, "Output",
 CellID->1218878418]
}, Open  ]],
Cell[59925, 1610, 126, 3, 70, "ExampleDelimiter",
 CellID->2025427363],
Cell[60054, 1615, 268, 10, 70, "ExampleText",
 CellID->945459518],
Cell[60325, 1627, 2164, 62, 70, "Input",
 CellID->1106614873],
Cell[62492, 1691, 84, 1, 70, "ExampleText",
 CellID->765318648],
Cell[CellGroupData[{
Cell[62601, 1696, 242, 7, 70, "Input",
 CellID->1547800593],
Cell[62846, 1705, 1864, 45, 70, "Output",
 CellID->30599408]
}, Open  ]],
Cell[64725, 1753, 81, 1, 70, "ExampleText",
 CellID->1430955053],
Cell[CellGroupData[{
Cell[64831, 1758, 1873, 52, 70, "Input",
 CellID->366453132],
Cell[66707, 1812, 42390, 731, 70, "Output",
 CellID->42264777]
}, Open  ]],
Cell[109112, 2546, 217, 8, 70, "ExampleText",
 CellID->1450592145],
Cell[CellGroupData[{
Cell[109354, 2558, 668, 20, 70, "Input",
 CellID->676617417],
Cell[110025, 2580, 2279, 57, 70, "Output",
 CellID->76784499]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[112353, 2643, 232, 7, 70, "ExampleSection",
 CellID->2130],
Cell[112588, 2652, 368, 12, 70, "ExampleText",
 CellID->951884767],
Cell[CellGroupData[{
Cell[112981, 2668, 327, 10, 70, "Input",
 CellID->1721592466],
Cell[113311, 2680, 419, 12, 70, "Output",
 CellID->370589710]
}, Open  ]],
Cell[CellGroupData[{
Cell[113767, 2697, 70, 2, 70, "Input",
 CellID->195334211],
Cell[113840, 2701, 418, 12, 70, "Output",
 CellID->27716186]
}, Open  ]],
Cell[114273, 2716, 145, 4, 70, "ExampleText",
 CellID->38933520],
Cell[CellGroupData[{
Cell[114443, 2724, 319, 10, 70, "Input",
 CellID->132240179],
Cell[114765, 2736, 354, 10, 70, "Output",
 CellID->608198578]
}, Open  ]],
Cell[CellGroupData[{
Cell[115156, 2751, 70, 2, 70, "Input",
 CellID->879052678],
Cell[115229, 2755, 349, 10, 70, "Output",
 CellID->43578873]
}, Open  ]],
Cell[115593, 2768, 126, 3, 70, "ExampleDelimiter",
 CellID->1394396311],
Cell[115722, 2773, 348, 12, 70, "ExampleText",
 CellID->129759266],
Cell[CellGroupData[{
Cell[116095, 2789, 189, 6, 70, "Input",
 CellID->1168081957],
Cell[116287, 2797, 1560, 35, 70, "Output",
 CellID->822435781]
}, Open  ]],
Cell[CellGroupData[{
Cell[117884, 2837, 317, 10, 70, "Input",
 CellID->1694039188],
Cell[118204, 2849, 410, 12, 70, "Output",
 CellID->369135117]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[118663, 2867, 224, 7, 70, "ExampleSection",
 CellID->31354],
Cell[118890, 2876, 69, 1, 70, "ExampleText",
 CellID->94557479],
Cell[CellGroupData[{
Cell[118984, 2881, 356, 12, 70, "Input",
 CellID->415732960],
Cell[119343, 2895, 667, 19, 70, "Output",
 CellID->110953972]
}, Open  ]],
Cell[120025, 2917, 126, 3, 70, "ExampleDelimiter",
 CellID->2086411401],
Cell[120154, 2922, 89, 1, 70, "ExampleText",
 CellID->55944744],
Cell[CellGroupData[{
Cell[120268, 2927, 2881, 77, 70, "Input",
 CellID->2115788040],
Cell[123152, 3006, 856, 23, 70, "Output",
 CellID->540168858]
}, Open  ]],
Cell[124023, 3032, 139, 4, 70, "ExampleText",
 CellID->50354489],
Cell[CellGroupData[{
Cell[124187, 3040, 170, 6, 70, "Input",
 CellID->532919221],
Cell[124360, 3048, 2547, 67, 70, "Output",
 CellID->125656365]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[126968, 3122, 311, 9, 70, "SeeAlsoSection",
 CellID->31545],
Cell[127282, 3133, 1214, 44, 70, "SeeAlso",
 CellID->17716]
}, Open  ]],
Cell[CellGroupData[{
Cell[128533, 3182, 314, 9, 70, "TutorialsSection",
 CellID->31475],
Cell[128850, 3193, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[129012, 3198, 173, 3, 70, "Tutorials",
 CellID->558945376]
}, Open  ]],
Cell[CellGroupData[{
Cell[129222, 3206, 305, 8, 70, "RelatedLinksSection"],
Cell[129530, 3216, 371, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[129938, 3233, 318, 9, 70, "MoreAboutSection",
 CellID->97998685],
Cell[130259, 3244, 157, 3, 70, "MoreAbout",
 CellID->98190108],
Cell[130419, 3249, 140, 3, 70, "MoreAbout",
 CellID->20745881],
Cell[130562, 3254, 168, 3, 70, "MoreAbout",
 CellID->295722636],
Cell[130733, 3259, 170, 3, 70, "MoreAbout",
 CellID->147693991],
Cell[130906, 3264, 163, 3, 70, "MoreAbout",
 CellID->329508590],
Cell[131072, 3269, 149, 3, 70, "MoreAbout",
 CellID->262217766],
Cell[131224, 3274, 146, 3, 70, "MoreAbout",
 CellID->53258868],
Cell[131373, 3279, 172, 3, 70, "MoreAbout",
 CellID->398760665],
Cell[131548, 3284, 193, 4, 70, "MoreAbout",
 CellID->132372590]
}, Open  ]],
Cell[131756, 3291, 27, 0, 70, "History"],
Cell[131786, 3293, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

