(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29829,        869]
NotebookOptionsPosition[     25853,        735]
NotebookOutlinePosition[     27273,        774]
CellTagsIndexPosition[     27188,        769]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Generalized Input" :> 
          Documentation`HelpLookup["paclet:tutorial/GeneralizedInput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Generalized Input\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Interpretation" :> 
          Documentation`HelpLookup["paclet:ref/Interpretation"], "Setting" :> 
          Documentation`HelpLookup["paclet:ref/Setting"], "Dynamic" :> 
          Documentation`HelpLookup["paclet:ref/Dynamic"], "Defer" :> 
          Documentation`HelpLookup["paclet:ref/Defer"], "Slider" :> 
          Documentation`HelpLookup["paclet:ref/Slider"], "Checkbox" :> 
          Documentation`HelpLookup["paclet:ref/Checkbox"], "ColorSetter" :> 
          Documentation`HelpLookup["paclet:ref/ColorSetter"], "ColorSlider" :> 
          Documentation`HelpLookup["paclet:ref/ColorSlider"], "Manipulate" :> 
          Documentation`HelpLookup["paclet:ref/Manipulate"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Interpretation\"\>", 
       2->"\<\"Setting\"\>", 3->"\<\"Dynamic\"\>", 4->"\<\"Defer\"\>", 
       5->"\<\"Slider\"\>", 6->"\<\"Checkbox\"\>", 7->"\<\"ColorSetter\"\>", 
       8->"\<\"ColorSlider\"\>", 9->"\<\"Manipulate\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "Defining Custom Notation" :> 
          Documentation`HelpLookup["paclet:guide/DefiningCustomNotation"], 
          "Generalized Input" :> 
          Documentation`HelpLookup["paclet:guide/GeneralizedInput"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Control Objects\"\>", 
       2->"\<\"Defining Custom Notation\"\>", 
       3->"\<\"Generalized Input\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["DynamicSetting", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DynamicSetting",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DynamicSetting"], "[", 
       StyleBox["e", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents an object which displays as ",
     Cell[BoxData[
      StyleBox["e", "TI"]], "InlineFormula"],
     ", but is interpreted as the dynamically updated current value of ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Setting",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Setting"], "[", 
       StyleBox["e", "TI"], "]"}]], "InlineFormula"],
     " if supplied as ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " input."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DynamicSetting",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DynamicSetting"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["e", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]displays as ",
     Cell[BoxData[
      FormBox["e", TraditionalForm]], "InlineMath"],
     ", but is interpreted as ",
     Cell[BoxData[
      FormBox[
       RowBox[{"f", "(", "e", ")"}], TraditionalForm]], "InlineMath"],
     " if supplied as input."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->19978]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DynamicSetting",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DynamicSetting"], "[", 
   StyleBox["e", "TI"], "]"}]], "InlineFormula"],
 " returns an object which remains unchanged until it is explicitly supplied \
as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input, and evaluated using ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Enter", "KeyEvent"],
 ", ",
 StyleBox["Evaluate in Place", "MenuName"],
 ", etc."
}], "Notes",
 CellID->10748],

Cell[TextData[{
 "In the object returned by ",
 Cell[BoxData[
  ButtonBox["DynamicSetting",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicSetting"]], "InlineFormula"],
 " all controls such as sliders are operable."
}], "Notes",
 CellID->2850]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->41894167],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->1614597],

Cell["\<\
Displays as a slider, but gives the slider's setting when used as input: \
\>", "ExampleText",
 CellID->16061],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicSetting", "[", 
  RowBox[{"Slider", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3904],

Cell[BoxData[
 TagBox[
  SliderBox[0.5],
  Setting]], "Output",
 ImageSize->{204, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->86337787]
}, Open  ]],

Cell["Copy the output to use as active input:", "ExampleText",
 CellID->17571],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    SliderBox[0.5],
    Setting], ",", 
   TagBox[
    SliderBox[0.848],
    Setting]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26886],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.5`", ",", "0.848`"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->458532863]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5299],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"DynamicSetting", "[", 
     RowBox[{"ColorSetter", "[", "]"}], "]"}]}]}], "]"}]], "Input", \
"ConversionLockdown",
 CellLabel->"In[1]:=",
 CellID->22056],

Cell[TextData[{
 "Copy and use ",
 StyleBox["Evaluate in Place", "MenuName"],
 " (",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Enter", "KeyEvent"],
 ") to display as an actual color swatch: "
}], "ExampleText",
 CellID->11728],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    TagBox[
     ColorSetterBox[RGBColor[
      0.0862745098039216, 0.254901960784314, 0.913725490196078]],
     Setting]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31172976],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18305728]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DynamicSetting",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicSetting"]], "InlineFormula"],
 " needs to be evaluated first using ",
 StyleBox["Evaluate in Place", "MenuName"],
 ":"
}], "ExampleText",
 CellID->6867],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"DynamicSetting", "[", 
     RowBox[{"ColorSetter", "[", "]"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28299],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->123727858]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotStyle", "->", 
    TagBox[
     ColorSetterBox[RGBColor[
      0.850980392156863, 0.149019607843137, 0.745098039215686]],
     Setting]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1201],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->926640697]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Interpretation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Interpretation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Setting",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Setting"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Defer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Defer"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Slider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Checkbox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Checkbox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorSetter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorSetter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorSlider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorSlider"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Manipulate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manipulate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12036]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GeneralizedInput"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->212065144],

Cell[TextData[ButtonBox["Defining Custom Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DefiningCustomNotation"]], "MoreAbout",
 CellID->469257350],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GeneralizedInput"]], "MoreAbout",
 CellID->176483310]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DynamicSetting - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 39, 36.5413598}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "DynamicSetting[e] represents an object which displays as e, but is \
interpreted as the dynamically updated current value of Setting[e] if \
supplied as Mathematica input. DynamicSetting[f, e] displays as e, but is \
interpreted as f(e) if supplied as input.", "synonyms" -> {"dynamic setting"},
     "title" -> "DynamicSetting", "type" -> "Symbol", "uri" -> 
    "ref/DynamicSetting"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7900, 230, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->41894167]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 27046, 762}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2832, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3455, 89, 1579, 37, 70, "ObjectNameGrid"],
Cell[5037, 128, 1501, 46, 70, "Usage",
 CellID->19978]
}, Open  ]],
Cell[CellGroupData[{
Cell[6575, 179, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7053, 196, 555, 19, 70, "Notes",
 CellID->10748],
Cell[7611, 217, 252, 8, 70, "Notes",
 CellID->2850]
}, Closed]],
Cell[CellGroupData[{
Cell[7900, 230, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->41894167],
Cell[CellGroupData[{
Cell[8284, 244, 146, 5, 70, "ExampleSection",
 CellID->1614597],
Cell[8433, 251, 120, 3, 70, "ExampleText",
 CellID->16061],
Cell[CellGroupData[{
Cell[8578, 258, 133, 4, 28, "Input",
 CellID->3904],
Cell[8714, 264, 193, 8, 46, "Output",
 CellID->86337787]
}, Open  ]],
Cell[8922, 275, 78, 1, 70, "ExampleText",
 CellID->17571],
Cell[CellGroupData[{
Cell[9025, 280, 195, 10, 37, "Input",
 CellID->26886],
Cell[9223, 292, 211, 7, 36, "Output",
 CellID->458532863]
}, Open  ]],
Cell[9449, 302, 120, 3, 70, "ExampleDelimiter",
 CellID->5299],
Cell[9572, 307, 361, 11, 70, "Input",
 CellID->22056],
Cell[9936, 320, 332, 11, 70, "ExampleText",
 CellID->11728],
Cell[CellGroupData[{
Cell[10293, 335, 380, 12, 35, "Input",
 CellID->31172976],
Cell[10676, 349, 3473, 61, 155, "Output",
 Evaluatable->False,
 CellID->18305728]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14198, 416, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[14432, 425, 269, 9, 70, "ExampleText",
 CellID->6867],
Cell[CellGroupData[{
Cell[14726, 438, 337, 10, 70, "Input",
 CellID->28299],
Cell[15066, 450, 3559, 62, 70, "Output",
 Evaluatable->False,
 CellID->123727858]
}, Open  ]],
Cell[CellGroupData[{
Cell[18662, 517, 370, 12, 70, "Input",
 CellID->1201],
Cell[19035, 531, 2872, 51, 70, "Output",
 Evaluatable->False,
 CellID->926640697]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21968, 589, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[22287, 600, 2180, 80, 70, "SeeAlso",
 CellID->12036]
}, Open  ]],
Cell[CellGroupData[{
Cell[24504, 685, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[24825, 696, 148, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[25010, 704, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[25331, 715, 141, 3, 70, "MoreAbout",
 CellID->212065144],
Cell[25475, 720, 158, 3, 70, "MoreAbout",
 CellID->469257350],
Cell[25636, 725, 145, 3, 70, "MoreAbout",
 CellID->176483310]
}, Open  ]],
Cell[25796, 731, 27, 0, 70, "History"],
Cell[25826, 733, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

