(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     36909,       1281]
NotebookOptionsPosition[     29697,       1027]
NotebookOutlinePosition[     30970,       1063]
CellTagsIndexPosition[     30884,       1058]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Some Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SomeMathematicalFunctions"], 
          "Mathematical Constants" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicalConstants"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Some Mathematical Functions\"\>", 
       2->"\<\"Mathematical Constants\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Exp" :> Documentation`HelpLookup["paclet:ref/Exp"], "Log" :> 
          Documentation`HelpLookup["paclet:ref/Log"], "Pi" :> 
          Documentation`HelpLookup["paclet:ref/Pi"], "N" :> 
          Documentation`HelpLookup["paclet:ref/N"], "Limit" :> 
          Documentation`HelpLookup["paclet:ref/Limit"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Exp\"\>", 2->"\<\"Log\"\>", 3->"\<\"Pi\"\>", 
       4->"\<\"N\"\>", 5->"\<\"Limit\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Constants" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalConstants"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Mathematical Constants\"\>", 
       2->"\<\"Mathematical Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "E ",
 StyleBox["(\[ExponentialE])", "OperatorCharacter"]
}], "ObjectName",
 CellID->21372],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["E",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/E"]], "InlineFormula"],
     " \[LineSeparator]is the exponential constant ",
     Cell[BoxData[
      StyleBox["e", "TI"]], "InlineFormula"],
     " (base of natural logarithms), with numerical value ",
     Cell[BoxData[
      RowBox[{"\[TildeEqual]", "2.71828"}]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27094]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Mathematical constant treated as numeric by ",
 Cell[BoxData[
  ButtonBox["NumericQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericQ"]], "InlineFormula"],
 " and as a constant by ",
 Cell[BoxData[
  ButtonBox["D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32326],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["E",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/E"]], "InlineFormula"],
 " can be evaluated to any numerical precision using ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->32301],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["E",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/E"]], "InlineFormula"],
 " can be entered in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " as ",
 Cell[BoxData["\[ExponentialE]"], "InlineFormula"],
 ", ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]ee\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " or ",
 Cell[TextData[ButtonBox["\\[ExponentialE]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ExponentialE"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->15296],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["E",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/E"]], "InlineFormula"],
 " is printed as ",
 Cell[BoxData["\[ExponentialE]"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11364]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->743913458],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->753988335],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["E",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/E"]], "InlineFormula"],
 " can be entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]ee\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " (for \"exponential e\"):"
}], "ExampleText",
 CellID->30090],

Cell[CellGroupData[{

Cell[BoxData["E"], "Input",
 CellLabel->"In[1]:=",
 CellID->25182],

Cell[BoxData["\[ExponentialE]"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->836807537]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19033],

Cell["Evaluate to any precision:", "ExampleText",
 CellID->9637],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"E", ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14457],

Cell[BoxData["2.\
7182818284590452353602874713526624977572470936999595749669676277241`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->452970900]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19633],

Cell["Do an exact numerical computation:", "ExampleText",
 CellID->31209],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Round", "[", 
  RowBox[{"E", "^", "100"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->263],

Cell[BoxData["26881171418161354484126255515800135873611119"], "Output",
 ImageSize->{342, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->188470676]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4127],

Cell[TextData[{
 "The first 20 digits of ",
 Cell[BoxData[
  FormBox["\[ExponentialE]", TraditionalForm]], "InlineMath"],
 " in base 10:"
}], "ExampleText",
 CellID->12685],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealDigits", "[", 
  RowBox[{"E", ",", "10", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3795],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "2", ",", "7", ",", "1", ",", "8", ",", "2", ",", "8", ",", "1", ",", "8",
      ",", "2", ",", "8", ",", "4", ",", "5", ",", "9", ",", "0", ",", "4", 
     ",", "5", ",", "2", ",", "3", ",", "5", ",", "3"}], "}"}], ",", "1"}], 
  "}"}]], "Output",
 ImageSize->{403, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->142542921]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19070],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[ExponentialE]", TraditionalForm]], "InlineMath"],
 " has a very regular continued fraction:"
}], "ExampleText",
 CellID->688],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{"E", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32235],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "1", ",", "2", ",", "1", ",", "1", ",", "4", ",", "1", ",", "1", 
   ",", "6", ",", "1", ",", "1", ",", "8", ",", "1", ",", "1", ",", "10", ",",
    "1", ",", "1", ",", "12", ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{385, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->205850274]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5915],

Cell[TextData[{
 "Evaluate symbolic relations involving ",
 Cell[BoxData[
  FormBox["\[ExponentialE]", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->21001],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"E", "^", "Pi"}], ">", 
  RowBox[{"Pi", "^", "E"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22415],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->92330383]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11222],

Cell[TextData[{
 "Mathematical functions and operations often give results involving ",
 Cell[BoxData[
  FormBox["\[ExponentialE]", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->22859],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "z"}], ")"}], "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "z"}], ")"}]}], ",", 
   RowBox[{"z", "->", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7347],

Cell[BoxData["\[ExponentialE]"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->63075439]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->306534573],

Cell["Solve the Steiner problem:", "ExampleText",
 CellID->46140340],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "x"}], ")"}]}], ",", 
     RowBox[{"x", ">", "0"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->319183249],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    FractionBox["1", "\[ExponentialE]"]], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "\[ExponentialE]"}], "}"}]}], "}"}]], "Output",
 ImageSize->{89, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->837583346]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3674],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Exp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exp"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " is automatically converted to ",
 Cell[BoxData[
  SuperscriptBox["\[ExponentialE]", 
   StyleBox["z", "TI"]]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->27584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", "z", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26251],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", "z"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->853702331]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->279766096],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[ExponentialE]", TraditionalForm]], "InlineMath"],
 " is not an algebraic number:"
}], "ExampleText",
 CellID->114241447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Element", "[", 
  RowBox[{"E", ",", "Algebraics"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->148908774],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->469213658]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->57113222],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["TrigToExp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigToExp"]], "InlineFormula"],
 " to obtain ",
 Cell[BoxData[
  ButtonBox["E",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/E"]], "InlineFormula"],
 " from hyperbolic and trigonometric functions: "
}], "ExampleText",
 CellID->695897114],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigToExp", "[", 
  RowBox[{"Sinh", "[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->482351060],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", 
    RowBox[{"2", " ", "\[ExponentialE]"}]]}], "+", 
  FractionBox["\[ExponentialE]", "2"]}]], "Output",
 ImageSize->{57, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->536634710]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1082571575],

Cell["Find twenty base-10 digits after the millionth one:", "ExampleText",
 CellID->1299003641],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealDigits", "[", 
  RowBox[{"E", ",", "10", ",", "20", ",", 
   RowBox[{"-", "1000000"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->310827476],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "8", ",", "8", ",", "3", ",", "7", ",", "4", ",", "7", ",", "1", ",", "1",
      ",", "5", ",", "1", ",", "5", ",", "6", ",", "2", ",", "3", ",", "9", 
     ",", "6", ",", "8", ",", "2", ",", "7", ",", "1"}], "}"}], ",", 
   RowBox[{"-", "999999"}]}], "}"}]], "Output",
 ImageSize->{448, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->523805728]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->55584612],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[ExponentialE]", TraditionalForm]], "InlineMath"],
 " arises in many limiting results:"
}], "ExampleText",
 CellID->130955963],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    FractionBox[
     SuperscriptBox["z", "z"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", "1"}], ")"}], 
      RowBox[{"z", "-", "1"}]]], "-", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", "1"}], ")"}], 
      RowBox[{"z", "-", "1"}]], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", "2"}], ")"}], 
      RowBox[{"z", "-", "2"}]]]}], ",", 
   RowBox[{"z", "->", "Infinity"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->727545383],

Cell[BoxData["\[ExponentialE]"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->872556964]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"k", "!"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->116044499],

Cell[BoxData["\[ExponentialE]"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->63144527]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "k"}], "+", "1"}], ")"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "k"}], ")"}], "!"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "0", ",", "Infinity"}], "}"}]}], "]"}], "]"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->427156330],

Cell[BoxData["\[ExponentialE]"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->23109491]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20126],

Cell[TextData[{
 "Weyl\[Hyphen]type sum involving ",
 Cell[BoxData[
  ButtonBox["E",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/E"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->285918017],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", "#", "]"}], ",", 
      RowBox[{"Im", "[", "#", "]"}]}], "}"}], "&"}], "/@", " ", "\n", "  ", 
   RowBox[{"Accumulate", "[", 
    RowBox[{"Exp", "[", 
     RowBox[{"I", " ", 
      RowBox[{"10.", "^", "3"}], "E", " ", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"Range", "[", "2000", "]"}], "]"}]}], "]"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->699190002],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylm1uobVUZx6frtte+neMxL8e8HtO8ZGr0UBFeSiy6WKlJQUQdD9o5WBmm
PdRLEdRLvdRLQuRDF+jyYCRGYBAJkRAJkRAVhEHYQxIkPQjB6vd9vzHGmnvt
efY+Rzf7rD3XnGN89/GN//eNeW4/+tDxez919KETx45e+s4Hj37m+Iljn730
HQ88yK3xGV3XPc6/Bw53XC+4yn+PLxb8/XJ8juN7/nTX5d0743P6wgv/feb3
//D32T/+s7t2cOwdefe55/790Y/88OYbH+lG8THmy4njj3G3m8XzGVdP/fpv
j37nd1/9yq++8PlfPP3bv198cmrrH7r7B1Dh9z3vevSnjz0LpV8++ddj9/zk
50/8qZvmPG7x+LZbv92NKz8exqMz8/nzz/+HKXE552MEm+uT/m2pGdqgE5QR
6Pvfe6Yb8S3nFFlG8bEBQZ7DCXEQBBZ/+fO/Xnrpf3zFNJPkAyUlVe8pzxDq
4YeeuOP93w1pxzFqjXncfeDTP/v615768Y/+8OKLL3Enn4UBuglTsUuXP7NB
u9yadBATQWTIBKR75FtPdyMId2NtxuNuEt8nSoJ2SJz6jBnL17yMjwPIgE0Z
rDGZ+s1v/IYnUOYrOsAOI6K3ujkAxaCLA7XSHPIIy4NwRtdBKwUuflrV4+15
FxvAGQmL95iKIZtkYwxk2O3yTD6fYX7m88k3aCHSNOjM0IVrHqEnUYbAcX8S
Zg3pUUbd4kbqtMYFYoSnug5zojS8UrNlzLwtPifo+aUvPgkVhFVq+Giw7mCO
IJ4QAEUw9CSpQ45pio61uR+uSVnXIGMEQ5VnWlapNmANcS3LXTzABUO5xvCj
PSKERYY+jCPSkAeq2KE7lDN4pqcz4LoxzwuF9NV6szomwCJIYCiHdfQDt6r1
QpGQEyIhdzoeVxgaRsANvRXHdHyCaBgZPt1Z6UcYQQ9SWgJpt1NS72TQpbgQ
a45rfnMEv6gqw8Lxply9WM/4NemoOYRxAoFzdvJhDOYJVVxDjCsW2UiPIimT
oIGPwmYRE+PytxtjFzjUqFzGy1vTmjxCH9i68qGAIEyJTHpNrhy87no00cLG
RBMcximPNklRBn3+lrQtWmACJmD/oP6mvAs37sIDt0ceNmrgUGQepvjmfOT6
whr9WHcRdm9M2TUnv0aJUQ6n4ew1K5mu2ukIf8OpdZ0pG6TQINnlh5kpMuV5
ZX4dfzjHowgrY5kl2lJrfC5bmZfSdes9GbvGfSnzJWm/9rw/auJ3ZCLoU8oJ
2uM597TDvTFOW6V9zqLslijX4i5yAY5hqbk6CsfL96U29nb5k1LGdrKPfoeL
9SfD9Jd3EDMtOyFsiUNTwaG9Z/f4XFDXOJZBTXRz3KnqtdaPjh3jX1PHE6ip
YUg5NYXzi6xp29xgWAQlI52/L9+LcgQZ4rRlne87LvHOjCWCGQlrM3vNpLMm
OyvADHzRqdl3ylCCD4plfY6qfU5B6v1WwoXxMTcxcVcA0cy+OvrSfbm+elGy
Lqqja9ntl88vO0W5V/NJ2nZiPoBuy9Bc1AxRssFodVZgC4zX8EyP15GV8WYP
UbB7faKtzFVu7bFTJsJZhx4ZHzVJotgPg+FYQeouPtf16IrJWg6cwAHSRA0+
viVGbJMfoEMQSRaCMiLoBUTy6pb7UdKfoye3GSsuRkDIcDPRTSCyPl6fIId4
t+2q+TnlDqorQOw1t/ZGQ5tb6aGoHZCphCQ/GauRsWEUUHea+xtKEVDhn9xv
09KxMs5YrqmenVb3llWEufo97bwFdYEdD7AmfEXO3HfD6Mw0r4TTK/1ujdQl
iMLXIiU+VyPllOie3SWmdW82Lv3aJWZqMakrcZr3ucAe00HLn5sx7XcGEXNQ
NKXHwhmw4Gp1tyrpJRk3TEYcZCRQVnPBfrrm/hPYRyiCtUKV9dBzjuJtG8Xz
uJ1IY2jOMctsEusoIczhqeUSOrGOMEtg1NevcHztyvfEkIH6IYIQGGMzsSlE
GhRh90GAwOA93jO+MxrVecYUeI9g201YHEyAFuvo7oVZJxHDhBuKh7E2as3E
31ih7o9mVVSttsz8Ve8LNxJNT00AYpDIRx9c0UuOSME8zSJHpC4jGpa0Mi9Z
OXULbNOvMmbGlRPNCqv8MrrGONDaVh8Gt+LDpp/CNP1EAdwvdVXD8GVdG1Fa
My7vXOF7XtJFJqtFMpi5nBl4IepAYw5X4eGlDzOfBjotSPrO4qkrkx7EoNKP
t+uqtUo6XJUjMUZkVqPBqfIuMYghsE1c3rUyN20e/QxmubjJH67G7lUpD/6w
+MJKm1l+EmqohN9MgSXb8YWni5b9ELbol5l/zeqQCDWbMhajdBnxkxZg/I5z
Y4+c3nWxnyQqWOOK+7aIsC9hF5wzz5TqGf0hbtU+rn4oKDmroWlrfbhkulG4
ZAuyhBgDBNEurZbc1UpETGSURDiqyB1FYMrQqzMnoKM9AleS2cAkB6FYa5s1
ZlpnLPXN7Sx/SlfKWHR2YKYwSFbhpco25GBjUcqosFVS77biM6pDLdaUQgoY
5045t7oVl1stowqpaBRhO7fVpk2wIvaBCIxHNZ5LdZ12njKotQrCK5nnClLF
CsyGD5wTvS3RWfSVsu4yJqITFX7Sdy0iunl8LDt6Lcm68Qe/A6l16jXVX24K
Ye/MRVM0Z0Wu5JsZUQ+RJmTsl6Xjk9mLMVbuYng3reHe40bNXNp0R0etxkve
m+hOhtUeQkH+GFdBMMYFNWMLzLhj/HFRMtys2h0teeTyLugXwlAiBmuemxgJ
/CK8vb0Wlcw8tKJL+njTCEXUtlrdL4gnrgMNjXKd2sMIJJdY38wxcW9EfMhk
Hpq0iGoWdudEJ+TcqpIjmIB7XHMzDKLacS+wvaagYtojNdf0MXjYDn/bylNO
Rvc7gmstD9mY5TpqkgMlE3cbbgk8NBAt6VzGCHVF6tryHMMCk05qrrWl2G3X
fajUj5s1Slyw2ipwNdQZj7kYiLOsxTLvbUGN0dx0wTCSp6w2pIWQ4Zs+Hduw
q93H9AFMcAOi9XsYadm5IN86EhLGJMyu7WnGfZweSMY4gjb2tH+7XVcpJEL3
7ZoZbFka1YEUjFgexN3UaR0nw1uFmG4PyzK0m8dKiQQ4h5D1yKJiRqW1t96v
8ZDchjmEIxJrxeHua4c9sF2LKcGW/pkhoF1swgDzooy64Auotv1sbnVoWjG4
7ARmLliHhE5CM1tu9tozeWW82723A5uSbETGzj1ONRbZF+KCkXXMripPnYhm
G7/FM+7OyICE27WTjZbmZCNDrbgo7c6WG8yziGHlhb+tHwqGsYZvaKXBELjD
cLNmS+bYx/PEArmFe1w016X0y7pSXTzbiBa1Etl/EdseyDwHIZOv+7v5ftNd
wNzUDiDc6BhXz0cS4aO06SiiI3ehOQRt1raCFkpNH+3BZc1EoQ8i6jERYtVn
uFuZ6x4lYF3QrpaOuIv43kov2Ty2544B0Scz4dSE0DY88ca6udfqk6GuRdtT
xXZoIuiBZHar5ow2RTMa6S3+KyKfuEe7t4/r7swAuzSjqvmi/hDuoRA/k4pP
Csa7eql55AmZ1Ap0YlKzO22NY1qFP/KjrUdiZR/litGxxyQWOOCWb63vLmbC
RR8F0nUQG1cMYEFW6rDE6WtMEIkwFCpC3sw3GWGoYnkQMVI7NpnhuJ1VUrVI
6CfG6HX087zMGITFVcu9cI4EhqfYg8iBGgyNAPce3eoWJkK0l+26Shk3TCbu
aSY66dh2UXMkM8fwGbFq3W1UMM1c7NJ2Ry/9Y3E181QKqmEFd26zNQ+wdcug
pstyVtvVs5SunfO1YiTi/colzgmEzC0F4RNB3JlR03XsTr9uf0C7KJ3Fdmgl
WvA7LoZMZtgNA9fCAkpiIxTRlrk7z8wGni4bHus1QoUE6L5WY9tdJdfrrCJ+
0w5iZKxPmeQuYZlY9hgU8uhl2EIzKweGugyImMTMJf4RCtnDvmGLWUrTapdC
ETHL+bR5HUOW8/OMqw1FR1ssYqLjGoHMXenZWUNJ5sCWu/voSaSYNWF28jWS
wdpOrJnf2s6l9+N2nhboZb+GJaamnaJSZNKkBSG3GJOclUTR0EPFpNg6EZrP
YjTyx6G6cxdbZK6Z2aXSXO5jygQ5xAiZ0pdx4ifgdyNhmnoKt/K9gDmOZxrm
cTk5jJuTmhksEjHYpNrSrq3lJMxi1x71M8cMZ3sEZyeJuep9XY1YFLKH4Glg
xuKaxVZTTNyxjD8Ubd5YFzmayxAHVm4K+e5C4mNYlC5HWnsDQU3ODLfjJ8Dw
sDsz21lNWx5ZW8InQiXPIhCIa/GGK5MLPs0Gb0hrNjDhIY+zWg/YDXeRLxRE
VTXpRVJkZDFmQ158RlW/Vs8bC+rONbXdjkgF9iIO6yvDDQZBc63uQELrbhQJ
YMPq/Ob6Sgmmh4x7DAKb7W+oyKzgnpRuZj9ez7sgpzWa7dUae9M2j5/QNXP+
xDC2E5tZaW6CNu6tWa1I0mKbrhG08QxAbO76Fd5rw5nWEDob5p51+W5JDOnr
1CxcLG6MculFqfk8C4cUFOytwgWqBn5EvTq19I+fM6eMG8w39iIv+eqM8IjR
s3YiY+hGZFupJJLsoVolbNi9rApP45mIQe3XjCvOYhzKCVBKXW15YJ0TWaWd
Fu5AeXblCNDypoWcuXKXMpO4V02tbD20amfp0WWxCBbPCe8YlL6YCGqshi8f
lKD19srJy3rdkSCmQq07UvZdu0Ft07XrUvbyaV03pSAZ5nltRQCWtcWyHtU4
96yKRHCKDkx1as1vx4zHVy76tcDrBumaxwzpeFehf+Y//KbANdUm8Ak6oilX
l7fMy66A1hYp/cSUZfjkfvUMcRfnq3vrOsJalEIsi2VbRQfnsjvZLfaELrgn
nf1PL3dxvqrm/IKPsosR4Lbsp/7kMXFy5C5/I8tc36N3Mk2XPsrMPRauRi7J
vmvgW9/haA13V/j0ZfDardsV1WaldsroOuh6MjX6wLUkTPQdK3FsyJkxO+vb
9XSs6zowd4Rfz6l+FkQXm/riVp21euq7tOFKjw7xPNO2dxg70C2DUhzpSRFx
/bHBUZfsov7xwXEXr1C7Z4eMF+6icmyQygUrVO4dHHX+Lmr3DY47vELt+A6Z
spKJLikkpHJikIrecdVF1N0/OMq3tzyDjxXzycFRcf4xwsv9N4Pu3yGVeNMe
XRTGRxc73ysYzlFn9mZFRPXtduor42CNw4KG7ntZVA5UWcqbUvcuTvbOzLTo
5jwxOXbxNc/uE7vGnxp/6Yi/4vL4y9Jiq8aOpU7aYn8/bFYdSvfh4R2+9Wlr
5+XTk9FoSPUko6zrGhbsPreD00aNxoJhjGEkAkNE+Hma0N6Y8zQr6lOeBxJa
PdNb8gxsn6d4s9bVs9yLk57EXiatJBDfZ77i4TjP1T+wJ/VcARvWlm1KK6Ss
xVtXwC5OHwNNRdq+vBZ337eH/Za+yNhfc5cXz1lYRUdjvZ4oetxDUBgz5BT7
Bd3tA9Zf+iZXxNwusc0tT6StWDcqdbiZilpPBFfFDvXePeJkiaRFulppkdWB
LUDPOQRpDZ7BTqyArgZ5qYWWZ8jv3oPrsiZJrmv2gxf1cNNKtvQVVk6/1xG3
nZlqU9dLxJ2a++b+yWVwbbY61e9rTSYC0C5P63OOfa8ohrn6jd32fKocYoIM
4uoBhlQ5lv7dqk/LaPnrX8uY9gpUwcBGatiknW/aBbCsKLb3XYS4zPeFl7lv
z5yzXTWCQ5xEbtXV6cJQ1dolDU35itcL4pKz3f4BzqeX9csb6e6myiFy01e2
H+01cNNa0lYtq3ApzbKzc+NChF5ePVgKdZI+ee6DpSoTgKcUB30dFp7tCN0S
RbBna1nUF1l7Wld36Xjc1OPVdpA9drJDNQ/Zy8C4oUv6adp/ZyE7+Rlupvoc
kLTtdXk2ectir/1zGGNkPY5l7SxgCdj6bgmWMO0QqG8/Tcrn1nWGXvoPQ/I1
bJT5c9Z/Y8LDx9tOI5IT10V/SxrtjbFYIfNIhHH20N4ds5UIe3S7a8f6vLhG
kQ2gbq13rhyyfniQ+/D/Oxq+253xf1MENfc=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->230564555]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13901],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Exp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Log",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Log"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pi"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Limit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Limit"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29169]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31441],

Cell[TextData[ButtonBox["Some Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SomeMathematicalFunctions"]], "Tutorials",
 CellID->6441],

Cell[TextData[ButtonBox["Mathematical Constants",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MathematicalConstants"]], "Tutorials",
 CellID->8499]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->8207],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#16094"], None}]], "RelatedLinks",
 CellID->109003325],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/e.html"], None}], "IT"]], "RelatedLinks",\

 CellID->78292393],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/Constants/E/"], None}]], "RelatedLinks",
 CellID->153718329]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->91262953],

Cell[TextData[ButtonBox["Mathematical Constants",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalConstants"]], "MoreAbout",
 CellID->134090951],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->22457018]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"E (\[ExponentialE]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 40, 19.3549558}", "context" -> "System`", 
    "keywords" -> {"exponential constant", "logarithms", "M_E"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "E is the exponential constant e (base of natural logarithms), with \
numerical value \\[TildeEqual] 2.71828. ", "synonyms" -> {}, "title" -> "E", 
    "type" -> "Symbol", "uri" -> "ref/E"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6247, 212, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->743913458]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 30741, 1051}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2389, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3012, 82, 108, 4, 70, "ObjectName",
 CellID->21372],
Cell[3123, 88, 614, 19, 70, "Usage",
 CellID->27094]
}, Open  ]],
Cell[CellGroupData[{
Cell[3774, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4252, 129, 350, 13, 70, "Notes",
 CellID->32326],
Cell[4605, 144, 315, 12, 70, "Notes",
 CellID->32301],
Cell[4923, 158, 772, 27, 70, "Notes",
 CellID->15296],
Cell[5698, 187, 512, 20, 70, "Notes",
 CellID->11364]
}, Closed]],
Cell[CellGroupData[{
Cell[6247, 212, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->743913458],
Cell[CellGroupData[{
Cell[6632, 226, 148, 5, 70, "ExampleSection",
 CellID->753988335],
Cell[6783, 233, 323, 11, 70, "ExampleText",
 CellID->30090],
Cell[CellGroupData[{
Cell[7131, 248, 66, 2, 28, "Input",
 CellID->25182],
Cell[7200, 252, 172, 5, 36, "Output",
 CellID->836807537]
}, Open  ]],
Cell[7387, 260, 121, 3, 70, "ExampleDelimiter",
 CellID->19033],
Cell[7511, 265, 64, 1, 70, "ExampleText",
 CellID->9637],
Cell[CellGroupData[{
Cell[7600, 270, 117, 4, 70, "Input",
 CellID->14457],
Cell[7720, 276, 235, 7, 36, "Output",
 CellID->452970900]
}, Open  ]],
Cell[7970, 286, 121, 3, 70, "ExampleDelimiter",
 CellID->19633],
Cell[8094, 291, 73, 1, 70, "ExampleText",
 CellID->31209],
Cell[CellGroupData[{
Cell[8192, 296, 120, 4, 70, "Input",
 CellID->263],
Cell[8315, 302, 202, 5, 36, "Output",
 CellID->188470676]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8566, 313, 222, 7, 70, "ExampleSection",
 CellID->4127],
Cell[8791, 322, 172, 6, 70, "ExampleText",
 CellID->12685],
Cell[CellGroupData[{
Cell[8988, 332, 136, 4, 70, "Input",
 CellID->3795],
Cell[9127, 338, 453, 13, 36, "Output",
 CellID->142542921]
}, Open  ]],
Cell[9595, 354, 121, 3, 70, "ExampleDelimiter",
 CellID->19070],
Cell[9719, 359, 169, 5, 70, "ExampleText",
 CellID->688],
Cell[CellGroupData[{
Cell[9913, 368, 133, 4, 70, "Input",
 CellID->32235],
Cell[10049, 374, 397, 10, 36, "Output",
 CellID->205850274]
}, Open  ]],
Cell[10461, 387, 120, 3, 70, "ExampleDelimiter",
 CellID->5915],
Cell[10584, 392, 176, 6, 70, "ExampleText",
 CellID->21001],
Cell[CellGroupData[{
Cell[10785, 402, 136, 5, 70, "Input",
 CellID->22415],
Cell[10924, 409, 160, 5, 36, "Output",
 CellID->92330383]
}, Open  ]],
Cell[11099, 417, 121, 3, 70, "ExampleDelimiter",
 CellID->11222],
Cell[11223, 422, 205, 6, 70, "ExampleText",
 CellID->22859],
Cell[CellGroupData[{
Cell[11453, 432, 270, 10, 70, "Input",
 CellID->7347],
Cell[11726, 444, 171, 5, 36, "Output",
 CellID->63075439]
}, Open  ]],
Cell[11912, 452, 125, 3, 70, "ExampleDelimiter",
 CellID->306534573],
Cell[12040, 457, 68, 1, 70, "ExampleText",
 CellID->46140340],
Cell[CellGroupData[{
Cell[12133, 462, 283, 10, 70, "Input",
 CellID->319183249],
Cell[12419, 474, 348, 11, 48, "Output",
 CellID->837583346]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12816, 491, 232, 7, 70, "ExampleSection",
 CellID->3674],
Cell[13051, 500, 347, 13, 70, "ExampleText",
 CellID->27584],
Cell[CellGroupData[{
Cell[13423, 517, 95, 3, 70, "Input",
 CellID->26251],
Cell[13521, 522, 195, 6, 36, "Output",
 CellID->853702331]
}, Open  ]],
Cell[13731, 531, 125, 3, 70, "ExampleDelimiter",
 CellID->279766096],
Cell[13859, 536, 164, 5, 70, "ExampleText",
 CellID->114241447],
Cell[CellGroupData[{
Cell[14048, 545, 135, 4, 70, "Input",
 CellID->148908774],
Cell[14186, 551, 162, 5, 36, "Output",
 CellID->469213658]
}, Open  ]],
Cell[14363, 559, 124, 3, 70, "ExampleDelimiter",
 CellID->57113222],
Cell[14490, 564, 355, 13, 70, "ExampleText",
 CellID->695897114],
Cell[CellGroupData[{
Cell[14870, 581, 136, 4, 70, "Input",
 CellID->482351060],
Cell[15009, 587, 294, 10, 52, "Output",
 CellID->536634710]
}, Open  ]],
Cell[15318, 600, 126, 3, 70, "ExampleDelimiter",
 CellID->1082571575],
Cell[15447, 605, 95, 1, 70, "ExampleText",
 CellID->1299003641],
Cell[CellGroupData[{
Cell[15567, 610, 176, 5, 70, "Input",
 CellID->310827476],
Cell[15746, 617, 474, 13, 36, "Output",
 CellID->523805728]
}, Open  ]],
Cell[16235, 633, 124, 3, 70, "ExampleDelimiter",
 CellID->55584612],
Cell[16362, 638, 169, 5, 70, "ExampleText",
 CellID->130955963],
Cell[CellGroupData[{
Cell[16556, 647, 580, 21, 70, "Input",
 CellID->727545383],
Cell[17139, 670, 172, 5, 36, "Output",
 CellID->872556964]
}, Open  ]],
Cell[CellGroupData[{
Cell[17348, 680, 232, 8, 70, "Input",
 CellID->116044499],
Cell[17583, 690, 171, 5, 36, "Output",
 CellID->63144527]
}, Open  ]],
Cell[CellGroupData[{
Cell[17791, 700, 404, 15, 70, "Input",
 CellID->427156330],
Cell[18198, 717, 171, 5, 36, "Output",
 CellID->23109491]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18418, 728, 224, 7, 70, "ExampleSection",
 CellID->20126],
Cell[18645, 737, 201, 8, 70, "ExampleText",
 CellID->285918017],
Cell[CellGroupData[{
Cell[18871, 749, 503, 16, 70, "Input",
 CellID->699190002],
Cell[19377, 767, 6349, 108, 70, "Output",
 Evaluatable->False,
 CellID->230564555]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25787, 882, 311, 9, 70, "SeeAlsoSection",
 CellID->13901],
Cell[26101, 893, 1134, 44, 70, "SeeAlso",
 CellID->29169]
}, Open  ]],
Cell[CellGroupData[{
Cell[27272, 942, 314, 9, 70, "TutorialsSection",
 CellID->31441],
Cell[27589, 953, 162, 3, 70, "Tutorials",
 CellID->6441],
Cell[27754, 958, 153, 3, 70, "Tutorials",
 CellID->8499]
}, Open  ]],
Cell[CellGroupData[{
Cell[27944, 966, 320, 9, 70, "RelatedLinksSection",
 CellID->8207],
Cell[28267, 977, 271, 6, 70, "RelatedLinks",
 CellID->109003325],
Cell[28541, 985, 189, 5, 70, "RelatedLinks",
 CellID->78292393],
Cell[28733, 992, 199, 4, 70, "RelatedLinks",
 CellID->153718329]
}, Open  ]],
Cell[CellGroupData[{
Cell[28969, 1001, 318, 9, 70, "MoreAboutSection",
 CellID->91262953],
Cell[29290, 1012, 155, 3, 70, "MoreAbout",
 CellID->134090951],
Cell[29448, 1017, 154, 3, 70, "MoreAbout",
 CellID->22457018]
}, Open  ]],
Cell[29617, 1023, 50, 0, 70, "History"],
Cell[29670, 1025, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

