(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39696,       1208]
NotebookOptionsPosition[     33880,       1013]
NotebookOutlinePosition[     35275,       1051]
CellTagsIndexPosition[     35189,       1046]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Three\[Hyphen]Dimensional Graphics Directives" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ThreeDimensionalGraphicsDirectives"], 
          "The Structure of Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheStructureOfGraphics"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Three\[Hyphen]Dimensional Graphics Directives\"\>", 
       2->"\<\"The Structure of Graphics\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FaceForm" :> Documentation`HelpLookup["paclet:ref/FaceForm"], 
          "Line" :> Documentation`HelpLookup["paclet:ref/Line"], "Mesh" :> 
          Documentation`HelpLookup["paclet:ref/Mesh"], "Thick" :> 
          Documentation`HelpLookup["paclet:ref/Thick"], "Thin" :> 
          Documentation`HelpLookup["paclet:ref/Thin"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"FaceForm\"\>", 2->"\<\"Line\"\>", 
       3->"\<\"Mesh\"\>", 4->"\<\"Thick\"\>", 
       5->"\<\"Thin\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Directives" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsDirectives"], 
          "Polygons" :> Documentation`HelpLookup["paclet:guide/Polygons"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup["paclet:guide/SymbolicGraphicsLanguage"], 
          "New in 6.0: Graphics Primitives & Directives" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Graphics Directives\"\>", 
       2->"\<\"Polygons\"\>", 3->"\<\"Symbolic Graphics Language\"\>", 
       4->"\<\"New in 6.0: Graphics Primitives & Directives\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["EdgeForm", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["EdgeForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/EdgeForm"], "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a graphics directive which specifies that edges of \
polygons and other filled graphics objects are to be drawn using the graphics \
directive or list of directives ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->988]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["EdgeForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EdgeForm"], "[", "]"}]], "InlineFormula"],
 " draws no edges. "
}], "Notes",
 CellID->23586],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EdgeForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeForm"]], "InlineFormula"],
 " works in both 2D and 3D. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->32446],

Cell[TextData[{
 "Color, opacity, thickness and dashing directives can be used in ",
 Cell[BoxData[
  ButtonBox["EdgeForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeForm"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20947],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EdgeForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeForm"]], "InlineFormula"],
 " applies to ",
 Cell[BoxData[
  ButtonBox["Polygon",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Disk",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Disk"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Rectangle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rectangle"]], "InlineFormula"],
 " objects. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->12366],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EdgeForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeForm"]], "InlineFormula"],
 " does not affect the rendering of ",
 Cell[BoxData[
  ButtonBox["Line",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Line"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->13406],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ", the default is to draw no edges. "
}], "Notes",
 CellID->5525],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 ", the default is to draw edges around every polygon. "
}], "Notes",
 CellID->1509],

Cell["\<\
No lines are ever drawn at edges formed by one polygon intersecting another. \
\
\>", "Notes",
 CellID->9354]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->261638405],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->37321424],

Cell["Specify the style of edges and faces:", "ExampleText",
 CellID->19169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"EdgeForm", "[", 
     RowBox[{"{", 
      RowBox[{"Thick", ",", "Blue"}], "}"}], "]"}], ",", 
    RowBox[{"FaceForm", "[", "Pink", "]"}], ",", 
    RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41],

Cell[BoxData[
 GraphicsBox[
  {EdgeForm[{RGBColor[0, 0, 1], Thickness[Large]}], FaceForm[RGBColor[
   1, 0.5, 0.5]], DiskBox[{0, 0}]}]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->470326177]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"EdgeForm", "[", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", "Blue"}], "}"}], "]"}], ",", 
     RowBox[{"FaceForm", "[", "Pink", "]"}], ",", 
     RowBox[{"Cuboid", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->39864857],

Cell[BoxData[
 Graphics3DBox[
  {EdgeForm[{RGBColor[0, 0, 1], Thickness[Large]}], FaceForm[RGBColor[
   1, 0.5, 0.5]], CuboidBox[{0, 0, 0}]},
  Boxed->False]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->54636884,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJytmA1TE0cYx89cAiGBEEwgvEQIIC8iFBA6xFKRDiKVQREtSkXbSR2nMFMH
i9rpy+eoH6D9nJl2X34X957uUZxhBm7Z5//b//Nkucvt7v3Gu6NXrxvvjl82
alunjTdHxy/f1u6enKpQeCkIgg/q9+/+QP39j/rL/H5oNptK+M/1B3VNBUHz
hul9r65tqrdoei/UNdvqHaprWvXCk941PSIIm7t11Wpx3hAH6ppRkYwg9I8l
nuCRVUQoPD4zxGM88h4PS+xBdEGkNBBaEw3MGmqXTEWoUFDXDbWD12WH0q31
2EYto6aFx4yhtqAqDqVbm2ETdQA1g2rHblBlFbVNZJg21Doeww6l22tGXUOt
obYLjylDrUKNQ2UFNWmom1ATDqVb67GCOoXaITwmDLUMNeNQurUZbqDOouZQ
7dh51HnUvMgwbqg5qEWH0u1Vo15HXULtFB5jhpqGWkmgRg01CXXToXRrPcZ5
WlZRu4RHzVCjeKw5lG5thhHUddQCqh1bRd1A7RYZhg01CLXpULodMWqFKrdQ
i8LjiqF68diG6hFU1VAlqB2H0q31KKLuol4WHkOG6uae33Mo3VZbqu49Ri2h
2rEF1G9QyyLDQCKl20Gv2is8+hMp3foz9KHGx+47qpuhL5HSbcWoXahPUCuo
fV61X2QoJ1L2s/jUAeFRSqTsnPrUQVQ7thP1KeqQyNCTSNn7wqdWUf1jr4gM
3YmUfRJ86rDwKCRS9lnTah71AHUEteBVayJDZyJlvy9c9dsEj/yFUzl1Dc9F
afWZqLrzwtVRkT934VQH1OEnU/YtdNHqmMjf8YmUiSpK/QTPzqSzeD4/F/Ui
YX6SKd3mLlyVVWYN1Q713bkoPYuZ/6X0M9nh+cRxSn+Tt6s2/Ovoz9C5nzti
1CNF6fdxFmrESz3Aq1NRKS/l/ne3oYsO7dZp+KAN73vQJSqQ33hx+i50BVp+
x8bpDT5dFbp6Jn0b7xp1n01/CX0VOnpTZFuUOyd16GnowRidwXOFemepd8BL
LeG14FBunW0xegF6GVq+neP0HHSdOs+mZ6j3FnQlkXbnYoIc61QkVyT+UWOM
usOoaA1k/ytpKhqF+hqq7KWGoXaoW666MjF6iE+5By3XeXG6gvc+dOlMugx9
QL1ylfqRdueiyKjnjJLrY/+oLj5Hg1FF5sbOd0hFebxfUb+fykIdQ3V7qQzU
T2SUO4Z0jE5R38/QhURae76Hkvucj5Re1/9GfcmUDv4BJfdd6djd/jsZox1e
pvWkh2TSbS6mtntUN0PYdN+iUbV+KloD/Qold7yWitaGESX31pbqwusX6pL7
dEsVBBXt9e28FMkUqZmY2sPY99QRV0uMdVU3f8pQZTzekkGeeViqV1DydMVS
FahTKHlSY6l+h0olUoNUH1HuuZCduSF89L1szqlMtEr0TSw6TPSkVX+Tvbju
vY6xo2T+UUXbW3fZGGyDqH0vjxM9VNFsEK3dJ4juw9qdzSTRh0Ttzm6a6D0c
7J71GtE7sHZnP0P0NlF7OjJLtI6DPbuZI7oEa0+45onOEV0w0QWiUzgsm+gi
0TGidRNdIlrF4ZaJLhPtg/3KRD9vciZHdNNEV2DzOGybaB02DfvARL9Q15zq
PTK9VZinpueeagaX/gVb7TJk\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31012],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Directive Specification",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->246558000],

Cell["Edges with different thickness:", "ExampleText",
 CellID->473070195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", 
       RowBox[{"Thickness", "[", "t", "]"}], "]"}], ",", "LightGray", ",", 
      RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->148358109],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt2t9qwjAUx/GTtP67kN3u0qdxV17vZoJBNvRCFOcD6mPsadxJWkUyoUOy
TOy30DZND/n8UltR6MTtFu8rt1vO3ehl6zaL5fxzNF5vtaswImYvIh/Pou2j
tsLql4OuVTNuDXQ707KnK3sn1fl6W+jhV1jkzW+K0+hHGSY4n1ezejjVfouK
ioqKioqKioqKioqKior672pZ9xaZdVsfd0KKs15X505TRr4lVStT2ai+n6H+
b2ZxfsIT16VPG9f3MtQ3zyL+pMpfKH60pjvglrrLtJ0olwlpq0mGTuk2jJz6
yfOe0b1PYm66dqkTXb9Gj/ENRSpSkaoNqe7jl3mb/guhoqKioqKioqKioqKi
oqLenzqTpjfL/QCvP3rit9TFfAPGcf07\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->636179097]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->176534330],

Cell["Edges with different dashing:", "ExampleText",
 CellID->840520326],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", 
       RowBox[{"Dashing", "[", "d", "]"}], "]"}], ",", "LightGray", ",", 
      RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->201666692],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {GrayLevel[0.85], EdgeForm[Dashing[Tiny]], RectangleBox[{0, 0}]}], ",", 
   GraphicsBox[
    {GrayLevel[0.85], EdgeForm[Dashing[Small]], RectangleBox[{0, 0}]}], ",", 
   GraphicsBox[
    {GrayLevel[0.85], EdgeForm[Dashing[Medium]], RectangleBox[{0, 0}]}], ",", 
   
   GraphicsBox[
    {GrayLevel[0.85], EdgeForm[Dashing[Large]], RectangleBox[{0, 0}]}]}], 
  "}"}]], "Output",
 ImageSize->{452, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->64910403]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->103574978],

Cell["Edges with different color:", "ExampleText",
 CellID->197782967],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", "c", "]"}], ",", "LightGray", ",", 
      RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Green", ",", "Blue", ",", "Yellow"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5759443],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {GrayLevel[0.85], EdgeForm[RGBColor[1, 0, 0]], RectangleBox[{0, 0}]}], 
   ",", 
   GraphicsBox[
    {GrayLevel[0.85], EdgeForm[RGBColor[0, 1, 0]], RectangleBox[{0, 0}]}], 
   ",", 
   GraphicsBox[
    {GrayLevel[0.85], EdgeForm[RGBColor[0, 0, 1]], RectangleBox[{0, 0}]}], 
   ",", 
   GraphicsBox[
    {GrayLevel[0.85], EdgeForm[RGBColor[1, 1, 0]], RectangleBox[{0, 0}]}]}], 
  "}"}]], "Output",
 ImageSize->{452, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->859607765]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->72050629],

Cell["Edges with several styles changed:", "ExampleText",
 CellID->150553173],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"EdgeForm", "[", 
     RowBox[{"Directive", "[", 
      RowBox[{"Thick", ",", "Dashed", ",", "Blue"}], "]"}], "]"}], ",", 
    "LightGray", ",", 
    RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->497456179],

Cell[BoxData[
 GraphicsBox[
  {GrayLevel[0.85], EdgeForm[{RGBColor[0, 0, 1], Thickness[Large], 
   Dashing[{Small, Small}]}], RectangleBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->6932690]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Primitives Affected",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->15136404],

Cell["Affected primitives:", "ExampleText",
 CellID->143670121],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"EdgeForm", "[", 
     RowBox[{"{", 
      RowBox[{"Blue", ",", "Thick"}], "}"}], "]"}], ",", "LightGray", ",", 
    RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->308952391],

Cell[BoxData[
 GraphicsBox[
  {GrayLevel[0.85], EdgeForm[{RGBColor[0, 0, 1], Thickness[Large]}], 
   RectangleBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->545208165]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"EdgeForm", "[", 
     RowBox[{"{", 
      RowBox[{"Blue", ",", "Thick"}], "}"}], "]"}], ",", "LightGray", ",", 
    RowBox[{"Polygon", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32093122],

Cell[BoxData[
 GraphicsBox[
  {GrayLevel[0.85], EdgeForm[{RGBColor[0, 0, 1], Thickness[Large]}], 
   PolygonBox[
    NCache[{{0, 0}, {Rational[1, 2], 1}, {1, 0}}, {{0, 0}, {0.5, 1}, {1, 
      0}}]]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->79257608]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"EdgeForm", "[", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", "Thick"}], "}"}], "]"}], ",", 
     RowBox[{"Cylinder", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->269660609],

Cell[BoxData[
 Graphics3DBox[
  {EdgeForm[{RGBColor[0, 0, 1], Thickness[Large]}], 
   CylinderBox[{{0, 0, -1}, {0, 0, 1}}]},
  Lighting->"Neutral"]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->229683736,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"EdgeForm", "[", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", "Thick"}], "}"}], "]"}], ",", 
     RowBox[{"Polygon", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
   ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->549609089],

Cell[BoxData[
 Graphics3DBox[
  {EdgeForm[{RGBColor[0, 0, 1], Thickness[Large]}], 
   Polygon3DBox[{{1, 0, 0}, {0, 0, 1}, {1, 1, 1}}]},
  Lighting->"Neutral"]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[4]=",
 CellID->16255494,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJylmYtvG0UQxjf2XfyM7dhxnHfcpg8oLRXvCgRICFEJhPo3RK2lVgKBSv/9
E9zMfmOfP8+Gs2wljr03329nX7Ozm99vP7xd/Hn74d3r2/nL97d/v333+p/5
L3+9L4uaeyGEN+XvHyeh/Pxv+Ul/fyqKIjQXi0Whr3Atb+HH8j0vC+f67fvy
vVF+a6htCMVCXyE+/bZ8F0BTrMqHRhOLSHsBfS6WZhExsPgaFi1j5ACEAh+u
1O4L1NWGnXqULw1he6m2n4HZRa1V2xU32j6HbQ+2mcu9UNun8KEP29x6MNqG
BvXoqaqeoIYBVPsVlfz4qseoa4T2tkjVJNWJqh6irjFU7VqqG6gmUHWkNItW
Uci6mT6Zw8cjtGxTl5HuWJ9cob5j6Lo1deeobwZdj6wajnKqylPUeIYW9msr
Z1CeQ3ngKHMqO1LlEby9gHJQaWV8edqJaseo9Qot3UY7gvYa2qGr3SftWLUH
8HkO7Yhbm1AfqrqHmm9gdbiVugP1A1iNE+oWlauPoU3qo5p1r9TV6HUf7U9R
2IfhirLq6Uo/ThOcNpUPVpy8OmIWB4V1TBqLvuxThUU1V7/bvJ4lqKzX+R+4
Ll47p1CfONSm46tP5fk9A/XUqd3zte9SeQZM4VOK2qHynkvl7xNQzxxq0/HV
p7LVIdTnTk95vnZdKlvZHnORoHY9/UY/cjQeQH3pUJuOrz6VI3Uf1CtnVD1f
2y6Vo7hlCrtRB46VUK+pvJWgtlzq0PFJqPMElcdh36VyZLexvrcVlVcox2yL
IjcJqvyVgNl2abqfbexcDxIsXVllMcei3GVXI7tmYXeRFzE/rUnNVvlWKB6S
heWvPPZpnoz1o50oFose70wR64+ovFP4sSdSeDSM8vFOlDFalKJwizKXYtH0
CZV3E774lBEon+xEGYLydGeKWD+j8l7h75CRwtm9UT7diWLnHY/i5QA+5QDW
z6nc9oF6lH6FYmcxryVNV20eS69KMedQqRalaQ3MFyn29lGvZZHm1W3rSYp5
5ne3otk+KFErQz/x+lo7w95JM+sb+Ma7g/lWj2a76T3QOA/ubEVrFau9WYo5
T0vRGkmaZVDSb5xHtLeiWdZxBt9Su6dP0wZjY7NWzkDiHcBIHOs3SZZ1TEHi
mFmfZPnfBCSOD/u1SZZLj9DrnydIHCV9kp3RxfAbUuQJn/Y2SJbx9EH6jhTZ
/5DWvbQ8WYp/SPjErQNpLW+yNSuFfO+X3c2prqRKlvWSrJu1KJZpNUD5LUHh
mLnepphZyeNXzsim9Zpplk9/3UrFloPS8uc7CHtlsSjX50b50pgiah3Jjbx2
U+vthaJ/wb2GHl1X67gu4u2cqHh1NFwVxxQ5wR84eYmv5l3mEnVX81ebA9VV
E9V2h8PRswmKnnj2q3MgEuJ65p2Pz8hdUJaRPqzuX60VqzssVh9CrRl+vqC7
5KjlUyXffpyAsbzNWwKinndbvpO5hr6V0A/hO+seYQyX+0wIFa/5lo7vvGTk
u6Je1mO3k2wpd/RZabnqTbbgur4qYhyI1lNw2Uru86W5Mbfj1nGvPSuqZ0oe
A75PkLxJhjPeFdk9MVtZPhRvKnlucG4+BzPeIF+AyVaWK+h8DN7NA8+dZWah
M0GYbDVBzffVis/yXp4vTM0K9M5zY5ekTFOs9Zyz/J+Bl7uIB5qva7/ZU5lx
GRhf6lOZl7KcNZ6FsPcftwJY1w==\
\>"]]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11763],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FaceForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FaceForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Line",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Line"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mesh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mesh"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Thick",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Thick"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Thin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Thin"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28485]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14224],

Cell[TextData[ButtonBox["Three\[Hyphen]Dimensional Graphics Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ThreeDimensionalGraphicsDirectives"]], "Tutorials",
 CellID->815154705],

Cell[TextData[ButtonBox["The Structure of Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheStructureOfGraphics"]], "Tutorials",
 CellID->659944600]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with EdgeForm",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=EdgeForm"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->443270676],

Cell[TextData[ButtonBox["Graphics Directives",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsDirectives"]], "MoreAbout",
 CellID->259689689],

Cell[TextData[ButtonBox["Polygons",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Polygons"]], "MoreAbout",
 CellID->365797811],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreAbout",
 CellID->775025553],

Cell[TextData[ButtonBox["New in 6.0: Graphics Primitives & Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]], "MoreAbout",
 CellID->52907914]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EdgeForm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 39, 37.1351250}", "context" -> "System`", 
    "keywords" -> {
     "borders of polygons", "polygon edges style", "seams between polygons"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "EdgeForm[g] is a graphics directive which specifies that edges of \
polygons and other filled graphics objects are to be drawn using the graphics \
directive or list of directives g. ", "synonyms" -> {"edge form"}, "title" -> 
    "EdgeForm", "type" -> "Symbol", "uri" -> "ref/EdgeForm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11246, 319, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->261638405]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 35045, 1039}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2824, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3447, 90, 4192, 83, 70, "ObjectNameGrid"],
Cell[7642, 175, 684, 20, 70, "Usage",
 CellID->988]
}, Open  ]],
Cell[CellGroupData[{
Cell[8363, 200, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8841, 217, 210, 8, 70, "Notes",
 CellID->23586],
Cell[9054, 227, 323, 10, 70, "Notes",
 CellID->32446],
Cell[9380, 239, 238, 8, 70, "Notes",
 CellID->20947],
Cell[9621, 249, 690, 25, 70, "Notes",
 CellID->12366],
Cell[10314, 276, 327, 12, 70, "Notes",
 CellID->13406],
Cell[10644, 290, 209, 8, 70, "Notes",
 CellID->5525],
Cell[10856, 300, 231, 8, 70, "Notes",
 CellID->1509],
Cell[11090, 310, 119, 4, 70, "Notes",
 CellID->9354]
}, Closed]],
Cell[CellGroupData[{
Cell[11246, 319, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->261638405],
Cell[CellGroupData[{
Cell[11631, 333, 147, 5, 70, "ExampleSection",
 CellID->37321424],
Cell[11781, 340, 76, 1, 70, "ExampleText",
 CellID->19169],
Cell[CellGroupData[{
Cell[11882, 345, 319, 10, 28, "Input",
 CellID->41],
Cell[12204, 357, 330, 9, 171, "Output",
 CellID->470326177]
}, Open  ]],
Cell[CellGroupData[{
Cell[12571, 371, 397, 12, 70, "Input",
 CellID->39864857],
Cell[12971, 385, 2084, 40, 184, 169, 4, "CachedBoxData", "BoxData", "Output",
 CellID->54636884]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15104, 431, 216, 7, 70, "ExampleSection",
 CellID->31012],
Cell[CellGroupData[{
Cell[15345, 442, 244, 7, 70, "ExampleSubsection",
 CellID->246558000],
Cell[15592, 451, 74, 1, 70, "ExampleText",
 CellID->473070195],
Cell[CellGroupData[{
Cell[15691, 456, 487, 15, 70, "Input",
 CellID->148358109],
Cell[16181, 473, 663, 15, 70, "Output",
 Evaluatable->False,
 CellID->636179097]
}, Open  ]],
Cell[16859, 491, 125, 3, 70, "ExampleDelimiter",
 CellID->176534330],
Cell[16987, 496, 72, 1, 70, "ExampleText",
 CellID->840520326],
Cell[CellGroupData[{
Cell[17084, 501, 485, 15, 70, "Input",
 CellID->201666692],
Cell[17572, 518, 619, 18, 123, "Output",
 CellID->64910403]
}, Open  ]],
Cell[18206, 539, 125, 3, 70, "ExampleDelimiter",
 CellID->103574978],
Cell[18334, 544, 70, 1, 70, "ExampleText",
 CellID->197782967],
Cell[CellGroupData[{
Cell[18429, 549, 442, 14, 70, "Input",
 CellID->5759443],
Cell[18874, 565, 640, 20, 123, "Output",
 CellID->859607765]
}, Open  ]],
Cell[19529, 588, 124, 3, 70, "ExampleDelimiter",
 CellID->72050629],
Cell[19656, 593, 77, 1, 70, "ExampleText",
 CellID->150553173],
Cell[CellGroupData[{
Cell[19758, 598, 332, 10, 70, "Input",
 CellID->497456179],
Cell[20093, 610, 342, 9, 121, "Output",
 CellID->6932690]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20484, 625, 239, 7, 70, "ExampleSubsection",
 CellID->15136404],
Cell[20726, 634, 63, 1, 70, "ExampleText",
 CellID->143670121],
Cell[CellGroupData[{
Cell[20814, 639, 299, 9, 70, "Input",
 CellID->308952391],
Cell[21116, 650, 319, 9, 121, "Output",
 CellID->545208165]
}, Open  ]],
Cell[CellGroupData[{
Cell[21472, 664, 568, 19, 70, "Input",
 CellID->32093122],
Cell[22043, 685, 395, 11, 121, "Output",
 CellID->79257608]
}, Open  ]],
Cell[CellGroupData[{
Cell[22475, 701, 362, 11, 70, "Input",
 CellID->269660609],
Cell[22840, 714, 4145, 74, 129, 159, 4, "CachedBoxData", "BoxData", "Output",
 CellID->229683736]
}, Open  ]],
Cell[CellGroupData[{
Cell[27022, 793, 642, 20, 70, "Input",
 CellID->549609089],
Cell[27667, 815, 2150, 41, 129, 170, 4, "CachedBoxData", "BoxData", "Output",
 CellID->16255494]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29890, 864, 311, 9, 70, "SeeAlsoSection",
 CellID->11763],
Cell[30204, 875, 1156, 44, 70, "SeeAlso",
 CellID->28485]
}, Open  ]],
Cell[CellGroupData[{
Cell[31397, 924, 314, 9, 70, "TutorialsSection",
 CellID->14224],
Cell[31714, 935, 197, 4, 70, "Tutorials",
 CellID->815154705],
Cell[31914, 941, 162, 3, 70, "Tutorials",
 CellID->659944600]
}, Open  ]],
Cell[CellGroupData[{
Cell[32113, 949, 305, 8, 70, "RelatedLinksSection"],
Cell[32421, 959, 361, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32819, 976, 319, 9, 70, "MoreAboutSection",
 CellID->443270676],
Cell[33141, 987, 149, 3, 70, "MoreAbout",
 CellID->259689689],
Cell[33293, 992, 128, 3, 70, "MoreAbout",
 CellID->365797811],
Cell[33424, 997, 162, 3, 70, "MoreAbout",
 CellID->775025553],
Cell[33589, 1002, 196, 4, 70, "MoreAbout",
 CellID->52907914]
}, Open  ]],
Cell[33800, 1009, 50, 0, 70, "History"],
Cell[33853, 1011, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

