(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    103235,       2199]
NotebookOptionsPosition[     98945,       2061]
NotebookOutlinePosition[    100396,       2101]
CellTagsIndexPosition[    100309,       2096]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"General Graph Drawing" :> 
          Documentation`HelpLookup["paclet:tutorial/GraphDrawing"], 
          "Hierarchical Drawing of Directed Graphs" :> 
          Documentation`HelpLookup["paclet:tutorial/LayeredGraphDrawing"], 
          "Tree Drawing" :> 
          Documentation`HelpLookup["paclet:tutorial/TreeDrawing"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"General Graph Drawing\"\>", 
       2->"\<\"Hierarchical Drawing of Directed Graphs\"\>", 
       3->"\<\"Tree Drawing\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DirectedEdges" :> 
          Documentation`HelpLookup["paclet:ref/DirectedEdges"], 
          "EdgeLabeling" :> 
          Documentation`HelpLookup["paclet:ref/EdgeLabeling"], 
          "MultiedgeStyle" :> 
          Documentation`HelpLookup["paclet:ref/MultiedgeStyle"], 
          "SelfLoopStyle" :> 
          Documentation`HelpLookup["paclet:ref/SelfLoopStyle"], 
          "VertexRenderingFunction" :> 
          Documentation`HelpLookup["paclet:ref/VertexRenderingFunction"], 
          "Arrow" :> Documentation`HelpLookup["paclet:ref/Arrow"], 
          "Arrowheads" :> 
          Documentation`HelpLookup["paclet:ref/Arrowheads"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DirectedEdges\"\>", 
       2->"\<\"EdgeLabeling\"\>", 3->"\<\"MultiedgeStyle\"\>", 
       4->"\<\"SelfLoopStyle\"\>", 5->"\<\"VertexRenderingFunction\"\>", 
       6->"\<\"Arrow\"\>", 7->"\<\"Arrowheads\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["EdgeRenderingFunction", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["EdgeRenderingFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/EdgeRenderingFunction"]], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["GraphPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
     " and related functions which gives a function to generate the graphics \
primitives to use in rendering each edge."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"EdgeRenderingFunction", "->", 
   StyleBox["g", "TI"]}]], "InlineFormula"],
 " specifies that each edge should be rendered with the graphics primitives \
given by ",
 Cell[BoxData[
  RowBox[{
   StyleBox["g", "TI"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["i", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["j", "TI"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["i", "TI"]], ",", 
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["j", "TI"]]}], "}"}], ",", 
    SubscriptBox[
     StyleBox["lbl", "TI"], 
     StyleBox["ij", "TI"]]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["r", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["r", "TI"], 
   StyleBox["j", "TI"]]], "InlineFormula"],
 " are the beginning and ending points of the edge, ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["j", "TI"]]], "InlineFormula"],
 " are the beginning and ending vertices, the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["lbl", "TI"], 
   StyleBox["ij", "TI"]]], "InlineFormula"],
 " is any label specified for the edge."
}], "Notes",
 CellID->636470603],

Cell[TextData[{
 "The graphics primitives obtained by applying ",
 Cell[BoxData[
  ButtonBox["EdgeRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeRenderingFunction"]], "InlineFormula"],
 " are in effect directly spliced into the graphic generated by a function \
like ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["Inset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inset"]], "InlineFormula"],
 " can be used to insert an arbitrary expression."
}], "Notes",
 CellID->184577521],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"EdgeRenderingFunction", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " renders edges according to the styles specified by ",
 Cell[BoxData[
  ButtonBox["DirectedEdges",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DirectedEdges"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["EdgeLabeling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeLabeling"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->336501309],

Cell[TextData[{
 "Settings for ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " define defaults that can be overridden by explicit directives in ",
 Cell[BoxData[
  ButtonBox["EdgeRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeRenderingFunction"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->809570488]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->812165794],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->129275924],

Cell["Draw edges as red arrows set back by a small amount:", "ExampleText",
 CellID->558263507],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"#1", ",", "0.1"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->188452606],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{{
      {RGBColor[1, 0, 0], ArrowBox[{{0., 1.}, {1., 0.}}, 0.1]}, 
      {RGBColor[1, 0, 0], ArrowBox[{{1., 2.}, {1., 1.}}, 0.1]}, 
      {RGBColor[1, 0, 0], ArrowBox[{{1., 1.}, {1., 0.}}, 0.1]}, 
      {RGBColor[1, 0, 0], ArrowBox[{{2., 2.}, {1., 1.}}, 0.1]}, 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2., 2.}, {2., 1.9530864197530864`}, {2., 
        1.9012345679012346`}, {2., 1.8444444444444446`}, {2., 
        1.782716049382716}, {2., 1.7160493827160495`}, {2., 
        1.6444444444444444`}, {2., 1.567901234567901}, {2., 
        1.4864197530864196`}, {2., 1.4}, {1.9965081146608072`, 
        1.3125574973768566`}, {1.9860324586432287`, 1.2280077672852039`}, {
        1.9685730319472645`, 1.1463508097250423`}, {1.9441298345729148`, 
        1.0675866246963714`}, {1.9127028665201793`, 0.9917152121991917}, {
        1.874292127789058, 0.9187365722335027}, {1.8288976183795513`, 
        0.8486507047993046}, {1.7765193382916589`, 0.7814576098965973}, {
        1.7171572875253809`, 0.717157287525381}, {1.6061489679212886`, 
        0.6061489679212887}, {1.5029716924536254`, 0.5029716924536255}, {
        1.4076254611223915`, 0.4076254611223915}, {1.3201102739275867`, 
        0.32011027392758673`}, {1.240426130869211, 0.24042613086921105`}, {
        1.1685730319472645`, 0.16857303194726453`}, {1.1045509771617472`, 
        0.10455097716174719`}, {1.048359966512659, 0.04835996651265902}, {1., 
        0.}}, 0.1]}}, 
     GraphicsComplexBox[{{0., 1.}, {1., 0.}, {1., 2.}, {1., 1.}, {2., 2.}, {
      2., 1.}, {2., 1.9530864197530864`}, {2., 1.9012345679012346`}, {2., 
      1.8444444444444446`}, {2., 1.782716049382716}, {2., 
      1.7160493827160495`}, {2., 1.6444444444444444`}, {2., 
      1.567901234567901}, {2., 1.4864197530864196`}, {2., 1.4}, {
      1.9965081146608072`, 1.3125574973768566`}, {1.9860324586432287`, 
      1.2280077672852039`}, {1.9685730319472645`, 1.1463508097250423`}, {
      1.9441298345729148`, 1.0675866246963714`}, {1.9127028665201793`, 
      0.9917152121991917}, {1.874292127789058, 0.9187365722335027}, {
      1.8288976183795513`, 0.8486507047993046}, {1.7765193382916589`, 
      0.7814576098965973}, {1.7171572875253809`, 0.717157287525381}, {
      1.6061489679212886`, 0.6061489679212887}, {1.5029716924536254`, 
      0.5029716924536255}, {1.4076254611223915`, 0.4076254611223915}, {
      1.3201102739275867`, 0.32011027392758673`}, {1.240426130869211, 
      0.24042613086921105`}, {1.1685730319472645`, 0.16857303194726453`}, {
      1.1045509771617472`, 0.10455097716174719`}, {1.048359966512659, 
      0.04835996651265902}}, 
      {RGBColor[0, 0, 0.7], 
       TagBox[
        TooltipBox[PointBox[1],
         "1"],
        Annotation[#, 1, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[2],
         "5"],
        Annotation[#, 5, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[3],
         "2"],
        Annotation[#, 2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[4],
         "4"],
        Annotation[#, 4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[5],
         "3"],
        Annotation[#, 3, "Tooltip"]& ]}]}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 1.}, {1., 0.}, {1., 2.}, {1., 1.}, {2., 
     2.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2127101784]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->843094468],

Cell["Draw edges as cylinders and vertices as spheres:", "ExampleText",
 CellID->999507777],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Cylinder", "[", 
       RowBox[{"#1", ",", "0.05"}], "]"}], "&"}], ")"}]}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Sphere", "[", 
       RowBox[{"#", ",", "0.1"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->131541535],

Cell[BoxData[
 Graphics3DBox[
  TagBox[{{
     CylinderBox[{{0.0336565100218259, 0.261321765643619, 0.}, {0., 
      0.24474517434175455`, 0.9989742720647393}}, 0.05], 
     CylinderBox[{{0.0336565100218259, 0.261321765643619, 0.}, {
      0.8449440803872921, 0., 0.523159358644546}}, 0.05], 
     CylinderBox[{{0.0336565100218259, 0.261321765643619, 0.}, {
      0.530937494896891, 0.9494940038888471, 0.5283357973836946}}, 0.05], 
     CylinderBox[{{0., 0.24474517434175455`, 0.9989742720647393}, {
      0.8449440803872921, 0., 0.523159358644546}}, 0.05], 
     CylinderBox[{{0., 0.24474517434175455`, 0.9989742720647393}, {
      0.530937494896891, 0.9494940038888471, 0.5283357973836946}}, 0.05], 
     CylinderBox[{{0.8449440803872921, 0., 0.523159358644546}, {
      0.530937494896891, 0.9494940038888471, 0.5283357973836946}}, 0.05]}, {
     SphereBox[{0.0336565100218259, 0.261321765643619, 0.}, 0.1], 
     SphereBox[{0., 0.24474517434175455`, 0.9989742720647393}, 0.1], 
     SphereBox[{0.8449440803872921, 0., 0.523159358644546}, 0.1], 
     SphereBox[{0.530937494896891, 0.9494940038888471, 0.5283357973836946}, 
      0.1]}},
   Annotation[#, 
    VertexCoordinateRules -> {{0.0336565100218259, 0.261321765643619, 0.}, {
     0., 0.24474517434175455`, 0.9989742720647393}, {0.8449440803872921, 0., 
     0.523159358644546}, {0.530937494896891, 0.9494940038888471, 
     0.5283357973836946}}]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 208},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->101699731,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->144330146],

Cell["Do not draw edges at all:", "ExampleText",
 CellID->283501837],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", "100", "}"}], ",", 
     RowBox[{"{", "100", "}"}]}], "]"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", "None"}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Sphere", "[", 
       RowBox[{"#", ",", "0.05"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->701174087],

Cell[BoxData[
 Graphics3DBox[
  TagBox[GraphicsGroup3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJw9VXs0FAgfnYS08k5CedSuR2uXQh6fusnulg0RotBDKqwkRPJMiFRCbUJ5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      "], 
      {RGBColor[0.5, 0., 0.]}], {
      SphereBox[{0.2000708687189865, 0.2685171414423084, 0.9555737715582234}, 
       0.05], SphereBox[{1.3984159726238998`, 0.8602235630133597, 
       0.8573369663746733}, 0.05], 
      SphereBox[{1.1247697258564757`, 0.8878321054863637, 
       1.2718468135857783`}, 0.05], 
      SphereBox[{1.0981018013267243`, 1.3311855182638728`, 
       0.5884448831370199}, 0.05], 
      SphereBox[{0.537978964058292, 1.3097660423153816`, 1.0840587307047043`},
        0.05], SphereBox[{0.08883282096566647, 0.6556535253715987, 
       1.016261096664011}, 0.05], 
      SphereBox[{1.0506776282111614`, 0.3658832416475191, 
       1.1635051499884919`}, 0.05], 
      SphereBox[{0.4977599972918585, 1.089355235635882, 0.925301529506769}, 
       0.05], SphereBox[{1.0563062237206373`, 0.6685628014336197, 
       1.0473336199064287`}, 0.05], 
      SphereBox[{1.2500049479285966`, 1.1020117305595378`, 
       0.4682969126143939}, 0.05], 
      SphereBox[{0.3356666761674215, 1.3362974915147063`, 0.6264917167744997},
        0.05], SphereBox[{0.058330539129404224`, 0.892933765725146, 
       0.449172825816868}, 0.05], 
      SphereBox[{1.394496919839086, 0.4145382986804645, 0.6856121475902244}, 
       0.05], SphereBox[{0.03185736832099073, 0.5701816181151136, 
       0.4564536544542712}, 0.05], 
      SphereBox[{0.8612143512666378, 0.9343564602903074, 1.377948972409815}, 
       0.05], SphereBox[{0.3451885985330506, 0.9704843780185919, 
       1.271709069879269}, 0.05], 
      SphereBox[{0.5659522063642684, 0.6660786264757641, 1.4247569937057105`},
        0.05], SphereBox[{0.175390126252143, 0.8087562387817873, 
       1.179494452979351}, 0.05], 
      SphereBox[{0.27598905081963643`, 1.1881658942446998`, 
       1.0584200286151078`}, 0.05], 
      SphereBox[{1.1365838179501744`, 0.5173868271821608, 0.6737614423514124},
        0.05], SphereBox[{0.8687525636661428, 0.6873699603412105, 
       1.3930037827990218`}, 0.05], 
      SphereBox[{0.10770581498811815`, 0.5026861415772454, 
       0.8819830363187169}, 0.05], 
      SphereBox[{0.8245163590615427, 0.2596824896808199, 0.5646236170757284}, 
       0.05], SphereBox[{0.6738070609694201, 1.4211024373016676`, 
       0.4903488240850793}, 0.05], 
      SphereBox[{1.2172289421886688`, 0.8460240467011333, 0.3799372345778469},
        0.05], SphereBox[{0.5004911992850707, 0.44583930314530995`, 
       1.3412552583057937`}, 0.05], 
      SphereBox[{0.17030735428756938`, 0.2977197429788484, 
       0.46778682380192615`}, 0.05], 
      SphereBox[{0.6942450747899861, 1.3933882408246867`, 0.75405255969648}, 
       0.05], SphereBox[{1.235858940823353, 0.6946869612420461, 
       0.17685223291057206`}, 0.05], 
      SphereBox[{0.3031657533268806, 0.1328087340859031, 0.624185260025427}, 
       0.05], SphereBox[{0.8631466020671896, 0.20550699353275048`, 
       1.1464882472659583`}, 0.05], 
      SphereBox[{0.4372654764360504, 0.25680858804207435`, 
       0.3872474447112824}, 0.05], 
      SphereBox[{0.25755617247378704`, 0.5961237577598031, 
       1.2149259395616856`}, 0.05], 
      SphereBox[{0.8200911802566546, 0.04230512366151673, 0.9215160069068631},
        0.05], SphereBox[{0.6942067231218315, 0.3116650295547449, 
       1.2948540253383163`}, 0.05], 
      SphereBox[{1.340009675959842, 0.7226510429775618, 1.0819068994375551`}, 
       0.05], SphereBox[{0.16971906367256806`, 0.6514403698281761, 
       0.34088312840883594`}, 0.05], 
      SphereBox[{0.38681373528641033`, 0.09014183171169388, 
       0.8629039623317984}, 0.05], 
      SphereBox[{1.1179254564160868`, 0.1736507931374074, 0.4070975408895826},
        0.05], SphereBox[{0.9525403766962939, 1.1390373602172872`, 
       1.2391351200521812`}, 0.05], 
      SphereBox[{0.12138220214444162`, 0.9979399864039539, 
       1.0065604960427117`}, 0.05], 
      SphereBox[{0.2998612879679091, 0.3542748579418746, 1.200204795070554}, 
       0.05], SphereBox[{1.1279295185033362`, 0.11756030177726595`, 
       0.7004707345413727}, 0.05], 
      SphereBox[{0.5896650443860518, 0.01339841440952294, 0.8152998138040926},
        0.05], SphereBox[{1.3436539675544936`, 1.081805978213187, 
       0.8779466725388726}, 0.05], 
      SphereBox[{1.359517580520277, 0.9767228743749865, 0.6267085910471762}, 
       0.05], SphereBox[{0.6828305449604233, 0.735428440417081, 0.}, 0.05], 
      SphereBox[{1.166260262080924, 1.0670111830017839`, 
       0.22406697322813646`}, 0.05], 
      SphereBox[{0.4332180136925279, 0.7946730686790094, 0.07825825085016147},
        0.05], SphereBox[{0.47382615779487586`, 1.0145694099261313`, 
       0.4950248920859783}, 0.05], 
      SphereBox[{0.10648591485020908`, 0.34823626194370466`, 
       0.7013139424236522}, 0.05], 
      SphereBox[{1.2874418232385794`, 0.29726982426411985`, 
       0.4596032260376324}, 0.05], 
      SphereBox[{1.1559787619354254`, 0.4000472570978603, 
       0.20271516729102673`}, 0.05], 
      SphereBox[{1.0599370794829301`, 0.15096862885455486`, 
       0.9841429178527373}, 0.05], 
      SphereBox[{1.2303103886611164`, 1.0671361720314123`, 
       1.0955137014376117`}, 0.05], 
      SphereBox[{0.04869963905131791, 0.8392744761959212, 0.8438383938981197},
        0.05], SphereBox[{0.4534630294539327, 1.3350091552372474`, 
       0.41134264440754476`}, 0.05], 
      SphereBox[{0.8071946913781469, 1.2400916112812679`, 
       1.0714992666480934`}, 0.05], 
      SphereBox[{0.20890347879989402`, 1.1403938143464014`, 
       0.4202001221156069}, 0.05], 
      SphereBox[{1.0432928194716329`, 0.8657921752572858, 
       0.12176544116449506`}, 0.05], 
      SphereBox[{0.6488937805890362, 1.1608796106635595`, 
       1.2486160779368058`}, 0.05], 
      SphereBox[{0.6096279471182606, 1.2144550351651506`, 
       0.20902984071050568`}, 0.05], 
      SphereBox[{0.856012174096193, 1.1157466878536006`, 
       0.11136064458350992`}, 0.05], 
      SphereBox[{0.8437320400756183, 0.9012561160768429, 0.00368909654787819},
        0.05], SphereBox[{0.22861564768753112`, 0.9070390619927728, 
       0.2501175513581994}, 0.05], 
      SphereBox[{0.5458316044878715, 0.508984316775582, 0.02277494094959598}, 
       0.05], SphereBox[{1.0718709081608728`, 1.251769394964987, 
       0.9937417356173714}, 0.05], 
      SphereBox[{0.25876884595216965`, 0.6556924620151909, 
       0.12117609096732707`}, 0.05], 
      SphereBox[{0.5469726102414172, 0.9979683135625235, 
       0.043611920614600175`}, 0.05], 
      SphereBox[{0.14833038461504366`, 1.2046205177075198`, 
       0.7574104778234593}, 0.05], 
      SphereBox[{0., 0.6510745315438948, 0.6904207529602356}, 0.05], 
      SphereBox[{1.0258744313628037`, 1.1976251780339549`, 
       0.37572056189019254`}, 0.05], 
      SphereBox[{0.4224593898909389, 0.35089018004505546`, 
       0.9990671174938888}, 0.05], 
      SphereBox[{0.48460898837554744`, 1.3983557774731894`, 
       0.8586908381218666}, 0.05], 
      SphereBox[{0.5889143008754086, 0.9477003146139904, 1.3722166781365868`},
        0.05], SphereBox[{0.36496987910871226`, 1.1089064327602194`, 
       0.22268566275434737`}, 0.05], 
      SphereBox[{0.8862671289193416, 0.46521761769638575`, 1.352940034897486},
        0.05], SphereBox[{0.6005716920206335, 0.7650890855095703, 
       1.1641148025477908`}, 0.05], 
      SphereBox[{0.4649503319392329, 0.3178440848387215, 
       0.13886402727898584`}, 0.05], 
      SphereBox[{0.8922133828218867, 1.4009778335865666`, 0.9028239723092688},
        0.05], SphereBox[{0.9707976922129506, 0.6248008557831358, 
       0.024706398628954518`}, 0.05], 
      SphereBox[{0.5822523221845758, 0.12288551773395762`, 
       1.1042892742224926`}, 0.05], 
      SphereBox[{0.23257620197152729`, 0.41500417335711304`, 
       0.24826711937833412`}, 0.05], 
      SphereBox[{0.8788601746032217, 1.3760506182458836`, 0.58643420256886}, 
       0.05], SphereBox[{1.2881092801058092`, 0.46107905412454825`, 
       1.0341720267282124`}, 0.05], 
      SphereBox[{1.4421527548435047`, 0.6581896236326694, 0.778126033795741}, 
       0.05], SphereBox[{0.8307327549885306, 1.2961199611906977`, 
       0.2757815983953336}, 0.05], 
      SphereBox[{0.6759931252080436, 0.18128509935860238`, 
       0.21743296929916772`}, 0.05], 
      SphereBox[{0.7962835130317965, 0.497321381729137, 0.05562470423316945}, 
       0.05], SphereBox[{0.885661874639418, 0.30535056359617774`, 
       0.1390186106751553}, 0.05], 
      SphereBox[{1.4199706598240192`, 0.7563248506484304, 0.4834525188358866},
        0.05], SphereBox[{0.8915385002342413, 0., 0.6260887127485907}, 0.05], 
      SphereBox[{1.3334222716804351`, 0.523419251680561, 0.3533195035302421}, 
       0.05], SphereBox[{0.05282316533009468, 0.9935305622286563, 
       0.6711228342527891}, 0.05], 
      SphereBox[{0.6323862250551519, 0.038359006200739176`, 
       0.6052399869885808}, 0.05], 
      SphereBox[{1.2095093170056184`, 1.2264363680128367`, 
       0.7580981535035181}, 0.05], 
      SphereBox[{0.49260308813169706`, 0.0617355864027036, 
       0.4295011874509501}, 0.05], 
      SphereBox[{1.2515921132927743`, 0.2630423866457562, 0.9045278101956578},
        0.05], SphereBox[{1.1653339294503438`, 0.5912549058310514, 
       1.256531641806846}, 0.05], 
      SphereBox[{0.8910960513555705, 0.11470173874505063`, 
       0.3382370918220582}, 0.05]}},
    ContentSelectable->True],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJw9VXs0FAgfnYS08k5CedSuR2uXQh6fusnulg0RotBDKqwkRPJMiFRCbUJ5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     "]]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->750912444,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Draw text on each edge:", "ExampleText",
 CellID->2018360208],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"5", "\[Rule]", "1"}], ",", 
     RowBox[{"3", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "4"}]}], "}"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Arrow", "[", "#", "]"}], ",", 
        RowBox[{"Inset", "[", 
         RowBox[{"\"\<Mathematica\>\"", ",", 
          RowBox[{"Mean", "[", "#1", "]"}], ",", "Automatic", ",", 
          "Automatic", ",", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "-", 
           RowBox[{"#", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ",", 
          RowBox[{"Background", "\[Rule]", "White"}]}], "]"}]}], "}"}], "&"}],
      ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->142574885],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{{{
       ArrowBox[{{0.572438280311159, 0.}, {0., 0.7716260133273214}}], 
       InsetBox[
        TagBox["Mathematica",
         "InsetString"], {0.2862191401555795, 0.3858130066636607}, Automatic, 
        Automatic, {0.572438280311159, -0.7716260133273214},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{1.0987164127194193`, 0.7303843755970227}, {0., 
        0.7716260133273214}}], InsetBox[
        TagBox["Mathematica",
         "InsetString"], {0.5493582063597097, 0.7510051944621721}, Automatic, 
        Automatic, {1.0987164127194193`, -0.04124163773029865},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{1.0987164127194193`, 0.7303843755970227}, {
        0.572438280311159, 0.}}], InsetBox[
        TagBox["Mathematica",
         "InsetString"], {0.8355773465152891, 0.36519218779851137`}, 
        Automatic, Automatic, {0.5262781324082604, 0.7303843755970227},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{1.6285080263957186`, 0.001172393789585724}, {
        2.1982300553291356`, 0.7722858413184375}}], InsetBox[
        TagBox["Mathematica",
         "InsetString"], {1.913369040862427, 0.3867291175540116}, Automatic, 
        Automatic, {-0.5697220289334171, -0.7711134475288517},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{1.6285080263957186`, 0.001172393789585724}, {
        0.572438280311159, 0.}}], InsetBox[
        TagBox["Mathematica",
         "InsetString"], {1.1004731533534389`, 0.000586196894792862}, 
        Automatic, Automatic, {1.0560697460845596`, 0.001172393789585724},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{1.6285080263957186`, 0.001172393789585724}, {
        1.0987164127194193`, 0.7303843755970227}}], InsetBox[
        TagBox["Mathematica",
         "InsetString"], {1.3636122195575688`, 0.36577838469330426`}, 
        Automatic, Automatic, {0.5297916136762992, -0.729211981807437},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{2.1982300553291356`, 0.7722858413184375}, {
        1.0987164127194193`, 0.7303843755970227}}], InsetBox[
        TagBox["Mathematica",
         "InsetString"], {1.6484732340242774`, 0.7513351084577301}, Automatic,
         Automatic, {1.0995136426097163`, 0.04190146572141473},
        Background->GrayLevel[1]]}}, 
     GraphicsComplexBox[{{0.572438280311159, 0.}, {0., 0.7716260133273214}, {
      1.0987164127194193`, 0.7303843755970227}, {1.6285080263957186`, 
      0.001172393789585724}, {2.1982300553291356`, 0.7722858413184375}}, 
      {RGBColor[0, 0, 0.7], 
       TagBox[
        TooltipBox[PointBox[1],
         "4"],
        Annotation[#, 4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[2],
         "1"],
        Annotation[#, 1, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[3],
         "5"],
        Annotation[#, 5, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[4],
         "3"],
        Annotation[#, 3, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[5],
         "2"],
        Annotation[#, 2, "Tooltip"]& ]}]},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{0.572438280311159, 0.}, {0., 
     0.7716260133273214}, {1.0987164127194193`, 0.7303843755970227}, {
     1.6285080263957186`, 0.001172393789585724}, {2.1982300553291356`, 
     0.7722858413184375}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{342., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{346, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1947308233]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->552137592],

Cell["Draw graphics on each edge:", "ExampleText",
 CellID->374325799],

Cell[BoxData[
 RowBox[{
  RowBox[{"arrow", "=", 
   GraphicsBox[RasterBox[CompressedData["
1:eJztlf9TmmAYwAujlhppV1vbslmUUIvSGpa6NStGX3DlygpBQp11MteUheYq
zv70vXyzldxiP+yX3T533D13fN6H53nhfZgoVveLUFdX14J5pf9RUBT9ExmC
IMcrgI2wLEJCznyUZOOqGscRRz4KsaIEwxIdZ6H7BaF2aPZKuFjaplWcvPP1
hshaDdGpaegRLtLblXB4OlSSVLzW9qEaglNUPB4XAXEDLRyWvKGd8Gbl+FT3
rQZYShymJQAMkAy00FsKJZu5xubOcbK0TlNWw2K/BO7c0Y6TG4HmHtGING9n
S962379QSn4GbDwgEDg6uuzx+y8iU7fvQ15aZHX/LHD8enf3WycrlUpYkK+I
nsjU9ydJ0IC+oWdPt7a23toQ3rx5TsjR8fmeyJeJ6dPSuoqD/GfXl725m1cd
NBrzflln/iKn+WUY5E/PXJ9MznH+cRuiUTkDkAks1zsxPVKGRcTU5ejVfaKA
cTlDAPx+QpgD/myZptIzL06WnmGE+eB7gMwuAMif4fZ6m8sjsGjoSoqww2UC
1mn5l9+plu56BOHNpI9ftrIPDv7OTXFYorrk4+tm7Qo3mLLDkFOCclDNM1l3
H2voCYGzw8whKAXNPuxjSfCaYkueAkj/EAGg+RywPXlm8bzMkmi6/0c22Kpy
o/sPGBgYzWAYeASWKHiCvsU17ZvUdSaYb3k6qBYSioIJQmIM2O5u1TghVDmb
jfk6YRgmqBWpjLWCMXeRNc8rQq2t2vKhXv9YTXzV7PoQYk0D7WBbQBYgRii6
zLcOXK1gdvVT27afGtrgQFSYz4O6s4dq7fHJhJIUvci0GP5ccmCDKYarfCzG
d+NObKAjOM/zL38ZSY/5q+4hhHQ4sbVpSEKQ4z+CsUMO5f/8XX4C3itGoQ==

     "], {{0, 0}, {47, 47}},
     ColorFunction->(Apply[RGBColor, 
       Part[CompressedData["
1:eJx1l/dqVFEQxoP4APZe8BVUVCzMM9gbKgj+rWIXRR/B3tsj2EtiA0EQSUg2
u5st2WzfZJNs7CXRRJ0595uDc8gPwmF3cu+ZM+ebsot27123Z0JTU9Ppf38T
//1dOM+8ocuXmLd08QITpybhI42NMo1ghb0zxpToymWmV7/Heuc2k6cDQple
vmD885uFXn1++CfTp/bZQpryPQI9e8p4+0GhQok4U6Enj5ma2mcKXbRNyNBi
oaT2q1eYvmifOv0aYfrVHusQaIMQ13PA3pUUaKGQp+ctzIDa4Q/Oaf3vyTGN
IG5Yc93MoK6jv5lB418xur9a8Hy8U6Dr15gMpboYf0+Im/UL606hR8+H+4b9
7BmmPfo+RvuEgtqvXWXqwQr7OqGkcUWcYF8ilHW1z0Mfzo8CzRN8fEaGmTrd
vsUMBeebIpQ0Dq9fMR/UjnN/+sgUAp3PFd7TAqGNtggptW8V0jRZKAb54/Kt
QoeFGrU0M15/jx8xVWp+xtQD/8+dZYrqvz2n+z5ON28w3UH8NgqJKA9Skc4r
Qf649/ZoPGH/M8YMBSvsTpdJ1R/O87//HVp3rH6mC1VaJtQonWK8TvH/jx4y
lSA+3VlmQFerD/jj8rhGv38xPn8nCQVaKxSjeFWD8+GeHz5gfH1w+3XT/XtM
Mdjf1d9ykJdYpwrl6B5C+3Khl54+YXpppeD1g/xFftj73y5k1Z5JM3Wzf6fW
uUsXGX/+GUKSbt1kcsHz0B3y3OWJ18cOoUEnhUb0Hp8f378xVTou9AfnP3+O
ianOUQ9hR92HH85fXydR11FHbJydbvs1L12+Dxj/c7ReKAf+YV/o1NZZ6GO+
kKPPnxjvv8u7tqhOxaijnfH5sUvIa305JPj7QV4kE0xV+xzsTg/vzJoO9AV9
HhP886hfm4RaUB8Qt2yG6acb1xmbX+2RPmK0X/DnR39G3lt9FfKC1vFVgn//
HCGj+sR5YEffxL1jP9hnCSnNE8QRdujOnS8TPA/d//jOhP3ZvS+h+jsieP/Q
T7A/4g07dIPzrxYGg33GW6E3+Ik+AvuL58z474N+XR6WonnP9083f5TpqBDO
F87/1kjX7XqfVl+4N+vPNCGuddjqB/UcdfeE4J93edsZ6bsrqA/or/be7f6o
j7a/IT7oH1af9+4yhSBvsbq8Smpe2jkP9d7VOZ9nsLt6nVD9o57Bjr6M/vTq
JTMU6BNzAPoJ7EsFX19sfuJ7+G37N/SBPm/rI/oy5i47X9vfJXb+QL/Cva4Q
/PtR11ye9QX9EefGPdr4u36Q1bjYPMd9nBI+BPeLuuvupzWaU7LBfIv9bX6i
PqC/2PxYIzR0RZ+FHe9z80s4X2IuQ345vfv9se/XL0w5ioOPP+ZGOxdhxe8H
zBn29xk+Iz9cv/NxdHry9XG833/IH5tnqBfYx94vPtu5HCv6L/IbcxjsyG/M
cfgdBzvyBX3T7mPjb8+H76E/O5/Y+mjj+xfoHbtL
        "], #]]& ),
     ColorFunctionScaling->False],
    Background->None,
    ImageSize->{47, 47},
    PlotRange->{{0, 47}, {0, 47}}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1102851310],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "\[Rule]", "1"}], ",", 
     RowBox[{"3", "\[Rule]", "1"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"5", "\[Rule]", "1"}], ",", 
     RowBox[{"6", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Line", "[", "#", "]"}], ",", 
        RowBox[{"Inset", "[", 
         RowBox[{"arrow", ",", 
          RowBox[{"Mean", "[", "#1", "]"}], ",", "Automatic", ",", 
          "Automatic", ",", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "-", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ",", 
          RowBox[{"Background", "\[Rule]", "White"}]}], "]"}]}], "}"}], "&"}],
      ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->165798872],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{{{
       LineBox[{{0.36327126408405364`, 1.8090169944118928`}, {
        0.9510565163256759, 1.}}], InsetBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztlf9TmmAYwAujlhppV1vbslmUUIvSGpa6NStGX3DlygpBQp11MteUheYq
zv70vXyzldxiP+yX3T533D13fN6H53nhfZgoVveLUFdX14J5pf9RUBT9ExmC
IMcrgI2wLEJCznyUZOOqGscRRz4KsaIEwxIdZ6H7BaF2aPZKuFjaplWcvPP1
hshaDdGpaegRLtLblXB4OlSSVLzW9qEaglNUPB4XAXEDLRyWvKGd8Gbl+FT3
rQZYShymJQAMkAy00FsKJZu5xubOcbK0TlNWw2K/BO7c0Y6TG4HmHtGING9n
S962379QSn4GbDwgEDg6uuzx+y8iU7fvQ15aZHX/LHD8enf3WycrlUpYkK+I
nsjU9ydJ0IC+oWdPt7a23toQ3rx5TsjR8fmeyJeJ6dPSuoqD/GfXl725m1cd
NBrzflln/iKn+WUY5E/PXJ9MznH+cRuiUTkDkAks1zsxPVKGRcTU5ejVfaKA
cTlDAPx+QpgD/myZptIzL06WnmGE+eB7gMwuAMif4fZ6m8sjsGjoSoqww2UC
1mn5l9+plu56BOHNpI9ftrIPDv7OTXFYorrk4+tm7Qo3mLLDkFOCclDNM1l3
H2voCYGzw8whKAXNPuxjSfCaYkueAkj/EAGg+RywPXlm8bzMkmi6/0c22Kpy
o/sPGBgYzWAYeASWKHiCvsU17ZvUdSaYb3k6qBYSioIJQmIM2O5u1TghVDmb
jfk6YRgmqBWpjLWCMXeRNc8rQq2t2vKhXv9YTXzV7PoQYk0D7WBbQBYgRii6
zLcOXK1gdvVT27afGtrgQFSYz4O6s4dq7fHJhJIUvci0GP5ccmCDKYarfCzG
d+NObKAjOM/zL38ZSY/5q+4hhHQ4sbVpSEKQ4z+CsUMO5f/8XX4C3itGoQ==

          "], {{0, 0}, {47, 47}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx1l/dqVFEQxoP4APZe8BVUVCzMM9gbKgj+rWIXRR/B3tsj2EtiA0EQSUg2
u5st2WzfZJNs7CXRRJ0595uDc8gPwmF3cu+ZM+ebsot27123Z0JTU9Ppf38T
//1dOM+8ocuXmLd08QITpybhI42NMo1ghb0zxpToymWmV7/Heuc2k6cDQple
vmD885uFXn1++CfTp/bZQpryPQI9e8p4+0GhQok4U6Enj5ma2mcKXbRNyNBi
oaT2q1eYvmifOv0aYfrVHusQaIMQ13PA3pUUaKGQp+ctzIDa4Q/Oaf3vyTGN
IG5Yc93MoK6jv5lB418xur9a8Hy8U6Dr15gMpboYf0+Im/UL606hR8+H+4b9
7BmmPfo+RvuEgtqvXWXqwQr7OqGkcUWcYF8ilHW1z0Mfzo8CzRN8fEaGmTrd
vsUMBeebIpQ0Dq9fMR/UjnN/+sgUAp3PFd7TAqGNtggptW8V0jRZKAb54/Kt
QoeFGrU0M15/jx8xVWp+xtQD/8+dZYrqvz2n+z5ON28w3UH8NgqJKA9Skc4r
Qf649/ZoPGH/M8YMBSvsTpdJ1R/O87//HVp3rH6mC1VaJtQonWK8TvH/jx4y
lSA+3VlmQFerD/jj8rhGv38xPn8nCQVaKxSjeFWD8+GeHz5gfH1w+3XT/XtM
Mdjf1d9ykJdYpwrl6B5C+3Khl54+YXpppeD1g/xFftj73y5k1Z5JM3Wzf6fW
uUsXGX/+GUKSbt1kcsHz0B3y3OWJ18cOoUEnhUb0Hp8f378xVTou9AfnP3+O
ianOUQ9hR92HH85fXydR11FHbJydbvs1L12+Dxj/c7ReKAf+YV/o1NZZ6GO+
kKPPnxjvv8u7tqhOxaijnfH5sUvIa305JPj7QV4kE0xV+xzsTg/vzJoO9AV9
HhP886hfm4RaUB8Qt2yG6acb1xmbX+2RPmK0X/DnR39G3lt9FfKC1vFVgn//
HCGj+sR5YEffxL1jP9hnCSnNE8QRdujOnS8TPA/d//jOhP3ZvS+h+jsieP/Q
T7A/4g07dIPzrxYGg33GW6E3+Ik+AvuL58z474N+XR6WonnP9083f5TpqBDO
F87/1kjX7XqfVl+4N+vPNCGuddjqB/UcdfeE4J93edsZ6bsrqA/or/be7f6o
j7a/IT7oH1af9+4yhSBvsbq8Smpe2jkP9d7VOZ9nsLt6nVD9o57Bjr6M/vTq
JTMU6BNzAPoJ7EsFX19sfuJ7+G37N/SBPm/rI/oy5i47X9vfJXb+QL/Cva4Q
/PtR11ye9QX9EefGPdr4u36Q1bjYPMd9nBI+BPeLuuvupzWaU7LBfIv9bX6i
PqC/2PxYIzR0RZ+FHe9z80s4X2IuQ345vfv9se/XL0w5ioOPP+ZGOxdhxe8H
zBn29xk+Iz9cv/NxdHry9XG833/IH5tnqBfYx94vPtu5HCv6L/IbcxjsyG/M
cfgdBzvyBX3T7mPjb8+H76E/O5/Y+mjj+xfoHbtL
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{47, 47},
         PlotRange->{{0, 47}, {0, 47}}], {0.6571638902048648, 1.4045084972059465`},
         Automatic, Automatic, {0.5877852522416223, -0.8090169944118928},
        Background->GrayLevel[1]]}, {
       LineBox[{{0., 0.6909830057189905}, {0.9510565163256759, 1.}}], 
       InsetBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztlf9TmmAYwAujlhppV1vbslmUUIvSGpa6NStGX3DlygpBQp11MteUheYq
zv70vXyzldxiP+yX3T533D13fN6H53nhfZgoVveLUFdX14J5pf9RUBT9ExmC
IMcrgI2wLEJCznyUZOOqGscRRz4KsaIEwxIdZ6H7BaF2aPZKuFjaplWcvPP1
hshaDdGpaegRLtLblXB4OlSSVLzW9qEaglNUPB4XAXEDLRyWvKGd8Gbl+FT3
rQZYShymJQAMkAy00FsKJZu5xubOcbK0TlNWw2K/BO7c0Y6TG4HmHtGING9n
S962379QSn4GbDwgEDg6uuzx+y8iU7fvQ15aZHX/LHD8enf3WycrlUpYkK+I
nsjU9ydJ0IC+oWdPt7a23toQ3rx5TsjR8fmeyJeJ6dPSuoqD/GfXl725m1cd
NBrzflln/iKn+WUY5E/PXJ9MznH+cRuiUTkDkAks1zsxPVKGRcTU5ejVfaKA
cTlDAPx+QpgD/myZptIzL06WnmGE+eB7gMwuAMif4fZ6m8sjsGjoSoqww2UC
1mn5l9+plu56BOHNpI9ftrIPDv7OTXFYorrk4+tm7Qo3mLLDkFOCclDNM1l3
H2voCYGzw8whKAXNPuxjSfCaYkueAkj/EAGg+RywPXlm8bzMkmi6/0c22Kpy
o/sPGBgYzWAYeASWKHiCvsU17ZvUdSaYb3k6qBYSioIJQmIM2O5u1TghVDmb
jfk6YRgmqBWpjLWCMXeRNc8rQq2t2vKhXv9YTXzV7PoQYk0D7WBbQBYgRii6
zLcOXK1gdvVT27afGtrgQFSYz4O6s4dq7fHJhJIUvci0GP5ccmCDKYarfCzG
d+NObKAjOM/zL38ZSY/5q+4hhHQ4sbVpSEKQ4z+CsUMO5f/8XX4C3itGoQ==

          "], {{0, 0}, {47, 47}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx1l/dqVFEQxoP4APZe8BVUVCzMM9gbKgj+rWIXRR/B3tsj2EtiA0EQSUg2
u5st2WzfZJNs7CXRRJ0595uDc8gPwmF3cu+ZM+ebsot27123Z0JTU9Ppf38T
//1dOM+8ocuXmLd08QITpybhI42NMo1ghb0zxpToymWmV7/Heuc2k6cDQple
vmD885uFXn1++CfTp/bZQpryPQI9e8p4+0GhQok4U6Enj5ma2mcKXbRNyNBi
oaT2q1eYvmifOv0aYfrVHusQaIMQ13PA3pUUaKGQp+ctzIDa4Q/Oaf3vyTGN
IG5Yc93MoK6jv5lB418xur9a8Hy8U6Dr15gMpboYf0+Im/UL606hR8+H+4b9
7BmmPfo+RvuEgtqvXWXqwQr7OqGkcUWcYF8ilHW1z0Mfzo8CzRN8fEaGmTrd
vsUMBeebIpQ0Dq9fMR/UjnN/+sgUAp3PFd7TAqGNtggptW8V0jRZKAb54/Kt
QoeFGrU0M15/jx8xVWp+xtQD/8+dZYrqvz2n+z5ON28w3UH8NgqJKA9Skc4r
Qf649/ZoPGH/M8YMBSvsTpdJ1R/O87//HVp3rH6mC1VaJtQonWK8TvH/jx4y
lSA+3VlmQFerD/jj8rhGv38xPn8nCQVaKxSjeFWD8+GeHz5gfH1w+3XT/XtM
Mdjf1d9ykJdYpwrl6B5C+3Khl54+YXpppeD1g/xFftj73y5k1Z5JM3Wzf6fW
uUsXGX/+GUKSbt1kcsHz0B3y3OWJ18cOoUEnhUb0Hp8f378xVTou9AfnP3+O
ianOUQ9hR92HH85fXydR11FHbJydbvs1L12+Dxj/c7ReKAf+YV/o1NZZ6GO+
kKPPnxjvv8u7tqhOxaijnfH5sUvIa305JPj7QV4kE0xV+xzsTg/vzJoO9AV9
HhP886hfm4RaUB8Qt2yG6acb1xmbX+2RPmK0X/DnR39G3lt9FfKC1vFVgn//
HCGj+sR5YEffxL1jP9hnCSnNE8QRdujOnS8TPA/d//jOhP3ZvS+h+jsieP/Q
T7A/4g07dIPzrxYGg33GW6E3+Ik+AvuL58z474N+XR6WonnP9083f5TpqBDO
F87/1kjX7XqfVl+4N+vPNCGuddjqB/UcdfeE4J93edsZ6bsrqA/or/be7f6o
j7a/IT7oH1af9+4yhSBvsbq8Smpe2jkP9d7VOZ9nsLt6nVD9o57Bjr6M/vTq
JTMU6BNzAPoJ7EsFX19sfuJ7+G37N/SBPm/rI/oy5i47X9vfJXb+QL/Cva4Q
/PtR11ye9QX9EefGPdr4u36Q1bjYPMd9nBI+BPeLuuvupzWaU7LBfIv9bX6i
PqC/2PxYIzR0RZ+FHe9z80s4X2IuQ345vfv9se/XL0w5ioOPP+ZGOxdhxe8H
zBn29xk+Iz9cv/NxdHry9XG833/IH5tnqBfYx94vPtu5HCv6L/IbcxjsyG/M
cfgdBzvyBX3T7mPjb8+H76E/O5/Y+mjj+xfoHbtL
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{47, 47},
         PlotRange->{{0, 47}, {0, 47}}], {0.47552825816283795`, 0.8454915028594953},
         Automatic, Automatic, {0.9510565163256759, 0.3090169942810095},
        Background->GrayLevel[1]]}, {
       LineBox[{{0.951056516190987, 0.}, {0.9510565163256759, 1.}}], 
       InsetBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztlf9TmmAYwAujlhppV1vbslmUUIvSGpa6NStGX3DlygpBQp11MteUheYq
zv70vXyzldxiP+yX3T533D13fN6H53nhfZgoVveLUFdX14J5pf9RUBT9ExmC
IMcrgI2wLEJCznyUZOOqGscRRz4KsaIEwxIdZ6H7BaF2aPZKuFjaplWcvPP1
hshaDdGpaegRLtLblXB4OlSSVLzW9qEaglNUPB4XAXEDLRyWvKGd8Gbl+FT3
rQZYShymJQAMkAy00FsKJZu5xubOcbK0TlNWw2K/BO7c0Y6TG4HmHtGING9n
S962379QSn4GbDwgEDg6uuzx+y8iU7fvQ15aZHX/LHD8enf3WycrlUpYkK+I
nsjU9ydJ0IC+oWdPt7a23toQ3rx5TsjR8fmeyJeJ6dPSuoqD/GfXl725m1cd
NBrzflln/iKn+WUY5E/PXJ9MznH+cRuiUTkDkAks1zsxPVKGRcTU5ejVfaKA
cTlDAPx+QpgD/myZptIzL06WnmGE+eB7gMwuAMif4fZ6m8sjsGjoSoqww2UC
1mn5l9+plu56BOHNpI9ftrIPDv7OTXFYorrk4+tm7Qo3mLLDkFOCclDNM1l3
H2voCYGzw8whKAXNPuxjSfCaYkueAkj/EAGg+RywPXlm8bzMkmi6/0c22Kpy
o/sPGBgYzWAYeASWKHiCvsU17ZvUdSaYb3k6qBYSioIJQmIM2O5u1TghVDmb
jfk6YRgmqBWpjLWCMXeRNc8rQq2t2vKhXv9YTXzV7PoQYk0D7WBbQBYgRii6
zLcOXK1gdvVT27afGtrgQFSYz4O6s4dq7fHJhJIUvci0GP5ccmCDKYarfCzG
d+NObKAjOM/zL38ZSY/5q+4hhHQ4sbVpSEKQ4z+CsUMO5f/8XX4C3itGoQ==

          "], {{0, 0}, {47, 47}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx1l/dqVFEQxoP4APZe8BVUVCzMM9gbKgj+rWIXRR/B3tsj2EtiA0EQSUg2
u5st2WzfZJNs7CXRRJ0595uDc8gPwmF3cu+ZM+ebsot27123Z0JTU9Ppf38T
//1dOM+8ocuXmLd08QITpybhI42NMo1ghb0zxpToymWmV7/Heuc2k6cDQple
vmD885uFXn1++CfTp/bZQpryPQI9e8p4+0GhQok4U6Enj5ma2mcKXbRNyNBi
oaT2q1eYvmifOv0aYfrVHusQaIMQ13PA3pUUaKGQp+ctzIDa4Q/Oaf3vyTGN
IG5Yc93MoK6jv5lB418xur9a8Hy8U6Dr15gMpboYf0+Im/UL606hR8+H+4b9
7BmmPfo+RvuEgtqvXWXqwQr7OqGkcUWcYF8ilHW1z0Mfzo8CzRN8fEaGmTrd
vsUMBeebIpQ0Dq9fMR/UjnN/+sgUAp3PFd7TAqGNtggptW8V0jRZKAb54/Kt
QoeFGrU0M15/jx8xVWp+xtQD/8+dZYrqvz2n+z5ON28w3UH8NgqJKA9Skc4r
Qf649/ZoPGH/M8YMBSvsTpdJ1R/O87//HVp3rH6mC1VaJtQonWK8TvH/jx4y
lSA+3VlmQFerD/jj8rhGv38xPn8nCQVaKxSjeFWD8+GeHz5gfH1w+3XT/XtM
Mdjf1d9ykJdYpwrl6B5C+3Khl54+YXpppeD1g/xFftj73y5k1Z5JM3Wzf6fW
uUsXGX/+GUKSbt1kcsHz0B3y3OWJ18cOoUEnhUb0Hp8f378xVTou9AfnP3+O
ianOUQ9hR92HH85fXydR11FHbJydbvs1L12+Dxj/c7ReKAf+YV/o1NZZ6GO+
kKPPnxjvv8u7tqhOxaijnfH5sUvIa305JPj7QV4kE0xV+xzsTg/vzJoO9AV9
HhP886hfm4RaUB8Qt2yG6acb1xmbX+2RPmK0X/DnR39G3lt9FfKC1vFVgn//
HCGj+sR5YEffxL1jP9hnCSnNE8QRdujOnS8TPA/d//jOhP3ZvS+h+jsieP/Q
T7A/4g07dIPzrxYGg33GW6E3+Ik+AvuL58z474N+XR6WonnP9083f5TpqBDO
F87/1kjX7XqfVl+4N+vPNCGuddjqB/UcdfeE4J93edsZ6bsrqA/or/be7f6o
j7a/IT7oH1af9+4yhSBvsbq8Smpe2jkP9d7VOZ9nsLt6nVD9o57Bjr6M/vTq
JTMU6BNzAPoJ7EsFX19sfuJ7+G37N/SBPm/rI/oy5i47X9vfJXb+QL/Cva4Q
/PtR11ye9QX9EefGPdr4u36Q1bjYPMd9nBI+BPeLuuvupzWaU7LBfIv9bX6i
PqC/2PxYIzR0RZ+FHe9z80s4X2IuQ345vfv9se/XL0w5ioOPP+ZGOxdhxe8H
zBn29xk+Iz9cv/NxdHry9XG833/IH5tnqBfYx94vPtu5HCv6L/IbcxjsyG/M
cfgdBzvyBX3T7mPjb8+H76E/O5/Y+mjj+xfoHbtL
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{47, 47},
         PlotRange->{{0, 47}, {0, 47}}], {0.9510565162583314, 0.5}, Automatic,
         Automatic, {1.3468892667845012`*^-10, 1.},
        Background->GrayLevel[1]]}, {
       LineBox[{{1.902113032568109, 0.6909830054627958}, {0.9510565163256759, 
        1.}}], InsetBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztlf9TmmAYwAujlhppV1vbslmUUIvSGpa6NStGX3DlygpBQp11MteUheYq
zv70vXyzldxiP+yX3T533D13fN6H53nhfZgoVveLUFdX14J5pf9RUBT9ExmC
IMcrgI2wLEJCznyUZOOqGscRRz4KsaIEwxIdZ6H7BaF2aPZKuFjaplWcvPP1
hshaDdGpaegRLtLblXB4OlSSVLzW9qEaglNUPB4XAXEDLRyWvKGd8Gbl+FT3
rQZYShymJQAMkAy00FsKJZu5xubOcbK0TlNWw2K/BO7c0Y6TG4HmHtGING9n
S962379QSn4GbDwgEDg6uuzx+y8iU7fvQ15aZHX/LHD8enf3WycrlUpYkK+I
nsjU9ydJ0IC+oWdPt7a23toQ3rx5TsjR8fmeyJeJ6dPSuoqD/GfXl725m1cd
NBrzflln/iKn+WUY5E/PXJ9MznH+cRuiUTkDkAks1zsxPVKGRcTU5ejVfaKA
cTlDAPx+QpgD/myZptIzL06WnmGE+eB7gMwuAMif4fZ6m8sjsGjoSoqww2UC
1mn5l9+plu56BOHNpI9ftrIPDv7OTXFYorrk4+tm7Qo3mLLDkFOCclDNM1l3
H2voCYGzw8whKAXNPuxjSfCaYkueAkj/EAGg+RywPXlm8bzMkmi6/0c22Kpy
o/sPGBgYzWAYeASWKHiCvsU17ZvUdSaYb3k6qBYSioIJQmIM2O5u1TghVDmb
jfk6YRgmqBWpjLWCMXeRNc8rQq2t2vKhXv9YTXzV7PoQYk0D7WBbQBYgRii6
zLcOXK1gdvVT27afGtrgQFSYz4O6s4dq7fHJhJIUvci0GP5ccmCDKYarfCzG
d+NObKAjOM/zL38ZSY/5q+4hhHQ4sbVpSEKQ4z+CsUMO5f/8XX4C3itGoQ==

          "], {{0, 0}, {47, 47}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx1l/dqVFEQxoP4APZe8BVUVCzMM9gbKgj+rWIXRR/B3tsj2EtiA0EQSUg2
u5st2WzfZJNs7CXRRJ0595uDc8gPwmF3cu+ZM+ebsot27123Z0JTU9Ppf38T
//1dOM+8ocuXmLd08QITpybhI42NMo1ghb0zxpToymWmV7/Heuc2k6cDQple
vmD885uFXn1++CfTp/bZQpryPQI9e8p4+0GhQok4U6Enj5ma2mcKXbRNyNBi
oaT2q1eYvmifOv0aYfrVHusQaIMQ13PA3pUUaKGQp+ctzIDa4Q/Oaf3vyTGN
IG5Yc93MoK6jv5lB418xur9a8Hy8U6Dr15gMpboYf0+Im/UL606hR8+H+4b9
7BmmPfo+RvuEgtqvXWXqwQr7OqGkcUWcYF8ilHW1z0Mfzo8CzRN8fEaGmTrd
vsUMBeebIpQ0Dq9fMR/UjnN/+sgUAp3PFd7TAqGNtggptW8V0jRZKAb54/Kt
QoeFGrU0M15/jx8xVWp+xtQD/8+dZYrqvz2n+z5ON28w3UH8NgqJKA9Skc4r
Qf649/ZoPGH/M8YMBSvsTpdJ1R/O87//HVp3rH6mC1VaJtQonWK8TvH/jx4y
lSA+3VlmQFerD/jj8rhGv38xPn8nCQVaKxSjeFWD8+GeHz5gfH1w+3XT/XtM
Mdjf1d9ykJdYpwrl6B5C+3Khl54+YXpppeD1g/xFftj73y5k1Z5JM3Wzf6fW
uUsXGX/+GUKSbt1kcsHz0B3y3OWJ18cOoUEnhUb0Hp8f378xVTou9AfnP3+O
ianOUQ9hR92HH85fXydR11FHbJydbvs1L12+Dxj/c7ReKAf+YV/o1NZZ6GO+
kKPPnxjvv8u7tqhOxaijnfH5sUvIa305JPj7QV4kE0xV+xzsTg/vzJoO9AV9
HhP886hfm4RaUB8Qt2yG6acb1xmbX+2RPmK0X/DnR39G3lt9FfKC1vFVgn//
HCGj+sR5YEffxL1jP9hnCSnNE8QRdujOnS8TPA/d//jOhP3ZvS+h+jsieP/Q
T7A/4g07dIPzrxYGg33GW6E3+Ik+AvuL58z474N+XR6WonnP9083f5TpqBDO
F87/1kjX7XqfVl+4N+vPNCGuddjqB/UcdfeE4J93edsZ6bsrqA/or/be7f6o
j7a/IT7oH1af9+4yhSBvsbq8Smpe2jkP9d7VOZ9nsLt6nVD9o57Bjr6M/vTq
JTMU6BNzAPoJ7EsFX19sfuJ7+G37N/SBPm/rI/oy5i47X9vfJXb+QL/Cva4Q
/PtR11ye9QX9EefGPdr4u36Q1bjYPMd9nBI+BPeLuuvupzWaU7LBfIv9bX6i
PqC/2PxYIzR0RZ+FHe9z80s4X2IuQ345vfv9se/XL0w5ioOPP+ZGOxdhxe8H
zBn29xk+Iz9cv/NxdHry9XG833/IH5tnqBfYx94vPtu5HCv6L/IbcxjsyG/M
cfgdBzvyBX3T7mPjb8+H76E/O5/Y+mjj+xfoHbtL
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{47, 47},
         PlotRange->{{0, 47}, {0, 47}}], {1.4265847744468925`, 0.8454915027313978},
         Automatic, Automatic, {-0.9510565162424331, 0.3090169945372042},
        Background->GrayLevel[1]]}, {
       LineBox[{{1.5388417687852298`, 1.809016994253556}, {0.9510565163256759,
         1.}}], InsetBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztlf9TmmAYwAujlhppV1vbslmUUIvSGpa6NStGX3DlygpBQp11MteUheYq
zv70vXyzldxiP+yX3T533D13fN6H53nhfZgoVveLUFdX14J5pf9RUBT9ExmC
IMcrgI2wLEJCznyUZOOqGscRRz4KsaIEwxIdZ6H7BaF2aPZKuFjaplWcvPP1
hshaDdGpaegRLtLblXB4OlSSVLzW9qEaglNUPB4XAXEDLRyWvKGd8Gbl+FT3
rQZYShymJQAMkAy00FsKJZu5xubOcbK0TlNWw2K/BO7c0Y6TG4HmHtGING9n
S962379QSn4GbDwgEDg6uuzx+y8iU7fvQ15aZHX/LHD8enf3WycrlUpYkK+I
nsjU9ydJ0IC+oWdPt7a23toQ3rx5TsjR8fmeyJeJ6dPSuoqD/GfXl725m1cd
NBrzflln/iKn+WUY5E/PXJ9MznH+cRuiUTkDkAks1zsxPVKGRcTU5ejVfaKA
cTlDAPx+QpgD/myZptIzL06WnmGE+eB7gMwuAMif4fZ6m8sjsGjoSoqww2UC
1mn5l9+plu56BOHNpI9ftrIPDv7OTXFYorrk4+tm7Qo3mLLDkFOCclDNM1l3
H2voCYGzw8whKAXNPuxjSfCaYkueAkj/EAGg+RywPXlm8bzMkmi6/0c22Kpy
o/sPGBgYzWAYeASWKHiCvsU17ZvUdSaYb3k6qBYSioIJQmIM2O5u1TghVDmb
jfk6YRgmqBWpjLWCMXeRNc8rQq2t2vKhXv9YTXzV7PoQYk0D7WBbQBYgRii6
zLcOXK1gdvVT27afGtrgQFSYz4O6s4dq7fHJhJIUvci0GP5ccmCDKYarfCzG
d+NObKAjOM/zL38ZSY/5q+4hhHQ4sbVpSEKQ4z+CsUMO5f/8XX4C3itGoQ==

          "], {{0, 0}, {47, 47}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx1l/dqVFEQxoP4APZe8BVUVCzMM9gbKgj+rWIXRR/B3tsj2EtiA0EQSUg2
u5st2WzfZJNs7CXRRJ0595uDc8gPwmF3cu+ZM+ebsot27123Z0JTU9Ppf38T
//1dOM+8ocuXmLd08QITpybhI42NMo1ghb0zxpToymWmV7/Heuc2k6cDQple
vmD885uFXn1++CfTp/bZQpryPQI9e8p4+0GhQok4U6Enj5ma2mcKXbRNyNBi
oaT2q1eYvmifOv0aYfrVHusQaIMQ13PA3pUUaKGQp+ctzIDa4Q/Oaf3vyTGN
IG5Yc93MoK6jv5lB418xur9a8Hy8U6Dr15gMpboYf0+Im/UL606hR8+H+4b9
7BmmPfo+RvuEgtqvXWXqwQr7OqGkcUWcYF8ilHW1z0Mfzo8CzRN8fEaGmTrd
vsUMBeebIpQ0Dq9fMR/UjnN/+sgUAp3PFd7TAqGNtggptW8V0jRZKAb54/Kt
QoeFGrU0M15/jx8xVWp+xtQD/8+dZYrqvz2n+z5ON28w3UH8NgqJKA9Skc4r
Qf649/ZoPGH/M8YMBSvsTpdJ1R/O87//HVp3rH6mC1VaJtQonWK8TvH/jx4y
lSA+3VlmQFerD/jj8rhGv38xPn8nCQVaKxSjeFWD8+GeHz5gfH1w+3XT/XtM
Mdjf1d9ykJdYpwrl6B5C+3Khl54+YXpppeD1g/xFftj73y5k1Z5JM3Wzf6fW
uUsXGX/+GUKSbt1kcsHz0B3y3OWJ18cOoUEnhUb0Hp8f378xVTou9AfnP3+O
ianOUQ9hR92HH85fXydR11FHbJydbvs1L12+Dxj/c7ReKAf+YV/o1NZZ6GO+
kKPPnxjvv8u7tqhOxaijnfH5sUvIa305JPj7QV4kE0xV+xzsTg/vzJoO9AV9
HhP886hfm4RaUB8Qt2yG6acb1xmbX+2RPmK0X/DnR39G3lt9FfKC1vFVgn//
HCGj+sR5YEffxL1jP9hnCSnNE8QRdujOnS8TPA/d//jOhP3ZvS+h+jsieP/Q
T7A/4g07dIPzrxYGg33GW6E3+Ik+AvuL58z474N+XR6WonnP9083f5TpqBDO
F87/1kjX7XqfVl+4N+vPNCGuddjqB/UcdfeE4J93edsZ6bsrqA/or/be7f6o
j7a/IT7oH1af9+4yhSBvsbq8Smpe2jkP9d7VOZ9nsLt6nVD9o57Bjr6M/vTq
JTMU6BNzAPoJ7EsFX19sfuJ7+G37N/SBPm/rI/oy5i47X9vfJXb+QL/Cva4Q
/PtR11ye9QX9EefGPdr4u36Q1bjYPMd9nBI+BPeLuuvupzWaU7LBfIv9bX6i
PqC/2PxYIzR0RZ+FHe9z80s4X2IuQ345vfv9se/XL0w5ioOPP+ZGOxdhxe8H
zBn29xk+Iz9cv/NxdHry9XG833/IH5tnqBfYx94vPtu5HCv6L/IbcxjsyG/M
cfgdBzvyBX3T7mPjb8+H76E/O5/Y+mjj+xfoHbtL
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{47, 47},
         PlotRange->{{0, 47}, {0, 47}}], {1.2449491425554529`, 1.404508497126778},
         Automatic, Automatic, {-0.5877852524595539, -0.8090169942535561},
        Background->GrayLevel[1]]}}, 
     GraphicsComplexBox[{{0.36327126408405364`, 1.8090169944118928`}, {
      0.9510565163256759, 1.}, {0., 0.6909830057189905}, {0.951056516190987, 
      0.}, {1.902113032568109, 0.6909830054627958}, {1.5388417687852298`, 
      1.809016994253556}}, 
      {RGBColor[0, 0, 0.7], 
       TagBox[
        TooltipBox[PointBox[1],
         "2"],
        Annotation[#, 2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[2],
         "1"],
        Annotation[#, 1, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[3],
         "3"],
        Annotation[#, 3, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[4],
         "4"],
        Annotation[#, 4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[5],
         "5"],
        Annotation[#, 5, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[6],
         "6"],
        Annotation[#, 6, "Tooltip"]& ]}]},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{0.36327126408405364`, 1.8090169944118928`}, {
     0.9510565163256759, 1.}, {0., 0.6909830057189905}, {0.951056516190987, 
     0.}, {1.902113032568109, 0.6909830054627958}, {1.5388417687852298`, 
     1.809016994253556}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{197., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{201, 200},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->1941500312]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DirectedEdges",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectedEdges"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EdgeLabeling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EdgeLabeling"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MultiedgeStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MultiedgeStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SelfLoopStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SelfLoopStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VertexRenderingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexRenderingFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Arrow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Arrow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Arrowheads",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Arrowheads"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["General Graph Drawing",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphDrawing"]], "Tutorials",
 CellID->99260146],

Cell[TextData[ButtonBox["Hierarchical Drawing of Directed Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LayeredGraphDrawing"]], "Tutorials",
 CellID->106430589],

Cell[TextData[ButtonBox["Tree Drawing",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TreeDrawing"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EdgeRenderingFunction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 39, 38.2601538}", "context" -> "System`", 
    "keywords" -> {
     "edge rendering control", "edge drawing control", 
      "edge visualization in graphs"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "EdgeRenderingFunction is an option for GraphPlot and related functions \
which gives a function to generate the graphics primitives to use in \
rendering each edge.", "synonyms" -> {"edge rendering function"}, "title" -> 
    "EdgeRenderingFunction", "type" -> "Symbol", "uri" -> 
    "ref/EdgeRenderingFunction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8811, 274, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->812165794]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 100166, 2089}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2228, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2851, 76, 1586, 37, 70, "ObjectNameGrid"],
Cell[4440, 115, 691, 19, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5168, 139, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5646, 156, 1547, 57, 70, "Notes",
 CellID->636470603],
Cell[7196, 215, 620, 19, 70, "Notes",
 CellID->184577521],
Cell[7819, 236, 544, 18, 70, "Notes",
 CellID->336501309],
Cell[8366, 256, 408, 13, 70, "Notes",
 CellID->809570488]
}, Closed]],
Cell[CellGroupData[{
Cell[8811, 274, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->812165794],
Cell[CellGroupData[{
Cell[9196, 288, 148, 5, 70, "ExampleSection",
 CellID->129275924],
Cell[9347, 295, 95, 1, 70, "ExampleText",
 CellID->558263507],
Cell[CellGroupData[{
Cell[9467, 300, 601, 19, 47, "Input",
 CellID->188452606],
Cell[10071, 321, 3551, 74, 201, "Output",
 CellID->2127101784]
}, Open  ]],
Cell[13637, 398, 125, 3, 70, "ExampleDelimiter",
 CellID->843094468],
Cell[13765, 403, 91, 1, 70, "ExampleText",
 CellID->999507777],
Cell[CellGroupData[{
Cell[13881, 408, 753, 22, 70, "Input",
 CellID->131541535],
Cell[14637, 432, 20389, 341, 229, 1496, 27, "CachedBoxData", "BoxData", \
"Output",
 CellID->101699731]
}, Open  ]],
Cell[35041, 776, 125, 3, 70, "ExampleDelimiter",
 CellID->144330146],
Cell[35169, 781, 68, 1, 70, "ExampleText",
 CellID->283501837],
Cell[CellGroupData[{
Cell[35262, 786, 483, 14, 70, "Input",
 CellID->701174087],
Cell[35748, 802, 34527, 590, 216, 15874, 280, "CachedBoxData", "BoxData", \
"Output",
 CellID->750912444]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[70324, 1398, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[70548, 1407, 67, 1, 70, "ExampleText",
 CellID->2018360208],
Cell[CellGroupData[{
Cell[70640, 1412, 1060, 30, 70, "Input",
 CellID->142574885],
Cell[71703, 1444, 3642, 84, 70, "Output",
 CellID->1947308233]
}, Open  ]],
Cell[75360, 1531, 125, 3, 70, "ExampleDelimiter",
 CellID->552137592],
Cell[75488, 1536, 70, 1, 70, "ExampleText",
 CellID->374325799],
Cell[75561, 1539, 2812, 54, 70, "Input",
 CellID->1102851310],
Cell[CellGroupData[{
Cell[78398, 1597, 961, 28, 70, "Input",
 CellID->165798872],
Cell[79362, 1627, 16561, 318, 70, "Output",
 CellID->1941500312]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[95984, 1952, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[96303, 1963, 1748, 62, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[98088, 2030, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[98409, 2041, 147, 3, 70, "Tutorials",
 CellID->99260146],
Cell[98559, 2046, 173, 3, 70, "Tutorials",
 CellID->106430589],
Cell[98735, 2051, 138, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[98888, 2057, 27, 0, 70, "History"],
Cell[98918, 2059, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

