(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26685,        959]
NotebookOptionsPosition[     20718,        752]
NotebookOutlinePosition[     22027,        789]
CellTagsIndexPosition[     21942,        784]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partitioning Data into Clusters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PartitioningDataIntoClusters"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Partitioning Data into Clusters\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"HammingDistance" :> 
          Documentation`HelpLookup["paclet:ref/HammingDistance"], 
          "StringCount" :> Documentation`HelpLookup["paclet:ref/StringCount"],
           "JaccardDissimilarity" :> 
          Documentation`HelpLookup["paclet:ref/JaccardDissimilarity"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"HammingDistance\"\>", 
       2->"\<\"StringCount\"\>", 
       3->"\<\"JaccardDissimilarity\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Exploratory Data Analysis" :> 
          Documentation`HelpLookup["paclet:guide/DataClassification"], 
          "Discrete & Integer Data" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteAndIntegerData"], 
          "Distance and Dissimilarity Measures" :> 
          Documentation`HelpLookup[
           "paclet:guide/DistanceAndDissimilarityMeasures"], 
          "Processing Textual Data" :> 
          Documentation`HelpLookup["paclet:guide/ProcessingTextualData"], 
          "String Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/StringManipulation"], 
          "New in 6.0: Core Language" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60CoreLanguage"], 
          "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Exploratory Data Analysis\"\>", 
       2->"\<\"Discrete & Integer Data\"\>", 
       3->"\<\"Distance and Dissimilarity Measures\"\>", 
       4->"\<\"Processing Textual Data\"\>", 5->"\<\"String Manipulation\"\>",
        6->"\<\"New in 6.0: Core Language\"\>", 
       7->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["EditDistance", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["EditDistance",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/EditDistance"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the edit or Levenshtein distance between strings \
or vectors ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2082]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["EditDistance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EditDistance"], "[", 
   RowBox[{
    StyleBox["u", "TI"], ",", 
    StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
 " gives the number of one-element deletions, insertions, and substitutions \
required to transform ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->22929],

Cell[TextData[{
 "For strings, setting the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IgnoreCase",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IgnoreCase"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " makes ",
 Cell[BoxData[
  ButtonBox["EditDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EditDistance"]], "InlineFormula"],
 " treat lower\[Hyphen] and upper\[Hyphen]case letters as equivalent. "
}], "Notes",
 CellID->16541]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->365007276],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->61095870],

Cell["Edit distance between two strings:", "ExampleText",
 CellID->235641551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EditDistance", "[", 
  RowBox[{"\"\<abc\>\"", ",", "\"\<cba\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->40087832],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17054384]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->113385095],

Cell["Edit distance between two vectors:", "ExampleText",
 CellID->184380276],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EditDistance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "1"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->151527321],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->150875460]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24484],

Cell["Compute distance between strings of unequal length:", "ExampleText",
 CellID->86273121],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EditDistance", "[", 
  RowBox[{"\"\<abcdef\>\"", ",", "\"\<cba\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->488208944],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10848798]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->204991544],

Cell["Compute distance between vectors of any length:", "ExampleText",
 CellID->14044010],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EditDistance", "[", 
  RowBox[{
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->323525768],

Cell[BoxData["97"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->202869294]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->113428434],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "IgnoreCase",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->555569688],

Cell["Obtain edit distance ignoring case of letters:", "ExampleText",
 CellID->1408879],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EditDistance", "[", 
  RowBox[{"\"\<abc\>\"", ",", "\"\<AbC\>\"", ",", 
   RowBox[{"IgnoreCase", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->583201827],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->45009698]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6541],

Cell["Cluster string data using edit distance:", "ExampleText",
 CellID->245478961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\"\<abc\>\"", ",", "\"\<xyz\>\"", ",", "\"\<bca\>\"", ",", 
     "\"\<wxyz\>\""}], "}"}], ",", 
   RowBox[{"DistanceFunction", "\[Rule]", "EditDistance"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->108189764],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"abc\"\>", ",", "\<\"bca\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"xyz\"\>", ",", "\<\"wxyz\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3813508]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->478877783],

Cell["Cluster numeric data using edit distance:", "ExampleText",
 CellID->68571327],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"DistanceFunction", "\[Rule]", "EditDistance"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->174963025],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{237, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->509615045]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18115],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EditDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EditDistance"]], "InlineFormula"],
 " is less than or equal to ",
 Cell[BoxData[
  ButtonBox["HammingDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HammingDistance"]], "InlineFormula"],
 " for strings of equal length:"
}], "ExampleText",
 CellID->506287235],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EditDistance", "[", 
  RowBox[{"\"\<bccbbcb\>\"", ",", "\"\<ccbbccb\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57611571],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->109695753]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HammingDistance", "[", 
  RowBox[{"\"\<bccbbcb\>\"", ",", "\"\<ccbbccb\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2593590],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->163192980]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->284671756],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EditDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EditDistance"]], "InlineFormula"],
 " is less than or equal to ",
 Cell[BoxData[
  ButtonBox["HammingDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HammingDistance"]], "InlineFormula"],
 " for vectors of equal length:"
}], "ExampleText",
 CellID->27320770],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EditDistance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "0", ",", "1", ",", "1", ",", "0"}],
     "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->101558368],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->293489062]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HammingDistance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "0", ",", "1", ",", "1", ",", "0"}],
     "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->536399638],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->49529695]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30212],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["HammingDistance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HammingDistance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringCount"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JaccardDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JaccardDissimilarity"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29288]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24555],

Cell[TextData[ButtonBox["Partitioning Data into Clusters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartitioningDataIntoClusters"]], "Tutorials",
 CellID->22256]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with EditDistance",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=EditDistance"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->636469],

Cell[TextData[ButtonBox["Exploratory Data Analysis",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataClassification"]], "MoreAbout",
 CellID->66623239],

Cell[TextData[ButtonBox["Discrete & Integer Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteAndIntegerData"]], "MoreAbout",
 CellID->444894644],

Cell[TextData[ButtonBox["Distance and Dissimilarity Measures",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DistanceAndDissimilarityMeasures"]], "MoreAbout",
 CellID->438008881],

Cell[TextData[ButtonBox["Processing Textual Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProcessingTextualData"]], "MoreAbout",
 CellID->121288777],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->45178251],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "MoreAbout",
 CellID->50899366],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->86618766]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EditDistance - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 39, 39.9633224}", "context" -> "System`", 
    "keywords" -> {
     "Levenshtein distance", "string distance", "string metric"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "EditDistance[u, v] gives the edit or Levenshtein distance between \
strings or vectors u and v.", "synonyms" -> {"edit distance"}, "title" -> 
    "EditDistance", "type" -> "Symbol", "uri" -> "ref/EditDistance"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7558, 223, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->365007276]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21799, 777}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3058, 69, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3681, 96, 1577, 37, 70, "ObjectNameGrid"],
Cell[5261, 135, 725, 24, 70, "Usage",
 CellID->2082]
}, Open  ]],
Cell[CellGroupData[{
Cell[6023, 164, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6501, 181, 499, 18, 70, "Notes",
 CellID->22929],
Cell[7003, 201, 518, 17, 70, "Notes",
 CellID->16541]
}, Closed]],
Cell[CellGroupData[{
Cell[7558, 223, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->365007276],
Cell[CellGroupData[{
Cell[7943, 237, 147, 5, 70, "ExampleSection",
 CellID->61095870],
Cell[8093, 244, 77, 1, 70, "ExampleText",
 CellID->235641551],
Cell[CellGroupData[{
Cell[8195, 249, 150, 4, 28, "Input",
 CellID->40087832],
Cell[8348, 255, 157, 5, 36, "Output",
 CellID->17054384]
}, Open  ]],
Cell[8520, 263, 125, 3, 70, "ExampleDelimiter",
 CellID->113385095],
Cell[8648, 268, 77, 1, 70, "ExampleText",
 CellID->184380276],
Cell[CellGroupData[{
Cell[8750, 273, 292, 9, 70, "Input",
 CellID->151527321],
Cell[9045, 284, 158, 5, 36, "Output",
 CellID->150875460]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9252, 295, 216, 7, 70, "ExampleSection",
 CellID->24484],
Cell[9471, 304, 93, 1, 70, "ExampleText",
 CellID->86273121],
Cell[CellGroupData[{
Cell[9589, 309, 154, 4, 70, "Input",
 CellID->488208944],
Cell[9746, 315, 157, 5, 36, "Output",
 CellID->10848798]
}, Open  ]],
Cell[9918, 323, 125, 3, 70, "ExampleDelimiter",
 CellID->204991544],
Cell[10046, 328, 89, 1, 70, "ExampleText",
 CellID->14044010],
Cell[CellGroupData[{
Cell[10160, 333, 258, 8, 70, "Input",
 CellID->323525768],
Cell[10421, 343, 159, 5, 36, "Output",
 CellID->202869294]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10629, 354, 222, 7, 70, "ExampleSection",
 CellID->113428434],
Cell[CellGroupData[{
Cell[10876, 365, 231, 7, 70, "ExampleSubsection",
 CellID->555569688],
Cell[11110, 374, 87, 1, 70, "ExampleText",
 CellID->1408879],
Cell[CellGroupData[{
Cell[11222, 379, 203, 5, 70, "Input",
 CellID->583201827],
Cell[11428, 386, 157, 5, 36, "Output",
 CellID->45009698]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[11646, 398, 222, 7, 70, "ExampleSection",
 CellID->6541],
Cell[11871, 407, 83, 1, 70, "ExampleText",
 CellID->245478961],
Cell[CellGroupData[{
Cell[11979, 412, 310, 10, 70, "Input",
 CellID->108189764],
Cell[12292, 424, 341, 11, 36, "Output",
 CellID->3813508]
}, Open  ]],
Cell[12648, 438, 125, 3, 70, "ExampleDelimiter",
 CellID->478877783],
Cell[12776, 443, 83, 1, 70, "ExampleText",
 CellID->68571327],
Cell[CellGroupData[{
Cell[12884, 448, 470, 16, 70, "Input",
 CellID->174963025],
Cell[13357, 466, 514, 19, 36, "Output",
 CellID->509615045]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13920, 491, 233, 7, 70, "ExampleSection",
 CellID->18115],
Cell[14156, 500, 378, 12, 70, "ExampleText",
 CellID->506287235],
Cell[CellGroupData[{
Cell[14559, 516, 158, 4, 70, "Input",
 CellID->57611571],
Cell[14720, 522, 158, 5, 36, "Output",
 CellID->109695753]
}, Open  ]],
Cell[CellGroupData[{
Cell[14915, 532, 160, 4, 70, "Input",
 CellID->2593590],
Cell[15078, 538, 158, 5, 36, "Output",
 CellID->163192980]
}, Open  ]],
Cell[15251, 546, 125, 3, 70, "ExampleDelimiter",
 CellID->284671756],
Cell[15379, 551, 377, 12, 70, "ExampleText",
 CellID->27320770],
Cell[CellGroupData[{
Cell[15781, 567, 339, 10, 70, "Input",
 CellID->101558368],
Cell[16123, 579, 158, 5, 36, "Output",
 CellID->293489062]
}, Open  ]],
Cell[CellGroupData[{
Cell[16318, 589, 342, 10, 70, "Input",
 CellID->536399638],
Cell[16663, 601, 157, 5, 36, "Output",
 CellID->49529695]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16881, 613, 311, 9, 70, "SeeAlsoSection",
 CellID->30212],
Cell[17195, 624, 740, 26, 70, "SeeAlso",
 CellID->29288]
}, Open  ]],
Cell[CellGroupData[{
Cell[17972, 655, 314, 9, 70, "TutorialsSection",
 CellID->24555],
Cell[18289, 666, 170, 3, 70, "Tutorials",
 CellID->22256]
}, Open  ]],
Cell[CellGroupData[{
Cell[18496, 674, 305, 8, 70, "RelatedLinksSection"],
Cell[18804, 684, 369, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19210, 701, 316, 9, 70, "MoreAboutSection",
 CellID->636469],
Cell[19529, 712, 154, 3, 70, "MoreAbout",
 CellID->66623239],
Cell[19686, 717, 157, 3, 70, "MoreAbout",
 CellID->444894644],
Cell[19846, 722, 179, 3, 70, "MoreAbout",
 CellID->438008881],
Cell[20028, 727, 156, 3, 70, "MoreAbout",
 CellID->121288777],
Cell[20187, 732, 148, 3, 70, "MoreAbout",
 CellID->45178251],
Cell[20338, 737, 155, 3, 70, "MoreAbout",
 CellID->50899366],
Cell[20496, 742, 150, 3, 70, "MoreAbout",
 CellID->86618766]
}, Open  ]],
Cell[20661, 748, 27, 0, 70, "History"],
Cell[20691, 750, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

