(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14961,        504]
NotebookOptionsPosition[     11540,        395]
NotebookOutlinePosition[     13022,        435]
CellTagsIndexPosition[     12937,        430]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Cells" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForCells"], 
          "Options for Notebooks" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForNotebooks"], 
          "Representing Textual Forms by Boxes" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RepresentingTextualFormsByBoxes"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Options for Cells\"\>", 
       2->"\<\"Options for Notebooks\"\>", 
       3->"\<\"Representing Textual Forms by Boxes\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Deploy" :> Documentation`HelpLookup["paclet:ref/Deploy"], 
          "CellEditDuplicate" :> 
          Documentation`HelpLookup["paclet:ref/CellEditDuplicate"], 
          "Selectable" :> Documentation`HelpLookup["paclet:ref/Selectable"], 
          "ContentSelectable" :> 
          Documentation`HelpLookup["paclet:ref/ContentSelectable"], 
          "Copyable" :> Documentation`HelpLookup["paclet:ref/Copyable"], 
          "Protected" :> Documentation`HelpLookup["paclet:ref/Protected"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Deploy\"\>", 
       2->"\<\"CellEditDuplicate\"\>", 3->"\<\"Selectable\"\>", 
       4->"\<\"ContentSelectable\"\>", 5->"\<\"Copyable\"\>", 
       6->"\<\"Protected\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Package Bulletproofing" :> 
          Documentation`HelpLookup["paclet:guide/PackageBulletproofing"], 
          "Stand-Alone Interfaces" :> 
          Documentation`HelpLookup["paclet:guide/StandAloneInterfaces"], 
          "Stylesheets" :> 
          Documentation`HelpLookup["paclet:guide/Stylesheets"], 
          "Window Properties" :> 
          Documentation`HelpLookup["paclet:guide/WindowProperties"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Package Bulletproofing\"\>", 
       2->"\<\"Stand-Alone Interfaces\"\>", 3->"\<\"Stylesheets\"\>", 
       4->"\<\"Window Properties\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Editable", "ObjectName",
 CellID->343],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Editable",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Editable"]], "InlineFormula"],
     "\[LineSeparator]is an option for displayed objects, cells and notebooks \
which specifies whether their contents can be edited interactively using the \
front end. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15085]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Even with the setting ",
 Cell[BoxData[
  RowBox[{"Editable", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the contents of an object can still be copied as a whole. "
}], "Notes",
 CellID->2904],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Editable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Editable"]], "InlineFormula"],
 " is an option for ",
 Cell[BoxData[
  ButtonBox["InterpretationBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpretationBox"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 ", as well as for ",
 Cell[BoxData[
  ButtonBox["StyleBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StyleBox"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25854],

Cell[TextData[{
 "Setting ",
 Cell[BoxData[
  RowBox[{"Editable", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " effectively allows you to \[OpenCurlyDoubleQuote]write protect\
\[CloseCurlyDoubleQuote] elements of notebooks. "
}], "Notes",
 CellID->28681]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->127028327],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->499742705],

Cell["Create a cell that cannot be edited interactively:", "ExampleText",
 CellID->13068558],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"TextCell", "[", 
   RowBox[{"\"\<noneditable text\>\"", ",", "\"\<Text\>\"", ",", 
    RowBox[{"Editable", "\[Rule]", "False"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->131023363],

Cell["noneditable text", "Text",
 Editable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->58353722],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->95222069],

Cell["Create a noneditable part of a cell:", "ExampleText",
 CellID->189081492],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"TextCell", "[", 
   RowBox[{
    RowBox[{"Row", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<abcde \>\"", ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<abde\>\"", ",", "Bold", ",", 
         RowBox[{"Editable", "\[Rule]", "False"}]}], "]"}], ",", 
       "\"\< abcde\>\""}], "}"}], "]"}], ",", "\"\<Text\>\""}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->200183863],

Cell[TextData[{
 "abcde ",
 StyleBox["abde",
  Editable->False,
  StripOnInput->False,
  FontWeight->Bold],
 " abcde"
}], "Text",
 CellID->51555877]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19031],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Deploy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Deploy"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellEditDuplicate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellEditDuplicate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Selectable",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Selectable"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ContentSelectable",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContentSelectable"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Copyable",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Copyable"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Protected",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Protected"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11565]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23778],

Cell[TextData[ButtonBox["Options for Cells",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForCells"]], "Tutorials",
 CellID->2591],

Cell[TextData[ButtonBox["Options for Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForNotebooks"]], "Tutorials",
 CellID->232099468],

Cell[TextData[ButtonBox["Representing Textual Forms by Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RepresentingTextualFormsByBoxes"]], "Tutorials",\

 CellID->10904]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->66626976],

Cell[TextData[ButtonBox["Package Bulletproofing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageBulletproofing"]], "MoreAbout",
 CellID->254595412],

Cell[TextData[ButtonBox["Stand-Alone Interfaces",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StandAloneInterfaces"]], "MoreAbout",
 CellID->329399913],

Cell[TextData[ButtonBox["Stylesheets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "MoreAbout",
 CellID->234424895],

Cell[TextData[ButtonBox["Window Properties",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WindowProperties"]], "MoreAbout",
 CellID->498080490]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Editable - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 39, 39.4789350}", "context" -> "System`", 
    "keywords" -> {
     "locking cells", "locking notebooks", "protection", "write protection", 
      "edit protection", "freezing cells", "freezing text", 
      "freezing graphics", "read only cells", "read only text"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Editable is an option for displayed objects, cells and notebooks which \
specifies whether their contents can be edited interactively using the front \
end. ", "synonyms" -> {}, "title" -> "Editable", "type" -> "Symbol", "uri" -> 
    "ref/Editable"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6037, 185, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->127028327]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12794, 423}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3081, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3704, 95, 44, 1, 70, "ObjectName",
 CellID->343],
Cell[3751, 98, 531, 15, 70, "Usage",
 CellID->15085]
}, Open  ]],
Cell[CellGroupData[{
Cell[4319, 118, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4797, 135, 281, 9, 70, "Notes",
 CellID->2904],
Cell[5081, 146, 595, 22, 70, "Notes",
 CellID->25854],
Cell[5679, 170, 321, 10, 70, "Notes",
 CellID->28681]
}, Closed]],
Cell[CellGroupData[{
Cell[6037, 185, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->127028327],
Cell[CellGroupData[{
Cell[6422, 199, 148, 5, 70, "ExampleSection",
 CellID->499742705],
Cell[6573, 206, 92, 1, 70, "ExampleText",
 CellID->13068558],
Cell[6668, 209, 250, 6, 70, "Input",
 CellID->131023363],
Cell[6921, 217, 117, 4, 70, "Text",
 CellID->58353722],
Cell[7041, 223, 124, 3, 70, "ExampleDelimiter",
 CellID->95222069],
Cell[7168, 228, 79, 1, 70, "ExampleText",
 CellID->189081492],
Cell[7250, 231, 444, 13, 70, "Input",
 CellID->200183863],
Cell[7697, 246, 148, 8, 70, "Text",
 CellID->51555877]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7894, 260, 311, 9, 70, "SeeAlsoSection",
 CellID->19031],
Cell[8208, 271, 1469, 53, 70, "SeeAlso",
 CellID->11565]
}, Open  ]],
Cell[CellGroupData[{
Cell[9714, 329, 314, 9, 70, "TutorialsSection",
 CellID->23778],
Cell[10031, 340, 142, 3, 70, "Tutorials",
 CellID->2591],
Cell[10176, 345, 155, 3, 70, "Tutorials",
 CellID->232099468],
Cell[10334, 350, 179, 4, 70, "Tutorials",
 CellID->10904]
}, Open  ]],
Cell[CellGroupData[{
Cell[10550, 359, 318, 9, 70, "MoreAboutSection",
 CellID->66626976],
Cell[10871, 370, 155, 3, 70, "MoreAbout",
 CellID->254595412],
Cell[11029, 375, 154, 3, 70, "MoreAbout",
 CellID->329399913],
Cell[11186, 380, 134, 3, 70, "MoreAbout",
 CellID->234424895],
Cell[11323, 385, 145, 3, 70, "MoreAbout",
 CellID->498080490]
}, Open  ]],
Cell[11483, 391, 27, 0, 70, "History"],
Cell[11513, 393, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

