(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     98870,       2913]
NotebookOptionsPosition[     86549,       2485]
NotebookOutlinePosition[     88137,       2527]
CellTagsIndexPosition[     88051,       2522]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vectors and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/VectorsAndMatrices"], 
          "Eigenvalues and Eigenvectors" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EigenvaluesAndEigenvectors"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Vectors and Matrices\"\>", 
       2->"\<\"Eigenvalues and Eigenvectors\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NullSpace" :> Documentation`HelpLookup["paclet:ref/NullSpace"],
           "Eigenvalues" :> 
          Documentation`HelpLookup["paclet:ref/Eigenvalues"], "Eigensystem" :> 
          Documentation`HelpLookup["paclet:ref/Eigensystem"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NullSpace\"\>", 
       2->"\<\"Eigenvalues\"\>", 
       3->"\<\"Eigensystem\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Matrix Operations" :> 
          Documentation`HelpLookup["paclet:guide/MatrixOperations"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Matrix Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Eigenvectors", "ObjectName",
 CellID->3242],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Eigenvectors",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Eigenvectors"], "[", 
       StyleBox["m", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the eigenvectors of the square matrix ",
     
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Eigenvectors",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Eigenvectors"], "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["m", "TI"], ",", 
         StyleBox["a", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the generalized eigenvectors of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " with respect to ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Eigenvectors",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Eigenvectors"], "[", 
       RowBox[{
        StyleBox["m", "TI"], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the first ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " eigenvectors of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Eigenvectors",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Eigenvectors"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["m", "TI"], ",", 
          StyleBox["a", "TI"]}], "}"}], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the first ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " generalized eigenvectors."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->12314]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Eigenvectors",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eigenvectors"]], "InlineFormula"],
 " finds numerical eigenvectors if ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " contains approximate real or complex numbers. "
}], "Notes",
 CellID->8300],

Cell["\<\
Eigenvectors corresponding to degenerate eigenvalues are chosen to be \
linearly independent. \
\>", "Notes",
 CellID->22981],

Cell["Eigenvectors are not normalized. ", "Notes",
 CellID->65],

Cell[TextData[{
 "For an ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], "\[Cross]", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " matrix, ",
 Cell[BoxData[
  ButtonBox["Eigenvectors",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eigenvectors"]], "InlineFormula"],
 " always returns a list of length ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ". The list contains each of the independent eigenvectors of the matrix, \
followed if necessary by an appropriate number of vectors of zeros. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->22375402,
  ButtonNote->"22375402"]
}], "Notes",
 CellID->229],

Cell["\<\
Eigenvectors with numeric eigenvalues are sorted in order of decreasing \
absolute value of their eigenvalues. \
\>", "Notes",
 CellID->8091],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Eigenvectors",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eigenvectors"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    RowBox[{
     ButtonBox["ZeroTest",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ZeroTest"], "->", 
     StyleBox["test", "TI"]}]}], "]"}]], "InlineFormula"],
 " applies ",
 Cell[BoxData[
  StyleBox["test", "TI"]], "InlineFormula"],
 " to determine whether expressions should be assumed to be zero. The default \
setting is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ZeroTest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ZeroTest"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10953],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Eigenvectors",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eigenvectors"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    StyleBox["spec", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Take",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Take"], "[", 
   RowBox[{
    RowBox[{"Eigenvectors", "[", 
     StyleBox["m", "TI"], "]"}], ",", 
    StyleBox["spec", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14275],

Cell[TextData[{
 "The option settings ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Cubics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cubics"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Quartics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quartics"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " can be used to specify that explicit radicals should be generated for all \
cubics and quartics. "
}], "Notes",
 CellID->6133],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects can be used in ",
 Cell[BoxData[
  ButtonBox["Eigenvectors",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eigenvectors"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27116]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->364862757],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->31077795],

Cell["Symbolic eigenvectors:", "ExampleText",
 CellID->35348174],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvectors", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->247985212],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "a"}], "+", "d", "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          RowBox[{"4", " ", "b", " ", "c"}], "-", 
          RowBox[{"2", " ", "a", " ", "d"}], "+", 
          SuperscriptBox["d", "2"]}]]}], 
       RowBox[{"2", " ", "c"}]]}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "a"}], "+", "d", "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          RowBox[{"4", " ", "b", " ", "c"}], "-", 
          RowBox[{"2", " ", "a", " ", "d"}], "+", 
          SuperscriptBox["d", "2"]}]]}], 
       RowBox[{"2", " ", "c"}]]}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{483, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39368252]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->495144951],

Cell["Exact eigenvectors:", "ExampleText",
 CellID->353977768],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvectors", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->139727108],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["13", "11"]}], "+", 
      RowBox[{
       FractionBox["1", "22"], " ", 
       RowBox[{"(", 
        RowBox[{"15", "+", 
         RowBox[{"3", " ", 
          SqrtBox["33"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "11"]}], "+", 
      RowBox[{
       FractionBox["1", "44"], " ", 
       RowBox[{"(", 
        RowBox[{"15", "+", 
         RowBox[{"3", " ", 
          SqrtBox["33"]}]}], ")"}]}]}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["13", "11"]}], "+", 
      RowBox[{
       FractionBox["1", "22"], " ", 
       RowBox[{"(", 
        RowBox[{"15", "-", 
         RowBox[{"3", " ", 
          SqrtBox["33"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "11"]}], "+", 
      RowBox[{
       FractionBox["1", "44"], " ", 
       RowBox[{"(", 
        RowBox[{"15", "-", 
         RowBox[{"3", " ", 
          SqrtBox["33"]}]}], ")"}]}]}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "2"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{420, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->490780276]
}, Open  ]],

Cell["Numerical value:", "ExampleText",
 CellID->295499056],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->387858559],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.2833494518006403`", ",", "0.6416747259003202`", ",", "1.`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.2833494518006403`"}], ",", 
     RowBox[{"-", "0.14167472590032015`"}], ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", 
     RowBox[{"-", "2.`"}], ",", "1.`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{460, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->159021310]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->302311108],

Cell["Eigenvectors computed using numerical methods:", "ExampleText",
 CellID->80476748],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvectors", "[", 
  RowBox[{"N", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->130178002],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.231970687246286`"}], ",", 
     RowBox[{"-", "0.5253220933012335`"}], ",", 
     RowBox[{"-", "0.8186734993561816`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.7858302387420671`"}], ",", 
     RowBox[{"-", "0.08675133925662842`"}], ",", "0.6123275602288102`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.4082482904638633`", ",", 
     RowBox[{"-", "0.816496580927726`"}], ",", "0.40824829046386263`"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{461, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->151613796]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22769],

Cell["\<\
Eigenvectors computed using numerical methods with 20-digit precision:\
\>", "ExampleText",
 CellID->199072870],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvectors", "[", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], ",", "20"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->550602945],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.23197068724628586166084715996393166237`20."}], ",", 
     RowBox[{"-", "0.5253220933012336934319879951297077174`20."}], ",", 
     RowBox[{"-", "0.81867349935618152520312883029378605452`20."}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.78583023874206710167510101490555266609`20."}], ",", 
     RowBox[{"-", "0.08675133925662845361504187871974921573`20."}], ",", 
     "0.61232756022881019444501725747092723258`20."}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.40824829046386301636621401244506805368`20.", ",", 
     RowBox[{"-", "0.81649658092772603273242802490240120679`20."}], ",", 
     "0.4082482904638630163662140124560209247`20."}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{540, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->153177775]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5373117],

Cell["A Hilbert matrix:", "ExampleText",
 CellID->357731883],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"N", "[", 
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"i", "+", "j", "+", "1"}], ")"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "10"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->303609810],

Cell["\<\
Eigenvectors corresponding to the eigenvalues with smallest magnitude:\
\>", "ExampleText",
 CellID->104202900],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vecs", "=", 
  RowBox[{"Eigenvectors", "[", 
   RowBox[{"m", ",", 
    RowBox[{"-", "2"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->154949572],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.00019927809123430635`", ",", 
     RowBox[{"-", "0.005220803144240182`"}], ",", "0.048235938513528226`", 
     ",", 
     RowBox[{"-", "0.21311789445351878`"}], ",", "0.4879540135430962`", ",", 
     RowBox[{"-", "0.5257476104881661`"}], ",", "0.04177266635949903`", ",", 
     "0.4781533821763959`", ",", 
     RowBox[{"-", "0.4377144105782719`"}], ",", "0.12548933726004052`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.000018892326271833865`"}], ",", "0.0006630673404566363`",
      ",", 
     RowBox[{"-", "0.008440050745953923`"}], ",", "0.054169186865833545`", 
     ",", 
     RowBox[{"-", "0.20006496273741275`"}], ",", "0.4513031185338781`", ",", 
     RowBox[{"-", "0.6320193749296165`"}], ",", "0.536251721525218`", ",", 
     RowBox[{"-", "0.25242874263093357`"}], ",", "0.05058518931010284`"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{447, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->35361951]
}, Open  ]],

Cell["The corresponding eigenvalues:", "ExampleText",
 CellID->346346698],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{"m", ",", 
   RowBox[{"-", "2"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->50325078],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.0459549047996723`*^-12", ",", "4.426901333353528`*^-15"}], 
  "}"}]], "Output",
 ImageSize->{202, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->349455507]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->138025455],

Cell["\<\
Zero vectors are used when there more eigenvalues than independent \
eigenvectors:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->22375402],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvectors", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->327248859],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->53407432]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->49710436],

Cell["Compute generalized eigenvectors:", "ExampleText",
 CellID->490149319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.", ",", "4."}], "}"}]}], "}"}]}], ";", 
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "4."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9.", ",", "16."}], "}"}]}], "}"}]}], ";", 
  RowBox[{"Eigenvectors", "[", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->91203630],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0.8484719165348688`", "\[InvisibleSpace]", "-", 
      RowBox[{"0.08583783620510349`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{
      RowBox[{"-", "0.49804348493191636`"}], "-", 
      RowBox[{"0.15709856728864385`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0.8484719165348688`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.08583783620510349`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{
      RowBox[{"-", "0.49804348493191636`"}], "+", 
      RowBox[{"0.15709856728864385`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{330, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->145817629]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21609],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Sparse Arrays",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->873108938],

Cell["A block diagonal matrix:", "ExampleText",
 CellID->10201624],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"s", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Band", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "]"}], "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "4"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"ArrayPlot", "[", 
   RowBox[{"s", ",", 
    RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->120078182],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt2zFuwjAUBmATX4DREgPZ7GzcIEztVHEFIlQBQ5WKImXMATIzcwImWJi4
Sm7AEdL3bChxSimtEEP7W8qzn5V8cTL5KcpTMp88vyTz6SgJH2fJ62Q6egsf
0hlNyZYQYsOHEjSuaGSPTVVRX4+So9zv96vVarfbCcNBbrfbWh6s1+uo1gtJ
g7Is+dKgphRF0el0+v2+MBykMUYpdcrDMBSuRRxku90ObROaA+fj8bipLpfL
4XDIQ3M2z/PcU+M4zm0TmsMhhwoVKlSoUKFChQoVKlSo91EXi0Wv1+MTjD1r
MBh4OV3lqd1uN7ZNaA6cZ1nWVKni/E51kDBHxbtLmqaVbaL1szfgHvKLtbvH
hwoVKlSoUKFChQoVKlSo91GvqDh/URuS6p2llIptO9WptbUGNI6Od3Ngs9b2
NLfA/EwtzW8ioHF06CUUKFCgQIECBQoUKP9Eue0enDQHHOoArbWnx973rSt2
9M2qw9Pyj1pFX35PUKBAgQIFChQoUKD8WaUoihvuwcuypNnTmrIsu5hTQlNe
7v3d9PmvKdF6B8qBRvI=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->314232850]
}, Open  ]],

Cell["Compute the eigenvectors:", "ExampleText",
 CellID->262352655],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvectors", "[", "s", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->726678371],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{370, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->594447746]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->239691314],

Cell["A tridiagonal matrix:", "ExampleText",
 CellID->135652336],

Cell[BoxData[
 RowBox[{
  RowBox[{"s", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x_", ",", "y_"}], "}"}], "/;", 
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{"x", "-", "y"}], "]"}], "\[LessEqual]", "1"}]}], "\[Rule]", 
       
       RowBox[{
        RowBox[{"3.", 
         RowBox[{"Abs", "[", 
          RowBox[{"x", "-", "y"}], "]"}]}], "-", "2."}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"250", ",", "250"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->317140975],

Cell["\<\
The eigenvectors corresponding to the three largest eigenvalues:\
\>", "ExampleText",
 CellID->44080672],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Eigenvectors", "[", 
   RowBox[{"s", ",", "3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->206745217],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->15357310]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18987],

Cell[TextData[{
 "The eigenvectors of a 3\[Times]3 matrix ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->539885110],

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"Eigenvectors", "[", "m", "]"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->295106875],

Cell[TextData[{
 "Diagonalize ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->320684602],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Inverse", "[", "v", "]"}], ".", "m", ".", "v"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->69766063],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["3", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"5", "+", 
        SqrtBox["33"]}], ")"}]}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["3", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "5"}], "+", 
        SqrtBox["33"]}], ")"}]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{372, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->113842921]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->203433568],

Cell["The eigenvalues of a nondiagonalizable matrix:", "ExampleText",
 CellID->106348115],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "2"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"vecs", "=", 
  RowBox[{"Eigenvectors", "[", "m", "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->23305850],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->271404879]
}, Open  ]],

Cell["Find the dimension of the span of all the eigenvectors:", "ExampleText",
 CellID->350159766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Count", "[", 
  RowBox[{"vecs", ",", 
   RowBox[{"v_", "/;", 
    RowBox[{
     RowBox[{"Norm", "[", "v", "]"}], ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->60253324],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->327460068]
}, Open  ]],

Cell["\<\
Estimate the probability that a random 4\[Times]4 matrix of ones and zeros is \
not diagonalizable:\
\>", "ExampleText",
 CellID->3551629],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"nd", "=", "0"}], ",", 
     RowBox[{"trials", "=", 
      RowBox[{"10", "^", "4"}]}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"m", "=", 
        RowBox[{"N", "[", 
         RowBox[{"RandomInteger", "[", 
          RowBox[{"1", ",", 
           RowBox[{"{", 
            RowBox[{"4", ",", "4"}], "}"}]}], "]"}], "]"}]}], ";", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Count", "[", 
           RowBox[{
            RowBox[{"Eigenvectors", "[", "m", "]"}], ",", 
            RowBox[{"v_", "/;", 
             RowBox[{
              RowBox[{"Norm", "[", "v", "]"}], ">", "0"}]}]}], "]"}], "<", 
          "4"}], ",", 
         RowBox[{"nd", "++"}]}], "]"}]}], ",", 
      RowBox[{"{", "trials", "}"}]}], "]"}], ";", 
    RowBox[{"N", "[", 
     RowBox[{"nd", "/", "trials"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->37685936],

Cell[BoxData["0.238`"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->59714594]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18518],

Cell["Compute the eigenvectors for a random symmetric matrix:", "ExampleText",
 CellID->416032189],

Cell[BoxData[{
 RowBox[{
  RowBox[{"r", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"100", ",", "100"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r", "=", 
   RowBox[{"r", ".", 
    RowBox[{"Transpose", "[", "r", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vecs", "=", 
   RowBox[{"Eigenvectors", "[", "r", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->72115827],

Cell["\<\
The numerical eigenvectors are orthonormal to the precision of the \
computation:\
\>", "ExampleText",
 CellID->167140292],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"Abs", "[", 
   RowBox[{
    RowBox[{"vecs", ".", 
     RowBox[{"Transpose", "[", "vecs", "]"}]}], "-", 
    RowBox[{"IdentityMatrix", "[", "100", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20720065],

Cell[BoxData["8.881784197001252`*^-16"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->16741997]
}, Open  ]],

Cell[TextData[{
 "Diagonalization of the matrix ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->410720412],

Cell[BoxData[
 RowBox[{
  RowBox[{"d", "=", 
   RowBox[{"vecs", ".", "r", ".", 
    RowBox[{"Transpose", "[", "vecs", "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->771802174],

Cell["\<\
The diagonal elements are essentially the same as the eigenvalues:\
\>", "ExampleText",
 CellID->474695885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"Abs", "[", 
   RowBox[{
    RowBox[{"Tr", "[", 
     RowBox[{"d", ",", "List"}], "]"}], "-", 
    RowBox[{"Eigenvalues", "[", "r", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->110916326],

Cell[BoxData["9.094947017729282`*^-13"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->507577935]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->76875828],

Cell["The first eigenvector of a random matrix:", "ExampleText",
 CellID->52270589],

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "10"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{
    RowBox[{"Eigenvectors", "[", "m", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->293320954],

Cell[TextData[{
 "The position of the largest component in ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->14268446],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "=", 
  RowBox[{
   RowBox[{"Position", "[", 
    RowBox[{
     RowBox[{"Abs", "[", "v", "]"}], ",", 
     RowBox[{"Max", "[", 
      RowBox[{"Abs", "[", "v", "]"}], "]"}]}], "]"}], "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "1"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->984127246],

Cell[BoxData["9"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->51283384]
}, Open  ]],

Cell[TextData[{
 "Compute the eigenvalue corresponding to eigenvector ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->151498562],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"m", ".", "v"}], ")"}], "[", 
   RowBox[{"[", "p", "]"}], "]"}], "/", 
  RowBox[{"v", "[", 
   RowBox[{"[", "p", "]"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->37807961],

Cell[BoxData["5.272457046811564`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->523243504]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14109],

Cell["The general symbolic case quickly gets very complicated:", "ExampleText",
 CellID->153668477],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Subscript", "[", 
     RowBox[{"a", ",", "##"}], "]"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->845404531],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["a", 
      RowBox[{"1", ",", "1"}]], ",", 
     SubscriptBox["a", 
      RowBox[{"1", ",", "2"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["a", 
      RowBox[{"2", ",", "1"}]], ",", 
     SubscriptBox["a", 
      RowBox[{"2", ",", "2"}]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{170, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->473275923]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvectors", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->71578896],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWL1PVEEQ37v37gP58FRQEMVDQ2IstVBbMYox1lIZTmICBXBB+ispz4+C
Qg3lxYhQGKXkD7DgT6CkJFaUz9mvY5k373bfcsYr3iX3dmd257ezs7O7s/Oi
trbwZqm2tjhfqz5drdUXFuffVp+srAIryDGWe80YeznKoB5BTfz5bx7+sipr
P/g30K0R2xLc7/DlzAC1FqDaavcwW0LdHOkf1NlXUX6GL28qqjKPZEuIbrWl
4ogFkov1pBG/IG6RxDK143SZxOqHbx6Y7wnMkNCoqPp/UmXBKBk7h3p/cLLu
N6qXQedJ7I+EFCe3vNCapGY/vbDeKU1+eUnzz33Eq5wJia/PBW+EB4invR8j
0Ih9BOJDpRNuK1gQcwIR+3Go9JGeure3x+SPL+CU2FSVSuXo6Ig3DxFzwVhw
6IiRcon6P/bSm7LttEXSfZV6DemVoA8PDxV9CbVvI3oskj5BrYh9tKqFHhX0
3Nycogci+gTnvCnEu4LoO4i+jOjxyLhzQvNE4dzrXvMb66DvSMfxpN339/dn
ZmZgE7DzCCHQMG0pvmWq5ngxzMEo+Vad6KBpf0dNsZ3D072gcsPLduNOM7aP
PiJ6NBoNMObOzk7Mkviuxj4YxBAxAn073nTSf9Cq/1WLvte8rDscucVCeF+7
xlDi3gqlyY+Pj9fX18uOkhTNyUIKjV36DUXpokLX8X31cVtHHfeJ8yF1HIpX
0y+alWtbr9dhYaEKW6vkhYNpHCHQO8aG6jenIVLKD4s+D9Jagx4bvw5KiOan
Zjy+5/doO9bymk8h0Ro2jfS+kT4CkcXGxoaUhkOB0Z6TV9qXVVmKTmLXoirt
8zC9namdnv69pWdPnYTd8g2bDfUZ4uePt0W/yUi+DLFt8XyTXpAYVbxtirCG
8hSA3+bm5sHBQUnJkzdzTHc9mtYKx+229+zFhP6UB7nMijoxuZx4TcnYIDYH
HEnSqzQheoG9dnd3m82m0kTekMlS2Iqi16n4gJYbIbmTTmsy7K5JrJe0Ex+H
d60aJQtgovJhoeYOtjCwdIQZqFMM+7+ONXl5i5hHoFYiYCfja7x7AmcJjdqP
UPCoj8gZPkNSJjZchYo7QGBzP5xWGj1H7XcNlFarBfuIQsGvL1MKREAQz4tr
vI1oqfEy0hhbgx5rGdnwj8EFrya4sOrg5JgLjgDHxQl3RXBnZ2cb4sd+808g
n/+8SUTTQhWcQaRqWVYRY7llFfl8zejBN7so/DbWC0e0flnGPids1yyjG5pb
ltENKynL6CbNP7YsI8YIUiFTWcdA8UNnpLNlH/FeokZwzUZq3aUVdEH17GZG
suQ8D1tWsuxsc1sG0N3Deg2pW1lJt9GqFrp3s5Ju88uyklRW0s12WVZSdkmb
lXSz7r/OSmI5cbZmWcoU+tDriuPG/5mdpNc4y1YmYfVCtlK+F7IsJWNZlrK7
WUoyLs+ylsw1a0n2yrKYWRYzy2JGZ89istxf5jdDLw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{354, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->447609729]
}, Open  ]],

Cell["The expression sizes increase faster than exponentially:", "ExampleText",
 CellID->292058297],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ByteCount", "[", 
    RowBox[{"Eigenvectors", "[", 
     RowBox[{"Array", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Subscript", "[", 
         RowBox[{"a", ",", "##"}], "]"}], "&"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "n"}], "}"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->27442347],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"64", ",", "2432", ",", "56360", ",", "1702536"}], "}"}]], "Output",\

 ImageSize->{184, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->186459761]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->232387054],

Cell["\<\
Construct a 10,000\[Times]10,000 sparse matrix:\
\>", "ExampleText",
 CellID->136272409],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"10", "^", "4"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], "]"}], "\[Rule]", "1."}], ",", 
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"-", "1"}]}], "}"}]}], "]"}], "\[Rule]", "1."}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "n"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->35751496],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"s", ",", 
   RowBox[{"MaxPlotPoints", "\[Rule]", "1000"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"#", "\[Equal]", "0"}], ",", "White", ",", "Black"}], "]"}], 
      "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->295605486],

Cell[GraphicsData["CompressedBitmap", "\<\
eJyV2elPVFcYBvCBAZRF9k0QGVEQZZNNRIFBdpC1WLVL2k6oLbaxWqRtuqZL
umi6xKVNG21ruqQuX/zg/3c6tzxvz/W5z9CUBA93zo8XZGbueZ9zFlKb6+cv
pjYvrKUS0xupy+sX1q4kpi5tpB+KZ8ViscfBZ20s/bVLf7X1GXcu+CL4eJT+
zNq6jAdz/3zEHqX/ydoC/+fR3H8fxQ94GIwhC5cTdtnpi/vB5BOPRn9ONuxf
VDNb6jj0n6TjUudA/046R+pc6LsYd0iVh9lfqWae1Dugfyata++Evk16p9T5
0D+Rzpe6APoHjEVSFWL2e6pZKHUR9E3SuvYu6Oukd0ldDP0d6WKpS6C/IV0i
dSn0NYzlUpVh9irVLJO6HPpL0rp2BfTnpCukroT+jHSl1FXQn5Cukroa+iOM
tVLVYPZDqlkjdS30+6R17d3Q75LeLXUd9Duk66Suh36LdL3Ue6CvkN4jdQP0
m6QbpN4LfYn0XqkboS+SbpQ6Af066YTU+6DXMe6Xqgmzr1LNJqn3Q58nrWsf
gF4jfUDqZugU6WapW6BfJN0i9UHo5zEekqoVs89RzVapD0E/Q1rXPgx9lvRh
qdugnybdJnU79Crpdqk7oJcxdknVidklqtkpdRf0Amld+wj0KdJHpO6GniXd
LXUP9BTGPql6MTtJNXul7oMeJ61r90OfJN0v9VHoJOmjUg9AD5MekPoY9PHQ
GFWDmB2kmoNSW60B0rr2Ceh+0iekHoLuJT0k9TB0N+lhqUeg7XU9KlUSsx1U
Myn1KHQbaV37pPP3Hn48qsegD5Iek3ocupn0uNQT0Hbvn5JqErP7qOak1PZ+
aySta09DN5CelnoGup70jNSzznc4dpeJqjnM1lDNOalPQVeR1rXnoStIz0u9
AF1GekHqRegS0otSLzmfAoJxRSpbCQqp5rLUK9D5pHXtp5xPWfx4VK9C55Je
lfo0dJz0aamDtTQIqWfl7BnUOpdxNp7xe3mVDuqcyfgbPyGdX+f1XyN8bTlX
///sebF0qf9mK1TTtH4+lklbutTPNfcK9qrTr6NF0pYEl6S295TlL/16n6ea
pvV7ifsPy1/6fTpH2hKVvgdwt2J3I31/mSFt6WdWarvXWtbQ98Epqmla32O5
E0q47daGCdK2kui1gfsmywUTUo+Rtk5fr2W2Blt/rdfHUappWq+9SdLWX+t1
fYS0dRhJqblzs154ROoh0tbd6h7HejPrKXXfdJxqmtY9GXeF4Z5Sd5zqN9K9
JPeQ1v8dk9r6anvGdc/LnaZp3U/3kbauS/fq3JdaH6VzQA9pe9fqjMFdrPU8
PVJb3rK7os5CXVTTtM5ZnaSt09AZjjtk6yF0PmwnbV1Bh9TcT9s6r/Os5fBz
znfjWoWvTev83Ur6WbfdvgH36LbLoPcNWki/4Hynr3dFwtcvQet9Dtufedn5
PKBV+Nq03pdpIv2K224/idOC7T7p/aQE6deczxyZ99bewJjIqMLXphul5gRy
2fm1Ve8chq83nM8xelcyfL0JrfcZ60i/7Xzqybz3+h5GvS9aSzVN6z1XzkIf
OJ+korqatO0s671iTk4fQ1dLXUn6U+fzV1Rbl/cFRr1fXk41Teu9eE5jXznf
f0Z1KWk7cdBnCJzdvoYulbqY9LfOJ8Cotp77BkZ9jlJENU3rMxrOhbecT5VR
XUDaTqL02RKnyB+hC6S2c7Y7zmdQrcLXpvX5Wh7pX5xPrFHNyfQutD4XzCH9
m/P5Nqo5x/4BHTrHjJy93nM+A8NEznEfwOiz1v86F368NZf1Nx5cFYw=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->8542946]
}, Open  ]],

Cell["\<\
The eigenvector matrix is a dense matrix, and too large to represent:\
\>", "ExampleText",
 CellID->67798946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemoryConstrained", "[", 
  RowBox[{
   RowBox[{"Eigenvectors", "[", "s", "]"}], ",", 
   RowBox[{"10", "^", "8"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->867977199],

Cell[BoxData[
 RowBox[{
  RowBox[{"Eigenvectors", "::", "\<\"arh\"\>"}], ":", 
  " ", "\<\"Because finding \\!\\(10000\\) out of the \\!\\(10000\\) \
eigenvalues and/or eigenvectors is likely to be faster with dense matrix \
methods, the sparse input matrix will be converted.  If fewer eigenvalues \
and/or eigenvectors would be sufficient, consider restricting this number \
using the second argument to \\!\\(Eigenvectors\\). \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"MessageLink\\\", ButtonFrame->None, \
ButtonData:>{\\\"System`\\\", \\\"Eigenvectors\\\", \\\"arh\\\"}, ButtonNote \
-> \\\"Eigenvectors::arh\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->349042768],

Cell[BoxData["$Aborted"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->908593046]
}, Open  ]],

Cell["\<\
Computing the few eigenvectors corresponding to the largest eigenvalues is \
much easier:\
\>", "ExampleText",
 CellID->440604564],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"Eigenvectors", "[", 
    RowBox[{"s", ",", "2"}], "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->338448105],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.030999999999999917`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->108889981]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->754133778],

Cell["\<\
When eigenvalues are closely grouped, the iterative method for sparse \
matrices may not converge:\
\>", "ExampleText",
 CellID->208560929],

Cell[BoxData[
 RowBox[{
  RowBox[{"s", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x_", ",", "y_"}], "}"}], "/;", 
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{"x", "-", "y"}], "]"}], "\[LessEqual]", "1"}]}], "\[Rule]", 
       
       RowBox[{
        RowBox[{"3.", " ", 
         RowBox[{"Abs", "[", 
          RowBox[{"x", "-", "y"}], "]"}]}], "-", "2."}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1000", ",", "1000"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->589424113],

Cell["The iteration has not converged well after 1000 iterations:", \
"ExampleText",
 CellID->82400519],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Eigenvectors", "[", 
   RowBox[{"s", ",", "3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->362730299],

Cell[BoxData[
 RowBox[{
  RowBox[{"Eigenvectors", "::", "\<\"maxit2\"\>"}], ":", 
  " ", "\<\"Maximum number of iterations, \\!\\(1000\\), has been reached by \
the Arnoldi algorithm without convergence to the specified tolerance, but the \
current best computed value has been returned.  You can use method options \
with Method -> {Arnoldi, opts} to increase the basis size or the maximum \
number of iterations, reduce the tolerance, or use an estimate as a shift, \
any of which may help. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"MessageLink\\\", ButtonFrame->None, ButtonData:>{\\\"System`\
\\\", \\\"Eigenvectors\\\", \\\"maxit2\\\"}, ButtonNote -> \
\\\"Eigenvectors::maxit2\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->517321251],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 92},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->322249990]
}, Open  ]],

Cell["\<\
You can give the algorithm a shift near an expected eigenvalue to speed up \
convergence:\
\>", "ExampleText",
 CellID->519893484],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Eigenvectors", "[", 
   RowBox[{"s", ",", "3", ",", 
    RowBox[{"Method", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Arnoldi\>\"", ",", 
       RowBox[{"\"\<Shift\>\"", "\[Rule]", 
        RowBox[{"-", "4"}]}]}], "}"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->734430664],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 92},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->9218668]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5364],

Cell["The first four eigenvectors of a banded matrix:", "ExampleText",
 CellID->184328414],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "250"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s", "=", 
   RowBox[{"N", "[", 
    RowBox[{"SparseArray", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{"i", "-", "j"}], "]"}], "\[Equal]", "1"}]}], "\[Rule]", 
       RowBox[{"i", "-", "j"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "n"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vecs", "=", 
   RowBox[{"Eigenvectors", "[", 
    RowBox[{"s", ",", "4"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->297918709],

Cell["A plot of the first four eigenvectors:", "ExampleText",
 CellID->380458825],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"MapThread", "[", 
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"c", ",", "v"}], "}"}], ",", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"{", 
         RowBox[{"c", ",", 
          RowBox[{"MapIndexed", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Point", "[", 
              RowBox[{"Join", "[", 
               RowBox[{"#2", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Re", "[", "#1", "]"}], ",", 
                  RowBox[{"Im", "[", "#1", "]"}]}], "}"}]}], "]"}], "]"}], 
             "&"}], ",", "v"}], "]"}]}], "}"}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Red", ",", "Yellow", ",", "Blue", ",", "Green"}], "}"}], ",",
        "vecs"}], "}"}]}], "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"BoxRatios", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->239794904],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 191},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6336147]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10879],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NullSpace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NullSpace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eigenvalues",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eigenvalues"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eigensystem",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eigensystem"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13371]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17554],

Cell[TextData[ButtonBox["Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VectorsAndMatrices"]], "Tutorials",
 CellID->2671],

Cell[TextData[ButtonBox["Eigenvalues and Eigenvectors",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EigenvaluesAndEigenvectors"]], "Tutorials",
 CellID->8476]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Eigenvectors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Eigenvectors"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->34905819],

Cell[TextData[ButtonBox["Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixOperations"]], "MoreAbout",
 CellID->615309650]
}, Open  ]],

Cell["New in 1  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Eigenvectors - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 39, 45.4322124}", "context" -> "System`", 
    "keywords" -> {
     "diagonalization of matrices", "eigenvectors", 
      "generalized eigenvectors", "left eigenvectors", "right eigenvectors", 
      "similarity transformation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Eigenvectors[m] gives a list of the eigenvectors of the square matrix m. \
Eigenvectors[{m, a}] gives the generalized eigenvectors of m with respect to \
a. Eigenvectors[m, k] gives the first k eigenvectors of m. Eigenvectors[{m, \
a}, k] gives the first k generalized eigenvectors.", "synonyms" -> {}, 
    "title" -> "Eigenvectors", "type" -> "Symbol", "uri" -> 
    "ref/Eigenvectors"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9169, 319, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->364862757]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 87908, 2515}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2130, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2753, 79, 49, 1, 70, "ObjectName",
 CellID->3242],
Cell[2805, 82, 2169, 71, 70, "Usage",
 CellID->12314]
}, Open  ]],
Cell[CellGroupData[{
Cell[5011, 158, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5489, 175, 316, 10, 70, "Notes",
 CellID->8300],
Cell[5808, 187, 135, 4, 70, "Notes",
 CellID->22981],
Cell[5946, 193, 63, 1, 70, "Notes",
 CellID->65],
Cell[6012, 196, 656, 21, 70, "Notes",
 CellID->229],
Cell[6671, 219, 151, 4, 70, "Notes",
 CellID->8091],
Cell[6825, 225, 794, 28, 70, "Notes",
 CellID->10953],
Cell[7622, 255, 553, 21, 70, "Notes",
 CellID->14275],
Cell[8178, 278, 620, 22, 70, "Notes",
 CellID->6133],
Cell[8801, 302, 331, 12, 70, "Notes",
 CellID->27116]
}, Closed]],
Cell[CellGroupData[{
Cell[9169, 319, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->364862757],
Cell[CellGroupData[{
Cell[9554, 333, 147, 5, 70, "ExampleSection",
 CellID->31077795],
Cell[9704, 340, 64, 1, 70, "ExampleText",
 CellID->35348174],
Cell[CellGroupData[{
Cell[9793, 345, 257, 9, 28, "Input",
 CellID->247985212],
Cell[10053, 356, 1001, 33, 62, "Output",
 CellID->39368252]
}, Open  ]],
Cell[11069, 392, 125, 3, 70, "ExampleDelimiter",
 CellID->495144951],
Cell[11197, 397, 62, 1, 70, "ExampleText",
 CellID->353977768],
Cell[CellGroupData[{
Cell[11284, 402, 348, 11, 70, "Input",
 CellID->139727108],
Cell[11635, 415, 1366, 50, 81, "Output",
 CellID->490780276]
}, Open  ]],
Cell[13016, 468, 59, 1, 70, "ExampleText",
 CellID->295499056],
Cell[CellGroupData[{
Cell[13100, 473, 97, 3, 70, "Input",
 CellID->387858559],
Cell[13200, 478, 542, 17, 36, "Output",
 CellID->159021310]
}, Open  ]],
Cell[13757, 498, 125, 3, 70, "ExampleDelimiter",
 CellID->302311108],
Cell[13885, 503, 88, 1, 70, "ExampleText",
 CellID->80476748],
Cell[CellGroupData[{
Cell[13998, 508, 387, 13, 70, "Input",
 CellID->130178002],
Cell[14388, 523, 689, 21, 54, "Output",
 CellID->151613796]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15126, 550, 216, 7, 70, "ExampleSection",
 CellID->22769],
Cell[15345, 559, 121, 3, 70, "ExampleText",
 CellID->199072870],
Cell[CellGroupData[{
Cell[15491, 566, 420, 14, 70, "Input",
 CellID->550602945],
Cell[15914, 582, 921, 23, 71, "Output",
 CellID->153177775]
}, Open  ]],
Cell[16850, 608, 123, 3, 70, "ExampleDelimiter",
 CellID->5373117],
Cell[16976, 613, 60, 1, 70, "ExampleText",
 CellID->357731883],
Cell[17039, 616, 411, 14, 70, "Input",
 CellID->303609810],
Cell[17453, 632, 121, 3, 70, "ExampleText",
 CellID->104202900],
Cell[CellGroupData[{
Cell[17599, 639, 178, 6, 70, "Input",
 CellID->154949572],
Cell[17780, 647, 1069, 26, 88, "Output",
 CellID->35361951]
}, Open  ]],
Cell[18864, 676, 73, 1, 70, "ExampleText",
 CellID->346346698],
Cell[CellGroupData[{
Cell[18962, 681, 148, 5, 70, "Input",
 CellID->50325078],
Cell[19113, 688, 252, 8, 39, "Output",
 CellID->349455507]
}, Open  ]],
Cell[19380, 699, 125, 3, 70, "ExampleDelimiter",
 CellID->138025455],
Cell[19508, 704, 180, 5, 70, "ExampleText",
 CellID->22375402],
Cell[CellGroupData[{
Cell[19713, 713, 348, 11, 70, "Input",
 CellID->327248859],
Cell[20064, 726, 390, 13, 36, "Output",
 CellID->53407432]
}, Open  ]],
Cell[20469, 742, 124, 3, 70, "ExampleDelimiter",
 CellID->49710436],
Cell[20596, 747, 76, 1, 70, "ExampleText",
 CellID->490149319],
Cell[CellGroupData[{
Cell[20697, 752, 554, 20, 70, "Input",
 CellID->91203630],
Cell[21254, 774, 805, 23, 54, "Output",
 CellID->145817629]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22108, 803, 239, 7, 70, "ExampleSection",
 CellID->21609],
Cell[CellGroupData[{
Cell[22372, 814, 234, 7, 70, "ExampleSubsection",
 CellID->873108938],
Cell[22609, 823, 66, 1, 70, "ExampleText",
 CellID->10201624],
Cell[CellGroupData[{
Cell[22700, 828, 799, 27, 70, "Input",
 CellID->120078182],
Cell[23502, 857, 782, 17, 70, "Output",
 Evaluatable->False,
 CellID->314232850]
}, Open  ]],
Cell[24299, 877, 68, 1, 70, "ExampleText",
 CellID->262352655],
Cell[CellGroupData[{
Cell[24392, 882, 108, 3, 70, "Input",
 CellID->726678371],
Cell[24503, 887, 545, 18, 36, "Output",
 CellID->594447746]
}, Open  ]],
Cell[25063, 908, 125, 3, 70, "ExampleDelimiter",
 CellID->239691314],
Cell[25191, 913, 64, 1, 70, "ExampleText",
 CellID->135652336],
Cell[25258, 916, 618, 21, 70, "Input",
 CellID->317140975],
Cell[25879, 939, 114, 3, 70, "ExampleText",
 CellID->44080672],
Cell[CellGroupData[{
Cell[26018, 946, 167, 5, 70, "Input",
 CellID->206745217],
Cell[26188, 953, 7327, 124, 70, "Output",
 Evaluatable->False,
 CellID->15357310]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[33576, 1084, 223, 7, 70, "ExampleSection",
 CellID->18987],
Cell[33802, 1093, 161, 6, 70, "ExampleText",
 CellID->539885110],
Cell[33966, 1101, 509, 17, 70, "Input",
 CellID->295106875],
Cell[34478, 1120, 133, 6, 70, "ExampleText",
 CellID->320684602],
Cell[CellGroupData[{
Cell[34636, 1130, 171, 5, 70, "Input",
 CellID->69766063],
Cell[34810, 1137, 688, 25, 51, "Output",
 CellID->113842921]
}, Open  ]],
Cell[35513, 1165, 125, 3, 70, "ExampleDelimiter",
 CellID->203433568],
Cell[35641, 1170, 89, 1, 70, "ExampleText",
 CellID->106348115],
Cell[CellGroupData[{
Cell[35755, 1175, 454, 15, 70, "Input",
 CellID->23305850],
Cell[36212, 1192, 391, 13, 36, "Output",
 CellID->271404879]
}, Open  ]],
Cell[36618, 1208, 98, 1, 70, "ExampleText",
 CellID->350159766],
Cell[CellGroupData[{
Cell[36741, 1213, 211, 7, 70, "Input",
 CellID->60253324],
Cell[36955, 1222, 158, 5, 36, "Output",
 CellID->327460068]
}, Open  ]],
Cell[37128, 1230, 148, 4, 70, "ExampleText",
 CellID->3551629],
Cell[CellGroupData[{
Cell[37301, 1238, 1029, 33, 70, "Input",
 CellID->37685936],
Cell[38333, 1273, 162, 5, 36, "Output",
 CellID->59714594]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38544, 1284, 233, 7, 70, "ExampleSection",
 CellID->18518],
Cell[38780, 1293, 98, 1, 70, "ExampleText",
 CellID->416032189],
Cell[38881, 1296, 475, 16, 70, "Input",
 CellID->72115827],
Cell[39359, 1314, 132, 4, 70, "ExampleText",
 CellID->167140292],
Cell[CellGroupData[{
Cell[39516, 1322, 267, 8, 70, "Input",
 CellID->20720065],
Cell[39786, 1332, 179, 5, 36, "Output",
 CellID->16741997]
}, Open  ]],
Cell[39980, 1340, 151, 6, 70, "ExampleText",
 CellID->410720412],
Cell[40134, 1348, 188, 6, 70, "Input",
 CellID->771802174],
Cell[40325, 1356, 117, 3, 70, "ExampleText",
 CellID->474695885],
Cell[CellGroupData[{
Cell[40467, 1363, 253, 8, 70, "Input",
 CellID->110916326],
Cell[40723, 1373, 180, 5, 36, "Output",
 CellID->507577935]
}, Open  ]],
Cell[40918, 1381, 124, 3, 70, "ExampleDelimiter",
 CellID->76875828],
Cell[41045, 1386, 83, 1, 70, "ExampleText",
 CellID->52270589],
Cell[41131, 1389, 376, 13, 70, "Input",
 CellID->293320954],
Cell[41510, 1404, 161, 6, 70, "ExampleText",
 CellID->14268446],
Cell[CellGroupData[{
Cell[41696, 1414, 330, 11, 70, "Input",
 CellID->984127246],
Cell[42029, 1427, 157, 5, 36, "Output",
 CellID->51283384]
}, Open  ]],
Cell[42201, 1435, 173, 6, 70, "ExampleText",
 CellID->151498562],
Cell[CellGroupData[{
Cell[42399, 1445, 244, 9, 70, "Input",
 CellID->37807961],
Cell[42646, 1456, 175, 5, 36, "Output",
 CellID->523243504]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[42870, 1467, 226, 7, 70, "ExampleSection",
 CellID->14109],
Cell[43099, 1476, 99, 1, 70, "ExampleText",
 CellID->153668477],
Cell[CellGroupData[{
Cell[43223, 1481, 257, 9, 70, "Input",
 CellID->845404531],
Cell[43483, 1492, 510, 19, 36, "Output",
 CellID->473275923]
}, Open  ]],
Cell[CellGroupData[{
Cell[44030, 1516, 107, 3, 70, "Input",
 CellID->71578896],
Cell[44140, 1521, 1720, 32, 70, "Output",
 Evaluatable->False,
 CellID->447609729]
}, Open  ]],
Cell[45875, 1556, 99, 1, 70, "ExampleText",
 CellID->292058297],
Cell[CellGroupData[{
Cell[45999, 1561, 465, 15, 70, "Input",
 CellID->27442347],
Cell[46467, 1578, 240, 8, 36, "Output",
 CellID->186459761]
}, Open  ]],
Cell[46722, 1589, 125, 3, 70, "ExampleDelimiter",
 CellID->232387054],
Cell[46850, 1594, 98, 3, 70, "ExampleText",
 CellID->136272409],
Cell[46951, 1599, 898, 30, 70, "Input",
 CellID->35751496],
Cell[CellGroupData[{
Cell[47874, 1633, 393, 12, 70, "Input",
 CellID->295605486],
Cell[48270, 1647, 2036, 37, 70, "Output",
 Evaluatable->False,
 CellID->8542946]
}, Open  ]],
Cell[50321, 1687, 119, 3, 70, "ExampleText",
 CellID->67798946],
Cell[CellGroupData[{
Cell[50465, 1694, 201, 6, 70, "Input",
 CellID->867977199],
Cell[50669, 1702, 689, 11, 70, "Message",
 CellID->349042768],
Cell[51361, 1715, 165, 5, 36, "Output",
 CellID->908593046]
}, Open  ]],
Cell[51541, 1723, 140, 4, 70, "ExampleText",
 CellID->440604564],
Cell[CellGroupData[{
Cell[51706, 1731, 185, 6, 70, "Input",
 CellID->338448105],
Cell[51894, 1739, 226, 7, 36, "Output",
 CellID->108889981]
}, Open  ]],
Cell[52135, 1749, 125, 3, 70, "ExampleDelimiter",
 CellID->754133778],
Cell[52263, 1754, 149, 4, 70, "ExampleText",
 CellID->208560929],
Cell[52415, 1760, 625, 21, 70, "Input",
 CellID->589424113],
Cell[53043, 1783, 103, 2, 70, "ExampleText",
 CellID->82400519],
Cell[CellGroupData[{
Cell[53171, 1789, 167, 5, 70, "Input",
 CellID->362730299],
Cell[53341, 1796, 759, 12, 70, "Message",
 CellID->517321251],
Cell[54103, 1810, 11049, 185, 70, "Output",
 Evaluatable->False,
 CellID->322249990]
}, Open  ]],
Cell[65167, 1998, 140, 4, 70, "ExampleText",
 CellID->519893484],
Cell[CellGroupData[{
Cell[65332, 2006, 350, 10, 70, "Input",
 CellID->734430664],
Cell[65685, 2018, 8937, 151, 70, "Output",
 Evaluatable->False,
 CellID->9218668]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[74671, 2175, 223, 7, 70, "ExampleSection",
 CellID->5364],
Cell[74897, 2184, 90, 1, 70, "ExampleText",
 CellID->184328414],
Cell[74990, 2187, 726, 24, 70, "Input",
 CellID->297918709],
Cell[75719, 2213, 81, 1, 70, "ExampleText",
 CellID->380458825],
Cell[CellGroupData[{
Cell[75825, 2218, 1117, 33, 70, "Input",
 CellID->239794904],
Cell[76945, 2253, 6538, 111, 70, "Output",
 Evaluatable->False,
 CellID->6336147]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[83544, 2371, 311, 9, 70, "SeeAlsoSection",
 CellID->10879],
Cell[83858, 2382, 710, 26, 70, "SeeAlso",
 CellID->13371]
}, Open  ]],
Cell[CellGroupData[{
Cell[84605, 2413, 314, 9, 70, "TutorialsSection",
 CellID->17554],
Cell[84922, 2424, 148, 3, 70, "Tutorials",
 CellID->2671],
Cell[85073, 2429, 164, 3, 70, "Tutorials",
 CellID->8476]
}, Open  ]],
Cell[CellGroupData[{
Cell[85274, 2437, 305, 8, 70, "RelatedLinksSection"],
Cell[85582, 2447, 369, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[85988, 2464, 318, 9, 70, "MoreAboutSection",
 CellID->34905819],
Cell[86309, 2475, 145, 3, 70, "MoreAbout",
 CellID->615309650]
}, Open  ]],
Cell[86469, 2481, 50, 0, 70, "History"],
Cell[86522, 2483, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

