(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    289142,       7568]
NotebookOptionsPosition[    259504,       6662]
NotebookOutlinePosition[    266960,       6789]
CellTagsIndexPosition[    266873,       6784]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"IsotopeData" :> 
          Documentation`HelpLookup["paclet:ref/IsotopeData"], "ChemicalData" :> 
          Documentation`HelpLookup["paclet:ref/ChemicalData"], "ParticleData" :> 
          Documentation`HelpLookup["paclet:ref/ParticleData"], "LatticeData" :> 
          Documentation`HelpLookup["paclet:ref/LatticeData"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"IsotopeData\"\>", 
       2->"\<\"ChemicalData\"\>", 3->"\<\"ParticleData\"\>", 
       4->"\<\"LatticeData\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integrated Data Sources" :> 
          Documentation`HelpLookup["paclet:guide/DataCollections"], 
          "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Integrated Data Sources\"\>", 
       2->"\<\"New in 6.0: Data Handling & Data Sources\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ElementData", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ElementData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ElementData"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"property\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the value of the specified property for the \
chemical element ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\""], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ElementData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ElementData"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", "\"\<\!\(\*
StyleBox[\"property\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the specified property for the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " chemical element."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Chemical elements can be specified by their full names, standard \
abbreviations or atomic numbers.\
\>", "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ElementData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ElementData"], "[", "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " gives a list of all standard chemical elements."
}], "Notes",
 CellID->485978669],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ElementData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ElementData"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " gives the full name of the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " chemical element."
}], "Notes",
 CellID->74780324],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ElementData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ElementData"], "[", "\"\<Properties\>\"", "]"}]], 
  "InlineFormula"],
 " gives a list of all properties available for chemical elements."
}], "Notes",
 CellID->54231339],

Cell[TextData[{
 "Properties that do not apply or are not known in a particular case are \
indicated by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Missing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Missing"], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->48425469],

Cell[TextData[{
 "Except where noted, all relevant quantities are given in SI (MKS) units. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ElementData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ElementData"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"prop\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " gives the numerical value; ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ElementData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ElementData"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"prop\", \"TI\"]\)\>\"", ",", "\"\<Units\>\""}], "]"}]], 
  "InlineFormula"],
 " gives the units used."
}], "Notes",
 CellID->193117324],

Cell["\<\
Numerical values that are known only to a certain precision are typically \
tagged with their precision, and given in arbitrary-precision form.\
\>", "Notes",
 CellID->286491208],

Cell["Basic element properties include:", "Notes",
 CellID->156536174],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<AtomicNumber\>\"", Cell[TextData[{
     "atomic number ",
     Cell[BoxData[
      FormBox["Z", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<AtomicWeight\>\"", Cell[
    "average atomic weight in atomic mass units", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->120063746],

Cell["\<\
If no other temperature or pressure is specified, all macroscopic properties \
are given for standard temperature and pressure. When applicable, properties \
are for the most stable form of the element at standard temperature and \
pressure.\
\>", "Notes",
 CellID->523829331],

Cell["Material properties include:", "Notes",
 CellID->6006833],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<BrinellHardness\>\"", Cell[
    "Brinell indentation hardness ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<BulkModulus\>\"", Cell[TextData[{
     "bulk modulus (incompressibility) ",
     Cell[BoxData[
      FormBox["K", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Density\>\"", Cell[
    "density at standard temperature and pressure", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LiquidDensity\>\"", Cell[
    "liquid density at melting point", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MohsHardness\>\"", Cell[
    "Mohs scratch resistance", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MolarVolume\>\"", Cell[
    "molar volume", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PoissonRatio\>\"", Cell[TextData[{
     "Poisson ratio ",
     Cell[BoxData[
      FormBox["\[Nu]", TraditionalForm]], "InlineMath"],
     " of solid"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ShearModulus\>\"", Cell[TextData[{
     "shear modulus ",
     Cell[BoxData[
      FormBox["G", TraditionalForm]], "InlineMath"],
     " of solid "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SoundSpeed\>\"", Cell[
    "speed of sound", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ThermalConductivity\>\"", Cell[
    TextData[{
     "thermal conductivity ",
     Cell[BoxData[
      FormBox["\[Kappa]", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ThermalExpansion\>\"", Cell[
    TextData[{
     "linear thermal expansion coefficient ",
     Cell[BoxData[
      FormBox["\[Alpha]", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<VickersHardness\>\"", Cell[
    "Vickers indentation hardness ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<YoungModulus\>\"", Cell[TextData[{
     "Young's modulus ",
     Cell[BoxData[
      FormBox["E", TraditionalForm]], "InlineMath"],
     " of solid"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, {
     None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True}}}},
 CellID->867546879],

Cell["Thermodynamic properties include:", "Notes",
 CellID->219479909],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<AbsoluteBoilingPoint\>\"", Cell[
    "boiling temperature in kelvin", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<AbsoluteMeltingPoint\>\"", Cell[
    "melting temperature in kelvin", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<AdiabaticIndex\>\"", Cell[TextData[{
     "gas phase adiabatic index ",
     Cell[BoxData[
      FormBox["\[Gamma]", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<BoilingPoint\>\"", Cell[TextData[{
     Cell[BoxData[Cell["", "TableText"]]],
     "boiling temperature in Celsius"
    }], "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<CriticalPressure\>\"", Cell[
    "pressure at liquid-gas critical point", "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<CriticalTemperature\>\"", Cell[
    "temperature at liquid-gas critical point", "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<CuriePoint\>\"", Cell[
    "Curie temperature at ferromagnet-paramagnet transition", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FusionHeat\>\"", Cell[
    "latent heat for solid-liquid transition", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MeltingPoint\>\"", Cell[
    "melting temperature in Celsius", "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<NeelPoint\>\"", Cell["\<\
N\[EAcute]el temperature at antiferromagnet-paramagnet transition\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Phase\>\"", Cell[TextData[{
     "naturally occurring phase (e.g. ",
     Cell[BoxData["\"\<Solid\>\""], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SpecificHeat\>\"", Cell[TextData[{
     "specific heat capacity ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["c", "p"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SuperconductingPoint\>\"", Cell[
    "superconducting transition temperature in kelvin", "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<VaporizationHeat\>\"", Cell[
    "latent heat for liquid-gas transition", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True}}}},
 CellID->83366517],

Cell["Electromagnetic and optical properties include:", "Notes",
 CellID->375384097],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Color\>\"", Cell[
    "basic material color", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ElectricalConductivity\>\"", Cell[
    TextData[{
     "electrical conductivity ",
     Cell[BoxData[
      FormBox["\[Sigma]", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ElectricalType\>\"", Cell[TextData[{
     "electrical type (e.g. ",
     Cell[BoxData["\"\<Insulator\>\""], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MagneticType\>\"", Cell[TextData[{
     "magnetic response type (e.g. ",
     Cell[BoxData["\"\<Paramagnetic\>\""], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<MassMagneticSusceptibility\>\"", Cell[
    TextData[{
     "mass magnetic susceptibility ",
     Cell[BoxData[
      FormBox["\[Chi]", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MolarMagneticSusceptibility\>\"", 
    Cell[TextData[{
     "molar magnetic susceptibility ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["\[Chi]", "m"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RefractiveIndex\>\"", Cell[
    "refractive index for visible light", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Resistivity\>\"", Cell[TextData[{
     "electrical resistivity ",
     Cell[BoxData[
      FormBox["\[Rho]", TraditionalForm]], "InlineMath"],
     " of solid"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VolumeMagneticSusceptibility\>\"", 
    Cell[TextData[{
     "volume magnetic susceptibility ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["\[Chi]", "v"], TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True, True}}}},
 CellID->504113991],

Cell["Abundance properties include (specified by mass-fraction):", "Notes",
 CellID->241081359],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<CrustAbundance\>\"", Cell[
    "Earth's crust abundance", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<HumanAbundance\>\"", Cell[
    "typical human body abundance", "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<MeteoriteAbundance\>\"", Cell[
    "observed carbonaceous meteorite abundance", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<OceanAbundance\>\"", Cell[
    "ocean abundance", "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<SolarAbundance\>\"", Cell[
    "abundance in the sun", "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<UniverseAbundance\>\"", Cell[
    "observed universe abundance", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->193211718],

Cell["Periodic table properties include:", "Notes",
 CellID->3666451],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Block\>\"", Cell[
    "label of outermost occupied electron subshell", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Group\>\"", Cell[
    "column in periodic table", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Period\>\"", Cell[
    "row in periodic table (number of electron shells)", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->133619875],

Cell["Basic chemical properties include:", "Notes",
 CellID->117120805],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<AllotropicMultiplicities\>\"", Cell[
    "numbers of atoms in allotropic molecules", "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<CommonCompoundNames\>\"", Cell[
    "names of common compounds ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ElectronAffinity\>\"", Cell[
    "electron affinity", "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<Electronegativity\>\"", Cell[
    "Pauling electronegativity", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GasAtomicMultiplicities\>\"", Cell[
    "number of atoms in gas-phase molecules", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Valence\>\"", Cell[
    "number of chemical bonds typically formed", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->175035396],

Cell["\<\
Crystallographic properties for the most stable solid phase include:\
\>", "Notes",
 CellID->12844614],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<CrystalStructure\>\"", Cell[
    "basic crystal lattice structure", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LatticeAngles\>\"", Cell[TextData[{
     "angles between crystallographic axes ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]"}], "}"}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<LatticeConstants\>\"", Cell[TextData[{
     "crystal lattice constants ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c"}], "}"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<SpaceGroupNumber\>\"", Cell[
    "International Tables space group number", "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<SpaceGroupName\>\"", Cell[
    "space group symbol", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->13778237],

Cell["Atomic properties include:", "Notes",
 CellID->170336351],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<AtomicRadius\>\"", Cell[
    "calculated distance from nucleus of outermost electron", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CovalentRadius\>\"", Cell[
    "half-distance between nuclei in a bonded pair of atoms", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ElectronConfiguration\>\"", Cell[
    "occupation numbers for each electron subshell", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ElectronConfigurationString\>\"", 
    Cell["electron configuration written in standard notation", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ElectronShellConfiguration\>\"", 
    Cell["occupation numbers for each complete energy shell", "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<IonizationEnergies\>\"", Cell[
    "list of ionization energies for each electron", "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<QuantumNumbers\>\"", Cell[
    "ground state angular momentum quantum numbers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VanDerWaalsRadius\>\"", Cell[
    "hard sphere interatomic interaction range", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->88400451],

Cell["Nuclear properties include:", "Notes",
 CellID->152932340],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<DecayMode\>\"", Cell[
    "dominant decay mode for longest-lived isotope", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<HalfLife\>\"", Cell[
    "half-life in seconds for longest-lived isotope", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<IsotopeAbundances\>\"", Cell[
    "list of mass numbers and abundances of stable isotopes", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<KnownIsotopes\>\"", Cell[
    "atomic mass numbers of all known isotopes", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Lifetime\>\"", Cell[
    "exponential lifetime in seconds for longest-lived isotope", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NeutronCrossSection\>\"", Cell[
    "thermal neutron cross section in barns", "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<NeutronMassAbsorption\>\"", Cell[
    "thermal neutron mass absorption coefficient", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Radioactive\>\"", Cell[
    "whether the element is radioactive", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<StableIsotopes\>\"", Cell[
    "atomic mass numbers of stable isotopes", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True, True}}}},
 CellID->86798297],

Cell["Names-related properties include:", "Notes",
 CellID->73881988],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Abbreviation\>\"", Cell[TextData[{
     "standard element abbreviation (e.g. ",
     Cell[BoxData["\"\<Na\>\""], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Allotropes\>\"", Cell[TextData[{
     "names of allotropes (e.g. ",
     Cell[BoxData["\"\<Graphite\>\""], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<AlternateNames\>\"", Cell[TextData[{
     "alternate names (e.g. ",
     Cell[BoxData["\"\<Aluminium\>\""], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CASNumber\>\"", Cell[
    "Chemical Abstract Service registry number", "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<IconColor\>\"", Cell[TextData[{
     "icon color for ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " molecular graphics"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Name\>\"", Cell[TextData[{
     "English name (e.g. ",
     Cell[BoxData["\"\<hydrogen\>\""], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<StandardName\>\"", Cell[TextData[{
     "standard ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " name (e.g. ",
     Cell[BoxData["\"\<Hydrogen\>\""], "InlineFormula"],
     ")"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->166563264],

Cell["Historical and commercial properties include:", "Notes",
 CellID->72025121],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<DiscoveryCountries\>\"", Cell[
    "countries where element was discovered", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DiscoveryYear\>\"", Cell[
    "year element was discovered", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->370270706],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ElementData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ElementData"], "[", "\"\<\!\(\*
StyleBox[\"class\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " gives a list of elements in the specified class. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ElementData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ElementData"], "[", 
   RowBox[{
    StyleBox["name", "TI"], ",", "\"\<\!\(\*
StyleBox[\"class\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " depending on whether the element corresponding to ",
 Cell[BoxData[
  StyleBox["name", "TI"]], "InlineFormula"],
 " is in the specified class."
}], "Notes",
 CellID->482514198],

Cell["Classes of elements include:", "Notes",
 CellID->91622357],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Actinide\>\"", Cell[
    "actinide", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<AlkaliMetal\>\"", Cell[
    "alkali metal", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Gas\>\"", Cell[
    "gas at standard temperature and pressure", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Lanthanide\>\"", Cell[
    "lanthanide", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Liquid\>\"", Cell[
    "liquid at standard temperature and pressure", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Ferromagnetic\>\"", Cell[
    "ferromagnetic at standard temperature and pressure", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Metal\>\"", Cell[
    "metallic", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Natural\>\"", Cell[
    "naturally occurring", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NobleGas\>\"", Cell[
    "noble gas", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Radioactive\>\"", Cell[
    "radioactive in all forms", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Solid\>\"", Cell[
    "solid at standard temperature and pressure", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Stable\>\"", Cell[
    "stable with respect to radioactive decay", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Synthetic\>\"", Cell[
    "occurring only when synthesized", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, {
     None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True}}}},
 CellID->1173142],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ElementData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ElementData"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"property\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"ann\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " gives various annotations associated with a property. Typical annotations \
include:"
}], "Notes",
 CellID->276644756],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Description\>\"", Cell[TextData[{
     Cell[BoxData[Cell["", "TableText"]]],
     "short textual description of the property"
    }], "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<Interval\>\"", Cell[TextData[{
     "uncertainty range given by ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Interval",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Interval"], "[", 
       StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LongDescription\>\"", Cell[
    "longer textual description of the property ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Note\>\"", Cell[
    "additional information about the property", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Units\>\"", Cell[
    "units in which the property is given", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnitsName\>\"", Cell[
    "English name for the units used", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnitsNotation\>\"", Cell[
    "notation for the units used", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnitsStandardName\>\"", Cell[
    TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " standard name for the units used"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->524183967]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->796003110],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->475039054],

Cell["Find the atomic weight of carbon:", "ExampleText",
 CellID->860716456],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\"\<Carbon\>\"", ",", "\"\<AtomicWeight\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->219384717],

Cell[BoxData["12.0107`5.999999999999999"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->240653761]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->187730611],

Cell["Find the thermal conductivity of tungsten (in SI units):", "ExampleText",
 CellID->152549474],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\"\<Tungsten\>\"", ",", "\"\<ThermalConductivity\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->727640411],

Cell[BoxData["170.`3.0000000000000018"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->956053826]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->585202192],

Cell["\<\
Plot the melting points (in Celsius) of elements as a function of atomic \
number:\
\>", "ExampleText",
 CellID->684057732],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ElementData", "[", 
     RowBox[{"z", ",", "\"\<MeltingPoint\>\""}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "118"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->239680026],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw1k11Ik1EYx0dXw4tYsYsF9onEiIjVyqxcPTprm+vDfQRZu4gsA5W2NChW
xCANi8rMPtQ+mBpYCTGCwItdvNStXiddJXQR1EVUdmXQe3h+58D483v/53/O
3ud53o1n8ulzKzweT9b9GdXllcWi/21suFOUfaq1D2G/an0ZDqhWZ+BaCZsV
7XKUN8j4mLsS3fAm9fss18lV97rF1Xl4s7hU9F84wXlB1bZ+eIt8XArmhiYt
b1UNPIa36X1rDsEhidR8mirM5+DtqqfbuW+H7n99Hg7LRROoHGP/Tu6/De9S
9Y/C9aq+cXi36sJzuEF1zvIe1Ssj8F5Vrz1vn2ruCdyoWrXvFxFTruKv+/B+
5YYifEDr8yECi3Salb6rXBLVwVv4Tarlbvwm7U94LfVolh+p2XUDMx3KpWaJ
mwGZjpJH44Pk4QX7/1tUl5/hwyen8A+qXn+JD3+280UfGyfx4coL/Jj2L0n9
SjEx7Y6svIcfl4Hv7gusuoQf1/cb6cBPyF9Trn89+Akx8Zr3N/BbxXWXgoFr
+K0yP+euHjtPST3v9ynqk9T5KdA3z2HV2ZvkYecO/hHVn7Z+cIB+eY6qfhvC
h0PD+MypwzyU4Irtb5tqP9+vwKFH7Id9zJcDe23/UqpnYYHrbL3hUe5z4OUx
8mnV3gny8INp8nD1DXn46yvyGdV37Be4hfkpZbT+E0/JZ2S9aXjZfh9ZnYeu
qKP5LM/7yGfFtDd3mflwstrfPwX2Hed5nvvhL73krZ9y/gOV+/iW
     "]], 
    LineBox[{{88., 700.}, {89., 1050.}, {90., 1750.}, {91., 1572.}, {92., 
     1135.}, {93., 644.}, {94., 640.}, {95., 1176.}, {96., 1345.}, {97., 
     1050.}, {98., 900.}, {99., 860.}, {100., 1527.}, {101., 827.}, {102., 
     827.}, {103., 1627.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  ImageSize->{272., Automatic},
  PlotRange->{{0., 103.}, {-259.14, 3550.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{276, 160},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->924006728]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(15)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->649452527],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Names and Classes",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->223414956],

Cell["Obtain a list of all the elements sorted by atomic number:", \
"ExampleText",
 CellID->303780252],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->174295882],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Hydrogen\"\>", ",", "\<\"Helium\"\>", ",", "\<\"Lithium\"\>", 
   ",", "\<\"Beryllium\"\>", ",", "\<\"Boron\"\>", ",", "\<\"Carbon\"\>", 
   ",", "\<\"Nitrogen\"\>", ",", "\<\"Oxygen\"\>", ",", "\<\"Fluorine\"\>", 
   ",", "\<\"Neon\"\>", ",", "\<\"Sodium\"\>", ",", "\<\"Magnesium\"\>", 
   ",", "\<\"Aluminum\"\>", ",", "\<\"Silicon\"\>", ",", "\<\"Phosphorus\"\>",
    ",", "\<\"Sulfur\"\>", ",", "\<\"Chlorine\"\>", ",", "\<\"Argon\"\>", 
   ",", "\<\"Potassium\"\>", ",", "\<\"Calcium\"\>", ",", "\<\"Scandium\"\>", 
   ",", "\<\"Titanium\"\>", ",", "\<\"Vanadium\"\>", ",", "\<\"Chromium\"\>", 
   ",", "\<\"Manganese\"\>", ",", "\<\"Iron\"\>", ",", "\<\"Cobalt\"\>", 
   ",", "\<\"Nickel\"\>", ",", "\<\"Copper\"\>", ",", "\<\"Zinc\"\>", 
   ",", "\<\"Gallium\"\>", ",", "\<\"Germanium\"\>", ",", "\<\"Arsenic\"\>", 
   ",", "\<\"Selenium\"\>", ",", "\<\"Bromine\"\>", ",", "\<\"Krypton\"\>", 
   ",", "\<\"Rubidium\"\>", ",", "\<\"Strontium\"\>", ",", "\<\"Yttrium\"\>", 
   ",", "\<\"Zirconium\"\>", ",", "\<\"Niobium\"\>", 
   ",", "\<\"Molybdenum\"\>", ",", "\<\"Technetium\"\>", 
   ",", "\<\"Ruthenium\"\>", ",", "\<\"Rhodium\"\>", ",", "\<\"Palladium\"\>",
    ",", "\<\"Silver\"\>", ",", "\<\"Cadmium\"\>", ",", "\<\"Indium\"\>", 
   ",", "\<\"Tin\"\>", ",", "\<\"Antimony\"\>", ",", "\<\"Tellurium\"\>", 
   ",", "\<\"Iodine\"\>", ",", "\<\"Xenon\"\>", ",", "\<\"Cesium\"\>", 
   ",", "\<\"Barium\"\>", ",", "\<\"Lanthanum\"\>", ",", "\<\"Cerium\"\>", 
   ",", "\<\"Praseodymium\"\>", ",", "\<\"Neodymium\"\>", 
   ",", "\<\"Promethium\"\>", ",", "\<\"Samarium\"\>", 
   ",", "\<\"Europium\"\>", ",", "\<\"Gadolinium\"\>", ",", "\<\"Terbium\"\>",
    ",", "\<\"Dysprosium\"\>", ",", "\<\"Holmium\"\>", ",", "\<\"Erbium\"\>", 
   ",", "\<\"Thulium\"\>", ",", "\<\"Ytterbium\"\>", ",", "\<\"Lutetium\"\>", 
   ",", "\<\"Hafnium\"\>", ",", "\<\"Tantalum\"\>", ",", "\<\"Tungsten\"\>", 
   ",", "\<\"Rhenium\"\>", ",", "\<\"Osmium\"\>", ",", "\<\"Iridium\"\>", 
   ",", "\<\"Platinum\"\>", ",", "\<\"Gold\"\>", ",", "\<\"Mercury\"\>", 
   ",", "\<\"Thallium\"\>", ",", "\<\"Lead\"\>", ",", "\<\"Bismuth\"\>", 
   ",", "\<\"Polonium\"\>", ",", "\<\"Astatine\"\>", ",", "\<\"Radon\"\>", 
   ",", "\<\"Francium\"\>", ",", "\<\"Radium\"\>", ",", "\<\"Actinium\"\>", 
   ",", "\<\"Thorium\"\>", ",", "\<\"Protactinium\"\>", 
   ",", "\<\"Uranium\"\>", ",", "\<\"Neptunium\"\>", ",", "\<\"Plutonium\"\>",
    ",", "\<\"Americium\"\>", ",", "\<\"Curium\"\>", ",", "\<\"Berkelium\"\>",
    ",", "\<\"Californium\"\>", ",", "\<\"Einsteinium\"\>", 
   ",", "\<\"Fermium\"\>", ",", "\<\"Mendelevium\"\>", 
   ",", "\<\"Nobelium\"\>", ",", "\<\"Lawrencium\"\>", 
   ",", "\<\"Rutherfordium\"\>", ",", "\<\"Dubnium\"\>", 
   ",", "\<\"Seaborgium\"\>", ",", "\<\"Bohrium\"\>", ",", "\<\"Hassium\"\>", 
   ",", "\<\"Meitnerium\"\>", ",", "\<\"Darmstadtium\"\>", 
   ",", "\<\"Roentgenium\"\>", ",", "\<\"Ununbium\"\>", 
   ",", "\<\"Ununtrium\"\>", ",", "\<\"Ununquadium\"\>", 
   ",", "\<\"Ununpentium\"\>", ",", "\<\"Ununhexium\"\>", 
   ",", "\<\"Ununseptium\"\>", ",", "\<\"Ununoctium\"\>"}], "}"}]], "Output",
 ImageSize->{563, 254},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1326826039]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->49007095],

Cell[BoxData["118"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->495047025]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->92157315],

Cell["Find the English name of an element:", "ExampleText",
 CellID->738578064],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\"\<Tungsten\>\"", ",", "\"\<Name\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->221172202],

Cell[BoxData["\<\"tungsten\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->903700697]
}, Open  ]],

Cell["A list of alternate names can also be found:", "ExampleText",
 CellID->629456667],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\"\<Tungsten\>\"", ",", "\"\<AlternateNames\>\""}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->33052035],

Cell[BoxData[
 RowBox[{"{", "\<\"wolfram\"\>", "}"}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1493262895]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->341649908],

Cell[TextData[{
 "An element can be specified by its standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " name, atomic number, or abbreviation:"
}], "ExampleText",
 CellID->192339],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\"\<Gold\>\"", ",", "\"\<AtomicNumber\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->374014864],

Cell[BoxData["79"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1775577423]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"79", ",", "\"\<Abbreviation\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7393140],

Cell[BoxData["\<\"Au\"\>"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->696989649]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\"\<Au\>\"", ",", "\"\<StandardName\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->188296305],

Cell[BoxData["\<\"Gold\"\>"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1929220005]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->612011445],

Cell["Additional names acceptable as input can be found:", "ExampleText",
 CellID->129146030],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\"\<Tungsten\>\"", ",", "\"\<AlternateStandardNames\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->952696506],

Cell[BoxData[
 RowBox[{"{", "\<\"Wolfram\"\>", "}"}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1692521629]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\"\<Wolfram\>\"", ",", "\"\<StandardName\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->149645494],

Cell[BoxData["\<\"Tungsten\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->642630441]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->593810369],

Cell["Find the list of element classes:", "ExampleText",
 CellID->268927234],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", "\"\<Classes\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28830905],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Actinide\"\>", ",", "\<\"AlkaliMetal\"\>", 
   ",", "\<\"AlkalineEarthMetal\"\>", ",", "\<\"Antiferromagnetic\"\>", 
   ",", "\<\"Conductor\"\>", ",", "\<\"Diamagnetic\"\>", 
   ",", "\<\"Ferromagnetic\"\>", ",", "\<\"Gas\"\>", ",", "\<\"Halogen\"\>", 
   ",", "\<\"Insulator\"\>", ",", "\<\"Lanthanide\"\>", ",", "\<\"Liquid\"\>",
    ",", "\<\"Metal\"\>", ",", "\<\"Natural\"\>", ",", "\<\"NobleGas\"\>", 
   ",", "\<\"Paramagnetic\"\>", ",", "\<\"Radioactive\"\>", 
   ",", "\<\"Semiconductor\"\>", ",", "\<\"Solid\"\>", ",", "\<\"Stable\"\>", 
   ",", "\<\"Synthetic\"\>", ",", "\<\"TransitionMetal\"\>"}], 
  "}"}]], "Output",
 ImageSize->{487, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->994561124]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16764254],

Cell["Find the list of elements belonging to a class:", "ExampleText",
 CellID->53277388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", "\"\<Gas\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->795584317],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Hydrogen\"\>", ",", "\<\"Helium\"\>", ",", "\<\"Nitrogen\"\>", 
   ",", "\<\"Oxygen\"\>", ",", "\<\"Fluorine\"\>", ",", "\<\"Neon\"\>", 
   ",", "\<\"Chlorine\"\>", ",", "\<\"Argon\"\>", ",", "\<\"Krypton\"\>", 
   ",", "\<\"Xenon\"\>", ",", "\<\"Radon\"\>"}], "}"}]], "Output",
 ImageSize->{380, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1723586467]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", "\"\<Radioactive\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23186614],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Technetium\"\>", ",", "\<\"Promethium\"\>", 
   ",", "\<\"Polonium\"\>", ",", "\<\"Astatine\"\>", ",", "\<\"Radon\"\>", 
   ",", "\<\"Francium\"\>", ",", "\<\"Radium\"\>", ",", "\<\"Actinium\"\>", 
   ",", "\<\"Protactinium\"\>", ",", "\<\"Thorium\"\>", 
   ",", "\<\"Neptunium\"\>", ",", "\<\"Uranium\"\>", ",", "\<\"Americium\"\>",
    ",", "\<\"Plutonium\"\>", ",", "\<\"Curium\"\>", ",", "\<\"Berkelium\"\>",
    ",", "\<\"Californium\"\>", ",", "\<\"Einsteinium\"\>", 
   ",", "\<\"Fermium\"\>", ",", "\<\"Mendelevium\"\>", 
   ",", "\<\"Nobelium\"\>", ",", "\<\"Rutherfordium\"\>", 
   ",", "\<\"Lawrencium\"\>", ",", "\<\"Dubnium\"\>", ",", "\<\"Bohrium\"\>", 
   ",", "\<\"Seaborgium\"\>", ",", "\<\"Meitnerium\"\>", 
   ",", "\<\"Roentgenium\"\>", ",", "\<\"Hassium\"\>", 
   ",", "\<\"Darmstadtium\"\>", ",", "\<\"Ununtrium\"\>", 
   ",", "\<\"Ununbium\"\>", ",", "\<\"Ununpentium\"\>", 
   ",", "\<\"Ununquadium\"\>", ",", "\<\"Ununhexium\"\>", 
   ",", "\<\"Ununoctium\"\>"}], "}"}]], "Output",
 ImageSize->{487, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->910836486]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->427853053],

Cell["Test whether an element belongs to a class:", "ExampleText",
 CellID->226300656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\"\<Na\>\"", ",", "\"\<Halogen\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16562659],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1165384386]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties and Annotations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1961895733],

Cell["Get a list of properties for a particular element:", "ExampleText",
 CellID->218429381],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{
   RowBox[{"ElementData", "[", 
    RowBox[{"\"\<Helium\>\"", ",", "\"\<Properties\>\""}], "]"}], ",", "4"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->180587304],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"\<\"Abbreviation\"\>", ",", "\<\"AbsoluteBoilingPoint\"\>", 
    ",", "\<\"AbsoluteMeltingPoint\"\>", ",", "\<\"AdiabaticIndex\"\>", 
    ",", "\<\"AllotropeNames\"\>", ",", 
    RowBox[{"\[LeftSkeleton]", "76", "\[RightSkeleton]"}], 
    ",", "\<\"VanDerWaalsRadius\"\>", ",", "\<\"VaporizationHeat\"\>", 
    ",", "\<\"VickersHardness\"\>", 
    ",", "\<\"VolumeMagneticSusceptibility\"\>", 
    ",", "\<\"YoungModulus\"\>"}], "}"}],
  Short[#, 4]& ]], "Output",
 ImageSize->{514, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->1564514862]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->228229632],

Cell["Get a short textual description of a property:", "ExampleText",
 CellID->1347723],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{
  "\"\<Ag\>\"", ",", "\"\<ElectronConfiguration\>\"", ",", 
   "\"\<Description\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->44910077],

Cell[BoxData["\<\"electron configuration\"\>"], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1011511766]
}, Open  ]],

Cell["Get a longer textual description:", "ExampleText",
 CellID->1113244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{
  "\"\<Ag\>\"", ",", "\"\<ElectronConfiguration\>\"", ",", 
   "\"\<LongDescription\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4392297],

Cell[BoxData["\<\"occupation numbers for each electron subshell\"\>"], \
"Output",
 ImageSize->{319, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->997701510]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->201659810],

Cell["Find the units in which a property value is given:", "ExampleText",
 CellID->112134317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\"\<Carbon\>\"", ",", "\"\<Density\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1229972329],

Cell[BoxData["2260.`3.9999999999999996"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->816962794]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\"\<C\>\"", ",", "\"\<Density\>\"", ",", "\"\<Units\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1225569552],

Cell[BoxData["\<\"KilogramsPerCubicMeter\"\>"], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1830723487]
}, Open  ]],

Cell["Get units in proper textual form:", "ExampleText",
 CellID->892569970],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\"\<C\>\"", ",", "\"\<Density\>\"", ",", "\"\<UnitsName\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1250211495],

Cell[BoxData["\<\"kilograms per cubic meter\"\>"], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1971435440]
}, Open  ]],

Cell["Get units as notation:", "ExampleText",
 CellID->1797178791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\"\<C\>\"", ",", "\"\<Density\>\"", ",", "\"\<UnitsNotation\>\""}],
   "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->826445282],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytUk0PgjAM7dYhkpgQLsaLSvgxevJHLMQEDkYD/H9s9wE4Fk80WV/79vo2
wh56aJ4vPbS1Lu+d/jRt3Ze3d0cUCgCoaOUnoHqkyqxqHAkzykjt0XQHzgnv
+qAaCoOSS+UoE0iNcgg4TYGklFK7s+LEwuyH0VNUxMWrpgypRbUk1WZ+Njbw
i3/zctqLsuCcmBvOJLpWwszHbofwO7d2yoOJvXPF6W8XgYLfCj8mwWhUl0Bh
2etKd17o+GLyzzSIL7XWRl0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{34, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->32657171]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->36013750],

Cell[TextData[{
 "Uncertainty is represented using ",
 Cell[BoxData[
  ButtonBox["Interval",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Interval"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->314844981],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\"\<Oxygen\>\"", ",", "\"\<AtomicWeight\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->493396966],

Cell[BoxData["15.9994`5.999999999999999"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->525381281]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{
  "\"\<Oxygen\>\"", ",", "\"\<AtomicWeight\>\"", ",", "\"\<Interval\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->431132459],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
   "15.99903896484375`5.999998343201677", ",", 
    "15.99976103515625`6.000001656729876"}], "}"}], "]"}]], "Output",
 ImageSize->{198, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1777916950]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->495260950],

Cell["Find additional notes about properties:", "ExampleText",
 CellID->273597932],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\"\<C\>\"", ",", "\"\<ElectricalType\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->502847698],

Cell[BoxData["\<\"Conductor\"\>"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1362714292]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\"\<C\>\"", ",", "\"\<ElectricalType\>\"", ",", "\"\<Note\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->417695890],

Cell[BoxData["\<\"Value given for graphite. Diamond is an insulator.\"\>"], \
"Output",
 ImageSize->{354, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->226010389]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Property Values",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->29302194],

Cell[TextData[{
 "A property value can be any valid ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression:"
}], "ExampleText",
 CellID->553589695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\"\<Chlorine\>\"", ",", "\"\<BoilingPoint\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->529027222],

Cell[BoxData[
 RowBox[{"-", "34.04`3.9999999999999996"}]], "Output",
 ImageSize->{47, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->287563654]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\"\<Pb\>\"", ",", "\"\<Phase\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->609521478],

Cell[BoxData["\<\"Solid\"\>"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->289562986]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\"\<Oxygen\>\"", ",", "\"\<KnownIsotopes\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->414708089],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "12", ",", "13", ",", "14", ",", "15", ",", "16", ",", "17", ",", "18", ",",
    "19", ",", "20", ",", "21", ",", "22", ",", "23", ",", "24", ",", "25", 
   ",", "26", ",", "27", ",", "28"}], "}"}]], "Output",
 ImageSize->{435, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->710913505]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->107469361],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Precision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Precision"]], "InlineFormula"],
 " to find out the number of significant digits for a property:"
}], "ExampleText",
 CellID->5758993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\"\<C\>\"", ",", "\"\<AtomicWeight\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->607479222],

Cell[BoxData["12.0107`5.999999999999999"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->364195096]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->388541687],

Cell[BoxData["5.999999999999999`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->82772219]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->380610788],

Cell[TextData[{
 "A property that is not applicable to an element has the value ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Missing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Missing"], "[", "\"\<NotApplicable\>\"", "]"}]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->812600388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\"\<Helium\>\"", ",", "\"\<MeltingPoint\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->978788],

Cell[BoxData[
 RowBox[{"Missing", "[", "\<\"NotApplicable\"\>", "]"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->368142135]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->490922267],

Cell[TextData[{
 "A property that is not available for an element has the value ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Missing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Missing"], "[", "\"\<NotAvailable\>\"", "]"}]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->187464565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\"\<F\>\"", ",", "\"\<SoundSpeed\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->178393597],

Cell[BoxData[
 RowBox[{"Missing", "[", "\<\"NotAvailable\"\>", "]"}]], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13920931]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11222678],

Cell[TextData[{
 "A property that is unknown for an element has the value ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Missing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Missing"], "[", "\"\<Unknown\>\"", "]"}]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->9731214],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"117", ",", "\"\<AtomicWeight\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->78474866],

Cell[BoxData[
 RowBox[{"Missing", "[", "\<\"Unknown\"\>", "]"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->186777870]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->358337295],

Cell["Find the list of element names matching a string expression:", \
"ExampleText",
 CellID->210372128],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", "\"\<H*\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->77964217],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Hydrogen\"\>", ",", "\<\"Helium\"\>", ",", "\<\"Holmium\"\>", 
   ",", "\<\"Hafnium\"\>", ",", "\<\"Hassium\"\>"}], "}"}]], "Output",
 ImageSize->{308, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1805520027]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->133680859],

Cell["\<\
Show the linear relationship between enthalpy of vaporization and boiling \
point:\
\>", "ExampleText",
 CellID->183278447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"ElementData", "[", 
       RowBox[{"z", ",", "\"\<AbsoluteBoilingPoint\>\""}], "]"}], ",", 
      RowBox[{"ElementData", "[", 
       RowBox[{"z", ",", "\"\<VaporizationHeat\>\""}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "118"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->222503889],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxVlF1IU2EYxw9eiKwuJnTVRah1oUGw0osya28QOGTBNrFUnK35gZnpaZ6U
xqpj4qDv0yJpZXRyWNqXZ7ZEvIgRXcUCIagbLyZ93JSwi4SgLtz2/5+L88L4
8bzP+3w/O5XBIV9PiSRJHflfga618LbXjXWi0gj13VlfdRbFNbsYzksR51un
VDgNcVFkIAgOzoBaCEwaoHEZzFBujYqvCfmQ7USz8C3tmPjlLRWfMvlz47hA
3C24P9Iiajpuv9+otkEuPwh76T/i22OwG2jFvfse9QFwhfl4mM/HWVAegZ17
DMxUI85gVDyIF85O8dubD/jtrOgtnl2itnA+t9D/drBCw/sDzZCVh+xHF3iY
8bLDzOcF+xMG0y+ZX4R+n4GO82DDNKieASP0Z1AvzbGeUfA79fqoVZ9m/XKM
sh9sT/CdDO4281XApeuou1ZAzt3k+3r6UdivPejXP7+wFQdbBX3ZLb73gavc
l4pT4FHWn2a+TQvUXwHjb0BtAnRQTlO/nOT9GNiYtNpL88z7Eugy+8F4paw/
OwQKjXZtoG+a7wfAkaf0z37aH/G9F0zdpezC3kxGwJ916GOim/tdg3cq+yk8
4Dud9+zPvlf0dwEMsl9Zzv8L90nnvNqfgyvnwNicNd/99J/t4f2UVY7Sn537
2klZpr2D9av0X8991bg/12at8TufsD72988k6+kGF1lPjvVt5XyNcbBrEfwb
BT9Qlq6C65TLqJ9JWe393CeV+1HC74/OfQiZ/xcF36P5ce7zMdy7+H/Wme/9
x6ynF0xNWetxm/Nvg5/T/ZT3gn2m/Umwiv015/vD3HcVNL+fgYu0pyzCVn2O
8zfn5VHEJsccLKk=
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 5869.}, {0., 800.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1431161679]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31026702],

Cell["\<\
Plot the atomic radii of the elements, showing the effects of the electron \
shell structure:\
\>", "ExampleText",
 CellID->564040795],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ElementData", "[", 
     RowBox[{"z", ",", "\"\<AtomicRadius\>\""}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "118"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1040243516],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxdlElOAzEQRVusWLJgwYKFQQghhBDzDDHzPCSESUBoGsIMQZygjsARfJQ+
Sh+BIzD4fSSIFD09V9ttV7m6I2tU6k1JklS//t+Mv4/SD2zDMwBLsDmyuMZb
4BlsjcwP8DZ8D2+HW9DBNdgJl2EXXITdrHeL90S6DO+NtHO8j+dP8X7ix/gA
PISDPL+PD+FlfDgyfcFHIv0dPgq1vzF4A8eZX8cnWF/5nOQ88in2e4VPQ/lM
ZMjwWebL51j/Elcd5Z79X/Ae3FTPeeafMI7bEfEFSP4Mf39lnLqlj8RxeyC+
xPr3jMuVT+6B6m14oXyusH/c8KD8rkY63PCg/HLvlG/Df/O9TjxjHA8pcfok
rxGXK3+bkPtneHhjnD4IDeLbnE/3a4f1lB884Mku8WfiePFEnL5zxL2cuOGG
q0+95pf/usdz1fOfq08cnlQg9fZynQd31DvHTf1DHzrc46Z6K46rb3PVvxqp
fvO46mu4x3O8UH/wHSuot8dz9Yu+czX/CWq8lTk=
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 50.},
  PlotRange->{{0., 86.}, {31., 298.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1717492553]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->717047],

Cell["Plot the number of stable isotopes of each element:", "ExampleText",
 CellID->451569494],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Length", "[", 
     RowBox[{"ElementData", "[", 
      RowBox[{"z", ",", "\"\<StableIsotopes\>\""}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "108"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1607110],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxtkslKQ0EQRQtXLl24cOEiBhERkahxHtKaOGVQ85yi7gR3Qn6hPq0/yU+I
Yt1AH2x41DscbnV1v7f0Ma4+Z8zs6+f5rX/ruxUv6f86C55LZW4efgG8CK6h
bx39luFX4Ffh1+DX4TfgGzjHJubbQn4bvhlV595B/134Pfh97H8Afwh/BH+M
/ieY7xS+BZ/K/i5W/7My72Llz6PGd3ax8m30b8N34DvwF+gv1roMjv/Kxcpf
IS/W/NfwYuVvguM/dLHy3ai6H7HyveB6+B58H/P34QfBup8B/C32F2vdwYs1
/33UOH8SR38Xx3wZ3obID0vvYuXhrSrnS1XpHT7D2wP2F8f5XKy8WPnHcr4k
Vl4c95+nPtZTyQns4Ay2Z+TBLo55M7y9IA92cAbbCHmwgzPYXpEHOziD7Q15
sIMz2N6nPAHSJIPz
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 108.}, {0., 10.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1569638944]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->143784917],

Cell["Plot the atomic masses of all stable isotopes:", "ExampleText",
 CellID->283212743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Flatten", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Thread", "[", 
       RowBox[{"{", 
        RowBox[{"z", ",", 
         RowBox[{"ElementData", "[", 
          RowBox[{"z", ",", "\"\<StableIsotopes\>\""}], "]"}]}], "}"}], "]"}],
       ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "100"}], "}"}]}], "]"}], ",", "1"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->123078064],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxt1k1OFFEUxfGHI4cOHDhwUBpjjDFGERFR4UGLgCIg+IkKJYqoiXELdym1
lLeUWoJLMMZzOrn/yOTmV/fU7aqm6vW7dPxr7+RMKWVmppS/9d/f7+X/11Jz
PQufw/EL8EXkLqueV70CX8Wca/B1zL0B31TtVG/Bt+FZXNcdXNccfBeex3Xf
w3UvwPfhRVXf1wNV39dD+BG8pOr7Xlb1fdfsgMsKvKqq7ylWYPdnkbcn8GNV
fa8xgd2fQ95eyw64PIHXVfV/Cvfn0ZcDLhvow2VTVf/nsBfQt59mB1yeqeq5
CHsRfXsrO+DyXFXPUdgP0be3swMuO/Cuqp7D2Mmu7i8hLwfcmH+BvK3nusLN
rsj7Od/LrnDIfi+a+yu5P31P9rMrHHB5qeNy28+u6vs9mp6/ms+f9uEGl1fI
y35vq/sT5Cc5bzfmXysnV9nvbcANLm+Ql70OVPfXkF/Lebsx/za7wmF7XXiX
XeGAywGMeZzfZK9DzfPWMd/r0EF2hQMu79GXva61g+zq/AbmeZ1jH25w+YC8
7HWzur+J/GbO2435j9kVDrjB5RB5uBzpuOcfZjfnvW7Dwf5RdoXDnyc3973O
w8F+n93BFe7hgBtcPiknD+5vYf4W5m1hnjzCnm93cPXny737/t2CKxxw8zx5
cH879+0R7o6zKxy2fwfhAW7Mf86usn9Xx+PszvndnLd7OOABbnD5orny6OvB
vMD5gfPtDq5wD4fsfcEge19Q4YAbPMLlBPNk7ys6OZAP5O0eDniAG+d/1XFf
r69vL/ftDq5wD4fsfc8gB/p2g0e4nGZX2fumTp7uk+AeDniAG+d90+fK42l2
p34gb1e4hwNusvdtgzzd18ENHuHyPbuDKxyy94k9PMiBvN3gES4/ZO/TftY/
P0KJwQ==
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 90.}, {0., 232.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1232612060]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->317530110],

Cell["\<\
Create an annotated list of critical temperature and critical pressure:\
\>", "ExampleText",
 CellID->14537516],

Cell[BoxData[
 RowBox[{
  RowBox[{"adata", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Tooltip", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ElementData", "[", 
          RowBox[{"z", ",", "\"\<CriticalTemperature\>\""}], "]"}], ",", 
         RowBox[{"ElementData", "[", 
          RowBox[{"z", ",", "\"\<CriticalPressure\>\""}], "]"}]}], "}"}], ",",
        
       RowBox[{"Row", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ElementData", "[", "z", "]"}], ",", "\"\< (\>\"", ",", 
          RowBox[{"ElementData", "[", 
           RowBox[{"z", ",", "\"\<Abbreviation\>\""}], "]"}], ",", 
          "\"\<)\>\""}], "}"}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "118"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->494474563],

Cell["Use the description annotations to get plot labels:", "ExampleText",
 CellID->131364823],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"adata", ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"ElementData", "[", 
       RowBox[{
       "1", ",", "\"\<CriticalTemperature\>\"", ",", "\"\<Description\>\""}], 
       "]"}], ",", 
      RowBox[{"ElementData", "[", 
       RowBox[{
       "1", ",", "\"\<CriticalPressure\>\"", ",", "\"\<Description\>\""}], 
       "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2045337437],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{32.97, 1.293}, {5.19, 0.227}, {3223., 67.}, {126.21, 3.39}, {
      154.59, 5.043}, {144.13, 5.172}, {44.4, 2.76}, {2573., 35.}, {1314., 
      20.7}, {416.9, 7.991}, {150.87, 4.898}, {2223., 16.}, {1766., 27.2}, {
      588., 10.34}, {209.41, 5.5}, {2093., 16.}, {819., 11.7}, {289.77, 
      5.841}, {1938., 9.4}, {1750., 172.}, {377., 6.28}}]}, {}}, {
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1750., 58.27162500000011}}]},
      InterpretationBox[
       RowBox[{
        "\"Mercury\"", "\[InvisibleSpace]", "\" (\"", "\[InvisibleSpace]", 
         "\"Hg\"", "\[InvisibleSpace]", "\")\""}], 
       Row[{"Mercury", " (", "Hg", ")"}]]],
     Annotation[#, 
      Row[{"Mercury", " (", "Hg", ")"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{377., 6.28}}]},
      InterpretationBox[
       RowBox[{
        "\"Radon\"", "\[InvisibleSpace]", "\" (\"", "\[InvisibleSpace]", 
         "\"Rn\"", "\[InvisibleSpace]", "\")\""}], 
       Row[{"Radon", " (", "Rn", ")"}]]],
     Annotation[#, 
      Row[{"Radon", " (", "Rn", ")"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{32.97, 1.293}}]},
      InterpretationBox[
       RowBox[{
        "\"Hydrogen\"", "\[InvisibleSpace]", "\" (\"", "\[InvisibleSpace]", 
         "\"H\"", "\[InvisibleSpace]", "\")\""}], 
       Row[{"Hydrogen", " (", "H", ")"}]]],
     Annotation[#, 
      Row[{"Hydrogen", " (", "H", ")"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{5.19, 0.227}}]},
      InterpretationBox[
       RowBox[{
        "\"Helium\"", "\[InvisibleSpace]", "\" (\"", "\[InvisibleSpace]", 
         "\"He\"", "\[InvisibleSpace]", "\")\""}], 
       Row[{"Helium", " (", "He", ")"}]]],
     Annotation[#, 
      Row[{"Helium", " (", "He", ")"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3223., 58.27162500000011}}]},
      InterpretationBox[
       RowBox[{
        "\"Lithium\"", "\[InvisibleSpace]", "\" (\"", "\[InvisibleSpace]", 
         "\"Li\"", "\[InvisibleSpace]", "\")\""}], 
       Row[{"Lithium", " (", "Li", ")"}]]],
     Annotation[#, 
      Row[{"Lithium", " (", "Li", ")"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{126.21, 3.39}}]},
      InterpretationBox[
       RowBox[{
        "\"Nitrogen\"", "\[InvisibleSpace]", "\" (\"", "\[InvisibleSpace]", 
         "\"N\"", "\[InvisibleSpace]", "\")\""}], 
       Row[{"Nitrogen", " (", "N", ")"}]]],
     Annotation[#, 
      Row[{"Nitrogen", " (", "N", ")"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{154.59, 5.043}}]},
      InterpretationBox[
       RowBox[{
        "\"Oxygen\"", "\[InvisibleSpace]", "\" (\"", "\[InvisibleSpace]", 
         "\"O\"", "\[InvisibleSpace]", "\")\""}], 
       Row[{"Oxygen", " (", "O", ")"}]]],
     Annotation[#, 
      Row[{"Oxygen", " (", "O", ")"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{144.13, 5.172}}]},
      InterpretationBox[
       RowBox[{
        "\"Fluorine\"", "\[InvisibleSpace]", "\" (\"", "\[InvisibleSpace]", 
         "\"F\"", "\[InvisibleSpace]", "\")\""}], 
       Row[{"Fluorine", " (", "F", ")"}]]],
     Annotation[#, 
      Row[{"Fluorine", " (", "F", ")"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{44.4, 2.76}}]},
      InterpretationBox[
       RowBox[{
        "\"Neon\"", "\[InvisibleSpace]", "\" (\"", "\[InvisibleSpace]", 
         "\"Ne\"", "\[InvisibleSpace]", "\")\""}], 
       Row[{"Neon", " (", "Ne", ")"}]]],
     Annotation[#, 
      Row[{"Neon", " (", "Ne", ")"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2573., 35.}}]},
      InterpretationBox[
       RowBox[{
        "\"Sodium\"", "\[InvisibleSpace]", "\" (\"", "\[InvisibleSpace]", 
         "\"Na\"", "\[InvisibleSpace]", "\")\""}], 
       Row[{"Sodium", " (", "Na", ")"}]]],
     Annotation[#, 
      Row[{"Sodium", " (", "Na", ")"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1314., 20.7}}]},
      InterpretationBox[
       RowBox[{
        "\"Sulfur\"", "\[InvisibleSpace]", "\" (\"", "\[InvisibleSpace]", 
         "\"S\"", "\[InvisibleSpace]", "\")\""}], 
       Row[{"Sulfur", " (", "S", ")"}]]],
     Annotation[#, 
      Row[{"Sulfur", " (", "S", ")"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{416.9, 7.991}}]},
      InterpretationBox[
       RowBox[{
        "\"Chlorine\"", "\[InvisibleSpace]", "\" (\"", "\[InvisibleSpace]", 
         "\"Cl\"", "\[InvisibleSpace]", "\")\""}], 
       Row[{"Chlorine", " (", "Cl", ")"}]]],
     Annotation[#, 
      Row[{"Chlorine", " (", "Cl", ")"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{150.87, 4.898}}]},
      InterpretationBox[
       RowBox[{
        "\"Argon\"", "\[InvisibleSpace]", "\" (\"", "\[InvisibleSpace]", 
         "\"Ar\"", "\[InvisibleSpace]", "\")\""}], 
       Row[{"Argon", " (", "Ar", ")"}]]],
     Annotation[#, 
      Row[{"Argon", " (", "Ar", ")"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2223., 16.}}]},
      InterpretationBox[
       RowBox[{
        "\"Potassium\"", "\[InvisibleSpace]", "\" (\"", "\[InvisibleSpace]", 
         "\"K\"", "\[InvisibleSpace]", "\")\""}], 
       Row[{"Potassium", " (", "K", ")"}]]],
     Annotation[#, 
      Row[{"Potassium", " (", "K", ")"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1766., 27.2}}]},
      InterpretationBox[
       RowBox[{
        "\"Selenium\"", "\[InvisibleSpace]", "\" (\"", "\[InvisibleSpace]", 
         "\"Se\"", "\[InvisibleSpace]", "\")\""}], 
       Row[{"Selenium", " (", "Se", ")"}]]],
     Annotation[#, 
      Row[{"Selenium", " (", "Se", ")"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{588., 10.34}}]},
      InterpretationBox[
       RowBox[{
        "\"Bromine\"", "\[InvisibleSpace]", "\" (\"", "\[InvisibleSpace]", 
         "\"Br\"", "\[InvisibleSpace]", "\")\""}], 
       Row[{"Bromine", " (", "Br", ")"}]]],
     Annotation[#, 
      Row[{"Bromine", " (", "Br", ")"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{209.41, 5.5}}]},
      InterpretationBox[
       RowBox[{
        "\"Krypton\"", "\[InvisibleSpace]", "\" (\"", "\[InvisibleSpace]", 
         "\"Kr\"", "\[InvisibleSpace]", "\")\""}], 
       Row[{"Krypton", " (", "Kr", ")"}]]],
     Annotation[#, 
      Row[{"Krypton", " (", "Kr", ")"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2093., 16.}}]},
      InterpretationBox[
       RowBox[{
        "\"Rubidium\"", "\[InvisibleSpace]", "\" (\"", "\[InvisibleSpace]", 
         "\"Rb\"", "\[InvisibleSpace]", "\")\""}], 
       Row[{"Rubidium", " (", "Rb", ")"}]]],
     Annotation[#, 
      Row[{"Rubidium", " (", "Rb", ")"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{819., 11.7}}]},
      InterpretationBox[
       RowBox[{
        "\"Iodine\"", "\[InvisibleSpace]", "\" (\"", "\[InvisibleSpace]", 
         "\"I\"", "\[InvisibleSpace]", "\")\""}], 
       Row[{"Iodine", " (", "I", ")"}]]],
     Annotation[#, 
      Row[{"Iodine", " (", "I", ")"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{289.77, 5.841}}]},
      InterpretationBox[
       RowBox[{
        "\"Xenon\"", "\[InvisibleSpace]", "\" (\"", "\[InvisibleSpace]", 
         "\"Xe\"", "\[InvisibleSpace]", "\")\""}], 
       Row[{"Xenon", " (", "Xe", ")"}]]],
     Annotation[#, 
      Row[{"Xenon", " (", "Xe", ")"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1938., 9.4}}]},
      InterpretationBox[
       RowBox[{
        "\"Cesium\"", "\[InvisibleSpace]", "\" (\"", "\[InvisibleSpace]", 
         "\"Cs\"", "\[InvisibleSpace]", "\")\""}], 
       Row[{"Cesium", " (", "Cs", ")"}]]],
     Annotation[#, 
      Row[{"Cesium", " (", "Cs", ")"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1750., 58.27162500000011}}]},
      InterpretationBox[
       RowBox[{
        "\"Mercury\"", "\[InvisibleSpace]", "\" (\"", "\[InvisibleSpace]", 
         "\"Hg\"", "\[InvisibleSpace]", "\")\""}], 
       Row[{"Mercury", " (", "Hg", ")"}]]],
     Annotation[#, 
      Row[{"Mercury", " (", "Hg", ")"}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{377., 6.28}}]},
      InterpretationBox[
       RowBox[{
        "\"Radon\"", "\[InvisibleSpace]", "\" (\"", "\[InvisibleSpace]", 
         "\"Rn\"", "\[InvisibleSpace]", "\")\""}], 
       Row[{"Radon", " (", "Rn", ")"}]]],
     Annotation[#, 
      Row[{"Radon", " (", "Rn", ")"}], "Tooltip"]& ]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  Frame->True,
  FrameLabel->{
    FormBox["\"critical temperature\"", TraditionalForm], 
    FormBox["\"critical pressure\"", TraditionalForm]},
  PlotRange->{{0., 3223.}, {0., 58.27162500000011}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{304, 200},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[2]=",
 CellID->1883633458]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->264632214],

Cell["\<\
Draw a basic periodic table, color coding solids, liquids and gases:\
\>", "ExampleText",
 CellID->554240849],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Head", "[", 
        RowBox[{"ElementData", "[", 
         RowBox[{"z", ",", "\"\<Group\>\""}], "]"}], "]"}], "=!=", 
       "Missing"}], ",", 
      RowBox[{"Inset", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"Pane", "[", 
           RowBox[{
            RowBox[{"ElementData", "[", 
             RowBox[{"z", ",", "\"\<Abbreviation\>\""}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"20", ",", "20"}], "}"}]}], "]"}], ",", 
          RowBox[{"Background", "\[Rule]", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"ElementData", "[", 
              RowBox[{"z", ",", "\"\<Phase\>\""}], "]"}], "/.", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"\"\<Solid\>\"", "\[Rule]", "LightBrown"}], ",", 
               RowBox[{"\"\<Liquid\>\"", "\[Rule]", "LightBlue"}], ",", 
               RowBox[{"\"\<Gas\>\"", "\[Rule]", "Yellow"}], ",", 
               RowBox[{"_", "\[Rule]", "Gray"}]}], "}"}]}], ")"}]}]}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ElementData", "[", 
           RowBox[{"z", ",", "\"\<Group\>\""}], "]"}], ",", 
          RowBox[{"-", 
           RowBox[{"ElementData", "[", 
            RowBox[{"z", ",", "\"\<Period\>\""}], "]"}]}]}], "}"}]}], "]"}], 
      ",", 
      RowBox[{"{", "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "108"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->199722801],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{424, 166},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40867734]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->303279762],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " to obtain a list of property values for all the elements:"
}], "ExampleText",
 CellID->7221748],

Cell[BoxData[
 RowBox[{
  RowBox[{"pv1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"ElementData", "[", 
      RowBox[{"z", ",", "\"\<BoilingPoint\>\""}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "118"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1920714127],

Cell[TextData[{
 "The same thing using ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->166897552],

Cell[BoxData[
 RowBox[{
  RowBox[{"pv2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"ElementData", "[", 
      RowBox[{"#", ",", "\"\<BoilingPoint\>\""}], "]"}], "&"}], "/@", 
    RowBox[{"ElementData", "[", "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1977644534],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pv1", "\[Equal]", "pv2"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1667278319],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1537150069]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->180873847],

Cell["Form a list of property values for a class of elements:", "ExampleText",
 CellID->217244094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"i", "=", 
  RowBox[{"ElementData", "[", "\"\<Insulator\>\"", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2073332905],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Boron\"\>", ",", "\<\"Sulfur\"\>", ",", "\<\"Chlorine\"\>", 
   ",", "\<\"Bromine\"\>", ",", "\<\"Iodine\"\>"}], "}"}]], "Output",
 ImageSize->{287, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->652936273]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"#", ",", 
      RowBox[{"ElementData", "[", 
       RowBox[{"#", ",", "\"\<Resistivity\>\""}], "]"}]}], "}"}], "&"}], "/@",
    "i"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23268862],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Boron\"\>", ",", "10000.`5.000000000000002"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Sulfur\"\>", ",", "1.`1.9999999999999998*^15"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"\<\"Chlorine\"\>", ",", "100.`2.9999999999999973"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"\<\"Bromine\"\>", ",", "1.`1.9999999999999998*^10"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"\<\"Iodine\"\>", ",", "1.`1.9999999999999998*^7"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{400, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->258504141]
}, Open  ]],

Cell[TextData[{
 "Display the data as a formatted table using ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->347983233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"Alignment", "\[Rule]", 
    RowBox[{"{", "Left", "}"}]}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"LightRed", ",", "Pink"}], "}"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1719255270],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Boron\"\>", "10000.`5.000000000000002"},
    {"\<\"Sulfur\"\>", "1.`1.9999999999999998*^15"},
    {"\<\"Chlorine\"\>", "100.`2.9999999999999973"},
    {"\<\"Bromine\"\>", "1.`1.9999999999999998*^10"},
    {"\<\"Iodine\"\>", "1.`1.9999999999999998*^7"}
   },
   ColumnsEqual->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{
        RGBColor[1, 0.85, 0.85], 
        RGBColor[1, 0.5, 0.5]}}},
   GridBoxFrame->{"ColumnsIndexed" -> {{{1, -1}, {1, -1}} -> True}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{135, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->319679906]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->156167646],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["DeleteCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DeleteCases"]], "InlineFormula"],
 " to filter out non-missing elements:"
}], "ExampleText",
 CellID->20360895],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeleteCases", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ElementData", "[", "z", "]"}], ",", 
       RowBox[{"ElementData", "[", 
        RowBox[{"z", ",", "\"\<CuriePoint\>\""}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "118"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"_", ",", "_Missing"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->156356400],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Iron\"\>", ",", "1043.`3.9999999999999996"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Cobalt\"\>", ",", "1394.`3.9999999999999996"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Nickel\"\>", ",", "631.`2.9999999999999996"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Gadolinium\"\>", ",", "292.`3.0000000000000018"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Terbium\"\>", ",", "222.`2.9999999999999973"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Dysprosium\"\>", ",", "87.`1.9999999999999998"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"\<\"Holmium\"\>", ",", "20.`1.9999999999999998"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Erbium\"\>", ",", "32.`1.9999999999999998"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Thulium\"\>", ",", "25.`1.9999999999999998"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{560, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2003578995]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->436506901],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 " to plot a list of property values:"
}], "ExampleText",
 CellID->19349895],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"ElementData", "[", 
      RowBox[{"z", ",", "\"\<Density\>\""}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "118"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1910073777],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxdkklIVlEYhg82UNDgQkokIi1FG2yystGjZpM2aFkRgj9GLUJw0wRZnGhh
E7aIyLTJBpJcSFkOpXKzsDINyQhcKC0yCFr8i5CioNL3OYu6cHl4znu/73z3
3hNbVJK3L8IYU/j3HqaucNqPyV8a60Y1prFgJ0TMKZvS14GPsyNocqKJFD9e
xaPE1Nt4tFhTjU+zB1oOXowe/Y1+M+yRthsx8/uH8Dh7Jj002BP3E59lu7uG
r694gvrYcvoliolV+Gwx+i4+V0y5hSeLpX7eBeLN6/hCeyrorM5qGI8vsvFj
T17KPPeL/RdrPThLnsL7VuBLxLx7+FKx6gG+TBxoxFPFT0/x5WJyK75CbG/D
V4pFz/BV4n7vq8Vi72v+658mRvr9rfjmkejwwgbydLH3ITkeqiHPgJPI8fBl
1jPF83fI8aP+e6wVS5rJ8daAPEuMekGOH+4gXycmvSLHc3GzfoTu2EtyuTlO
P7NBHGQ/h5e3kG/81x2e9IR8kxhqIsdz6smzbeWV4WsqebZYcI08RyyuJccj
6Gc2i7Hs5/Aw38tsEYv4vw4P+fm3is1+fryU/222if2cLyt3E/33wOvxAJ/n
z1eu+Bi3cpfSTj35feYNyFOfU58n/n5Nvdxl9FCPd72jnufL3lO/XXnUB+rx
6bjDK3g+kJs++pkdYkkn9Xi8Py94AuctwGP8/PniEO/v8u1QYsGF9kMzyXeK
pzkPFq+l3uGffX98zFvqd2n+Sua1+Pde6uVmD252i3v9++ADXTyPn+i2fwCp
ke8t
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1608584005]
}, Open  ]],

Cell["\<\
Missing data is automatically excluded in plotting functions: \
\>", "ExampleText",
 CellID->94821444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Cases", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"ElementData", "[", 
       RowBox[{"z", ",", "\"\<Density\>\""}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "118"}], "}"}]}], "]"}], ",", "_Missing"}], "]"}], "//",
   "Short"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23663497],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Missing", "[", "\<\"NotAvailable\"\>", "]"}], ",", 
    RowBox[{"\[LeftSkeleton]", "21", "\[RightSkeleton]"}], ",", 
    RowBox[{"Missing", "[", "\<\"NotAvailable\"\>", "]"}]}], "}"}],
  Short]], "Output",
 ImageSize->{377, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//Short=",
 CellID->799739952]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->522875263],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListLogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLogPlot"]], "InlineFormula"],
 " when the data spans several orders of magnitude:"
}], "ExampleText",
 CellID->671567693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"ElementData", "[", 
      RowBox[{"z", ",", "\"\<UniverseAbundance\>\""}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "118"}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->80420752],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6377772]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->87128243],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["LatticeData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LatticeData"]], "InlineFormula"],
 " to get detailed information on solid state structures:"
}], "ExampleText",
 CellID->1252683353],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\"\<Titanium\>\"", ",", "\"\<CrystalStructure\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1068126438],

Cell[BoxData["\<\"HexagonalClosePacking\"\>"], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->807028520]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LatticeData", "[", 
  RowBox[{"%", ",", "\"\<Image\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2066922330],

Cell[BoxData[
 Graphics3DBox[{
   GraphicsComplex3DBox[
    NCache[{{-1, 0, 1}, {
      Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2], 1}, {
      Rational[-1, 2], Rational[-1, 2] 3^Rational[1, 2], 1}, {0, 0, 1}, {
      Rational[1, 2], Rational[1, 2] 3^Rational[1, 2], 1}, {
      Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2], 1}, {1, 0, 1}, {
      Rational[-1, 2], Rational[1, 2] 3^Rational[-1, 2], 1 - Rational[2, 3]^
       Rational[1, 2]}, {
      0, Rational[1, 2] 3^Rational[-1, 2] + Rational[-1, 2] 3^Rational[1, 2], 
       1 - Rational[2, 3]^Rational[1, 2]}, {
      Rational[1, 2], Rational[1, 2] 3^Rational[-1, 2], 1 - Rational[2, 3]^
       Rational[1, 2]}, {-1, 0, -1}, {
      Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2], -1}, {
      Rational[-1, 2], Rational[-1, 2] 3^Rational[1, 2], -1}, {0, 0, -1}, {
      Rational[1, 2], Rational[1, 2] 3^Rational[1, 2], -1}, {
      Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2], -1}, {1, 
      0, -1}}, {{-1, 0, 
      1}, {-0.5, 0.8660254037844386, 1}, {-0.5, -0.8660254037844386, 1}, {0, 
      0, 1}, {0.5, 0.8660254037844386, 1}, {0.5, -0.8660254037844386, 1}, {1, 
      0, 1}, {-0.5, 0.2886751345948129, 0.18350341907227397`}, {
      0, -0.5773502691896257, 0.18350341907227397`}, {0.5, 0.2886751345948129,
       0.18350341907227397`}, {-1, 
      0, -1}, {-0.5, 
       0.8660254037844386, -1}, {-0.5, -0.8660254037844386, -1}, {0, 0, -1}, {
      0.5, 0.8660254037844386, -1}, {0.5, -0.8660254037844386, -1}, {1, 
      0, -1}}], {
     {Opacity[0.1], EdgeForm[GrayLevel[0.8]], 
      Polygon3DBox[{{1, 2, 5, 7, 6, 3}, {11, 12, 15, 17, 16, 13}, {1, 2, 12, 
        11}, {1, 3, 13, 11}, {3, 6, 16, 13}, {6, 7, 17, 16}, {7, 5, 15, 17}, {
        5, 2, 12, 15}}]}, 
     {GrayLevel[0.8], 
      Line3DBox[{{9, 8}, {9, 10}, {10, 8}, {11, 14}, {12, 14}, {13, 14}, {15, 
       14}, {16, 14}, {17, 14}, {1, 4}, {2, 4}, {3, 4}, {5, 4}, {6, 4}, {7, 
       4}}]}}], 
   {GrayLevel[0], Specularity[
     GrayLevel[1], 5], SphereBox[{-1, 0, 1}, 0.06], 
    SphereBox[
     NCache[{Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2], 1}, {-0.5, 
       0.8660254037844386, 1}], 0.06], 
    SphereBox[
     NCache[{Rational[-1, 2], Rational[-1, 2] 3^Rational[1, 2], 
       1}, {-0.5, -0.8660254037844386, 1}], 0.06], SphereBox[{0, 0, 1}, 0.06],
     SphereBox[
     NCache[{Rational[1, 2], Rational[1, 2] 3^Rational[1, 2], 1}, {
      0.5, 0.8660254037844386, 1}], 0.06], 
    SphereBox[
     NCache[{Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2], 1}, {
      0.5, -0.8660254037844386, 1}], 0.06], SphereBox[{1, 0, 1}, 0.06], 
    SphereBox[
     NCache[{Rational[-1, 2], Rational[1, 2] 3^Rational[-1, 2], 1 - 
       Rational[2, 3]^Rational[1, 2]}, {-0.5, 0.2886751345948129, 
      0.18350341907227397`}], 0.06], 
    SphereBox[
     NCache[{0, Rational[1, 2] 3^Rational[-1, 2] + 
       Rational[-1, 2] 3^Rational[1, 2], 1 - Rational[2, 3]^Rational[1, 2]}, {
      0, -0.5773502691896257, 0.18350341907227397`}], 0.06], 
    SphereBox[
     NCache[{Rational[1, 2], Rational[1, 2] 3^Rational[-1, 2], 1 - 
       Rational[2, 3]^Rational[1, 2]}, {0.5, 0.2886751345948129, 
      0.18350341907227397`}], 0.06], SphereBox[{-1, 0, -1}, 0.06], 
    SphereBox[
     NCache[{Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2], -1}, {-0.5, 
       0.8660254037844386, -1}], 0.06], 
    SphereBox[
     NCache[{Rational[-1, 2], Rational[-1, 2] 
       3^Rational[1, 2], -1}, {-0.5, -0.8660254037844386, -1}], 0.06], 
    SphereBox[{0, 0, -1}, 0.06], 
    SphereBox[
     NCache[{Rational[1, 2], Rational[1, 2] 3^Rational[1, 2], -1}, {
      0.5, 0.8660254037844386, -1}], 0.06], 
    SphereBox[
     NCache[{Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2], -1}, {
      0.5, -0.8660254037844386, -1}], 0.06], SphereBox[{1, 0, -1}, 0.06]}},
  Boxed->False,
  ImageSize->{180., 186.77708802110493`},
  ViewPoint->NCache[{4, 
     Rational[5, 3], 1}, {4, 1.6666666666666667`, 1}],
  ViewVertical->{-0.04765712139887231, -0.02441337508448826, 
   0.9986360329175898}]], "Output",
 ImageSize->{184, 187},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->221621188,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LatticeData", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<Bravais\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Tetragonal\>\"", ",", "\"\<BodyCentered\>\""}], "}"}]}], 
    "}"}], ",", "\"\<Properties\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1744994232],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AlternateNames\"\>", ",", "\<\"AutomorphismGroupOrder\"\>", 
   ",", "\<\"Determinant\"\>", ",", "\<\"Dimension\"\>", ",", "\<\"Even\"\>", 
   ",", "\<\"GramMatrix\"\>", ",", "\<\"Integral\"\>", 
   ",", "\<\"Nonintegral\"\>", ",", "\<\"Nonunimodular\"\>", 
   ",", "\<\"Odd\"\>", ",", "\<\"QuadraticForm\"\>", 
   ",", "\<\"StandardName\"\>", ",", "\<\"Unimodular\"\>", 
   ",", "\<\"Volume\"\>"}], "}"}]], "Output",
 ImageSize->{459, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1050662818]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->417168155],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["IsotopeData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IsotopeData"]], "InlineFormula"],
 " to get detailed information on isotopes:"
}], "ExampleText",
 CellID->431281038],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\"\<Rubidium\>\"", ",", "\"\<KnownIsotopes\>\""}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->399283605],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "71", ",", "72", ",", "73", ",", "74", ",", "75", ",", "76", ",", "77", ",",
    "78", ",", "79", ",", "80", ",", "81", ",", "82", ",", "83", ",", "84", 
   ",", "85", ",", "86", ",", "87", ",", "88", ",", "89", ",", "90", ",", 
   "91", ",", "92", ",", "93", ",", "94", ",", "95", ",", "96", ",", "97", 
   ",", "98", ",", "99", ",", "100", ",", "101", ",", "102"}], 
  "}"}]], "Output",
 ImageSize->{456, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1879436492]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IsotopeData", "[", 
  RowBox[{"\"\<Rubidium84\>\"", ",", "\"\<Properties\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->232186824],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AtomicMass\"\>", ",", "\<\"AtomicNumber\"\>", 
   ",", "\<\"BindingEnergy\"\>", ",", "\<\"BranchingRatios\"\>", 
   ",", "\<\"DaughterNuclides\"\>", ",", "\<\"DecayEnergies\"\>", 
   ",", "\<\"DecayModes\"\>", ",", "\<\"DecayModeSymbols\"\>", 
   ",", "\<\"DecayProducts\"\>", ",", "\<\"ExcitedStateEnergies\"\>", 
   ",", "\<\"ExcitedStateHalfLives\"\>", ",", "\<\"ExcitedStateLifetimes\"\>",
    ",", "\<\"ExcitedStateParities\"\>", ",", "\<\"ExcitedStateSpins\"\>", 
   ",", "\<\"ExcitedStateWidths\"\>", ",", "\<\"FullSymbol\"\>", 
   ",", "\<\"HalfLife\"\>", ",", "\<\"IsotopeAbundance\"\>", 
   ",", "\<\"Lifetime\"\>", ",", "\<\"MagneticMoment\"\>", 
   ",", "\<\"MassExcess\"\>", ",", "\<\"MassNumber\"\>", 
   ",", "\<\"Memberships\"\>", ",", "\<\"Name\"\>", 
   ",", "\<\"NeutronNumber\"\>", ",", "\<\"Parity\"\>", 
   ",", "\<\"QuadrupoleMoment\"\>", ",", "\<\"QuantumStatistics\"\>", 
   ",", "\<\"Spin\"\>", ",", "\<\"Stable\"\>", ",", "\<\"Symbol\"\>", 
   ",", "\<\"Width\"\>"}], "}"}]], "Output",
 ImageSize->{576, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->352157321]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->119304512],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ChemicalData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChemicalData"]], "InlineFormula"],
 " to find properties for compounds of elements: "
}], "ExampleText",
 CellID->1039087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", "\"\<PalladiumCompound\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1183840123],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"PalladiumOxide\"\>", ",", "\<\"Palladium(II)Sulfide\"\>", 
   ",", "\<\"Palladium(II)Acetate\"\>", ",", "\<\"PalladiumNitrate\"\>", 
   ",", "\<\"Bis(Acetonitrile)Dichloropalladium\"\>", 
   ",", "\<\"Palladium(II)Bromide\"\>", 
   ",", "\<\"AmmoniumChloropalladite\"\>", 
   ",", "\<\"AmmoniumHexachloropalladate(IV)\"\>", 
   ",", "\<\"Palladium(II)Iodide\"\>", 
   ",", "\<\"AllylpalladiumChlorideDimer\"\>", 
   ",", "\<\"Bis(Benzonitrile)PalladiumChloride\"\>", 
   ",", "\<\"Bis(Dibenzylideneacetone)Palladium\"\>", 
   ",", "\<\"Bis(Triphenylphosphinepalladium)Acetate\"\>", 
   ",", "\<\"Tetrakis(Triphenylphosphine)Palladium\"\>"}], "}"}]], "Output",
 ImageSize->{580, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->243162915]
}, Open  ]],

Cell["Formulas:", "ExampleText",
 CellID->1181975817],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Caffeine\>\"", ",", "\"\<FormulaDisplay\>\""}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->175222298],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["\<\"C\"\>", "8"], "\[InvisibleSpace]", 
   SubscriptBox["\<\"H\"\>", "10"], "\[InvisibleSpace]", 
   SubscriptBox["\<\"N\"\>", "4"], "\[InvisibleSpace]", 
   SubscriptBox["\<\"O\"\>", "2"]}],
  Row[{
    Subscript["C", 8], 
    Subscript["H", 10], 
    Subscript["N", 4], 
    Subscript["O", 2]}]]], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->177732164]
}, Open  ]],

Cell["Element tallies:", "ExampleText",
 CellID->656157715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Caffeine\>\"", ",", "\"\<ElementTally\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->714188660],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"H\"\>", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"C\"\>", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"N\"\>", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"O\"\>", ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2142211018]
}, Open  ]],

Cell["3D structure plots:", "ExampleText",
 CellID->889999083],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Caffeine\>\"", ",", "\"\<MoleculePlot\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1175401636],

Cell[BoxData[
 Graphics3DBox[
  {AbsoluteThickness[3], EdgeForm[None], Specularity[
    GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJwtUw1MjWEUbjSzpFmrlaYisVBrLSqUDmlJqHvLvbdbrtv9q/une2+XWmRC
wxgLtSkjN6GttaIhjLOYyVKYxNIoK3+Zv/IXm/d9j7N9O9v7nfec53nO887R
FEr1k9zc3CLZN5l9fxq/PF4fEgffw3KPdJRp8KwtwaNvUQHcHmcHX+3YV88O
5GkYzSNThVObZil1Wjm+mx81tckzHdx4vFXjgy4WO4xQnXTQ8mZiLcx0l3lF
eEvAgzf4rcbtPs0pgwuVeK72zuwWRxIEV3yQXFXl0ZwQPWVpLip1y1+m+2bB
qORqUIU5HC7cTYs90AqwRHUt1dN7NbiSL3/7q9sIbyYY8KpMlOe03hpVhaCV
Hyg3Is1V0P25BsKbBrgH759JrpaigceIFQQelwbKqxjgfbHEuygPBd4hNQyW
soLKQqr/aofFu67Abo0vcNhBVQaws/J6hQUXMNnG9xtxIHRKeZVWQby6nSB0
8zOC4Hs0DllVWG6xhXJPPulWYiHd4nWkS2kG1Jxg0erEz+c58XRkKEt9Nhhh
DQfUYyc8XkWk15AC+fiwUD1wOqV7rdC57ebpgE8xIHDNsAOHaessJry4jubW
GUifCSPxPmgi3lIjzS930t6v6NHvefePzKIsYNUfJBkmFDguOfCYPxO6LBXq
fkaNNA8HApd5+aJNqFjadm9bgAbaeb27lXg8Ssb+XztNN5wKfMFz2zLkLmnc
KoWxv09K3l1U4s/M1w2179V4h/PaHQGr1MMPQ6KVKPY/bxNy1xQ0KIDDrY8v
wLJE5ojbeSD2O20liP2bUv/rZwZ+vT8vGxy8Xh0DXOauli1wMtrVFnshAY5+
3JG4JGgz4Oip+PDZUhQ4OuQo3sFwBvnjsBaF8cIkKPq1R+EKLlSjgd5Dupb4
ekmIv1YGx7kuvZuht4S9kDE58nUfceWTL4a0NDdAQr55Zac9vdDTvelxKPCP
G1DgVeiIr/sWFPo/05DPgrPJhwkOrAuIHAiVZZMP/PUgcpeNfLLLAVgWGJd/
KAVFHzZH9FHa4KlsNPJ6Sjj5IMcCUv5jwAnFEXOCxyyJIHDXGED4b6GZ+nmY
8IaTbb5DQ7hldiQ/5eNvvl6zjHyYZSY8JYXkk0op/ANM5hbS
    "], {
     {RGBColor[0.65, 0.7, 0.7], SphereBox[15, 24.], SphereBox[16, 24.], 
      SphereBox[17, 24.], SphereBox[18, 24.], SphereBox[19, 24.], 
      SphereBox[20, 24.], SphereBox[21, 24.], SphereBox[22, 24.], 
      SphereBox[23, 24.], SphereBox[24, 24.]}, 
     {RGBColor[0.4, 0.4, 0.4], SphereBox[7, 34.], SphereBox[8, 34.], 
      SphereBox[9, 34.], SphereBox[10, 34.], SphereBox[11, 34.], 
      SphereBox[12, 34.], SphereBox[13, 34.], SphereBox[14, 34.]}, 
     {RGBColor[0.291989, 0.437977, 0.888609], SphereBox[3, 32.], 
      SphereBox[4, 32.], SphereBox[5, 32.], SphereBox[6, 32.]}, 
     {RGBColor[0.800498, 0.201504, 0.192061], SphereBox[1, 31.], 
      SphereBox[2, 31.]}, 
     {RGBColor[0.65, 0.7, 0.7], CylinderBox[{38, 15}, 15.], 
      CylinderBox[{39, 16}, 15.], CylinderBox[{40, 17}, 15.], 
      CylinderBox[{41, 18}, 15.], CylinderBox[{42, 19}, 15.], 
      CylinderBox[{43, 20}, 15.], CylinderBox[{44, 21}, 15.], 
      CylinderBox[{45, 22}, 15.], CylinderBox[{46, 23}, 15.], 
      CylinderBox[{47, 24}, 15.]}, 
     {RGBColor[0.4, 0.4, 0.4], CylinderBox[{25, 9}, 15.], 
      CylinderBox[{26, 10}, 15.], CylinderBox[{27, 8}, 15.], 
      CylinderBox[{28, 10}, 15.], CylinderBox[{29, 12}, 15.], 
      CylinderBox[{30, 7}, 15.], CylinderBox[{31, 11}, 15.], 
      CylinderBox[{32, 13}, 15.], CylinderBox[{33, 9}, 15.], 
      CylinderBox[{34, 10}, 15.], CylinderBox[{35, 14}, 15.], 
      CylinderBox[{36, 8}, 15.], CylinderBox[{37, 11}, 15.], 
      CylinderBox[{7, 8}, 15.], CylinderBox[{7, 9}, 15.], 
      CylinderBox[{11, 38}, 15.], CylinderBox[{12, 39}, 15.], 
      CylinderBox[{12, 40}, 15.], CylinderBox[{12, 41}, 15.], 
      CylinderBox[{13, 42}, 15.], CylinderBox[{13, 43}, 15.], 
      CylinderBox[{13, 44}, 15.], CylinderBox[{14, 45}, 15.], 
      CylinderBox[{14, 46}, 15.], CylinderBox[{14, 47}, 15.]}, 
     {RGBColor[0.291989, 0.437977, 0.888609], CylinderBox[{3, 27}, 15.], 
      CylinderBox[{3, 28}, 15.], CylinderBox[{3, 29}, 15.], 
      CylinderBox[{4, 30}, 15.], CylinderBox[{4, 31}, 15.], 
      CylinderBox[{4, 32}, 15.], CylinderBox[{5, 33}, 15.], 
      CylinderBox[{5, 34}, 15.], CylinderBox[{5, 35}, 15.], 
      CylinderBox[{6, 36}, 15.], CylinderBox[{6, 37}, 15.]}, 
     {RGBColor[0.800498, 0.201504, 0.192061], CylinderBox[{1, 25}, 15.], 
      CylinderBox[{2, 26}, 15.]}}]},
  Boxed->False,
  ImageSize->289.7480032635572,
  Lighting->"Neutral",
  ViewPoint->{1.3, -2.4, -2.}]], "Output",
 ImageSize->{294, 297},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1577237571,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->754945036],

Cell["Show schematic colors assigned to elements:", "ExampleText",
 CellID->357475455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", 
  RowBox[{"\"\<Atoms\>\"", ",", "\"\<Panel\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->185511550],

Cell[BoxData[
 PanelBox[
  StyleBox[
   GraphicsBox[
    {EdgeForm[Opacity[0.1]], {
      {RGBColor[0.65, 0.7, 0.7], 
       TagBox[{RectangleBox[{0.55, 9.55}, {1.45, 10.45}], InsetBox[
          StyleBox["\<\"H\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {1, 10},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["H" -> RGBColor[0.65, 0.7, 0.7], 2]]]), PassEventsDown -> 
          Automatic, PassEventsUp -> 
          True}]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, 
      {RGBColor[0.836713, 1., 1.], 
       TagBox[{RectangleBox[{17.55, 9.55}, {18.45, 10.45}], InsetBox[
          StyleBox["\<\"He\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {18, 10},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["He" -> RGBColor[0.836713, 1., 1.], 2]]]), PassEventsDown -> 
          Automatic, PassEventsUp -> True}]]}}, {
      {RGBColor[0.799435, 0.543572, 0.997559], 
       TagBox[{RectangleBox[{0.55, 8.55}, {1.45, 9.45}], InsetBox[
          StyleBox["\<\"Li\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {1, 9},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Li" -> RGBColor[0.799435, 0.543572, 0.997559], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.770565, 0.964309, 0.0442359], 
       TagBox[{RectangleBox[{1.55, 8.55}, {2.45, 9.45}], InsetBox[
          StyleBox["\<\"Be\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {2, 9},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Be" -> RGBColor[0.770565, 0.964309, 0.0442359], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> 
          True}]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, 
      {RGBColor[1., 0.709804, 0.709804], 
       TagBox[{RectangleBox[{12.55, 8.55}, {13.45, 9.45}], InsetBox[
          StyleBox["\<\"B\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {13, 9},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["B" -> RGBColor[1., 0.709804, 0.709804], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.4, 0.4, 0.4], 
       TagBox[{RectangleBox[{13.55, 8.55}, {14.45, 9.45}], InsetBox[
          StyleBox["\<\"C\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {14, 9},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["C" -> RGBColor[0.4, 0.4, 0.4], 2]]]), PassEventsDown -> 
          Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.291989, 0.437977, 0.888609], 
       TagBox[{RectangleBox[{14.55, 8.55}, {15.45, 9.45}], InsetBox[
          StyleBox["\<\"N\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {15, 9},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["N" -> RGBColor[0.291989, 0.437977, 0.888609], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.800498, 0.201504, 0.192061], 
       TagBox[{RectangleBox[{15.55, 8.55}, {16.45, 9.45}], InsetBox[
          StyleBox["\<\"O\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {16, 9},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["O" -> RGBColor[0.800498, 0.201504, 0.192061], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.578462, 0.85539, 0.408855], 
       TagBox[{RectangleBox[{16.55, 8.55}, {17.45, 9.45}], InsetBox[
          StyleBox["\<\"F\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {17, 9},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["F" -> RGBColor[0.578462, 0.85539, 0.408855], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.677263, 0.928423, 0.955287], 
       TagBox[{RectangleBox[{17.55, 8.55}, {18.45, 9.45}], InsetBox[
          StyleBox["\<\"Ne\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {18, 9},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Ne" -> RGBColor[0.677263, 0.928423, 0.955287], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}}, {
      {RGBColor[0.658708, 0.492173, 0.842842], 
       TagBox[{RectangleBox[{0.55, 7.55}, {1.45, 8.45}], InsetBox[
          StyleBox["\<\"Na\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {1, 8},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Na" -> RGBColor[0.658708, 0.492173, 0.842842], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.628274, 0.850553, 0.0782731], 
       TagBox[{RectangleBox[{1.55, 7.55}, {2.45, 8.45}], InsetBox[
          StyleBox["\<\"Mg\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {2, 8},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Mg" -> RGBColor[0.628274, 0.850553, 0.0782731], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> 
          True}]]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, 
      {RGBColor[0.8913, 0.631904, 0.627399], 
       TagBox[{RectangleBox[{12.55, 7.55}, {13.45, 8.45}], InsetBox[
          StyleBox["\<\"Al\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {13, 8},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Al" -> RGBColor[0.8913, 0.631904, 0.627399], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.941176, 0.784314, 0.627451], 
       TagBox[{RectangleBox[{13.55, 7.55}, {14.45, 8.45}], InsetBox[
          StyleBox["\<\"Si\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {14, 8},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Si" -> RGBColor[0.941176, 0.784314, 0.627451], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[1., 0.501961, 0], 
       TagBox[{RectangleBox[{14.55, 7.55}, {15.45, 8.45}], InsetBox[
          StyleBox["\<\"P\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {15, 8},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["P" -> RGBColor[1., 0.501961, 0], 2]]]), PassEventsDown -> 
          Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.90443, 0.97015, 0.13504], 
       TagBox[{RectangleBox[{15.55, 7.55}, {16.45, 8.45}], InsetBox[
          StyleBox["\<\"S\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {16, 8},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["S" -> RGBColor[0.90443, 0.97015, 0.13504], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.412698, 0.932689, 0.166398], 
       TagBox[{RectangleBox[{16.55, 7.55}, {17.45, 8.45}], InsetBox[
          StyleBox["\<\"Cl\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {17, 8},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Cl" -> RGBColor[0.412698, 0.932689, 0.166398], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.546138, 0.844244, 0.892092], 
       TagBox[{RectangleBox[{17.55, 7.55}, {18.45, 8.45}], InsetBox[
          StyleBox["\<\"Ar\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {18, 8},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Ar" -> RGBColor[0.546138, 0.844244, 0.892092], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}}, {
      {RGBColor[0.534026, 0.420729, 0.705621], 
       TagBox[{RectangleBox[{0.55, 6.55}, {1.45, 7.45}], InsetBox[
          StyleBox["\<\"K\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {1, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["K" -> RGBColor[0.534026, 0.420729, 0.705621], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.480072, 0.744591, 0.0955222], 
       TagBox[{RectangleBox[{1.55, 6.55}, {2.45, 7.45}], InsetBox[
          StyleBox["\<\"Ca\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {2, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Ca" -> RGBColor[0.480072, 0.744591, 0.0955222], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.901961, 0.901961, 0.901961], 
       TagBox[{RectangleBox[{2.55, 6.55}, {3.45, 7.45}], InsetBox[
          StyleBox["\<\"Sc\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {3, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Sc" -> RGBColor[0.901961, 0.901961, 0.901961], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.74902, 0.760784, 0.780392], 
       TagBox[{RectangleBox[{3.55, 6.55}, {4.45, 7.45}], InsetBox[
          StyleBox["\<\"Ti\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {4, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Ti" -> RGBColor[0.74902, 0.760784, 0.780392], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.65098, 0.65098, 0.670588], 
       TagBox[{RectangleBox[{4.55, 6.55}, {5.45, 7.45}], InsetBox[
          StyleBox["\<\"V\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {5, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["V" -> RGBColor[0.65098, 0.65098, 0.670588], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.541176, 0.6, 0.780392], 
       TagBox[{RectangleBox[{5.55, 6.55}, {6.45, 7.45}], InsetBox[
          StyleBox["\<\"Cr\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {6, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Cr" -> RGBColor[0.541176, 0.6, 0.780392], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.611765, 0.478431, 0.780392], 
       TagBox[{RectangleBox[{6.55, 6.55}, {7.45, 7.45}], InsetBox[
          StyleBox["\<\"Mn\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {7, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Mn" -> RGBColor[0.611765, 0.478431, 0.780392], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.878431, 0.4, 0.2], 
       TagBox[{RectangleBox[{7.55, 6.55}, {8.45, 7.45}], InsetBox[
          StyleBox["\<\"Fe\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {8, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Fe" -> RGBColor[0.878431, 0.4, 0.2], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.941176, 0.564706, 0.627451], 
       TagBox[{RectangleBox[{8.55, 6.55}, {9.45, 7.45}], InsetBox[
          StyleBox["\<\"Co\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {9, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Co" -> RGBColor[0.941176, 0.564706, 0.627451], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.313725, 0.815686, 0.313725], 
       TagBox[{RectangleBox[{9.55, 6.55}, {10.45, 7.45}], InsetBox[
          StyleBox["\<\"Ni\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {10, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Ni" -> RGBColor[0.313725, 0.815686, 0.313725], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.784314, 0.501961, 0.2], 
       TagBox[{RectangleBox[{10.55, 6.55}, {11.45, 7.45}], InsetBox[
          StyleBox["\<\"Cu\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {11, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Cu" -> RGBColor[0.784314, 0.501961, 0.2], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.490196, 0.501961, 0.690196], 
       TagBox[{RectangleBox[{11.55, 6.55}, {12.45, 7.45}], InsetBox[
          StyleBox["\<\"Zn\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {12, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Zn" -> RGBColor[0.490196, 0.501961, 0.690196], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.800757, 0.542666, 0.533513], 
       TagBox[{RectangleBox[{12.55, 6.55}, {13.45, 7.45}], InsetBox[
          StyleBox["\<\"Ga\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {13, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Ga" -> RGBColor[0.800757, 0.542666, 0.533513], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.60508, 0.632465, 0.576489], 
       TagBox[{RectangleBox[{13.55, 6.55}, {14.45, 7.45}], InsetBox[
          StyleBox["\<\"Ge\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {14, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Ge" -> RGBColor[0.60508, 0.632465, 0.576489], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.741176, 0.501961, 0.890196], 
       TagBox[{RectangleBox[{14.55, 6.55}, {15.45, 7.45}], InsetBox[
          StyleBox["\<\"As\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {15, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["As" -> RGBColor[0.741176, 0.501961, 0.890196], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.917248, 0.657833, 0.0706628], 
       TagBox[{RectangleBox[{15.55, 6.55}, {16.45, 7.45}], InsetBox[
          StyleBox["\<\"Se\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {16, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Se" -> RGBColor[0.917248, 0.657833, 0.0706628], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.58847, 0.22163, 0.16064], 
       TagBox[{RectangleBox[{16.55, 6.55}, {17.45, 7.45}], InsetBox[
          StyleBox["\<\"Br\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {17, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Br" -> RGBColor[0.58847, 0.22163, 0.16064], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.426019, 0.747462, 0.810413], 
       TagBox[{RectangleBox[{17.55, 6.55}, {18.45, 7.45}], InsetBox[
          StyleBox["\<\"Kr\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {18, 7},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Kr" -> RGBColor[0.426019, 0.747462, 0.810413], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}}, {
      {RGBColor[0.425391, 0.329242, 0.585895], 
       TagBox[{RectangleBox[{0.55, 5.55}, {1.45, 6.45}], InsetBox[
          StyleBox["\<\"Rb\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {1, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Rb" -> RGBColor[0.425391, 0.329242, 0.585895], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.325959, 0.646423, 0.095983], 
       TagBox[{RectangleBox[{1.55, 5.55}, {2.45, 6.45}], InsetBox[
          StyleBox["\<\"Sr\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {2, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Sr" -> RGBColor[0.325959, 0.646423, 0.095983], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.531014, 1., 1.], 
       TagBox[{RectangleBox[{2.55, 5.55}, {3.45, 6.45}], InsetBox[
          StyleBox["\<\"Y\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {3, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Y" -> RGBColor[0.531014, 1., 1.], 2]]]), PassEventsDown -> 
          Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.458599, 0.917466, 0.918573], 
       TagBox[{RectangleBox[{3.55, 5.55}, {4.45, 6.45}], InsetBox[
          StyleBox["\<\"Zr\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {4, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Zr" -> RGBColor[0.458599, 0.917466, 0.918573], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.385036, 0.834854, 0.841681], 
       TagBox[{RectangleBox[{4.55, 5.55}, {5.45, 6.45}], InsetBox[
          StyleBox["\<\"Nb\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {5, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Nb" -> RGBColor[0.385036, 0.834854, 0.841681], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.310325, 0.752163, 0.769323], 
       TagBox[{RectangleBox[{5.55, 5.55}, {6.45, 6.45}], InsetBox[
          StyleBox["\<\"Mo\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {6, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Mo" -> RGBColor[0.310325, 0.752163, 0.769323], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.234466, 0.669394, 0.701499], 
       TagBox[{RectangleBox[{6.55, 5.55}, {7.45, 6.45}], InsetBox[
          StyleBox["\<\"Tc\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {7, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Tc" -> RGBColor[0.234466, 0.669394, 0.701499], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.157459, 0.586546, 0.638209], 
       TagBox[{RectangleBox[{7.55, 5.55}, {8.45, 6.45}], InsetBox[
          StyleBox["\<\"Ru\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {8, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Ru" -> RGBColor[0.157459, 0.586546, 0.638209], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.0793033, 0.50362, 0.579453], 
       TagBox[{RectangleBox[{8.55, 5.55}, {9.45, 6.45}], InsetBox[
          StyleBox["\<\"Rh\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {9, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Rh" -> RGBColor[0.0793033, 0.50362, 0.579453], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0., 0.420615, 0.525231], 
       TagBox[{RectangleBox[{9.55, 5.55}, {10.45, 6.45}], InsetBox[
          StyleBox["\<\"Pd\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {10, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Pd" -> RGBColor[0., 0.420615, 0.525231], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.752941, 0.752941, 0.752941], 
       TagBox[{RectangleBox[{10.55, 5.55}, {11.45, 6.45}], InsetBox[
          StyleBox["\<\"Ag\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {11, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Ag" -> RGBColor[0.752941, 0.752941, 0.752941], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[1., 0.85098, 0.560784], 
       TagBox[{RectangleBox[{11.55, 5.55}, {12.45, 6.45}], InsetBox[
          StyleBox["\<\"Cd\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {12, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Cd" -> RGBColor[1., 0.85098, 0.560784], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.728371, 0.440594, 0.422196], 
       TagBox[{RectangleBox[{12.55, 5.55}, {13.45, 6.45}], InsetBox[
          StyleBox["\<\"In\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {13, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["In" -> RGBColor[0.728371, 0.440594, 0.422196], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.39799, 0.491477, 0.495586], 
       TagBox[{RectangleBox[{13.55, 5.55}, {14.45, 6.45}], InsetBox[
          StyleBox["\<\"Sn\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {14, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Sn" -> RGBColor[0.39799, 0.491477, 0.495586], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.619608, 0.388235, 0.709804], 
       TagBox[{RectangleBox[{14.55, 5.55}, {15.45, 6.45}], InsetBox[
          StyleBox["\<\"Sb\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {15, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Sb" -> RGBColor[0.619608, 0.388235, 0.709804], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.816706, 0.451332, 0.0100947], 
       TagBox[{RectangleBox[{15.55, 5.55}, {16.45, 6.45}], InsetBox[
          StyleBox["\<\"Te\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {16, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Te" -> RGBColor[0.816706, 0.451332, 0.0100947], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.580392, 0, 0.580392], 
       TagBox[{RectangleBox[{16.55, 5.55}, {17.45, 6.45}], InsetBox[
          StyleBox["\<\"I\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {17, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["I" -> RGBColor[0.580392, 0, 0.580392], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.316906, 0.638078, 0.710252], 
       TagBox[{RectangleBox[{17.55, 5.55}, {18.45, 6.45}], InsetBox[
          StyleBox["\<\"Xe\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {18, 6},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Xe" -> RGBColor[0.316906, 0.638078, 0.710252], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}}, {
      {RGBColor[0.332803, 0.217712, 0.483666], 
       TagBox[{RectangleBox[{0.55, 4.55}, {1.45, 5.45}], InsetBox[
          StyleBox["\<\"Cs\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {1, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Cs" -> RGBColor[0.332803, 0.217712, 0.483666], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.165935, 0.55605, 0.0796556], 
       TagBox[{RectangleBox[{1.55, 4.55}, {2.45, 5.45}], InsetBox[
          StyleBox["\<\"Ba\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {2, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Ba" -> RGBColor[0.165935, 0.55605, 0.0796556], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, {}, 
      {RGBColor[0.781537, 0.717388, 0.716579], 
       TagBox[{RectangleBox[{3.55, 4.55}, {4.45, 5.45}], InsetBox[
          StyleBox["\<\"Hf\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {4, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Hf" -> RGBColor[0.781537, 0.717388, 0.716579], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.734443, 0.544489, 0.683471], 
       TagBox[{RectangleBox[{4.55, 4.55}, {5.45, 5.45}], InsetBox[
          StyleBox["\<\"Ta\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {5, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Ta" -> RGBColor[0.734443, 0.544489, 0.683471], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.681179, 0.360409, 0.63675], 
       TagBox[{RectangleBox[{5.55, 4.55}, {6.45, 5.45}], InsetBox[
          StyleBox["\<\"W\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {6, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["W" -> RGBColor[0.681179, 0.360409, 0.63675], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.605181, 0.367584, 0.556343], 
       TagBox[{RectangleBox[{6.55, 4.55}, {7.45, 5.45}], InsetBox[
          StyleBox["\<\"Re\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {7, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Re" -> RGBColor[0.605181, 0.367584, 0.556343], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.521806, 0.382125, 0.469204], 
       TagBox[{RectangleBox[{7.55, 4.55}, {8.45, 5.45}], InsetBox[
          StyleBox["\<\"Os\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {8, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Os" -> RGBColor[0.521806, 0.382125, 0.469204], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.445624, 0.373159, 0.399069], 
       TagBox[{RectangleBox[{8.55, 4.55}, {9.45, 5.45}], InsetBox[
          StyleBox["\<\"Ir\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {9, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Ir" -> RGBColor[0.445624, 0.373159, 0.399069], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.815686, 0.815686, 0.878431], 
       TagBox[{RectangleBox[{9.55, 4.55}, {10.45, 5.45}], InsetBox[
          StyleBox["\<\"Pt\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {10, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Pt" -> RGBColor[0.815686, 0.815686, 0.878431], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[1., 0.819608, 0.137255], 
       TagBox[{RectangleBox[{10.55, 4.55}, {11.45, 5.45}], InsetBox[
          StyleBox["\<\"Au\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {11, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Au" -> RGBColor[1., 0.819608, 0.137255], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.721569, 0.721569, 0.815686], 
       TagBox[{RectangleBox[{11.55, 4.55}, {12.45, 5.45}], InsetBox[
          StyleBox["\<\"Hg\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {12, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Hg" -> RGBColor[0.721569, 0.721569, 0.815686], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.65098, 0.329412, 0.301961], 
       TagBox[{RectangleBox[{12.55, 4.55}, {13.45, 5.45}], InsetBox[
          StyleBox["\<\"Tl\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {13, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Tl" -> RGBColor[0.65098, 0.329412, 0.301961], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.341176, 0.34902, 0.380392], 
       TagBox[{RectangleBox[{13.55, 4.55}, {14.45, 5.45}], InsetBox[
          StyleBox["\<\"Pb\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {14, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Pb" -> RGBColor[0.341176, 0.34902, 0.380392], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.619608, 0.309804, 0.709804], 
       TagBox[{RectangleBox[{14.55, 4.55}, {15.45, 5.45}], InsetBox[
          StyleBox["\<\"Bi\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {15, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Bi" -> RGBColor[0.619608, 0.309804, 0.709804], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.670588, 0.360784, 0], 
       TagBox[{RectangleBox[{15.55, 4.55}, {16.45, 5.45}], InsetBox[
          StyleBox["\<\"Po\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {16, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Po" -> RGBColor[0.670588, 0.360784, 0], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.458824, 0.309804, 0.270588], 
       TagBox[{RectangleBox[{16.55, 4.55}, {17.45, 5.45}], InsetBox[
          StyleBox["\<\"At\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {17, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["At" -> RGBColor[0.458824, 0.309804, 0.270588], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.218799, 0.516091, 0.591608], 
       TagBox[{RectangleBox[{17.55, 4.55}, {18.45, 5.45}], InsetBox[
          StyleBox["\<\"Rn\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {18, 5},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Rn" -> RGBColor[0.218799, 0.516091, 0.591608], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}}, {
      {RGBColor[0.25626, 0.0861372, 0.398932], 
       TagBox[{RectangleBox[{0.55, 3.55}, {1.45, 4.45}], InsetBox[
          StyleBox["\<\"Fr\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {1, 4},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Fr" -> RGBColor[0.25626, 0.0861372, 0.398932], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0., 0.473472, 0.04654], 
       TagBox[{RectangleBox[{1.55, 3.55}, {2.45, 4.45}], InsetBox[
          StyleBox["\<\"Ra\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {2, 4},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Ra" -> RGBColor[0., 0.473472, 0.04654], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, {}, 
      {RGBColor[0.684106, 0.206907, 0.445606], 
       TagBox[{RectangleBox[{3.55, 3.55}, {4.45, 4.45}], InsetBox[
          StyleBox["\<\"Rf\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {4, 4},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Rf" -> RGBColor[0.684106, 0.206907, 0.445606], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.691534, 0.185783, 0.420025], 
       TagBox[{RectangleBox[{4.55, 3.55}, {5.45, 4.45}], InsetBox[
          StyleBox["\<\"Db\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {5, 4},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Db" -> RGBColor[0.691534, 0.185783, 0.420025], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.696874, 0.166269, 0.395772], 
       TagBox[{RectangleBox[{5.55, 3.55}, {6.45, 4.45}], InsetBox[
          StyleBox["\<\"Sg\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {6, 4},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Sg" -> RGBColor[0.696874, 0.166269, 0.395772], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.700126, 0.148365, 0.372844], 
       TagBox[{RectangleBox[{6.55, 3.55}, {7.45, 4.45}], InsetBox[
          StyleBox["\<\"Bh\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {7, 4},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Bh" -> RGBColor[0.700126, 0.148365, 0.372844], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.701289, 0.13207, 0.351243], 
       TagBox[{RectangleBox[{7.55, 3.55}, {8.45, 4.45}], InsetBox[
          StyleBox["\<\"Hs\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {8, 4},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Hs" -> RGBColor[0.701289, 0.13207, 0.351243], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.700363, 0.117385, 0.330968], 
       TagBox[{RectangleBox[{8.55, 3.55}, {9.45, 4.45}], InsetBox[
          StyleBox["\<\"Mt\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {9, 4},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Mt" -> RGBColor[0.700363, 0.117385, 0.330968], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.697348, 0.10431, 0.31202], 
       TagBox[{RectangleBox[{9.55, 3.55}, {10.45, 4.45}], InsetBox[
          StyleBox["\<\"Ds\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {10, 4},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Ds" -> RGBColor[0.697348, 0.10431, 0.31202], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.692245, 0.0928444, 0.294398], 
       TagBox[{RectangleBox[{10.55, 3.55}, {11.45, 4.45}], InsetBox[
          StyleBox["\<\"Rg\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {11, 4},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Rg" -> RGBColor[0.692245, 0.0928444, 0.294398], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.685054, 0.0829886, 0.278102], 
       TagBox[{RectangleBox[{11.55, 3.55}, {12.45, 4.45}], InsetBox[
          StyleBox["\<\"Uub\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {12, 4},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Uub" -> RGBColor[0.685054, 0.0829886, 0.278102], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.675773, 0.0747426, 0.263133], 
       TagBox[{RectangleBox[{12.55, 3.55}, {13.45, 4.45}], InsetBox[
          StyleBox["\<\"Uut\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {13, 4},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Uut" -> RGBColor[0.675773, 0.0747426, 0.263133], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.664405, 0.0681063, 0.249491], 
       TagBox[{RectangleBox[{13.55, 3.55}, {14.45, 4.45}], InsetBox[
          StyleBox["\<\"Uuq\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {14, 4},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Uuq" -> RGBColor[0.664405, 0.0681063, 0.249491], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.650947, 0.0630797, 0.237174], 
       TagBox[{RectangleBox[{14.55, 3.55}, {15.45, 4.45}], InsetBox[
          StyleBox["\<\"Uup\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {15, 4},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Uup" -> RGBColor[0.650947, 0.0630797, 0.237174], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.635401, 0.0596628, 0.226184], 
       TagBox[{RectangleBox[{15.55, 3.55}, {16.45, 4.45}], InsetBox[
          StyleBox["\<\"Uuh\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {16, 4},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Uuh" -> RGBColor[0.635401, 0.0596628, 0.226184], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> 
          True}]]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}}, {{}, {}, 
      {RGBColor[0.928084, 0.716075, 0.329427], 
       TagBox[{RectangleBox[{2.55, 1.55}, {3.45, 2.45}], InsetBox[
          StyleBox["\<\"La\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {3, 2},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["La" -> RGBColor[0.928084, 0.716075, 0.329427], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.894824, 0.731424, 0.325131], 
       TagBox[{RectangleBox[{3.55, 1.55}, {4.45, 2.45}], InsetBox[
          StyleBox["\<\"Ce\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {4, 2},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Ce" -> RGBColor[0.894824, 0.731424, 0.325131], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.86523, 0.707999, 0.315261], 
       TagBox[{RectangleBox[{4.55, 1.55}, {5.45, 2.45}], InsetBox[
          StyleBox["\<\"Pr\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {5, 2},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Pr" -> RGBColor[0.86523, 0.707999, 0.315261], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.837836, 0.662974, 0.301635], 
       TagBox[{RectangleBox[{5.55, 1.55}, {6.45, 2.45}], InsetBox[
          StyleBox["\<\"Nd\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {6, 2},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Nd" -> RGBColor[0.837836, 0.662974, 0.301635], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.811992, 0.607859, 0.285626], 
       TagBox[{RectangleBox[{6.55, 1.55}, {7.45, 2.45}], InsetBox[
          StyleBox["\<\"Pm\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {7, 2},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Pm" -> RGBColor[0.811992, 0.607859, 0.285626], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.787563, 0.549894, 0.268279], 
       TagBox[{RectangleBox[{7.55, 1.55}, {8.45, 2.45}], InsetBox[
          StyleBox["\<\"Sm\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {8, 2},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Sm" -> RGBColor[0.787563, 0.549894, 0.268279], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.764628, 0.493261, 0.250405], 
       TagBox[{RectangleBox[{8.55, 1.55}, {9.45, 2.45}], InsetBox[
          StyleBox["\<\"Eu\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {9, 2},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Eu" -> RGBColor[0.764628, 0.493261, 0.250405], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.743177, 0.440115, 0.23269], 
       TagBox[{RectangleBox[{9.55, 1.55}, {10.45, 2.45}], InsetBox[
          StyleBox["\<\"Gd\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {10, 2},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Gd" -> RGBColor[0.743177, 0.440115, 0.23269], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.72281, 0.39143, 0.215783], 
       TagBox[{RectangleBox[{10.55, 1.55}, {11.45, 2.45}], InsetBox[
          StyleBox["\<\"Tb\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {11, 2},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Tb" -> RGBColor[0.72281, 0.39143, 0.215783], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.702434, 0.347663, 0.200392], 
       TagBox[{RectangleBox[{11.55, 1.55}, {12.45, 2.45}], InsetBox[
          StyleBox["\<\"Dy\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {12, 2},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Dy" -> RGBColor[0.702434, 0.347663, 0.200392], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.679962, 0.309234, 0.187368], 
       TagBox[{RectangleBox[{12.55, 1.55}, {13.45, 2.45}], InsetBox[
          StyleBox["\<\"Ho\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {13, 2},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Ho" -> RGBColor[0.679962, 0.309234, 0.187368], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.652012, 0.276823, 0.17779], 
       TagBox[{RectangleBox[{13.55, 1.55}, {14.45, 2.45}], InsetBox[
          StyleBox["\<\"Er\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {14, 2},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Er" -> RGBColor[0.652012, 0.276823, 0.17779], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.613603, 0.251489, 0.173042], 
       TagBox[{RectangleBox[{14.55, 1.55}, {15.45, 2.45}], InsetBox[
          StyleBox["\<\"Tm\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {15, 2},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Tm" -> RGBColor[0.613603, 0.251489, 0.173042], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.557855, 0.234598, 0.17489], 
       TagBox[{RectangleBox[{15.55, 1.55}, {16.45, 2.45}], InsetBox[
          StyleBox["\<\"Yb\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {16, 2},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Yb" -> RGBColor[0.557855, 0.234598, 0.17489], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.475685, 0.227573, 0.18555], 
       TagBox[{RectangleBox[{16.55, 1.55}, {17.45, 2.45}], InsetBox[
          StyleBox["\<\"Lu\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {17, 2},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Lu" -> RGBColor[0.475685, 0.227573, 0.18555], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> 
          True}]]}, {}}, {{}, {}, 
      {RGBColor[0.322042, 0.71693, 0.988479], 
       TagBox[{RectangleBox[{2.55, 0.55}, {3.45, 1.45}], InsetBox[
          StyleBox["\<\"Ac\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {3, 1},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Ac" -> RGBColor[0.322042, 0.71693, 0.988479], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.3608, 0.67166, 0.943003], 
       TagBox[{RectangleBox[{3.55, 0.55}, {4.45, 1.45}], InsetBox[
          StyleBox["\<\"Th\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {4, 1},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Th" -> RGBColor[0.3608, 0.67166, 0.943003], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.397469, 0.628, 0.898853], 
       TagBox[{RectangleBox[{4.55, 0.55}, {5.45, 1.45}], InsetBox[
          StyleBox["\<\"Pa\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {5, 1},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Pa" -> RGBColor[0.397469, 0.628, 0.898853], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.43205, 0.58595, 0.856029], 
       TagBox[{RectangleBox[{5.55, 0.55}, {6.45, 1.45}], InsetBox[
          StyleBox["\<\"U\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {6, 1},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["U" -> RGBColor[0.43205, 0.58595, 0.856029], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.464542, 0.54551, 0.814532], 
       TagBox[{RectangleBox[{6.55, 0.55}, {7.45, 1.45}], InsetBox[
          StyleBox["\<\"Np\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {7, 1},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Np" -> RGBColor[0.464542, 0.54551, 0.814532], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.494945, 0.506679, 0.774361], 
       TagBox[{RectangleBox[{7.55, 0.55}, {8.45, 1.45}], InsetBox[
          StyleBox["\<\"Pu\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {8, 1},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Pu" -> RGBColor[0.494945, 0.506679, 0.774361], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.52326, 0.469458, 0.735517], 
       TagBox[{RectangleBox[{8.55, 0.55}, {9.45, 1.45}], InsetBox[
          StyleBox["\<\"Am\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.2],
           BackFaceColor->GrayLevel[0.2],
           GraphicsColor->GrayLevel[0.2],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.2]], {9, 1},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Am" -> RGBColor[0.52326, 0.469458, 0.735517], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.549486, 0.433847, 0.697999], 
       TagBox[{RectangleBox[{9.55, 0.55}, {10.45, 1.45}], InsetBox[
          StyleBox["\<\"Cm\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {10, 1},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Cm" -> RGBColor[0.549486, 0.433847, 0.697999], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.573624, 0.399845, 0.661808], 
       TagBox[{RectangleBox[{10.55, 0.55}, {11.45, 1.45}], InsetBox[
          StyleBox["\<\"Bk\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {11, 1},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Bk" -> RGBColor[0.573624, 0.399845, 0.661808], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.595673, 0.367454, 0.626942], 
       TagBox[{RectangleBox[{11.55, 0.55}, {12.45, 1.45}], InsetBox[
          StyleBox["\<\"Cf\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {12, 1},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Cf" -> RGBColor[0.595673, 0.367454, 0.626942], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.615633, 0.336672, 0.593404], 
       TagBox[{RectangleBox[{12.55, 0.55}, {13.45, 1.45}], InsetBox[
          StyleBox["\<\"Es\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {13, 1},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Es" -> RGBColor[0.615633, 0.336672, 0.593404], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.633505, 0.307499, 0.561191], 
       TagBox[{RectangleBox[{13.55, 0.55}, {14.45, 1.45}], InsetBox[
          StyleBox["\<\"Fm\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {14, 1},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Fm" -> RGBColor[0.633505, 0.307499, 0.561191], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.649288, 0.279937, 0.530305], 
       TagBox[{RectangleBox[{14.55, 0.55}, {15.45, 1.45}], InsetBox[
          StyleBox["\<\"Md\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {15, 1},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Md" -> RGBColor[0.649288, 0.279937, 0.530305], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.662982, 0.253984, 0.500746], 
       TagBox[{RectangleBox[{15.55, 0.55}, {16.45, 1.45}], InsetBox[
          StyleBox["\<\"No\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {16, 1},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["No" -> RGBColor[0.662982, 0.253984, 0.500746], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, 
      {RGBColor[0.674588, 0.22964, 0.472513], 
       TagBox[{RectangleBox[{16.55, 0.55}, {17.45, 1.45}], InsetBox[
          StyleBox["\<\"Lr\"\>",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.85],
           BackFaceColor->GrayLevel[0.85],
           GraphicsColor->GrayLevel[0.85],
           FontFamily->"Helvetica",
           FontSize->Scaled[0.022],
           FontWeight->Bold,
           FontColor->GrayLevel[0.85]], {17, 1},
          Alignment->{Center, Center}]},
        EventHandlerTag[{"MouseClicked" :> (SelectionMove[
             ButtonNotebook[], After, ButtonCell]; NotebookWrite[
             ButtonNotebook[], 
             ToBoxes[
              Part["Lr" -> RGBColor[0.674588, 0.22964, 0.472513], 2]]]), 
          PassEventsDown -> Automatic, PassEventsUp -> True}]]}, {}}},
    ContentSelectable->False,
    PlotRangePadding->None],
   StripOnInput->False,
   CacheGraphics->False],
  FrameMargins->Automatic]], "Output",
 ImageSize->{326, 191},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[1]=",
 CellID->93717229]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\"\<Osmium\>\"", ",", "\"\<IconColor\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->223111928],

Cell[BoxData[
 RowBox[{"RGBColor", "[", 
  RowBox[{"0.521806`", ",", "0.382125`", ",", "0.469204`"}], "]"}]], "Output",\

 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->999954552]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->659161659],

Cell["\<\
Using non-standard element and property names will not work: \
\>", "ExampleText",
 CellID->1329051991],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\"\<hydrogen\>\"", ",", "\"\<Density\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->46500988],

Cell[BoxData[
 RowBox[{
  RowBox[{"ElementData", "::", "\<\"notent\"\>"}], ":", 
  " ", "\<\"\\!\\(\\\"\\\\\\\"hydrogen\\\\\\\"\\\"\\) is not a known entity, \
class, or tag for \\!\\(ElementData\\). Use \\!\\(ElementData\\)[] for a list \
of entities.\"\>"}]], "Message", "MSG",
 CellID->29134042],

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\<\"hydrogen\"\>", ",", "\<\"Density\"\>"}], "]"}]], "Output",
 ImageSize->{212, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29572378]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\"\<Carbon\>\"", ",", " ", "\"\<melting point\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->222925477],

Cell[BoxData[
 RowBox[{
  RowBox[{"ElementData", "::", "\<\"notprop\"\>"}], ":", 
  " ", "\<\"\\!\\(\\\"\\\\\\\"melting point\\\\\\\"\\\"\\) is not a known \
property for \\!\\(ElementData\\). Use \
\\!\\(ElementData\\)[\\\"Properties\\\"] for a list of properties.\"\>"}]], \
"Message", "MSG",
 CellID->954234589],

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\<\"Carbon\"\>", ",", "\<\"melting point\"\>"}], "]"}]], "Output",
 ImageSize->{240, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->412861527]
}, Open  ]],

Cell["Use string functions to find the standardized names: ", "ExampleText",
 CellID->173046581],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"ElementData", "[", "]"}], ",", 
   RowBox[{
    RowBox[{"StringMatchQ", "[", 
     RowBox[{"#", ",", 
      RowBox[{"___", "~~", "\"\<hydrogen\>\"", "~~", "___"}], ",", 
      RowBox[{"IgnoreCase", "\[Rule]", "True"}]}], "]"}], "&"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->135247669],

Cell[BoxData[
 RowBox[{"{", "\<\"Hydrogen\"\>", "}"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->444020832]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\"\<Hydrogen\>\"", ",", "\"\<Density\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->375830393],

Cell[BoxData["0.0899`2.9999999999999996"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->152450099]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"ElementData", "[", 
    RowBox[{"\"\<Carbon\>\"", ",", "\"\<Properties\>\""}], "]"}], ",", 
   RowBox[{
    RowBox[{"StringMatchQ", "[", 
     RowBox[{"#", ",", 
      RowBox[{"___", "~~", "\"\<melting\>\"", "~~", "___"}], ",", 
      RowBox[{"IgnoreCase", "\[Rule]", "True"}]}], "]"}], "&"}]}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->57009403],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AbsoluteMeltingPoint\"\>", ",", "\<\"MeltingPoint\"\>"}], 
  "}"}]], "Output",
 ImageSize->{254, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->280823022]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementData", "[", 
  RowBox[{"\"\<Carbon\>\"", ",", "\"\<MeltingPoint\>\""}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->205300593],

Cell[BoxData["3550.`3.9999999999999996"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1770958295]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->740563479],

Cell[TextData[{
 "Arithmetical operations cannot be carried out on ",
 Cell[BoxData[
  ButtonBox["Missing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Missing"]], "InlineFormula"],
 " entries:"
}], "ExampleText",
 CellID->1025458525],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"72", " ", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ElementData", "[", 
     RowBox[{"i", ",", "\"\<Resistivity\>\""}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1325162500],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"72", " ", 
    RowBox[{"Missing", "[", "\<\"NotApplicable\"\>", "]"}]}], ",", 
   RowBox[{"72", " ", 
    RowBox[{"Missing", "[", "\<\"NotApplicable\"\>", "]"}]}], ",", 
   "6.7680000000012`1.9999999999999998*^-6", ",", 
   "2.8799999999985`1.9999999999999998*^-6", ",", "720000.`5.000000000000002",
    ",", "0.0007200000000000019`1.9999999999999998", ",", 
   RowBox[{"72", " ", 
    RowBox[{"Missing", "[", "\<\"NotApplicable\"\>", "]"}]}], ",", 
   RowBox[{"72", " ", 
    RowBox[{"Missing", "[", "\<\"NotApplicable\"\>", "]"}]}], ",", 
   RowBox[{"72", " ", 
    RowBox[{"Missing", "[", "\<\"NotApplicable\"\>", "]"}]}], ",", 
   RowBox[{"72", " ", 
    RowBox[{"Missing", "[", "\<\"NotApplicable\"\>", "]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{554, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->372716645]
}, Open  ]],

Cell[TextData[{
 "Remove the ",
 Cell[BoxData[
  ButtonBox["Missing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Missing"]], "InlineFormula"],
 " entries before performing operations: "
}], "ExampleText",
 CellID->85509328],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeleteCases", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"ElementData", "[", 
      RowBox[{"i", ",", "\"\<Resistivity\>\""}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "10"}], "}"}]}], "]"}], ",", "_Missing"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->548645387],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "9.4`1.9999999999999998*^-8", ",", "4.`1.9999999999999998*^-8", ",", 
   "10000.`5.000000000000002", ",", "0.00001`1.9999999999999998"}], 
  "}"}]], "Output",
 ImageSize->{266, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->38854216]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"72", " ", "%"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->60605648],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "6.7680000000012`1.9999999999999998*^-6", ",", 
   "2.8799999999985`1.9999999999999998*^-6", ",", "720000.`5.000000000000002",
    ",", "0.0007200000000000019`1.9999999999999998"}], "}"}]], "Output",
 ImageSize->{287, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->187779624]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->160163481],

Cell["Plot the discovery years for successive elements:", "ExampleText",
 CellID->355083364],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ElementData", "[", 
     RowBox[{"z", ",", "\"\<DiscoveryYear\>\""}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "1", ",", "108"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->696443128],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., 1766.}, {2., 1895.}, {3., 1817.}, {4., 1797.}, {5., 
     1808.}}], 
    LineBox[{{7., 1772.}, {8., 1774.}, {9., 1886.}, {10., 1898.}, {11., 
     1807.}, {12., 1755.}, {13., 1825.}, {14., 1824.}, {15., 1669.}, {
     15.072637159981559`, 1511.4500000000003`}}], 
    LineBox[{{16.884542656112576`, 1511.4500000000003`}, {17., 1774.}, {18., 
     1894.}, {19., 1807.}, {20., 1808.}, {21., 1879.}, {22., 1791.}, {23., 
     1801.}, {24., 1797.}, {25., 1774.}, {25.069568097509276`, 
     1511.4500000000003`}}], 
    LineBox[{{26.940147255689425`, 1511.4500000000003`}, {27., 1735.}, {28., 
     1751.}, {28.02456671110655, 1511.4500000000003`}}], 
    LineBox[{{30.030533333333334`, 1511.4500000000003`}, {31., 1875.}, {32., 
     1886.}, {32.58891509433962, 1511.4500000000003`}}], 
    LineBox[{{33.46111111111111, 1511.4500000000003`}, {34., 1817.}, {35., 
     1826.}, {36., 1898.}, {37., 1861.}, {38., 1790.}, {39., 1794.}, {40., 
     1789.}, {41., 1801.}, {42., 1781.}, {43., 1937.}, {44., 1844.}, {45., 
     1803.}, {46., 1803.}, {46.06070164480533, 1511.4500000000003`}}], 
    LineBox[{{47.93656840357069, 1511.4500000000003`}, {48., 1817.}, {49., 
     1863.}, {49.07229076701624, 1511.4500000000003`}}], 
    LineBox[{{51.9432260087811, 1511.4500000000003`}, {52., 1783.}, {53., 
     1811.}, {54., 1898.}, {55., 1860.}, {56., 1808.}, {57., 1839.}, {58., 
     1803.}, {59., 1885.}, {60., 1885.}, {61., 1945.}, {62., 1879.}, {63., 
     1901.}, {64., 1880.}, {65., 1843.}, {66., 1886.}, {67., 1878.}, {68., 
     1842.}, {69., 1879.}, {70., 1878.}, {71., 1907.}, {72., 1923.}, {73., 
     1802.}, {74., 1783.}, {75., 1925.}, {76., 1803.}, {77., 1803.}, {78., 
     1735.}, {78.05278630460448, 1511.4500000000003`}}], 
    LineBox[{{80.89599821481701, 1511.4500000000003`}, {81., 1861.}, {
     81.05963999317522, 1511.4500000000003`}}], 
    LineBox[{{83.22379518072289, 1511.4500000000003`}, {84., 1898.}, {85., 
     1940.}, {86., 1900.}, {87., 1939.}, {88., 1898.}, {89., 1899.}, {90., 
     1829.}, {91., 1913.}, {92., 1789.}, {93., 1940.}, {94., 1940.}, {95., 
     1944.}, {96., 1944.}, {97., 1949.}, {98., 1950.}, {99., 1952.}, {100., 
     1952.}, {101., 1955.}, {102., 1958.}, {103., 1961.}, {104., 1964.}, {
     105., 1967.}, {106., 1974.}, {107., 1981.}, {108., 1984.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 1600.},
  ImageSize->{233., Automatic},
  PlotRange->{{0., 108.}, {1511.4500000000003`, 1984.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{237, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1358663125]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5688417],

Cell["Find how many elements were discovered in each country:", "ExampleText",
 CellID->506055598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SortBy", "[", 
  RowBox[{
   RowBox[{"Tally", "[", 
    RowBox[{"Flatten", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"ElementData", "[", 
        RowBox[{"z", ",", "\"\<DiscoveryCountries\>\""}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "1", ",", "108"}], "}"}]}], "]"}], "]"}], "]"}], 
   ",", "Last"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->103895441],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Finland\"\>", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Italy\"\>", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Mexico\"\>", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Peru\"\>", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Romania\"\>", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Spain\"\>", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Austria\"\>", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Denmark\"\>", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Russia\"\>", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Switzerland\"\>", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"France\"\>", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Germany\"\>", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UnitedStates\"\>", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Sweden\"\>", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UnitedKingdom\"\>", ",", "23"}], "}"}]}], "}"}]], "Output",
 ImageSize->{506, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->857523324]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->94446453],

Cell["Make a table of 3 properties of elements:", "ExampleText",
 CellID->255019254],

Cell[BoxData[
 RowBox[{
  RowBox[{"tab", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "100"}], "}"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"ElementData", "[", 
            RowBox[{"z", ",", "#"}], "]"}], "&"}], "/@", 
          RowBox[{"{", 
           RowBox[{
           "\"\<Density\>\"", ",", "\"\<BoilingPoint\>\"", ",", 
            "\"\<ThermalConductivity\>\""}], "}"}]}], ")"}]}], ")"}], 
      "\[Rule]", 
      RowBox[{"ElementData", "[", "z", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "1", ",", "80"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->44519215],

Cell["\<\
Cluster the elements into 10 groups based on the values of the properties:\
\>", "ExampleText",
 CellID->242109154],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{"tab", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->178456335],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Hydrogen\"\>", ",", "\<\"Helium\"\>", 
     ",", "\<\"Nitrogen\"\>", ",", "\<\"Oxygen\"\>", ",", "\<\"Fluorine\"\>", 
     ",", "\<\"Neon\"\>", ",", "\<\"Phosphorus\"\>", ",", "\<\"Sulfur\"\>", 
     ",", "\<\"Chlorine\"\>", ",", "\<\"Argon\"\>", ",", "\<\"Krypton\"\>", 
     ",", "\<\"Xenon\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Lithium\"\>", ",", "\<\"Potassium\"\>", 
     ",", "\<\"Rubidium\"\>", ",", "\<\"Cesium\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Beryllium\"\>", ",", "\<\"Carbon\"\>", ",", "\<\"Sodium\"\>",
      ",", "\<\"Magnesium\"\>", ",", "\<\"Aluminum\"\>", 
     ",", "\<\"Silicon\"\>", ",", "\<\"Calcium\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Boron\"\>", ",", "\<\"Scandium\"\>", ",", "\<\"Titanium\"\>",
      ",", "\<\"Selenium\"\>", ",", "\<\"Bromine\"\>", 
     ",", "\<\"Strontium\"\>", ",", "\<\"Yttrium\"\>", ",", "\<\"Iodine\"\>", 
     ",", "\<\"Barium\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Vanadium\"\>", ",", "\<\"Germanium\"\>", 
     ",", "\<\"Zirconium\"\>", ",", "\<\"Niobium\"\>", 
     ",", "\<\"Lanthanum\"\>", ",", "\<\"Cerium\"\>", 
     ",", "\<\"Praseodymium\"\>", ",", "\<\"Neodymium\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Chromium\"\>", ",", "\<\"Iron\"\>", ",", "\<\"Cobalt\"\>", 
     ",", "\<\"Nickel\"\>", ",", "\<\"Zinc\"\>", ",", "\<\"Molybdenum\"\>", 
     ",", "\<\"Ruthenium\"\>", ",", "\<\"Rhodium\"\>", 
     ",", "\<\"Palladium\"\>", ",", "\<\"Cadmium\"\>", ",", "\<\"Indium\"\>", 
     ",", "\<\"Tin\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Manganese\"\>", ",", "\<\"Gallium\"\>", 
     ",", "\<\"Arsenic\"\>", ",", "\<\"Antimony\"\>", 
     ",", "\<\"Tellurium\"\>", ",", "\<\"Promethium\"\>", 
     ",", "\<\"Samarium\"\>", ",", "\<\"Europium\"\>", 
     ",", "\<\"Ytterbium\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Copper\"\>", ",", "\<\"Silver\"\>", ",", "\<\"Gold\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Technetium\"\>", ",", "\<\"Gadolinium\"\>", 
     ",", "\<\"Terbium\"\>", ",", "\<\"Dysprosium\"\>", 
     ",", "\<\"Holmium\"\>", ",", "\<\"Erbium\"\>", ",", "\<\"Thulium\"\>", 
     ",", "\<\"Lutetium\"\>", ",", "\<\"Hafnium\"\>", 
     ",", "\<\"Mercury\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Tantalum\"\>", ",", "\<\"Tungsten\"\>", 
     ",", "\<\"Rhenium\"\>", ",", "\<\"Osmium\"\>", ",", "\<\"Iridium\"\>", 
     ",", "\<\"Platinum\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{570, 186},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1118357663]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["IsotopeData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IsotopeData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ChemicalData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChemicalData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ParticleData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ParticleData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LatticeData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LatticeData"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->1584193535],

Cell[TextData[{
 ButtonBox["Demonstrations with ElementData",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=ElementData"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[ButtonBox["ElementData Source Information",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
ElementDataSourceInformation.html"], None}]], "RelatedLinks",
 CellID->1038487239]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Integrated Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataCollections"]], "MoreAbout",
 CellID->311688887],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataHandlingAndDataSources"]], "MoreAbout",
 CellID->205596695]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ElementData - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 39, 47.7603970}", "context" -> "System`", 
    "keywords" -> {
     "abbreviation", "absolute boiling point", "absolute melting point", 
      "abundance", "abundance in the sun", "abundances", "actinium", 
      "adiabatic index", "allotrope names", "allotropic molecules", 
      "allotropic multiplicities", "alternate names", 
      "alternate standard names", "aluminium", "aluminum", "americium", 
      "angles between crystallographic axes", 
      "antiferromagnet-paramagnet transition", 
      "antiferromagnetic-paramagnetic transition", "antimony", "argentum", 
      "argon", "arsenic", "astatine", "atomic", "atomic mass numbers", 
      "atomic mass units", "atomic number", "atomic radius", "atomic weight", 
      "atoms", "aurum", "average atomic weight", "barium", 
      "basic crystal lattice structure", "basic material color", "berkelium", 
      "beryllium", "bismuth", "block", "bohrium", "boiling point", 
      "boiling temperature", "bonded pair of atoms", "boron", 
      "Brinell hardness", "Brinell indentation hardness", "bromine", 
      "bulk modulus", "bulk modulus incompressibility", "cadmium", "caesium", 
      "calcium", "californium", "carbon", "carbonaceous meteorite abundance", 
      "CAS number", "CAS registry number", "cerium", "cesium", 
      "Chemical Abstract Service", "ChemicalElements", "chemical elements", 
      "chlorine", "chromium", "cobalt", "column in periodic table", 
      "common compound names", "copper", "covalent radius", 
      "critical pressure", "critical temperature", "crust abundance", 
      "crystal lattice constants", "crystal structure", "crystallographic", 
      "cuprum", "Curie point", "Curie temperature", "curium", "darmstadtium", 
      "decay mode", "density", "discovery countries", "discovery year", 
      "dominant decay mode", "dubnium", "dysprosium", 
      "Earth's crust abundance", "einsteinium", "electrical conductivity", 
      "electrical resistivity of solid", "electrical type", "electromagnetic",
       "electron affinity", "electron configuration", 
      "electron configuration string", "electron shell configuration", 
      "electron subshell", "electronegativity", "element table", 
      "English name", "erbium", "europium", "exponential lifetime", "fermium",
       "ferromagnet-paramagnet transition", 
      "ferromagnetic-paramagnetic transition", "ferrum", "fluorine", 
      "francium", "gadolinium", "gallium", "gas atomic multiplicities", 
      "gas phase adiabatic index", "gas-phase molecules", "germanium", "gold",
       "ground state angular momentum", "group", "hafnium", 
      "half-distance between nuclei", "half-life", 
      "hard sphere interatomic interaction range", "hassium", 
      "heat of fusion", "heat of vaporization", "helium", "holmium", 
      "human abundance", "hydrargyrum", "hydrogen", "icon color", "indium", 
      "International Tables space group number", "iodine", 
      "ionization energies", "iridium", "iron", "isotope abundances", 
      "kalium", "kelvin", "known isotopes", "krypton", "lanthanum", 
      "latent heat", "lattice angles", "lattice constants", "lawrencium", 
      "lead", "lifetime", "linear thermal expansion coefficient", 
      "liquid density", "liquid-gas critical point", "liquid-gas transition", 
      "lithium", "longest-lived isotope", "lutetium", "magnesium", 
      "magnetic response type", "magnetic type", "manganese", 
      "mass magnetic susceptibility", "mass number", "material", "meitnerium",
       "melting point", "melting temperature", "mendelevium", "mercury", 
      "meteorite abundance", "Mohs hardness", "Mohs scratch resistance", 
      "molar magnetic susceptibility", "molybdenum", "names of allotropes", 
      "names of common compounds", "natrium", "naturally occurring phase", 
      "Neel point", "Neel temperature", "neodymium", "neon", "neptunium", 
      "neutron cross-section", "neutron mass absorption", "nickel", "niobium",
       "nitrogen", "nobelium", "nuclear", "nucleus-electron distance", 
      "number of atoms", "number of chemical bonds", 
      "number of electron shells", "numbers of atoms", 
      "observed universe abundance", "occupation numbers", "ocean abundance", 
      "optical", "osmium", "outermost occupied subshell", "oxygen", 
      "palladium", "Pauling electronegativity", "period", "periodic table", 
      "phase", "phosphorus", "platinum", "plumbum", "plutonium", 
      "Poisson ratio of solid", "Poisson's ratio", "polonium", "potassium", 
      "praseodymium", "pressure", "promethium", "protactinium", 
      "quantum numbers", "radioactive", "radioactive in all forms", "radium", 
      "radon", "refractive index", "resistivity", "rhenium", "rhodium", 
      "roentgenium", "row in periodic table", "rubidium", "ruthenium", 
      "rutherfordium", "samarium", "scandium", "seaborgium", "selenium", 
      "shear modulus", "silicon", "silver", "sodium", "solar abundance", 
      "solid-liquid transition", "sound speed", "space group name", 
      "space group number", "space group symbol", "specific heat", 
      "specific heat capacity", "speed of sound", "stable isotopes", 
      "standard element abbreviation", "standard temperature and pressure", 
      "stannum", "stibium", "strontium", "sulfur", "sulphur", 
      "superconducting point", "superconducting transition temperature", 
      "tantalum", "technetium", "tellurium", "terbium", "thallium", 
      "thermal conductivity", "thermal expansion", 
      "thermal neutron cross-section", 
      "thermal neutron mass absorption coefficient", "thermodynamic ", 
      "thorium", "thulium", "tin", "titanium", "tungsten", 
      "typical human body abundance", "universe abundance", "ununbium", 
      "ununhexium", "ununoctium", "ununpentium", "ununquadium", "ununseptium",
       "ununtrium", "uranium", "valence", "vanadium", "Van der Waals radius", 
      "Vickers hardness", "Vickers indentation hardness", 
      "volume magnetic susceptibility", "wolfram", "xenon", 
      "year element was discovered", "Young's modulus", 
      "Young's modulus of a solid", "ytterbium", "yttrium", "zinc", 
      "zirconium"}, "index" -> True, "label" -> "Built-in Mathematica Symbol",
     "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "ElementData[\"name\", \" property\"] gives the value of the specified \
property for the chemical element \" name\". ElementData[n, \" property\"] \
gives the specified property for the n\\[Null]^th chemical element.", 
    "synonyms" -> {"element data"}, "title" -> "ElementData", "type" -> 
    "Symbol", "uri" -> "ref/ElementData"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[31467, 830, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->796003110]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 266729, 6777}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1715, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2338, 66, 1576, 37, 70, "ObjectNameGrid"],
Cell[3917, 105, 1270, 38, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5224, 148, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5702, 165, 145, 4, 70, "Notes",
 CellID->1067943069],
Cell[5850, 171, 275, 9, 70, "Notes",
 CellID->485978669],
Cell[6128, 182, 417, 15, 70, "Notes",
 CellID->74780324],
Cell[6548, 199, 291, 9, 70, "Notes",
 CellID->54231339],
Cell[6842, 210, 321, 11, 70, "Notes",
 CellID->48425469],
Cell[7166, 223, 738, 22, 70, "Notes",
 CellID->193117324],
Cell[7907, 247, 188, 4, 70, "Notes",
 CellID->286491208],
Cell[8098, 253, 70, 1, 70, "Notes",
 CellID->156536174],
Cell[8171, 256, 586, 14, 70, "2ColumnTableMod",
 CellID->120063746],
Cell[8760, 272, 286, 6, 70, "Notes",
 CellID->523829331],
Cell[9049, 280, 63, 1, 70, "Notes",
 CellID->6006833],
Cell[9115, 283, 2522, 61, 70, "2ColumnTableMod",
 CellID->867546879],
Cell[11640, 346, 70, 1, 70, "Notes",
 CellID->219479909],
Cell[11713, 349, 2559, 53, 70, "2ColumnTableMod",
 CellID->83366517],
Cell[14275, 404, 84, 1, 70, "Notes",
 CellID->375384097],
Cell[14362, 407, 2187, 55, 70, "2ColumnTableMod",
 CellID->504113991],
Cell[16552, 464, 95, 1, 70, "Notes",
 CellID->241081359],
Cell[16650, 467, 1002, 19, 70, "2ColumnTableMod",
 CellID->193211718],
Cell[17655, 488, 69, 1, 70, "Notes",
 CellID->3666451],
Cell[17727, 491, 639, 13, 70, "2ColumnTableMod",
 CellID->133619875],
Cell[18369, 506, 71, 1, 70, "Notes",
 CellID->117120805],
Cell[18443, 509, 1055, 19, 70, "2ColumnTableMod",
 CellID->175035396],
Cell[19501, 530, 112, 3, 70, "Notes",
 CellID->12844614],
Cell[19616, 535, 1242, 29, 70, "2ColumnTableMod",
 CellID->13778237],
Cell[20861, 566, 63, 1, 70, "Notes",
 CellID->170336351],
Cell[20927, 569, 1485, 26, 70, "2ColumnTableMod",
 CellID->88400451],
Cell[22415, 597, 64, 1, 70, "Notes",
 CellID->152932340],
Cell[22482, 600, 1562, 28, 70, "2ColumnTableMod",
 CellID->86798297],
Cell[24047, 630, 69, 1, 70, "Notes",
 CellID->73881988],
Cell[24119, 633, 1702, 45, 70, "2ColumnTableMod",
 CellID->166563264],
Cell[25824, 680, 81, 1, 70, "Notes",
 CellID->72025121],
Cell[25908, 683, 512, 11, 70, "2ColumnTableMod",
 CellID->370270706],
Cell[26423, 696, 941, 31, 70, "Notes",
 CellID->482514198],
Cell[27367, 729, 64, 1, 70, "Notes",
 CellID->91622357],
Cell[27434, 732, 1858, 38, 70, "2ColumnTableMod",
 CellID->1173142],
Cell[29295, 772, 456, 13, 70, "Notes",
 CellID->276644756],
Cell[29754, 787, 1676, 38, 70, "2ColumnTableMod",
 CellID->524183967]
}, Closed]],
Cell[CellGroupData[{
Cell[31467, 830, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->796003110],
Cell[CellGroupData[{
Cell[31852, 844, 148, 5, 70, "ExampleSection",
 CellID->475039054],
Cell[32003, 851, 76, 1, 70, "ExampleText",
 CellID->860716456],
Cell[CellGroupData[{
Cell[32104, 856, 162, 4, 28, "Input",
 CellID->219384717],
Cell[32269, 862, 182, 5, 36, "Output",
 CellID->240653761]
}, Open  ]],
Cell[32466, 870, 125, 3, 70, "ExampleDelimiter",
 CellID->187730611],
Cell[32594, 875, 99, 1, 70, "ExampleText",
 CellID->152549474],
Cell[CellGroupData[{
Cell[32718, 880, 174, 5, 70, "Input",
 CellID->727640411],
Cell[32895, 887, 180, 5, 36, "Output",
 CellID->956053826]
}, Open  ]],
Cell[33090, 895, 125, 3, 70, "ExampleDelimiter",
 CellID->585202192],
Cell[33218, 900, 133, 4, 70, "ExampleText",
 CellID->684057732],
Cell[CellGroupData[{
Cell[33376, 908, 302, 9, 70, "Input",
 CellID->239680026],
Cell[33681, 919, 1545, 34, 181, "Output",
 CellID->924006728]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[35275, 959, 221, 7, 70, "ExampleSection",
 CellID->649452527],
Cell[CellGroupData[{
Cell[35521, 970, 238, 7, 70, "ExampleSubsection",
 CellID->223414956],
Cell[35762, 979, 103, 2, 70, "ExampleText",
 CellID->303780252],
Cell[CellGroupData[{
Cell[35890, 985, 102, 3, 70, "Input",
 CellID->174295882],
Cell[35995, 990, 3288, 50, 275, "Output",
 CellID->1326826039]
}, Open  ]],
Cell[CellGroupData[{
Cell[39320, 1045, 101, 3, 70, "Input",
 CellID->49007095],
Cell[39424, 1050, 160, 5, 36, "Output",
 CellID->495047025]
}, Open  ]],
Cell[39599, 1058, 124, 3, 70, "ExampleDelimiter",
 CellID->92157315],
Cell[39726, 1063, 79, 1, 70, "ExampleText",
 CellID->738578064],
Cell[CellGroupData[{
Cell[39830, 1068, 156, 4, 70, "Input",
 CellID->221172202],
Cell[39989, 1074, 173, 5, 36, "Output",
 CellID->903700697]
}, Open  ]],
Cell[40177, 1082, 87, 1, 70, "ExampleText",
 CellID->629456667],
Cell[CellGroupData[{
Cell[40289, 1087, 167, 5, 70, "Input",
 CellID->33052035],
Cell[40459, 1094, 195, 6, 36, "Output",
 CellID->1493262895]
}, Open  ]],
Cell[40669, 1103, 125, 3, 70, "ExampleDelimiter",
 CellID->341649908],
Cell[40797, 1108, 191, 6, 70, "ExampleText",
 CellID->192339],
Cell[CellGroupData[{
Cell[41013, 1118, 160, 4, 70, "Input",
 CellID->374014864],
Cell[41176, 1124, 160, 5, 36, "Output",
 CellID->1775577423]
}, Open  ]],
Cell[CellGroupData[{
Cell[41373, 1134, 148, 4, 70, "Input",
 CellID->7393140],
Cell[41524, 1140, 167, 5, 36, "Output",
 CellID->696989649]
}, Open  ]],
Cell[CellGroupData[{
Cell[41728, 1150, 158, 4, 70, "Input",
 CellID->188296305],
Cell[41889, 1156, 170, 5, 36, "Output",
 CellID->1929220005]
}, Open  ]],
Cell[42074, 1164, 125, 3, 70, "ExampleDelimiter",
 CellID->612011445],
Cell[42202, 1169, 93, 1, 70, "ExampleText",
 CellID->129146030],
Cell[CellGroupData[{
Cell[42320, 1174, 177, 5, 70, "Input",
 CellID->952696506],
Cell[42500, 1181, 195, 6, 36, "Output",
 CellID->1692521629]
}, Open  ]],
Cell[CellGroupData[{
Cell[42732, 1192, 163, 4, 70, "Input",
 CellID->149645494],
Cell[42898, 1198, 173, 5, 36, "Output",
 CellID->642630441]
}, Open  ]],
Cell[43086, 1206, 125, 3, 70, "ExampleDelimiter",
 CellID->593810369],
Cell[43214, 1211, 76, 1, 70, "ExampleText",
 CellID->268927234],
Cell[CellGroupData[{
Cell[43315, 1216, 120, 3, 70, "Input",
 CellID->28830905],
Cell[43438, 1221, 806, 16, 88, "Output",
 CellID->994561124]
}, Open  ]],
Cell[44259, 1240, 124, 3, 70, "ExampleDelimiter",
 CellID->16764254],
Cell[44386, 1245, 89, 1, 70, "ExampleText",
 CellID->53277388],
Cell[CellGroupData[{
Cell[44500, 1250, 117, 3, 70, "Input",
 CellID->795584317],
Cell[44620, 1255, 454, 10, 54, "Output",
 CellID->1723586467]
}, Open  ]],
Cell[CellGroupData[{
Cell[45111, 1270, 124, 3, 70, "Input",
 CellID->23186614],
Cell[45238, 1275, 1182, 22, 122, "Output",
 CellID->910836486]
}, Open  ]],
Cell[46435, 1300, 125, 3, 70, "ExampleDelimiter",
 CellID->427853053],
Cell[46563, 1305, 86, 1, 70, "ExampleText",
 CellID->226300656],
Cell[CellGroupData[{
Cell[46674, 1310, 152, 4, 70, "Input",
 CellID->16562659],
Cell[46829, 1316, 163, 5, 36, "Output",
 CellID->1165384386]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[47041, 1327, 248, 7, 70, "ExampleSubsection",
 CellID->1961895733],
Cell[47292, 1336, 93, 1, 70, "ExampleText",
 CellID->218429381],
Cell[CellGroupData[{
Cell[47410, 1341, 221, 7, 70, "Input",
 CellID->180587304],
Cell[47634, 1350, 654, 16, 71, "Output",
 CellID->1564514862]
}, Open  ]],
Cell[48303, 1369, 125, 3, 70, "ExampleDelimiter",
 CellID->228229632],
Cell[48431, 1374, 87, 1, 70, "ExampleText",
 CellID->1347723],
Cell[CellGroupData[{
Cell[48543, 1379, 201, 6, 70, "Input",
 CellID->44910077],
Cell[48747, 1387, 189, 5, 36, "Output",
 CellID->1011511766]
}, Open  ]],
Cell[48951, 1395, 74, 1, 70, "ExampleText",
 CellID->1113244],
Cell[CellGroupData[{
Cell[49050, 1400, 204, 6, 70, "Input",
 CellID->4392297],
Cell[49257, 1408, 213, 6, 36, "Output",
 CellID->997701510]
}, Open  ]],
Cell[49485, 1417, 125, 3, 70, "ExampleDelimiter",
 CellID->201659810],
Cell[49613, 1422, 93, 1, 70, "ExampleText",
 CellID->112134317],
Cell[CellGroupData[{
Cell[49731, 1427, 158, 4, 70, "Input",
 CellID->1229972329],
Cell[49892, 1433, 181, 5, 36, "Output",
 CellID->816962794]
}, Open  ]],
Cell[CellGroupData[{
Cell[50110, 1443, 178, 5, 70, "Input",
 CellID->1225569552],
Cell[50291, 1450, 189, 5, 36, "Output",
 CellID->1830723487]
}, Open  ]],
Cell[50495, 1458, 76, 1, 70, "ExampleText",
 CellID->892569970],
Cell[CellGroupData[{
Cell[50596, 1463, 182, 5, 70, "Input",
 CellID->1250211495],
Cell[50781, 1470, 192, 5, 36, "Output",
 CellID->1971435440]
}, Open  ]],
Cell[50988, 1478, 66, 1, 70, "ExampleText",
 CellID->1797178791],
Cell[CellGroupData[{
Cell[51079, 1483, 185, 5, 70, "Input",
 CellID->826445282],
Cell[51267, 1490, 478, 12, 70, "Output",
 Evaluatable->False,
 CellID->32657171]
}, Open  ]],
Cell[51760, 1505, 124, 3, 70, "ExampleDelimiter",
 CellID->36013750],
Cell[51887, 1510, 216, 8, 70, "ExampleText",
 CellID->314844981],
Cell[CellGroupData[{
Cell[52128, 1522, 162, 4, 70, "Input",
 CellID->493396966],
Cell[52293, 1528, 182, 5, 36, "Output",
 CellID->525381281]
}, Open  ]],
Cell[CellGroupData[{
Cell[52512, 1538, 193, 6, 70, "Input",
 CellID->431132459],
Cell[52708, 1546, 318, 10, 36, "Output",
 CellID->1777916950]
}, Open  ]],
Cell[53041, 1559, 125, 3, 70, "ExampleDelimiter",
 CellID->495260950],
Cell[53169, 1564, 82, 1, 70, "ExampleText",
 CellID->273597932],
Cell[CellGroupData[{
Cell[53276, 1569, 159, 4, 70, "Input",
 CellID->502847698],
Cell[53438, 1575, 175, 5, 36, "Output",
 CellID->1362714292]
}, Open  ]],
Cell[CellGroupData[{
Cell[53650, 1585, 183, 5, 70, "Input",
 CellID->417695890],
Cell[53836, 1592, 218, 6, 36, "Output",
 CellID->226010389]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[54103, 1604, 235, 7, 70, "ExampleSubsection",
 CellID->29302194],
Cell[54341, 1613, 158, 6, 70, "ExampleText",
 CellID->553589695],
Cell[CellGroupData[{
Cell[54524, 1623, 164, 4, 70, "Input",
 CellID->529027222],
Cell[54691, 1629, 198, 6, 36, "Output",
 CellID->287563654]
}, Open  ]],
Cell[CellGroupData[{
Cell[54926, 1640, 151, 4, 70, "Input",
 CellID->609521478],
Cell[55080, 1646, 170, 5, 36, "Output",
 CellID->289562986]
}, Open  ]],
Cell[CellGroupData[{
Cell[55287, 1656, 163, 4, 70, "Input",
 CellID->414708089],
Cell[55453, 1662, 382, 10, 36, "Output",
 CellID->710913505]
}, Open  ]],
Cell[55850, 1675, 125, 3, 70, "ExampleDelimiter",
 CellID->107469361],
Cell[55978, 1680, 247, 8, 70, "ExampleText",
 CellID->5758993],
Cell[CellGroupData[{
Cell[56250, 1692, 157, 4, 70, "Input",
 CellID->607479222],
Cell[56410, 1698, 182, 5, 36, "Output",
 CellID->364195096]
}, Open  ]],
Cell[CellGroupData[{
Cell[56629, 1708, 105, 3, 70, "Input",
 CellID->388541687],
Cell[56737, 1713, 174, 5, 36, "Output",
 CellID->82772219]
}, Open  ]],
Cell[56926, 1721, 125, 3, 70, "ExampleDelimiter",
 CellID->380610788],
Cell[57054, 1726, 297, 10, 70, "ExampleText",
 CellID->812600388],
Cell[CellGroupData[{
Cell[57376, 1740, 159, 4, 70, "Input",
 CellID->978788],
Cell[57538, 1746, 212, 6, 36, "Output",
 CellID->368142135]
}, Open  ]],
Cell[57765, 1755, 125, 3, 70, "ExampleDelimiter",
 CellID->490922267],
Cell[57893, 1760, 296, 10, 70, "ExampleText",
 CellID->187464565],
Cell[CellGroupData[{
Cell[58214, 1774, 155, 4, 70, "Input",
 CellID->178393597],
Cell[58372, 1780, 210, 6, 36, "Output",
 CellID->13920931]
}, Open  ]],
Cell[58597, 1789, 124, 3, 70, "ExampleDelimiter",
 CellID->11222678],
Cell[58724, 1794, 283, 10, 70, "ExampleText",
 CellID->9731214],
Cell[CellGroupData[{
Cell[59032, 1808, 150, 4, 70, "Input",
 CellID->78474866],
Cell[59185, 1814, 206, 6, 36, "Output",
 CellID->186777870]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[59452, 1827, 243, 7, 70, "ExampleSection",
 CellID->358337295],
Cell[59698, 1836, 105, 2, 70, "ExampleText",
 CellID->210372128],
Cell[CellGroupData[{
Cell[59828, 1842, 115, 3, 70, "Input",
 CellID->77964217],
Cell[59946, 1847, 309, 8, 36, "Output",
 CellID->1805520027]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[60304, 1861, 227, 7, 70, "ExampleSection",
 CellID->133680859],
Cell[60534, 1870, 133, 4, 70, "ExampleText",
 CellID->183278447],
Cell[CellGroupData[{
Cell[60692, 1878, 454, 13, 70, "Input",
 CellID->222503889],
Cell[61149, 1893, 1341, 31, 134, "Output",
 CellID->1431161679]
}, Open  ]],
Cell[62505, 1927, 124, 3, 70, "ExampleDelimiter",
 CellID->31026702],
Cell[62632, 1932, 144, 4, 70, "ExampleText",
 CellID->564040795],
Cell[CellGroupData[{
Cell[62801, 1940, 299, 9, 70, "Input",
 CellID->1040243516],
Cell[63103, 1951, 1000, 25, 134, "Output",
 CellID->1717492553]
}, Open  ]],
Cell[64118, 1979, 122, 3, 70, "ExampleDelimiter",
 CellID->717047],
Cell[64243, 1984, 94, 1, 70, "ExampleText",
 CellID->451569494],
Cell[CellGroupData[{
Cell[64362, 1989, 339, 10, 70, "Input",
 CellID->1607110],
Cell[64704, 2001, 911, 24, 143, "Output",
 CellID->1569638944]
}, Open  ]],
Cell[65630, 2028, 125, 3, 70, "ExampleDelimiter",
 CellID->143784917],
Cell[65758, 2033, 89, 1, 70, "ExampleText",
 CellID->283212743],
Cell[CellGroupData[{
Cell[65872, 2038, 480, 16, 70, "Input",
 CellID->123078064],
Cell[66355, 2056, 1444, 33, 164, "Output",
 CellID->1232612060]
}, Open  ]],
Cell[67814, 2092, 125, 3, 70, "ExampleDelimiter",
 CellID->317530110],
Cell[67942, 2097, 121, 3, 70, "ExampleText",
 CellID->14537516],
Cell[68066, 2102, 842, 24, 70, "Input",
 CellID->494474563],
Cell[68911, 2128, 94, 1, 70, "ExampleText",
 CellID->131364823],
Cell[CellGroupData[{
Cell[69030, 2133, 546, 16, 70, "Input",
 CellID->2045337437],
Cell[69579, 2151, 9447, 255, 70, "Output",
 CellID->1883633458]
}, Open  ]],
Cell[79041, 2409, 125, 3, 70, "ExampleDelimiter",
 CellID->264632214],
Cell[79169, 2414, 119, 3, 70, "ExampleText",
 CellID->554240849],
Cell[CellGroupData[{
Cell[79313, 2421, 1649, 45, 70, "Input",
 CellID->199722801],
Cell[80965, 2468, 3867, 67, 70, "Output",
 Evaluatable->False,
 CellID->40867734]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[84881, 2541, 237, 7, 70, "ExampleSection",
 CellID->303279762],
Cell[85121, 2550, 236, 8, 70, "ExampleText",
 CellID->7221748],
Cell[85360, 2560, 313, 10, 70, "Input",
 CellID->1920714127],
Cell[85676, 2572, 194, 8, 70, "ExampleText",
 CellID->166897552],
Cell[85873, 2582, 280, 9, 70, "Input",
 CellID->1977644534],
Cell[CellGroupData[{
Cell[86178, 2595, 104, 3, 70, "Input",
 CellID->1667278319],
Cell[86285, 2600, 162, 5, 36, "Output",
 CellID->1537150069]
}, Open  ]],
Cell[86462, 2608, 125, 3, 70, "ExampleDelimiter",
 CellID->180873847],
Cell[86590, 2613, 98, 1, 70, "ExampleText",
 CellID->217244094],
Cell[CellGroupData[{
Cell[86713, 2618, 147, 4, 70, "Input",
 CellID->2073332905],
Cell[86863, 2624, 305, 8, 36, "Output",
 CellID->652936273]
}, Open  ]],
Cell[CellGroupData[{
Cell[87205, 2637, 277, 10, 70, "Input",
 CellID->23268862],
Cell[87485, 2649, 677, 21, 58, "Output",
 CellID->258504141]
}, Open  ]],
Cell[88177, 2673, 219, 8, 70, "ExampleText",
 CellID->347983233],
Cell[CellGroupData[{
Cell[88421, 2685, 437, 14, 70, "Input",
 CellID->1719255270],
Cell[88861, 2701, 815, 21, 108, "Output",
 CellID->319679906]
}, Open  ]],
Cell[89691, 2725, 125, 3, 70, "ExampleDelimiter",
 CellID->156167646],
Cell[89819, 2730, 227, 8, 70, "ExampleText",
 CellID->20360895],
Cell[CellGroupData[{
Cell[90071, 2742, 484, 15, 70, "Input",
 CellID->156356400],
Cell[90558, 2759, 1049, 28, 54, "Output",
 CellID->2003578995]
}, Open  ]],
Cell[91622, 2790, 125, 3, 70, "ExampleDelimiter",
 CellID->436506901],
Cell[91750, 2795, 220, 8, 70, "ExampleText",
 CellID->19349895],
Cell[CellGroupData[{
Cell[91995, 2807, 363, 11, 70, "Input",
 CellID->1910073777],
Cell[92361, 2820, 1237, 28, 124, "Output",
 CellID->1608584005]
}, Open  ]],
Cell[93613, 2851, 112, 3, 70, "ExampleText",
 CellID->94821444],
Cell[CellGroupData[{
Cell[93750, 2858, 363, 12, 70, "Input",
 CellID->23663497],
Cell[94116, 2872, 407, 12, 36, "Output",
 CellID->799739952]
}, Open  ]],
Cell[94538, 2887, 125, 3, 70, "ExampleDelimiter",
 CellID->522875263],
Cell[94666, 2892, 241, 8, 70, "ExampleText",
 CellID->671567693],
Cell[CellGroupData[{
Cell[94932, 2904, 372, 11, 70, "Input",
 CellID->80420752],
Cell[95307, 2917, 4180, 73, 70, "Output",
 Evaluatable->False,
 CellID->6377772]
}, Open  ]],
Cell[99502, 2993, 124, 3, 70, "ExampleDelimiter",
 CellID->87128243],
Cell[99629, 2998, 248, 8, 70, "ExampleText",
 CellID->1252683353],
Cell[CellGroupData[{
Cell[99902, 3010, 172, 5, 70, "Input",
 CellID->1068126438],
Cell[100077, 3017, 187, 5, 36, "Output",
 CellID->807028520]
}, Open  ]],
Cell[CellGroupData[{
Cell[100301, 3027, 143, 4, 70, "Input",
 CellID->2066922330],
Cell[100447, 3033, 9740, 178, 208, 4039, 80, "CachedBoxData", "BoxData", \
"Output",
 CellID->221621188]
}, Open  ]],
Cell[CellGroupData[{
Cell[110224, 3216, 305, 9, 70, "Input",
 CellID->1744994232],
Cell[110532, 3227, 593, 13, 71, "Output",
 CellID->1050662818]
}, Open  ]],
Cell[111140, 3243, 125, 3, 70, "ExampleDelimiter",
 CellID->417168155],
Cell[111268, 3248, 233, 8, 70, "ExampleText",
 CellID->431281038],
Cell[CellGroupData[{
Cell[111526, 3260, 167, 5, 70, "Input",
 CellID->399283605],
Cell[111696, 3267, 562, 13, 54, "Output",
 CellID->1879436492]
}, Open  ]],
Cell[CellGroupData[{
Cell[112295, 3285, 164, 4, 70, "Input",
 CellID->232186824],
Cell[112462, 3291, 1188, 22, 122, "Output",
 CellID->352157321]
}, Open  ]],
Cell[113665, 3316, 125, 3, 70, "ExampleDelimiter",
 CellID->119304512],
Cell[113793, 3321, 239, 8, 70, "ExampleText",
 CellID->1039087],
Cell[CellGroupData[{
Cell[114057, 3333, 133, 3, 70, "Input",
 CellID->1183840123],
Cell[114193, 3338, 834, 18, 105, "Output",
 CellID->243162915]
}, Open  ]],
Cell[115042, 3359, 53, 1, 70, "ExampleText",
 CellID->1181975817],
Cell[CellGroupData[{
Cell[115120, 3364, 169, 5, 70, "Input",
 CellID->175222298],
Cell[115292, 3371, 501, 16, 36, "Output",
 CellID->177732164]
}, Open  ]],
Cell[115808, 3390, 59, 1, 70, "ExampleText",
 CellID->656157715],
Cell[CellGroupData[{
Cell[115892, 3395, 165, 4, 70, "Input",
 CellID->714188660],
Cell[116060, 3401, 454, 15, 36, "Output",
 CellID->2142211018]
}, Open  ]],
Cell[116529, 3419, 62, 1, 70, "ExampleText",
 CellID->889999083],
Cell[CellGroupData[{
Cell[116616, 3424, 166, 4, 70, "Input",
 CellID->1175401636],
Cell[116785, 3430, 26702, 446, 318, 3749, 65, "CachedBoxData", "BoxData", \
"Output",
 CellID->1577237571]
}, Open  ]],
Cell[143502, 3879, 125, 3, 70, "ExampleDelimiter",
 CellID->754945036],
Cell[143630, 3884, 86, 1, 70, "ExampleText",
 CellID->357475455],
Cell[CellGroupData[{
Cell[143741, 3889, 152, 4, 70, "Input",
 CellID->185511550],
Cell[143896, 3895, 95473, 2110, 70, "Output",
 CellID->93717229]
}, Open  ]],
Cell[CellGroupData[{
Cell[239406, 6010, 159, 4, 70, "Input",
 CellID->223111928],
Cell[239568, 6016, 252, 8, 36, "Output",
 CellID->999954552]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[239869, 6030, 230, 7, 70, "ExampleSection",
 CellID->659161659],
Cell[240102, 6039, 113, 3, 70, "ExampleText",
 CellID->1329051991],
Cell[CellGroupData[{
Cell[240240, 6046, 158, 4, 70, "Input",
 CellID->46500988],
Cell[240401, 6052, 298, 6, 70, "Message",
 CellID->29134042],
Cell[240702, 6060, 247, 7, 36, "Output",
 CellID->29572378]
}, Open  ]],
Cell[CellGroupData[{
Cell[240986, 6072, 171, 5, 70, "Input",
 CellID->222925477],
Cell[241160, 6079, 314, 7, 70, "Message",
 CellID->954234589],
Cell[241477, 6088, 252, 7, 36, "Output",
 CellID->412861527]
}, Open  ]],
Cell[241744, 6098, 96, 1, 70, "ExampleText",
 CellID->173046581],
Cell[CellGroupData[{
Cell[241865, 6103, 361, 11, 70, "Input",
 CellID->135247669],
Cell[242229, 6116, 195, 6, 36, "Output",
 CellID->444020832]
}, Open  ]],
Cell[CellGroupData[{
Cell[242461, 6127, 159, 4, 70, "Input",
 CellID->375830393],
Cell[242623, 6133, 182, 5, 36, "Output",
 CellID->152450099]
}, Open  ]],
Cell[CellGroupData[{
Cell[242842, 6143, 419, 12, 70, "Input",
 CellID->57009403],
Cell[243264, 6157, 253, 8, 36, "Output",
 CellID->280823022]
}, Open  ]],
Cell[CellGroupData[{
Cell[243554, 6170, 162, 4, 70, "Input",
 CellID->205300593],
Cell[243719, 6176, 182, 5, 36, "Output",
 CellID->1770958295]
}, Open  ]],
Cell[243916, 6184, 125, 3, 70, "ExampleDelimiter",
 CellID->740563479],
Cell[244044, 6189, 239, 8, 70, "ExampleText",
 CellID->1025458525],
Cell[CellGroupData[{
Cell[244308, 6201, 286, 9, 70, "Input",
 CellID->1325162500],
Cell[244597, 6212, 922, 23, 75, "Output",
 CellID->372716645]
}, Open  ]],
Cell[245534, 6238, 229, 8, 70, "ExampleText",
 CellID->85509328],
Cell[CellGroupData[{
Cell[245788, 6250, 338, 11, 70, "Input",
 CellID->548645387],
Cell[246129, 6263, 330, 10, 39, "Output",
 CellID->38854216]
}, Open  ]],
Cell[CellGroupData[{
Cell[246496, 6278, 92, 3, 70, "Input",
 CellID->60605648],
Cell[246591, 6283, 372, 10, 39, "Output",
 CellID->187779624]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[247012, 6299, 228, 7, 70, "ExampleSection",
 CellID->160163481],
Cell[247243, 6308, 92, 1, 70, "ExampleText",
 CellID->355083364],
Cell[CellGroupData[{
Cell[247360, 6313, 313, 9, 70, "Input",
 CellID->696443128],
Cell[247676, 6324, 2801, 50, 154, "Output",
 CellID->1358663125]
}, Open  ]],
Cell[250492, 6377, 123, 3, 70, "ExampleDelimiter",
 CellID->5688417],
Cell[250618, 6382, 98, 1, 70, "ExampleText",
 CellID->506055598],
Cell[CellGroupData[{
Cell[250741, 6387, 429, 13, 70, "Input",
 CellID->103895441],
Cell[251173, 6402, 1288, 37, 71, "Output",
 CellID->857523324]
}, Open  ]],
Cell[252476, 6442, 124, 3, 70, "ExampleDelimiter",
 CellID->94446453],
Cell[252603, 6447, 84, 1, 70, "ExampleText",
 CellID->255019254],
Cell[252690, 6450, 758, 24, 70, "Input",
 CellID->44519215],
Cell[253451, 6476, 125, 3, 70, "ExampleText",
 CellID->242109154],
Cell[CellGroupData[{
Cell[253601, 6483, 134, 4, 70, "Input",
 CellID->178456335],
Cell[253738, 6489, 2692, 55, 207, "Output",
 CellID->1118357663]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[256491, 6551, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[256810, 6562, 973, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[257820, 6602, 326, 9, 70, "RelatedLinksSection",
 CellID->1584193535],
Cell[258149, 6613, 367, 12, 70, "RelatedLinks"],
Cell[258519, 6627, 236, 5, 70, "RelatedLinks",
 CellID->1038487239]
}, Open  ]],
Cell[CellGroupData[{
Cell[258792, 6637, 299, 8, 70, "MoreAboutSection"],
Cell[259094, 6647, 150, 3, 70, "MoreAbout",
 CellID->311688887],
Cell[259247, 6652, 185, 3, 70, "MoreAbout",
 CellID->205596695]
}, Open  ]],
Cell[259447, 6658, 27, 0, 70, "History"],
Cell[259477, 6660, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

