(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     68278,       2561]
NotebookOptionsPosition[     56661,       2150]
NotebookOutlinePosition[     57968,       2188]
CellTagsIndexPosition[     57882,       2183]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Solving Equations" :> 
          Documentation`HelpLookup["paclet:tutorial/SolvingEquations"], 
          "Eliminating Variables" :> 
          Documentation`HelpLookup["paclet:tutorial/EliminatingVariables"], 
          "Solving Logical Combinations of Equations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SolvingLogicalCombinationsOfEquations"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Solving Equations\"\>", 
       2->"\<\"Eliminating Variables\"\>", 
       3->"\<\"Solving Logical Combinations of Equations\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Reduce" :> Documentation`HelpLookup["paclet:ref/Reduce"], 
          "SolveAlways" :> Documentation`HelpLookup["paclet:ref/SolveAlways"],
           "Solve" :> Documentation`HelpLookup["paclet:ref/Solve"], 
          "GroebnerBasis" :> 
          Documentation`HelpLookup["paclet:ref/GroebnerBasis"], "Exists" :> 
          Documentation`HelpLookup["paclet:ref/Exists"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Reduce\"\>", 2->"\<\"SolveAlways\"\>", 
       3->"\<\"Solve\"\>", 4->"\<\"GroebnerBasis\"\>", 
       5->"\<\"Exists\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Polynomial Algebra" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialAlgebra"], 
          "Polynomial Systems" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialSystems"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Polynomial Algebra\"\>", 
       2->"\<\"Polynomial Systems\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Eliminate", "ObjectName",
 CellID->21526],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Eliminate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Eliminate"], "[", 
       RowBox[{
        StyleBox["eqns", "TI"], ",", 
        StyleBox["vars", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]eliminates variables between a set of simultaneous \
equations. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26896]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Equations are given in the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], "==", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13568],

Cell[TextData[{
 "Simultaneous equations can be combined either in a list or with ",
 Cell[BoxData["&&"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5703],

Cell["A single variable or a list of variables can be specified. ", "Notes",
 CellID->12829],

Cell["Variables can be any expressions. ", "Notes",
 CellID->15016],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Eliminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eliminate"]], "InlineFormula"],
 " works primarily with linear and polynomial equations. "
}], "Notes",
 CellID->12819]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->326286276],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->616954347],

Cell[TextData[{
 "Eliminate the variable ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " between two equations:"
}], "ExampleText",
 CellID->270263401],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Equal]", 
      RowBox[{"2", "+", "y"}]}], ",", 
     RowBox[{"y", "\[Equal]", "z"}]}], "}"}], ",", "y"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->368399657],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", "+", "z"}], "\[Equal]", "x"}]], "Output",
 ImageSize->{55, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->191778175]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->227546035],

Cell["A system of linear equations:", "ExampleText",
 CellID->163297537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "+", 
      RowBox[{"3", "y"}], "+", 
      RowBox[{"4", "z"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"9", "x"}], "+", 
      RowBox[{"8", "y"}], "+", 
      RowBox[{"7", "z"}]}], "\[Equal]", "2"}]}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->539162013],

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "-", 
   RowBox[{"11", " ", "y"}]}], "\[Equal]", 
  RowBox[{"22", " ", "x"}]}]], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->674654205]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->349044186],

Cell["A system of polynomial equations:", "ExampleText",
 CellID->486420803],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{"x", "-", "y", "+", "z"}], "\[Equal]", "2"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "-", 
      RowBox[{"y", "^", "2"}]}], "\[Equal]", 
     RowBox[{"z", "+", "1"}]}]}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->903256584],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "18"}], " ", "x"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"28", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["x", "4"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "5"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "6"]}]}], "\[Equal]", 
   RowBox[{"-", "27"}]}], "&&", 
  RowBox[{"y", "\[Equal]", 
   RowBox[{
    RowBox[{"-", "12"}], "-", 
    RowBox[{"2", " ", "x"}], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "4"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "5"]}]}]}]}]], "Output",
 ImageSize->{493, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->722101256]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->263424852],

Cell["Eliminate two variables:", "ExampleText",
 CellID->174389283],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{"x", "-", "y", "+", "z"}], "\[Equal]", "2"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "-", 
      RowBox[{"y", "^", "2"}]}], "\[Equal]", 
     RowBox[{"z", "+", "1"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->157418400],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", "18"}], " ", "x"}], "+", 
   RowBox[{"4", " ", 
    SuperscriptBox["x", "2"]}], "-", 
   RowBox[{"28", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"8", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{"4", " ", 
    SuperscriptBox["x", "5"]}], "+", 
   RowBox[{"4", " ", 
    SuperscriptBox["x", "6"]}]}], "\[Equal]", 
  RowBox[{"-", "27"}]}]], "Output",
 ImageSize->{257, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->150236073]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->52136986],

Cell["A system of equations involving radicals", "ExampleText",
 CellID->31481365],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", "x", "]"}], "+", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"y", "-", "1"}], "]"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"2", 
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "3"}], ")"}]}]}], "+", 
      RowBox[{"3", " ", 
       RowBox[{"y", "^", "2"}]}]}], "\[Equal]", "2"}]}], ",", "y"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->478800065],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", "2864000"}], " ", "x"}], "+", 
   RowBox[{"4956544", " ", 
    SuperscriptBox["x", "2"]}], "-", 
   RowBox[{"3109824", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"4114800", " ", 
    SuperscriptBox["x", "4"]}], "-", 
   RowBox[{"1219104", " ", 
    SuperscriptBox["x", "5"]}], "+", 
   RowBox[{"819936", " ", 
    SuperscriptBox["x", "6"]}], "-", 
   RowBox[{"310608", " ", 
    SuperscriptBox["x", "7"]}], "+", 
   RowBox[{"121500", " ", 
    SuperscriptBox["x", "8"]}], "-", 
   RowBox[{"23328", " ", 
    SuperscriptBox["x", "9"]}], "+", 
   RowBox[{"14580", " ", 
    SuperscriptBox["x", "10"]}], "+", 
   RowBox[{"729", " ", 
    SuperscriptBox["x", "12"]}]}], "\[Equal]", 
  RowBox[{"-", "1000000"}]}]], "Output",
 ImageSize->{490, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->672032070]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25281651],

Cell["A system of transcendental equations:", "ExampleText",
 CellID->94735075],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "+", "y"}], "]"}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"x", "-", "y"}], "]"}], "\[Equal]", "2"}]}], ",", "y"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->85310987],

Cell[BoxData[
 RowBox[{
  RowBox[{"Eliminate", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Eliminate\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Eliminate/ifun\\\", \
ButtonNote -> \\\"Eliminate::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->444877524],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", "x"}], "-", 
    RowBox[{"ArcCos", "[", "2", "]"}]}], "\[Equal]", 
   FractionBox["\[Pi]", "2"]}], "||", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", 
    RowBox[{"ArcCos", "[", "2", "]"}]}], "\[Equal]", 
   RowBox[{"-", 
    FractionBox["\[Pi]", "2"]}]}]}]], "Output",
 ImageSize->{275, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->238960196]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->351155646],

Cell["A system of modular equations:", "ExampleText",
 CellID->162850622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{"x", "-", "y", "+", "z"}], "\[Equal]", "2"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "-", 
      RowBox[{"y", "^", "2"}]}], "\[Equal]", 
     RowBox[{"z", "+", "1"}]}], "&&", 
    RowBox[{"Modulus", "\[Equal]", "5"}]}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->332347053],

Cell[BoxData[
 RowBox[{
  RowBox[{"Modulus", "\[Equal]", "5"}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", "x"}], "+", 
    SuperscriptBox["x", "2"], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "4"]}], "+", 
    SuperscriptBox["x", "5"], "+", 
    SuperscriptBox["x", "6"]}], "\[Equal]", "2"}], "&&", 
  RowBox[{"y", "\[Equal]", 
   RowBox[{
    RowBox[{"-", "2"}], "-", 
    RowBox[{"2", " ", "x"}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "3"]}], "-", 
    SuperscriptBox["x", "4"], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "5"]}]}]}]}]], "Output",
 ImageSize->{475, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->47773909]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22629935],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "InverseFunctions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->58263160],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Eliminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eliminate"]], "InlineFormula"],
 " uses inverse functions but prints warning messages:"
}], "ExampleText",
 CellID->498336114],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", "-", "y"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"g", "[", 
      RowBox[{"x", "+", "y"}], "]"}], "\[Equal]", "0"}]}], ",", "y"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->615068353],

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFunction", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used. Values may be lost for \
multivalued inverses. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InverseFunction/ifun\\\", ButtonNote -> \\\
\"InverseFunction::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->44710125],

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFunction", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used. Values may be lost for \
multivalued inverses. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InverseFunction/ifun\\\", ButtonNote -> \\\
\"InverseFunction::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->453262166],

Cell[BoxData[
 RowBox[{
  RowBox[{
   TagBox[
    SuperscriptBox["g", 
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}]],
    {InverseFunction, 1, 1},
    Editable->False], "[", "0", "]"}], "\[Equal]", 
  RowBox[{
   RowBox[{"2", " ", "x"}], "-", 
   RowBox[{
    TagBox[
     SuperscriptBox["f", 
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}]],
     {InverseFunction, 1, 1},
     Editable->False], "[", "0", "]"}]}]}]], "Output",
 ImageSize->{148, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27906527]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2665726],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseFunctions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFunctions"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Eliminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eliminate"]], "InlineFormula"],
 " does not print inverse function messages:"
}], "ExampleText",
 CellID->41155148],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", "-", "y"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"g", "[", 
      RowBox[{"x", "+", "y"}], "]"}], "\[Equal]", "0"}]}], ",", "y", ",", 
   RowBox[{"InverseFunctions", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150621549],

Cell[BoxData[
 RowBox[{
  RowBox[{
   TagBox[
    SuperscriptBox["g", 
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}]],
    {InverseFunction, 1, 1},
    Editable->False], "[", "0", "]"}], "\[Equal]", 
  RowBox[{
   RowBox[{"2", " ", "x"}], "-", 
   RowBox[{
    TagBox[
     SuperscriptBox["f", 
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}]],
     {InverseFunction, 1, 1},
     Editable->False], "[", "0", "]"}]}]}]], "Output",
 ImageSize->{148, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->179294795]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", "y"}], "]"}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"x", "-", 
       RowBox[{"y", "^", "2"}]}], "]"}], "\[Equal]", "2"}]}], ",", "y", ",", 
   RowBox[{"InverseFunctions", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->384293612],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x", "-", 
    SuperscriptBox["x", "4"], "-", 
    RowBox[{"ArcCos", "[", "2", "]"}]}], "\[Equal]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["\[Pi]", "2"], "4"], "-", 
    RowBox[{"\[Pi]", " ", 
     SuperscriptBox["x", "2"]}]}]}], "||", 
  RowBox[{
   RowBox[{"x", "-", 
    SuperscriptBox["x", "4"], "+", 
    RowBox[{"ArcCos", "[", "2", "]"}]}], "\[Equal]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["\[Pi]", "2"], "4"], "+", 
    RowBox[{"\[Pi]", " ", 
     SuperscriptBox["x", "2"]}]}]}]}]], "Output",
 ImageSize->{381, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->19141955]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->221224241],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseFunctions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFunctions"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Eliminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eliminate"]], "InlineFormula"],
 " does not use inverse functions:"
}], "ExampleText",
 CellID->208160627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", "-", "y"}], "]"}], "\[Equal]", "0"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"g", "[", 
      RowBox[{"x", "+", "y"}], "]"}], "\[Equal]", "0"}]}], ",", "y", ",", 
   RowBox[{"InverseFunctions", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->493307520],

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", "-", "y"}], "]"}], "\[Equal]", "0"}], "&&", 
    RowBox[{
     RowBox[{"g", "[", 
      RowBox[{"x", "+", "y"}], "]"}], "\[Equal]", "0"}]}], ",", "y", ",", 
   RowBox[{"InverseFunctions", "\[Rule]", "False"}]}], "]"}]], "Output",
 ImageSize->{437, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->207527611]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", "y"}], "]"}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"x", "-", 
       RowBox[{"y", "^", "2"}]}], "]"}], "\[Equal]", "2"}]}], ",", "y", ",", 
   RowBox[{"InverseFunctions", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->216198298],

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       SuperscriptBox["x", "2"], "-", "y"}], "]"}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"x", "-", 
       SuperscriptBox["y", "2"]}], "]"}], "\[Equal]", "2"}]}], ",", "y", ",", 
   
   RowBox[{"InverseFunctions", "\[Rule]", "False"}]}], "]"}]], "Output",
 ImageSize->{476, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->589135421]
}, Open  ]],

Cell["\<\
Eliminating variables from algebraic equations does not require using inverse \
functions:\
\>", "ExampleText",
 CellID->203165551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{"x", "-", "y", "+", "z"}], "\[Equal]", "2"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "-", 
      RowBox[{"y", "^", "2"}]}], "\[Equal]", 
     RowBox[{"z", "+", "1"}]}]}], ",", "z", ",", 
   RowBox[{"InverseFunctions", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->413086211],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "18"}], " ", "x"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"28", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["x", "4"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "5"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "6"]}]}], "\[Equal]", 
   RowBox[{"-", "27"}]}], "&&", 
  RowBox[{"y", "\[Equal]", 
   RowBox[{
    RowBox[{"-", "12"}], "-", 
    RowBox[{"2", " ", "x"}], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "4"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "5"]}]}]}]}]], "Output",
 ImageSize->{493, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->159307220]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Mode",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->130988174],

Cell["\<\
Find a modulus for which a system of equations has a solution and eliminate a \
variable:\
\>", "ExampleText",
 CellID->640369772],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "+", 
      RowBox[{"3", "y"}]}], "\[Equal]", "5"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "-", 
      RowBox[{"x", " ", "y"}]}], "\[Equal]", "7"}]}], ",", "y", ",", 
   RowBox[{"Mode", "\[Rule]", "Modular"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->296534750],

Cell[BoxData[
 RowBox[{
  RowBox[{"Modulus", "\[Equal]", "191721"}], "&&", 
  RowBox[{"x", "\[Equal]", "47377"}]}]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->169033391]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WorkingPrecision",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->405858340],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Eliminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eliminate"]], "InlineFormula"],
 " computes with exact coefficients:"
}], "ExampleText",
 CellID->385254824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}]}], "\[Equal]", "E"}], "&&", 
    RowBox[{
     RowBox[{"x", "-", "y", "+", "z"}], "\[Equal]", "2"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "-", 
      RowBox[{"y", "^", "2"}]}], "\[Equal]", 
     RowBox[{"z", "+", "Pi"}]}]}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->325858090],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "16"}], "+", 
       RowBox[{"2", " ", "\[ExponentialE]"}], "-", 
       RowBox[{"4", " ", "\[Pi]"}]}], ")"}], " ", "x"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"12", "-", 
       RowBox[{"4", " ", "\[ExponentialE]"}], "-", 
       RowBox[{"4", " ", "\[Pi]"}]}], ")"}], " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "16"}], "-", 
       RowBox[{"4", " ", "\[ExponentialE]"}], "-", 
       RowBox[{"8", " ", "\[Pi]"}]}], ")"}], " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["x", "4"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "5"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "6"]}]}], "\[Equal]", 
   RowBox[{
    RowBox[{"-", "8"}], "-", 
    RowBox[{"2", " ", "\[ExponentialE]"}], "-", 
    SuperscriptBox["\[ExponentialE]", "2"], "-", 
    RowBox[{"8", " ", "\[Pi]"}], "-", 
    RowBox[{"4", " ", "\[ExponentialE]", " ", "\[Pi]"}], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["\[Pi]", "2"]}]}]}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "\[ExponentialE]", "+", 
      RowBox[{"2", " ", "\[Pi]"}]}], ")"}], " ", "y"}], "\[Equal]", 
   RowBox[{
    RowBox[{"-", "4"}], "-", 
    RowBox[{"2", " ", "\[ExponentialE]"}], "-", 
    RowBox[{"6", " ", "\[Pi]"}], "+", 
    RowBox[{"2", " ", "x"}], "-", 
    RowBox[{"2", " ", "\[ExponentialE]", " ", "x"}], "-", 
    RowBox[{"2", " ", "\[Pi]", " ", "x"}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"\[ExponentialE]", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"2", " ", "\[Pi]", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "4"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "5"]}]}]}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      RowBox[{"2", " ", "x"}]}], ")"}], " ", "y"}], "\[Equal]", 
   RowBox[{
    RowBox[{"-", "\[ExponentialE]"}], "-", 
    RowBox[{"2", " ", "\[Pi]"}], "-", 
    RowBox[{"2", " ", "x"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "3"]}]}]}], "&&", 
  RowBox[{
   RowBox[{"y", "+", 
    SuperscriptBox["y", "2"]}], "\[Equal]", 
   RowBox[{
    RowBox[{"-", "2"}], "-", "\[Pi]", "+", "x", "+", 
    SuperscriptBox["x", "3"]}]}]}]], "Output",
 ImageSize->{541, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->101793983]
}, Open  ]],

Cell["\<\
This performs the elimination using 20 digit approximate number coefficients:\
\
\>", "ExampleText",
 CellID->634858008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}]}], "\[Equal]", "E"}], "&&", 
    RowBox[{
     RowBox[{"x", "-", "y", "+", "z"}], "\[Equal]", "2"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "-", 
      RowBox[{"y", "^", "2"}]}], "\[Equal]", 
     RowBox[{"z", "+", "Pi"}]}]}], ",", "z", ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->817159742],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "23.12980695744108248312999859164`19.58214651250987"}], " ",
      "x"}], "-", 
    RowBox[{"11.43949792819535389529172341976`19.58214651250987", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"52.0058685425545268491422969541`19.58214651250987", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"8.`19.58214651250987", " ", 
     SuperscriptBox["x", "4"]}], "+", 
    RowBox[{"4.`19.58214651250987", " ", 
     SuperscriptBox["x", "5"]}], "+", 
    RowBox[{"4.`19.58214651250987", " ", 
     SuperscriptBox["x", "6"]}]}], "\[Equal]", 
   RowBox[{"-", "119.59571547961878934284431696075`19.58214651250987"}]}], "&&",
   
  RowBox[{
   RowBox[{"7.00146713563863171228557423852`19.58214651250987", " ", "y"}], 
   "\[Equal]", 
   RowBox[{
    RowBox[{"-", "28.28611957845684990149643524422`19.58214651250987"}], "-", 
    
    RowBox[{"9.71974896409767694764586170988`19.58214651250987", " ", "x"}], 
    "-", 
    RowBox[{"11.00146713563863171228557423853`19.58214651250987", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"8.`19.58214651250987", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"4.`19.58214651250987", " ", 
     SuperscriptBox["x", "4"]}], "+", 
    RowBox[{"2.`19.58214651250987", " ", 
     SuperscriptBox["x", "5"]}]}]}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2.`19.58214651250987"}], "+", 
      RowBox[{"2.`19.58214651250987", " ", "x"}]}], ")"}], " ", "y"}], 
   "\[Equal]", 
   RowBox[{
    RowBox[{"-", "9.00146713563863171228557423852`19.58214651250987"}], "-", 
    RowBox[{"2.`19.58214651250987", " ", "x"}], "+", 
    RowBox[{"2.`19.58214651250987", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"2.`19.58214651250987", " ", 
     SuperscriptBox["x", "3"]}]}]}], "&&", 
  RowBox[{
   RowBox[{"y", "+", 
    SuperscriptBox["y", "2"]}], "\[Equal]", 
   RowBox[{
    RowBox[{"-", "5.14159265358979323846264338358`19.58214651250987"}], "+", 
    "x", "+", 
    SuperscriptBox["x", "3"]}]}]}]], "Output",
 ImageSize->{541, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->83015335]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26223435],

Cell[TextData[{
 "Rewrite ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " in terms of ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->665951347],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "==", 
      RowBox[{
       RowBox[{"x", "^", "5"}], "+", 
       RowBox[{"y", "^", "5"}]}]}], ",", 
     RowBox[{"a", "==", 
      RowBox[{"x", "+", "y"}]}], ",", 
     RowBox[{"b", "==", 
      RowBox[{"x", " ", "y"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->171974083],

Cell[BoxData[
 RowBox[{"f", "\[Equal]", 
  RowBox[{
   SuperscriptBox["a", "5"], "-", 
   RowBox[{"5", " ", 
    SuperscriptBox["a", "3"], " ", "b"}], "+", 
   RowBox[{"5", " ", "a", " ", 
    SuperscriptBox["b", "2"]}]}]}]], "Output",
 ImageSize->{131, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->360392300]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->558488304],

Cell["Find a condition for two polynomials to have a common root:", \
"ExampleText",
 CellID->320408455],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "-", "1"}], ")"}], 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "a"}], "-", "3"}], ")"}], "x"}], "+", "4"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"a", "^", "2"}]}], ")"}], 
     RowBox[{"x", "^", "4"}]}], "-", 
    RowBox[{"2", "a", " ", "x"}], "+", 
    RowBox[{"7", 
     RowBox[{"a", "^", "2"}]}], "-", "1"}]}], ";"}], "\n", 
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "\[Equal]", "0"}], "&&", 
    RowBox[{"g", "\[Equal]", "0"}]}], ",", "x"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->314270683],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", "102"}], " ", "a"}], "-", 
   RowBox[{"2270", " ", 
    SuperscriptBox["a", "2"]}], "+", 
   RowBox[{"4602", " ", 
    SuperscriptBox["a", "3"]}], "+", 
   RowBox[{"2549", " ", 
    SuperscriptBox["a", "4"]}], "-", 
   RowBox[{"9336", " ", 
    SuperscriptBox["a", "5"]}], "+", 
   RowBox[{"1749", " ", 
    SuperscriptBox["a", "6"]}], "+", 
   RowBox[{"7464", " ", 
    SuperscriptBox["a", "7"]}], "-", 
   RowBox[{"4122", " ", 
    SuperscriptBox["a", "8"]}], "-", 
   RowBox[{"3102", " ", 
    SuperscriptBox["a", "9"]}], "+", 
   RowBox[{"2372", " ", 
    SuperscriptBox["a", "10"]}], "+", 
   RowBox[{"546", " ", 
    SuperscriptBox["a", "11"]}], "-", 
   RowBox[{"623", " ", 
    SuperscriptBox["a", "12"]}], "+", 
   RowBox[{"49", " ", 
    SuperscriptBox["a", "14"]}]}], "\[Equal]", "0"}]], "Output",
 ImageSize->{415, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->515071387]
}, Open  ]],

Cell[TextData[{
 "This solves the same problem using ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->76698603],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"Exists", "[", 
   RowBox[{"x", ",", 
    RowBox[{
     RowBox[{"f", "\[Equal]", "0"}], "&&", 
     RowBox[{"g", "\[Equal]", "0"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->480883378],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "\[Equal]", "0"}], "||", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "102"}], "-", 
    RowBox[{"2270", " ", "a"}], "+", 
    RowBox[{"4602", " ", 
     SuperscriptBox["a", "2"]}], "+", 
    RowBox[{"2549", " ", 
     SuperscriptBox["a", "3"]}], "-", 
    RowBox[{"9336", " ", 
     SuperscriptBox["a", "4"]}], "+", 
    RowBox[{"1749", " ", 
     SuperscriptBox["a", "5"]}], "+", 
    RowBox[{"7464", " ", 
     SuperscriptBox["a", "6"]}], "-", 
    RowBox[{"4122", " ", 
     SuperscriptBox["a", "7"]}], "-", 
    RowBox[{"3102", " ", 
     SuperscriptBox["a", "8"]}], "+", 
    RowBox[{"2372", " ", 
     SuperscriptBox["a", "9"]}], "+", 
    RowBox[{"546", " ", 
     SuperscriptBox["a", "10"]}], "-", 
    RowBox[{"623", " ", 
     SuperscriptBox["a", "11"]}], "+", 
    RowBox[{"49", " ", 
     SuperscriptBox["a", "13"]}]}], "\[Equal]", "0"}]}]], "Output",
 ImageSize->{473, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->439012244]
}, Open  ]],

Cell[TextData[{
 "The condition is equivalent to ",
 Cell[BoxData[
  ButtonBox["Resultant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resultant"]], "InlineFormula"],
 " of the polynomials being zero:"
}], "ExampleText",
 CellID->18794560],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resultant", "[", 
  RowBox[{"f", ",", "g", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->472077287],

Cell[BoxData[
 RowBox[{
  RowBox[{"102", " ", "a"}], "+", 
  RowBox[{"2270", " ", 
   SuperscriptBox["a", "2"]}], "-", 
  RowBox[{"4602", " ", 
   SuperscriptBox["a", "3"]}], "-", 
  RowBox[{"2549", " ", 
   SuperscriptBox["a", "4"]}], "+", 
  RowBox[{"9336", " ", 
   SuperscriptBox["a", "5"]}], "-", 
  RowBox[{"1749", " ", 
   SuperscriptBox["a", "6"]}], "-", 
  RowBox[{"7464", " ", 
   SuperscriptBox["a", "7"]}], "+", 
  RowBox[{"4122", " ", 
   SuperscriptBox["a", "8"]}], "+", 
  RowBox[{"3102", " ", 
   SuperscriptBox["a", "9"]}], "-", 
  RowBox[{"2372", " ", 
   SuperscriptBox["a", "10"]}], "-", 
  RowBox[{"546", " ", 
   SuperscriptBox["a", "11"]}], "+", 
  RowBox[{"623", " ", 
   SuperscriptBox["a", "12"]}], "-", 
  RowBox[{"49", " ", 
   SuperscriptBox["a", "14"]}]}]], "Output",
 ImageSize->{384, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->166266410]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->796322304],

Cell[TextData[{
 "Equations returned by ",
 Cell[BoxData[
  ButtonBox["Eliminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eliminate"]], "InlineFormula"],
 " do not contain the elimination variables:"
}], "ExampleText",
 CellID->319298288],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "-", 
      RowBox[{"3", "y"}], "+", 
      RowBox[{"5", "z"}]}], "\[Equal]", "7"}]}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->165014615],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "24"}], "-", 
   RowBox[{"42", " ", "y"}], "-", 
   RowBox[{"34", " ", 
    SuperscriptBox["y", "2"]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"29", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"x", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "28"}], "-", 
      RowBox[{"12", " ", "y"}]}], ")"}]}]}]}]], "Output",
 ImageSize->{246, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->432588882]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->299065826],

Cell[TextData[{
 "Equations returned by ",
 Cell[BoxData[
  ButtonBox["Eliminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eliminate"]], "InlineFormula"],
 " are implied by the input equations:"
}], "ExampleText",
 CellID->602609135],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"inp", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{"x", "-", "y", "+", "z"}], "\[Equal]", "2"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "-", 
      RowBox[{"y", "^", "2"}]}], "\[Equal]", 
     RowBox[{"z", "+", "1"}]}]}]}], ";"}], "\n", 
 RowBox[{"out", "=", 
  RowBox[{"Eliminate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}], "+", 
       RowBox[{"z", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
     RowBox[{
      RowBox[{"x", "-", "y", "+", "z"}], "\[Equal]", "2"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "3"}], "-", 
       RowBox[{"y", "^", "2"}]}], "\[Equal]", 
      RowBox[{"z", "+", "1"}]}]}], ",", "z"}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->893844131],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "18"}], " ", "x"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"28", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["x", "4"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "5"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "6"]}]}], "\[Equal]", 
   RowBox[{"-", "27"}]}], "&&", 
  RowBox[{"y", "\[Equal]", 
   RowBox[{
    RowBox[{"-", "12"}], "-", 
    RowBox[{"2", " ", "x"}], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "4"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "5"]}]}]}]}]], "Output",
 ImageSize->{493, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->802223497]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " to check this property:"
}], "ExampleText",
 CellID->128224251],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"ForAll", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
    RowBox[{"Implies", "[", 
     RowBox[{"inp", ",", "out"}], "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->404930390],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->53858810]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->95993621],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " to eliminate an existential quantifier:"
}], "ExampleText",
 CellID->207036442],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqns", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"x", " ", "z"}], "\[Equal]", "y"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{
       RowBox[{"x", "^", "2"}], 
       RowBox[{"z", "^", "2"}]}]}], "\[Equal]", "1"}]}]}], ";"}], "\n", 
 RowBox[{"Resolve", "[", 
  RowBox[{"Exists", "[", 
   RowBox[{"z", ",", "eqns"}], "]"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->240980670],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"]}], "\[Equal]", "0"}], "&&", 
  RowBox[{"x", "\[NotEqual]", "0"}]}]], "Output",
 ImageSize->{141, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->505852764]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Eliminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eliminate"]], "InlineFormula"],
 " gives the same set of equations, but does not give inequations:"
}], "ExampleText",
 CellID->370437302],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{"eqns", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->365831602],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["y", "2"], "\[Equal]", 
  RowBox[{"1", "-", 
   SuperscriptBox["x", "2"]}]}]], "Output",
 ImageSize->{66, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->216250362]
}, Open  ]],

Cell[TextData[{
 "Eliminate a variable using ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->269404379],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{"eqns", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", "z", "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->573821296],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   SuperscriptBox["x", "2"], "+", 
   SuperscriptBox["y", "2"]}], "}"}]], "Output",
 ImageSize->{83, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->228121759]
}, Open  ]],

Cell[TextData[{
 "Eliminate a variable from a pair of polynomials using ",
 Cell[BoxData[
  ButtonBox["Resultant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resultant"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->191568019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Resultant", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"eqns", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], "-", 
     RowBox[{"eqns", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "2"}], "]"}], "]"}]}], ",", 
    RowBox[{
     RowBox[{"eqns", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "1"}], "]"}], "]"}], "-", 
     RowBox[{"eqns", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "2"}], "]"}], "]"}]}], ",", "z"}], "]"}], "//", 
  "Factor"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->197863775],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"]}], ")"}]}]], "Output",
 ImageSize->{99, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->672595118]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to eliminate an existential quantifier and solve the resulting system:"
}], "ExampleText",
 CellID->507858816],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{"z", ",", "eqns"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->30347758],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}]]}]}], "||", 
    RowBox[{"y", "\[Equal]", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}]]}]}], ")"}], "&&", 
  RowBox[{"x", "\[NotEqual]", "0"}]}]], "Output",
 ImageSize->{243, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->334164432]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->457471148],

Cell[TextData[{
 "When the input contains only equations, ",
 Cell[BoxData[
  ButtonBox["Eliminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eliminate"]], "InlineFormula"],
 " returns only equations:"
}], "ExampleText",
 CellID->27245002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqns", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"x", " ", "z"}], "\[Equal]", "y"}], " ", "&&", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{
      RowBox[{"x", "^", "2"}], 
      RowBox[{"z", "^", "2"}]}]}], "\[Equal]", "1"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->360180507],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x", " ", "z"}], "\[Equal]", "y"}], "&&", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    RowBox[{
     SuperscriptBox["x", "2"], " ", 
     SuperscriptBox["z", "2"]}]}], "\[Equal]", "1"}]}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->308059347]
}, Open  ]],

Cell[TextData[{
 "The zero set of the result is the Zariski closure of the projection of the \
zero set of ",
 Cell[BoxData[
  StyleBox["eqns", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->87438477],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{"eqns", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->54180620],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["y", "2"], "\[Equal]", 
  RowBox[{"1", "-", 
   SuperscriptBox["x", "2"]}]}]], "Output",
 ImageSize->{66, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->275305292]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " to get a result with zero set equal to the projection of the zero set of \
",
 Cell[BoxData[
  StyleBox["eqns", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->56954183],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"Exists", "[", 
   RowBox[{"z", ",", "eqns"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->724509304],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"]}], "\[Equal]", "0"}], "&&", 
  RowBox[{"x", "\[NotEqual]", "0"}]}]], "Output",
 ImageSize->{141, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->419677775]
}, Open  ]],

Cell[TextData[{
 "When the input contains inequations, ",
 Cell[BoxData[
  ButtonBox["Eliminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eliminate"]], "InlineFormula"],
 " returns equations and inequations:"
}], "ExampleText",
 CellID->675696407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqin", "=", 
  RowBox[{"eqns", "&&", 
   RowBox[{"t", "\[NotEqual]", "0"}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->130725184],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x", " ", "z"}], "\[Equal]", "y"}], "&&", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    RowBox[{
     SuperscriptBox["x", "2"], " ", 
     SuperscriptBox["z", "2"]}]}], "\[Equal]", "1"}], "&&", 
  RowBox[{"t", "\[NotEqual]", "0"}]}]], "Output",
 ImageSize->{190, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->52390716]
}, Open  ]],

Cell[TextData[{
 "The zero set of the result is equal to the projection of the zero set of ",
 Cell[BoxData[
  StyleBox["eqin", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->90740353],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{"eqin", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->547090882],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["y", "2"], "\[Equal]", 
   RowBox[{"1", "-", 
    SuperscriptBox["x", "2"]}]}], "&&", 
  RowBox[{"t", "\[NotEqual]", "0"}], "&&", 
  RowBox[{"x", "\[NotEqual]", "0"}]}]], "Output",
 ImageSize->{161, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->70319608]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18748],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SolveAlways",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SolveAlways"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Solve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Solve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GroebnerBasis",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GroebnerBasis"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Exists",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exists"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23251]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22704],

Cell[TextData[ButtonBox["Solving Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SolvingEquations"]], "Tutorials",
 CellID->20588],

Cell[TextData[ButtonBox["Eliminating Variables",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EliminatingVariables"]], "Tutorials",
 CellID->12269],

Cell[TextData[ButtonBox["Solving Logical Combinations of Equations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SolvingLogicalCombinationsOfEquations"]], "Tutorials",
 CellID->4500]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->41769262],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "MoreAbout",
 CellID->337025012],

Cell[TextData[ButtonBox["Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialSystems"]], "MoreAbout",
 CellID->202059293]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Eliminate - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 39, 52.8230266}", "context" -> "System`", 
    "keywords" -> {
     "eliminating variables", "equations", "simultaneous equations", 
      "Zariski closure"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Eliminate[eqns, vars] eliminates variables between a set of simultaneous \
equations. ", "synonyms" -> {}, "title" -> "Eliminate", "type" -> "Symbol", 
    "uri" -> "ref/Eliminate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5177, 165, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->326286276]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 57739, 2176}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2639, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3262, 87, 47, 1, 70, "ObjectName",
 CellID->21526],
Cell[3312, 90, 568, 18, 70, "Usage",
 CellID->26896]
}, Open  ]],
Cell[CellGroupData[{
Cell[3917, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4395, 130, 193, 8, 70, "Notes",
 CellID->13568],
Cell[4591, 140, 157, 5, 70, "Notes",
 CellID->5703],
Cell[4751, 147, 92, 1, 70, "Notes",
 CellID->12829],
Cell[4846, 150, 67, 1, 70, "Notes",
 CellID->15016],
Cell[4916, 153, 224, 7, 70, "Notes",
 CellID->12819]
}, Closed]],
Cell[CellGroupData[{
Cell[5177, 165, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->326286276],
Cell[CellGroupData[{
Cell[5562, 179, 148, 5, 70, "ExampleSection",
 CellID->616954347],
Cell[5713, 186, 173, 6, 70, "ExampleText",
 CellID->270263401],
Cell[CellGroupData[{
Cell[5911, 196, 270, 9, 28, "Input",
 CellID->368399657],
Cell[6184, 207, 210, 7, 36, "Output",
 CellID->191778175]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6443, 220, 220, 7, 70, "ExampleSection",
 CellID->227546035],
Cell[6666, 229, 72, 1, 70, "ExampleText",
 CellID->163297537],
Cell[CellGroupData[{
Cell[6763, 234, 421, 15, 70, "Input",
 CellID->539162013],
Cell[7187, 251, 259, 9, 36, "Output",
 CellID->674654205]
}, Open  ]],
Cell[7461, 263, 125, 3, 70, "ExampleDelimiter",
 CellID->349044186],
Cell[7589, 268, 76, 1, 70, "ExampleText",
 CellID->486420803],
Cell[CellGroupData[{
Cell[7690, 273, 519, 17, 70, "Input",
 CellID->903256584],
Cell[8212, 292, 952, 33, 36, "Output",
 CellID->722101256]
}, Open  ]],
Cell[9179, 328, 125, 3, 70, "ExampleDelimiter",
 CellID->263424852],
Cell[9307, 333, 67, 1, 70, "ExampleText",
 CellID->174389283],
Cell[CellGroupData[{
Cell[9399, 338, 568, 19, 70, "Input",
 CellID->157418400],
Cell[9970, 359, 566, 20, 36, "Output",
 CellID->150236073]
}, Open  ]],
Cell[10551, 382, 124, 3, 70, "ExampleDelimiter",
 CellID->52136986],
Cell[10678, 387, 82, 1, 70, "ExampleText",
 CellID->31481365],
Cell[CellGroupData[{
Cell[10785, 392, 534, 19, 70, "Input",
 CellID->478800065],
Cell[11322, 413, 926, 30, 54, "Output",
 CellID->672032070]
}, Open  ]],
Cell[12263, 446, 124, 3, 70, "ExampleDelimiter",
 CellID->25281651],
Cell[12390, 451, 79, 1, 70, "ExampleText",
 CellID->94735075],
Cell[CellGroupData[{
Cell[12494, 456, 339, 12, 70, "Input",
 CellID->85310987],
Cell[12836, 470, 469, 8, 70, "Message",
 CellID->444877524],
Cell[13308, 480, 482, 17, 49, "Output",
 CellID->238960196]
}, Open  ]],
Cell[13805, 500, 125, 3, 70, "ExampleDelimiter",
 CellID->351155646],
Cell[13933, 505, 73, 1, 70, "ExampleText",
 CellID->162850622],
Cell[CellGroupData[{
Cell[14031, 510, 568, 18, 70, "Input",
 CellID->332347053],
Cell[14602, 530, 809, 27, 36, "Output",
 CellID->47773909]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15460, 563, 221, 7, 70, "ExampleSection",
 CellID->22629935],
Cell[CellGroupData[{
Cell[15706, 574, 236, 7, 70, "ExampleSubsection",
 CellID->58263160],
Cell[15945, 583, 248, 8, 70, "ExampleText",
 CellID->498336114],
Cell[CellGroupData[{
Cell[16218, 595, 346, 12, 70, "Input",
 CellID->615068353],
Cell[16567, 609, 427, 8, 70, "Message",
 CellID->44710125],
Cell[16997, 619, 428, 8, 70, "Message",
 CellID->453262166],
Cell[17428, 629, 569, 22, 36, "Output",
 CellID->27906527]
}, Open  ]],
Cell[18012, 654, 123, 3, 70, "ExampleDelimiter",
 CellID->2665726],
Cell[18138, 659, 475, 17, 70, "ExampleText",
 CellID->41155148],
Cell[CellGroupData[{
Cell[18638, 680, 401, 12, 70, "Input",
 CellID->150621549],
Cell[19042, 694, 570, 22, 36, "Output",
 CellID->179294795]
}, Open  ]],
Cell[CellGroupData[{
Cell[19649, 721, 451, 14, 70, "Input",
 CellID->384293612],
Cell[20103, 737, 699, 24, 54, "Output",
 CellID->19141955]
}, Open  ]],
Cell[20817, 764, 125, 3, 70, "ExampleDelimiter",
 CellID->221224241],
Cell[20945, 769, 468, 17, 70, "ExampleText",
 CellID->208160627],
Cell[CellGroupData[{
Cell[21438, 790, 402, 12, 70, "Input",
 CellID->493307520],
Cell[21843, 804, 481, 15, 36, "Output",
 CellID->207527611]
}, Open  ]],
Cell[CellGroupData[{
Cell[22361, 824, 452, 14, 70, "Input",
 CellID->216198298],
Cell[22816, 840, 547, 18, 39, "Output",
 CellID->589135421]
}, Open  ]],
Cell[23378, 861, 141, 4, 70, "ExampleText",
 CellID->203165551],
Cell[CellGroupData[{
Cell[23544, 869, 578, 18, 70, "Input",
 CellID->413086211],
Cell[24125, 889, 952, 33, 36, "Output",
 CellID->159307220]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25126, 928, 225, 7, 70, "ExampleSubsection",
 CellID->130988174],
Cell[25354, 937, 140, 4, 70, "ExampleText",
 CellID->640369772],
Cell[CellGroupData[{
Cell[25519, 945, 539, 18, 70, "Input",
 CellID->296534750],
Cell[26061, 965, 257, 8, 36, "Output",
 CellID->169033391]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26367, 979, 237, 7, 70, "ExampleSubsection",
 CellID->405858340],
Cell[26607, 988, 230, 8, 70, "ExampleText",
 CellID->385254824],
Cell[CellGroupData[{
Cell[26862, 1000, 520, 17, 70, "Input",
 CellID->325858090],
Cell[27385, 1019, 2765, 86, 88, "Output",
 CellID->101793983]
}, Open  ]],
Cell[30165, 1108, 130, 4, 70, "ExampleText",
 CellID->634858008],
Cell[CellGroupData[{
Cell[30320, 1116, 576, 18, 70, "Input",
 CellID->817159742],
Cell[30899, 1136, 2228, 60, 156, "Output",
 CellID->83015335]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[33188, 1203, 226, 7, 70, "ExampleSection",
 CellID->26223435],
Cell[33417, 1212, 292, 12, 70, "ExampleText",
 CellID->665951347],
Cell[CellGroupData[{
Cell[33734, 1228, 454, 16, 70, "Input",
 CellID->171974083],
Cell[34191, 1246, 366, 12, 36, "Output",
 CellID->360392300]
}, Open  ]],
Cell[34572, 1261, 125, 3, 70, "ExampleDelimiter",
 CellID->558488304],
Cell[34700, 1266, 104, 2, 70, "ExampleText",
 CellID->320408455],
Cell[CellGroupData[{
Cell[34829, 1272, 889, 33, 70, "Input",
 CellID->314270683],
Cell[35721, 1307, 1003, 33, 54, "Output",
 CellID->515071387]
}, Open  ]],
Cell[36739, 1343, 215, 8, 70, "ExampleText",
 CellID->76698603],
Cell[CellGroupData[{
Cell[36979, 1355, 252, 8, 70, "Input",
 CellID->480883378],
Cell[37234, 1365, 1030, 33, 54, "Output",
 CellID->439012244]
}, Open  ]],
Cell[38279, 1401, 245, 8, 70, "ExampleText",
 CellID->18794560],
Cell[CellGroupData[{
Cell[38549, 1413, 138, 4, 70, "Input",
 CellID->472077287],
Cell[38690, 1419, 928, 31, 54, "Output",
 CellID->166266410]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39667, 1456, 237, 7, 70, "ExampleSection",
 CellID->796322304],
Cell[39907, 1465, 248, 8, 70, "ExampleText",
 CellID->319298288],
Cell[CellGroupData[{
Cell[40180, 1477, 436, 15, 70, "Input",
 CellID->165014615],
Cell[40619, 1494, 517, 19, 36, "Output",
 CellID->432588882]
}, Open  ]],
Cell[41151, 1516, 125, 3, 70, "ExampleDelimiter",
 CellID->299065826],
Cell[41279, 1521, 242, 8, 70, "ExampleText",
 CellID->602609135],
Cell[CellGroupData[{
Cell[41546, 1533, 1004, 33, 70, "Input",
 CellID->893844131],
Cell[42553, 1568, 952, 33, 36, "Output",
 CellID->802223497]
}, Open  ]],
Cell[43520, 1604, 208, 8, 70, "ExampleText",
 CellID->128224251],
Cell[CellGroupData[{
Cell[43753, 1616, 287, 9, 70, "Input",
 CellID->404930390],
Cell[44043, 1627, 160, 5, 36, "Output",
 CellID->53858810]
}, Open  ]],
Cell[44218, 1635, 124, 3, 70, "ExampleDelimiter",
 CellID->95993621],
Cell[44345, 1640, 224, 8, 70, "ExampleText",
 CellID->207036442],
Cell[CellGroupData[{
Cell[44594, 1652, 475, 16, 70, "Input",
 CellID->240980670],
Cell[45072, 1670, 351, 12, 36, "Output",
 CellID->505852764]
}, Open  ]],
Cell[45438, 1685, 243, 7, 70, "ExampleText",
 CellID->370437302],
Cell[CellGroupData[{
Cell[45706, 1696, 131, 4, 70, "Input",
 CellID->365831602],
Cell[45840, 1702, 259, 9, 36, "Output",
 CellID->216250362]
}, Open  ]],
Cell[46114, 1714, 220, 8, 70, "ExampleText",
 CellID->269404379],
Cell[CellGroupData[{
Cell[46359, 1726, 218, 7, 70, "Input",
 CellID->573821296],
Cell[46580, 1735, 282, 10, 39, "Output",
 CellID->228121759]
}, Open  ]],
Cell[46877, 1748, 239, 8, 70, "ExampleText",
 CellID->191568019],
Cell[CellGroupData[{
Cell[47141, 1760, 577, 20, 70, "Input",
 CellID->197863775],
Cell[47721, 1782, 333, 12, 39, "Output",
 CellID->672595118]
}, Open  ]],
Cell[48069, 1797, 253, 8, 70, "ExampleText",
 CellID->507858816],
Cell[CellGroupData[{
Cell[48347, 1809, 235, 8, 70, "Input",
 CellID->30347758],
Cell[48585, 1819, 493, 18, 52, "Output",
 CellID->334164432]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[49127, 1843, 230, 7, 70, "ExampleSection",
 CellID->457471148],
Cell[49360, 1852, 247, 8, 70, "ExampleText",
 CellID->27245002],
Cell[CellGroupData[{
Cell[49632, 1864, 342, 12, 70, "Input",
 CellID->360180507],
Cell[49977, 1878, 395, 14, 36, "Output",
 CellID->308059347]
}, Open  ]],
Cell[50387, 1895, 212, 7, 70, "ExampleText",
 CellID->87438477],
Cell[CellGroupData[{
Cell[50624, 1906, 130, 4, 70, "Input",
 CellID->54180620],
Cell[50757, 1912, 259, 9, 36, "Output",
 CellID->275305292]
}, Open  ]],
Cell[51031, 1924, 325, 12, 70, "ExampleText",
 CellID->56954183],
Cell[CellGroupData[{
Cell[51381, 1940, 163, 5, 70, "Input",
 CellID->724509304],
Cell[51547, 1947, 351, 12, 36, "Output",
 CellID->419677775]
}, Open  ]],
Cell[51913, 1962, 256, 8, 70, "ExampleText",
 CellID->675696407],
Cell[CellGroupData[{
Cell[52194, 1974, 156, 5, 70, "Input",
 CellID->130725184],
Cell[52353, 1981, 438, 15, 36, "Output",
 CellID->52390716]
}, Open  ]],
Cell[52806, 1999, 196, 6, 70, "ExampleText",
 CellID->90740353],
Cell[CellGroupData[{
Cell[53027, 2009, 131, 4, 70, "Input",
 CellID->547090882],
Cell[53161, 2015, 363, 12, 36, "Output",
 CellID->70319608]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[53585, 2034, 311, 9, 70, "SeeAlsoSection",
 CellID->18748],
Cell[53899, 2045, 1188, 44, 70, "SeeAlso",
 CellID->23251]
}, Open  ]],
Cell[CellGroupData[{
Cell[55124, 2094, 314, 9, 70, "TutorialsSection",
 CellID->22704],
Cell[55441, 2105, 144, 3, 70, "Tutorials",
 CellID->20588],
Cell[55588, 2110, 152, 3, 70, "Tutorials",
 CellID->12269],
Cell[55743, 2115, 191, 4, 70, "Tutorials",
 CellID->4500]
}, Open  ]],
Cell[CellGroupData[{
Cell[55971, 2124, 318, 9, 70, "MoreAboutSection",
 CellID->41769262],
Cell[56292, 2135, 147, 3, 70, "MoreAbout",
 CellID->337025012],
Cell[56442, 2140, 147, 3, 70, "MoreAbout",
 CellID->202059293]
}, Open  ]],
Cell[56604, 2146, 27, 0, 70, "History"],
Cell[56634, 2148, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

