(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     77338,       1874]
NotebookOptionsPosition[     71397,       1672]
NotebookOutlinePosition[     72773,       1711]
CellTagsIndexPosition[     72687,       1706]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EllipticLog" :> 
          Documentation`HelpLookup["paclet:ref/EllipticLog"], 
          "EllipticExpPrime" :> 
          Documentation`HelpLookup["paclet:ref/EllipticExpPrime"], 
          "EllipticTheta" :> 
          Documentation`HelpLookup["paclet:ref/EllipticTheta"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"EllipticLog\"\>", 
       2->"\<\"EllipticExpPrime\"\>", 
       3->"\<\"EllipticTheta\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Elliptic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EllipticExp", "ObjectName",
 CellID->18040],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["EllipticExp",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/EllipticExp"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["a", "TI"], ",", 
          StyleBox["b", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is the inverse for ",
     Cell[BoxData[
      ButtonBox["EllipticLog",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/EllipticLog"]], "InlineFormula"],
     ". It produces a list ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"]}], "}"}]], "InlineFormula"],
     " such that ",
     Cell[BoxData[
      RowBox[{
       StyleBox["u", "TI"], "==", 
       RowBox[{
        ButtonBox["EllipticLog",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/EllipticLog"], "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           StyleBox["x", "TI"], ",", 
           StyleBox["y", "TI"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           StyleBox["a", "TI"], ",", 
           StyleBox["b", "TI"]}], "}"}]}], "]"}]}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13182]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticExp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticExp"]], "InlineFormula"],
 " gives the generalized exponential associated with the elliptic curve ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["y", "2"], "=", 
    RowBox[{
     SuperscriptBox["x", "3"], "+", 
     RowBox[{"a", "\[VeryThinSpace]", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"b", "\[VeryThinSpace]", "x"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->22677],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["EllipticExp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticExp"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->121025626],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticExp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticExp"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->203358365],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->654230859],

Cell["Evaluate numerically: ", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticExp", "[", 
  RowBox[{
   RowBox[{"-", "0.4"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.043827135411493`", ",", "15.333640384130709`"}], "}"}]], "Output",\

 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->101885003]
}, Open  ]],

Cell["Check relation with the inverse function: ", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticLog", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"-", "0.39999999999999997`"}]], "Output",
 ImageSize->{33, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->72588819]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"EllipticExp", "[", 
     RowBox[{"x", ",", " ", 
      RowBox[{"{", 
       RowBox[{"4", ",", " ", "1"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFnGuoXVcRx3dzzzn3lTSJJppaaxKT3Ca3ebT6uRQp1jfiBxFbK8QoJqJN
qBGr4iNFzBeroEgNPor47ENIjTYVUxAL2oJYfFR8gUSQ+sEiWPwQELb/tf5r
z8yePXvfe25bvJDL2WevNfNbM7NmzVp737zp8Mmj7/nA4ZPHjhze8ZrbD584
euzIB3fcdPx2fDVzWVVVF/Hvc9sqfK7xKf87Udd1NZM+5Z/qtvSrir99Zf72
qaf+Xb6duOvrXK/4fn//vUbL2976Hd4orU596sIjF/7SSFkHJbOu3bX5+olf
/f34befSR96/4fozq5B++jM/Pf/QH/rHAJEQ3K/l1Td+9dKl/w5rWXfP13/5
ilD6xz7640d/9td+6SpnLdJ1bLH0W2+59+LFf61koQfPPnnXZx/t2h9f4la/
dLXckHQAArPP/mls14XSNSqGpD/+2N8+dPKhfu9++1tPnPny4/1jUAsOaXny
d/84dvRsvxYdY6wFCABZSQsu8FXXDwgghFGf9GTBfQNSn3nm0hted0/6uBu/
Evq6In0SjkWlx2PRaInH4udm0lqNVAv1W70zIcef//TPI+96oJ9DbT7EgaHD
AOnjVfiVMGbWyKPeiXk0Eod49Hp1dpkRPyEJIRX161d7DelHGCOY1+YXnw8P
hRxqpyEOzYtr5VCJnmPOReDVAxya43bVnBUzdTw7vP1irRpv/VqbnJe0sBcC
B+HTL1X7D41FZ+a1IfsXv/Dz++/7Tb8WHduQFp+NvBbNuLEWzbhDWjTjxlp0
9sdaNOMOaWnPafWHSoul6xhj6T4CD4VjwNKMBbpfi45xSMtb3vzNp5/+T78W
zf+xFrX0kBYf96rFx/3BUAsQAbqSFl3zDxV/zDvtXjrva05a6pWeZp2PJa81
lq5VVL/0bkR6LTr7Yi2aEYe0qLdiLVABRf1alGJISztm1A+qPZau2mPp8y5W
9tR2hfNj0ZiJten1kDaNnb1Oi19XPN2BUKtSDWnVdWVHzbpjtCrtuhJ47QuB
7fq0uxotqCl8NMTalGZIm1YeS3W8drKdzpBYm+bsWBtb6Vzf47SMQ62a42Ot
up4NadW9TjNGr23B9dsfatOZ1a8tZaqDRcti3c4NXirvw/xwQvq4e2AM2utA
yK7+ibVotMRaFl2E7g+1qD9iLVpHUwvnDRJwydH7Q61aVXitvK9Z4JpQK0IK
sxrgLa3KutVJ3RJRjIS95py/unhxfW6t2fHF5f4mx7LejWXWab0is41dTGxZ
gS1LnZXrLKPib67GHWshx6E5bFJtM/erXmJdF4aIdaZtKONnEuRPstPWIG5l
z2akLrlrb7dt7v5GR72hbs+aUdHzkozjz4U2Oxu8KLJviiB8Bct1aH2eWt9E
dKn+rnD3Lw9p1Xojx3OlodZc/IISe56W0nSu+93WntKPFDrnvU09Ja91xRgV
OaTzu63NPXRZyhgi7YawE6UbGovDgujIuGntIX2ckg5tYZ00yyM6yENrxHK2
3dCMytJGuCAofvw6e3njDbRI+rYWfZsdFyNTc56vEjh/pCpjUBZtyrOxiSjM
Qujs0IgW3E80VzuKTU1MoBROs3571prXzxG1Ym3GjSWnd1NjVchFmEi+4yhh
SfgHabvMV9XH+7gDbyR7vyzrYw5FCQAFWAIxlXY7fbnfGCAIS3wLYMnYZrS5
1QjdMRoohJrdTn/274j2wlcwzEszQZ6ZE/SEeiwH8AloALjTcbwwt8MF5hDW
O8xLhDUMv9ORsB30ggTtuNFAtx2OZ0vTDhqhBaNDOwwzzzl6b+7h83+889Qj
77z1Pmwr8fvYe8/e8eHzn7/r0SQm27ro9DMqX8+d+8HvP3LHwze//buvvelr
t9z8vfe/78FTn7xw95d+wd5Mg9pbR5Bn1jys/P0Hfnvi+DkY5Y2v/wYEABwC
YKaKErhBkh5mbFniPGCgDRJufNVXIOQdWcKn73wEdisSWDTI7M4PNMrKsSg8
NDkEwOQIuJKgm337Iq5TGFYVjP2Jj//k/nt/jbhFjCEMoShFts92ud9Yrmm2
Tm2XW01wTT8CAeIwZN8uS18ABcIGoQVOdMBt5D0g4Bsk8Xiv03+dM8IEHWEw
4OEGPsNhud16XMJw0IiYgQo0QEj86IcpueMzrIQGC05iXp/G4qFiwYVGXt38
YHrRdpANnSWeSrZcxCWCFLfwDdqcufsxhIjYB8aJz/HYewS/oBM0wCk5vhc4
EnwDM4Eb4iGDhgPqRhfVOUZSboIu9ARJnvXzmLtwDecQ7mJaQBYkJp6Njocy
0AOzDq2gZXMTq8CDDHgReBg6+qBByjXhqjeCGlgKKPBLuAuZh366hEPGb4wL
36SYzBHBmEsjAi0V55k0C/WQzUWVK04K8cudPVhT8D6Ec9bNoqUUOazRIKf0
9fUIWgEp3c9650ACK0AcNQADt9Fog7MAr+EAXKe1h71hVYwORuNejW6FyDzK
sspxZUn5f1tzzaK2RA4EIMEooa/5OdqkM/eflWtcUVYaTeLTGpxWSJ5kH1zL
EMFMa5W2vsrV9XFb4xnKwpWu9CMzQsgtFSZrPPRFrOkI9eRp0Y1QdosldnNl
OkuLUSRkgTbdW+/8KfusUuuwL1rimkeFvJdq1UU3UrkGZxpp7jthfUJXQju6
c5Q7GypII7jWZPGItEa/svEZ2lMyCZPWxXBEuoe70lCxCUfgR7PQWL0w5VXe
7MM4816eP9p8yFrbj8CfgV2V+4k0/PAEw9P7szH2k8oaPwx7v0vntVbguZ/Z
l3Au7crSZDeIHwaxP48ghe55cs01kWvZvizU9sRPdzVsLztDRhE+e2o5JSs7
yNzP7EsstXwrNvfUc6739vRrJHuhmqclfoXzZ6HbSzvOOt05+9N+fyq23bVn
1OdqciI7HTHRfMiuvbO0iTSvc8ZBjRDTq6e2dyxPYn8KOtd4rJxk+CrT0I+Q
dpB81IKeXZ4dQFbyYp7pE3nuITE779j9s0j2kzxXNyWWt7w/Q9/pbDBjLA8e
FBmSjdAoppcxFgo5zcEP783X9qmPnj+yvc0vjImYWve8Oxu95ZrUezo24DMb
/2zPv5GQ89JYnj7w6LCKLa7PKHZ2bMSM5dllz8t25WktWcUP+CFPzKpnfcyh
NqcxT/lq1j9L72YvypwNaf0zdtLKmWqdCw0Ae1p/NkKtNuNb/3paPXnZ1bEO
ySNafS8j737HQsPBd57sUpfmrF0dP5Jjrrbvhmiuyu1HNqMmgtiO/s2dpY73
GKH+Sbt/6yjPx7GsyyVCZ4LTcfZ059RjiR+GaBXT+jewSCvPOJwXPK3TGYzS
71P8Ncei71/kqBvb/I8bHXYfcyYWWuses45nD3UGkbc6dq1ZKEcyHX6YOfy7
P/7NMNLnc6Ox+INJtPM+xtiNfE/PmCN2jR3N3uxv13yOPWbWLG6ZJQp47NrD
rDqX2vFJ5VX03GfstJJWTndltDGtVgeW1ubDG64/00OrOhlVMkaauuo+h/NP
Dpba/iyjjEl1hTGkrYrARpJn1Z0OWeVaQjzZ1p9+jp3mpbYvyzhjXn37wvLa
KOIMjnnbOrV21LctxrV9DqgzlR504+swspeug8uG0c4UnpjHjO6th4mt6Zjh
vf/lWVp58kB9NhtwfOOQVldfS2tXX0aDp6VW9wbIRHJS3dQYMa1SsJ/NgYyE
mFZzF2nz2qEzuuSumFVzV9Y5EvYSCzGpe1+nVV9wzsWkOo8tqayqbN5DqrUJ
e0nUc/h8x7ZEaSLPrVqVMNfDmExnrSWTb0slE5NpJcNeMmtb4/E21CdEtKHM
K/xQYkyqZwOWVCzbmoWe1L2dqyt7WStiUs2i7CWZoWTRmFN1G87WGQJb+NbU
ebr9tvJYrhmgPaTuDZixVH+l6opJNbtYUptj7OzzpLon2lvb/KlZuXkC5/uT
UaxbYswzyglieZviGsNo5x3HGjO6t+NbmcXmQW9P93cHY4nZEmUxq+YUy2pn
Ir0Zs+pOi/3s3tSO0Z22mxVmX8sP6t2ZkFavLa2djZw1Ma2zUCvX20zoaV21
3KrxqcPT+cxL2txb6xpOr06kUaeuS/sGPKLViere14k2zrSYUdcjyyg0HEIP
Y/ud6mS25h3+2I5qDzLaapTREjGm6Nhv2CRjM9h62Jw9ZsFCw+MD64EqqOxm
nE36bB/bUlcJa0vJa2WFiXm1ihHe8tSvqooTeniTfbI+XWUJ0okMn60tpXxb
VpeY0lkmUZZn/1VV3FEoEyT7uDrC5IxEHjNqnraMYt+yrkSMSeZyw0Yx+FBM
3+txtclyO/5LvRJT6nmFpbR7j7RLWpGSyvGhmL6XUtd2UsoKWgIkplTNhrK1
qtAjvrW3TF4xE5yJ8/65rrZZDmfBNKx2VbH5tp91udg43zDrn+ZLV/Fo9Viq
j5hP1yfLZ3Mts1PMp1G9PBAp3pKeVEZZahBPyl668zO5szfjelLnvVZ9ZaPF
s7rqTCvdQVb37mWQdYdY9SRtueMNGy2eVauBJlp8LbgupNVqwNLaGsSuEZ7W
ebNFy8qvqUC9H5njbe2RYia2qF6Tkd6QkZWMExNqfl4e9IM/3VMvZtLWrGXd
6tmGWIWitZZ51rYP187ajZmY1b2LXFY0pdIVzXyXr92eoHU+wdwTk7r6vFWz
Ml6mIdW9RT+pm41h1Gh8uoo88EDMp/tw63XJO60VbS2EXUvqmcQ0pMlOB6Ym
1JNt/1642t3zOY/pqMrbJ6uhk1Wstcp6OjfjVkWnlV9s89jLWilYL8sKNg2l
VjumJpO/jGzsoHljkOt0+738wiW0g1ztXcxMfh3wePPCLcu5MAKVUSTykGsK
RqlpSqm4EqHUmBJGdT5jjGrMFqOLiZhQ65mAsLXir47QxkUfYSemzDlSP6nW
M9bfkoMGWGV3NcAofzNQYo5eFp1lnz8Nmdin7HQGycob5uXpVWaRJaLz5E3e
YbOx1clqMatWWiFrbSuSYSviMsVJVbUs7yn1nJeUcj1IqZotpa1G+ihtbOVz
qcbBUqhHT4PWRX7UHDc9a6saYUXtW8deFE8Yq+pK3UtYst00hLYKsfXSqgnL
niy2pc5o9pJdxCCp1oKW1K7y05BaH2i8eNK2dST3PY+c3ovPirM8qZyG0+5z
bNW0Fk6NTffXeZ3M7Al9Tc0ayJ2ClZOpVfH1RrS3pLNKZ87FpFqxTk/qZkNv
pKxEKhmwrCkxqe43LKn4p5yoxaQuV6yZ1MdKTKrXllQYWvXf2khnmnW9ZKuD
/yc6u1c0c24idpTwO9iJZXrOMz2XjAf6Y7mXsGvvmFBPxS2hzIhBQo2q55PQ
/fV4IZTswqXrWRBKDJb88hzQmdynFXM/Wzr3zRXuhOHEXQ53E10bMn+Q0sYt
Tx6eP8p8CjdfNX99yt9PNX8bJFHSYiXHodD205Bq7SCkEyGtmxcQ81ye09zX
xnsu6PRMZRo6xlLuMdtvOe5xVOPBVXM1/29AMzcQBjwjhlnS8y05VS12Weeu
OQoh0x1N8xSpYzmIh5JsuZHIaU7lJ/KNIJDuSFuOKFzpXUb+T4Xvrtv/T5M/
y2eri53f1WX/Ax+McE0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87863333]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2408],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->2497102],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticExp", "[", 
  RowBox[{
   RowBox[{"2.", "I"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "-", "I"}], ",", 
     RowBox[{"2", "+", "I"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107725575],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.2937013001998705`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.7406349874246752`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.6983712526491788`"}], "+", 
    RowBox[{"0.9885753824797981`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{309, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->133671312]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->250903755],

Cell["Evaluate to high precision:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"EllipticExp", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "]"}], ",", "60"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.0032900522422674832163222492234390994969467624279911379921592590838332606\
1168`60.", ",", 
   "0.081251393742102163038356240091874540633164238984323060795523186056230043\
6065`60."}], "}"}]], "Output",
 ImageSize->{466, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83545618]
}, Open  ]],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticExp", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], ",", "60"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.0032900522422674832163222492234390994969467624279911379921592590838332605\
8713`58.03267549581852", ",", 
   "0.081251393742102163038356240091874540633164238984323060795523186056230043\
30239`58.318395692103834"}], "}"}]], "Output",
 ImageSize->{452, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->302018472]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21280],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"EllipticExp", "[", 
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"I", " ", "y"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->58474681],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->325129130]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3206011],

Cell[TextData[{
 "Define addition on the elliptic curve ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["y", "2"], "\[LongEqual]", 
    RowBox[{
     SuperscriptBox["x", "3"], "+", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"b", " ", "x"}]}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->192894915],

Cell[BoxData[
 RowBox[{
  RowBox[{"ellipticAdd", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x1_", ",", "y1_"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x2_", ",", "y2_"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a_", ",", "b_"}], "}"}]}], "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"s", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"y2", "-", "y1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"x2", "-", "x1"}], ")"}]}]}], ",", "x3", ",", "y3"}], "}"}], 
    ",", 
    RowBox[{
     RowBox[{"x3", "=", 
      RowBox[{
       RowBox[{"s", "^", "2"}], "-", "x1", "-", "x2", "-", "a"}]}], ";", " ", 
     
     RowBox[{"y3", "=", 
      RowBox[{
       RowBox[{"-", "y1"}], "+", 
       RowBox[{"s", 
        RowBox[{"(", 
         RowBox[{"x1", "-", "x3"}], ")"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"x3", ",", "y3"}], "}"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16542044],

Cell["Use addition on the elliptic curve to add rational numbers:", \
"ExampleText",
 CellID->3369491],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ellipticAdd", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"EllipticExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "/", "3."}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "1"}], "}"}]}], "]"}], ",", 
     RowBox[{"EllipticExp", "[", 
      RowBox[{
       RowBox[{"1", "/", "2."}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "1"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->330668327],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"34.690370443334544`", ",", 
   RowBox[{"-", "215.85996773348234`"}]}], "}"}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->432372657]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"EllipticLog", "[", 
   RowBox[{"%", ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "1"}], "}"}]}], "]"}], "\[Equal]", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "/", "3"}], "+", 
    RowBox[{"1", "/", "2"}]}], ")"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->13937039],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->37713105]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->80798860],

Cell["Map integers on an elliptic curve:", "ExampleText",
 CellID->48020595],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "^", "2"}], "\[Equal]", 
    RowBox[{"x", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"4", "x"}], "+", "1"}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"PointSize", "[", "0.03", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"EllipticExp", "[", 
          RowBox[{"#", ",", 
           RowBox[{"{", 
            RowBox[{"4.", ",", "1"}], "}"}]}], "]"}], "&"}], "/@", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"Range", "[", "10", "]"}]}], ",", 
          RowBox[{"Range", "[", "10", "]"}]}], "]"}]}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->161398891],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdmHk8VN//x2fMWIYZZWlalD6VVupTktLi3CyFkkiLpCiJilZaVNoX7QlJ
fUpJWmilBZ0TbYSy73sie/bG9tWcc+b3+I0/3MedO3fu+7yX1+t57qj122w2
yrBYLJn+f3+Pha/jajcb9wGW+E+dUWIu+KQ/7AULZeY/KNqnxqT5qeRWpvaA
bxo7rbeXqTLb1R46rbLuAWPNr2iZX1FlHhQNvMOd1ANkQ3VNV29VZSaIP+8G
tZ5bBLBHhdF77zfRY003eO1eEO1eoMKEuZ8Y9/tOF9BOvG/m6qjC9D2VbX07
tQtY/L1NS4UBvdfmCS+IwCXgcvHE3YGMhsbajIbhItD8kyOjazuQ2fH3Z6L/
gNTlR9buVxzIDNHTvVY+9Q8o/vux+wDGZ23XjGNnO4H3uyKNx/7KjLvzbu8h
2h3g8Ifik5pv+Uz4xoPJssodYLw4Tj6TyLVf1M3qALcP2uQf8eEzb8VxtgPr
5wUT3Mz5TLvpU6vmujawWByfErNsTpqa/4Y2ENo6B37eqch8s9mWtyG9FWwX
x8VjOOI8toK4F8eLugMUmCfp59pl01uAYYxM4ChHBWaysSUzMrYFXP37c+YK
TPn04jVjrraA44avGX01BWZxb4z1IJn+6x49gg2r5ZmukJLNuy82gzfiuOQY
3rIUh5m6zcBecEon2FaO8eksnpP99Dfo/JWUmftClvGKCPSW8fxN8iHL4Lh/
A9i2ps6xl8vUag2JhOebwAv9k5Zui7jMkgyzye+smoCMOG4us3Gtw6nrpxqB
p7LpwZtWHOaryQ9/zr5GMOzIow3WCzjMPtPnZbOnNYBx4vzJMFvTpmfNSqwH
g6rcZp036T+vLfexGVFP6s1mJom/Vwe+dxf913CUzTy6p/hRpFkHtL3lyjbO
ZzOL5a9NGVleCxaJ42QzujPVEwftqgUpAtOdHwtZTO7IP+iDew34MPbmyW7A
YtYXjm+e6PQLlIjX1wd8Gu40LnhbDQ6184DFoV4QVHBo+0fzKiBkObM9E7vB
lp3ve5oGVwHal7aWv+yDeVVgjZ2Sja53N4gTx/kTNInOrMhmuoH6tSb3vfmV
pN5dIOtLp7r64kpQOTnc8PQhESi65mKZc/sHoH0oJ87bD7DaUnNPQFMnAGZT
/vRerQD7WM8H3TvUCVhbj59D6ytAgLjenWCF+QevzMpyYGj+KEU5tgMEzTOd
0ahZDmjfqbzWnL0xqwzkrV5ryD3WDqzEcZSBPeMtZnlEtoGLLcZ+MypLSX3b
gPyyIgsHtVJw/9YYn+unW8EhjkHDIZ0SQPvwpIIrW39HMZhyKemLyekW8LI2
bMXMskKQuGPwM25YM2iuLrL6FFtI8tMMGm17pvg+KwSzTnaU7fVtBlPFnxeC
kLkNOk57mkGkc9ryGOV8QPtK6Bh4t35sHnjl32bZfLkJqFm7KlZMzwUm6tfj
O/lNoMY/KS70Yg4oE8fbCBLE68wGrrVes9PONoDkkS9NRwdmgXFNY4s89OpB
dl5+TXlVJqB9M+RxrtxA2wywvPrS4uupNcD+foh5m1062C3O/y/QWuA98zI7
HYTqn223N/sFlovjSgPnHRfYD9arBpEPox2eHf4mqbPOYBMN23spYO2kYUH7
nleCuHnfDdz6kkG8gWa2h00lSBk6D96xSJLU9cafDOfcLYlAteiIbaV9BRj8
pC70pvwXEl85+Cb+3U/AXid5Zkp+GRj40D+1ruEjABz9Y8/XlYH4FQvuLj/4
UVLHtb/8J2u7fgDTp2WEvT9VCr7wwj6Xbo8Hel06Ny5+LgbxDtbCaUIkyXvn
c6fHqj1xoO7V1KqSxHzAV1S8bDnkNUhW3xRxb1IO2OLFaxadeSXJa5X4GA3m
HE9cW7UgG7y1NhSmZD4FjnmLdswOSwexpur+BdUPJXnq/qarHPHnHkjYHrvk
TVIyeDIjKiq/PRSMjjFz1hqaDF6Pystzrw2UrHPa7JPciGJ/EBJmIbw28gOA
XqFZSYIj4GL3RZXxPa+B4n3Nrw/DvSVx2N8rKjTM2Qve+wkS/1hGgeLwv9ft
wWCPv9fDiO98mWuR3P93TmXe0exF0Sen3Ix1jXPeUp2eN3e8wYS0aQGhsfR7
IAdfp0f6uXNK//38gXHK9/HvrxQ/PwwGheLnu+Pnw9FhOL5TOD44msSvgeOH
pQZ4fd54fdCWrP8WXj80IfnJeSvOD/xC8ncb5w9uJ/mdh/MLb5P8W+H8Q5qX
ebg+cBGp3yNcP5jGw/UNw/WFBaT+Bbj+MJL0xxDcH/At6Z8xuH/gLNJfI3B/
wUek/4xx/0E26U993J+Q1tUjzLclKaMMviH9L+r7+1cBI8l8vMHzARXI/Jjj
+YGBZL6e4fmCUvMH68l83sDzCa3J/Lri+YWyZL4ZPN/wK5l/TTz/8CPRhxFY
HyDt801YP2Ap0ZcsrC+QRfRnNtYfOIDo0wusT/Au0a8FWL+glL7Bq7Mz/ODT
fn3kx59+5NsMfVyMp9sXFgKvS4bhKaHNcOiSNk2timLQI85PC+QQ/b2L9RfS
OQ8crvpyY2gbVCZ6non1HJoNE94J5ZeDl1jvoSXxg+nYD6BoC/aLS9gv4Bzi
J57YT6CU38Bc4kdbsB/BE9U2k+5PqAQPrUpl/l0kgrX5g1La+3UtIzSoXOgt
ggOIv+H1d0Ep/4MbV+86clSxCqTaLIDv9nfDoDXNO0s1qsBo7J8wTf+UiqpV
FXg8udpaI7kbWlYc3pX2owrom0aMWuLdA68cte0Zsrga9Irz0wMPEH/ej/0Z
vp8edXXC2V8gD/s3pDouu039kt/NPphJ/D4e+z2aRHjgC+YB9Mve5KhRXS0w
w7yAwglPTMQ8gaR4A7kRHonGPII2E15Rx7yCPAnPaGGeQV8I7wzBvIMcCQ/t
xDyEFhNeEi+vj4N+EZ56inkKSfEW2kV4LB/zGNpPeO035jUkT3jODvMc6iS8
h+OVQxaEB/0wD6JSwouHMS8ibcKTVzBPoltCRX7M9xZgMtSE/9lRAUnxKEom
vIpliIesCc+GYJ5FLYR3cX6VkBQPo0JoZd/M7gBq/6xKl/PhozDC0zh/fLSZ
8PYBzNvoIOHx/ZjHkZDwegHmdSTF82gY4f3fmPdRnI5bqgkjIt8fiOaR/cEF
vD9AW2SjBW/MuoA53j+gULK/mIT3F2ga2X/gfKogqf0JCif7Fy7ev6BtZH+D
16OKvpP9Tyre/yCp/RGiHDohr1gU1KOGZgtmX83dLtlPoSfRU3QdQDOk80l1
Jz9Sfvx8nU5Y3TDfz+1KE1RTebc1wL0Dttx4oD9gdBOk+kB18MO6F3eFo1rh
t1s98xI86+A9W4sWI+VWOKTXcaLLujpI9chN3/7AKlYdvOP145H8qxYoy024
bTy1Bmbq8ZX8lzfDaFP328cvVUvi+LLP2TK0rQrO4Zf2eAU2Qarjy66XQa5R
IxTqHTpc9qkSvjnauDorrB4Gfa4b5db9QxLXpylLXdLuVcAbj13kFVVqoOsZ
27nhWyog1fcFS/c7LAgphy+1p30dtaoadgZ0wvi3ZZLnPPVdmGhysQyaeL7W
j9n+E1KfcpvrZup/uhL6v7bb+1m2pF8Hh2czn8rh+VUu2o8siyTfoz7IGqvv
u8mmFHYXjRYtG1MAZ7xkWxmyi6Hvu3U8OD9f8r3oiRNuVjF5UPm8qeE3nXx4
pH53kpNjruRYWh+iuS8oB1I/TtgL035tyYF+6zuCf1tkSz4/vSu5VvZ3Jjwe
dsJvzIZs2CrOfwbU1jqidvNhFowrOFS3fnk6nBkToP9xXBakPNCgwy57MSkT
su5e/fm0Khmq+kbHZKlnwjS9sRE3XZPhu2PnHcxz0iHljWhhqlnzrXQY4Xz6
VcSPBOiZoLruM0qDLrpXlY0Wv4FnSl7KjbySBinPbByTNNyx/7xqgqmrvlYU
vLJqBNM0Ng0m+Duf21YyCJ6Zuuh2Wf855SZ6PWOQy9/rwJXcP3ui+H5wjvw+
5Zb95PmF+PkghsSXgeMDH0n8lCuGkPW14vUBEVm/OV4/mE/yQ7lBl+QvFecP
XCT55YvjzZRw0hmcf5BE6hOK6wNqSP0oJwSQukbiI3hH6q+J6w8CSH9QDuAW
4/4xxf0j4aw+LXF/AfvDC+++ERbByPZE3uryUnCN9CP1/f9IvxrjfpVwlyvu
Z/CS9Pti3O+gl8wD9eEVZF6+43kB28k8UZ9MIvMWiudNwmkf0mYuLLlRA54u
3zM1eFglpD6oQeYX4fkFUvMNUsj8G+L5B++IPlAf4xH9yMH6AVQrgvo43jWQ
7hePEr2JwnoDdl2LUXZ2qoPUdzKJXoVjvQJSegbyHhxLvv2pAa6JKy+f/74N
dBD9o75TQ/RRiPURSOkneEn0lfqIo9P70T/kWqDy/jaLjiciCadtvfDOQPSz
CxivShvkdLIVUh+YrPGPzd3gNvgk2PKMWnqPhMuUXsgOvzWmD7Tk6zlYreyE
jws6PENcWAzVcV+u3uR1Gmzmk3dEhRL6A0cYTVQWjWQzUecExrcS/0D6PoNy
lr23vQvzgc1kDI4c3T23CzY/FCbN+sZmXqmF2h2w64L0fQnlLJMZ4c8HrpNh
civlRnxN6oZfRSsnKHjJMF/zNR/oq/dA+v6Fcpbzaqu+t7UyTKzQNmTT1l44
Y+it902qHCYjZ7ioUqkP4vdNHObk4eXTUkz7YBxYvmmoA4ehHDZwhNFemc0c
hu13IiJ/AAtNLBycPuYOhzHV4fAKVPvPn7xwZoVyGMwxLMQf88Z0SS6HCd97
6wo4xUJ6hqlme35ymBF7l1c5vmEh+j7Jz7FvY04fC72aNrbirRaXodymsaO3
2kifyxTq+6mOPMhGhfpmoUvWcpkebv6jvJNs9Gpn1PqF67kM5bYDyU4Cw2Nc
ZlBubIATWwap7Mg6X3WJyzwvDj17ZZ8Mwu/fuAzlON/7tovD3nGZPyYXVjmP
5iBezI77wUVcJtwqPP39QQ46JSeM3FvLZSjHbaqfcXDKHy5z6afCeqEJF7Hj
4bffov74qwNS3HdxkUVqtsC8/3wrfg7SvpwoZ9bBZQL3gystTVwUjI+M1syD
iqOALBpnf99wRyWXodx39uw2F6P+559cZ3vg8jlZNPz4TeXoLC5z+W/AibJo
VnC3/Y9PXEbX8ITuzy5ZyXqihBZREcPkUNG6wrz2xzR/csgmIPfgowf969up
bWcwWw5B0RMHvRAuo69fZRx4Qw413Y0XcffS/Mmh0sDG2Z52XObQYdMRUwbJ
oyTVzS7IgMsY2U5ZGr9dXlIvnD959PrVIZd/aznM5rkDOvfUyaP8wZ82LrvL
YShnvohrm+5tx2Gsplde/GingGh/3dLw/bg7UgFNZzJWBnXIMNhneMhgnW7E
/VsyjM316veNijxE+3ezsK0+fAUPjTn+PVSoK8OY/wieXHqdh+g8UE713bQc
eESzmYlhykzgbx6SdzigsWQdm0nNj9RKVVdEdN5wvhXRLu4E1wdXWcy8Cf8i
M29FxIiPLIYjX2jle1QRFeE+ZsC3Hfobrimiff+5HVY0ZjELrllOmVCqKOG6
6bHr74S0K6IoxZrzWSp9Ei5O6GUlr7HqBZ/9Ky/EuSihcUvVn94S9oDWoFdj
tQ8oSThTVX2+wsQ4JXTV1C5Mw6kLmI42CKlNUUJuXSUjLvC6CJcqoaWKwWtX
IxGo0Rx8L1uOL+Fi1u8lx76M56NJ2lO188s6wTivl42XXPnolVrgP8VTOoBe
c0tlzG6+hNP9OHacJ958dK3cdbdBZLuEy0eGdGtHcdpBUsE28/uhfETfH0a8
aYpYmsBHwrJY1QHrW8HEySUu51L5kn3DRg8T34piPjoSFaz31aUFJLB9wEqO
APlyeg9FyjUD/9D9oY+GCiT7nq1lFq0xMwVoT4LLMrsXjUClKTWqbq4AFf04
7pYztxFkbrtxN2uJQLJPs4hvrH+yRYBsbawLFebXgJeFhg3IU4BqRSU9btxf
4N0Dz7MjDwsQ9cfmAwpaulcE6IRTzwJ9rUrQYKBSMeeOAAU+LIm9E1wOgurO
mFc/FCDqx7u9PU4PeiZAgBWX9T2tBCy5fGZpBRKgFRUXdJdl5oL6rhF/6j8I
EOWF5IUy22M+C9CYx/X65kOzgEfbPwFN6QLUKEy2dX6cCEwVZ2ww7T+nfMP7
r9ZnV5YAOS3xj7qn+wHc2H1Pa1+eAH19bhrhbuwHXg486QhzBIjyFr1u8Ux8
HdL7dfH98OSWgd2+mQJE+Y8+/x1+PqTx8XF8kMZPuYiuby5eH6Trn4DXD5Oy
H+/1DBMgyiU0f744f5Dmdz/OL4Qk/5Qbokh9inF9IK2fOa4ffN9w4MedlQJE
fR7rRX/9jyZNMhE2QNoPGbgfoDvpF1fcLzCA9BP1edpvJ3C/QRfSj/txP0Ln
LM6PjV/5iPp8JOlnFdzPkPb/4ZQLq493t0GNg54lwv75uJMVosOLaIczyPxQ
3x9P5usJni/IJvM3Fs8f1K0pLnbrVUKUA+g8b8TzDNXJvPvieYdtRA+or38h
ejEa6wWU0hOoR/TmGdYbaEb0iPq0EdGrnVivkCzRM+rLhkTv8JGFpPQQfSd6
SX34gczNmr5GHjr+RvFTtAMbSektsiB6TH14pe/ao5PseEi508Dgmp4Mim8C
Z42MeWj9KpsgOSsZZEv0nfqwlP6jPVlzpqk/VkA80fGEWW0yyJr4B+4TDpLy
F3R2RHvtv43yqLPzsZ1SGAdZTvvO+6dCHmUPjh828QkHSfkV8jaeeybnhDxa
IXrgfKGFgxYSf6M+f5j4XyL2P0T98c/utZVgNRc9qhpl0ZUrhz+356JZxE8b
sZ+iFuK38dhvkZQfo9fErwuxXyMH39UWb9tlEeWGM8T/NbD/I8oHR38ZCBsL
uWgq+9uk7Ib/O9L75jnPNYpt56KGRSuLh3txUc1mYU9QBxdJ8QuK+P98g9oJ
/yhg/pHUhfARCiP8RJ+jSvhqIOYrSd0JfyEZWcxnbzCfoXzCbwWY39B2y8nx
V7zYkvzRPiu//jA7Tp+LLhMejMY8iIYQXqTrkOJL9NR/0/zN6iwUa2qls+MO
B0nxKkomfEv7J5/Xq6Pi0QtDRyZ1aahykBQfo4+En2kesglfJ2G+RlL8jV4Q
Pqd5uKxnHr1wXhe8NNycpfaNjaT4Hj0h/E/XnUD2B8Px/kCiGytHKJhf1mCj
Oh+1GGO7TkjX7TXstoe9dSesmmPkHuzGQtlLIhO2sjsgXTfVqXUWl1fVGfXB
A+MdffoC2+Dqi4I1r7J6oCHZ39B15Jh6aXpYtEIzznC5goXdUGo/BEcNjp+7
X7YFLvzQOtXpmQhKv6/6H2W1OwA=
   "], {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     TagBox[
      TooltipBox[
       LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
         19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 
        36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 
        53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
        70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
        87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 
        103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 
        117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 
        131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 
        145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 
        159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 
        173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 
        187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 
        201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 
        214}],
       RowBox[{
         SuperscriptBox["y", "2"], "\[Equal]", 
         RowBox[{"x", " ", 
           RowBox[{"(", 
             RowBox[{"1", "+", 
               RowBox[{"4", " ", "x"}], "+", 
               SuperscriptBox["x", "2"]}], ")"}]}]}]],
      Annotation[#, $CellContext`y^2 == $CellContext`x (1 + 
         4 $CellContext`x + $CellContext`x^2), "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwl02V0FgQUBuBvo5GWkpBGSkpBCQWkW2npUqRROqSR7u4U6ZaSVhqVzm0M
Rvc2uh8OP573/r3nnvdmat6xRoegQCCQR5wxz3KO81wghFDCuEg4l7hMBFe4
yjWuc4Ob3OI2d7jLPe7zgEiiiOYhj3jME57yjOe84CWveM0bAvYMIpgYxCQW
sYlDXOIRnw9IQEISkZgkJCUZH5KcFKQkFan5iDSkJR3p+ZgMZCQTmclCVrKR
nU/IQU5ykTvo/V0/JS/5yE8BCvIZn1OIwnzBlxShKMUozld8TQlKUopvKE0Z
ylKO8lSgIpWoTBWqUo3qfMt31KAmtahNHepSj++pTwMa0ojGNKEpzWhOC1ry
Az/Sip9oTRva0o72vCtZRzrxM7/QmS50pRvd6UFPetGbPvxKX/rRnwEMZBCD
GcJvDGUYwxnBSEYxmjGMZRzjmcBEJjGZKUxlGtOZwUxmMZs5zGUe81nAQhbx
O4v5gyUsZRnLWcFKVrGaNaxlHevZwJ9sZBOb2cJW/mIb29nBTnaxmz38zT/s
ZR/7OcBBDnGYI/zLf/zPUY5xnBOc5BSnOcNZznGeC4QQShgXCecSl4ngCle5
xnVucJNb3OYOd7nHfR4QSRTRPOQRj3nCU57xnBe85BWveUMg2P8TzFv2z6gN

        "]],
       RowBox[{
         SuperscriptBox["y", "2"], "\[Equal]", 
         RowBox[{"x", " ", 
           RowBox[{"(", 
             RowBox[{"1", "+", 
               RowBox[{"4", " ", "x"}], "+", 
               SuperscriptBox["x", "2"]}], ")"}]}]}]],
      Annotation[#, $CellContext`y^2 == $CellContext`x (1 + 
         4 $CellContext`x + $CellContext`x^2), "Tooltip"]& ]}}],
  AspectRatio->1,
  Epilog->{
    RGBColor[1, 0, 0], 
    PointSize[0.03], 
    PointBox[{{0.217917186230826, 0.64669715942612}, {
     0.542349325787202, -1.3705650787165}, {33.9010800689024, 
     208.789311977435}, {0.0663092924073123, 0.290152611998147}, {
     1.24652277733675, -3.06572499309335}, {7.56173627518915, 
     25.8584637163099}, {0.00624282306674842, 0.0799934855264031}, {
     2.94346923292115, -7.94366187058026}, {2.77237376738197, 
     7.4044054365773}, {0.00815848230625659, -0.0917892623121318}, {
     0.217917186230826, -0.64669715942612}, {0.542349325787202, 
     1.3705650787165}, {33.9010800689024, -208.789311977435}, {
     0.0663092924073123, -0.290152611998147}, {1.24652277733675, 
     3.06572499309335}, {7.56173627518915, -25.8584637163099}, {
     0.00624282306674842, -0.0799934855264031}, {2.94346923292115, 
     7.94366187058026}, {2.77237376738197, -7.4044054365773}, {
     0.00815848230625659, 0.0917892623121318}}]},
  Frame->True,
  FrameTicks->True,
  Method->{},
  PlotRange->{{-5, 5}, {-5, 5}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->800652281]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Differentiation:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"EllipticExp", "[", 
    RowBox[{"u", ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}]}], "]"}], ",", "u"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"EllipticExpPrime", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}]}], "]"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32194116]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3289],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticExp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticExp"]], "InlineFormula"],
 " is a multivalued complex function, so the inverse relation does not always \
hold:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticExp", "[", 
  RowBox[{"12.4", ",", " ", 
   RowBox[{"{", 
    RowBox[{"4.", ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.13643514261682588`", ",", 
   RowBox[{"-", "0.4619881099234786`"}]}], "}"}]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->69614987]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticLog", "[", 
  RowBox[{"%", ",", " ", 
   RowBox[{"{", 
    RowBox[{"4.", ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["1.0741023325923502`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->733015599]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8568],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticLog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticLog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticExpPrime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticExpPrime"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticTheta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticTheta"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27529]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5107],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->30223]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->37],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/EllipticExponentialFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/EllipticFunctions/EllipticExp/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->364506598],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->2526740]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EllipticExp - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 39, 56.3387416}", "context" -> "System`", 
    "keywords" -> {
     "eexp", "elliptic curve", "elliptic exponential", "elliptic function", 
      "exponential"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "EllipticExp[u, {a, b}] is the inverse for EllipticLog. It produces a \
list {x, y} such that u == EllipticLog[{x, y}, {a, b}]. ", 
    "synonyms" -> {"elliptic exp"}, "title" -> "EllipticExp", "type" -> 
    "Symbol", "uri" -> "ref/EllipticExp"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5901, 201, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->203358365]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 72544, 1699}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2075, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2698, 80, 49, 1, 70, "ObjectName",
 CellID->18040],
Cell[2750, 83, 1453, 48, 70, "Usage",
 CellID->13182]
}, Open  ]],
Cell[CellGroupData[{
Cell[4240, 136, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4718, 153, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4841, 159, 539, 18, 70, "Notes",
 CellID->22677],
Cell[5383, 179, 254, 8, 70, "Notes",
 CellID->121025626],
Cell[5640, 189, 224, 7, 70, "Notes",
 CellID->31226]
}, Closed]],
Cell[CellGroupData[{
Cell[5901, 201, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->203358365],
Cell[CellGroupData[{
Cell[6286, 215, 148, 5, 70, "ExampleSection",
 CellID->654230859],
Cell[6437, 222, 182, 4, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[6644, 230, 180, 6, 28, "Input"],
Cell[6827, 238, 241, 8, 36, "Output",
 CellID->101885003]
}, Open  ]],
Cell[7083, 249, 202, 4, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[7310, 257, 159, 5, 28, "Input"],
Cell[7472, 264, 193, 6, 36, "Output",
 CellID->72588819]
}, Open  ]],
Cell[7680, 273, 105, 2, 70, "ExampleDelimiter"],
Cell[CellGroupData[{
Cell[7810, 279, 344, 11, 28, "Input"],
Cell[8157, 292, 5844, 100, 163, "Output",
 Evaluatable->False,
 CellID->87863333]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14050, 398, 215, 7, 70, "ExampleSection",
 CellID->2408],
Cell[14268, 407, 209, 5, 70, "ExampleText",
 CellID->2497102],
Cell[CellGroupData[{
Cell[14502, 416, 251, 9, 70, "Input",
 CellID->107725575],
Cell[14756, 427, 442, 13, 36, "Output",
 CellID->133671312]
}, Open  ]],
Cell[15213, 443, 125, 3, 70, "ExampleDelimiter",
 CellID->250903755],
Cell[15341, 448, 187, 4, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[15553, 456, 252, 8, 70, "Input"],
Cell[15808, 466, 377, 11, 54, "Output",
 CellID->83545618]
}, Open  ]],
Cell[16200, 480, 93, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[16318, 486, 248, 8, 70, "Input"],
Cell[16569, 496, 408, 11, 54, "Output",
 CellID->302018472]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17026, 513, 223, 7, 70, "ExampleSection",
 CellID->21280],
Cell[CellGroupData[{
Cell[17274, 524, 500, 17, 70, "Input",
 CellID->58474681],
Cell[17777, 543, 32360, 535, 70, "Output",
 Evaluatable->False,
 CellID->325129130]
}, Open  ]],
Cell[50152, 1081, 123, 3, 70, "ExampleDelimiter",
 CellID->3206011],
Cell[50278, 1086, 369, 13, 70, "ExampleText",
 CellID->192894915],
Cell[50650, 1101, 1091, 37, 70, "Input",
 CellID->16542044],
Cell[51744, 1140, 102, 2, 70, "ExampleText",
 CellID->3369491],
Cell[CellGroupData[{
Cell[51871, 1146, 560, 19, 70, "Input",
 CellID->330668327],
Cell[52434, 1167, 259, 8, 36, "Output",
 CellID->432372657]
}, Open  ]],
Cell[CellGroupData[{
Cell[52730, 1180, 329, 12, 70, "Input",
 CellID->13937039],
Cell[53062, 1194, 160, 5, 36, "Output",
 CellID->37713105]
}, Open  ]],
Cell[53237, 1202, 124, 3, 70, "ExampleDelimiter",
 CellID->80798860],
Cell[53364, 1207, 76, 1, 70, "ExampleText",
 CellID->48020595],
Cell[CellGroupData[{
Cell[53465, 1212, 1051, 34, 70, "Input",
 CellID->161398891],
Cell[54519, 1248, 11427, 206, 70, "Output",
 CellID->800652281]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[65995, 1460, 217, 6, 70, "ExampleSection"],
Cell[66215, 1468, 176, 4, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[66416, 1476, 217, 7, 70, "Input"],
Cell[66636, 1485, 272, 9, 36, "Output",
 CellID->32194116]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[66957, 1500, 225, 7, 70, "ExampleSection",
 CellID->3289],
Cell[67185, 1509, 383, 11, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[67593, 1524, 173, 5, 70, "Input"],
Cell[67769, 1531, 259, 8, 36, "Output",
 CellID->69614987]
}, Open  ]],
Cell[CellGroupData[{
Cell[68065, 1544, 170, 5, 70, "Input"],
Cell[68238, 1551, 176, 5, 36, "Output",
 CellID->733015599]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[68475, 1563, 310, 9, 70, "SeeAlsoSection",
 CellID->8568],
Cell[68788, 1574, 728, 26, 70, "SeeAlso",
 CellID->27529]
}, Open  ]],
Cell[CellGroupData[{
Cell[69553, 1605, 313, 9, 70, "TutorialsSection",
 CellID->5107],
Cell[69869, 1616, 192, 4, 70, "Tutorials",
 CellID->30223]
}, Open  ]],
Cell[CellGroupData[{
Cell[70098, 1625, 318, 9, 70, "RelatedLinksSection",
 CellID->37],
Cell[70419, 1636, 198, 4, 70, "RelatedLinks"],
Cell[70620, 1642, 201, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[70858, 1651, 319, 9, 70, "MoreAboutSection",
 CellID->364506598],
Cell[71180, 1662, 145, 3, 70, "MoreAbout",
 CellID->2526740]
}, Open  ]],
Cell[71340, 1668, 27, 0, 70, "History"],
Cell[71370, 1670, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

