(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     52345,       1199]
NotebookOptionsPosition[     48341,       1063]
NotebookOutlinePosition[     49609,       1100]
CellTagsIndexPosition[     49523,       1095]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EllipticExp" :> 
          Documentation`HelpLookup["paclet:ref/EllipticExp"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"EllipticExp\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Elliptic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EllipticExpPrime", "ObjectName",
 CellID->27283],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["EllipticExpPrime",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/EllipticExpPrime"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["a", "TI"], ",", 
          StyleBox["b", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the derivative of ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["EllipticExp",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/EllipticExp"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["a", "TI"], ",", 
          StyleBox["b", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     " with respect to ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29242]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["EllipticExpPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticExpPrime"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->138465321],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticExpPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticExpPrime"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->127888394],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->189374834],

Cell["Evaluate numerically: ", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticExpPrime", "[", 
  RowBox[{
   RowBox[{"-", "0.4"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"4.", ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"30.667280768261417`", ",", "117.67119359903187`"}], 
  "}"}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->300695930]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"EllipticExpPrime", "[", 
     RowBox[{"x", ",", " ", 
      RowBox[{"{", 
       RowBox[{"4", ",", " ", "1"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->337822494]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2408],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->822564203],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticExpPrime", "[", 
  RowBox[{
   RowBox[{"2.", "I"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "-", "I"}], ",", " ", 
     RowBox[{"2", "+", "I"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->206525672],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.3967425052983575`"}], "+", 
    RowBox[{"1.9771507649595963`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.30669603337476903`", "\[InvisibleSpace]", "-", 
    RowBox[{"3.8550953027792927`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{281, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->387096722]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->324004859],

Cell["Evaluate to high precision:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"EllipticExpPrime", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"2", ",", " ", "2"}], "}"}]}], "]"}], ",", "60"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.1625027874842043260767124801837490812663284779686461215910463721124600872\
13`60.", ",", 
   "2.013192682300340480747514561857881791682809539810417218732468451391503215\
73081`60."}], "}"}]], "Output",
 ImageSize->{452, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->106656668]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->287380592],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticExpPrime", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], ",", " ", "60"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"2", ",", " ", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.1625027874842043260767124801837490812663284779686461215910463721124600866\
0479`58.318395692103834", ",", 
   "2.013192682300340480747514561857881791682809539810417218732468451391503215\
63212`60.215160047492816"}], "}"}]], "Output",
 ImageSize->{445, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->457037315]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21280],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"EllipticExpPrime", "[", 
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"I", " ", "y"}]}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"1", ",", " ", "2"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->80534158]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"EllipticExp", "[", 
    RowBox[{"u", ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}]}], "]"}], ",", "u"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33021167],

Cell[BoxData[
 RowBox[{"EllipticExpPrime", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}]}], "]"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->43727879]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24272],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["EllipticExp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticExp"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->25217]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->128283334],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->727344649]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EllipticExpPrime - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 39, 57.5418974}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "EllipticExpPrime[u, {a, b}] gives the derivative of EllipticExp[u, {a, \
b}] with respect to u.", "synonyms" -> {"elliptic exp prime"}, "title" -> 
    "EllipticExpPrime", "type" -> "Symbol", "uri" -> 
    "ref/EllipticExpPrime"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4087, 146, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->127888394]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 49380, 1088}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1163, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1786, 58, 54, 1, 70, "ObjectName",
 CellID->27283],
Cell[1843, 61, 1068, 35, 70, "Usage",
 CellID->29242]
}, Open  ]],
Cell[CellGroupData[{
Cell[2948, 101, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3426, 118, 120, 4, 70, "Notes",
 CellID->20640],
Cell[3549, 124, 264, 8, 70, "Notes",
 CellID->138465321],
Cell[3816, 134, 234, 7, 70, "Notes",
 CellID->31226]
}, Closed]],
Cell[CellGroupData[{
Cell[4087, 146, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->127888394],
Cell[CellGroupData[{
Cell[4472, 160, 148, 5, 70, "ExampleSection",
 CellID->189374834],
Cell[4623, 167, 182, 4, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[4830, 175, 196, 6, 28, "Input"],
Cell[5029, 183, 243, 8, 36, "Output",
 CellID->300695930]
}, Open  ]],
Cell[5287, 194, 105, 2, 70, "ExampleDelimiter"],
Cell[CellGroupData[{
Cell[5417, 200, 349, 11, 28, "Input"],
Cell[5769, 213, 5585, 96, 161, "Output",
 Evaluatable->False,
 CellID->337822494]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11403, 315, 215, 7, 70, "ExampleSection",
 CellID->2408],
Cell[11621, 324, 211, 5, 70, "ExampleText",
 CellID->822564203],
Cell[CellGroupData[{
Cell[11857, 333, 266, 9, 70, "Input",
 CellID->206525672],
Cell[12126, 344, 443, 13, 36, "Output",
 CellID->387096722]
}, Open  ]],
Cell[12584, 360, 125, 3, 70, "ExampleDelimiter",
 CellID->324004859],
Cell[12712, 365, 187, 4, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[12924, 373, 270, 9, 70, "Input"],
Cell[13197, 384, 377, 11, 54, "Output",
 CellID->106656668]
}, Open  ]],
Cell[13589, 398, 125, 3, 70, "ExampleDelimiter",
 CellID->287380592],
Cell[13717, 403, 93, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[13835, 409, 268, 8, 70, "Input"],
Cell[14106, 419, 409, 11, 54, "Output",
 CellID->457037315]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14564, 436, 223, 7, 70, "ExampleSection",
 CellID->21280],
Cell[CellGroupData[{
Cell[14812, 447, 496, 16, 70, "Input"],
Cell[15311, 465, 31073, 513, 70, "Output",
 Evaluatable->False,
 CellID->80534158]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[46433, 984, 217, 6, 70, "ExampleSection"],
Cell[CellGroupData[{
Cell[46675, 994, 236, 8, 70, "Input",
 CellID->33021167],
Cell[46914, 1004, 272, 9, 36, "Output",
 CellID->43727879]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[47247, 1020, 311, 9, 70, "SeeAlsoSection",
 CellID->24272],
Cell[47561, 1031, 202, 6, 70, "SeeAlso",
 CellID->25217]
}, Open  ]],
Cell[CellGroupData[{
Cell[47800, 1042, 319, 9, 70, "MoreAboutSection",
 CellID->128283334],
Cell[48122, 1053, 147, 3, 70, "MoreAbout",
 CellID->727344649]
}, Open  ]],
Cell[48284, 1059, 27, 0, 70, "History"],
Cell[48314, 1061, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

