(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    197385,       4773]
NotebookOptionsPosition[    185286,       4383]
NotebookOutlinePosition[    186845,       4425]
CellTagsIndexPosition[    186707,       4419]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EllipticK" :> Documentation`HelpLookup["paclet:ref/EllipticK"],
           "EllipticE" :> Documentation`HelpLookup["paclet:ref/EllipticE"], 
          "EllipticPi" :> Documentation`HelpLookup["paclet:ref/EllipticPi"], 
          "JacobiZeta" :> Documentation`HelpLookup["paclet:ref/JacobiZeta"], 
          "JacobiAmplitude" :> 
          Documentation`HelpLookup["paclet:ref/JacobiAmplitude"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"EllipticK\"\>", 
       2->"\<\"EllipticE\"\>", 3->"\<\"EllipticPi\"\>", 
       4->"\<\"JacobiZeta\"\>", 
       5->"\<\"JacobiAmplitude\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals" :> 
          Documentation`HelpLookup["paclet:guide/EllipticIntegrals"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Elliptic Integrals\"\>", 
       2->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EllipticF", "ObjectName",
 CellID->29733],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["EllipticF",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/EllipticF"], "[", 
       RowBox[{
        StyleBox["\[Phi]", "TR"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the elliptic integral of the first kind ",
     Cell[BoxData[
      FormBox[
       RowBox[{"F", "(", 
        RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}], ")"}], 
       TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2195]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", "\[Pi]"}], "/", "2"}], "<", "\[Phi]", "<", 
    RowBox[{"\[Pi]", "/", "2"}]}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"F", "(", 
     RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}], ")"}], "=", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "\[Phi]"], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"m", 
          RowBox[{
           SuperscriptBox["sin", "2"], "(", "\[Theta]", ")"}]}]}], ")"}], 
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}]], "d", "\[InvisibleSpace]", 
      "\[Theta]"}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->4012],

Cell[TextData[{
 "The complete elliptic integral associated with ",
 Cell[BoxData[
  ButtonBox["EllipticF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticF"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["EllipticK",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticK"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9238],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticF"]], "InlineFormula"],
 " is the inverse of ",
 Cell[BoxData[
  ButtonBox["JacobiAmplitude",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiAmplitude"]], "InlineFormula"],
 ". If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Phi]", "=", 
    RowBox[{"am", "(", 
     RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 " then ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "=", 
    RowBox[{"F", "(", 
     RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}], ")"}]}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->27837],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["EllipticF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticF"], "[", 
   RowBox[{
    StyleBox["\[Phi]", "TR"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity running along the ray from ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["csc", "2"], "(", "\[Phi]", ")"}], TraditionalForm]], 
  "InlineMath"],
 " to infinity. "
}], "Notes",
 CellID->7752],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["EllipticF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticF"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->295634972],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticF"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticF"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->154991223],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->121073090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticF", "[", 
  RowBox[{"0.3", ",", "0.8"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["0.30365239221539364`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->47209955]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"EllipticF", "[", 
    RowBox[{"\[Phi]", ",", "0.5"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", "0", ",", 
     RowBox[{"Pi", "/", "2"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWG9oVlUYv/O++2NmWZisTJoYOi1tYuUftFLRxDEU15jMTF+n8k7mVm6z
sKGZqJSuYpk4FSVIxT8fFooRLBAFSYiESBAVwiDsQxIkfRgIt995nvvc99xz
n/fF9/3QF8f2vvfc+zu/85zf8zvPOXd16c7Muo3pzpbmdNWbm9LvZlqaO6oW
tm/CLb/E87xz+Ouq9HAd4Ir+zgUBvpOfc/A5BADftHyDNHc9z9ybiGtza4j1
zFyaZ9XKM+lXQdezzWcq28vzyh2eCU7bT/SodhBlTrv0IRqpNMzUpIJHSIU9
c+Wl1MFPLGoEu02qRN4qD7+rw+8yp11ufcfdOcLh/TrP3eH4PGEsyM9NvF/2
Xm5sOP7DwC1XYzdrbruiQHyh7f+DvySrRRk/uXPnn+0fDTSvOXPp4m+TnR41
Tvslpz00q3xFdBc/N2/89eGW78F59ec/DqvZYfcA1952Fr+4OKjiyIUp0IAM
lMAdiHCRe1MIHc9377qAyexXeSjS1HfnryP1wN29++8+FTfMwsEowPWquEcp
uMHB+6dP/bJyxcmjR37CtfeFin2MOO/dGwQKtOjxeWwOT9BzDMXOxOA9Ks+T
hMMUMQHO1x4VN1K0hWAtmX6I94mKG0W4a7/+iQR0dZ5Hh90qrpJwV378PdJ4
Zyz+0aIZhGDNdqg8oy3NME+oAU287Sp2jGAjzYy+21Tsc6IvBkcIWNlbVdxY
0Y/9jgl1q7hxoh9EYW9uic13vOVJUGG+H6g8VPVTCAcT6DtwBQFuJhybn3+0
HdatvFRXU5j/sW+ushZdjM6757j78yRLJbDAPR1FsLwoGsJb0Abmee8BWUxz
iigHW0I50LQrvWVPc3WoET2RZNZzY47e+XahqZaaIPq2/1prIiuy97h9pwXh
Su3Ze4kdtEHN/CuWg3hlZWIOmhFkVxSoQLhe5ZlJOISIQBEugl6r4mZJbiEL
oKYcqrjZ8ewhrrSKe03yFMW3Khb/XMJzXLCj947KMtdyHIjglbdV3HxRi12B
0ZpU3AIr/6zGchW30FKDs9So4hYR7vbtv5EiCIJxG2KzrKXnEBPLhcerV3lq
xVHReMtUXF1ivKUqbgm1o3G5nUAttUaFIFC3LhZ9vYwGVVG1IUetyvMWtbl6
49NbrKIaxPmggnNAS+qFS0R+tHcCdz02Wt7ibZPyleibPF+6q3G5KAAa9teC
ApgMoMnSiCvK/CJjIWf7XFJgAG9ekTwrRWd4hLP2RpFMqySvfKTwXg/cKicn
bjdDq4Nw/SAAhIFg5qieWENtzJbLKFeXyH9rhQUFBPJC5FkqyzpqI3lIoXH7
TBW1XnKNNIENMU1XcRlhC938qopqSczw5VjsrdbMDMs0laU1wTJVxbU5bDUq
qt1iQ3XAxRQVR/utqQ6h0ybHIu9I+OcFlaVT3MELh08HCRSdM8x+wesD8ler
uPeD0P0h2wQVRackn1ebyfR4FUVnLZ/TjJG952Pz67bcYrQcp3J0W1qyCmOD
/NUq19lrq+iEaMzMqgJtNbpvku7zbdbMUaz4xFowC52UffQPlRnzwCym+bGj
3LNqb/mvgKvDjoSiz+Tsn6+909Hz6cCtSrnOXrtEQ2w/xj2VaubpDSasEwBi
IYyK+edTwvPuY1bPUyoLo3gVgYjfqBKovUHoei5I/H6WQPWI7nww47e9BOoz
0RdLH8clTOBxFUdvmD7OXIgfWvC7ZTS7XtEIT01FHq5y9IpGqMw4b2HQYSqO
3pB9nLfCVf2IivqK2uYo33bWnAWHqqj9MiYmB1ExZnks8j7Cc400Y5WpLH2S
l3AdlaqoQ0F2nZg3TF9FHZa8ICmBrLaC/rfklfwHcpMMqw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->139737178]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"EllipticF", "[", 
    RowBox[{"\[Phi]", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", "0", ",", "8"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[Phi]", "+", 
   FractionBox[
    RowBox[{"m", " ", 
     SuperscriptBox["\[Phi]", "3"]}], "6"], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", "m"}], "+", 
      RowBox[{"9", " ", 
       SuperscriptBox["m", "2"]}]}], ")"}], " ", 
    SuperscriptBox["\[Phi]", "5"]}], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"16", " ", "m"}], "-", 
       RowBox[{"180", " ", 
        SuperscriptBox["m", "2"]}], "+", 
       RowBox[{"225", " ", 
        SuperscriptBox["m", "3"]}]}], ")"}], " ", 
     SuperscriptBox["\[Phi]", "7"]}], "5040"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Phi]", "]"}], "9"],
    SeriesData[$CellContext`\[Phi], 0, {}, 1, 9, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Phi], 0, {
   1, 0, Rational[1, 6] $CellContext`m, 0, 
    Rational[1, 120] ((-4) $CellContext`m + 9 $CellContext`m^2), 0, 
    Rational[1, 5040] (16 $CellContext`m - 180 $CellContext`m^2 + 
     225 $CellContext`m^3)}, 1, 9, 1],
  Editable->False]], "Output",
 ImageSize->{395, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102717479]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Evaluate for complex arguments:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticF", "[", 
  RowBox[{
   RowBox[{"3", "+", 
    RowBox[{"2.5", " ", "I"}]}], ",", 
   RowBox[{"2.3", "-", 
    RowBox[{"1.5", " ", "I"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"2.136262961761814`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.5733293736158249`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->141677529]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Evaluate to high precision:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"EllipticF", "[", 
    RowBox[{
     RowBox[{"12", "/", "5"}], ",", "3"}], "]"}], ",", "50"}], "]"}]], "Input",\

 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"1.\
0010773804561062360796595863838358931497135904585299945363921714349`49.\
81490026476788", "-", 
  RowBox[{
  "1.9231661895046253531841444093352781715706878703093774491830974481948`50.\
09844943146751", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{379, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23369283]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->81376879],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticF", "[", 
  RowBox[{"2", ",", "0.9999999999999999990000000000000000000"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["42.69566795256993004057616557518`19.99385903307339"], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3404285]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Simple exact values are generated automatically:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticF", "[", 
  RowBox[{"\[Phi]", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["\[Phi]"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->752058302]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticF", "[", 
  RowBox[{
   RowBox[{"Pi", "/", "2"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"EllipticK", "[", "m", "]"}]], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26026711]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticF"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticF", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.2", ",", "0.5", ",", "1.8"}], "}"}], ",", 
   RowBox[{"1", "/", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.20044353944930093`", ",", "0.5068477562654311`", ",", 
   "2.013430773879979`"}], "}"}]], "Output",
 ImageSize->{202, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13463773]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Expand in series with respect to the modulus:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"EllipticF", "[", 
    RowBox[{"\[Phi]", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[Phi]", "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["\[Phi]", "4"], "-", 
      RowBox[{
       FractionBox["1", "8"], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "\[Phi]"}], "]"}]}]}], ")"}], " ", "m"}], "+", 
   RowBox[{
    FractionBox["3", "256"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"12", " ", "\[Phi]"}], "-", 
      RowBox[{"8", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "\[Phi]"}], "]"}]}], "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"4", " ", "\[Phi]"}], "]"}]}], ")"}], " ", 
    SuperscriptBox["m", "2"]}], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"60", " ", "\[Phi]"}], "-", 
       RowBox[{"45", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"2", " ", "\[Phi]"}], "]"}]}], "+", 
       RowBox[{"9", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"4", " ", "\[Phi]"}], "]"}]}], "-", 
       RowBox[{"Sin", "[", 
        RowBox[{"6", " ", "\[Phi]"}], "]"}]}], ")"}], " ", 
     SuperscriptBox["m", "3"]}], "3072"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "4"],
    SeriesData[$CellContext`m, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 
   0, {$CellContext`\[Phi], Rational[1, 4] $CellContext`\[Phi] + 
    Rational[-1, 8] Sin[2 $CellContext`\[Phi]], 
    Rational[3, 256] (12 $CellContext`\[Phi] - 8 Sin[2 $CellContext`\[Phi]] + 
     Sin[4 $CellContext`\[Phi]]), 
    Rational[5, 3072] (60 $CellContext`\[Phi] - 45 Sin[2 $CellContext`\[Phi]] + 
     9 Sin[4 $CellContext`\[Phi]] - Sin[6 $CellContext`\[Phi]])}, 0, 4, 1],
  Editable->False]], "Output",
 ImageSize->{381, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->220623382]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting: "
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"EllipticF", "[", 
   RowBox[{"\[Phi]", ",", "m"}], "]"}], " ", "//", " ", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"F", "(", 
   RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}], ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->244957685]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticF"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticF", "[", 
  RowBox[{
   RowBox[{"x", "+", 
    FractionBox[
     SuperscriptBox["x", "2"], "2"], "+", 
    FractionBox[
     SuperscriptBox["x", "3"], "3"], "+", 
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"]}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "3"],
    SeriesData[$CellContext`x, 0, {}, 1, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 
    Rational[1, 2]}, 1, 3, 1],
  Editable->False]], "Output",
 ImageSize->{87, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->177065394]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticF", "[", 
  RowBox[{"x", ",", 
   RowBox[{"m", "+", 
    FractionBox[
     SuperscriptBox["m", "2"], "2"], "+", 
    FractionBox[
     SuperscriptBox["m", "3"], "3"], "+", 
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "4"]}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["x", "4"], "-", 
      RowBox[{
       FractionBox["1", "8"], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "x"}], "]"}]}]}], ")"}], " ", "m"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"17", " ", "x"}], "64"], "-", 
      RowBox[{
       FractionBox["5", "32"], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "x"}], "]"}]}], "+", 
      RowBox[{
       FractionBox["3", "256"], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"4", " ", "x"}], "]"}]}]}], ")"}], " ", 
    SuperscriptBox["m", "2"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"247", " ", "x"}], "768"], "-", 
      FractionBox[
       RowBox[{"641", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"2", " ", "x"}], "]"}]}], "3072"], "+", 
      FractionBox[
       RowBox[{"27", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"4", " ", "x"}], "]"}]}], "1024"], "-", 
      FractionBox[
       RowBox[{"5", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"6", " ", "x"}], "]"}]}], "3072"]}], ")"}], " ", 
    SuperscriptBox["m", "3"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "4"],
    SeriesData[$CellContext`m, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 
   0, {$CellContext`x, Rational[1, 4] $CellContext`x + 
    Rational[-1, 8] Sin[2 $CellContext`x], Rational[17, 64] $CellContext`x + 
    Rational[-5, 32] Sin[2 $CellContext`x] + 
    Rational[3, 256] Sin[4 $CellContext`x], Rational[247, 768] $CellContext`x + 
    Rational[-641, 3072] Sin[2 $CellContext`x] + 
    Rational[27, 1024] Sin[4 $CellContext`x] + 
    Rational[-5, 3072] Sin[6 $CellContext`x]}, 0, 4, 1],
  Editable->False]], "Output",
 ImageSize->{397, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->132878808]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Carry out an elliptic integral:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{
      RowBox[{"a", " ", 
       SuperscriptBox["x", "3"]}], "+", "b"}]]], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"2", " ", "\[ImaginaryI]", " ", 
    SuperscriptBox["b", 
     RowBox[{"1", "/", "3"}]], " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{"5", "/", "6"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        FractionBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", "a"}], ")"}], 
           RowBox[{"1", "/", "3"}]], " ", "x"}], 
         SuperscriptBox["b", 
          RowBox[{"1", "/", "3"}]]]}], ")"}]}]], " ", 
    SqrtBox[
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "a"}], ")"}], 
         RowBox[{"1", "/", "3"}]], " ", "x"}], 
       SuperscriptBox["b", 
        RowBox[{"1", "/", "3"}]]], "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "a"}], ")"}], 
         RowBox[{"2", "/", "3"}]], " ", 
        SuperscriptBox["x", "2"]}], 
       SuperscriptBox["b", 
        RowBox[{"2", "/", "3"}]]]}]], " ", 
    RowBox[{"EllipticF", "[", 
     RowBox[{
      RowBox[{"ArcSin", "[", 
       FractionBox[
        SqrtBox[
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], 
            RowBox[{"5", "/", "6"}]]}], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"-", "a"}], ")"}], 
             RowBox[{"1", "/", "3"}]], " ", "x"}], 
           SuperscriptBox["b", 
            RowBox[{"1", "/", "3"}]]]}]], 
        SuperscriptBox["3", 
         RowBox[{"1", "/", "4"}]]], "]"}], ",", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{"1", "/", "3"}]]}], "]"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["3", 
     RowBox[{"1", "/", "4"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "a"}], ")"}], 
     RowBox[{"1", "/", "3"}]], " ", 
    SqrtBox[
     RowBox[{"b", "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "3"]}]}]]}], ")"}]}]], "Output",
 ImageSize->{527, 161},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14531787]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Plot an incomplete elliptic integral over the complex plane:", \
"ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"EllipticF", "[", 
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
      RowBox[{"1", "/", "2"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "2"}], "Pi"}], ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 156},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->733925222]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Calculate the surface area of a triaxial ellipsoid:", "ExampleText"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"area", "[", 
    RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"m", "=", 
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], 
          RowBox[{
           SuperscriptBox["b", "2"], "(", 
           RowBox[{
            SuperscriptBox["a", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}]]}], ",", 
        RowBox[{"\[CurlyTheta]", "=", 
         RowBox[{"ArcSin", "[", 
          SqrtBox[
           RowBox[{"1", "-", 
            FractionBox[
             SuperscriptBox["c", "2"], 
             SuperscriptBox["a", "2"]]}]], "]"}]}]}], "}"}], ",", 
      RowBox[{"2", " ", "\[Pi]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          FractionBox[
           RowBox[{"b", " ", 
            SuperscriptBox["c", "2"], " "}], 
           SqrtBox[
            RowBox[{
             SuperscriptBox["a", "2"], "-", 
             SuperscriptBox["c", "2"]}]]], 
          RowBox[{"EllipticF", "[", 
           RowBox[{"\[CurlyTheta]", ",", "m"}], "]"}]}], "+", 
         SuperscriptBox["c", "2"], "+", 
         RowBox[{"b", " ", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["a", "2"], "-", 
            SuperscriptBox["c", "2"]}]], " ", 
          RowBox[{"EllipticE", "[", 
           RowBox[{"\[CurlyTheta]", ",", "m"}], "]"}]}]}], ")"}]}]}], "]"}], "/;",
     
    RowBox[{"a", ">", "b", ">", "c"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:="],

Cell["The area of an ellipsoid with half axes 3, 2, 1:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"area", "[", 
  RowBox[{"3", ",", "2", ",", "1."}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["48.88214630258205`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->73321171]
}, Open  ]],

Cell["\<\
Calculate volume through integrating the differential surface elements:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "=", "3"}], ",", 
     RowBox[{"b", "=", "2"}], ",", 
     RowBox[{"c", "=", "1"}]}], "}"}], ",", 
   RowBox[{"NIntegrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "\[CurlyTheta]", "]"}], 
      SqrtBox[
       RowBox[{
        RowBox[{
         SuperscriptBox["b", "2"], 
         SuperscriptBox["c", "2"], 
         SuperscriptBox[
          RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}], "2"], 
         SuperscriptBox[
          RowBox[{"Sin", "[", "\[CurlyTheta]", "]"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], 
         SuperscriptBox["c", "2"], 
         SuperscriptBox[
          RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}], "2"], 
         SuperscriptBox[
          RowBox[{"Sin", "[", "\[CurlyTheta]", "]"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], 
         SuperscriptBox["b", "2"], 
         SuperscriptBox[
          RowBox[{"Cos", "[", "\[CurlyTheta]", "]"}], "2"]}]}]]}], ",", 
     RowBox[{"{", 
      RowBox[{"\[CurlyPhi]", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[CurlyTheta]", ",", "0", ",", "Pi"}], "}"}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData["48.8821738213866`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->483827043]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Arc length parametrization of a curve that minimizes the integral of the \
square of its curvature:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"s", "'"}], "[", "\[CurlyPhi]", "]"}], "==", 
    RowBox[{"-", 
     FractionBox["c", 
      SqrtBox[
       RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}]]]}]}], ",", 
   RowBox[{"s", "[", "\[CurlyPhi]", "]"}], ",", "\[CurlyPhi]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"s", "[", "\[CurlyPhi]", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "-", 
     RowBox[{"2", " ", "c", " ", 
      RowBox[{"EllipticF", "[", 
       RowBox[{
        FractionBox["\[CurlyPhi]", "2"], ",", "2"}], "]"}]}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{243, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->292825898]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Parametrization of a mylar balloon (two flat sheets of plastic sewn together \
at their circumference and then inflated):\
\>", "ExampleText"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "[", 
   RowBox[{"u_", ",", "v_"}], "]"}], ":=", 
  FractionBox[
   RowBox[{"Cos", "[", "v", "]"}], 
   SqrtBox[
    RowBox[{"Cosh", "[", 
     RowBox[{"2", "u"}], "]"}]]]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"y", "[", 
   RowBox[{"u_", ",", "v_"}], "]"}], ":=", 
  FractionBox[
   RowBox[{"Sin", "[", "v", "]"}], 
   SqrtBox[
    RowBox[{"Cosh", "[", 
     RowBox[{"2", "u"}], "]"}]]]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"z", "[", 
   RowBox[{"u_", ",", "v_"}], "]"}], ":=", 
  RowBox[{
   SqrtBox["2"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"EllipticE", "[", 
      RowBox[{
       RowBox[{"ArcSin", "[", 
        FractionBox[
         RowBox[{
          SqrtBox["2"], 
          RowBox[{"Sinh", "[", "u", "]"}]}], 
         SqrtBox[
          RowBox[{"Cosh", "[", 
           RowBox[{"2", "u"}], "]"}]]], "]"}], ",", 
       FractionBox["1", "2"]}], "]"}], "-", 
     RowBox[{
      FractionBox["1", "2"], 
      RowBox[{"EllipticF", "[", 
       RowBox[{
        RowBox[{"ArcSin", "[", 
         FractionBox[
          RowBox[{
           SqrtBox["2"], 
           RowBox[{"Sinh", "[", "u", "]"}]}], 
          SqrtBox[
           RowBox[{"Cosh", "[", 
            RowBox[{"2", "u"}], "]"}]]], "]"}], ",", 
        FractionBox["1", "2"]}], "]"}]}]}], ")"}]}]}]}], "Input",
 CellLabel->"In[1]:="],

Cell["Plot the resulting balloon:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "[", 
      RowBox[{"u", ",", "v"}], "]"}], ",", 
     RowBox[{"y", "[", 
      RowBox[{"u", ",", "v"}], "]"}], ",", 
     RowBox[{"z", "[", 
      RowBox[{"u", ",", "v"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"-", "8"}], ",", "8"}], "}"}], ",", 
   RowBox[{"PlotRange", "->", "All"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "4"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 270},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->932899898]
}, Open  ]],

Cell["Calculate the ratio of the main curvatures:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"h", ",", "g"}], "}"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"h", "[", "u_", "]"}], "=", 
     RowBox[{
      RowBox[{"x", "[", 
       RowBox[{"u", ",", "v"}], "]"}], "/", 
      RowBox[{"Cos", "[", "v", "]"}]}]}], ";", 
    RowBox[{
     RowBox[{"g", "[", "u_", "]"}], "=", 
     RowBox[{"z", "[", 
      RowBox[{"u", ",", "v"}], "]"}]}], ";", 
    RowBox[{
     FractionBox[
      RowBox[{"(", 
       FractionBox[
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"g", "''"}], "[", "u", "]"}], 
          RowBox[{
           RowBox[{"h", "'"}], "[", "u", "]"}]}], "-", 
         RowBox[{
          RowBox[{
           RowBox[{"g", "'"}], "[", "u", "]"}], 
          RowBox[{
           RowBox[{"h", "''"}], "[", "u", "]"}]}]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{
             RowBox[{"g", "'"}], "[", "u", "]"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{
             RowBox[{"h", "'"}], "[", "u", "]"}], "2"]}], ")"}], 
         RowBox[{"3", "/", "2"}]]], ")"}], 
      RowBox[{"(", 
       FractionBox[
        RowBox[{
         RowBox[{"g", "'"}], "[", "u", "]"}], 
        RowBox[{
         RowBox[{"h", "[", "u", "]"}], 
         SqrtBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{
             RowBox[{"g", "'"}], "[", "u", "]"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{
             RowBox[{"h", "'"}], "[", "u", "]"}], "2"]}]]}]], ")"}]], "//", 
     "Simplify"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->354051606]
}, Open  ]],

Cell["\<\
Express the radius of the original sheets through the radius of the inflated \
balloon:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"h", ",", "g"}], "}"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"h", "[", "u_", "]"}], "=", 
     RowBox[{
      RowBox[{"x", "[", 
       RowBox[{"u", ",", "v"}], "]"}], "/", 
      RowBox[{"Cos", "[", "v", "]"}]}]}], ";", 
    RowBox[{
     RowBox[{"g", "[", "u_", "]"}], "=", 
     RowBox[{"z", "[", 
      RowBox[{"u", ",", "v"}], "]"}]}], ";", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        SqrtBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{
            RowBox[{"h", "'"}], "[", "u", "]"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{
            RowBox[{"g", "'"}], "[", "u", "]"}], "2"]}]], "//", "Simplify"}], 
       "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"u", ",", "0", ",", "\[Infinity]"}], "}"}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:="],

Cell[BoxData[
 RowBox[{"2", " ", 
  SqrtBox[
   FractionBox["2", "\[Pi]"]], " ", 
  SuperscriptBox[
   RowBox[{"Gamma", "[", 
    FractionBox["5", "4"], "]"}], "2"]}]], "Output",
 ImageSize->{115, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->462296627]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[5]:="],

Cell[BoxData["1.3110287771460598`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1967973]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Expand special cases:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"EllipticF", "[", 
   RowBox[{
    RowBox[{"ArcCsc", "[", 
     SqrtBox["m"], "]"}], ",", "m"}], "]"}], "//", 
  "FunctionExpand"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"EllipticK", "[", 
   FractionBox["1", "m"], "]"}], 
  SqrtBox["m"]]], "Output",
 ImageSize->{96, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->199432129]
}, Open  ]],

Cell["Expand special cases under argument restrictions:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"EllipticF", "[", 
   RowBox[{"z", ",", "1"}], "]"}], "//", "FunctionExpand"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"EllipticF", "[", 
  RowBox[{"z", ",", "1"}], "]"}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->675436802]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"%", ",", 
   RowBox[{"0", "<", "z", "<", 
    RowBox[{"Pi", "/", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{
   RowBox[{"Sec", "[", "z", "]"}], "+", 
   RowBox[{"Tan", "[", "z", "]"}]}], "]"}]], "Output",
 ImageSize->{136, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->92995970]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Compositions with the inverse function need ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 ": "
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticF", "[", 
  RowBox[{
   RowBox[{"JacobiAmplitude", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"EllipticF", "[", 
  RowBox[{
   RowBox[{"JacobiAmplitude", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->146776879]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["z"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->362204126]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiAmplitude", "[", 
  RowBox[{
   RowBox[{"EllipticF", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{"JacobiAmplitude", "[", 
  RowBox[{
   RowBox[{"EllipticF", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->196311933]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:="],

Cell[BoxData["z"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->497316324]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Solve an equation containing ",
 Cell[BoxData[
  ButtonBox["EllipticF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticF"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"EllipticF", "[", 
       RowBox[{"z", ",", "m"}], "]"}], "3"], "+", 
     RowBox[{"EllipticF", "[", 
      RowBox[{"z", ",", "m"}], "]"}]}], "\[Equal]", "x"}], ",", "z"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->7751404],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"-", 
      RowBox[{"JacobiAmplitude", "[", 
       RowBox[{
        RowBox[{
         FractionBox[
          SuperscriptBox[
           RowBox[{"(", 
            FractionBox["2", "3"], ")"}], 
           RowBox[{"1", "/", "3"}]], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"9", " ", "x"}], "+", 
             RowBox[{
              SqrtBox["3"], " ", 
              SqrtBox[
               RowBox[{"4", "+", 
                RowBox[{"27", " ", 
                 SuperscriptBox["x", "2"]}]}]]}]}], ")"}], 
           RowBox[{"1", "/", "3"}]]], "-", 
         FractionBox[
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"9", " ", "x"}], "+", 
             RowBox[{
              SqrtBox["3"], " ", 
              SqrtBox[
               RowBox[{"4", "+", 
                RowBox[{"27", " ", 
                 SuperscriptBox["x", "2"]}]}]]}]}], ")"}], 
           RowBox[{"1", "/", "3"}]], 
          RowBox[{
           SuperscriptBox["2", 
            RowBox[{"1", "/", "3"}]], " ", 
           SuperscriptBox["3", 
            RowBox[{"2", "/", "3"}]]}]]}], ",", "m"}], "]"}]}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"JacobiAmplitude", "[", 
      RowBox[{
       RowBox[{
        FractionBox[
         RowBox[{"1", "+", 
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["3"]}]}], 
         RowBox[{
          SuperscriptBox["2", 
           RowBox[{"2", "/", "3"}]], " ", 
          SuperscriptBox["3", 
           RowBox[{"1", "/", "3"}]], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"9", " ", "x"}], "+", 
             RowBox[{
              SqrtBox["3"], " ", 
              SqrtBox[
               RowBox[{"4", "+", 
                RowBox[{"27", " ", 
                 SuperscriptBox["x", "2"]}]}]]}]}], ")"}], 
           RowBox[{"1", "/", "3"}]]}]], "-", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"\[ImaginaryI]", " ", 
             SqrtBox["3"]}]}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"9", " ", "x"}], "+", 
             RowBox[{
              SqrtBox["3"], " ", 
              SqrtBox[
               RowBox[{"4", "+", 
                RowBox[{"27", " ", 
                 SuperscriptBox["x", "2"]}]}]]}]}], ")"}], 
           RowBox[{"1", "/", "3"}]]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["2", 
           RowBox[{"1", "/", "3"}]], " ", 
          SuperscriptBox["3", 
           RowBox[{"2", "/", "3"}]]}]]}], ",", "m"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"JacobiAmplitude", "[", 
      RowBox[{
       RowBox[{
        FractionBox[
         RowBox[{"1", "-", 
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["3"]}]}], 
         RowBox[{
          SuperscriptBox["2", 
           RowBox[{"2", "/", "3"}]], " ", 
          SuperscriptBox["3", 
           RowBox[{"1", "/", "3"}]], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"9", " ", "x"}], "+", 
             RowBox[{
              SqrtBox["3"], " ", 
              SqrtBox[
               RowBox[{"4", "+", 
                RowBox[{"27", " ", 
                 SuperscriptBox["x", "2"]}]}]]}]}], ")"}], 
           RowBox[{"1", "/", "3"}]]}]], "-", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"\[ImaginaryI]", " ", 
             SqrtBox["3"]}]}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"9", " ", "x"}], "+", 
             RowBox[{
              SqrtBox["3"], " ", 
              SqrtBox[
               RowBox[{"4", "+", 
                RowBox[{"27", " ", 
                 SuperscriptBox["x", "2"]}]}]]}]}], ")"}], 
           RowBox[{"1", "/", "3"}]]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["2", 
           RowBox[{"1", "/", "3"}]], " ", 
          SuperscriptBox["3", 
           RowBox[{"2", "/", "3"}]]}]]}], ",", "m"}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{529, 272},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->572124523]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Numerically find a root of a transcendental equation:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"EllipticF", "[", 
       RowBox[{"z", ",", "2"}], "]"}], "3"], "+", 
     RowBox[{"EllipticF", "[", 
      RowBox[{"z", ",", "2"}], "]"}], "+", "z"}], "\[Equal]", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", 
   RowBox[{"0.659917937683705`", "\[InvisibleSpace]", "-", 
    RowBox[{"1.4295663755228222`*^-17", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{211, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6871494]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Integrals:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "z", "]"}], 
    RowBox[{"EllipticF", "[", 
     RowBox[{"z", ",", "m"}], "]"}]}], " ", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox["m"], " ", 
      RowBox[{"Sin", "[", "z", "]"}]}], 
     SqrtBox[
      RowBox[{"2", "-", "m", "+", 
       RowBox[{"m", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"2", " ", "z"}], "]"}]}]}]]], "]"}], 
   SqrtBox["m"]], "-", 
  RowBox[{
   RowBox[{"Cos", "[", "z", "]"}], " ", 
   RowBox[{"EllipticF", "[", 
    RowBox[{"z", ",", "m"}], "]"}]}]}]], "Output",
 ImageSize->{310, 58},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->346407080]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   FractionBox[
    RowBox[{" ", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "z"}], "]"}], 
      RowBox[{"EllipticF", "[", 
       RowBox[{"z", ",", "m"}], "]"}]}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"m", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "2"]}]}], ")"}], 
     RowBox[{"3", "/", "2"}]]], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"ArcTanh", "[", 
      RowBox[{
       SqrtBox[
        RowBox[{
         RowBox[{"-", "1"}], "+", "m"}]], " ", 
       RowBox[{"Tan", "[", "z", "]"}]}], "]"}]}], 
    RowBox[{
     SqrtBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", "m"}]], " ", "m"}]]}], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    SqrtBox["2"], " ", 
    RowBox[{"EllipticF", "[", 
     RowBox[{"z", ",", "m"}], "]"}]}], 
   RowBox[{"m", " ", 
    SqrtBox[
     RowBox[{"2", "-", "m", "+", 
      RowBox[{"m", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "z"}], "]"}]}]}]]}]]}]], "Output",
 ImageSize->{341, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->64745354]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Limits on branch cuts:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"EllipticF", "[", 
    RowBox[{
     RowBox[{"2", "+", 
      RowBox[{"\[CurlyEpsilon]", " ", "I"}]}], ",", "2"}], "]"}], ",", 
   RowBox[{"\[CurlyEpsilon]", "->", "0"}], ",", 
   RowBox[{"Direction", "->", 
    RowBox[{"-", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"EllipticF", "[", 
  RowBox[{"2", ",", "2"}], "]"}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87914507]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"EllipticF", "[", 
    RowBox[{
     RowBox[{"2", "+", 
      RowBox[{"\[CurlyEpsilon]", " ", "I"}]}], ",", "2"}], "]"}], ",", 
   RowBox[{"\[CurlyEpsilon]", "->", "0"}], ",", 
   RowBox[{"Direction", "->", 
    RowBox[{"+", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"EllipticF", "[", 
    RowBox[{"2", ",", "2"}], "]"}]}], "-", 
  RowBox[{
   SqrtBox["2"], " ", 
   RowBox[{"EllipticK", "[", 
    FractionBox["1", "2"], "]"}]}], "+", 
  RowBox[{"4", " ", 
   RowBox[{"EllipticK", "[", "2", "]"}]}]}]], "Output",
 ImageSize->{349, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->48442794]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4682],

Cell["\<\
The defining integral converges only under additional conditions:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"1", "-", 
      RowBox[{"m", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "t", "]"}], "2"]}]}]]], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Re", "[", 
        RowBox[{"m", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "z", "]"}], "2"]}], "]"}], "\[LessEqual]", 
       "1"}], "||", 
      RowBox[{
       RowBox[{"Im", "[", 
        RowBox[{"m", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "z", "]"}], "2"]}], "]"}], "\[NotEqual]", 
       "0"}]}], ")"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Re", "[", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"Csc", "[", "z", "]"}], "2"], "m"], "]"}], 
       "\[GreaterEqual]", "1"}], "||", 
      RowBox[{
       RowBox[{"Re", "[", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"Csc", "[", "z", "]"}], "2"], "m"], "]"}], "\[LessEqual]", 
       "0"}], "||", 
      RowBox[{
       RowBox[{"Im", "[", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"Csc", "[", "z", "]"}], "2"], "m"], "]"}], "\[NotEqual]", 
       "0"}]}], ")"}], "&&", 
    RowBox[{
     RowBox[{"2", "+", 
      RowBox[{"m", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "z"}], "]"}]}]}], "\[NotEqual]", "m"}]}], ",", 
   RowBox[{"EllipticF", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"m", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "t", "]"}], "2"]}]}]]], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "z"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Im", "[", 
           RowBox[{"m", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", "z", "]"}], "2"]}], "]"}], "\[Equal]", "0"}],
          "&&", 
         RowBox[{
          RowBox[{"Re", "[", 
           RowBox[{"m", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", "z", "]"}], "2"]}], "]"}], ">", "1"}]}], 
        ")"}], "||", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Im", "[", 
           FractionBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{"2", "-", "m", "+", 
               RowBox[{"m", " ", 
                RowBox[{"Cos", "[", 
                 RowBox[{"2", " ", "z"}], "]"}]}]}], ")"}], " ", 
             SuperscriptBox[
              RowBox[{"Csc", "[", "z", "]"}], "2"]}], "m"], "]"}], "\[Equal]",
           "0"}], "&&", 
         RowBox[{
          RowBox[{"-", "2"}], "<", 
          RowBox[{"Re", "[", 
           FractionBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{"2", "-", "m", "+", 
               RowBox[{"m", " ", 
                RowBox[{"Cos", "[", 
                 RowBox[{"2", " ", "z"}], "]"}]}]}], ")"}], " ", 
             SuperscriptBox[
              RowBox[{"Csc", "[", "z", "]"}], "2"]}], "m"], "]"}], "<", 
          "0"}]}], ")"}], "||", 
       RowBox[{
        RowBox[{"2", "+", 
         RowBox[{"m", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"2", " ", "z"}], "]"}]}]}], "\[Equal]", "m"}]}]}]}], 
    "]"}]}], "]"}]], "Output",
 ImageSize->{552, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->428043620]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Different conventions exist for the second argument:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"1", "-", 
      RowBox[{
       RowBox[{"k", "^", "2"}], " ", 
       RowBox[{
        RowBox[{"Sin", "[", "t", "]"}], "^", "2"}]}]}], "]"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "z"}], "}"}], ",", 
   RowBox[{"GenerateConditions", "->", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->241607850],

Cell[BoxData[
 RowBox[{"EllipticF", "[", 
  RowBox[{"z", ",", 
   SuperscriptBox["k", "2"]}], "]"}]], "Output",
 ImageSize->{112, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->402418042]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"t", "^", "2"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"m", " ", 
          RowBox[{"t", "^", "2"}]}]}], ")"}]}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "z"}], "}"}], ",", 
    RowBox[{"GenerateConditions", "->", "False"}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{"#", ",", 
     RowBox[{
      RowBox[{"0", "<", "m", "<", "1"}], "&&", 
      RowBox[{"0", "<", "z", "<", "1"}]}]}], "]"}], "&"}]}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"EllipticF", "[", 
  RowBox[{
   RowBox[{"ArcSin", "[", "z", "]"}], ",", "m"}], "]"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->803849305]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["In traditional form the vertical separator must be used:", "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"F", "(", 
   RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}], ")"}], 
  TraditionalForm]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"EllipticF", "[", 
  RowBox[{"\[Phi]", ",", "m"}], "]"}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->729021713]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Nested derivatives:", "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"NestList", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"#", ",", "x"}], "]"}], "&"}], ",", 
     RowBox[{"EllipticF", "[", 
      RowBox[{"x", ",", "m"}], "]"}], ",", "4"}], "]"}], "//", "Simplify"}], "//",
   "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"F", "(", 
     RowBox[{"x", "\[VerticalSeparator]", "m"}], ")"}], ",", 
    FractionBox["1", 
     SqrtBox[
      RowBox[{"1", "-", 
       RowBox[{"m", " ", 
        RowBox[{
         SuperscriptBox["sin", "2"], "(", "x", ")"}]}]}]]], ",", 
    FractionBox[
     RowBox[{"m", " ", 
      RowBox[{"cos", "(", "x", ")"}], " ", 
      RowBox[{"sin", "(", "x", ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"m", " ", 
         RowBox[{
          SuperscriptBox["sin", "2"], "(", "x", ")"}]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], ",", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"m", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}], " ", 
          RowBox[{"cos", "(", 
           RowBox[{"2", " ", "x"}], ")"}]}], "+", 
         RowBox[{"m", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"cos", "(", 
             RowBox[{"4", " ", "x"}], ")"}], "-", "5"}], ")"}]}]}], ")"}]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"cos", "(", 
            RowBox[{"2", " ", "x"}], ")"}], " ", "m"}], "-", "m", "+", "2"}], 
         ")"}], 
        RowBox[{"5", "/", "2"}]]}]]}], ",", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"m", " ", 
       RowBox[{"cos", "(", "x", ")"}], " ", 
       RowBox[{"sin", "(", "x", ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "5"}], " ", 
          SuperscriptBox["m", "2"], " ", 
          RowBox[{
           SuperscriptBox["sin", "4"], "(", "x", ")"}]}], "+", 
         RowBox[{"m", " ", 
          RowBox[{
           SuperscriptBox["sin", "2"], "(", "x", ")"}]}], "+", 
         RowBox[{"3", " ", "m", " ", 
          RowBox[{
           SuperscriptBox["cos", "2"], "(", "x", ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"cos", "(", 
              RowBox[{"2", " ", "x"}], ")"}], " ", "m"}], "-", "m", "-", 
            "3"}], ")"}]}], "+", "4"}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"m", " ", 
          RowBox[{
           SuperscriptBox["sin", "2"], "(", "x", ")"}]}]}], ")"}], 
       RowBox[{"7", "/", "2"}]]]}]}], "}"}], TraditionalForm]], "Output",
 ImageSize->{450, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->55349367]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  ButtonBox["EllipticF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticF"]], "InlineFormula"],
 " at integer points:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Mod", "[", 
     RowBox[{
      RowBox[{"Round", "[", 
       RowBox[{"Abs", "[", 
        RowBox[{"EllipticF", "[", 
         RowBox[{
          RowBox[{"x", " ", "y"}], ",", "0.3"}], "]"}], "]"}], "]"}], ",", 
      "2"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "50"}], ",", "50"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "50"}], ",", "50"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJy9VFtyAyEMg96kV+oRMtPv3v+vne4L27JlsxtokxFGOGBkfb5+vl4frbXv
/dO3/+Nzwqci2w+guJnOrOjp39f2fUA2L1KP2wwXw7P6wpi4bb/ZDURojtmO
82x/JxhiaDnL22NLhj3QcA41wTDBN2UciiswfpMcW6hAiQas5kJqFUl//JYB
l2z2aTJsX922uJGTCXKeMLOip2XvKC6ht6ImQTggFRCjH8SQ7ff8ALYXbEbE
1LwlI7QDP56giPsEFXeqj18qyIF9wIYoDNJYT8hbR2GfbV/HHCIYJ+H7Uz/C
SPL2oBq0JKB8cs4fFZgEWbAwNggsVmYrdlcjZgHbC/ef27ZLRvrw3p35tXpc
0eghDAxSZCxCuUWZ6Ku83idBp2U8okFeeotLSWT2IEgorxyXIPYSN03FHKrw
Sh0bCI4GtoKjY9OwtitAmXXJuH1mDnumovRN2Ks+LikEC9ov2oog3OntJGy+
l9QcBvvcFZ0qTKmI9q3uOUxH0bRC78G3N+MaW1lykyVvskRdS/ok6O3nOj6b
4zY0N5wvYsfR+ScuwF1pRoA4GsHuRvvw9y5YNYi5sRXv+MXnji+yJirK36ST
6DNeguGZujstQrUf95SdQ2+40eYmIaIhNslMtqB74xIUbWUsGny57sI5otVq
JMsI+ilYK45d1TB0KCNhxeC2AM/MDi+XfYPQMGcrcJeWS2AO6QUDu1K1nlf6
JMpFmjnV8YQEHIF4BIIkibxW0i+K+7AfRBbhwSjNKDojUEesWNh+DmYfXjxB
ueJLhmcM8KDwxPDokhd4gV99ZismCIQhlZNRF5xJqGQfGMbsUsIi+tTKMCXm
0MB+CxMJHDeQV3ZrgmiaQa2hzYT0KrIB5B+OhFNsZhNigiHnLxmuR8BTl3n7
qxOzyNtKxAQaYSaRXJCKs9Jm8yqVekJsHqkUas1zhenIP/wFVFwXtA==
   "], {{0, 0}, {101, 101}}, {0, 1}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRangeClipping->True]], "Output",
 ImageSize->{229, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->616325821]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16972],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticK",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticK"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticE",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticE"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticPi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticPi"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiZeta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiZeta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiAmplitude",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiAmplitude"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14571]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20376],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->28801]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->6953],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/EllipticIntegraloftheFirstKind.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/EllipticIntegrals/EllipticF/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->193386512],

Cell[TextData[ButtonBox["Elliptic Integrals",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticIntegrals"]], "MoreAbout",
 CellID->299291599],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->60139149]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EllipticF - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 39, 59.3544438}", "context" -> "System`", 
    "keywords" -> {"elliptic integral of first kind"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "EllipticF[\\[Phi], m] gives the elliptic integral of the first kind \
F(\\[Phi] \\[VerticalSeparator] m). ", "synonyms" -> {"elliptic f"}, "title" -> 
    "EllipticF", "type" -> "Symbol", "uri" -> "ref/EllipticF"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7453, 260, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->154991223]},
 "XRef-2005-4-26-23-37-1.8558342"->{
  Cell[175501, 4043, 124, 1, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342"],
  Cell[176292, 4076, 87, 1, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 186335, 4407},
 {"XRef-2005-4-26-23-37-1.8558342", 186492, 4411}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2381, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3004, 83, 47, 1, 70, "ObjectName",
 CellID->29733],
Cell[3054, 86, 725, 23, 70, "Usage",
 CellID->2195]
}, Open  ]],
Cell[CellGroupData[{
Cell[3816, 114, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4294, 131, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4417, 137, 786, 28, 70, "Notes",
 CellID->4012],
Cell[5206, 167, 352, 13, 70, "Notes",
 CellID->9238],
Cell[5561, 182, 693, 26, 70, "Notes",
 CellID->27837],
Cell[6257, 210, 477, 17, 70, "Notes",
 CellID->7752],
Cell[6737, 229, 250, 8, 70, "Notes",
 CellID->295634972],
Cell[6990, 239, 220, 7, 70, "Notes",
 CellID->31226],
Cell[7213, 248, 203, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[7453, 260, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->154991223],
Cell[CellGroupData[{
Cell[7838, 274, 148, 5, 70, "ExampleSection",
 CellID->121073090],
Cell[CellGroupData[{
Cell[8011, 283, 112, 3, 28, "Input"],
Cell[8126, 288, 176, 5, 36, "Output",
 CellID->47209955]
}, Open  ]],
Cell[8317, 296, 105, 2, 70, "ExampleDelimiter"],
Cell[CellGroupData[{
Cell[8447, 302, 263, 8, 28, "Input"],
Cell[8713, 312, 2091, 38, 138, "Output",
 Evaluatable->False,
 CellID->139737178]
}, Open  ]],
Cell[10819, 353, 105, 2, 70, "ExampleDelimiter"],
Cell[CellGroupData[{
Cell[10949, 359, 236, 7, 70, "Input"],
Cell[11188, 368, 1294, 40, 56, "Output",
 CellID->102717479]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12531, 414, 200, 6, 70, "ExampleSection"],
Cell[12734, 422, 54, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[12813, 426, 212, 7, 70, "Input"],
Cell[13028, 435, 272, 7, 36, "Output",
 CellID->141677529]
}, Open  ]],
Cell[13315, 445, 105, 2, 70, "ExampleDelimiter"],
Cell[13423, 449, 50, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[13498, 453, 192, 7, 70, "Input"],
Cell[13693, 462, 396, 11, 54, "Output",
 CellID->23369283]
}, Open  ]],
Cell[14104, 476, 124, 3, 70, "ExampleDelimiter",
 CellID->81376879],
Cell[14231, 481, 93, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[14349, 487, 149, 4, 70, "Input"],
Cell[14501, 493, 206, 5, 36, "Output",
 CellID->3404285]
}, Open  ]],
Cell[14722, 501, 105, 2, 70, "ExampleDelimiter"],
Cell[14830, 505, 71, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[14926, 509, 113, 3, 70, "Input"],
Cell[15042, 514, 163, 5, 36, "Output",
 CellID->752058302]
}, Open  ]],
Cell[CellGroupData[{
Cell[15242, 524, 133, 4, 70, "Input"],
Cell[15378, 530, 192, 6, 36, "Output",
 CellID->26026711]
}, Open  ]],
Cell[15585, 539, 105, 2, 70, "ExampleDelimiter"],
Cell[15693, 543, 192, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[15910, 553, 197, 6, 70, "Input"],
Cell[16110, 561, 274, 9, 36, "Output",
 CellID->13463773]
}, Open  ]],
Cell[16399, 573, 105, 2, 70, "ExampleDelimiter"],
Cell[16507, 577, 68, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[16600, 581, 231, 7, 70, "Input"],
Cell[16834, 590, 1853, 53, 84, "Output",
 CellID->220623382]
}, Open  ]],
Cell[18702, 646, 105, 2, 70, "ExampleDelimiter"],
Cell[18810, 650, 321, 10, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[19156, 664, 165, 5, 70, "Input"],
Cell[19324, 671, 282, 9, 50, "Output",
 CellID->244957685]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19655, 686, 223, 6, 70, "ExampleSection"],
Cell[19881, 694, 191, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[20097, 704, 309, 10, 70, "Input"],
Cell[20409, 716, 496, 17, 54, "Output",
 CellID->177065394]
}, Open  ]],
Cell[CellGroupData[{
Cell[20942, 738, 309, 10, 70, "Input"],
Cell[21254, 750, 2014, 61, 81, "Output",
 CellID->132878808]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23317, 817, 207, 6, 70, "ExampleSection"],
Cell[23527, 825, 54, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[23606, 829, 226, 8, 70, "Input"],
Cell[23835, 839, 2419, 83, 182, "Output",
 CellID->14531787]
}, Open  ]],
Cell[26269, 925, 105, 2, 70, "ExampleDelimiter"],
Cell[26377, 929, 85, 1, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[26487, 934, 508, 17, 70, "Input"],
Cell[26998, 953, 44303, 730, 70, "Output",
 Evaluatable->False,
 CellID->733925222]
}, Open  ]],
Cell[71316, 1686, 105, 2, 70, "ExampleDelimiter"],
Cell[71424, 1690, 74, 0, 70, "ExampleText"],
Cell[71501, 1692, 1688, 52, 70, "Input"],
Cell[73192, 1746, 71, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[73288, 1750, 114, 3, 70, "Input"],
Cell[73405, 1755, 174, 5, 36, "Output",
 CellID->73321171]
}, Open  ]],
Cell[73594, 1763, 102, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[73721, 1769, 1294, 39, 70, "Input"],
Cell[75018, 1810, 174, 5, 36, "Output",
 CellID->483827043]
}, Open  ]],
Cell[75207, 1818, 105, 2, 70, "ExampleDelimiter"],
Cell[75315, 1822, 130, 3, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[75470, 1829, 358, 12, 70, "Input"],
Cell[75831, 1843, 474, 16, 49, "Output",
 CellID->292825898]
}, Open  ]],
Cell[76320, 1862, 105, 2, 70, "ExampleDelimiter"],
Cell[76428, 1866, 152, 3, 70, "ExampleText"],
Cell[76583, 1871, 1366, 48, 70, "Input"],
Cell[77952, 1921, 50, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[78027, 1925, 615, 19, 70, "Input"],
Cell[78645, 1946, 72896, 1199, 70, "Output",
 Evaluatable->False,
 CellID->932899898]
}, Open  ]],
Cell[151556, 3148, 66, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[151647, 3152, 1670, 56, 70, "Input"],
Cell[153320, 3210, 158, 5, 36, "Output",
 CellID->354051606]
}, Open  ]],
Cell[153493, 3218, 118, 3, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[153636, 3225, 947, 32, 70, "Input"],
Cell[154586, 3259, 309, 11, 60, "Output",
 CellID->462296627]
}, Open  ]],
Cell[CellGroupData[{
Cell[154932, 3275, 77, 2, 70, "Input"],
Cell[155012, 3279, 174, 5, 36, "Output",
 CellID->1967973]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[155235, 3290, 217, 6, 70, "ExampleSection"],
Cell[155455, 3298, 44, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[155524, 3302, 199, 7, 70, "Input"],
Cell[155726, 3311, 248, 9, 63, "Output",
 CellID->199432129]
}, Open  ]],
Cell[155989, 3323, 72, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[156086, 3327, 146, 4, 70, "Input"],
Cell[156235, 3333, 217, 7, 36, "Output",
 CellID->675436802]
}, Open  ]],
Cell[CellGroupData[{
Cell[156489, 3345, 173, 5, 70, "Input"],
Cell[156665, 3352, 272, 9, 36, "Output",
 CellID->92995970]
}, Open  ]],
Cell[156952, 3364, 105, 2, 70, "ExampleDelimiter"],
Cell[157060, 3368, 214, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[157299, 3379, 176, 5, 70, "Input"],
Cell[157478, 3386, 285, 9, 36, "Output",
 CellID->146776879]
}, Open  ]],
Cell[CellGroupData[{
Cell[157800, 3400, 87, 2, 70, "Input"],
Cell[157890, 3404, 158, 5, 36, "Output",
 CellID->362204126]
}, Open  ]],
Cell[CellGroupData[{
Cell[158085, 3414, 176, 5, 70, "Input"],
Cell[158264, 3421, 285, 9, 36, "Output",
 CellID->196311933]
}, Open  ]],
Cell[CellGroupData[{
Cell[158586, 3435, 87, 2, 70, "Input"],
Cell[158676, 3439, 158, 5, 36, "Output",
 CellID->497316324]
}, Open  ]],
Cell[158849, 3447, 105, 2, 70, "ExampleDelimiter"],
Cell[158957, 3451, 194, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[159176, 3462, 324, 11, 70, "Input"],
Cell[159503, 3475, 451, 8, 70, "Message",
 CellID->7751404],
Cell[159957, 3485, 4495, 142, 293, "Output",
 CellID->572124523]
}, Open  ]],
Cell[164467, 3630, 105, 2, 70, "ExampleDelimiter"],
Cell[164575, 3634, 76, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[164676, 3638, 388, 12, 70, "Input"],
Cell[165067, 3652, 333, 10, 39, "Output",
 CellID->6871494]
}, Open  ]],
Cell[165415, 3665, 105, 2, 70, "ExampleDelimiter"],
Cell[165523, 3669, 33, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[165581, 3673, 228, 7, 70, "Input"],
Cell[165812, 3682, 636, 23, 79, "Output",
 CellID->346407080]
}, Open  ]],
Cell[CellGroupData[{
Cell[166485, 3710, 501, 17, 70, "Input"],
Cell[166989, 3729, 803, 30, 65, "Output",
 CellID->64745354]
}, Open  ]],
Cell[167807, 3762, 105, 2, 70, "ExampleDelimiter"],
Cell[167915, 3766, 45, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[167985, 3770, 335, 10, 70, "Input"],
Cell[168323, 3782, 216, 7, 36, "Output",
 CellID->87914507]
}, Open  ]],
Cell[CellGroupData[{
Cell[168576, 3794, 335, 10, 70, "Input"],
Cell[168914, 3806, 426, 15, 51, "Output",
 CellID->48442794]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[169389, 3827, 225, 7, 70, "ExampleSection",
 CellID->4682],
Cell[169617, 3836, 96, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[169738, 3842, 321, 11, 70, "Input"],
Cell[170062, 3855, 3385, 108, 193, "Output",
 CellID->428043620]
}, Open  ]],
Cell[173462, 3966, 105, 2, 70, "ExampleDelimiter"],
Cell[173570, 3970, 75, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[173670, 3974, 450, 14, 70, "Input",
 CellID->241607850],
Cell[174123, 3990, 242, 8, 39, "Output",
 CellID->402418042]
}, Open  ]],
Cell[CellGroupData[{
Cell[174402, 4003, 722, 23, 70, "Input"],
Cell[175127, 4028, 251, 8, 36, "Output",
 CellID->803849305]
}, Open  ]],
Cell[175393, 4039, 105, 2, 70, "ExampleDelimiter"],
Cell[175501, 4043, 124, 1, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],
Cell[CellGroupData[{
Cell[175650, 4048, 157, 5, 70, "Input"],
Cell[175810, 4055, 222, 7, 36, "Output",
 CellID->729021713]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[176081, 4068, 208, 6, 70, "ExampleSection"],
Cell[176292, 4076, 87, 1, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],
Cell[CellGroupData[{
Cell[176404, 4081, 339, 11, 70, "Input"],
Cell[176746, 4094, 2639, 83, 128, "Output",
 CellID->55349367]
}, Open  ]],
Cell[179400, 4180, 105, 2, 70, "ExampleDelimiter"],
Cell[179508, 4184, 188, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[179721, 4195, 562, 18, 70, "Input"],
Cell[180286, 4215, 1379, 29, 246, "Output",
 CellID->616325821]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[181726, 4251, 311, 9, 70, "SeeAlsoSection",
 CellID->16972],
Cell[182040, 4262, 1212, 44, 70, "SeeAlso",
 CellID->14571]
}, Open  ]],
Cell[CellGroupData[{
Cell[183289, 4311, 314, 9, 70, "TutorialsSection",
 CellID->20376],
Cell[183606, 4322, 192, 4, 70, "Tutorials",
 CellID->28801]
}, Open  ]],
Cell[CellGroupData[{
Cell[183835, 4331, 320, 9, 70, "RelatedLinksSection",
 CellID->6953],
Cell[184158, 4342, 201, 4, 70, "RelatedLinks"],
Cell[184362, 4348, 199, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[184598, 4357, 319, 9, 70, "MoreAboutSection",
 CellID->193386512],
Cell[184920, 4368, 147, 3, 70, "MoreAbout",
 CellID->299291599],
Cell[185070, 4373, 144, 3, 70, "MoreAbout",
 CellID->60139149]
}, Open  ]],
Cell[185229, 4379, 27, 0, 70, "History"],
Cell[185259, 4381, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

