(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28689,       1019]
NotebookOptionsPosition[     23046,        823]
NotebookOutlinePosition[     24391,        861]
CellTagsIndexPosition[     24306,        856]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EllipticExp" :> 
          Documentation`HelpLookup["paclet:ref/EllipticExp"], "EllipticTheta" :> 
          Documentation`HelpLookup["paclet:ref/EllipticTheta"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"EllipticExp\"\>", 
       2->"\<\"EllipticTheta\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"], 
          "Elliptic Integrals" :> 
          Documentation`HelpLookup["paclet:guide/EllipticIntegrals"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Elliptic Functions\"\>", 
       2->"\<\"Elliptic Integrals\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EllipticLog", "ObjectName",
 CellID->26093],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["EllipticLog",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/EllipticLog"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["a", "TI"], ",", 
          StyleBox["b", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the generalized logarithm associated with the \
elliptic curve ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["y", "2"], "=", 
        RowBox[{
         SuperscriptBox["x", "3"], "+", 
         RowBox[{"a", " ", 
          SuperscriptBox["x", "2"]}], "+", 
         RowBox[{"b", " ", "x"}]}]}], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24205]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["EllipticLog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticLog"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 " is defined as the value of the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", "2"], 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "\[Infinity]", "x"], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["t", "3"], "+", 
         RowBox[{"a", "\[VeryThinSpace]", 
          SuperscriptBox["t", "2"]}], "+", 
         RowBox[{"b", "\[VeryThinSpace]", "t"}]}], ")"}], 
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}]], "d", "\[VeryThinSpace]", "t"}]}]}], 
   TraditionalForm]], "InlineMath"],
 ", where the sign of the square root is specified by giving the value of ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["x", "3"], "+", 
      RowBox[{"a", "\[VeryThinSpace]", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"b", "\[VeryThinSpace]", "x"}]}]]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->18042],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticLog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticLog"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->334150698],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->790626189],

Cell["Evaluate numerically:", "ExampleText",
 CellID->79887406],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "0.3"}], "}"}], ",", 
   RowBox[{"EllipticLog", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"x", "^", "3"}], "-", 
         RowBox[{"5", 
          RowBox[{"x", "^", "2"}]}], "+", "x"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", "1"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21585744],

Cell[BoxData[
 RowBox[{"0.7256311852272992`", "\[InvisibleSpace]", "+", 
  RowBox[{"1.0681781783521944`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->222352295]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "0.3"}], "}"}], ",", 
   RowBox[{"EllipticLog", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", 
        RowBox[{"Sqrt", "[", 
         RowBox[{
          RowBox[{"x", "^", "3"}], "-", 
          RowBox[{"5", 
           RowBox[{"x", "^", "2"}]}], "+", "x"}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", "1"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->440380095],

Cell[BoxData[
 RowBox[{"0.7256311852272992`", "\[InvisibleSpace]", "-", 
  RowBox[{"1.0681781783521944`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->334073360]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->518382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"EllipticLog", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"Sqrt", "[", 
         RowBox[{
          RowBox[{"x", "^", "3"}], "+", 
          RowBox[{"4", 
           RowBox[{"x", "^", "2"}]}], "+", "x"}], "]"}]}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"4", ",", "1"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->407788630],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 126},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16506834]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2408],

Cell["Evaluate for complex arguments and parameters:", "ExampleText",
 CellID->4444035],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticLog", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "+", "I"}], ",", 
     RowBox[{
      RowBox[{"-", "I"}], " ", 
      RowBox[{"Sqrt", "[", "15", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "-", "I"}], ",", 
     RowBox[{"-", "12.0"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->736993573],

Cell[BoxData[
 RowBox[{"0.6317190201568897`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.2501813381422783`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->190154306]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8561960],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->105180445],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"EllipticLog", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "6"}], "}"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->184173805],

Cell[BoxData[
 RowBox[{"-", 
  "0.7098518800801157325977999683322569755601880350110471648965725994359`50."}\
]], "Output",
 ImageSize->{376, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->675352637]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->608725055],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->214336764],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticLog", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.000000000000000000000000000000000", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->362428851],

Cell[BoxData[
 RowBox[{"-", 
  "0.709851880080115732597799968332256975560188035003`31.954916825549194"}]], \
"Output",
 ImageSize->{250, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->641356927]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21280],

Cell[TextData[{
 "Define addition on the elliptic curve ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["y", "2"], "\[LongEqual]", 
    RowBox[{
     SuperscriptBox["x", "3"], "+", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"b", " ", "x"}]}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->22073173],

Cell[BoxData[
 RowBox[{
  RowBox[{"ellipticAdd", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x1_", ",", "y1_"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x2_", ",", "y2_"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a_", ",", "b_"}], "}"}]}], "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"s", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"y2", "-", "y1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"x2", "-", "x1"}], ")"}]}]}], ",", "x3", ",", "y3"}], "}"}], 
    ",", 
    RowBox[{
     RowBox[{"x3", "=", 
      RowBox[{
       RowBox[{"s", "^", "2"}], "-", "x1", "-", "x2", "-", "a"}]}], ";", " ", 
     
     RowBox[{"y3", "=", 
      RowBox[{
       RowBox[{"-", "y1"}], "+", 
       RowBox[{"s", 
        RowBox[{"(", 
         RowBox[{"x1", "-", "x3"}], ")"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"x3", ",", "y3"}], "}"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->872126664],

Cell["Use addition on the elliptic curve to add rational numbers:", \
"ExampleText",
 CellID->159392050],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ellipticAdd", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"EllipticExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "/", "3."}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "1"}], "}"}]}], "]"}], ",", 
     RowBox[{"EllipticExp", "[", 
      RowBox[{
       RowBox[{"1", "/", "2."}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "1"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->421839988],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"34.690370443334544`", ",", 
   RowBox[{"-", "215.85996773348234`"}]}], "}"}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->778250255]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"EllipticLog", "[", 
   RowBox[{"%", ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "1"}], "}"}]}], "]"}], "\[Equal]", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "/", "3"}], "+", 
    RowBox[{"1", "/", "2"}]}], ")"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->299789009],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->700870167]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1116],

Cell["Differentiation:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->164473026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"EllipticLog", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}]}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->297717024],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"2", " ", "y"}]]], "Output",
 ImageSize->{26, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->105625820]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->59477612],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticExp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticExp"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["EllipticLog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticLog"]], "InlineFormula"],
 " are inverse functions of one another:"
}], "ExampleText",
 CellID->291663548],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticExp", "[", 
  RowBox[{"0.5", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->313332756],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.9680104775665788`", ",", 
   RowBox[{"-", "8.027749411851687`"}]}], "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->120173983]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticLog", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->270292262],

Cell[BoxData["0.5`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->121053608]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5642],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticExp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticExp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticTheta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticTheta"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12796]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29498],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->29078]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->4639],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/EllipticLogarithm.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/EllipticFunctions/EllipticLog/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->242495],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->211327692],

Cell[TextData[ButtonBox["Elliptic Integrals",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticIntegrals"]], "MoreAbout",
 CellID->90989401]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EllipticLog - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 40, 2.1357650}", "context" -> "System`", 
    "keywords" -> {
     "elliptic curve", "elliptic function", "elliptic logarithm", "elog"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "EllipticLog[{x, y}, {a, b}] gives the generalized logarithm associated \
with the elliptic curve y^2 = x^3 + a x^2 + b x. ", 
    "synonyms" -> {"elliptic log"}, "title" -> "EllipticLog", "type" -> 
    "Symbol", "uri" -> "ref/EllipticLog"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6123, 206, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->334150698]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24163, 849}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2063, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2686, 78, 49, 1, 70, "ObjectName",
 CellID->26093],
Cell[2738, 81, 1050, 34, 70, "Usage",
 CellID->24205]
}, Open  ]],
Cell[CellGroupData[{
Cell[3825, 120, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4303, 137, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4426, 143, 1433, 49, 70, "Notes",
 CellID->18042],
Cell[5862, 194, 224, 7, 70, "Notes",
 CellID->31226]
}, Closed]],
Cell[CellGroupData[{
Cell[6123, 206, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->334150698],
Cell[CellGroupData[{
Cell[6508, 220, 148, 5, 70, "ExampleSection",
 CellID->790626189],
Cell[6659, 227, 63, 1, 70, "ExampleText",
 CellID->79887406],
Cell[CellGroupData[{
Cell[6747, 232, 527, 18, 28, "Input",
 CellID->21585744],
Cell[7277, 252, 273, 7, 36, "Output",
 CellID->222352295]
}, Open  ]],
Cell[CellGroupData[{
Cell[7587, 264, 556, 19, 28, "Input",
 CellID->440380095],
Cell[8146, 285, 273, 7, 36, "Output",
 CellID->334073360]
}, Open  ]],
Cell[8434, 295, 122, 3, 70, "ExampleDelimiter",
 CellID->518382],
Cell[CellGroupData[{
Cell[8581, 302, 581, 19, 28, "Input",
 CellID->407788630],
Cell[9165, 323, 2830, 50, 147, "Output",
 Evaluatable->False,
 CellID->16506834]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12044, 379, 215, 7, 70, "ExampleSection",
 CellID->2408],
Cell[12262, 388, 87, 1, 70, "ExampleText",
 CellID->4444035],
Cell[CellGroupData[{
Cell[12374, 393, 388, 14, 70, "Input",
 CellID->736993573],
Cell[12765, 409, 273, 7, 36, "Output",
 CellID->190154306]
}, Open  ]],
Cell[13053, 419, 123, 3, 70, "ExampleDelimiter",
 CellID->8561960],
Cell[13179, 424, 70, 1, 70, "ExampleText",
 CellID->105180445],
Cell[CellGroupData[{
Cell[13274, 429, 291, 10, 70, "Input",
 CellID->184173805],
Cell[13568, 441, 253, 8, 36, "Output",
 CellID->675352637]
}, Open  ]],
Cell[13836, 452, 125, 3, 70, "ExampleDelimiter",
 CellID->608725055],
Cell[13964, 457, 113, 3, 70, "ExampleText",
 CellID->214336764],
Cell[CellGroupData[{
Cell[14102, 464, 262, 8, 70, "Input",
 CellID->362428851],
Cell[14367, 474, 249, 8, 36, "Output",
 CellID->641356927]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14665, 488, 223, 7, 70, "ExampleSection",
 CellID->21280],
Cell[14891, 497, 368, 13, 70, "ExampleText",
 CellID->22073173],
Cell[15262, 512, 1092, 37, 70, "Input",
 CellID->872126664],
Cell[16357, 551, 104, 2, 70, "ExampleText",
 CellID->159392050],
Cell[CellGroupData[{
Cell[16486, 557, 560, 19, 70, "Input",
 CellID->421839988],
Cell[17049, 578, 259, 8, 36, "Output",
 CellID->778250255]
}, Open  ]],
Cell[CellGroupData[{
Cell[17345, 591, 330, 12, 70, "Input",
 CellID->299789009],
Cell[17678, 605, 161, 5, 36, "Output",
 CellID->700870167]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17888, 616, 232, 7, 70, "ExampleSection",
 CellID->1116],
Cell[18123, 625, 196, 5, 70, "ExampleText",
 CellID->164473026],
Cell[CellGroupData[{
Cell[18344, 634, 290, 10, 70, "Input",
 CellID->297717024],
Cell[18637, 646, 201, 7, 53, "Output",
 CellID->105625820]
}, Open  ]],
Cell[18853, 656, 124, 3, 70, "ExampleDelimiter",
 CellID->59477612],
Cell[18980, 661, 356, 12, 70, "ExampleText",
 CellID->291663548],
Cell[CellGroupData[{
Cell[19361, 677, 181, 6, 70, "Input",
 CellID->313332756],
Cell[19545, 685, 258, 8, 36, "Output",
 CellID->120173983]
}, Open  ]],
Cell[CellGroupData[{
Cell[19840, 698, 179, 6, 70, "Input",
 CellID->270292262],
Cell[20022, 706, 161, 5, 36, "Output",
 CellID->121053608]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20244, 718, 310, 9, 70, "SeeAlsoSection",
 CellID->5642],
Cell[20557, 729, 467, 17, 70, "SeeAlso",
 CellID->12796]
}, Open  ]],
Cell[CellGroupData[{
Cell[21061, 751, 314, 9, 70, "TutorialsSection",
 CellID->29498],
Cell[21378, 762, 192, 4, 70, "Tutorials",
 CellID->29078]
}, Open  ]],
Cell[CellGroupData[{
Cell[21607, 771, 320, 9, 70, "RelatedLinksSection",
 CellID->4639],
Cell[21930, 782, 188, 4, 70, "RelatedLinks"],
Cell[22121, 788, 201, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22359, 797, 316, 9, 70, "MoreAboutSection",
 CellID->242495],
Cell[22678, 808, 147, 3, 70, "MoreAbout",
 CellID->211327692],
Cell[22828, 813, 146, 3, 70, "MoreAbout",
 CellID->90989401]
}, Open  ]],
Cell[22989, 819, 27, 0, 70, "History"],
Cell[23019, 821, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

