(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     73724,       1915]
NotebookOptionsPosition[     66335,       1672]
NotebookOutlinePosition[     67788,       1712]
CellTagsIndexPosition[     67652,       1706]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InverseEllipticNomeQ" :> 
          Documentation`HelpLookup["paclet:ref/InverseEllipticNomeQ"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"InverseEllipticNomeQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"], 
          "Elliptic Integrals" :> 
          Documentation`HelpLookup["paclet:guide/EllipticIntegrals"], 
          "Inverse Functions" :> 
          Documentation`HelpLookup["paclet:guide/InverseFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Elliptic Functions\"\>", 
       2->"\<\"Elliptic Integrals\"\>", 
       3->"\<\"Inverse Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EllipticNomeQ", "ObjectName",
 CellID->15247],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["EllipticNomeQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/EllipticNomeQ"], "[", 
       StyleBox["m", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the nome ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"],
     " corresponding to the parameter ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " in an elliptic function. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1658]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticNomeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticNomeQ"]], "InlineFormula"],
 " is related to ",
 Cell[BoxData[
  ButtonBox["EllipticK",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticK"]], "InlineFormula"],
 " by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"q", "(", "m", ")"}], "=", 
    RowBox[{"exp", "[", 
     RowBox[{
      RowBox[{"-", "\[Pi]"}], "\[InvisibleSpace]", 
      RowBox[{
       RowBox[{"K", "(", 
        RowBox[{"1", "-", "m"}], ")"}], "/", 
       RowBox[{"K", "(", "m", ")"}]}]}], "]"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->9566],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["EllipticNomeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticNomeQ"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " plane running from ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->18725],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["EllipticNomeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticNomeQ"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->160351738],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticNomeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticNomeQ"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticNomeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticNomeQ"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->98135962],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->213872628],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticNomeQ", "[", 
  RowBox[{"-", "2."}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->449527254],

Cell[BoxData[
 RowBox[{"-", "0.06823782774533839`"}]], "Output",
 ImageSize->{75, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->57937933]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->543396058],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"EllipticNomeQ", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->85720348],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytmE1oHVUUx2/eR2KssY1tbFprG1vbiih+1EZr20SNSayx1BZrleIiBiFZ
2EqNG93oRje60Y2FYhd+gB+LiKUiVBALYkEsiAVRQSpIXVgEi4uA8Pyde2be
nbnvvjtJ33sk8+7M/O//no//OXPn7Z6cnX7m2cnZmanJgfEjk89Nz0w9PzB2
+AiXyh3GmBP8H+o3jGuM7P/BWq1myjKyH/O4HIxcLXHxgD3rlGP1pRe/eOrg
hxzff+/s2e//MI8GZ3bJsfv8+b9Pf/3b0bfPHD702fDOozPTc2+9+Q1XLl78
10wE510lxyvO/fjnxx/9wBp797zLYm+8fvrLU78yaTw4Z5mdw1qfzp175eVT
9Tmfn/zpwoV/RoJzVtirOue1V78ypQP7PzBlRjrJDOc877crcJ27YMDqCrgy
P//f9uAKa+TYpSvgyejIMdw//s53+GY2JOxlb6ZcKzGQS51B1gHLCgdM8E3s
Oo7HWCURXSv3Km6GMZXwlQyrb4GussGucunSPGHHXyI69fQnpPGXn/8yfdyr
JHZezmouqpvl2AknSoKfqBJSJNXfNj9utn6QN3KABDVa+ETSVAEFq5QSe8O5
uDUTJXhz7L0LZM+yVoOr3G6jBGd2FYS3LGNbKeGX7zDLlgyL1hWxRkbrcxkZ
tCi0RLxQFxlBZoRvXZBzm0VzGxBQAowQCceaIHqHdZH0qqA4SiWsDmKHUmsh
xA7EwYDTlTlr77eM6EcZ0adUbl+QsTNRrWhObi61czEW7WE7DKLt5d7cjQl6
UzLb5lB7W4LiaG7yZmnusRi7CcqZb3/v9RCbIuemvo6KWj+hbjGQWOVft15U
iPQLsyc1dEsL1t/snevC3QWzbKQrGn9iiLJ6kvz4fH6ESgviX2n5ySmCxw80
v6RgRngdW725yvNxq1JPKA1WInRFtm1s4HTaKCUryPf1KTNC4I9BV4ApO8PW
r9mX5hBzqFRKslrLav8xy0KZ8iDiUdnQD1X1+y0LKuexCxEF5/ccxVlOqSSK
jdWYIJp7wt57MrOSuyoKmeOsw0U4w3p1wbnfo/z5l3VfsqFFh59+PIosWqzF
GWVlrtqsVfUc3RJN2otqJYO6xc61O66u+lU+uk+S4O+rI1zdqxakZ+518xue
gKwKB9nSfVkDSuNCKyXNrGf2BFHqF7ZT2fI02x1EqZIJOX1GrH4kZ3V3anXi
00SQQ1FaH4J6OIi60kPtCqKWeKiHcvb0eHfHgxw9qdX4JJ6PBVGqDhoS/UKG
o0GUdl1yQaxl+GAQZXevyc5ThiMRFBahAfaUTVC9qQZAiY8PWNRYbfG7zWs8
D+2zVv1scWemz1gaEm1Lhve1xCyny9PYUG/yFG+NMXu+ItUM8ZTh8IKZm+0c
+zzvhxbFGOtIfWkUeBTL28BQLvdFu8RrvXzvrIX0ZZ/IZSAAZbgjgnJRC6Ps
Lj+j++0RFP7gldSjQ4kXq71o3hvkWJVysElsjlIuSpWCleG2CMr5FkZdZ89p
Iez9ZHhPBOViHkbpbhrTcUCGd0dQdHSadhGK/kA08yiJpn1/LNMeaX8yHAxy
2B1NpqsN5nTmV1A5UgvKRJ/COcmtMjXWQuP+za8Ff9W1Xvy3tplZfwZonVmi
sq6WV2f7bFVmmiKbBhne1VbmEm99W3O5T3tMuRbOt9rjakftSdV3g73L6y2C
kOGW+l3/nSfbgWIomgKtoQjl7Amj1K7RkWNIVIZ3RlCudmIoV6UxlOsLMZSr
ZYeSaNpfcDJd444gx3ovmjGUszqG0h8pilAu5jEUQkAODhXrMekrs3585fnR
sL+pNKuEiO79c+V1faa9vO651gpvua4G0kcSC/nclVq4jpXN6TPKVs2ySW78
919lY0/L+6VjW+i+RWc7pejstAr0zcvV7m31u1mOG+05y2NEEcrlOoaiCVCY
zVGhX9dNx/8Br0TO\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->151718398]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->60217398],

Cell["Series expansion:", "ExampleText",
 CellID->875088119],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"EllipticNomeQ", "[", "m", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->277605641],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["m", "16"], "+", 
   FractionBox[
    SuperscriptBox["m", "2"], "32"], "+", 
   FractionBox[
    RowBox[{"21", " ", 
     SuperscriptBox["m", "3"]}], "1024"], "+", 
   FractionBox[
    RowBox[{"31", " ", 
     SuperscriptBox["m", "4"]}], "2048"], "+", 
   FractionBox[
    RowBox[{"6257", " ", 
     SuperscriptBox["m", "5"]}], "524288"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "6"],
    SeriesData[$CellContext`m, 0, {}, 1, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 0, {
    Rational[1, 16], 
    Rational[1, 32], 
    Rational[21, 1024], 
    Rational[31, 2048], 
    Rational[6257, 524288]}, 1, 6, 1],
  Editable->False]], "Output",
 ImageSize->{253, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->135292019]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Simple arguments evaluate automatically:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticNomeQ", "[", 
  RowBox[{"1", "/", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{"-", "\[Pi]"}]]], "Output",
 ImageSize->{23, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41498256]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Evaluate to high precision:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"EllipticNomeQ", "[", 
    RowBox[{"33", "/", "100"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["0.\
0250089803731769680234501247750404866632605499177486456817550505277`50."], \
"Output",
 ImageSize->{375, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5975301]
}, Open  ]],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticNomeQ", "[", "0.330000000000000000000000", "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["0.02500898037317696802345012477504048666`22.23248583536703"], \
"Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->282432800]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticNomeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticNomeQ"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticNomeQ", "[", 
  RowBox[{"{", 
   RowBox[{"0.2", ",", " ", "0.3", ",", " ", "0.4"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.013942857275318264`", ",", "0.02227743615715351`", ",", 
   "0.03188334731336319`"}], "}"}]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->175178486]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"EllipticNomeQ", "[", "m", "]"}], " ", "//", " ", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   InterpretationBox["q",
    EllipticNomeQ,
    Editable->False,
    Selectable->False], "(", "m", ")"}], TraditionalForm]], "Output",
 ImageSize->{27, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->798052986]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticNomeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticNomeQ"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticNomeQ", "[", 
  RowBox[{"m", "-", 
   FractionBox[
    SuperscriptBox["m", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["m", "3"], "9"], "+", 
   SuperscriptBox[
    RowBox[{"O", "[", "m", "]"}], "4"]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["m", "16"], "-", 
   FractionBox[
    RowBox[{"35", " ", 
     SuperscriptBox["m", "3"]}], "9216"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "4"],
    SeriesData[$CellContext`m, 0, {}, 1, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 0, {
    Rational[1, 16], 0, 
    Rational[-35, 9216]}, 1, 4, 1],
  Editable->False]], "Output",
 ImageSize->{115, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->99795811]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  ButtonBox["EllipticNomeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticNomeQ"]], "InlineFormula"],
 " over the complex plane:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"EllipticNomeQ", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87025026]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify expressions containing ",
 Cell[BoxData[
  ButtonBox["EllipticNomeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticNomeQ"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"EllipticNomeQ", "[", "m", "]"}], "+", 
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", "\[Pi]"}], " ", 
     RowBox[{
      RowBox[{"EllipticK", "[", 
       RowBox[{"1", "-", "m"}], "]"}], "/", 
      RowBox[{"EllipticK", "[", "m", "]"}]}]}], "]"}]}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"2", " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[Pi]", " ", 
      RowBox[{"EllipticK", "[", 
       RowBox[{"1", "-", "m"}], "]"}]}], 
     RowBox[{"EllipticK", "[", "m", "]"}]]}]]}]], "Output",
 ImageSize->{109, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16419631]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Compose with inverse functions:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseEllipticNomeQ", "[", 
    RowBox[{"EllipticNomeQ", "[", "z", "]"}], "]"}], ",", 
   RowBox[{"EllipticNomeQ", "[", 
    RowBox[{"InverseEllipticNomeQ", "[", "z", "]"}], "]"}]}], "}"}]], "Input",\

 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   RowBox[{"EllipticNomeQ", "[", 
    RowBox[{"InverseEllipticNomeQ", "[", "z", "]"}], "]"}]}], "}"}]], "Output",\

 ImageSize->{303, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->430048053]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->426162909]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Find the derivative:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"EllipticNomeQ", "[", "q", "]"}], ",", "q"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[Pi]", "2"], " ", 
    RowBox[{"EllipticNomeQ", "[", "q", "]"}]}], 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", "q", " ", 
    SuperscriptBox[
     RowBox[{"EllipticK", "[", "q", "]"}], "2"]}]]}]], "Output",
 ImageSize->{177, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->474068398]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Symbolically solve a transcendental equation:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"EllipticNomeQ", "[", "z", "]"}], "+", 
     SuperscriptBox[
      RowBox[{"EllipticNomeQ", "[", "z", "]"}], "2"]}], "\[Equal]", "g"}], 
   ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"InverseEllipticNomeQ", "[", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         SqrtBox[
          RowBox[{"1", "+", 
           RowBox[{"4", " ", "g"}]}]]}], ")"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"InverseEllipticNomeQ", "[", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SqrtBox[
          RowBox[{"1", "+", 
           RowBox[{"4", " ", "g"}]}]]}], ")"}]}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{318, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6096613]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Numerically find a root of a transcendental equation:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"EllipticNomeQ", "[", "z", "]"}], "+", 
     RowBox[{"EllipticNomeQ", "[", 
      RowBox[{"z", "^", "2"}], "]"}], "+", "z"}], "\[Equal]", 
    RowBox[{"-", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"2", "+", "I"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", 
   RowBox[{
    RowBox[{"-", "1.0457010686134143`"}], "-", 
    RowBox[{"0.11357372684164047`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->549012177]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "For most named special functions, the direct function is \
single\[Hyphen]valued and the inverse is multi\[Hyphen]valued. ",
 Cell[BoxData[
  ButtonBox["EllipticNomeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticNomeQ"]], "InlineFormula"],
 " is a multi\[Hyphen]valued function and the inverse function, ",
 Cell[BoxData[
  ButtonBox["InverseEllipticNomeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseEllipticNomeQ"]], "InlineFormula"],
 ", is single-valued. As a result, the following is correct everywhere:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseEllipticNomeQ", "[", 
  RowBox[{"EllipticNomeQ", "[", "z", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["z"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->62958153]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "Riemann surface of ",
 Cell[BoxData[
  ButtonBox["EllipticNomeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticNomeQ"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", 
       RowBox[{"InverseEllipticNomeQ", "[", 
        RowBox[{"r", " ", 
         RowBox[{"Exp", "[", 
          RowBox[{"I", " ", "\[Phi]"}], "]"}]}], "]"}], "]"}], ",", 
      RowBox[{"Im", "[", 
       RowBox[{"InverseEllipticNomeQ", "[", 
        RowBox[{"r", " ", 
         RowBox[{"Exp", "[", 
          RowBox[{"I", " ", "\[Phi]"}], "]"}]}], "]"}], "]"}], ",", 
      RowBox[{"r", " ", 
       RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "0", ",", "0.4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{"Opacity", "[", "0.66", "]"}], "}"}]}], ",", 
   RowBox[{"BoxRatios", "->", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 201},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->146916976]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25279],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["InverseEllipticNomeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseEllipticNomeQ"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->26652]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1307],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->4232]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->20680],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/EllipticNomeQ.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/EllipticFunctions/EllipticNomeQ/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->341153500],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->409265679],

Cell[TextData[ButtonBox["Elliptic Integrals",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticIntegrals"]], "MoreAbout",
 CellID->933092047],

Cell[TextData[ButtonBox["Inverse Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InverseFunctions"]], "MoreAbout",
 CellID->676416757]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EllipticNomeQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 40, 2.5107746}", "context" -> "System`", 
    "keywords" -> {"ellipticnome", "nome"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "EllipticNomeQ[m] gives the nome q corresponding to the parameter m in an \
elliptic function. ", "synonyms" -> {"elliptic nome q"}, "title" -> 
    "EllipticNomeQ", "type" -> "Symbol", "uri" -> "ref/EllipticNomeQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6037, 210, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->98135962]},
 "XRef-2005-4-26-23-37-1.8558342"->{
  Cell[40203, 1157, 237, 8, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 67377, 1696},
 {"XRef-2005-4-26-23-37-1.8558342", 67533, 1700}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2122, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2745, 80, 51, 1, 70, "ObjectName",
 CellID->15247],
Cell[2799, 83, 672, 21, 70, "Usage",
 CellID->1658]
}, Open  ]],
Cell[CellGroupData[{
Cell[3508, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3986, 126, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4109, 132, 671, 25, 70, "Notes",
 CellID->9566],
Cell[4783, 159, 511, 18, 70, "Notes",
 CellID->18725],
Cell[5297, 179, 258, 8, 70, "Notes",
 CellID->160351738],
Cell[5558, 189, 228, 7, 70, "Notes",
 CellID->31226],
Cell[5789, 198, 211, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6037, 210, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->98135962],
Cell[CellGroupData[{
Cell[6421, 224, 148, 5, 70, "ExampleSection",
 CellID->213872628],
Cell[CellGroupData[{
Cell[6594, 233, 128, 4, 28, "Input",
 CellID->449527254],
Cell[6725, 239, 193, 6, 36, "Output",
 CellID->57937933]
}, Open  ]],
Cell[6933, 248, 125, 3, 70, "ExampleDelimiter",
 CellID->543396058],
Cell[CellGroupData[{
Cell[7083, 255, 243, 8, 28, "Input",
 CellID->85720348],
Cell[7329, 265, 2181, 40, 131, "Output",
 Evaluatable->False,
 CellID->151718398]
}, Open  ]],
Cell[9525, 308, 124, 3, 70, "ExampleDelimiter",
 CellID->60217398],
Cell[9652, 313, 60, 1, 70, "ExampleText",
 CellID->875088119],
Cell[CellGroupData[{
Cell[9737, 318, 225, 7, 70, "Input",
 CellID->277605641],
Cell[9965, 327, 888, 31, 54, "Output",
 CellID->135292019]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10902, 364, 200, 6, 70, "ExampleSection"],
Cell[11105, 372, 63, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[11193, 376, 112, 3, 70, "Input"],
Cell[11308, 381, 216, 7, 36, "Output",
 CellID->41498256]
}, Open  ]],
Cell[11539, 391, 105, 2, 70, "ExampleDelimiter"],
Cell[11647, 395, 187, 4, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[11859, 403, 170, 5, 70, "Input"],
Cell[12032, 410, 233, 7, 36, "Output",
 CellID->5975301]
}, Open  ]],
Cell[12280, 420, 93, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[12398, 426, 114, 2, 70, "Input"],
Cell[12515, 430, 218, 6, 36, "Output",
 CellID->282432800]
}, Open  ]],
Cell[12748, 439, 105, 2, 70, "ExampleDelimiter"],
Cell[12856, 443, 337, 10, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[13218, 457, 162, 4, 70, "Input"],
Cell[13383, 463, 279, 9, 36, "Output",
 CellID->175178486]
}, Open  ]],
Cell[13677, 475, 105, 2, 70, "ExampleDelimiter"],
Cell[13785, 479, 320, 10, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[14130, 493, 140, 4, 70, "Input"],
Cell[14273, 499, 317, 11, 50, "Output",
 CellID->798052986]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14639, 516, 223, 6, 70, "ExampleSection"],
Cell[14865, 524, 199, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[15089, 534, 283, 9, 70, "Input"],
Cell[15375, 545, 576, 20, 54, "Output",
 CellID->99795811]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16000, 571, 207, 6, 70, "ExampleSection"],
Cell[16210, 579, 201, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[16436, 590, 400, 13, 70, "Input"],
Cell[16839, 605, 16340, 272, 70, "Output",
 Evaluatable->False,
 CellID->87025026]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33228, 883, 217, 6, 70, "ExampleSection"],
Cell[33448, 891, 345, 12, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[33818, 907, 366, 12, 70, "Input"],
Cell[34187, 921, 397, 13, 46, "Output",
 CellID->16419631]
}, Open  ]],
Cell[34599, 937, 105, 2, 70, "ExampleDelimiter"],
Cell[34707, 941, 54, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[34786, 945, 277, 8, 70, "Input"],
Cell[35066, 955, 296, 10, 36, "Output",
 CellID->430048053]
}, Open  ]],
Cell[CellGroupData[{
Cell[35399, 970, 87, 2, 70, "Input"],
Cell[35489, 974, 203, 7, 36, "Output",
 CellID->426162909]
}, Open  ]],
Cell[35707, 984, 105, 2, 70, "ExampleDelimiter"],
Cell[35815, 988, 43, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[35883, 992, 141, 4, 70, "Input"],
Cell[36027, 998, 475, 16, 57, "Output",
 CellID->474068398]
}, Open  ]],
Cell[36517, 1017, 105, 2, 70, "ExampleDelimiter"],
Cell[36625, 1021, 68, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[36718, 1025, 278, 9, 70, "Input"],
Cell[36999, 1036, 849, 30, 81, "Output",
 CellID->6096613]
}, Open  ]],
Cell[37863, 1069, 105, 2, 70, "ExampleDelimiter"],
Cell[37971, 1073, 76, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[38072, 1077, 381, 12, 70, "Input"],
Cell[38456, 1091, 331, 11, 36, "Output",
 CellID->549012177]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38836, 1108, 210, 6, 70, "ExampleSection"],
Cell[39049, 1116, 573, 13, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[39647, 1133, 136, 3, 70, "Input"],
Cell[39786, 1138, 157, 5, 36, "Output",
 CellID->62958153]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39992, 1149, 208, 6, 70, "ExampleSection"],
Cell[40203, 1157, 237, 8, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],
Cell[CellGroupData[{
Cell[40465, 1169, 1022, 29, 70, "Input"],
Cell[41490, 1200, 22079, 366, 70, "Output",
 Evaluatable->False,
 CellID->146916976]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[63630, 1573, 311, 9, 70, "SeeAlsoSection",
 CellID->25279],
Cell[63944, 1584, 220, 6, 70, "SeeAlso",
 CellID->26652]
}, Open  ]],
Cell[CellGroupData[{
Cell[64201, 1595, 313, 9, 70, "TutorialsSection",
 CellID->1307],
Cell[64517, 1606, 191, 4, 70, "Tutorials",
 CellID->4232]
}, Open  ]],
Cell[CellGroupData[{
Cell[64745, 1615, 321, 9, 70, "RelatedLinksSection",
 CellID->20680],
Cell[65069, 1626, 184, 4, 70, "RelatedLinks"],
Cell[65256, 1632, 203, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[65496, 1641, 319, 9, 70, "MoreAboutSection",
 CellID->341153500],
Cell[65818, 1652, 147, 3, 70, "MoreAbout",
 CellID->409265679],
Cell[65968, 1657, 147, 3, 70, "MoreAbout",
 CellID->933092047],
Cell[66118, 1662, 145, 3, 70, "MoreAbout",
 CellID->676416757]
}, Open  ]],
Cell[66278, 1668, 27, 0, 70, "History"],
Cell[66308, 1670, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

