(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    154290,       3988]
NotebookOptionsPosition[    142091,       3563]
NotebookOutlinePosition[    143620,       3603]
CellTagsIndexPosition[    143533,       3598]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EllipticK" :> Documentation`HelpLookup["paclet:ref/EllipticK"],
           "EllipticF" :> Documentation`HelpLookup["paclet:ref/EllipticF"], 
          "EllipticE" :> Documentation`HelpLookup["paclet:ref/EllipticE"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"EllipticK\"\>", 
       2->"\<\"EllipticF\"\>", 3->"\<\"EllipticE\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals" :> 
          Documentation`HelpLookup["paclet:guide/EllipticIntegrals"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Elliptic Integrals\"\>", 
       2->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EllipticPi", "ObjectName",
 CellID->6549],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["EllipticPi",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/EllipticPi"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the complete elliptic integral of the third kind \
",
     Cell[BoxData[
      RowBox[{
       StyleBox["\[CapitalPi]", "TR"], 
       RowBox[{"(", 
        RowBox[{
         StyleBox["n", "TI"], "\[VerticalSeparator]", 
         StyleBox["m", "TI"]}], ")"}]}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["EllipticPi",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/EllipticPi"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["\[Phi]", "TR"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the incomplete elliptic integral ",
     Cell[BoxData[
      RowBox[{
       StyleBox["\[CapitalPi]", "TR"], 
       RowBox[{"(", 
        RowBox[{
         StyleBox["n", "TI"], ";", 
         RowBox[{
          StyleBox["\[Phi]", "TR"], "\[VerticalSeparator]", 
          StyleBox["m", "TI"]}]}], ")"}]}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->10695]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[CapitalPi]", "(", 
     RowBox[{"n", ";", 
      RowBox[{
       RowBox[{"\[Phi]", "\[VerticalSeparator]"}], "m"}]}], ")"}], "=", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "\[Phi]"], 
     RowBox[{
      SuperscriptBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"n", " ", 
            RowBox[{
             SuperscriptBox["sin", "2"], "(", "\[Theta]", ")"}]}]}], ")"}], 
         RowBox[{"-", "1"}]], "[", 
        RowBox[{"1", "-", 
         RowBox[{"m", " ", 
          RowBox[{
           SuperscriptBox["sin", "2"], "(", "\[Theta]", ")"}]}]}], "]"}], 
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}]], "d", "\[VeryThinSpace]", 
      "\[Theta]"}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->421056331],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[CapitalPi]", "(", 
     RowBox[{"n", ";", 
      RowBox[{
       RowBox[{"\[Phi]", "\[VerticalSeparator]"}], "m"}]}], ")"}], "=", 
    RowBox[{
     RowBox[{"\[CapitalPi]", "(", 
      RowBox[{"n", "\[VerticalSeparator]", "m"}], ")"}], "=", 
     RowBox[{"\[CapitalPi]", "(", 
      RowBox[{"n", ";", 
       RowBox[{
        FractionBox["\[Pi]", "2"], "\[VerticalSeparator]", "m"}]}], ")"}]}]}],
    TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellID->132178877],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["EllipticPi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticPi"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->32287970],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticPi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticPi"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticPi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticPi"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->444779439],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->822304930],

Cell["Evaluate numerically:", "ExampleText",
 CellID->302265459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticPi", "[", 
  RowBox[{"0.4", ",", "0.6"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->436394388],

Cell[BoxData["2.590921156555219`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6589803]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->353050909],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"EllipticPi", "[", 
    RowBox[{"m", ",", "0.6"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->438244904],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87383903]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->93803308],

Cell["Series expansions:", "ExampleText",
 CellID->89013934],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"EllipticPi", "[", 
    RowBox[{"n", ",", "\[Phi]", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->362843514],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"ArcTanh", "[", 
       RowBox[{
        SqrtBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", "n"}]], " ", 
        RowBox[{"Tan", "[", "\[Phi]", "]"}]}], "]"}], 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", "n"}]]], "+", 
     FractionBox[
      RowBox[{"\[Pi]", " ", 
       RowBox[{"Round", "[", 
        FractionBox[
         RowBox[{"Re", "[", "\[Phi]", "]"}], "\[Pi]"], "]"}]}], 
      SqrtBox[
       RowBox[{"1", "-", "n"}]]]}], ")"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["\[Phi]", 
        RowBox[{"2", " ", "n"}]]}], "+", 
      FractionBox[
       RowBox[{"ArcTanh", "[", 
        RowBox[{
         SqrtBox[
          RowBox[{
           RowBox[{"-", "1"}], "+", "n"}]], " ", 
         RowBox[{"Tan", "[", "\[Phi]", "]"}]}], "]"}], 
       RowBox[{"2", " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", "n"}]], " ", "n"}]], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["\[Pi]", 
           RowBox[{"4", " ", "n"}]]}], "+", 
         FractionBox["\[Pi]", 
          RowBox[{"4", " ", 
           SqrtBox[
            RowBox[{"1", "-", "n"}]], " ", "n"}]]}], ")"}], " ", 
       RowBox[{"Round", "[", 
        FractionBox[
         RowBox[{"Re", "[", "\[Phi]", "]"}], "\[Pi]"], "]"}]}]}], ")"}], " ", 
    "m"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "2"],
    SeriesData[$CellContext`m, 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 
   0, {(-1 + $CellContext`n)^Rational[-1, 2] 
     ArcTanh[(-1 + $CellContext`n)^Rational[1, 2] 
       Tan[$CellContext`\[Phi]]] + (1 - $CellContext`n)^Rational[-1, 2] Pi 
     Round[Pi^(-1) Re[$CellContext`\[Phi]]], 
    Rational[-1, 2] $CellContext`n^(-1) $CellContext`\[Phi] + 
    Rational[1, 2] (-1 + $CellContext`n)^Rational[-1, 2] $CellContext`n^(-1) 
     ArcTanh[(-1 + $CellContext`n)^Rational[1, 2] Tan[$CellContext`\[Phi]]] + 
    2 (Rational[-1, 4] $CellContext`n^(-1) Pi + 
      Rational[1, 4] (1 - $CellContext`n)^Rational[-1, 2] $CellContext`n^(-1) 
       Pi) Round[Pi^(-1) Re[$CellContext`\[Phi]]]}, 0, 2, 1],
  Editable->False]], "Output",
 ImageSize->{523, 96},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->105825228]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"EllipticPi", "[", 
    RowBox[{"n", ",", "\[Phi]", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->387924925],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[Phi]", "+", 
   RowBox[{
    FractionBox["7", "6"], " ", 
    RowBox[{"(", 
     RowBox[{"m", "+", 
      RowBox[{"2", " ", "n"}]}], ")"}], " ", 
    SuperscriptBox["\[Phi]", "3"]}], "+", 
   RowBox[{
    FractionBox["31", "120"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", "m"}], "+", 
      RowBox[{"9", " ", 
       SuperscriptBox["m", "2"]}], "-", 
      RowBox[{"8", " ", "n"}], "+", 
      RowBox[{"12", " ", "m", " ", "n"}], "+", 
      RowBox[{"24", " ", 
       SuperscriptBox["n", "2"]}]}], ")"}], " ", 
    SuperscriptBox["\[Phi]", "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Phi]", "]"}], "6"],
    SeriesData[$CellContext`\[Phi], 0, {}, 1, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Phi], 0, {
   1, 0, Rational[7, 6] ($CellContext`m + 2 $CellContext`n), 0, 
    Rational[31, 120] ((-4) $CellContext`m + 9 $CellContext`m^2 - 
     8 $CellContext`n + 12 $CellContext`m $CellContext`n + 
     24 $CellContext`n^2)}, 1, 6, 1],
  Editable->False]], "Output",
 ImageSize->{399, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->298966122]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20862],

Cell["Evaluate numerically:", "ExampleText",
 CellID->233643202],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticPi", "[", 
  RowBox[{
   RowBox[{"1", "/", "3"}], ",", 
   RowBox[{"Pi", "/", "5"}], ",", "0.3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->92754591],

Cell[BoxData["0.6687348074653343`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->89826]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24675135],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->40712917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticPi", "[", 
  RowBox[{
   RowBox[{"-", "2"}], ",", 
   RowBox[{"1", "-", 
    RowBox[{"2.", "I"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->273099337],

Cell[BoxData[
 RowBox[{"0.7840492266613482`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.25841451619365335`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->96523508]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticPi", "[", 
  RowBox[{
   RowBox[{"-", "1"}], ",", 
   RowBox[{"2.5", "+", "I"}], ",", 
   RowBox[{
    RowBox[{"1", "/", "3"}], "-", "I"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10049987],

Cell[BoxData[
 RowBox[{"1.4237821081510151`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.1021692037960592`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->109525354]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->661329943],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->359817788],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"EllipticPi", "[", 
    RowBox[{
     RowBox[{"3", "/", "10"}], ",", 
     RowBox[{"4", "/", "10"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->92760374],

Cell[BoxData["2.\
1487954158664566359360227863754503502433007322701144202385126513946`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->225588192]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"EllipticPi", "[", 
    RowBox[{
     RowBox[{"3", "/", "10"}], ",", "2", ",", 
     RowBox[{"4", "/", "10"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->162410687],

Cell[BoxData["2.\
9069282158995094765661591577858774162815622496101746900209238288051`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->420764978]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->165557200],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->628991026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticPi", "[", 
  RowBox[{"1", ",", "2", ",", "0.999999999999999999990000000000"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->341879449],

Cell[BoxData[
 RowBox[{"-", "1.99999999999999999979`9.956681393357238*^20"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->326290603]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->104554776],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->3699197],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticPi", "[", 
  RowBox[{"0", ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->350129947],

Cell[BoxData[
 RowBox[{"EllipticK", "[", "m", "]"}]], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->209810230]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticPi", "[", 
  RowBox[{"n", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->49881015],

Cell[BoxData[
 FractionBox["\[Pi]", 
  RowBox[{"2", " ", 
   SqrtBox[
    RowBox[{"1", "-", "n"}]]}]]], "Output",
 ImageSize->{62, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->94721167]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticPi", "[", 
  RowBox[{"n", ",", "0", ",", "m"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->321616007],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->341218905]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticPi", "[", 
  RowBox[{"n", ",", "z", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->82429615],

Cell[BoxData[
 FractionBox[
  RowBox[{"ArcTanh", "[", 
   RowBox[{
    SqrtBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", "n"}]], " ", 
    RowBox[{"Tan", "[", "z", "]"}]}], "]"}], 
  SqrtBox[
   RowBox[{
    RowBox[{"-", "1"}], "+", "n"}]]]], "Output",
 ImageSize->{168, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->551329709]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->895189039],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticPi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticPi"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->232871448],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticPi", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.2", ",", "0.5", ",", "1.8"}], "}"}], ",", 
   RowBox[{"1", "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38848777],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.0929565827318743`", ",", "2.7012877620953506`", ",", 
   RowBox[{
    RowBox[{"-", "0.3584311427313618`"}], "-", 
    RowBox[{"2.0665192726702326`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{275, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->65760391]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->438156456],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->441495560],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"EllipticPi", "[", 
   RowBox[{"n", ",", "m"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->92836248],

Cell[BoxData[
 FormBox[
  RowBox[{"\[CapitalPi]", "(", 
   RowBox[{"n", "\[VerticalSeparator]", "m"}], ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->473263758]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"EllipticPi", "[", 
   RowBox[{"n", ",", "\[Phi]", ",", "m"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->211826760],

Cell[BoxData[
 FormBox[
  RowBox[{"\[CapitalPi]", "(", 
   RowBox[{"n", ";", 
    RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}]}], ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TraditionalForm=",
 CellID->15749304]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12480],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticPi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticPi"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->555511551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticPi", "[", 
  RowBox[{"n", ",", 
   RowBox[{
    RowBox[{"Exp", "[", "\[Phi]", "]"}], "-", "1", "+", 
    RowBox[{
     RowBox[{"O", "[", "\[Phi]", "]"}], "^", "5"}]}], ",", "m"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->55809021],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[Phi]", "+", 
   FractionBox[
    SuperscriptBox["\[Phi]", "2"], "2"], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", "6"], "+", 
      FractionBox["m", "2"], "+", "n", "+", 
      RowBox[{
       FractionBox["2", "3"], " ", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"2", " ", "n"}]}], ")"}]}]}], ")"}], " ", 
    SuperscriptBox["\[Phi]", "3"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", "24"], "+", "m", "+", 
      RowBox[{"2", " ", "n"}], "+", 
      RowBox[{
       FractionBox["3", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"2", " ", "n"}]}], ")"}]}]}], ")"}], " ", 
    SuperscriptBox["\[Phi]", "4"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Phi]", "]"}], "5"],
    SeriesData[$CellContext`\[Phi], 0, {}, 1, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Phi], 0, {1, 
    Rational[1, 2], Rational[1, 6] + 
    Rational[1, 2] $CellContext`m + $CellContext`n + 
    Rational[2, 3] ($CellContext`m + 2 $CellContext`n), 
    Rational[1, 24] + $CellContext`m + 2 $CellContext`n + 
    Rational[3, 4] ($CellContext`m + 2 $CellContext`n)}, 1, 5, 1],
  Editable->False]], "Output",
 ImageSize->{448, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->181158843]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22811],

Cell["Carry out an elliptic integral:", "ExampleText",
 CellID->13377438],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", 
     SqrtBox[
      RowBox[{
       RowBox[{"x", "^", "3"}], "+", 
       RowBox[{"2", " ", "x"}], "-", "3"}]]}]], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->867456692],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"4", " ", 
     SqrtBox["2"], " ", 
     SqrtBox[
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "x"}], ")"}]}], 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", "\[ImaginaryI]"}], "+", 
        SqrtBox["11"]}]]], " ", 
     SqrtBox[
      RowBox[{"3", "+", "x", "+", 
       SuperscriptBox["x", "2"]}]], " ", 
     RowBox[{"EllipticPi", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"2", " ", 
         SqrtBox["11"]}], 
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], "+", 
         SqrtBox["11"]}]], ",", 
       RowBox[{"ArcSin", "[", 
        FractionBox[
         SqrtBox[
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], "+", 
           SqrtBox["11"], "-", 
           RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]}]], 
         RowBox[{
          SqrtBox["2"], " ", 
          SuperscriptBox["11", 
           RowBox[{"1", "/", "4"}]]}]], "]"}], ",", 
       FractionBox[
        RowBox[{"2", " ", 
         SqrtBox["11"]}], 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", "\[ImaginaryI]"}], "+", 
         SqrtBox["11"]}]]}], "]"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], "+", 
       SqrtBox["11"]}], ")"}], " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "3"}], "+", 
       RowBox[{"2", " ", "x"}], "+", 
       SuperscriptBox["x", "3"]}]]}], ")"}]}]}]], "Output",
 ImageSize->{512, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->807221849]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->96132111],

Cell[TextData[{
 "Definition of the solid angle subtended by a disk (for instance a detector, \
a road sign) at the origin in the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ",",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 "\[Hyphen]plane from a point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"\[Rho]", ",", "0", ",", "h"}], "}"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->817085670],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalOmega]Int", "[", 
   RowBox[{"R_", ",", "\[Rho]_", ",", "h_"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"ray", "=", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Rho]", ",", "0", ",", "h"}], "}"}], "-", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"r", " ", 
          RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}]}], ",", 
         RowBox[{"r", " ", 
          RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}], ",", "0"}], "}"}]}]}], 
     "}"}], ",", 
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           FractionBox["ray", 
            RowBox[{"Norm", "[", "ray", "]"}]], ")"}], ".", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], 
         RowBox[{"ray", ".", "ray"}]], "r"}], " ", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"r", ",", "0", ",", "R"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[CurlyPhi]", ",", "0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->344534690],

Cell["Closed form result for the solid angle:", "ExampleText",
 CellID->374784375],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"\[CapitalOmega]", "[", 
     RowBox[{"R_", ",", "\[Rho]_", ",", "h_"}], "]"}], " ", "=", " ", 
    RowBox[{"Piecewise", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"2", "\[Pi]", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            FractionBox["h", 
             SqrtBox[
              RowBox[{
               SuperscriptBox["h", "2"], "+", 
               SuperscriptBox["R", "2"]}]]]}], ")"}]}], ",", 
         RowBox[{"\[Rho]", "==", "0"}]}], "}"}], ",", " ", "\n", "     ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"2", 
          SqrtBox[
           FractionBox[
            SuperscriptBox["h", "2"], 
            RowBox[{
             SuperscriptBox["h", "2"], "+", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"R", "+", "\[Rho]"}], ")"}], "2"]}]]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"EllipticK", "[", 
              FractionBox[
               RowBox[{"4", "R", " ", "\[Rho]"}], 
               RowBox[{
                SuperscriptBox["h", "2"], "+", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"R", "+", "\[Rho]"}], ")"}], "2"]}]], "]"}]}], "+", 
            
            RowBox[{
             SqrtBox[
              RowBox[{"1", "-", 
               FractionBox[
                RowBox[{"4", "R", " ", "\[Rho]"}], 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"R", "+", "\[Rho]"}], ")"}], "2"]]}]], " ", 
             RowBox[{"EllipticPi", "[", 
              RowBox[{
               FractionBox[
                RowBox[{"4", "R", " ", "\[Rho]"}], 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"R", "+", "\[Rho]"}], ")"}], "2"]], ",", 
               FractionBox[
                RowBox[{"4", "R", " ", "\[Rho]"}], 
                RowBox[{
                 SuperscriptBox["h", "2"], "+", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"R", "+", "\[Rho]"}], ")"}], "2"]}]]}], "]"}]}]}], 
           ")"}]}], ",", 
         RowBox[{"R", "<", "\[Rho]"}]}], "}"}], ",", " ", "\n", "     ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\[Pi]", "-", 
          RowBox[{"2", 
           SqrtBox[
            FractionBox[
             SuperscriptBox["h", "2"], 
             RowBox[{
              SuperscriptBox["h", "2"], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["R", "2"]}]}]]], " ", 
           RowBox[{"EllipticK", "[", 
            FractionBox[
             RowBox[{"4", 
              SuperscriptBox["R", "2"]}], 
             RowBox[{
              SuperscriptBox["h", "2"], "+", 
              RowBox[{"4", 
               SuperscriptBox["R", "2"]}]}]], "]"}]}]}], ",", " ", 
         RowBox[{"R", " ", "==", " ", "\[Rho]"}]}], "}"}], ",", " ", "\n", 
       "     ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"2", "\[Pi]", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{
             FractionBox["1", "\[Pi]"], 
             RowBox[{
              SqrtBox[
               FractionBox[
                SuperscriptBox["h", "2"], 
                RowBox[{
                 SuperscriptBox["h", "2"], "+", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"R", "+", "\[Rho]"}], ")"}], "2"]}]]], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"EllipticK", "[", 
                 FractionBox[
                  RowBox[{"4", "R", " ", "\[Rho]"}], 
                  RowBox[{
                   SuperscriptBox["h", "2"], "+", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"R", "+", "\[Rho]"}], ")"}], "2"]}]], "]"}], "+", 
                
                RowBox[{
                 SqrtBox[
                  RowBox[{"1", "-", 
                   FractionBox[
                    RowBox[{"4", "R", " ", "\[Rho]"}], 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"R", "+", "\[Rho]"}], ")"}], "2"]]}]], " ", 
                 RowBox[{"EllipticPi", "[", 
                  RowBox[{
                   FractionBox[
                    RowBox[{"4", "R", " ", "\[Rho]"}], 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"R", "+", "\[Rho]"}], ")"}], "2"]], ",", 
                   FractionBox[
                    RowBox[{"4", "R", " ", "\[Rho]"}], 
                    RowBox[{
                    SuperscriptBox["h", "2"], "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"R", "+", "\[Rho]"}], ")"}], "2"]}]]}], "]"}]}]}],
                ")"}]}]}]}], ")"}]}], ",", 
         RowBox[{"R", ">", "\[Rho]"}]}], "}"}]}], "}"}], "]"}]}], ";"}], 
  " "}]], "Input",
 CellLabel->"In[2]:=",
 CellID->308217535],

Cell["Numerical comparison:", "ExampleText",
 CellID->280713378],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"R", "=", "1"}], "}"}], ",", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Rho]", "=", "2.3"}], ",", 
       RowBox[{"h", "=", "3.4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[CapitalOmega]Int", "[", 
        RowBox[{"R", ",", "\[Rho]", ",", "h"}], "]"}], ",", 
       RowBox[{"\[CapitalOmega]", "[", 
        RowBox[{"R", ",", "\[Rho]", ",", "h"}], "]"}]}], "}"}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->159144135],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.1528142450073446`", ",", "0.15281424537408445`"}], 
  "}"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->100695930]
}, Open  ]],

Cell["\<\
Plot the solid angle as a function of horizontal distance and height:\
\>", "ExampleText",
 CellID->138140112],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"\[CapitalOmega]", "[", 
    RowBox[{"1", ",", "\[Rho]", ",", "h"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Rho]", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"h", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->87455621],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytfQd4bGd55nBmpHuNjY0xmBIbSCGNzQYCKaQtbBJCCrtAQngoCXGIk8Au
JGsIfTHGBfuCfbF9r4vutW/XVRmNeu+99zKapinSaKRRGXWNpHmf3e/7/v+M
5h7pGsiunl//nDbn/N/7fu0vR/rwfV/5l/u/eN9XPv+5+97+pw/c92//8vnP
ffntH/zXB+iQ/VU2m62Cfp99k422/w9tyW8FADqRUX+Najud+l3Z+ybXvAv5
sf32Kxz9OtVG+pvfsFzzO6/wTfOZJ/Ud3iVHH+LacXitzfbr/6Hj3zly3LC0
4tfk8Ld0K2yO+++/X5286bXf0C3ls3xrm11dbUu3/qv6bo6Mp6v7vkfOf1mf
z0rfgc7qm/yGfH5Un7kn41mZLZG2Zl0bxrURLrTD97depTD4WMZR/tqbM57O
97bTbQy6iZFLN3KolqhL3y0ff2W56936e1lpzOgG9EF17jCy+C5Z6bvoZypc
/tpyp9dZWkISDfE9VOED2Xy3E7mjyKRF3/PXj73nay2tM3KH4OC72XMFp+tU
G1TZr49CcNfMHc/1R4/ozx0Z3Jr3l+/lStNt9uuEJj/Erh7GjzGoMkye+YCp
NBnP+09prvjK22/CuxzLHaTW66fS06jQE9RTjbwR1d68Ua2SBm8xq3ljoHLM
k98pT/6sRS4SZADXB7nQ3elpWXlDyBvmwrcf5gMjcqWdn2Cne6uH0BPHLJgp
LD9zhO3r/eCHDMgdB/kmQyQBg5g/jHyhy2bkq6cY+aOq1fSZz0/hKpseSZ+q
qCfyJQrLTx3R07x+5A3oYsgD+X5DoEL3G4ZdP8tRQHzxHbP4vHl/1hU7H7Xn
j5tqaOXnV+TJnzgiaV6vyNiPfCoD/LRBeoLmsGAIBcwhV/aCEdOXiG1SS7IK
dEvos0CaUTCuALYyqZ7+cSuT2fT0fCp9fGdqQAFJX0DPLyS0C4fVHeizcETp
l6NQI104hkKmkqvsAgGYnkxFWY2Dm5GVfrq2yl9N67Fdt1A8XFZ+N/J7UNAr
pY+l7VffLhxA4SCoLU6Gwzms2u4kBpxjN7TDoMpeOH7op2lbFYNbYi+YuBkr
vyRt+kiGPggrJ/I7UNDJXyrsRmEPCvvg5JY5uWXOATgH+Rw1q4j1o2hYJLEX
jcJRxC1zCiJOfjRVYpmyo5xxIbUmiyuL9SqO3qXxeUtaN9OuzTxyS0EbCtpR
2IHCLji7+WxRL4r64KLmGS5SIrtrEK4hZSWuYWmBw6W5c43BxZhRZS/SrSoa
h6lXtpPUVOeELizGBLNKtbT5CKu/LJ/vtuD6RquF3epsgbMNznY4O+DsRFEX
iqTlrj4U96OYNb+E7a5kCCXDh61xlIygZJRLMfFerP0HfXIZh8Ol8XVR+4oY
U9VosUinCbT86A2rZbzj2Pa/3moptxfWwdkIVzPfpLgdxZ0o7kJxN4p7UEJF
rLhkAKVkPaVDSoscZWKxZaMoHYW9dAxGCWtHiYDNtVGsdNYo1tpAUlARaexF
E2mNcU6qTUM2Cidvps3Hy3Kn1efcWVAOZxWKauGqR0kTSlulmZ0o60JZN8p6
UNaLsj6U96NcPHD5kI4v5RRHykeVFpSNQRdWolJ2PKUm1oxzCbefBCueVGzS
Z5aL2180qd0EWQ4dY5mOaJWpN289VqI7rNp1u9MlvFSipAYldShtRHkLKtpQ
2cHHK7tR2YvKPlT2w6gkkbIqB3VLq0ZQyd6tkmNhxSgqxrhw+8tZrPIJlElR
2mgvm0SpFJtBlb1EE0OysZgso4qQSkASz+agyjAJzLD2bItM9x4r6W1WPbyz
4DKc1+FyoqREqKlGRR0qG1DVjKpWVHegRvxWTS9q+lDTj5oBMyesEW2sGUU1
FfYAVWxNVeOoFIWk2qiYUPpYPqnsjD7LpNhJWqNkSh3lT5vidIp9zVSaT9o0
ivhXy3wsr0elfpfm8zYrr3fmvwDnyyi5htJ8lLtQWYaqKpGiAbXNqGtFfTvq
u1DfjfoePl7frzW1nqNX/QjqVLZj1JL11bCO1kygWkqVlrWS21k5hQqzyPXl
JEXZFMk9pTJhkllJS6K69DX0aS+a0vmbc+pmVmndVzL/npXZ1119NJn35AFr
0zmUXULldVQVoqYEdRWor+GbNzahsRVN7WjqRHM3mnrR1KeefkvTEJqG0TjC
pWEUDWOoFy2uZy9TNwGjlhmtmTy0T6OaWl5Fv5UslRKba5bcdqJs6vDKUtku
dbOHdist4Cye0CiWMwyHRPSiqWMYdxwr/ftMX2RPRzfBSY7ddf6LC5e/tpb7
4HbB9/eKf5Qqe14ov4q6fDQUobEMzVVoqUNrIx9vbUdbJ9p60NarrTS7Vay7
dQQto2imQtw3cabSOI5GcVENk6inornLqptCrZuPU13DclaTnFX0W+lWElW4
NRzltOEocyuJCBITFdGLYjeK3TpT0rpxFA9r/FF4/JZVG+564TNT9HH1f83n
f3O16OHt0h/sVT2bqs3hezTloqUQrSVor0RHDToa0ClhqbMTXd0ag5Odg+gc
QscwOsTs28fQNo5WsvEWQsDRPIFmUYYmhYHRwJLWu1E/jbppgYJqo2YaRjX9
Vk1rpCqnUSGlnArLylhkp7GgQmAQFIrbYoGNa7uLgSNQisySlcE+/7xNNt8L
Syb2+h98oPaZv2x78RMDF+6boP3Cr0RLvrNS8dhWzVPJhudSzedTrVf4Fl0u
dJejpxq99ehtQm8reju0bfQNoHcQvUPoGUH3KLrFMDon0MFevZ08VRsrcGta
441mEt3RNI1GKQ0kO6EinBE0aVyk/VWCVSUfo8ogYIxyvrZMjnOtNJIgKRFs
SpSOsO90Q1CxF7kZj+N04+3pmCCeKuOstJOrNzz6m7k//L3iZz9Yk/ORtkuf
7r9+P6NU/vW56oeW6k9tND+TbH/xoPPiQU9uio73l2KgCkN1GGrCUCuGOnT7
XjPUj8FBDAxjYAT9o+gbR98EekVDuqfQNYVONzrcpm61T6PNIybmQYsHzR40
edDogdHgUS2s96RbaNTQ8WqP0pIqDyqlVHigsVJ6RUiVTrPiUF0yrW3KoZRH
FYOwUpgXuW/maZUOmf38e626dPc33vXkd99zhrae/N3cZz9QfO7Pqy9/vDX/
7/uKPz/O5H57tunReNuT613P7fa+tDdwZX8on93xaAXGajHeiPFWdZ/XjPdi
TBKjkWEMj2J4DEPjGJzA4BQG3OiX9vWY3N/S5UGnl0uHl0+0edHqRYsXzbRr
NFHlaPRq3av3wqijnRO1XtSYpVrOEnSkY1RlVXhMZ6RRZjWzK+xKebNEa6tS
NMUCo1fkPsYfKR3jjOrGnjmPBfEByVPeQRvffNdjD77nye//zlnaPvOHuTkf
LL78keqCT7WU/mNf9ZfGGr/mZSt8YrH36bXBF3dHLiZHc/fGnQeTZax37gZM
t/Bdp7vh7oV7AFPSO5kYw9g4xiYwOomRKYxMY2gagx6N3G19XvR60ePj0u1D
lw8dPoHQh1YfWnxo9inv1ehTra/3gUodHSUADcJOcFAAKhwIPINx46vLPKxx
hJ5BsBklpk0XT2uVs6Xt8yb69tabYHe3tthX8+7raeOh3/j+Y7/11Ok/YOzO
/9H1y39RnP/x6rLPttR+vrfpgdGOb3vo+OBTCyNnExMvbU9eSbrz96aL972V
BxIL3uLvgr8XvgH4huAdhUfytalJTE5hwo1xD8a8GBUhhwWfAT/6/ejzo9eP
Hj+6/ejyo9MvccCvvWKLH81SmuR4ox8Nfg0eZUuMZ41P6xnhZ1SxVlZ6UeEV
2/VAKZ+MLRKOKustEa9XzOpH1Y9D796boPd6ba+vMdH7/nsff/J9p89+gNG7
+qHr+R8pLvlUde0/trR8safzayP9351mTXom5s5Z9V7a8l3fCxTtz5QfBGtS
SovCXQj3ItSP4BBmRjEzDr84No8b09NwezGltMh265gfowGBMYDBAAYC6Aug
N4CeALoD6AqYvYD2ANoCaOX9FqpONAfQFMhA0a9QFO+nNbPaB4KQikEgGhWM
poZPfgjCUo9Yr5G2XlJD3ufK4ZqGy8xBrBnVPTfB0ez3yZm308ZTv/34s39w
+vyfPEfbhR++Xvo3xdWfrWr5fHP3A90D3xoee9RNx73PzQdeXgld2ww792ZL
9+eq2QPOt7IRz/cg2o+5IcyOIjKO8BRCbswI5T4TwekApmYwOYPxGYwFBcog
BoMYCKI/iL4ZjWBW94wE4Rm0z6CNj7ZSlUVgHkJpop1V50etFK2QRjVjWiWA
Ko1UvW0Ck5SyTIqd0BQkHWkki037PsTSGm9vhqTZ3+RRads7aePs+57I+cCP
rvwZI1n+ses1ny5u+seq7i81D36te/y7Q9NPTAWemaFTs5eX5vM3YiXJxSqG
Md6SWupILUpHZXEICyOIjWN+CtFpzHoR8SEkphiYgT8IbxCeINwhTIYwEcJY
SMAMYTBkxpW+EHpD6AmhW4DuDKI9iLYgGEqjhSp780w6p2kgOLNZMdNgyrME
S3uVL30da6a93MuOsZzjk8aSbNuTvoarbILTZRZl41Y0f+aGaPwaHU/uEtOn
jXO/f+rSn/yo4MPPV/zVBdpt/vvizs9XDX25eeLbXZ7HhoKnp2afDzBQufGl
ovWVil3aTjSlEu2plZ7Ucj8/cGUUyxNYmkLcgwUfYn7d031jKISZMAJh+MLw
hOEOYyqCiQh/ZzTM9VAYA2H0h9EXRm8YPXKwK4SOkIlh0LR1hWEjY8oYZtUH
UBfIwFB5PkKwUopCMEvBV6YKx7NS5SMd4henj8zYKM0zMxaOH7ZfoY0fvP+h
y+8/df3Pni756PP1n2CYuu8vHvjXqsmvN3m/1xX6wdDcs5OL5/wMTcHiemmC
NrYaD7baUutdqUR/KiFBdn0Ca24kvFjxY0lsayGI+RDmROpQBDMRBGbhm4Vn
FtOzmJrVst86OovhCIYiGIxgIIK+yCFYnQKWzgcJrZYgmqmYYDXMgIAy6hix
2sBhX7Laz+MOPo4lPlRIUT5QoaXQdBBYJVJsKhyz+zuauSjMzHHSN/Hee2nj
mT/+Xt4f/8D14aerP/5C66cZs6EvuMa/UuX7TlP4+13zpwcXX5hYvehjqIoX
qd6t39pt3dvpTG31pTaGUhtj2JLwsOXFhh9rItFyGPEIFmcRm+XdyBxCc5iZ
g38Ovig8UYnHc5iYExWbw/AchmYxOIv+WUEtgp6I9pAdYbSH0BZCa0iD1hTM
AM30kA5CTZkoQWZU0S8rl13hJZbJlkiQGeLpdN5d7EGxR8eMLNe0xr1o+lhv
92bB701a58Raf5E2cj70cPGHflD50aebPvlCz2cv0pHJf3N5v1EZebgp9sPO
pTMDifPjW1e9u84wndqvXdlr3kx2JJO9qZ3B1NZoansSu/K8nQC2RLL1CBKz
WJnDUhQLUczPC4TzCM1jZl6h8mrPPNzzmJRTY1GMRDE0h8E5DAiESiu6IugM
g/BrC8Mg9Gz2lhDjJ7JJReixbXLkqAmoCEvoVUmp9KXzFbk2bZ5km2yxmTpX
rOE0xFIVfAKeBUHROdsbtAZKPnM7bVz6y4er/vKH9R9/puNvXxz+HCMY+HdX
5DuVC483rvyoY+3F/q1LY8l8j/LiB43L++0bez27+wMHyZHU7iSS09jzYs+M
fye3Z7E5h/UoEvNYmUc8hoUFzC8oVF4dWIB/Ad4YpmNwxzSEo/MCYVSj2zeH
3ln0iO52RtARQbug2BoGQajQbQyiIcj6VzdD2TPZLiNoVwjKaLpUpH/lKljY
Rfe8onsyQkag2S14WTM+hdddOhK81cQr/8OPNHzkh22ffKb/vhcn//kSa8c3
XYuPVK4+2bhxtmP75f693NFU0bTCK9W6dNC1ftC/fTC8tz+R2p/GgRcHARyY
3uh1ySh25rEZw/oCVhewvIj4ImKL3KjZRYQXEVxEYBG+RXgXML2AqRgmYhrN
wSgGouifA0HWM4duE7L2iGidXMNaF0KTBGSGzEStdgaEGePE9mqzV/pN92aU
6yxQaRyhpvPltLYZonIujw6oNqPoOI+nLDZbW6xVG284ppcNSI/412i/5L8/
2v7XT/b+3bNj9+dM/0/GeOFB1+oTlRtPN+zktO9f7kPBKN+qZgbNc7SR6kuk
hrdS48mU+yDlRSqAlAicEhe3H8PuArYXsbmItThWl7C8xMdjUkeWEIpjJo5A
nFH2LMK9gMkFU59HYhiax8A8+qPoi6JXkO6a0zOSbRFRy/AhxgaBbLuFYL7f
/KGDNRJUqgJs2tQv9vPovfKNoqFivWzXjhIvG3WxR425kK66PCqfTsckaz4t
0VeNVN+QBTqOHEmPWNoP10bca+aINR99rPcTTw3/w7PTn8/x/hsjvvKIa+PJ
ys3nGnZfbk9d7+M7VblBWUXbLG8PJTC2ialdeA8QAEy4U/NILfD2Xhw7S9ha
wsYyEst8JL6MhWXMy3Z4GcElBJbgi8MbN3PECVH70RiGYxhUoM+jN4qeaHqc
cBbts2DUI4J6GE1hNIaUHgsjrNei2tUm5oK3vcKfHvcXGMt8WrnFK7BPTQNP
tcvs1TP2RVKO0WFzVviOn4qDjCPUIvErb6MjLR/7/sinnpr6pzPBL57z/zsz
sPGEa/OZyq1zDckrbXD28rfqpkBdYTLx/gXendyEZweBfYS4y5OKIhVDahGp
uKj9MpIr2F7Rkty7soqlVSyuYn4Vcyt8RXAZgWX4xQym45iKgxgYFxKGFzAY
0wz0iZfujrLa00aHcMAERJgAm0FS6IgWRF2QPQtFNO4hEQVVwkJlAEyC6iEp
tS8Tx8y13WTAUew51HPR/Kw0+jfJCjL3bf8vTLBtUMMkS/tllvavH5/67Gn/
F85EHjgX+gazkXzKtflcxc6F+v28Nv5a9TCaJnmIh7LMoRgf8WzAv4PQ3g1U
LCG1jJTAvZfgejOBtQRWE1hOYDGBWAJzq5LaruixDu8yppcwtYTJOMbjGBU+
hhYwEDPHZ3vmwWxE0SmEEBuH+t8YRoMYoyYjCOHCXj2jLUKPLBEdWeViE2Um
GcKELbvEHN9LWwO7egmUln6AdX7s9ldCPyvziBkB1B0O/ZHEjHfTicFPPOH5
3OnZL52NfvXc3HcY/71nXdvnKnav1h8UCf71Q2idQLcXA9TfpIRsmQ8Gt7mO
7mMhRUbA4K8gtYpUAgdrkuatYXMd6+tIrGF5DfE1xNYQTSAi1Myswr8Cxn9Z
8F8S/OMYWTR1tz/G1sD4zzP+Ks94TdusRkz7ozQFIU2BckoCiu0WZQxEAMFf
7tMM0IlSnzn3SQwUe1Fs+iMJtZSpeEwrOC6eWuPCa35qLrItXEj+8zo6MfaZ
J/z/fHrhgbOxb51bfFi4eL5o90LFXl49f72mB82D6BxHvwcjQUxGyaOrmXtE
k4jtIX6ApZQmYg0H62ILG9Jr2cDGBhIbWFlHfB2xddPPh4UP/yq8K5heIXIx
uYzxJZ2JDC6Q/0NfTON/e2cUHXOagtZZ8UsRk4gw6oULbQuMHpmCUaUzbiKj
wiRDM6H8PrFB1lAixSjmzp4iQyKDS2WRkvfYnTfNIK0cKU7MjMj8tM6UWHl4
o8nD9H1PBP/H6fhXzy4+eG7lceZh/3xR8mrFQZHw0NCNtgH0jPOo9PgMpuco
oxFZ3orYDuJ7WNrHygGZApGQEhL2N5Dc5I3tTWxsIrGJlQ3EhZnoOmbXEV5D
UJjwrgoNK0wDa8QSRuIYjkPl2T0xsYf59IyLkMFMzAoTEc2EQVSorJSoqAmC
fdIMqmZQKZ6pIqCJSMcJoqNU2QYTUCIsiGG4dJ/Hlq2sQhXnYZR+xbWyigcH
jmampnWZ505auODek+0uOtHwDw8F7j8V+dfTK986u/zIuY0nL+GF6wxpXjnf
qbYFzV3oGsDAGEaneZTRN0uZvMLnTVjcwVISK3tI7GM9lRLEDzaxt4XkFna3
eHdjC4ktLAs9sQ1ENxBZR2gdM2vwCyXTqwqnk+PLh7nmoASLvgUQJQrpznl0
RNEeRZuQYmVEdL1OLERxwtZhsytOKgPmGAeRUubnMMFxxnRUyjhsbB1G2k1p
CyFa2DoM541Rw9R3/nyt4H2UrRM3eijNyqstTPC4u+1n6UT7Pz0U+cKp6FdO
Jx48u/p4zs4zl3CemTgoEiYamnnCvbefp74m3PAEEJD8NbqCxQ3eWEkKCwcQ
FlJbONjG/jaS29jZxua2RuDE4ibmNzFHNGyYNKzpXgzbQNboEoaXMBTHQBz9
Zrx4dXeMzaJjXgiIonUOLUJD0yxzoOJ9vbioTA6qg9ouBBiDLaKM47XCX1lE
iTn+lEXwu5RF3Ii96ZlMnbZawZ0/Ff63WvCXkdG30In+L3xv7kunFr5+ev2R
s2tP5hw8fwkXc/nbpYJ/czM6OzHQj7FRuN3w+RGK8PHYMnv8lR3eJvA3U9JC
gjsrtYP9HSR3sL2DzR2N5ImlbSxsCQWbTEFwA4F17f9PTK5iYgVjyxhZZhIG
hQSFzklioPMIA82zGvvGiESIMOrCzECtkKAY0LlWpVhChRTaN7mwl/lu7E/o
mC3Fbrondk7m6IzzuD7yXa/EgcVubrMwIOP7J+nE+Jcennvg1NK3T288fnbz
6Rycv4iruWruFw01aG/i1QXDfZgcgWcKMzwAi/kYFpc5BVrdxvqekuEOgh87
XFK72NvF7i62drk1iR0iijcWthHdwuwmwpsq77ed9K3Dswa3uKTxVYyuMAlD
S+ZqhkX0LqJHeoSdsRto0NrbOIuGDBJsBnNgrwmmNZfN4CYspGdSSnwoEavg
8EB9NtMiijzmLLyHg4PTNIojPLzuJjyk3y1AxixfBgdiQ2+kE94HHp7791Or
3/3R1pNnt5/LwcWLyM9FqZNv1lKDriYMdGCsD+4R+Cf54FwYC/NYWsLqGta2
sKE5uI0J2GUC9neRTGInyc1Y30ViF8s7HDhMj8PMBzZA+E+vYSqBCaFgVPci
Tg4uoT+Ovjjj323i3z6v1+SyDcyhSfJWgr8+ouGvNcelsqqFgSoVnrlHR8gb
5QE9VsEjRCViARm4n3CZPQel+rrOYsQdhWaWpJG8mfex9imOjd0ZDEgU+Tk6
H/nqI9FvnFp/5Ec7T59N5uTg6kU4c1EpDLTX8DKb4XZM9sI7jKAwMB9CPIqV
JSQSWN/iI9sH2JGONKGfxF4Su4L+RhJru1jZPexl3RncRGATvg141uFew2QC
4wmMST9uaBmE/cCSYB9Hj8DfaY4n3dI2j9YoWqKCv1DQKCwQBcpP1FCOxOCz
jlYK9hUzovbSezhBal/q56woDb+ovE31mI2iQ89jarvddrS3oPrJZpZzAoeZ
qGHTvegMjO8wPc3iNx5d+N+nNp84nTx7NnUhB3kXUZKrfUdXNQYaMdaO6V74
h/lRUS8WQjyOvhrnLu+GYLyzj92U9pkEcnJP+sRJnUku7GB+J52F2bJnNuHf
hHcD0+uYWmMdV9o9LB3qgWX0C849cXQvokuPMp+wYMwuxpwlOslKLnpOOFeH
2NFXiaYbBLRgQDquPDztKKRtBiu54/AdG8baq0ZAtYdP4669jPiMwuM8jcp6
7kRGDpSBtPSg72GL/+ZjSw+d2n7q9H7OWVzJQeFFlEtUbSvlergRk+3wypjQ
7CRiXsSDWIny8OZGQlR5Bzt7qWTqIImDvbTPuHs1yYnn4i5i4thntxHexowk
nN5NTG/AvY5J6SmPJTCyCsJ5UDL+viVWZgJZodixgPYY2mRgiHGOCs5z2iOT
LtfJ/CUhzfpssxPSVQpplU+SPpdLKTuKtsrreYUiuXHxKMqfO4rMlRuEcKGU
m2B8R9q3WFeimbHU2lu28iBe5s10fufBx1YfO7X77OnUy2dxPQfFF1EtPHQK
D2ONcHfALzxEJ7DgxVIQq1Gsx/kIdW+3t1O7ewfJlO6psjehrH8Py0nEk1gQ
FuZ2mIXgNgJb8EnC795QSGaPr2E0geFVDK2AtX1ZIXCya5FdSpqFViGiWc+g
nCBtr5+FYqFWJkCZBKNa974cyqfQFtWs7zYH0aAdi4qqovEni8W58BriDBpM
FhxO8fBK4bNegQcr1sf3z/ipd1lYkIznbjqx+/Bj66dO7b9wGpfOoiAHZTxR
itZC9JRiqJq3vR1cR4YwP4G4F8tBJKLYEBa21wX7O/b22Ldv76U2xCCo98Wm
IB5+bheRHYQUA1vwbJpZ58Q6DilYxcAKU6B7BMzBoslBjDloMXvADjKFBvE6
xIPBtmDP4EF0mGyhMqgjq070lTmUBcz5FplQZSKMYvY/aSpcakZG8nwmQef5
pj1InDh8D8dm0+NyPxkPmVcwH5zlCQ+3MQ+PPbb11KnU+dO4egZFOagSHjoK
0V+KkWq4m1TugLlhLExiyYvVINajOl852N3ZSx4kk2kWUmt7KWJBvROhKAju
ILBtUmCzTW1gQkYqRtcwnNAMKA/Us4TuOLpkpJs5WBAOdK83qynK3oi2FAU2
4SC7NoKasE5RqsQjGcSBXfAvT68+4XFQ9kiEf4lew8P425U7kjCl0bc7PdLD
VW+GEfQFVNxc5C4WNG/9Ka3hbos1yFjEnXQi+uCDu6ce3X32FC6exvUzKM1B
rRDRXYjBUoxXw9OEQDsfmR/G4qTC/1ZsxrGdONjZ3N/dTSZ5ic+WsJDYSy3v
8fiQ0uu7w7sZNGyZNGxgfB2jEhqGEhiQVKdvGb3LICaIhs44OmTwoW1BM9Q8
D6JBMdEgZNTNskdS3qM6zOGXiVAssBWoHgEZQGlA+yK2AfFFsl7Al5EZKCqK
vEgnmvYMWxD8xSelKfn/xMobLaxIT+0O9icPf3f3yUf3nj+Fy6dReAYVL/LX
26+htxDDpZishreRj8z2Ss9Jzf5iI4qt+MF2Yn9nK7mbZE6SB+t7qVXhZFEc
VTSJ2STCEir8O/Bt69gwtWmyso7hNQzq3OhE34rJypJmpT09ft0SA9GimGnk
WbUGPZPpqBHbUKwYVSGFBvFSYfaE2UKUe2I0OE4wOVmcgJoLssRMOFY4ihQ7
ah7TqSKGUahXuKnYTcQ4CtzH93L/A77Kyku26bO2v//Q7tOPHpw/hWun4TqD
auGl6xoGCjFaCne1yjyxMIylSaz6dF84tbW0t72W3OGkdTN5sJZkTpb2zICR
RGQXoV3M7PCcj9ZJ9xbPyBEpY+sYWcfQmmakX6ylZxndyyYp5pznydYFECm0
1WSSQpTUH2UlrFhxVIY4bii8DaLEzoQ4SoUVZTD2tMeyqZjNY3RFXoVOUcZa
d+LFYXJSYDovFXvyb7oO9haYuVXmGLa5/2YLC9Kbu4VOpH7w0O6ZR3HxFPJO
o+wMaoWFnmuHfVlEOhDtxeIIlvldkoP18MHmvLTm1vXd/UTyYCWZ4pRJ8FcG
EdxFgAxiR/eNbhvfwOgGhgV52u9PoG8VvSvokd6CQl6h3rYIBXyzYN84L8BH
zfHQWdTOokZSWEMjr/NWgZ4tgTInzl1LBX2/JoTRl1jt8h2mroK9Xj9LkOu0
yYNCj+4WOwoy5vftYhM3x9/MatXLKOZ6xbdYcBf74XcY8MPv7b7wKK6cQuFp
VJ5RWShGCjFZCq9kTrMdmO9DfIRJSvj31iPJzdj2Fs+mre3sKFsgnY8J7Gmd
J8y925KpkspvYWITYzJ8OmzO4GRngt+1jE49InSCkVfgLzD4TTEQ+Hqsrm4O
CnoO1BFUCwFVYfNtnhA7IyrlSv+NMh6pVtHC1GkzayrWWZPh4l+9goXnCpyy
il5xQAQc5kuZcULgP5LNsqfnP0HyKv6UYwZu/q6LaRH3WJg5jD9PP7R//lGl
/zyjgM4LGLiGsUK4y3g31JSa60zF+lNxXuqylwjsrs9ubfK0/+r2xvLO7uLO
fmz3QK8lm9llN+Q1PVEWc7LFCzTYHjZMTgbWQLT0rjIn3UKLnq+RLIpoYU4y
aFF5LrFSqwxiVrNSHdYj+USJwSaRRZQoo6Cj7JBUK4iYEr8uNu2VmBEZrSCr
UNmr4qNQv+aQzqOkyLc0I8oCNcTyk32EEWt0t763yu2618KIsMgsvAH5T6Ds
KdSeEd90AUO5GHdimulIhZtT0a6DhQHaTq54thPBjXVeebSylYgTK9vJ6M6+
kvp2Tp5kDMMjFjIlVIwTFZsY2cCQ5LPMhI4OJ5mJFXRKN7t9CW1xtMbZRuTs
rcxETItcH0UdFcml0nxoDagMozKk8CJGDLaR7LKMnJa5CEjMNoo5u1VB22XO
d2aRkRSZRYBmbm4c82BbYU7sKpXK18HbONZabphdO56XG+I5r/2Sx93LR899
F1cehfMJVD6FBqGj7wJGcjEpw3kzdQeRloNoN23vLE1srnjXEqGV9XnaXdhc
i25tz27zGozgdoqT2G0QD25zHseuWTBtIqtvDb0J9CTQvco06L5dm8lDyyJb
RNMCW4S2ovp5pImonWMWBAXyU+SjhIUKKYJZeVBna6UzktWKqyoRu7AX61jN
FiHx2enVoUG3rVCclR7q4AMFajQv+6aIZ2L8k1vEPRp7FUWR+wiKn0D1U2g6
g84cDFzEaC6mitgKgvUHs+17870nRKbwFq9z92/BKz0FigVqDHtMlH1YIsKg
6DujvGaivIrOFW3NhDODHEcz6XuT7jk4GmQ4o05ANghiW1bN7KEmV0V4DV1Y
5UIKakJZ3Y80Pg20QTCrfoP/0Cu79NrGtK4bTh0dTignpIqCXb6lMTdMdafP
fDNE2/PM11yOrm/8sb7puPln3uQcSuZWbvB19kedKhqfROkTqH2Kr+/OweAl
jF9PuYsQbFTeMxTpW1rl1zkCK9FAYknUxHZidF3eDSTdF14GNzCwbo7FdSfQ
ldCsKF1tW0arEEM7REzTokaoPgZS/rp55oX2Wfnn9FgnkyIj1mGTkvRMQllQ
BwbFjM3BfkhEImJcVNgHCS9FPu19ivQIB5sCq1qal0J57bJATyozNw4rL3Ln
vPT77UejxvEeyWo91rzrbh0l+NAJk4ssNAgRvTn7Qxd2Rq/qCLAValqb61yJ
DcQXx+eX+FXD0Op8ILHsW1u38eDe/sRGilJU0wpOEBf96+gTS+lZgyJERUO7
4qJliVrUHOc3fRe1JA0xGESIQXQYtVF+A85cAlM1SxkrB4bKCJiPsJ4fICLS
FiKEsIWo3oIegeW0lTsORXpNqlPFaKNQj24rBg7X8aWDNNdZOkazURh5+jV7
vQSW9Tk7nTNlzjlkvlX9hgyMbyWMVVaI/vPq9K6ndDNQkwi30HYsNnyrfJux
E+ei5xOpM1wTQ8cq2lfQtpLu9y6hmUocTXE0mr1he8MC6lVsZRRtdoKxJpqR
S1aJ11H+JkKZTljJRzjaGcCskoz4WsxZD+FouPwKbgKySIryaaTS2r0rTO2F
qldsZ+gcmViyZ1HPV70A9jEGVY68KcvaUYXo7Zbs884MFO8wUXQcjF6hjw1v
+cpMvfLS4dhYYNHjjYfcy/OTK5zwj6zuDCcOBhM8Qqc8tvIp3QktZxNp4rKJ
KQHatKRPpDE9Ub+AupguteLHa9Krd6vnQJBSqaQiyX1FhNVT3Y88RhkVSe5L
eaaAMFY2QNgqV2FjdNlXKCtXmDKsrKlqbMH0FApB2ihQPV6VuRAs+XolqQmw
9uF5sjmVkc9belPKho6Jnmamf0cG7ncR7rY30MbB4Es7Y9doY9lXSXUk0jUz
N+Sdn3Iv+Cfis6NL/E7P4MpW/8pe3yrDruPjKmuwXi/YsoKmZY1z3SIal9AY
RwMVE3NHnWBeK8WoYU3WaswtrpqDQXiLN6iQYq7pUXgL5EapnnFMq7QET1Zq
0WXlqP0m7j7tpClL5Lyl0Cvpu2k3WQr1wwxedNyeP525YoL9NkPPt7euAtXu
+oYx7JuvZ78tA/c3mvp+27y/hj58kT73HPefRmKhwUXuPPUubXYv7XYty3oT
8hG2rLYVLTKpdjNrd5PuF93esMQ4q5PllI2I661dYJhZr2MgrKup6HGDLIK6
Upww4V3Bo84VEVO3wyiTkWeCu5QH10p1xsI+hNVbiiugNJzPcDBMZ4Raw+2m
TitFp/hHPqRA92A5KWT1VmFQ4iHjy9+xrmJzpD3xTzfGdjID6beYMfC10emy
oL/BE+ycCA/R/kB0pjfGuXjn4np7nBNEFb/S7sIgDTYIWpujXsCti6NOj8tk
1ywcelTyJNWkzwSwWB4haydQVSQLc+9GoCwNaX9RojNtQVRAtWmvzLDaXf60
RfAv+2Un+RGNqsOMcAXKYRgaVYOUVmV+Cto8/YcerKuhHMfmFMaPRTRLI5oZ
Be9l38EjYnOTzoCnijZGg/z6Rc+srzM6d4uy+DhqqSxyEXlqFtnqCbGFDDus
NdFsWthvWdjT/euKOVbOclUiZp5BkGo0Da4cJcFDJuzFM8oZuJSOqv47eeIi
nU0TklzSGupNayhHOQLUIRav5wiViip1FTBu/8nRzM5EU9XZx+bLb2MU+bGB
yRKqh/xd0rZbmuYWG6Jr9fO8ULw2dkBGrCDjWv2Vl6oFVFLh/h5XMg4+j0pz
bu/WiijKTfdaOoviMMrnGEu27lmURdJ5LyGqiu4LltDniTSuxUFWU97g6SeX
ysTsRX6VBzvNorTTm86/CrTdK9ZITfOliHs1M4a0BljXcFjHoWw/6dpwc4yE
G/FzjCxvTExVDnjbdNxvDIXqIgvVs2sM11yyMrpfMa/WedjL9XuT9vJYunXm
sSzaKI/qUmZmCvaqw/hFmBqlyo8aBKbNXhIGIclgMqJK4xSYjKThmtG57OGo
oKBqT+upjS3fkcb1MEdI52N2lSSYuNpNbKwrNY7imWHHN6zv5selV+ny/d5h
RqoT9X4e764MxcrCa6JSyZLZA3M0cw4lUS4qZtKGnhuOonSOC2FirrooNfvI
JRH994pKzMlOm6M4ZPa5RP8EJKrYN+r8NABCSRXDyXg5fZm6JFhJhuWFcpJa
AyXQM1Js33zMGm2sK7YURIJfVvqohi2Nir3Ky4u0SgIx26uFQV4w6JpLt4g3
HS5T4uJZUzqyxwgXysUjOnu94MZFNwgAKq6QuY7KFQTJrwrtF82gKGD2HhUW
snkMElmiNQXeG9Ap0PFDW6OhtcYaJ47H4o5jsfgFM8K+utw9ZjN/rgd2r89w
8nI9iOsh5IXNvkKaa+2DI3BKIW2PaN/CqZ8rAleYi44GZZKHX/EwNK5gGoEg
GBG2J65YO9ItMJwBOJz+tOfXTy3kWKA9P+WD1Msp8OoeDmXj+fw7ffi2nHWV
xxFMXnssJj9PmIhuZ1327akHX5nB1fR76NeCuBZCboihcZi4FEjRa7LMNe/O
8KFEDqee73QGD6OngwR3ShGZ2WCcaRQYA/UNP0RFClXWxigYWnaHll3phQf5
nkO9sK50seqJwuDOYzH4WcJAyfbS9K4pgVSXArg8AwZE50KMR25Q46F6PPRZ
oLazC82MiYQrDev4xRbC0mktCoAkK+SeV6H2oYUZo2mFepaRpGV7MKWW+JSv
PIR1Xta6jl9J+jodw82c/q0kI4d6W/aL06kcT0pJ+ZIPL/v0fI0WVIpqa+7h
muG8oJZWK3TBDApmzBEC2ioUUkm4fL+Z/xQKtyycQ3OZVeBL80gG7oXmkDMZ
T/qv3r4Si+L51ZsKR1i8J23dT4/yHPOzEwdnJg/OTrGoz0/jxWnkeHDOfLOC
xL7gx8V0a68EcDWg9P4aC5Z7+LdTrlOvOW9Gy088FgS0BI+2oMCvi7prQTon
theYTPpuYJJukZbbrhl9649hVEn9hmOl5l7Da6Q1SrrzXhCpKlpd9oPEuqIN
y7imE83cAK5LkViad/hpuzU/wyvliyxKopYFHpvP1wrryCce87U95nuVIMok
bYZm8ucsMtxyrEx3HyvTm818/fGhA9WWJ0fx1Bh+NI5nJjTSz7nxvErNlNd9
yYuXvbjg43JRQ29cIb27ymsqrvkP5crlA9d1nzCPRcoTl5uvv2XP1zk4EyVF
9Vu8YoH0lYx3at/xE0n5Rost3k3ynZSmPz2BZydwZhJnpyDWaT/vwUseFkXP
jVz04pIZES77cEWP1Diu+nBNjpNo9lxT/67LIa5l82Se77CttJ2rOr+kw3k6
kuQxe0oiro08xd6vWOSwZiBKrjcfy95d2g55PFL0MPu5KTw/hRfceNGNnGmc
m9b+5WUPLlBhWS+aPR0l4xWW4KrOKXN9N0inNr0qr6bPMukMfNmpSMvWEvya
pcUnjpXgLcdKcKeZj2fYo2odizF1GNGySZTz5lIDJY3y/xc9uGSmM5dZvium
fFfl8DWGnStHbsYKfzvtsGQ6j5jBdY8u8sTrSrJ3WySxvt2oJPuZYyW7XXNj
rnKw2UmcF6eQwyOi59zar12YZkkuSjEu6VFVksC4qntNVw//op6Sgs3Ki1wP
F+V7VFB7Qf4DgbrDe38MI2pO554MW5FnUYuZjlt0y1+vtco4z2MILx32zi6Y
WnXp8C9VXab2X1E+1rhKn9dUS7JydQ5x5fAvJP7Oj0FVtc7qqUXPdcvk7V5u
Ws4Uzk3hPBVG9SVznp0aeNEsxiWVuTmu6JZQ666ab2Dar4kEXMumIzfD4/y+
pQXWkT7Vzrcdy75d9wV+xmQ/+1zG3/mlhr5sjpOrDP+inhQ1LhO2V3Sv7Sp3
4a4drgmk3/db2mDt2ak2vV1OZbaJv/v2tCYSYC9JsRkv87j8Bfdh2wxqiv2S
noy6fPjOtnFFT1zRJzfMuKpa+Uc/UYt+VuvaL5q69tJUutdKGKSxsTMQjksZ
7bFfpvZcUfbyp5Z724991s9bjv6CKbfjpUmQvKoY9FCJqpf0sBg9RxVu018c
Z+lHnvQLlqPvMKV7mR40aY5VK+kuToGK45Iapf9vx0jyKto9nHG1xrt3pNmj
O1+QYmMZOJZ97JjW3ni3X/wJ7sbt+sQRbb7f/J828h8cmMNf0vr06Ru1zPQk
RyKaFaWbfe9XLddZefxMxv5hq95pucqaDf0tMryc/FcS3rNe9XdHEPvPlive
dsw3DP0N/X9wMs7ee0wr7OlWvMty1rrO6pNQaxrE40gUSv99j4yrPq6vUqsa
32M5a13N+FF9tXp/3Boh3mTZ/7C+Wr3p9puWs9Z+0Z/pqyVvlr+wze21XvVB
jYH620rWKPB6y/5/1fdUf3vufZaz1j7oH+qrxfOp/4CVcfZ1lv3f1VeLZsrf
h+f2Wq/6LX2V+r8bf2A5ax0JeI+WTv3fmz+0nLWOuP26vrf6/0n/xXLWOtLy
Tn21+s9V1hhgHYP4JX21+t9eH0DGexAW6+Krfk+usnpxa3ZtrnCSltr+2HLW
mrPeo7GQu9r+xHLWmo28Sd/7g3L1B3V7rVe9Xl/153LVhyxnrVHntfpq8bOi
n68UN27TV4sftf255azV99+ipfsbufovkJlF3Zgt8D0/KVd9OOPs/XrKhM/+
rZzlVrLTvU/2bK/6v/v1OoE=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->42012401]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14758264],

Cell["\<\
This calculates the classical action for a relativistic 3D oscillator:\
\>", "ExampleText",
 CellID->635299783],

Cell[BoxData[
 RowBox[{
  RowBox[{"HamiltonS", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "\[ScriptCapitalE]"}], " ", "t"}], "+", 
    RowBox[{"\[ScriptCapitalL]", " ", "\[CurlyPhi]"}], "+", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SqrtBox[
       RowBox[{
        RowBox[{
         FractionBox["1", 
          SuperscriptBox["c", "2"]], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"\[ScriptCapitalE]", "-", 
            RowBox[{
             FractionBox["1", "2"], " ", "m", " ", "\[Omega]", " ", 
             SuperscriptBox["\[Rho]", "2"]}]}], ")"}], "2"]}], "-", 
        FractionBox[
         SuperscriptBox["\[ScriptCapitalL]", "2"], 
         SuperscriptBox["\[Rho]", "2"]], "-", 
        RowBox[{
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["c", "2"]}]}]], 
      RowBox[{"\[DifferentialD]", "\[Rho]"}]}]}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->97385879],

Cell[TextData[{
 "The action can be expressed using ",
 Cell[BoxData[
  RowBox[{" ", "EllipticPi"}]], "InlineFormula"],
 " (for brevity, occurring roots are abbreviated):"
}], "ExampleText",
 CellID->72349346],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"HamiltonS", " ", "/.", " ", 
   RowBox[{"MapIndexed", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"#1", "\[Rule]", 
       SubscriptBox["\[ScriptCapitalR]", 
        RowBox[{"#2", "[", 
         RowBox[{"[", "1", "]"}], "]"}]]}], "&"}], ",", 
     RowBox[{"Union", "[", 
      RowBox[{"Cases", "[", 
       RowBox[{"HamiltonS", ",", "_Root", ",", "\[Infinity]"}], "]"}], 
      "]"}]}], "]"}]}], " ", "//", " ", "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->41127911],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{579, 440},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->251341330]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->36387963],

Cell["A conformal map:", "ExampleText",
 CellID->9680926],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "w_", "]"}], "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     SqrtBox[
      FractionBox[
       RowBox[{
        RowBox[{"Cos", "[", "w", "]"}], "+", 
        RowBox[{"1", "/", "2"}]}], 
       RowBox[{
        RowBox[{"Cos", "[", "w", "]"}], "-", 
        RowBox[{"1", "/", "3"}]}]]], ",", "w"}], "]"}], "//", 
   "PowerExpand"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->921811622],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"1", "+", 
      RowBox[{"Cos", "[", "w", "]"}]}]]], 
   RowBox[{
    RowBox[{"Cos", "[", 
     FractionBox["w", "2"], "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"EllipticF", "[", 
       RowBox[{
        RowBox[{"ArcSin", "[", 
         RowBox[{
          SqrtBox["2"], " ", 
          RowBox[{"Tan", "[", 
           FractionBox["w", "2"], "]"}]}], "]"}], ",", 
        FractionBox["1", "6"]}], "]"}], "+", 
      RowBox[{"4", " ", 
       RowBox[{"EllipticPi", "[", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", "2"]}], ",", 
         RowBox[{"-", 
          RowBox[{"ArcSin", "[", 
           RowBox[{
            SqrtBox["2"], " ", 
            RowBox[{"Tan", "[", 
             FractionBox["w", "2"], "]"}]}], "]"}]}], ",", 
         FractionBox["1", "6"]}], "]"}]}]}], ")"}]}]}]}]], "Output",
 ImageSize->{563, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->399477382]
}, Open  ]],

Cell["\<\
Visualize the image of lines of constant real and imaginary parts:\
\>", "ExampleText",
 CellID->482963154],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", 
      RowBox[{"f", "[", 
       RowBox[{"u", "+", 
        RowBox[{"I", " ", "v"}]}], "]"}], "]"}], ",", 
     RowBox[{"Im", "[", 
      RowBox[{"f", "[", 
       RowBox[{"u", "+", 
        RowBox[{"I", " ", "v"}]}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"1", "/", "100"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->799039566],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->428118520]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28215],

Cell["Expand special cases using assumptions:", "ExampleText",
 CellID->22785854],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"EllipticPi", "[", 
   RowBox[{"n", ",", "z", ",", "1"}], "]"}], "//", 
  "FunctionExpand"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->514617148],

Cell[BoxData[
 RowBox[{"EllipticPi", "[", 
  RowBox[{"n", ",", "z", ",", "1"}], "]"}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->374437869]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"%", ",", 
   RowBox[{"0", "<", "z", "<", 
    RowBox[{"Pi", "/", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->389916808],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    SqrtBox["n"], " ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{
      SqrtBox["n"], " ", 
      RowBox[{"Sin", "[", "z", "]"}]}], "]"}]}], "-", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"Sec", "[", "z", "]"}], "+", 
     RowBox[{"Tan", "[", "z", "]"}]}], "]"}]}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", "n"}]]], "Output",
 ImageSize->{312, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->578513041]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->273518513],

Cell[TextData[{
 "This shows the branch cuts of the ",
 Cell[BoxData[
  ButtonBox["EllipticPi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticPi"]], "InlineFormula"],
 " function:"
}], "ExampleText",
 CellID->515847209],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"EllipticPi", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"x", "+", 
       RowBox[{"\[ImaginaryI]", " ", "y"}]}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"y", "\[Equal]", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70414942],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->252924115]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"EllipticPi", "[", 
     RowBox[{"0.2", ",", 
      RowBox[{"x", "+", 
       RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
      RowBox[{"1", "/", "4"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"ViewPoint", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2.5"}], ",", " ", 
      RowBox[{"-", "1.4"}], ",", " ", "1.8"}], "}"}]}], ",", 
   RowBox[{"BoxRatios", "->", "Automatic"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{
        RowBox[{"-", "Pi"}], "/", "2"}]}], ",", 
      RowBox[{"x", "\[Equal]", 
       RowBox[{"Pi", "/", "2"}]}]}], "}"}]}], ",", 
   RowBox[{"ExclusionsStyle", "\[Rule]", 
    RowBox[{"{", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->85321896],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFvQd4G9ed7s0rO9ndbMtutiV7N9ly7+7dbOASJ3GSzTrxJrFTDFmyZfUu
SiLF3ivYCwgQIAACIEiCBECCvffeJbFLFEVKpEhK7EXsRMfM+9xvZkBSNEXb
spPnfnwgCDM4M/N7T5tzZt75g33J2+GqyyVvxyuX/vFdz0vuDo5XvP7xHTdP
atVL/8POzi6E+jfyd3bU5/9LfWL+hQCws/sF/f4StQzmz+5NZu0v9639we7a
Q9RKW5p396X5Y+rtZWrxfzPf/uqAb3eW7XZT/Xpfqpe29/HyvvX/a3ef9PH/
bN+3/8J8+5tPOeKzVL/dt/YP6LeXny3vkL13QDr62P+6eyx6iQHeFvUq85G9
b7tXmLWH961lMWvf37f2O8+lpQ9hS3t0X9pvM2s/2Lf235m1f71v7Y+2af/j
wG//c9/yl7dT/+OBqX+yb/nl5/LvWwdu918HlPQnbUcfnU7/0k5NeIH9v7Vv
+dALbvdT+u1Lu8vbeX5oX6p/+MRtD21Xgk/OsbeeI/lfB6Z7jVkmFN7by3++
7/t/OnArpta9xGZd1YnpDe3+Yt/3BzN95+Oq2azryzxvZltaxz8z2/zVvm3o
Gvfybt6wWQ6zUV70x7/cl+5bB279f7b3bfeHmV3I6kX2HeQMbDcdNuvGRJj7
/i2+ubufl7ZbJf2/3VdybiKvCwV9KLyLonsouo+iYXpHbJbzfS9mL4d2S/tP
trf60r59//PO3v40pxb5TSjqQEknynpRfhcV91E5jMqHqBhB+Si9557r7nZ/
s28PL2/nBkP9XFntrz9fZZbfZ13fXt7hsvtqVgFyS1FYjeIGlLWi8haqe1B7
F/WDaHiAxlE0jqF+HHUTNEjbaff9HHuV2e3y/AEO7kcP5nJ/2317+Y92uL6m
USFLi9xc5BehqBxlNahqQm0HGrrQ3I/WQbQ9QPsoOibQ8QRtU2iZRuM0Q/C3
n0JIf/za58ixxOP+28tf3iH7W5UcmmRkKKFVIVeLwnyUlKCiAjV1qG9B8y20
9+LWALqG0T2KnnH0TaF3Ft3zuL2A9gU0zDKUf7NdT/5g33GZ2mz3p9vf7me3
UZVcDdlTC5ha/ffpYqgkUEmhliMzGVlKZKtQoEVpPipLUFuFxnq0tuLmbXT1
oW8QAyO4N4H7Uxiew9ASBpdxZwVdy2hdQt3Cgfm4vyyfkX5aKob45YZrYdj5
o788lJYAu79XiWhmtRQaGbKTkaNErgpFWlTkoaYEjdVoa8TtNnR3or8fg/fx
8BEeTWJ8DhNPMbGKsQ0MbeLOBjpWUTqLTKqKHtrO2Y/3d/vL1kb+Z9t5dyDx
lzuvhdvt/CmFUApwKE1IdS4UeLoIagk0iciQIScZeUrkq1CqRVU+6kvQUo1b
jehpx90uDN3F6DAej2F6BnOLWFjF/BZmDZgw4J4OzcvImCCCb1rOlVovle22
npe2iWk2pt98ri/7s526+GWlGKkJSBUiVYCU+F3Kv09PgEaMjERkypCbjAIl
ilQo16I2H00laK9GVyPutGOoG2MDmHyIuQk8ncXqMjY2sW7AihnTJvLOutmH
Fe/B4lPvdoeo/6lel4tTGobhL57L5a8fyPrHO6x/pJRDKUWKGMkJUFC4DHEy
H6nxVLmlCWzUGWJkJiJLhjwFipQoUaFSi/p8tJbgVhV6G3CvDSNdeDKA+YdY
eYyNOehXYNqCxQSdyTK7tebLin9G/RJDfZXF26bZT/c3BzL/0U6r+vc0NZRK
JCuQJEWSGAoR5ALI+UiOh4IPBQ8pfCiZfE8XIkMErQTZMuQrUKxEmQo1WWjK
R1sxuipxpx5DrRjrxMxdPH2AzcfQz8GyAuhIGMxWw/rU1K3PZD+00y53l/5g
J3//LC0HKRlQpCEpGTIZEsVIFEImhJSPRB7kPCRRrzgk83CIQqZymyHOkiBH
igIFSpSoUKFWi8ZctBWiqwwDdXjYgse3sdCP9WEYJ2CeBZZJbFKvFf3S8MxN
yQHE13aJ958r/urA3H5pR8Erykokl0CeB5kWUjUkqRDLIZJAKIQwHmLqxYOY
i8Q4yOMg40IRh1Qq//lIFyAjgZaSK0WhAqWpqEhHbQYas9Gaj64SDFRhtAlT
N/G0F1uDsDwCOQ0sWrBGveZ1Y42rDTxKiveOlP1K9veFXztYCa3i9dQWJDdA
Xo3EUkgKkJANoQaCNMQrwJeCL0JcPOLiIIiDkAthDMSxkHIhjUUSly4cWk48
I0eM3EQUyFGSjHIlalRozERrDrqKMFCO0XpMt2G5G4YBEA9BPiYxs4XFdapd
mIZKiNrYvXK2S+b6i+h5c/dcntqJ5JuQtyGxEeIaCCvAKwI3B7GZiElHdDKi
pIgWI0aAqDhEx4Ibi/gY8KMhjIY4BokxkMcyZcSjFWkEyExAjhj5UhQnoTwF
NWlo0KA1C135GCjBSA2mm7FyC4Z+kPcJ8hGBJ5uYoXr7XtzJQ1Wcz2cpOrQ7
/tinRHYLknaImsGvB7cKMaWIyENIJjgqBCcjWIqgBHAECOMhLAZhUYiKQmwU
4iIRH4WEKEiiIY1BUiySuUjjQUUVjwDZCciToEiGMgWqU9GgQksmOnMxUISR
Skw3YKUd+i6C6DeRQ0aMruDRBIZv41YmSvkHKHHYVcJ6puCNvf2roBW8JkTX
IKwCIcUIyIGvGl4p8JTBUwRPPry58ItBYCSCIxAajshwxISTceFkfDiZEEFK
oiCLRlIMUrlI50ETjywh8kQoTESpHNXJaEhDiwad2RgowEgppmux3ETo2i2W
LgN5ZxODC7j/EP1taNSgUGB3yHsb3db8t88P+1V8bV89Y87Er1LL0Y0Iq0ZQ
GXwK4K6FUxoc5LgmwvU4OETDKQKuYfDgwJeDQA44HERwyJgQkhtC8kNJcQQS
IyGPQkoM0rhQ85AZj1whCsQokaIqCfUpaElHpxYDeRgpxlQFsVRr2Wwymdp1
ZNcKeqkB2T3cakB1BnKENiVf9txRQr3cWXxHFu/VAxUw88ZXqOWgGviWw70Q
1zNxMQVnJDgdh9OROMvB+UDYB+K6H1z84BMAf39wAsiIIDI6iOQGkwmUgjBI
I6CIgjIGKi4yeMiOR34CiiWolKFegWYlOjW4m4MH+eTjYutChWm9xmBs2iTa
n5L0kLcfzbUozaQ68M9Hz4x1WNSyTzWcinBZi1MpOJKAw9E4HIwjvvjACyc8
cN4D9h5w9oKXN/x9yFA/IsKfiA4g+BR9CCShkEcgNQppMdBwkcVHngBFIlQk
ok6O5hTcVpF9GeT9bGIszzJbbFgr1+lr1qz182T9GNnQS1RRUx4t1GK7Q16f
h50ZC79GLXtU42oxTqrAluBwONheVraThe0I9nXrMQfizA3yijPp5Ep6eZBB
3kSoDxHhS3ADSGEwRBxIw5AcAWUU1LHQxiGXjyIhysWolaEpiexIIbrTiYEM
68Ms81Se4WnRpq502VIxQ5SPkuXdlqIaUquFSkRhe7H4nnvOFDcOqPc7Z2dm
JMFyrceZIhxOMbJ919gXDezTevZZ69Gzxo8uW85cs15xsDo7E77uRJAHEepJ
RPuS8YGkMAiJIUgKQ2okVNHIjEUOD4XxKEsgqyRkvZRskVtvp1j70ixDatOE
Vj+fs76Wt2QqmLTmDxP5nUZtjTk1ax+u3Q4v/1Pb6R/u1BP5Q+RPo3MNqxaw
fz7Mfm+dfWTz6HH9sQums5fMV69a3J0If1drsJs1wovg+pHxARAHQxaClHCk
RSIjGtlcMp9HFseTFQlkjZhokFg6ZJbuZPM9pXEkfWtSs7qUubChfWzKHLRo
bulTazYlWValiKLdz+z0Gcy7o7Zvj+rgwWzswuKzfzrP/s36+x/qjp02njtv
crhq8bph9Xe2hroT0d4k3w8JgUgMhiKUVIaT6ihSG0PmcInCOLI0nqgSEjUJ
5haJ+bbM1JekH1RsjqUsTytnl5QTG6n3DIpbW5Ka5bjsTekzXO+dGvFZtMzV
wW/bMLdJv9vFfmuW/e7KkSObx0/qL503OtubfRytwS5EhAcR50MK/UlJEJnE
IVPDSFUEkRlFZMcQebFEcRxRzrdWxpvrhaZ2sfG2eKtPsj4kfTomnZmSjS0m
3l1OuLkeVz0Xmr3AP4DU+UVI/22X1JkpE/arg+wfTb//ztIHH26cP61zvGjw
vm4OdLKEu1ljvQiBLyEOIOTBRHIIkRZGaCIJbZQ1J9paEGMt4VrL40zVPGOz
wNAWv3k7frVfuDgknHokGH3MuzsVc3MurPqxb87jSBFzVqEOaPcl753uwYM5
vN3B/YON052BtCWktqMaJvu1ocM/mX7/N09Pf7Rx9cyWxxWDv4Mp1Nkc426J
97GK/K2yQKsi2KoMtarDrRkRVm2kJS/KUhRtKYkxlcfo6+L0jdyNttjlTu5C
P3dyMGZkOOLOCKdj1K96xCVnOPCLc9oSutAFEk9VFzbrNvu10cM/m/no8PLl
E+uuF7b8rxs5N0xRrma+l0Xka5EGWJKCrCkca3qoVRNmyQy3ZEdY8iPNhZHG
4kh9VYyuNmq9MfJpW8Tc7fAn3aEjvQF37vi033Gp6rPP6fUUH8zp8hmcbnsS
em5zJrBfucP+wfiRd+bOf7DidGbd/6o+2MEQ4WyM8zAn+JgT/czyAEtykCUt
xKIKtWhCzdowc064OS/MWBimK4vYqgxbqwldagiZbQp83Or/sN2zv8O5vf1K
VfPpnHZHsfvvgZPOfjcatZ392oPDP5s8/d6Cw4kVv8tbwdd04Y4GrptR6GWW
+Jpk/uakQEtqsCWdY1ZxzJoQU1aoKSfEkBeiKwzZLOGslgUuVQbMVvk8rvF4
UOvUX3ulvep0VemRnNpLvyun6067d6c5q9ms/sM/Gjv9q5lrHy55nV8Ptt8M
d9DFOBsEniaxt1Hqa5L7m1MCzcogc3qwSR1sygg2aoP12UFbuUEb+QErBX6L
Rd4zxe4TxTceFF/pKzzTnvtBVcY72dEsxRfi/Lbrc5yeNGcWVUsPvzF86peT
147Ou59eCb6yEX5tM9pJz3c3iLyMiT5GmZ9JQaEGmJSBpvRAozrQoAnUZwZs
af3Xs3xWsr0Ws91msp0msq4+0J7rUx9rT/11lfQn2UEsmS1n9vZMLi/SM/3H
PlLXbdI0NquB/frAybfHr7Jn3E8sBV9aC7+6EXNji+eiT/AwSLyMUh9jkp8p
2d+U6m9UBhjTAgwqf53Kb0vts672WtG4L2qcZ9KvTaRdeJByok/Gbhf+rCrm
jWw/lnQvqefu2PfFaHfL320PM5slo6vAqz0nf/LQ/jdP3D+a9z+3HHZlLcZh
k+esE7rrxZ4GqbdR7ksBG5P9jDSwv0Hpq1P6bKV5rSs9VlKdF1MdZ5IuT8jO
PBAd7ee90x7xw6oAVqbX70T7t/to3bZpE9isivdfuf3Rj+7bvzPu8eFMwJnF
sMsrMdfX+U6bCW46sYc+0ctA0/oaFb5Gu0Mpfga7v0zx0aV4b6Z4rCtcV5Ju
LMquzogvTAiOP4h9rz/sZ+2+36tyYWW5sRJdP477OWj/2v3jtO7btEI2q/jo
Kx0nfzhw/Z1HXh9MBZ1eiLi8zL2+9jFaH4qT4rX7K4WvIdlXr/DWJXluJrmv
y5xXEh0WRVdm488+jjn2MORXd3z+s+PGd6sus7KusRIOpHXdR7v/DgV99d3u
5b20h+hG+lVqB++zBO+zCj54peXcm/1O7474fjDJOT0Xfflp3PVVgfOGyG1L
sk1roFgPJfkY7L6W5KOXe+lkHptS13WJ00rCtaX4S3Mxp5+EHR3x++Vd5zdv
nn+l+gRLe/E5WLsXp2Xa41+4MXlq28UxVsLxV/M/erXp8g973d59EPDB4/Az
s7GXl+IdVhKc18Vum4meOqmX3u5lOc0o99bLvHRS9y2J60bCjdX4q0+5F+fD
T04Gvj/q/vMB++/dOsmqYbO0Z1hCl50DeH0hxq/tZTzJEp98Ne/8dxsdf9zt
86uhkGPj0WdneFcWhQ4rIuf1RLdNqadO7qWnM5OCPEST/rnM2yD11Evct0Qu
GwLHtbiry1EX5jknpnzYYzfeHjz33c6jrDo2K/s4K95lt19lUON3O6HtfvXA
Un/Jc6fU7egyZ9T96TlW4plXcx1+0ODxX13Bv7kfdXws7ty00H5B7Lic6LIm
c9+Qe24leevtmPL+C6rgKVKKM9FTL3bXCV02+Y7rMfYrERcWA0/MeB6euPb2
0Lnv9xx+pYHNyjlq6+k/D6ftvrXvTlpbCXx1tye4wpJeeyXP7c26oLc7Iw8P
8k4+El6Yklyblzk9lbuuJXlsKLy2FD76Q1QzsvtrhtUopVkNInedwGWL57gR
bb8aemHJ78Sc2+EnV/774cnv9x9mtbBZ+WxWvPN20dtKP/4FS58h/o4PPc3Z
Vkdtu9vtObLkHqy8oB/VRb1zm3/0nujMqPTKpNxhPtnlabL7aorXRorPVoqv
nuqjqJ6V6q6ofovqa6lGJnLXx7tscR03Iu3XOBeWfU7MOx+euvDfo0e+N0AP
LFglVNeyD/jz8Hrv4fXa4fWir6cmh7yaH/tWXcJ7t6Un7ikujKZcm1Q6zae5
PU3zXE3z3kjz3VL66VP9DSn+9MmAOofJfIzU+Yw6q8W76rg3tiKvrnMurvic
WnI+Onv+FxMf/GCIHluyKtgs0Qvz0jMpusbSc3Qm1b967zBSGR35WnL8D/Ol
79SlfHA77eyA6sqo2nFS4zqv8Xyq8VlT+26o/XXpAfq0AGNqgDHF36SgGH1N
id4mkacx3s0Q66SLvL4ZfHnN+8yy87GF8+9OfvjjEfarfcw4KNVph3H32C+W
o9+29RoeO5A2Wqoii3+ckvLfBerD9VmnbudcvpfrOJrrOpnjOZ/j8zTLb00b
sJkRqNMEGlRBxrRAU2qAKTnALPczJ/qYRF4mgbsx1kUf6aijRjo+51adji9d
+O3M4f8aZ792j81qZbMyvjCtxx5aCtLWOfuz4lW/SM19r7D4RH3ppdtlDvdK
XUdLvCaLfOcLA5bzA9dygzezgnWZwQZNsEkVTI8HqVFhkr9F6msWe5sFHiau
qzHyhp5zdcv3wrrTyZWLhxc++Pkk+42HbFYXVQVu/F5pA1jxhezUmuOF9Rfr
Gxw7693u1Xo/qvafqgxaKOMsF4esF4Rs5Ybos0ON2hCTJoQaulpSgyyKQIvM
3yLxtQg8zXFupkgnA+e6zvfSpvPptcsfPP3o3Vn2j8fZr1DZ20zN3n5HWnem
Juzmbf0J5c2LRbcdG255dHb4DrYGjTVxputDF6rDVyrCN0rCdQXhhrxwU3aY
OTPMog6xpnGsKUFWeYBV4mcRelt4HuZoF1Ooo8HfXud2ftP++OpJ9hL77Wn2
d0fZrO5Ppf0Kw3nijWvby//44vQuO/Sdl9IGbhQNejXcDezq4wx2h4/dipxp
jVpsjF6tid6siNaXRBkLIs15kZYsaiYbRs0TiVQOkRRESAOsIl8rNYuMcTeH
OZsCHYyel/UOpzfOHVs78uvFwz9+wn5lyPGz6Y+wHD4PvdvH6Yec0sa9i8eD
G0cjuoej7w9yx/t4s7fjnrbz1pp4WzVcQ0WsqSTGUhBtzYkitBGEOpxQhhDJ
HEIWSIj9CYEPwfW0Rriag2+Yfa4Znc7rLp3aPH507f2fz7PffPIC9M/cD5+D
3nmHftI7fZ5TPB/dOM3veSIcGk2YuC+a601Y7kzYaBPqGuONNXxzOc9azLXm
xxDZUURGJJEeRqaEkEnBhCSQEPoRPG8iyt3KcbH4OVpcrxjtz+lPn9g6wl49
/N8LL0B/+EXov3MgvR8rfiUkfSW2eF3YtCLtWZAPT8qfPJIv3JOu9kk3b0sM
rWJTvdBSJbCW8olCLpETQ2qjSXUEqQwjFSGkNIhMCCD5vmS0FxnqRgQ4WT2v
W65fMp07Y/jwuO7999Ycdug9mTPawfxs1gvU/Ff38nszVxuozyEsoS42fUtU
bEhqNih719IfLqRPTaYtjaSu3UvW9SQZO6TmJomlVkRUCIliPpEfR2bHkhnR
ZHoEmRJGyjgQB0HgD64vGeFJBLtafZ2srtctVy6ZTp4xHj2h38fvuTs++pNt
8hfI+VeZycY2udcOeTQrwZiQrlcUm9UtVu0dY9boetbMnHb5sWbjQbrhTqqp
U2FplVnrE4kqEVkmJAv5ZG4cqY2FKgqpEUgKRSIHwkDw/RHtQ4Z6EAGuVm8X
wsnBevGy+eQF04HkU3qbD+Irn0lPXyxl6F/fS0/txYnpepAVbUlKM2pKrPkt
ROGApWhcXzi3nL82k7M1mmm8pzb3KK0dydYmOVGbSFaIyWIh8qiNuFDH0FfY
kyMgDYUoGIIgcP3JCG8i2MMa4EF4uhLXHawXrlqv76G3zUj0ZowYUDWP9DGb
hj88UAPNvOPceGl7nGL3vd0rf7bzPtUbMxpiSFWaOb8EFW1E1aC16omxYnGj
bGO+UDeRaxrSWvo1RGca0ZpM1stRlYgSEfIFyOYhg4u0aPomhzwckhAkcMAP
IqP9iDAfguNN+HmSrm7kdWfywg1yrwbSYBrf1LE5lsNJxJlCuNTBpxm7Lp/9
OpgS+piH4qV9dWt3XvPdj4uKRZbSWl6K+nayaYhonDY1LG9Vbz0t008WmR7m
WQeyyJ4Msj0NDQpUy1AqQUECcuKRyYMqFspoKCLpOyHiUAhDwA0kI/2JMD8i
2Jf09oKbFxzcsfcy8cziA7a3lc0Bm4ujcpxW41oxPKpp3i9v63L4orresE3W
qA7QjcXUnbwUsqEM7TfJ2w/Jm3PmtjV9o36lxjRTbnlURNzPJ3u1aFehMQXV
SSiTolBM3/nT8qGOQ1osUqIhi4QkHKIw8DlkTBAZFUSGB5IB/vD1h7vfM13k
TO/xABwLxYdR+CAeJ2Q4n45rOXAtgS8jbdt7RWkjUjw+rza7N3fnebsCmYKL
Q0kKOsrQ04X+cfQtWTs3DG3GtUbLXA0xUY6hQvTmoF2DxjTUJKNcjqJE+iZt
lgAaPtLjkBqLpGhIKY0REIaTvBAyNoSM4pAhwQgKhj/nmcBrYbgcgUsxuMDH
RQkuK3BdDecceBcjoAKcWkbjyzsaN0Sen1vjD/dptI1/6JtUVcnorcHgHQxP
4/462a8zdVo22omFRkxUYagYvXlo16JJhdpUlCtQLEO+hL6hniGAmo+0OCTH
Qk7JjII4EoIIkhdOxoaTUWEICwMn/JlGj1i4xsFFABcJXJLglgbPTPjmIbAE
oZWIqkNc8zN6NstxPtrrc6v8kdeem5M2ldQa5MehIRlDTRgdwvgCRg3kfZOl
n9jsxEILJmoxVIbeAnRko0mDujRUpNCmhwIpcsXQCmkzRDofqXFQcCGLQWI0
RNEQRIEXCW4koiMREbWtEn3qAD78hfBPhF8S/JUI0CA4B6FFiChHTA34jUho
g6hjj2+YUjrp7Xtwf/mZ+pyYkQOKYnFLifF2TI9hehmPzeQIaR3ERg8WOjDR
iKFK9BajIxdNWtSpUamkbSqFctqykiVChhAqAW1lSYmjbS3SWNoNIoqBIJr2
h/BiEBOzrS9KiAgRwhMRrkCEEhEaRGYhOh9xpeBXQVAHSTNkHUi69XF9o/YB
z/Tt9xwzuv7J+zld1LyFLI8x9mkwewdPF7Ggw4yFnIB5GOv9mL+NiRYM1aCv
FB0FaM5GXQaq0mk3UZECeTJkS5Ap2taVyqOdLXaHZFzYfUMSi4RYCKlXHPhx
28J4IvCk4CnAU4KvQXwWBPkQFkNSCWkt5I1QtEF5C2mdSO/Z9SE73jsW/E8v
rsmZGZpaK6NWB3Kx+hjrOqySWCAtkzCMYGUAs910EQ41oK8CHUVozkW9FlVq
lKWhKBl5cmQnMpqEjIuNT/uP7A7JKWHfkMVBwoWIeucjIX5bkygRoiSIlZCo
kaiFNA/yYigqkFKLtEaoWqG5icwuaPfYq9msG+2/DvwUTd/cp8mFmVaaqiJW
H9VDt4ItPdZJyyIMU9h8hKVBTPVipAP3m9BXjY4SNBegPgdVGpSmoTAZuXJk
UZrEUCfYfG7/kMJnnG/Uiw8pj/bCSQWQCrclyeSQpSApHcmZSM2FshDpZdBU
I7MBWa3Y6/UuHkTx0LbXu/yXvnafoumt5zUFseJHa6J1uqcwk6QBlg0YlrAx
jeUxzN7HRB+Gb+JuM7prcbMczYWozUG5BiVpKEhBjhzaHU1pAtptmMo4JxWM
ETEpHnLqPQEK8bamlGSkpiFNA1U2NAXQliC7Erl1KGhGcQdKu1Deh4oBVN5H
9QNUj6ByFBWPaFkbQdc+pUW9tKuKuXZp9w1qjBzMEoyvry3p9dTQzWDA1jrW
F/F0GnNjmBzCaB8Gb6GvBbfr0FqOhkJU5aBEg6I05KcgW057PTMkUIuQJgTt
AT2UEk/9E8Du68lCpIiQmrgtKV0JtQqZWmTlIqcQ+WUoqkFpIzWqQ3UnantR
P4CGITQ+RNMYmsbROIH6J6h+wvQazzTRvSDjWP6mz557Ye7McJ+SMmbAnAlP
DVjewtNVLCxgZhKPRzF6H0N9uHMbXS3oqENTOeoKUZGNIg3y06ghC7RyZEih
YaS8RGtJpTT8z1SqWSVASamTIF1KK1EnQ6NEpgo5WcjPR2ExSitQWYeaFtTf
RFMPWu+i4z5uPsStMdx+gptT6JhG2ywaZ1A99ewpkoNbErV8sYTc1USNqDgs
wbAOj3S0k25yDZNLeDyLscd4MIJ799Dfi+5buNWCljrUlaOqEKXZyNcgNw05
KchMgkZKO53VYjB+7W9SwpTMi1pKEyFdjPRE2nJOCcuk8kCJLBXys1CSD2po
WlWFuno0taLtNm71oWsQvQ/RN4Y7T3B3FncW0LeI7iW0L6JhnimXbx6ojHnW
6h9o18+OphCWoH8N91YxvIIHS3gwh6FJDI7j7gP0DqCzGx0daGlCQy2qy1Fe
iOJs5GqQnQZtCjKSaLu5iqIW0wpsPvR/TLMpYl4q8bYnnRKVlUJvlqNCURbK
C1BdioYatDSiox2dXei9g7tDGHqEB5MYmcXoEkZWMEyRraN7DY1LKJiGeowu
s384UBnjM/+m7X4FCsNuLaJrAb3z6J9F3yR6xtA9gi6qLtxBWxea2lHXiKpq
lJWhpBAF2chSIzMNGSnQJEElo0sindFE1zjGD844wb9BS7L51RlJVLlSpZuv
RmkWqgpQV4rmGtxsQncH+rtx7y4ePMDYOJ7MYGoRM2uY3sQTPUb06N1E+Rwz
ZqfL6u8/WdG3bDMVaxGneYZ+KqNtkn5Co2Mc7SNoG0LLABp7UXcb1a2oqEdJ
JQpKkFeAnGxkqqFJgzoF6UlIk0IpQaroY/Z22iTOqPo6JYlqbBlM75CbggKq
61ejPAu1BWiiZg816GpC/00M9WL0Hh4/xMxjLM5jeQVrm1g1YtGEcQOZN/SA
vjfyJYr2s/WsF/pSX9RO0A/DNIyhfgR1Q6i9h+p+VHahrAMlzSisRV4Fsoug
zYNGC5UaaUqkKpAsRYoEySIohEhmnO/JTP+tFGw737+uSqD7wUxGT34y3T+W
qFGVjYYCtJbhVg16m3CvAyM9eDKI+VEsT2J9Abo1GPUwmbFiMNx90m+7Tf9Z
en5s07M76C1/iIoHKB9C6T2U9qO4G4W3kE+d+hqgrUZGKdQFSM+BMgPJaVAk
Qy6DVAy5CHIhZPEfM8NTZyUlU0oqxsivZeQUJNNnsXI1aqixcAHaS9FdjbvU
ALId492YvYeno9igxisLsKwBegJG89bak3CWwObieKbmq/vU/MWe0tlVk38f
BYPIH0BuH3K6kXULmW3QUGOTWijLkVIERS6StJCrkJiCRDnEEiQIIaEGBPGQ
8Bhr+Y5Rnho32DEjiK9TwyNKThYjhxpiUAONSmpQz3j724vRU4nBBoy0YbIb
iwPYGIHhCSzzoIdim0ZsLizd1VJyvPaXzn49zJWZH+2KsenR3kFGL9RdUN2C
sg0pTVDUQVYBaQkk+RBlIUGNBCUESRAmIj4BfD4EfNonL+LSVnkpl/bJy7lI
tlnl4+mhXoaIHspSWqghYJkSVSrUZaIpB20F6CnDYC3GWjHTieU70A3DMgFy
jsSylW46T0c3ulNfWMtLzwqGGbd/n/aUdyH5NhQdkLZAXI+EKsSXgpsPbhZi
NYhVIkaBGCm4YnDjERMHLhfxXAhidozysZAxRvkUxiiv2vH90wWThNIUVKah
ToOmLLTloacYg1UYa8LcTaz1wTgI8hEwRWBuE0vz5FQn0SEL2xFD3yB9+YX1
MDPF71HfJ96EuA2CRnBrEF2OiEKEZoNDzdCU4CSBkwhOAsIEiOAhPAZR0Yil
Zj/UHCiK9shLdjzyVOEoGVu5RgitiGk0MpQoUJGK2nQ0ZaItBz2FuF+OsXrM
tWG9C+YBkA8ITFgxuYInIxhpRp3EJsZmKXlxLcyskHaa81sQU4/wSgSXwD8P
PpnwVMIjCR4SeAnhzYMfF4ExCI5EKDVBjUBMBOIiEB9JJkSRkmh6HpsUixTG
Iq+ORyYzws5PRLEc5cmoVaJRjbYs9ORjsARj1ZhrwvotmHoIcsCIhwY8WsDD
+xioRWXiXiH7SoU++3xtnwLmSs3r1BehtQisgE8xXLPhqMJVBezFsOfjWiwc
I+ESAY8weIcgMBScUISHIDqU5IaR/DBSFEEmRtL+eEUMlFyoeMhg5jz5YhRJ
UZ6EmhQ0pqMtAz25GCzCWAXm6rHWShhuWYgeHX3Ovz+Fu/3oLEeJLJTBd/tc
LYS5kka7m/2q4VZCX4k6n4YTiTjOx/EonArBmSBcDsT1ANzwg1cg/AMRFIiI
YDI6mORySEEoKQ5HYgRti0+NQTpji6cE5CWgUIIyGaoVaFSiTY2eLAwWYKwU
s1XESr1F32K03NpEz1P0jqGrEy0lKEgKYQS4f1rvu5//mdP5egl9ifCIFO9H
gx1Msn3Jw574wB1nPXHJHTe84OkDXx9w/MmIACI6kIijLfGQhEEWgeQdSzx9
XhegQITSRFTL6UstbenoycRgLjlSSE6XWp5WGbfq9aaWNbJ9nux4iNabRG0p
spODd9CZemP3kvsu4ddfSAftImb8/b6tcGmAX7uFHahnXzex7U3sqzh6zXri
BnnRmXRwhbsH/L3JEF8i3JeICSAEHFIUgsRQJEUgNRrpzAWObD7yhSgRo0qK
+iS0KdGlJu9qieEc4nGBebFEv1G5ZaxbIRpmyIZh1HZYSkuRkRrEEnjvDOJf
+kIq6GtbzNNI336kp73Q7A9W2B/p2acMH54znbxqvXjd6nCD8HIjgzyJEC8i
0oeIYwzyYg5kYUiJpC990+NfHvLiUZyASgnqZGSLgrylJHpV1sFM66Ns02yB
fq1kw1C2aK2YJCruk2VtptxSQqkMZErgd6FnZmj/5rrjOKamnbSF++jWB6eN
Jy+ZL14xOztafV2JQHdrmCcRQ3vlkRAEaQgU4VBGQh0NLRe5PBQJyHIRWSMh
G6REe5K1K9VyV2V5mGGcytYt5q5t5s9bCset+fesua0GValZmkaRbztldr1Z
Nhl2L9YGDuB+8y77F0ts9ubRE4ZTZ432V8zujlY/Z2uwGxHpRcT5kYIASIIh
Z/zyqkhk0u5zsoBHlgrIShFZK7Y2J1puJVn6UsxDaYYx1eZMxsqKdlanfWTN
vGNSteqSSg0CVcBebs8vyP0frjvb2owe7NcesH+6cPi9taMf6c6eNTpcNns5
WgOcrWHuRAxjnBcFkjIOmRxKpkWQmigyK5bM5RJFPKJcQFQJrXUic1uiqVtu
vJukG05ef5y6NKecXlGO6lL7DPKWzYRSXYya4mZu+G079bbdPu7MDbTPWVs+
Rm/bA/t7D9lvLxz57cqpE7or5wyu9iY/R0uIizXKg+D5kAn+pDSIUIQQyjBC
HUFoo2kzfX4sUcIjKviWqnhTU4KxQ2zoFm/eTVx7KFt8LJuclT1ckvStClpW
Y0pXORqK3nagL0Dv9dn0rGb2GxPvvz137OjaxVNbThf0vtdNwU7mCDdLnDd9
OzkxkEgKtqaEEOnh9M1mbZQ1N9paFGst5VrK44x1fEOLQN8Rv94tWLmXMP9Q
+GRC8GCS1zsT1TLHKZ321vizBG47Rf3i9P+8Q+vxcVpHFo/Nunv4zYn3f714
7tja9TObvleNgQ6mcGcz18Mi8LFK/K3yIKuCY00LtWrCrZkR1qxIS360pSja
XBpjrIzVN8TpmrlrHbFPe+LmBrgT96OHH0b0PgpuGfEufeBE07p+UVq3j9N6
b9N2sF+lKvjUCfaS/fFVz0tbgdcNoTeMMW7meG+L2M8iY8z2qRyrKsxiM9vn
Mmb7okhDaZSuOnqrLmqtOXKpI3K2K3y8J2S4P6Dnnldzv1NZz2WNH0vg8vuj
daBpK9iv9LHfHDv27uylD566nVsPvKoLcdBHuRj5nmaRj1nqT1vuU4It6SEW
dYhZE2rOCjPnhpvywwyFYVvl4RtVYat1oYuNnJmWwPF2v6GbHj23nJrbL5c1
n8qgaJ13/FLPPHdflPY6TZtKZ+/rwx/+fPLi4XnnUyuBVzZDrm1F3tDz3E0J
3qZExnivCLQog83pHLOaY8oMMWWFGHNC9PmcrSLOemnwSnngQpX/dLX3WJ37
/fob3fVXmmtOlZUdyfBl8vazaPdHd/iXj9N6fYxWzGbVsF+98+Fb4xd+O+P0
0ZL/xfWQq5uRjjqui0HoaZQw9vukbfu9KT3IpA42ZgYbsoL1OUGbuYHrBQHL
hb4LxV7TJW5jpY73S650F59uLjhSlvkuTev6+6C15fA1mjaSzSplv9L94Q8f
XHj3idOHC95nV0KurEc6bMY66wTuBjFjwpf7mZIDaCubMsBoM+FnBOoyAza1
fuvZPsvZngs5rlM5jmPZV+5nne3O/LA5/Vdl8rcyfJg+wff3R/s+K4TNKmSz
2t//3uD5X4w7HZn1PrUUcmk18toG12kr3lUvoo34Btm2EZ/2tacFGNP89bQR
33dT7bOm8VzWuM2rb0ypro6ln7+ferwn6b1m8U/L4r6v8WT6X5sXzet3pr3K
4h1nhbJZ2VTHe/j1O+feHrnBnvQ+Mc+5sBxpv8Z13Ix30SW46yWeDK2vUeFn
TKGN+IZUPz1txPfeVHquKd2XU53mU69PJ10ck526Lz7SE//L5qg3y4JZGneW
0PML0v71PlofhvYMTaths+qPvNpz6WcPXN577Ht8NvT8UpT9apzjhsBlS2Sj
9Tbs+topYgPtdPXeSvHaTHZfU7gsyx0XZPbT4nNjgo+GuL/pCX+rxf+NMk+W
xpUl9Nqxzu16er5Q3lL7sGfxjrHc2Sw11dA+erXT/qf33d8bDzw+E35+McZ+
he+4LnTZFLvrJJ56qff2YwNJtAnfoPDRK7y2kjw25a5rUqdlyfWFhEvT/NPj
MUeHQ9/p9f1xq/PrZc4stRNL6M3EIdjOW9uo04ZKI/3dJ9P+7UG0cddY8cdY
6g9YVWdeu+X4s3ve7z3iHJ+KPD8fd3U53nFN5LIpcd9KtNHS3nGjzZn9l3Jv
vdxzS+a+meiyJr6xLLy6yLswE31yIvT9B74/73P+fuvFV8svstSOrIS9eWuj
9dwdEXwK7bMnHHZpr7DiHFnx51nqk6wK+zc63P/7buDh0bATk7EX5vjXnibc
WBW7biS6b0k9dTLvbTf+X8q89NRyovumyHld6LjCu7IYc3427PjjAPZDt5/d
sf9u+ylWxUcs9VkWx3PHwvf74HSiz2WaS69WOP+g3e8Xd8KOjESfesK/NCe8
tiR2Wkl0XZdRBe2lk2873Rk//l9KvfSJnjqx21aC80a8w2rslaWIs3PBx554
/WbE8a27Z1+9+SGrkmoHF1hxHjusVF2g537f+JQ6upfPc4fPhT61qF1eL/f9
cVvor/pjPnzAP/M44fKsxGFR6rwid1tP8txUeOvoSulLP34hZ4z4Ui+DxEMv
ctsSOG/wHNairyyHnp0PODbl9ptH9m/dO/Xa7cO0qTnjJCvObQ+g3QsTeu4h
dKOvimr83ygP/2kr970+wfFh8fkJ2dUZ+Y1FhetKssd6stdmio8u2VdPNx6m
Idns91TTSnDTxTtvch3WIy+vcM4u+nw04/zb8QtvDZ16o5tNP9KQ+SGL67qX
cP/c7Vl50/N8OoYYk+L/7ALa0/4PQRArI+qH5fxftoqP9spODyddmkh1mEl1
XlS6ryi91pU+m1RvSfWZNrt90o7dXuxpELrp+c5bsQ4b4VdWg84ueR2bdfzt
k7M/ffjhG31sVhOblctmxbrsAfxkvv25ydy1oAdi/+rLdJ3eLGHc9zPEPytP
eq819URv+oVh1bVxjfOM2m1R7bmi9lmnzj3p/ro0f4PS35jiT/X1JrmvSepj
pE6uQncDz0UX47gZbr8WdH7F88SCA3vqzNuP2N+9y2a1sVlF7J1HZPdSun1e
Surk6csSyt/KTP91Reax1qxzvdlXh3OcJuiH57wWtT4rWv/1jIAtTaBeFWhI
CzQqA+gH2aizKDVUkXibEjwMPFd9zA1d2NWNoIurnqeeOhyZO/3ziaPfH2Kz
OtmsMjZLcGOH0ud3oQxgCbXvZhYcrSg+01pi31tyY7jEfaLIe6bAbzE/YCU3
cCM7aCszSK8JNqqCTGlB5tRAsyLALPMzS3xMCZ5Gvpsxxkkffn0r8NK655kV
xw8XT78zdeRHI/Rwl243ydRY/QtQfuw5mx1aarAXxEooP6qtPV1RZ99a79RX
6zFc7TNR6T9bFrRUErxayNnI4+iyQwzaEKOGY2bs9ZbkQIvc35LoaxZ5mfke
phgXQ7ijnhrQep1bc/xo+exvZg+/NcE8DEAVvtqBoXX9XWn/zZcZ9nNYCS2n
tR1XKm45t3Z49rX5P2gOetwQMlsTulQRtlYavlkYpssLM+aEmbShZk2IJZ1j
SaUmWYFWqZ9F5GOJ9zTHuhrDbxiCruq8Lmw4nlw9f3jx6C+m2d8bYbOoRl9x
bQ/ts3nKFyamimpVHNd3JeuuS8WAT1tfYF9P6MPb4U/aIueaopbrotarordK
owyFEca8CHN2uCUzzKoKtSo51uQgqyzAKva1CrwtXHdzpLOR42DwuaxzPrN+
6djKsV/Ns//zMfuV+2xW69UDiV1fhPg7ns96VLrbtwHrk3ijLlmPfCtHOe0P
Ivrvxzy8w53s5C50xK00x23UcXWVscbSGFNhtCUvypoVQWjCifRQIoVx1Sf6
W4W+Vp6XJdrNHOJk8r9mcLuwZX9y/dTRlcO/mGO/8YjN6rVngN0+6flAG+/+
eKJMfMbveO1xKNh4b7B4ZDpv0idrLrRyJqb9Cf/OmGBkWDh1R7jYJVztEGw2
x+tr+abKOEsJ11oQQ+REEZmRjI8+lFBwCGkgIfIj+D5EjIc1zMUS6Gj2tDc6
nN06d3zjKHv58E+m2K89vEL3O78vXicWDyrefIh2jVu5IuxYTLwzI3s0Lpse
li3dSVzvkmy1i41NCeYagaWcby3i0rEMsqJJTSSZxjjn5cGEOIAU+JFcLyLC
zRrkbPG5bna6ZLh0Rnf8o83331li/2TmEsPr/hyvv22c+vl4nWle/nKMdlNc
aUjq2EwdeJo2PqOcHU9dvp+82Z+kvy0ztUrM9SJrlZAo5RMFcUROLJkZTaoi
6ZgMSSFkYhAdpYHnS0Z6khxXwu+G1fWqxf6C8fQp/dEjG4ffXd7l9fq8vP+x
j9dm74eav5mQqUuusqhvmjPvbWofP82cn9Ksjqq2BpXG7mRzh8zSlGitERMV
QjoIR14cfaFOE02mRSA5DFIORIy9PNaHDPMgAl2sPk5Wp2uWCxdMx04Z3j+6
xX5nxZc5LjNnoZsc3a25Mg8VbM8CDqR9zfs5WvoZXnW8SZFpyKgi8m5Z84fM
hU/W8xfnc9cfa/XDGlN/uuV2irVVTtRLySoxWZpAFsQjJw4ZsUiPQkoE5KGQ
cCAIBM+fjPQmOO60H97Tmbh+zXL2ounYOdP7x3Q7tNvjpl1YG+tOtLSd6Jn/
8gmsdI3XCEh1him/iizrJMofWipndGXLy8WbU3mGkSzzQIa1O53oSCGaksha
KR1BplBIR5PRcqFi3O+KcPpeQEIw4oMQ60eGeRPBnoSfO+HqTNhft5y1txy7
aLaxen4CK+NPfS4yLBP/998/iRjZGkt5NVnfTTaMWhvm9bVraxW6uWLDWL7l
fg7Rn0neVpHNKaiV08F6ikR04J4sHtRcOpRPShRk4RCHQMgBL4iM9KNj5wT7
EN4epLMrae9EnnEgfHdqwZf3PijxYJNG+7vPon59ryvOi/HL0+eaDCEKNGRD
Ndp7yY5xon3J2LyxUWdYrDQ9KbE+KCDv5qAzg46IVKegoyMVS+hISdnxdNSk
9Fj6ZldSJBLDIQqFIISMDSQiA4gwfyLQl/Tyhosn7N3gs8O6C71gRusKMh7v
iRj5aeRvPE9OjzszhShT026T7jvofUJ2r5hv6raaTU/rLFOV5EgJHX6qU4tm
FR2QqjKJDk5VIEaOkA5XpWLs6sk2u3oEbVfncciYYDIyiAxl7Oo+/nD1xe4z
ojZyo5lgh4HNw1EFzmhxvdTGb4t5Rj8rcZDLl2mPP3heAX0FPUtAx5XracS9
IdyfI+9uWbsN+puWlRZyuhYjZRgopAOCtWhQn0abukvkdLiwXBG0+/zoNqN2
GMkLJWNDyagQMoQJ3OXHgRfTNdsUkBtLp6JwkosTCTgtxwU1rufShnu/Guzc
1d1+4uMZ/X5PNqPm5b1qmChSr9Nq8uLRqMJgO0Yf4dEy+cBE3jUZesiVDkw3
YqQKA8XozKPDtDWo6JBtpQo6fFueBFmM81zFh9LmPLcZsiNJQSTJi2Cc5+EI
C0cw4zzfvebtxIVDPK6LcF0Oh1Q4Z8AtF74lCKxEqM1db4szuhOXaL8Spu/5
kcdO/uwWjc3ajiIebmfgUSempvBkgxwnyGHSeAcrnZhuwUgtBkrRWYCWbDRk
0JH0yhiDeb4U2WI6zp5agLRdg3ksHcHumcE8CtFRCI/C7mVbcvymbwJ8EuGd
BO9UOqycXzaCCsEpQ3gV7QngMTZ6m+Pm4OjnX35eB1UufLvvopxLUC145h4W
VzG7RU6SxCj097DSg+kOjDRgoAKdRWjNRYMWNWo60mFxMh31MCcRWjHtiEi3
OZPjaBsLbSSPpY3k8dF0rMG4WMTEwn1HR7gYYVKEKRCmRKgGYVmIzKeD/cVW
gVcHQRNErUhkjPJf/WQl//y8EqbU+WRVrO5+MVansWbCU5KchXkcm0NY7Mfk
bdqAMVCDzlK0FtBhJ2sy6BCUJakoSKLja9JKEugwlbQlnnEXMc7xv5Fwaed4
AhdCHvg82K4QUAflycFLAS8NvAzws8HPh6AEokpIapHYRIdkVNxESudnKPn+
XiVuz5TEW2qiNydasPkUm1ZyBaY56B5j9QHm7mK8E8OtuFtPGxlai9CYhxot
ylUoTqWjmmZL6QinGhGjJJ52FCXz6FicSTzQfvE4xkIVT/vFd696i5IhSYdE
g8RsSPMhL0ES4xdXNtkevviUOvX6gfzUbqeb+Bb9MoxWUg/TKnTzWHuChYeY
ukvHhh1sQ18DblfRMWPr81ClRakKRal0RFmtFJk2fiaiLyUhhTGuKfjb5nDa
0CaENOEZf5ISyRqkZiE1D2nFNua//mTmL+1jtp0t/446b85sLG0YzUYT9FvY
WMHKHBYeY/ohxgcw3EUH4+1qRHsVHZ63No8O1VukQqESuQpkSmmjo0ZMQzNu
wT+xub+T42knYVI84yoUIVkCF+YCc19pUJqKGd0cPD5jOL/lsSfqntvO3Udq
60kT7Y58qsfTdSwsYXYGT8bxaJgOZXy3iw5rfKsRLVV0oOOqPJRkokCFfCWy
FYz/2YaZsO3S/IqScW2mCmgHZ4qQdnMqJXSddWaOdGjXGbsTiZn55YNvPY9F
DYke6jC+hcfreLKMiXk8mqKDQVMnrf5+Ojz0rTa0NaChCtUlKM9DYSZy05GT
iiwFHVpanUj7X9NFtL2XITukFDL5w3TJTsyIfNtXvT+vGKJv2tzHe3HurOLe
Cu4vYWgeg1MYGMedEfQO4nYf2m+hpQUN9aipREUJSnKRn4nsdGSlIlMBtYxx
H+/g0BS2Z+j8dq9W2/Jkf1xtOn693d/ZGNwZhpvzuD2Lrhl0T6JzHLdHcGsI
7XfR0oPGm6htRmUtSstRXISCXORkIjMdGanQKGi3MH3cr7z4cf/Kdac3pOYp
DZNoeozmCbSMoXkETUNoGEBdL6pv0278skYUVyO/FLmFyM6BNoM51p+90LGY
X4/4c9uBAqgysbOrHEXVCKoe0M8qVAzQzy2UdtLPMBQ0I68OOZW29mi7p+7/
Inv/Y1tBojCMSWNXeB8F95B/B3m9yO1Edodtj39z4B5/xKy17cFcGPwsrnhm
H3N+pD9+4zO33CjwfW4s8D8P3OrHzFpqk8V8OkC+7YmTT0j1bI7+/yqVy//z
VM7/P6Z6e89ap8+1lnfA2hu/97VMBdn/VPonrHXas5autzvR5pmnSOyu0O9f
frbNTjI61Zd22rLdpQP28aXdUfyJfcfdPyehd/+3z6Xc2c/eZfoj0zrsPmJ2
tPvN9vFsz/bs/1WdQwempWeo9ErG42f7haBP0Emn+uY+EttW79DvX9q/Fb3i
73Hwb14wMxrb77x8is6Xt/uO3efZ9+zhDw7cw8s76p+L3XTQli/ZfTxm/MsH
zEj+cE+u2Q7yR8/lvG39/r51Z47zlRdMbxtB/Wab6/njHpz+s3876U+wN0b+
f23r/Mpnbmf7zaW9v+Fjd8B2OzPsf32uPHbyYO8y83s6dj87KI8/M9WOm/a7
uzo+zvtfu7x0KobbLuS5d7v/8f8BdPX6iw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{126, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->248267072]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->43572874],

Cell["Numerically find a root of a transcendental equation:", "ExampleText",
 CellID->359213511],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"EllipticPi", "[", 
       RowBox[{"z", ",", "2"}], "]"}], "3"], "+", 
     RowBox[{"EllipticPi", "[", 
      RowBox[{"z", ",", "2"}], "]"}], "+", "z"}], "\[Equal]", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "I"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87011885],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", 
   RowBox[{
    RowBox[{"-", "1.0621206431477452`"}], "+", 
    RowBox[{"1.6102379194785308`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->682230778]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14709596],

Cell["Integrals:", "ExampleText",
 CellID->421508063],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "z", "]"}], " ", 
    RowBox[{"EllipticPi", "[", 
     RowBox[{"n", ",", "z", ",", "m"}], "]"}]}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->401788471],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "m"}], "+", "n"}]], " ", 
      RowBox[{"Cos", "[", "z", "]"}]}], 
     RowBox[{
      SqrtBox[
       RowBox[{"1", "-", "n"}]], " ", 
      SqrtBox[
       RowBox[{"2", "-", "m", "+", 
        RowBox[{"m", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"2", " ", "z"}], "]"}]}]}]]}]], "]"}], 
   RowBox[{
    SqrtBox[
     RowBox[{"1", "-", "n"}]], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"-", "m"}], "+", "n"}]]}]], "+", 
  RowBox[{
   RowBox[{"EllipticPi", "[", 
    RowBox[{"n", ",", "z", ",", "m"}], "]"}], " ", 
   RowBox[{"Sin", "[", "z", "]"}]}]}]], "Output",
 ImageSize->{367, 58},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->516404192]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11944],

Cell["Limits at branch cuts can be wrong:", "ExampleText",
 CellID->44826221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"EllipticPi", "[", 
    RowBox[{"2", ",", 
     RowBox[{
      RowBox[{"Pi", "/", "2"}], "+", 
      RowBox[{"\[CurlyEpsilon]", " ", "I"}]}]}], "]"}], ",", 
   RowBox[{"\[CurlyEpsilon]", "->", "0"}], ",", 
   RowBox[{"Direction", "->", 
    RowBox[{"-", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->566911265],

Cell[BoxData[
 RowBox[{"EllipticPi", "[", 
  RowBox[{"2", ",", 
   FractionBox["\[Pi]", "2"]}], "]"}]], "Output",
 ImageSize->{119, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->169059261]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"EllipticPi", "[", 
    RowBox[{"2", ",", 
     RowBox[{
      RowBox[{"Pi", "/", "2"}], "+", 
      RowBox[{"\[CurlyEpsilon]", " ", "I"}]}]}], "]"}], ",", 
   RowBox[{"\[CurlyEpsilon]", "->", "0"}], ",", 
   RowBox[{"Direction", "->", 
    RowBox[{"+", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->651061860],

Cell[BoxData[
 RowBox[{"EllipticPi", "[", 
  RowBox[{"2", ",", 
   FractionBox["\[Pi]", "2"]}], "]"}]], "Output",
 ImageSize->{119, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->609237516]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->631730637],

Cell["\<\
The defining integral converges only under additional conditions:\
\>", "ExampleText",
 CellID->173356131],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "z"], 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"n", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
     SqrtBox[
      RowBox[{"1", "-", 
       RowBox[{"m", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "t", "]"}], "2"]}]}]]}]], 
   RowBox[{"\[DifferentialD]", "t"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->62121558],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Re", "[", 
        RowBox[{"m", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "z", "]"}], "2"]}], "]"}], "\[LessEqual]", 
       "1"}], "||", 
      RowBox[{
       RowBox[{"Im", "[", 
        RowBox[{"m", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "z", "]"}], "2"]}], "]"}], "\[NotEqual]", 
       "0"}]}], ")"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Re", "[", 
        RowBox[{"n", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "z", "]"}], "2"]}], "]"}], "\[LessEqual]", 
       "1"}], "||", 
      RowBox[{
       RowBox[{"Im", "[", 
        RowBox[{"n", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "z", "]"}], "2"]}], "]"}], "\[NotEqual]", 
       "0"}]}], ")"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Re", "[", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "-", "m", "+", 
            RowBox[{"m", " ", 
             RowBox[{"Cos", "[", 
              RowBox[{"2", " ", "z"}], "]"}]}]}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"Csc", "[", "z", "]"}], "2"]}], "m"], "]"}], 
       "\[GreaterEqual]", "0"}], "||", 
      RowBox[{
       RowBox[{"Re", "[", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "-", "m", "+", 
            RowBox[{"m", " ", 
             RowBox[{"Cos", "[", 
              RowBox[{"2", " ", "z"}], "]"}]}]}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"Csc", "[", "z", "]"}], "2"]}], "m"], "]"}], 
       "\[LessEqual]", 
       RowBox[{"-", "2"}]}], "||", 
      RowBox[{
       RowBox[{"Im", "[", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "-", "m", "+", 
            RowBox[{"m", " ", 
             RowBox[{"Cos", "[", 
              RowBox[{"2", " ", "z"}], "]"}]}]}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"Csc", "[", "z", "]"}], "2"]}], "m"], "]"}], "\[NotEqual]",
        "0"}]}], ")"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Re", "[", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "-", "n", "+", 
            RowBox[{"n", " ", 
             RowBox[{"Cos", "[", 
              RowBox[{"2", " ", "z"}], "]"}]}]}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"Csc", "[", "z", "]"}], "2"]}], "n"], "]"}], 
       "\[GreaterEqual]", "0"}], "||", 
      RowBox[{
       RowBox[{"Re", "[", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "-", "n", "+", 
            RowBox[{"n", " ", 
             RowBox[{"Cos", "[", 
              RowBox[{"2", " ", "z"}], "]"}]}]}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"Csc", "[", "z", "]"}], "2"]}], "n"], "]"}], 
       "\[LessEqual]", 
       RowBox[{"-", "2"}]}], "||", 
      RowBox[{
       RowBox[{"Im", "[", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "-", "n", "+", 
            RowBox[{"n", " ", 
             RowBox[{"Cos", "[", 
              RowBox[{"2", " ", "z"}], "]"}]}]}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"Csc", "[", "z", "]"}], "2"]}], "n"], "]"}], "\[NotEqual]",
        "0"}]}], ")"}], "&&", 
    RowBox[{
     RowBox[{"2", "+", 
      RowBox[{"m", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "z"}], "]"}]}]}], "\[NotEqual]", "m"}], "&&", 
    RowBox[{
     RowBox[{"2", "+", 
      RowBox[{"n", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "z"}], "]"}]}]}], "\[NotEqual]", "n"}]}], ",", 
   RowBox[{"EllipticPi", "[", 
    RowBox[{"n", ",", "z", ",", "m"}], "]"}], ",", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       SqrtBox[
        RowBox[{"1", "-", 
         RowBox[{"m", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "t", "]"}], "2"]}]}]], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"n", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "t", "]"}], "2"]}]}], ")"}]}]], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "z"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Im", "[", 
           RowBox[{"m", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", "z", "]"}], "2"]}], "]"}], "\[Equal]", "0"}],
          "&&", 
         RowBox[{
          RowBox[{"Re", "[", 
           RowBox[{"m", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", "z", "]"}], "2"]}], "]"}], ">", "1"}]}], 
        ")"}], "||", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Im", "[", 
           RowBox[{"n", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", "z", "]"}], "2"]}], "]"}], "\[Equal]", "0"}],
          "&&", 
         RowBox[{
          RowBox[{"Re", "[", 
           RowBox[{"n", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", "z", "]"}], "2"]}], "]"}], ">", "1"}]}], 
        ")"}], "||", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Im", "[", 
           FractionBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{"2", "-", "m", "+", 
               RowBox[{"m", " ", 
                RowBox[{"Cos", "[", 
                 RowBox[{"2", " ", "z"}], "]"}]}]}], ")"}], " ", 
             SuperscriptBox[
              RowBox[{"Csc", "[", "z", "]"}], "2"]}], "m"], "]"}], "\[Equal]",
           "0"}], "&&", 
         RowBox[{
          RowBox[{"-", "2"}], "<", 
          RowBox[{"Re", "[", 
           FractionBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{"2", "-", "m", "+", 
               RowBox[{"m", " ", 
                RowBox[{"Cos", "[", 
                 RowBox[{"2", " ", "z"}], "]"}]}]}], ")"}], " ", 
             SuperscriptBox[
              RowBox[{"Csc", "[", "z", "]"}], "2"]}], "m"], "]"}], "<", 
          "0"}]}], ")"}], "||", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Im", "[", 
           FractionBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{"2", "-", "n", "+", 
               RowBox[{"n", " ", 
                RowBox[{"Cos", "[", 
                 RowBox[{"2", " ", "z"}], "]"}]}]}], ")"}], " ", 
             SuperscriptBox[
              RowBox[{"Csc", "[", "z", "]"}], "2"]}], "n"], "]"}], "\[Equal]",
           "0"}], "&&", 
         RowBox[{
          RowBox[{"-", "2"}], "<", 
          RowBox[{"Re", "[", 
           FractionBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{"2", "-", "n", "+", 
               RowBox[{"n", " ", 
                RowBox[{"Cos", "[", 
                 RowBox[{"2", " ", "z"}], "]"}]}]}], ")"}], " ", 
             SuperscriptBox[
              RowBox[{"Csc", "[", "z", "]"}], "2"]}], "n"], "]"}], "<", 
          "0"}]}], ")"}], "||", 
       RowBox[{
        RowBox[{"2", "+", 
         RowBox[{"m", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"2", " ", "z"}], "]"}]}]}], "\[Equal]", "m"}], "||", 
       RowBox[{
        RowBox[{"2", "+", 
         RowBox[{"n", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"2", " ", "z"}], "]"}]}]}], "\[Equal]", "n"}]}]}]}], 
    "]"}]}], "]"}]], "Output",
 ImageSize->{584, 305},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->262954645]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->458797935],

Cell["\<\
Different argument conventions exist that result in modified results:\
\>", "ExampleText",
 CellID->150104120],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"n", " ", 
         RowBox[{
          RowBox[{"Sin", "[", "t", "]"}], "^", "2"}]}]}], ")"}], " ", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"1", "-", 
        RowBox[{
         RowBox[{"k", "^", "2"}], " ", 
         RowBox[{
          RowBox[{"Sin", "[", "t", "]"}], "^", "2"}]}]}], "]"}]}], ")"}]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "z"}], "}"}], ",", 
   RowBox[{"GenerateConditions", "->", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->459984691],

Cell[BoxData[
 RowBox[{"EllipticPi", "[", 
  RowBox[{"n", ",", "z", ",", 
   SuperscriptBox["k", "2"]}], "]"}]], "Output",
 ImageSize->{137, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->426126785]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"n", " ", 
          RowBox[{"t", "^", "2"}]}]}], ")"}], 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"m", " ", 
            RowBox[{"t", "^", "2"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"t", "^", "2"}]}], ")"}]}], "]"}]}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "z"}], "}"}], ",", " ", 
    RowBox[{"GenerateConditions", "->", "False"}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{"#", ",", 
     RowBox[{
      RowBox[{"0", "<", "m", "<", "1"}], "&&", 
      RowBox[{"0", "<", "z", "<", "1"}]}]}], "]"}], "&"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->104899489],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"EllipticPi", "[", 
   RowBox[{"n", ",", 
    RowBox[{"-", 
     RowBox[{"ArcSin", "[", "z", "]"}]}], ",", "m"}], "]"}]}]], "Output",
 ImageSize->{203, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->171188973]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20654],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticK",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticK"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticF"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticE",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticE"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->778]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7655],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->25516]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->11261],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/EllipticIntegraloftheThirdKind.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/EllipticIntegrals/EllipticPi/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->52157378],

Cell[TextData[ButtonBox["Elliptic Integrals",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticIntegrals"]], "MoreAbout",
 CellID->56344424],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->472681487]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EllipticPi - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 40, 4.1670670}", "context" -> "System`", 
    "keywords" -> {
     "complete elliptic integral", "ellipticcpi", "elliptic integral", 
      "elliptic integral of the third kind", "incomplete elliptic integral"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "EllipticPi[n, m] gives the complete elliptic integral of the third kind \
\\[CapitalPi] (n \\[VerticalSeparator] m). EllipticPi[n, \\[Phi], m] gives \
the incomplete elliptic integral \\[CapitalPi] (n; \\[Phi] \
\\[VerticalSeparator] m). ", "synonyms" -> {"elliptic pi"}, "title" -> 
    "EllipticPi", "type" -> "Symbol", "uri" -> "ref/EllipticPi"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7089, 239, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->444779439]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 143390, 3591}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2131, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2754, 78, 47, 1, 70, "ObjectName",
 CellID->6549],
Cell[2804, 81, 1491, 48, 70, "Usage",
 CellID->10695]
}, Open  ]],
Cell[CellGroupData[{
Cell[4332, 134, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4810, 151, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4933, 157, 888, 29, 70, "Notes",
 CellID->421056331],
Cell[5824, 188, 541, 18, 70, "Notes",
 CellID->132178877],
Cell[6368, 208, 251, 8, 70, "Notes",
 CellID->32287970],
Cell[6622, 218, 222, 7, 70, "Notes",
 CellID->31226],
Cell[6847, 227, 205, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[7089, 239, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->444779439],
Cell[CellGroupData[{
Cell[7474, 253, 148, 5, 70, "ExampleSection",
 CellID->822304930],
Cell[7625, 260, 64, 1, 70, "ExampleText",
 CellID->302265459],
Cell[CellGroupData[{
Cell[7714, 265, 133, 4, 28, "Input",
 CellID->436394388],
Cell[7850, 271, 173, 5, 36, "Output",
 CellID->6589803]
}, Open  ]],
Cell[8038, 279, 125, 3, 70, "ExampleDelimiter",
 CellID->353050909],
Cell[CellGroupData[{
Cell[8188, 286, 247, 8, 28, "Input",
 CellID->438244904],
Cell[8438, 296, 2261, 41, 140, "Output",
 Evaluatable->False,
 CellID->87383903]
}, Open  ]],
Cell[10714, 340, 124, 3, 70, "ExampleDelimiter",
 CellID->93803308],
Cell[10841, 345, 60, 1, 70, "ExampleText",
 CellID->89013934],
Cell[CellGroupData[{
Cell[10926, 350, 262, 8, 70, "Input",
 CellID->362843514],
Cell[11191, 360, 2486, 74, 117, "Output",
 CellID->105825228]
}, Open  ]],
Cell[CellGroupData[{
Cell[13714, 439, 267, 8, 70, "Input",
 CellID->387924925],
Cell[13984, 449, 1241, 37, 51, "Output",
 CellID->298966122]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15274, 492, 216, 7, 70, "ExampleSection",
 CellID->20862],
Cell[15493, 501, 64, 1, 70, "ExampleText",
 CellID->233643202],
Cell[CellGroupData[{
Cell[15582, 506, 189, 6, 70, "Input",
 CellID->92754591],
Cell[15774, 514, 172, 5, 36, "Output",
 CellID->89826]
}, Open  ]],
Cell[15961, 522, 124, 3, 70, "ExampleDelimiter",
 CellID->24675135],
Cell[16088, 527, 73, 1, 70, "ExampleText",
 CellID->40712917],
Cell[CellGroupData[{
Cell[16186, 532, 193, 7, 70, "Input",
 CellID->273099337],
Cell[16382, 541, 273, 7, 36, "Output",
 CellID->96523508]
}, Open  ]],
Cell[CellGroupData[{
Cell[16692, 553, 232, 8, 70, "Input",
 CellID->10049987],
Cell[16927, 563, 273, 7, 36, "Output",
 CellID->109525354]
}, Open  ]],
Cell[17215, 573, 125, 3, 70, "ExampleDelimiter",
 CellID->661329943],
Cell[17343, 578, 70, 1, 70, "ExampleText",
 CellID->359817788],
Cell[CellGroupData[{
Cell[17438, 583, 237, 8, 70, "Input",
 CellID->92760374],
Cell[17678, 593, 235, 7, 36, "Output",
 CellID->225588192]
}, Open  ]],
Cell[CellGroupData[{
Cell[17950, 605, 248, 8, 70, "Input",
 CellID->162410687],
Cell[18201, 615, 235, 7, 36, "Output",
 CellID->420764978]
}, Open  ]],
Cell[18451, 625, 125, 3, 70, "ExampleDelimiter",
 CellID->165557200],
Cell[18579, 630, 113, 3, 70, "ExampleText",
 CellID->628991026],
Cell[CellGroupData[{
Cell[18717, 637, 173, 5, 70, "Input",
 CellID->341879449],
Cell[18893, 644, 219, 6, 36, "Output",
 CellID->326290603]
}, Open  ]],
Cell[19127, 653, 125, 3, 70, "ExampleDelimiter",
 CellID->104554776],
Cell[19255, 658, 89, 1, 70, "ExampleText",
 CellID->3699197],
Cell[CellGroupData[{
Cell[19369, 663, 129, 4, 70, "Input",
 CellID->350129947],
Cell[19501, 669, 193, 6, 36, "Output",
 CellID->209810230]
}, Open  ]],
Cell[CellGroupData[{
Cell[19731, 680, 128, 4, 70, "Input",
 CellID->49881015],
Cell[19862, 686, 242, 9, 53, "Output",
 CellID->94721167]
}, Open  ]],
Cell[CellGroupData[{
Cell[20141, 700, 139, 4, 70, "Input",
 CellID->321616007],
Cell[20283, 706, 158, 5, 36, "Output",
 CellID->341218905]
}, Open  ]],
Cell[CellGroupData[{
Cell[20478, 716, 138, 4, 70, "Input",
 CellID->82429615],
Cell[20619, 722, 387, 15, 64, "Output",
 CellID->551329709]
}, Open  ]],
Cell[21021, 740, 125, 3, 70, "ExampleDelimiter",
 CellID->895189039],
Cell[21149, 745, 214, 7, 70, "ExampleText",
 CellID->232871448],
Cell[CellGroupData[{
Cell[21388, 756, 217, 7, 70, "Input",
 CellID->38848777],
Cell[21608, 765, 369, 11, 36, "Output",
 CellID->65760391]
}, Open  ]],
Cell[21992, 779, 125, 3, 70, "ExampleDelimiter",
 CellID->438156456],
Cell[22120, 784, 203, 7, 70, "ExampleText",
 CellID->441495560],
Cell[CellGroupData[{
Cell[22348, 795, 167, 5, 70, "Input",
 CellID->92836248],
Cell[22518, 802, 288, 9, 50, "Output",
 CellID->473263758]
}, Open  ]],
Cell[CellGroupData[{
Cell[22843, 816, 186, 6, 70, "Input",
 CellID->211826760],
Cell[23032, 824, 317, 10, 50, "Output",
 CellID->15749304]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23398, 840, 239, 7, 70, "ExampleSection",
 CellID->12480],
Cell[23640, 849, 213, 7, 70, "ExampleText",
 CellID->555511551],
Cell[CellGroupData[{
Cell[23878, 860, 273, 9, 70, "Input",
 CellID->55809021],
Cell[24154, 871, 1421, 43, 54, "Output",
 CellID->181158843]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25624, 920, 223, 7, 70, "ExampleSection",
 CellID->22811],
Cell[25850, 929, 73, 1, 70, "ExampleText",
 CellID->13377438],
Cell[CellGroupData[{
Cell[25948, 934, 278, 10, 70, "Input",
 CellID->867456692],
Cell[26229, 946, 1724, 60, 119, "Output",
 CellID->807221849]
}, Open  ]],
Cell[27968, 1009, 124, 3, 70, "ExampleDelimiter",
 CellID->96132111],
Cell[28095, 1014, 460, 16, 70, "ExampleText",
 CellID->817085670],
Cell[28558, 1032, 1193, 36, 70, "Input",
 CellID->344534690],
Cell[29754, 1070, 82, 1, 70, "ExampleText",
 CellID->374784375],
Cell[29839, 1073, 5089, 141, 70, "Input",
 CellID->308217535],
Cell[34931, 1216, 64, 1, 70, "ExampleText",
 CellID->280713378],
Cell[CellGroupData[{
Cell[35020, 1221, 590, 19, 70, "Input",
 CellID->159144135],
Cell[35613, 1242, 244, 8, 36, "Output",
 CellID->100695930]
}, Open  ]],
Cell[35872, 1253, 120, 3, 70, "ExampleText",
 CellID->138140112],
Cell[CellGroupData[{
Cell[36017, 1260, 340, 10, 70, "Input",
 CellID->87455621],
Cell[36360, 1272, 17865, 297, 70, "Output",
 Evaluatable->False,
 CellID->42012401]
}, Open  ]],
Cell[54240, 1572, 124, 3, 70, "ExampleDelimiter",
 CellID->14758264],
Cell[54367, 1577, 121, 3, 70, "ExampleText",
 CellID->635299783],
Cell[54491, 1582, 938, 28, 70, "Input",
 CellID->97385879],
Cell[55432, 1612, 209, 6, 70, "ExampleText",
 CellID->72349346],
Cell[CellGroupData[{
Cell[55666, 1622, 515, 15, 70, "Input",
 CellID->41127911],
Cell[56184, 1639, 11066, 185, 70, "Output",
 Evaluatable->False,
 CellID->251341330]
}, Open  ]],
Cell[67265, 1827, 124, 3, 70, "ExampleDelimiter",
 CellID->36387963],
Cell[67392, 1832, 57, 1, 70, "ExampleText",
 CellID->9680926],
Cell[CellGroupData[{
Cell[67474, 1837, 447, 16, 70, "Input",
 CellID->921811622],
Cell[67924, 1855, 1055, 36, 86, "Output",
 CellID->399477382]
}, Open  ]],
Cell[68994, 1894, 117, 3, 70, "ExampleText",
 CellID->482963154],
Cell[CellGroupData[{
Cell[69136, 1901, 603, 20, 70, "Input",
 CellID->799039566],
Cell[69742, 1923, 13180, 220, 70, "Output",
 Evaluatable->False,
 CellID->428118520]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[82971, 2149, 233, 7, 70, "ExampleSection",
 CellID->28215],
Cell[83207, 2158, 81, 1, 70, "ExampleText",
 CellID->22785854],
Cell[CellGroupData[{
Cell[83313, 2163, 180, 6, 70, "Input",
 CellID->514617148],
Cell[83496, 2171, 228, 7, 36, "Output",
 CellID->374437869]
}, Open  ]],
Cell[CellGroupData[{
Cell[83761, 2183, 193, 6, 70, "Input",
 CellID->389916808],
Cell[83957, 2191, 516, 19, 60, "Output",
 CellID->578513041]
}, Open  ]],
Cell[84488, 2213, 125, 3, 70, "ExampleDelimiter",
 CellID->273518513],
Cell[84616, 2218, 230, 8, 70, "ExampleText",
 CellID->515847209],
Cell[CellGroupData[{
Cell[84871, 2230, 590, 19, 70, "Input",
 CellID->70414942],
Cell[85464, 2251, 16064, 267, 70, "Output",
 Evaluatable->False,
 CellID->252924115]
}, Open  ]],
Cell[CellGroupData[{
Cell[101565, 2523, 1130, 34, 70, "Input",
 CellID->85321896],
Cell[102698, 2559, 21294, 353, 70, "Output",
 Evaluatable->False,
 CellID->248267072]
}, Open  ]],
Cell[124007, 2915, 124, 3, 70, "ExampleDelimiter",
 CellID->43572874],
Cell[124134, 2920, 96, 1, 70, "ExampleText",
 CellID->359213511],
Cell[CellGroupData[{
Cell[124255, 2925, 404, 13, 70, "Input",
 CellID->87011885],
Cell[124662, 2940, 330, 11, 36, "Output",
 CellID->682230778]
}, Open  ]],
Cell[125007, 2954, 124, 3, 70, "ExampleDelimiter",
 CellID->14709596],
Cell[125134, 2959, 53, 1, 70, "ExampleText",
 CellID->421508063],
Cell[CellGroupData[{
Cell[125212, 2964, 259, 8, 70, "Input",
 CellID->401788471],
Cell[125474, 2974, 887, 33, 79, "Output",
 CellID->516404192]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[126410, 3013, 226, 7, 70, "ExampleSection",
 CellID->11944],
Cell[126639, 3022, 77, 1, 70, "ExampleText",
 CellID->44826221],
Cell[CellGroupData[{
Cell[126741, 3027, 384, 12, 70, "Input",
 CellID->566911265],
Cell[127128, 3041, 244, 8, 49, "Output",
 CellID->169059261]
}, Open  ]],
Cell[CellGroupData[{
Cell[127409, 3054, 384, 12, 70, "Input",
 CellID->651061860],
Cell[127796, 3068, 244, 8, 49, "Output",
 CellID->609237516]
}, Open  ]],
Cell[128055, 3079, 125, 3, 70, "ExampleDelimiter",
 CellID->631730637],
Cell[128183, 3084, 116, 3, 70, "ExampleText",
 CellID->173356131],
Cell[CellGroupData[{
Cell[128324, 3091, 512, 18, 70, "Input",
 CellID->62121558],
Cell[128839, 3111, 7661, 237, 326, "Output",
 CellID->262954645]
}, Open  ]],
Cell[136515, 3351, 125, 3, 70, "ExampleDelimiter",
 CellID->458797935],
Cell[136643, 3356, 120, 3, 70, "ExampleText",
 CellID->150104120],
Cell[CellGroupData[{
Cell[136788, 3363, 664, 22, 70, "Input",
 CellID->459984691],
Cell[137455, 3387, 253, 8, 39, "Output",
 CellID->426126785]
}, Open  ]],
Cell[CellGroupData[{
Cell[137745, 3400, 931, 30, 70, "Input",
 CellID->104899489],
Cell[138679, 3432, 303, 10, 36, "Output",
 CellID->171188973]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[139043, 3449, 311, 9, 70, "SeeAlsoSection",
 CellID->20654],
Cell[139357, 3460, 700, 26, 70, "SeeAlso",
 CellID->778]
}, Open  ]],
Cell[CellGroupData[{
Cell[140094, 3491, 313, 9, 70, "TutorialsSection",
 CellID->7655],
Cell[140410, 3502, 192, 4, 70, "Tutorials",
 CellID->25516]
}, Open  ]],
Cell[CellGroupData[{
Cell[140639, 3511, 321, 9, 70, "RelatedLinksSection",
 CellID->11261],
Cell[140963, 3522, 201, 4, 70, "RelatedLinks"],
Cell[141167, 3528, 200, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[141404, 3537, 318, 9, 70, "MoreAboutSection",
 CellID->52157378],
Cell[141725, 3548, 146, 3, 70, "MoreAbout",
 CellID->56344424],
Cell[141874, 3553, 145, 3, 70, "MoreAbout",
 CellID->472681487]
}, Open  ]],
Cell[142034, 3559, 27, 0, 70, "History"],
Cell[142064, 3561, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

