(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    253490,       5358]
NotebookOptionsPosition[    242658,       5008]
NotebookOutlinePosition[    244266,       5051]
CellTagsIndexPosition[    244128,       5045]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ModularLambda" :> 
          Documentation`HelpLookup["paclet:ref/ModularLambda"], "DedekindEta" :> 
          Documentation`HelpLookup["paclet:ref/DedekindEta"], 
          "KleinInvariantJ" :> 
          Documentation`HelpLookup["paclet:ref/KleinInvariantJ"], 
          "EllipticExp" :> Documentation`HelpLookup["paclet:ref/EllipticExp"],
           "EllipticLog" :> 
          Documentation`HelpLookup["paclet:ref/EllipticLog"], "SiegelTheta" :> 
          Documentation`HelpLookup["paclet:ref/SiegelTheta"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ModularLambda\"\>", 
       2->"\<\"DedekindEta\"\>", 3->"\<\"KleinInvariantJ\"\>", 
       4->"\<\"EllipticExp\"\>", 5->"\<\"EllipticLog\"\>", 
       6->"\<\"SiegelTheta\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Elliptic Functions\"\>", 
       2->"\<\"Mathematical Functions\"\>", 
       3->"\<\"Number Theoretic Functions\"\>", 4->"\<\"Number Theory\"\>", 
       5->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EllipticTheta", "ObjectName",
 CellID->28333],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["EllipticTheta",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/EllipticTheta"], "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["u", "TI"], ",", 
        StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the theta function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["\[CurlyTheta]", "a"], "(", 
        RowBox[{"u", ",", "q"}], ")"}], TraditionalForm]], "InlineMath"],
     " (",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"a", "=", "1"}], ",", "\[Ellipsis]", ",", "4"}], 
       TraditionalForm]], "InlineMath"],
     "). "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29465]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[CurlyTheta]", "1"], "(", 
     RowBox[{"u", ",", "q"}], ")"}], "=", 
    RowBox[{"2", 
     SuperscriptBox["q", 
      RowBox[{"1", "/", "4"}]], 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"n", "=", "0"}], "\[Infinity]",
       LimitsPositioning->True], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "n"], 
       SuperscriptBox["q", 
        RowBox[{"n", "(", 
         RowBox[{"n", "+", "1"}], ")"}]], 
       RowBox[{"sin", "(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "n"}], "+", "1"}], ")"}], "u"}], ")"}]}]}]}]}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->27073],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[CurlyTheta]", "2"], "(", 
     RowBox[{"u", ",", "q"}], ")"}], "=", 
    RowBox[{"2", 
     SuperscriptBox["q", 
      RowBox[{"1", "/", "4"}]], 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"n", "=", "0"}], "\[Infinity]",
       LimitsPositioning->True], 
      RowBox[{
       SuperscriptBox["q", 
        RowBox[{"n", "(", 
         RowBox[{"n", "+", "1"}], ")"}]], 
       RowBox[{"cos", "(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "n"}], "+", "1"}], ")"}], "u"}], ")"}]}]}]}]}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->8064501],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[CurlyTheta]", "3"], "(", 
     RowBox[{"u", ",", "q"}], ")"}], "=", 
    RowBox[{"1", "+", 
     RowBox[{"2", 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"n", "=", "1"}], "\[Infinity]",
        LimitsPositioning->True], 
       RowBox[{
        SuperscriptBox["q", 
         SuperscriptBox["n", "2"]], 
        RowBox[{"cos", "(", 
         RowBox[{"2", "n", " ", "u"}], ")"}]}]}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->20590732],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[CurlyTheta]", "4"], "(", 
     RowBox[{"u", ",", "q"}], ")"}], "=", 
    RowBox[{"1", "+", 
     RowBox[{"2", 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"n", "=", "1"}], "\[Infinity]",
        LimitsPositioning->True], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "n"], 
        SuperscriptBox["q", 
         SuperscriptBox["n", "2"]], 
        RowBox[{"cos", "(", 
         RowBox[{"2", "n", " ", "u"}], ")"}]}]}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->13828035],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[CurlyTheta]", "i"], TraditionalForm]], "InlineMath"],
 " are defined only inside the unit ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 " disk; the disk forms a natural boundary of analyticity."
}], "Notes",
 CellID->5025318],

Cell[TextData[{
 "Inside the unit ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 " disk, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[CurlyTheta]", "1"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[CurlyTheta]", "2"], TraditionalForm]], "InlineMath"],
 " have branch cuts from 0 to -1. "
}], "Notes",
 CellID->3298577],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["EllipticTheta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticTheta"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->290233170],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticTheta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticTheta"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticTheta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticTheta"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->298229711],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->33261311],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticTheta", "[", 
  RowBox[{"1", ",", " ", "2.", ",", 
   RowBox[{"1", "/", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["1.4278763400221823`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21561431]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"EllipticTheta", "[", 
    RowBox[{"2", ",", " ", "x", ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "6"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytWkuIXFUQfZnunn8yk/lPJp9JYuL4izHGkN/EEGP8hBAEY5TgYgxCsvCD
xo1udKMb3ehGN7rwA34WEUURFMSAGBADoiAqiILEhUEwuAgIbd2quu/cPu92
ZgwZmJm+r+udU6eqbr17b/eBuRPHHnxo7sTxo3PTtz029+ix40cfn973yGNy
qbaoKIoP5ffhiUJeN+WV/h5pNptFLbzSn+Ke8KfIX702/G1cuPDvC8+funn2
lf13vPbuO98WV8vVDjGd0Xd//fWv48dOyrv3H3n7px//1HeL4prwt0vufOrJ
T94/+b2Mzp+/8NKLX7726tfFVcS1Xm3Pnv376APvff/dHzISHME8883vZmto
NXHCoIqa/nnm6U8/+/Tn8PJKQlynY2EXnwTX7cUDGZ879495bp7WhOWRhz8I
L+vxrsOH3gpW4zIOoB0JehHG8tvpMVDfa6+8fPrNN84A49QXv4ju0jNnEnki
TIOmY4mlRCS8HCf/O2lco/EVOpbIC6T46/ZCKcRlRD3O8KWT9A3IuC6g9Uti
RzbMXqSJN8wOzV2keWwBrGG4Vgfir3gdtHaTVs21ZTTxoTtqvevg65L3Clvd
88esxiYuiqPAQY2kbIhAD41HM2zpuEHjNZSZXh2L6zIoI+5VLmrkjRCJXtI8
4pq6/H/D/6+lOgj3dchEXJegiuPifnjZp2OZfjYV/W729YkTH53+6reIVtRk
lonv7Cuy30csjLo6Zlm0hZf9OpagS+hLe59t4OqniKx1xeajTEmZmLD7+KMf
nnv281a0EIclpGhN1jdpHTLh2rFG32C1mDgZdZq0ZL3wTiapkITASlilFwfu
Na54NSk2O2mP0iRb0YLiQX0X/XN11jfUQI41+gbFA6SYUVeR4qwX6G0CDCtE
e7UrnibFgzl2RQuKhyi6wZp7e3iZ6wmrKBo5j6LfsFpK/iwlVO2qdYyLSldY
SfFiDRoBn0lshZkUelOuy+f5g/5VFNkhUpLywmq42TpjBy9RLyI4FOMsVce8
4DFedJb/z7uCIjhCDBoPn7+I6wjddam88HyExikvro5SlJY08STLVe8KqpoR
0pGyQPMoZXcloS6PufE5MEZeqb13ALZCzPKoqLSxnBeOCqtx4l7hkWDlWXZH
g9U4ca4gH6dI00SGPXYnRHmCuPOo0DRBWU9RcXWSuJe78uWkaYK8SdGQ80lS
vpx8XEbKl9H9al/p8stonEeFch6nqPBtipT3ufJ0rcpr9SmKCutJmYA8RTHX
9U7LvO4iRbxenozR9xUsZ0cZKt2eZ1jo3/X4xLoEfqy8DRlrA/CHJ6X5gady
z4L4wtB4sOYzHqwaUp1YNdhMkFBIQPJ88bnEnc2qGutf9lzz6/hYwVt+sbbu
zvJdbLVuvFjtrySGlBfeGC92ij3N/Gp9IkbNdy7TFC+NcnnXMNUW+zruVTNJ
18f8+rJs7bQ++6N3noGWWA1RbeVjJWOJTZHxo9z5hs1+W3+gb2nFg7r9q9m/
OOfdYZi5pxLH1IruGvaolDMo6cbhffPW5mhUUy8rBnvSwTZeVuO3lGonXaUV
Zc8Kyosi7Awnms1KHos69qtFi0VRzhrMr4v5VivjhLqNdVn2bWfiMwtdMTTK
PayzTyZVXtTkLQleeDngbI2ymlOsQcp67OBaPY3Ud5kkZXY0Fg2ZlC15Tz0I
/Y3X4aa+260GqZ7Zs8ilJWIJz0eibn3QamuKLBqZqu4oMzEZc+6nAeupRvgs
Y4TeN3vUxFiCSidTSbcedR9GqZYNDV02RcPdfIrAJyDWp/B0myEWta909BmK
RB4VSmeo1g01pOqk3LSorPOLnc3ouLscl0myclrQ3f9jXPY3n7CXG78cez1f
Nrx0jBlpy7bKrno+lI4FZcbmIp/N4X1+ttj9qLFhet86HWr4csfG/G09b51f
9WK6S8/gk9nNKqyfYV4H+9DntCt4r8C8vI40D2XREDNjR6caTlCBYqhYszOq
dVWc6WwgFrX32Q2lGygSeVTUwwa6P0UF1/U6xjqMnwcDkdVXrRtJq9pjF+1x
MSv0tzwqnisbaZyiwrcbdNx6alVFhW8byXdDHaY4bqKKCaih8xsauu8miu9g
goZcbyJ09tHODrFa3kQsKSr2kjdSJHjulLPEV8mbKRJqXzkLU6s61m8X3y8u
IaWbKWcpB1bMNylHoStaA51vf7aYtG+m2kp5oLDk8V3c/Dx2bo1ZuIWqS/V6
5SI/WyKP57f9/q+fcmb42Gem+GQV8K1Eivb7PcPHGnIL1UCKj/1diW+NoZh/
f2efVeDMfStVsObL6xzdZmszrgyNWGmbrXs7U4AZtZWYUmQpOim98HIb8fdn
/YXibRQntUdf82htJ/8ZtZfe3055S1Gx4tpBvsRzmT7SsJ2Up2hQvoPu6sv6
CLYdpFzt8emFK99Jyhi1hzTtJOUpKqxmyZdeV95LmrLslS45S+Ne8pE/39yV
YY+ouDpL3HlUaNqV88L7FVBuJpZ4stFDynfl2B0NHCGHtdia5bJ25Wa+I5i/
8rCTELTzJDLgqmagq0SBQ0X18yDuoV2kYTd5b4z9ZDXbyoi0tWEMWrsJeTfl
JmVCRyEm+bH4L1wb4rSbaixlxByrMpqPC2HspDjtoYrRGFT68a4Ko/m4cEbM
5T0U1ZQRVrPNZH9eR0SrFdlJ0dlDMUzxYXULecFP2AZFYK+OcUaj9j6b8Xzf
S9x5VKg0ezyvgRr2E/v0XayjWXmDNJXsvhZNfcRp5q3Emd8DQvk+Uq723mlQ
R/tIeR4Vys2evinjqJhbt1F1xqc6Ky/ZfcVkaN109XbKOa9CaqT8dvKmkaDC
8zuarXM4f96ArmKoWO2lqMh16AS1Iv9NKI1jgo5PYfDZxZ06pp221yNW53uy
FWVrzvgJSGX/nOxtjQXr85QFcWOWsjZcK3eMDvL9TspjcrKbKL6lHYvHOa6Z
9YWlrzhAVVlLkKGKkeMaMz2R1Ds70w5p/h+IEfWdRcog8P4UzTEkZzxWknYv
rrqGg9Fbj5adcexvtn7WEZ/tYb3fUV7D9/Pu1rsOh7/d4qfQOZyy2ew/pON7
ValMPJn5okAMxFjmp31/8T51X3DD1xb1RzHbfNsxf7VY9B9enAhp\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->197617755]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Series expansion:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"EllipticTheta", "[", 
    RowBox[{"4", ",", " ", "0", ",", "q"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "0", ",", "100"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNV2FP2zAQdeOmTKO0KUNsaExNi+AD2r8Y2z7xIyo0CT4gJuAPbn8ss51z
cV/O7gWadpVa95x3796dz05yvXi+/XW/eL67WZQ/Hxe/b+9unsofD49mSveU
6v1RSo0/KfO/Mv/c137+mq9SM/OrzdRnGksYzyPjRWI+M+OA7IzsDy7a3P5q
r6ByUUO7XGOft7Qv3ug/ADsDe+KyUroe7MdeHBkzpxr0zbgHXjlcPwJ7uAZ/
AvakJf5ww/zHTNWsmcO8JnyfraKG2ZELtbSpxDk7y1VY6nvUAsutjNT3pAWW
q3gXcbhO+N/ywe7iUdhTmQjFd55F+f5unAasajn6fYfocYfogtC4p9Po3ev2
Z2v3XVOALTupZCeXbA/g6STjxnuwbAdvkhtPod3r3v6Zgzob3EzvvBP4fBRg
sG8kvKcCDOa0KV7sl13qfUOnAJOsTzB362W9w2dQCYbri9dguLp2hfmy7Vhr
11EznuzOFj7d8s9UB1X9PM37DElDwV7dr+r7X6iQRw4pikypj+orwHN65WH0
SZKvn8z1ALTlUaTPu7HTRNnhOls21Q9RHLed6zkG/9Y7qVbfrsdM9NS8U7cH
6khjQRisSagqxLkYgxecBxQRDZjdmInH1WoUwWFfeb5UjrFccqrvPo15ggPj
1iv0rarfRUtimCUYZsCAjNOEb0lxsjCOXs3QXp+uqVbZokpfX1WNkKEE26le
6X+by5ydPYMIsayRPwN1XOWxJ7utyhWpYqvRODPmVTzHpdbEdV8DrjbcPQf5
ttsx32F2Gqjy5/hy5Vd6REfWNd5R84Czse8a6FkEjfW+DHENFrph9f4BWS+8
bw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{449, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->497237067]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Evaluate numerically for complex arguments:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticTheta", "[", 
  RowBox[{"2", ",", 
   RowBox[{"3", "+", 
    RowBox[{"2.5", " ", "I"}]}], ",", 
   RowBox[{"0.3", " ", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"137.24943971232958`", "\[InvisibleSpace]", "+", 
  RowBox[{"196.76165797870385`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->858319935]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Evaluate to high precision:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"EllipticTheta", "[", 
    RowBox[{"2", ",", "4", ",", 
     RowBox[{"2", "/", "3"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"-", 
  "0.4522052633013633812303207097285656455372184556072449551865469264241`50."}\
]], "Output",
 ImageSize->{376, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->377429531]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3388656],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->739511185],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticTheta", "[", 
  RowBox[{"2", ",", "4", ",", "0.6666666666666666666666666666666666666"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->880174307],

Cell[BoxData[
 RowBox[{"-", 
  "0.452205263301363381230320709728565645684116967678`35.222088406579736"}]], \
"Output",
 ImageSize->{271, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->732729948]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticTheta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticTheta"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticTheta", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", "z", ",", "q"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"EllipticTheta", "[", 
    RowBox[{"1", ",", "z", ",", "q"}], "]"}], ",", 
   RowBox[{"EllipticTheta", "[", 
    RowBox[{"2", ",", "z", ",", "q"}], "]"}], ",", 
   RowBox[{"EllipticTheta", "[", 
    RowBox[{"3", ",", "z", ",", "q"}], "]"}], ",", 
   RowBox[{"EllipticTheta", "[", 
    RowBox[{"4", ",", "z", ",", "q"}], "]"}]}], "}"}]], "Output",
 ImageSize->{326, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->384903351]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticTheta", "[", 
  RowBox[{"2", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Pi", "/", "2"}], ",", "Pi"}], "}"}], ",", 
   RowBox[{"1", "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"EllipticTheta", "[", 
    RowBox[{"2", ",", "\[Pi]", ",", 
     FractionBox["1", "2"]}], "]"}]}], "}"}]], "Output",
 ImageSize->{190, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->355980128]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticTheta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticTheta"]], "InlineFormula"],
 " evaluates symbolically for special arguments:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"EllipticTheta", "[", 
    RowBox[{"j", ",", " ", "z", ",", "0"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->58785385]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticTheta", "[", 
  RowBox[{"1", ",", " ", "Pi", ",", 
   RowBox[{"1", "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->12081830]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting: "
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"EllipticTheta", "[", 
   RowBox[{"a", ",", "z", ",", "q"}], "]"}], " ", "//", " ", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["\[CurlyTheta]", "a"], "(", 
   RowBox[{"z", ",", "q"}], ")"}], TraditionalForm]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->184470101]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticTheta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticTheta"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticTheta", "[", 
  RowBox[{"2", ",", "z", ",", 
   RowBox[{"q", "-", 
    FractionBox[
     SuperscriptBox["q", "2"], "2"], "+", 
    FractionBox[
     SuperscriptBox["q", "3"], "9"], "+", 
    SuperscriptBox[
     RowBox[{"O", "[", "q", "]"}], "4"]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{"Cos", "[", "z", "]"}], " ", 
    SuperscriptBox["q", 
     RowBox[{"1", "/", "4"}]]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"Cos", "[", "z", "]"}], " ", 
    SuperscriptBox["q", 
     RowBox[{"5", "/", "4"}]]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"5", " ", 
        RowBox[{"Cos", "[", "z", "]"}]}], "576"], "+", 
      RowBox[{"2", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"3", " ", "z"}], "]"}]}]}], ")"}], " ", 
    SuperscriptBox["q", 
     RowBox[{"9", "/", "4"}]]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "q", "]"}], 
     RowBox[{"13", "/", "4"}]],
    SeriesData[$CellContext`q, 0, {}, 1, 13, 4],
    Editable->False]}],
  SeriesData[$CellContext`q, 0, {
   2 Cos[$CellContext`z], 0, 0, 0, Rational[-1, 4] Cos[$CellContext`z], 0, 0, 
    0, Rational[5, 576] Cos[$CellContext`z] + 2 Cos[3 $CellContext`z]}, 1, 13,
    4],
  Editable->False]], "Output",
 ImageSize->{420, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->532549836]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "Plot near the unit circle in the complex ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 " plane:"
}], "ExampleText",
 CellID->472588036],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"EllipticTheta", "[", 
     RowBox[{"1", ",", "0.5", ",", 
      RowBox[{"0.9", " ", 
       RowBox[{"Exp", "[", 
        RowBox[{"I", " ", "\[Phi]"}], "]"}]}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", 
     RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->45204487],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->66412631]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"EllipticTheta", "[", 
     RowBox[{"1", ",", "0.5", ",", 
      RowBox[{"0.99", " ", 
       RowBox[{"Exp", "[", 
        RowBox[{"I", " ", "\[Phi]"}], "]"}]}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", 
     RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3856954],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->591293514]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->40147986],

Cell[TextData[{
 "The number of representations of ",
 Cell[BoxData["n"], "InlineFormula"],
 " as a sum of four squares:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"SeriesCoefficient", "[", 
    RowBox[{
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"EllipticTheta", "[", 
         RowBox[{"3", ",", "0", ",", "q"}], "]"}], "^", "4"}], ",", 
       RowBox[{"{", 
        RowBox[{"q", ",", "0", ",", "n"}], "}"}]}], "]"}], ",", "n"}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "8", ",", "24", ",", "32", ",", "24", ",", "48", ",", "96", ",", "64", ",", 
   "24", ",", "104", ",", "144"}], "}"}]], "Output",
 ImageSize->{266, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->278496134]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Conformal map from an ellipse to the unit disk:", "ExampleText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"w", "[", 
   RowBox[{"z_", ",", 
    RowBox[{"{", 
     RowBox[{"a_", ",", "b_"}], "}"}]}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"q", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "-", "b"}], ")"}], "^", "2"}], "/", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", "b"}], ")"}], "^", "2"}]}]}], ",", 
      RowBox[{"e", "=", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}]}], "]"}]}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"EllipticTheta", "[", 
      RowBox[{"1", ",", 
       RowBox[{"ArcSin", "[", 
        RowBox[{"z", "/", "e"}], "]"}], ",", "q"}], "]"}], "/", 
     RowBox[{"EllipticTheta", "[", 
      RowBox[{"4", ",", 
       RowBox[{"ArcSin", "[", 
        RowBox[{"z", "/", "e"}], "]"}], ",", "q"}], "]"}]}]}], "]"}], 
  " "}]], "Input",
 CellLabel->"In[1]:="],

Cell["Visualize the map:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", 
      RowBox[{"w", "[", 
       RowBox[{
        RowBox[{"\[Rho]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}]}], " ", "+", " ", 
           RowBox[{"I", " ", 
            RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"Im", "[", 
      RowBox[{"w", "[", 
       RowBox[{
        RowBox[{"\[Rho]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}]}], "+", 
           RowBox[{"I", " ", 
            RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Rho]", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[CurlyPhi]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 217},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->193122496]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Dirichlet Green's function for the 1D heat equation:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x_", ",", "t_"}], "}"}], ",", "x0_", ",", "L_"}], "]"}], "=", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"2", "L"}], ")"}]}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"EllipticTheta", "[", 
       RowBox[{"3", ",", 
        RowBox[{
         RowBox[{"Pi", "/", 
          RowBox[{"(", 
           RowBox[{"2", "L"}], ")"}]}], " ", 
         RowBox[{"(", 
          RowBox[{"x", "-", "x0"}], ")"}]}], ",", 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Pi", "^", "2"}]}], "/", 
           RowBox[{"L", "^", "2"}]}], " ", "t"}], "]"}]}], "]"}], "-", 
      RowBox[{"EllipticTheta", "[", 
       RowBox[{"3", ",", 
        RowBox[{
         RowBox[{"Pi", "/", 
          RowBox[{"(", 
           RowBox[{"2", "L"}], ")"}]}], " ", 
         RowBox[{"(", 
          RowBox[{"x", "+", "x0"}], ")"}]}], ",", 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Pi", "^", "2"}]}], "/", 
           RowBox[{"L", "^", "2"}]}], " ", "t"}], "]"}]}], "]"}]}], ")"}]}]}],
   ";"}]], "Input",
 CellLabel->"In[1]:="],

Cell["\<\
Plot the time\[Hyphen]dependent temperature distribution:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "t"}], "}"}], ",", "0.6", ",", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0.01", ",", 
     RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->559319414],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->197897527]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Form Bloch functions of a one\[Hyphen]dimensional crystal with Gaussian \
orbitals:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Psi]", "[", 
   RowBox[{"\[ScriptK]_", ",", "x_", ",", "\[Phi]_"}], "]"}], ":=", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", "\[Pi]", " ", "\[Phi]", " ", 
      SuperscriptBox["x", "2"]}]], " ", 
    RowBox[{"EllipticTheta", "[", 
     RowBox[{"3", ",", 
      RowBox[{
       RowBox[{"\[Pi]", " ", "\[ScriptK]"}], "-", 
       RowBox[{
        FractionBox["1", "2"], " ", "\[Pi]", " ", "\[ImaginaryI]", " ", 
        "\[Phi]", " ", "x"}]}], ",", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], " ", "\[Phi]"}]]}], "]"}]}], 
   SqrtBox[
    RowBox[{
     FractionBox["2", "\[Phi]"], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"4", " ", 
         SuperscriptBox["\[ScriptK]", "2"], " ", "\[Pi]"}], "\[Phi]"]}]], 
     RowBox[{"EllipticTheta", "[", 
      RowBox[{"3", ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"4", " ", "\[ImaginaryI]", " ", "\[ScriptK]", " ", "\[Pi]"}],
          "\[Phi]"]}], ",", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"4", " ", "\[Pi]"}], "\[Phi]"]}]]}], "]"}]}]]]}]], "Input",
 CellLabel->"In[1]:="],

Cell["\<\
Plot Bloch functions as a function of the quasi\[Hyphen]wave vector:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"\[Psi]", "[", 
     RowBox[{"\[ScriptK]", ",", " ", "x", ",", " ", "1"}], "]"}], "]"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "12"}], ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[ScriptK]", ",", "0", ",", 
     RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{249, 204},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->180140059]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Electrostatic potential in a NaCl\[Hyphen]like crystal with pointlike ions:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CurlyPhi]", "[", 
   RowBox[{"{", 
    RowBox[{"x_", ",", " ", "y_", ",", " ", "z_"}], "}"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"16", "/", "Pi"}], " ", 
   RowBox[{"NIntegrate", "[", 
    RowBox[{
     RowBox[{"t", " ", 
      RowBox[{"EllipticTheta", "[", 
       RowBox[{"2", ",", 
        RowBox[{"2", " ", "Pi", " ", "x"}], ",", 
        RowBox[{"Exp", "[", 
         RowBox[{"-", 
          RowBox[{"t", "^", "2"}]}], "]"}]}], "]"}], 
      RowBox[{"EllipticTheta", "[", 
       RowBox[{"2", ",", 
        RowBox[{"2", " ", "Pi", " ", "y"}], ",", 
        RowBox[{"Exp", "[", 
         RowBox[{"-", 
          RowBox[{"t", "^", "2"}]}], "]"}]}], "]"}], 
      RowBox[{"EllipticTheta", "[", 
       RowBox[{"2", ",", 
        RowBox[{"2", " ", "Pi", " ", "z"}], ",", 
        RowBox[{"Exp", "[", 
         RowBox[{"-", 
          RowBox[{"t", "^", "2"}]}], "]"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Infinity]"}], "}"}]}], 
    "]"}]}]}]], "Input",
 CellLabel->"In[1]:="],

Cell["Plot the potential in a plane through the crystal:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListContourPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"\[CurlyPhi]", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "/", "10"}], ",", 
       RowBox[{"y", "/", "10"}], ",", "0.3"}], "}"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->157384148]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["A concise form of the Poisson summation formula:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["x", 
    RowBox[{"1", "/", "4"}]], " ", 
   RowBox[{"EllipticTheta", "[", 
    RowBox[{"3", ",", "0", ",", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[Pi]", " ", "x"}]]}], "]"}]}], "==", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", 
      RowBox[{"UnitStep", "[", 
       RowBox[{"Im", "[", "x", "]"}], "]"}]}], "-", "1"}], ")"}], "  ", "I", 
   " ", 
   SuperscriptBox["x", 
    RowBox[{
     RowBox[{"-", "1"}], "/", "4"}]], " ", 
   RowBox[{"EllipticTheta", "[", 
    RowBox[{"3", ",", "0", ",", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[Pi]", "/", "x"}]]}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["x", 
    RowBox[{"1", "/", "4"}]], " ", 
   RowBox[{"EllipticTheta", "[", 
    RowBox[{"3", ",", "0", ",", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[Pi]", " ", "x"}]]}], "]"}]}], "\[Equal]", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"EllipticTheta", "[", 
     RowBox[{"3", ",", "0", ",", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[Pi]", "/", "x"}]]}], "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"UnitStep", "[", 
        RowBox[{"Im", "[", "x", "]"}], "]"}]}]}], ")"}]}], 
   SuperscriptBox["x", 
    RowBox[{"1", "/", "4"}]]]}]], "Output",
 ImageSize->{548, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->68982196]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", " ", "/.", 
  RowBox[{"x", "->", 
   RowBox[{"-", " ", "2."}]}]}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->138724319]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Numerically find a root of a transcendental equation:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"EllipticTheta", "[", 
       RowBox[{"1", ",", "z", ",", 
        RowBox[{"1", "/", "3"}]}], "]"}], "3"], "+", 
     RowBox[{"EllipticTheta", "[", 
      RowBox[{"3", ",", "z", ",", 
       RowBox[{"1", "/", "3"}]}], "]"}], "+", "z"}], "\[Equal]", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", "0.4715180565507052`"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->81269891]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sum"]], "InlineFormula"],
 " can generate elliptic theta functions:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "^", "n"}], " ", 
    RowBox[{"q", "^", 
     RowBox[{"(", 
      RowBox[{"n", "^", "2"}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"EllipticTheta", "[", 
     RowBox[{"4", ",", "0", ",", "q"}], "]"}]}], ")"}]}]], "Output",
 ImageSize->{208, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->374000481]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4682],

Cell["\<\
Machine-precision input is insufficient to give a correct answer:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticTheta", "[", 
  RowBox[{"1", ",", 
   RowBox[{"10.", "^", "30"}], ",", 
   RowBox[{"1", "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"-", "1.0215674528499898`"}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->197773920]
}, Open  ]],

Cell["\<\
Use arbitrary-precision arithmetic to obtain the correct result:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"EllipticTheta", "[", 
    RowBox[{"1", ",", 
     RowBox[{"10", "^", "30"}], ",", 
     RowBox[{"1", "/", "2"}]}], "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"-", "0.05033734468593828794245386880585168936`20."}]], "Output",
 ImageSize->{173, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6029256]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticTheta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticTheta"]], "InlineFormula"],
 " has the attribute ",
 Cell[BoxData[
  ButtonBox["NHoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NHoldFirst"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "EllipticTheta", "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Listable", ",", "NHoldFirst", ",", "Protected", ",", "ReadProtected"}], 
  "}"}]], "Output",
 ImageSize->{332, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->349143670]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Different argument conventions exist:", "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"EllipticTheta", "[", 
      RowBox[{"1", ",", "z", ",", 
       RowBox[{"1", "/", "2"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"EllipticTheta", "[", 
      RowBox[{"1", ",", 
       RowBox[{"z", "/", 
        RowBox[{"(", 
         RowBox[{"2", "Pi"}], ")"}]}], ",", 
       RowBox[{"1", "/", "2"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->205409889]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"EllipticTheta", "[", 
      RowBox[{"1", ",", "2", ",", "q"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"q", ",", "0.1", ",", " ", "0.8"}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"EllipticTheta", "[", 
      RowBox[{"1", ",", "2", ",", 
       RowBox[{"Exp", "[", 
        RowBox[{"I", " ", "Pi", " ", 
         RowBox[{"(", 
          RowBox[{"I", " ", "\[Tau]"}], ")"}]}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Tau]", ",", "0.1", ",", " ", "0.8"}], "}"}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->116952870]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Visualize a function with a boundary of analyticity:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"r", "=", "0.995"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"z_", "?", "NumberQ"}], "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Abs", "[", "z", "]"}], ">", "r"}], ",", "0", ",", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{
          RowBox[{"Arg", "[", 
           RowBox[{"EllipticTheta", "[", 
            RowBox[{"3", ",", " ", "1", ",", "z"}], "]"}], "]"}], "/", "2"}], 
         "]"}], "^", "2"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"qx", "+", 
        RowBox[{"I", " ", "qy"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"qx", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"qy", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"PlotPoints", " ", "->", " ", "30"}], ",", 
      RowBox[{"MaxRecursion", "->", "1"}], ",", 
      RowBox[{"Contours", "->", "60"}], ",", 
      RowBox[{"PlotRange", " ", "->", " ", "All"}], ",", 
      RowBox[{"Frame", "->", "False"}], ",", 
      RowBox[{"ContourLines", "->", "False"}], ",", 
      RowBox[{"RegionFunction", "->", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Norm", "[", 
           RowBox[{"{", 
            RowBox[{"#1", ",", "#2"}], "}"}], "]"}], "<", "r"}], "&"}], 
        ")"}]}], ",", 
      RowBox[{"ColorFunction", "->", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Hue", "[", 
          RowBox[{"2.72", " ", "#"}], "]"}], "&"}], ")"}]}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->79340287]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"qr", " ", 
      RowBox[{"Cos", "[", "q\[Phi]", "]"}]}], ",", 
     RowBox[{"qr", " ", 
      RowBox[{"Sin", "[", "q\[Phi]", "]"}]}], ",", 
     RowBox[{"Abs", "[", 
      RowBox[{"EllipticTheta", "[", 
       RowBox[{"2", ",", "2", ",", 
        RowBox[{"qr", " ", 
         RowBox[{"Exp", "[", 
          RowBox[{"I", " ", "q\[Phi]"}], "]"}]}]}], "]"}], "]"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"q\[Phi]", ",", 
     RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"qr", ",", "0", ",", "0.99"}], "}"}], ",", " ", 
   RowBox[{"BoxRatios", "->", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "0.66"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->51025683]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18352],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ModularLambda",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ModularLambda"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DedekindEta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DedekindEta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["KleinInvariantJ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/KleinInvariantJ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticExp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticExp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticLog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticLog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SiegelTheta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SiegelTheta"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4934]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17639],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->19670]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->837860855],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->726760696],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->167929418],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->82287264],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->934599269],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->293227642]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
EllipticTheta"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EllipticTheta - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 40, 5.9639880}", "context" -> "System`", 
    "keywords" -> {
     "double-periodic function", "Jacobi theta 1", "Jacobi theta 2", 
      "Jacobi theta 3", "Jacobi theta 4", "theta1", "theta2", "theta3", 
      "theta4", "theta functions"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "EllipticTheta[a, u, q] gives the theta function \\[CurlyTheta]_a (u, q) \
(a = 1, ..., 4). ", "synonyms" -> {"elliptic theta"}, "title" -> 
    "EllipticTheta", "type" -> "Symbol", "uri" -> "ref/EllipticTheta"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9428, 322, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->298229711]},
 "XRef-2005-4-26-23-37-1.8558342"->{
  Cell[185381, 3872, 105, 1, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 243851, 5035},
 {"XRef-2005-4-26-23-37-1.8558342", 244008, 5039}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2986, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3609, 94, 51, 1, 70, "ObjectName",
 CellID->28333],
Cell[3663, 97, 920, 30, 70, "Usage",
 CellID->29465]
}, Open  ]],
Cell[CellGroupData[{
Cell[4620, 132, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5098, 149, 120, 4, 70, "Notes",
 CellID->20640],
Cell[5221, 155, 802, 29, 70, "Notes",
 CellID->27073],
Cell[6026, 186, 716, 26, 70, "Notes",
 CellID->8064501],
Cell[6745, 214, 575, 21, 70, "Notes",
 CellID->20590732],
Cell[7323, 237, 666, 24, 70, "Notes",
 CellID->13828035],
Cell[7992, 263, 310, 10, 70, "Notes",
 CellID->5025318],
Cell[8305, 275, 380, 14, 70, "Notes",
 CellID->3298577],
Cell[8688, 291, 258, 8, 70, "Notes",
 CellID->290233170],
Cell[8949, 301, 228, 7, 70, "Notes",
 CellID->31226],
Cell[9180, 310, 211, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[9428, 322, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->298229711],
Cell[CellGroupData[{
Cell[9813, 336, 147, 5, 70, "ExampleSection",
 CellID->33261311],
Cell[CellGroupData[{
Cell[9985, 345, 152, 4, 28, "Input"],
Cell[10140, 351, 175, 5, 36, "Output",
 CellID->21561431]
}, Open  ]],
Cell[10330, 359, 105, 2, 70, "ExampleDelimiter"],
Cell[CellGroupData[{
Cell[10460, 365, 290, 9, 28, "Input"],
Cell[10753, 376, 3376, 59, 131, "Output",
 Evaluatable->False,
 CellID->197617755]
}, Open  ]],
Cell[14144, 438, 105, 2, 70, "ExampleDelimiter"],
Cell[14252, 442, 177, 4, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[14454, 450, 247, 7, 28, "Input"],
Cell[14704, 459, 1070, 22, 36, "Output",
 Evaluatable->False,
 CellID->497237067]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15823, 487, 200, 6, 70, "ExampleSection"],
Cell[16026, 495, 66, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[16117, 499, 199, 6, 70, "Input"],
Cell[16319, 507, 273, 7, 36, "Output",
 CellID->858319935]
}, Open  ]],
Cell[16607, 517, 105, 2, 70, "ExampleDelimiter"],
Cell[16715, 521, 187, 4, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[16927, 529, 203, 6, 70, "Input"],
Cell[17133, 537, 253, 8, 36, "Output",
 CellID->377429531]
}, Open  ]],
Cell[17401, 548, 123, 3, 70, "ExampleDelimiter",
 CellID->3388656],
Cell[17527, 553, 113, 3, 70, "ExampleText",
 CellID->739511185],
Cell[CellGroupData[{
Cell[17665, 560, 183, 5, 70, "Input",
 CellID->880174307],
Cell[17851, 567, 249, 8, 36, "Output",
 CellID->732729948]
}, Open  ]],
Cell[18115, 578, 105, 2, 70, "ExampleDelimiter"],
Cell[18223, 582, 337, 10, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[18585, 596, 194, 6, 70, "Input"],
Cell[18782, 604, 528, 15, 54, "Output",
 CellID->384903351]
}, Open  ]],
Cell[CellGroupData[{
Cell[19347, 624, 223, 7, 70, "Input"],
Cell[19573, 633, 308, 10, 51, "Output",
 CellID->355980128]
}, Open  ]],
Cell[19896, 646, 105, 2, 70, "ExampleDelimiter"],
Cell[20004, 650, 350, 10, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[20379, 664, 234, 7, 70, "Input"],
Cell[20616, 673, 222, 7, 36, "Output",
 CellID->58785385]
}, Open  ]],
Cell[CellGroupData[{
Cell[20875, 685, 152, 4, 70, "Input"],
Cell[21030, 691, 157, 5, 36, "Output",
 CellID->12081830]
}, Open  ]],
Cell[21202, 699, 105, 2, 70, "ExampleDelimiter"],
Cell[21310, 703, 321, 10, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[21656, 717, 174, 5, 70, "Input"],
Cell[21833, 724, 290, 9, 50, "Output",
 CellID->184470101]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22172, 739, 223, 6, 70, "ExampleSection"],
Cell[22398, 747, 201, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[22624, 757, 323, 10, 70, "Input"],
Cell[22950, 769, 1187, 38, 51, "Output",
 CellID->532549836]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24186, 813, 207, 6, 70, "ExampleSection"],
Cell[24396, 821, 168, 6, 70, "ExampleText",
 CellID->472588036],
Cell[CellGroupData[{
Cell[24589, 831, 417, 13, 70, "Input",
 CellID->45204487],
Cell[25009, 846, 4335, 75, 70, "Output",
 Evaluatable->False,
 CellID->66412631]
}, Open  ]],
Cell[CellGroupData[{
Cell[29381, 926, 417, 13, 70, "Input",
 CellID->3856954],
Cell[29801, 941, 8679, 146, 70, "Output",
 Evaluatable->False,
 CellID->591293514]
}, Open  ]],
Cell[38495, 1090, 124, 3, 70, "ExampleDelimiter",
 CellID->40147986],
Cell[38622, 1095, 277, 8, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[38924, 1107, 495, 15, 70, "Input"],
Cell[39422, 1124, 302, 9, 36, "Output",
 CellID->278496134]
}, Open  ]],
Cell[39739, 1136, 105, 2, 70, "ExampleDelimiter"],
Cell[39847, 1140, 70, 0, 70, "ExampleText"],
Cell[39920, 1142, 999, 33, 70, "Input"],
Cell[40922, 1177, 41, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[40988, 1181, 1157, 34, 70, "Input"],
Cell[42148, 1217, 27504, 455, 70, "Output",
 Evaluatable->False,
 CellID->193122496]
}, Open  ]],
Cell[69667, 1675, 105, 2, 70, "ExampleDelimiter"],
Cell[69775, 1679, 212, 4, 70, "ExampleText"],
Cell[69990, 1685, 1267, 42, 70, "Input"],
Cell[71260, 1729, 225, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[71510, 1739, 401, 13, 70, "Input",
 CellID->559319414],
Cell[71914, 1754, 13088, 219, 70, "Output",
 Evaluatable->False,
 CellID->197897527]
}, Open  ]],
Cell[85017, 1976, 105, 2, 70, "ExampleDelimiter"],
Cell[85125, 1980, 251, 7, 70, "ExampleText"],
Cell[85379, 1989, 1371, 40, 70, "Input"],
Cell[86753, 2031, 236, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[87014, 2041, 415, 13, 70, "Input"],
Cell[87432, 2056, 55479, 914, 70, "Output",
 Evaluatable->False,
 CellID->180140059]
}, Open  ]],
Cell[142926, 2973, 105, 2, 70, "ExampleDelimiter"],
Cell[143034, 2977, 243, 6, 70, "ExampleText"],
Cell[143280, 2985, 1051, 31, 70, "Input"],
Cell[144334, 3018, 210, 4, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[144569, 3026, 490, 15, 70, "Input"],
Cell[145062, 3043, 33275, 550, 70, "Output",
 Evaluatable->False,
 CellID->157384148]
}, Open  ]],
Cell[178352, 3596, 105, 2, 70, "ExampleDelimiter"],
Cell[178460, 3600, 208, 4, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[178693, 3608, 704, 23, 70, "Input"],
Cell[179400, 3633, 852, 27, 57, "Output",
 CellID->68982196]
}, Open  ]],
Cell[CellGroupData[{
Cell[180289, 3665, 127, 4, 70, "Input"],
Cell[180419, 3671, 161, 5, 36, "Output",
 CellID->138724319]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[180629, 3682, 217, 6, 70, "ExampleSection"],
Cell[180849, 3690, 76, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[180950, 3694, 468, 14, 70, "Input"],
Cell[181421, 3710, 226, 7, 36, "Output",
 CellID->81269891]
}, Open  ]],
Cell[181662, 3720, 105, 2, 70, "ExampleDelimiter"],
Cell[181770, 3724, 323, 10, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[182118, 3738, 333, 12, 70, "Input"],
Cell[182454, 3752, 347, 12, 51, "Output",
 CellID->374000481]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[182850, 3770, 225, 7, 70, "ExampleSection",
 CellID->4682],
Cell[183078, 3779, 233, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[183336, 3789, 173, 5, 70, "Input"],
Cell[183512, 3796, 193, 6, 36, "Output",
 CellID->197773920]
}, Open  ]],
Cell[183720, 3805, 232, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[183977, 3815, 231, 7, 70, "Input"],
Cell[184211, 3824, 217, 6, 36, "Output",
 CellID->6029256]
}, Open  ]],
Cell[184443, 3833, 105, 2, 70, "ExampleDelimiter"],
Cell[184551, 3837, 315, 11, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[184891, 3852, 98, 2, 70, "Input"],
Cell[184992, 3856, 266, 9, 36, "Output",
 CellID->349143670]
}, Open  ]],
Cell[185273, 3868, 105, 2, 70, "ExampleDelimiter"],
Cell[185381, 3872, 105, 1, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],
Cell[CellGroupData[{
Cell[185511, 3877, 705, 22, 70, "Input"],
Cell[186219, 3901, 4422, 77, 70, "Output",
 Evaluatable->False,
 CellID->205409889]
}, Open  ]],
Cell[CellGroupData[{
Cell[190678, 3983, 689, 21, 70, "Input"],
Cell[191370, 4006, 4165, 72, 70, "Output",
 Evaluatable->False,
 CellID->116952870]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[195584, 4084, 208, 6, 70, "ExampleSection"],
Cell[195795, 4092, 212, 4, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[196032, 4100, 1798, 52, 70, "Input"],
Cell[197833, 4154, 8125, 137, 70, "Output",
 Evaluatable->False,
 CellID->79340287]
}, Open  ]],
Cell[CellGroupData[{
Cell[205995, 4296, 804, 24, 70, "Input"],
Cell[206802, 4322, 31533, 521, 70, "Output",
 Evaluatable->False,
 CellID->51025683]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[238396, 4850, 311, 9, 70, "SeeAlsoSection",
 CellID->18352],
Cell[238710, 4861, 1478, 53, 70, "SeeAlso",
 CellID->4934]
}, Open  ]],
Cell[CellGroupData[{
Cell[240225, 4919, 314, 9, 70, "TutorialsSection",
 CellID->17639],
Cell[240542, 4930, 192, 4, 70, "Tutorials",
 CellID->19670]
}, Open  ]],
Cell[CellGroupData[{
Cell[240771, 4939, 319, 9, 70, "MoreAboutSection",
 CellID->837860855],
Cell[241093, 4950, 147, 3, 70, "MoreAbout",
 CellID->726760696],
Cell[241243, 4955, 155, 3, 70, "MoreAbout",
 CellID->167929418],
Cell[241401, 4960, 161, 3, 70, "MoreAbout",
 CellID->82287264],
Cell[241565, 4965, 137, 3, 70, "MoreAbout",
 CellID->934599269],
Cell[241705, 4970, 145, 3, 70, "MoreAbout",
 CellID->293227642]
}, Open  ]],
Cell[CellGroupData[{
Cell[241887, 4978, 305, 8, 70, "RelatedLinksSection"],
Cell[242195, 4988, 391, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[242601, 5004, 27, 0, 70, "History"],
Cell[242631, 5006, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

