(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    251803,       5107]
NotebookOptionsPosition[    242577,       4789]
NotebookOutlinePosition[    244098,       4831]
CellTagsIndexPosition[    243960,       4825]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EllipticTheta" :> 
          Documentation`HelpLookup["paclet:ref/EllipticTheta"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"EllipticTheta\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Elliptic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EllipticThetaPrime", "ObjectName",
 CellID->9409],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["EllipticThetaPrime",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/EllipticThetaPrime"], "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["u", "TI"], ",", 
        StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the derivative with respect to ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " of the theta function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["\[CurlyTheta]", "a"], "(", 
        RowBox[{"u", ",", "q"}], ")"}], TraditionalForm]], "InlineMath"],
     " (",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"a", "=", "1"}], ",", "\[Ellipsis]", ",", "4"}], 
       TraditionalForm]], "InlineMath"],
     "). "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16772]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["EllipticThetaPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticThetaPrime"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->97661197],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticThetaPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticThetaPrime"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticThetaPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticThetaPrime"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->262715595],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->150710694],

Cell["Evaluate numerically:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->133493648],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticThetaPrime", "[", 
  RowBox[{"2", ",", "2.3", ",", 
   RowBox[{"1", "/", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->294689000],

Cell[BoxData[
 RowBox[{"-", "1.4171071758203504`"}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->788300114]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->208026797],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"EllipticThetaPrime", "[", 
    RowBox[{"2", ",", "x", ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "6"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->138555544],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->368359619]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->279107200],

Cell["Series expansion:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->62645436],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"EllipticThetaPrime", "[", 
    RowBox[{"1", ",", "x", ",", "q"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28879004],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    SuperscriptBox["q", 
     RowBox[{"1", "/", "4"}]]}], "-", 
   RowBox[{"6", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"3", " ", "x"}], "]"}], " ", 
    SuperscriptBox["q", 
     RowBox[{"9", "/", "4"}]]}], "+", 
   RowBox[{"10", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"5", " ", "x"}], "]"}], " ", 
    SuperscriptBox["q", 
     RowBox[{"25", "/", "4"}]]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "q", "]"}], 
     RowBox[{"41", "/", "4"}]],
    SeriesData[$CellContext`q, 0, {}, 1, 41, 4],
    Editable->False]}],
  SeriesData[$CellContext`q, 0, {
   2 Cos[$CellContext`x], 0, 0, 0, 0, 0, 0, 0, (-6) Cos[3 $CellContext`x], 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10 Cos[5 $CellContext`x]}, 1, 
   41, 4],
  Editable->False]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{355, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->60152370]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->400558285],

Cell["Evaluate numerically for complex arguments:", "ExampleText",
 CellID->343325960],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticThetaPrime", "[", 
  RowBox[{"2", ",", 
   RowBox[{"3", "+", 
    RowBox[{"2.5", " ", "I"}]}], ",", 
   RowBox[{"0.3", " ", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->79019813],

Cell[BoxData[
 RowBox[{"795.1888955613994`", "\[InvisibleSpace]", "-", 
  RowBox[{"547.1113929392978`", " ", "\[ImaginaryI]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->249384895]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->631840797],

Cell["Evaluate to high precision:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->51044900],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"EllipticThetaPrime", "[", 
    RowBox[{"2", ",", "4", ",", 
     RowBox[{"2", "/", "3"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10346012],

Cell[BoxData["1.\
9148337270717004308888813522782263833336195982120452441806034365029`50."], \
"Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->270698764]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4668185],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->120883321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticThetaPrime", "[", 
  RowBox[{"2", ",", "4", ",", "0.66666666666666666666666666666666"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->337259340],

Cell[BoxData["1.914833727071700430888881352278241392917423637822`30.\
38740216398612"], "Output",
 ImageSize->{228, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->482073870]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->180401608],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticThetaPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticThetaPrime"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->348000296],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticThetaPrime", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", "z", ",", "q"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->62319027],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"EllipticThetaPrime", "[", 
    RowBox[{"1", ",", "z", ",", "q"}], "]"}], ",", 
   RowBox[{"EllipticThetaPrime", "[", 
    RowBox[{"2", ",", "z", ",", "q"}], "]"}], ",", 
   RowBox[{"EllipticThetaPrime", "[", 
    RowBox[{"3", ",", "z", ",", "q"}], "]"}], ",", 
   RowBox[{"EllipticThetaPrime", "[", 
    RowBox[{"4", ",", "z", ",", "q"}], "]"}]}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{396, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22302931]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticThetaPrime", "[", 
  RowBox[{"2", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Pi", "/", "2"}], ",", "Pi"}], "}"}], ",", 
   RowBox[{"1", "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->49595525],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"EllipticThetaPrime", "[", 
    RowBox[{"2", ",", 
     FractionBox["\[Pi]", "2"], ",", 
     FractionBox["1", "2"]}], "]"}], ",", "0"}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{229, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->403973719]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->45603933],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticThetaPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticThetaPrime"]], "InlineFormula"],
 " evaluates symbolically for special arguments:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->58128579],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"EllipticThetaPrime", "[", 
    RowBox[{"j", ",", " ", "z", ",", "0"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->399383430],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11449874]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->138545402],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting: "
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->71912863],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"EllipticThetaPrime", "[", 
   RowBox[{"3", ",", "z", ",", "q"}], "]"}], " ", "//", " ", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->171860489],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubsuperscriptBox[
    TagBox["\[CurlyTheta]",
     EllipticThetaPrime], "3", "\[Prime]"], "(", 
   RowBox[{"z", ",", "q"}], ")"}], TraditionalForm]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{42, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->498348549]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->840504613],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EllipticThetaPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticThetaPrime"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->474501127],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticThetaPrime", "[", 
  RowBox[{"2", ",", "z", ",", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "q"}], "]"}], "+", 
    SuperscriptBox[
     RowBox[{"O", "[", "q", "]"}], "4"]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3584952],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    RowBox[{"2", " ", 
     RowBox[{"Sin", "[", "z", "]"}], " ", 
     SuperscriptBox["q", 
      RowBox[{"1", "/", "4"}]]}]}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"Sin", "[", "z", "]"}], " ", 
    SuperscriptBox["q", 
     RowBox[{"5", "/", "4"}]]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"23", " ", 
         RowBox[{"Sin", "[", "z", "]"}]}], "192"]}], "-", 
      RowBox[{"6", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"3", " ", "z"}], "]"}]}]}], ")"}], " ", 
    SuperscriptBox["q", 
     RowBox[{"9", "/", "4"}]]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "q", "]"}], 
     RowBox[{"13", "/", "4"}]],
    SeriesData[$CellContext`q, 0, {}, 1, 13, 4],
    Editable->False]}],
  SeriesData[$CellContext`q, 
   0, {(-2) Sin[$CellContext`z], 0, 0, 0, Rational[1, 4] Sin[$CellContext`z], 
    0, 0, 0, Rational[-23, 192] Sin[$CellContext`z] - 6 
    Sin[3 $CellContext`z]}, 1, 13, 4],
  Editable->False]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{443, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->191857]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->479448484],

Cell[TextData[{
 "Solution of the 1D heat equation with Dirichlet boundary condition and \
initial condition ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"T", "(", 
     RowBox[{"x", ",", "0"}], ")"}], "=", 
    RowBox[{"\[Delta]", "(", 
     RowBox[{"x", "-", 
      SubscriptBox["x", "0"]}], ")"}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->25120583],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x_", ",", "t_"}], "}"}], ",", "x0_", ",", "L_"}], "]"}], "=", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"2", "L"}], ")"}]}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"EllipticTheta", "[", 
       RowBox[{"3", ",", 
        RowBox[{
         RowBox[{"Pi", "/", 
          RowBox[{"(", 
           RowBox[{"2", "L"}], ")"}]}], " ", 
         RowBox[{"(", 
          RowBox[{"x", "-", "x0"}], ")"}]}], ",", 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Pi", "^", "2"}]}], "/", 
           RowBox[{"L", "^", "2"}]}], " ", "t"}], "]"}]}], "]"}], "-", 
      RowBox[{"EllipticTheta", "[", 
       RowBox[{"3", ",", 
        RowBox[{
         RowBox[{"Pi", "/", 
          RowBox[{"(", 
           RowBox[{"2", "L"}], ")"}]}], " ", 
         RowBox[{"(", 
          RowBox[{"x", "+", "x0"}], ")"}]}], ",", 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Pi", "^", "2"}]}], "/", 
           RowBox[{"L", "^", "2"}]}], " ", "t"}], "]"}]}], "]"}]}], ")"}]}]}],
   ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24714760],

Cell["Calculate the temperature gradient:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->5605209],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"gradT", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x_", ",", "t_"}], "}"}], ",", "x0_", ",", "L_"}], "]"}], "=", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "t"}], "}"}], ",", "x0", ",", "L"}], "]"}], ",", 
    "x"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->50181466],

Cell[BoxData[
 FractionBox[
  RowBox[{
   FractionBox[
    RowBox[{"\[Pi]", " ", 
     RowBox[{"EllipticThetaPrime", "[", 
      RowBox[{"3", ",", 
       FractionBox[
        RowBox[{"\[Pi]", " ", 
         RowBox[{"(", 
          RowBox[{"x", "-", "x0"}], ")"}]}], 
        RowBox[{"2", " ", "L"}]], ",", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["\[Pi]", "2"], " ", "t"}], 
          SuperscriptBox["L", "2"]]}]]}], "]"}]}], 
    RowBox[{"2", " ", "L"}]], "-", 
   FractionBox[
    RowBox[{"\[Pi]", " ", 
     RowBox[{"EllipticThetaPrime", "[", 
      RowBox[{"3", ",", 
       FractionBox[
        RowBox[{"\[Pi]", " ", 
         RowBox[{"(", 
          RowBox[{"x", "+", "x0"}], ")"}]}], 
        RowBox[{"2", " ", "L"}]], ",", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["\[Pi]", "2"], " ", "t"}], 
          SuperscriptBox["L", "2"]]}]]}], "]"}]}], 
    RowBox[{"2", " ", "L"}]]}], 
  RowBox[{"2", " ", "L"}]]], "Output",
 ImageSize->{421, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->562821391]
}, Open  ]],

Cell["Plot the temperature gradient:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->23206133],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"gradT", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "t"}], "}"}], ",", "0.6", ",", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0.01", ",", "0.1"}], "}"}], ",", 
   RowBox[{"PlotRange", " ", "->", " ", "All"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->210231804],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 233},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->626790144]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->74996794],

Cell["\<\
Electrostatic force in a NaCl\[Hyphen]like crystal with point\[Hyphen]like \
ions:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->5884973],

Cell[BoxData[
 RowBox[{
  RowBox[{"fNaCl", "[", 
   RowBox[{"{", 
    RowBox[{"x_", ",", " ", "y_", ",", " ", "z_"}], "}"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"16", "/", "Pi"}], " ", 
   RowBox[{"NIntegrate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", " ", "\[Pi]", " ", "t", " ", 
        RowBox[{"EllipticTheta", "[", 
         RowBox[{"2", ",", 
          RowBox[{"2", " ", "\[Pi]", " ", "y"}], ",", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            SuperscriptBox["t", "2"]}]]}], "]"}], " ", 
        RowBox[{"EllipticTheta", "[", 
         RowBox[{"2", ",", 
          RowBox[{"2", " ", "\[Pi]", " ", "z"}], ",", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            SuperscriptBox["t", "2"]}]]}], "]"}], 
        RowBox[{"EllipticThetaPrime", "[", 
         RowBox[{"2", ",", 
          RowBox[{"2", " ", "\[Pi]", " ", "x"}], ",", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            SuperscriptBox["t", "2"]}]]}], "]"}]}], ",", 
       RowBox[{"2", " ", "\[Pi]", " ", "t", " ", 
        RowBox[{"EllipticTheta", "[", 
         RowBox[{"2", ",", 
          RowBox[{"2", " ", "\[Pi]", " ", "x"}], ",", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            SuperscriptBox["t", "2"]}]]}], "]"}], 
        RowBox[{"EllipticTheta", "[", 
         RowBox[{"2", ",", 
          RowBox[{"2", " ", "\[Pi]", " ", "z"}], ",", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            SuperscriptBox["t", "2"]}]]}], "]"}], " ", 
        RowBox[{"EllipticThetaPrime", "[", 
         RowBox[{"2", ",", 
          RowBox[{"2", " ", "\[Pi]", " ", "y"}], ",", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            SuperscriptBox["t", "2"]}]]}], "]"}]}], ",", 
       RowBox[{"2", " ", "\[Pi]", " ", "t", " ", 
        RowBox[{"EllipticTheta", "[", 
         RowBox[{"2", ",", 
          RowBox[{"2", " ", "\[Pi]", " ", "x"}], ",", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            SuperscriptBox["t", "2"]}]]}], "]"}], " ", 
        RowBox[{"EllipticTheta", "[", 
         RowBox[{"2", ",", 
          RowBox[{"2", " ", "\[Pi]", " ", "y"}], ",", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            SuperscriptBox["t", "2"]}]]}], "]"}], 
        RowBox[{"EllipticThetaPrime", "[", 
         RowBox[{"2", ",", 
          RowBox[{"2", " ", "\[Pi]", " ", "z"}], ",", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            SuperscriptBox["t", "2"]}]]}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"PrecisionGoal", "\[Rule]", "2"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->415565633],

Cell["\<\
Plot the magnitude of the force in a plane through the crystal:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->7548498],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ListPlot3D", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Norm", "[", 
      RowBox[{"fNaCl", "[", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "0.3"}], "}"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1", ",", 
       RowBox[{"1", "/", "10"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "1", ",", 
       RowBox[{"1", "/", "10"}]}], "}"}]}], "]"}], "]"}], "//", 
  "Quiet"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->351150088],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1W12sXFUVnk7be6ftANPOTO/09pzeOTPnHqkGjEQLtKWzsPb2h4JSUDTG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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmAn8T1Uaxu85F0VEiey7rGVfsytLdqm0SFQkZAllVBohFU2FRIsaJU0L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         "]], Polygon3DBox[CompressedData["
1:eJwtmHccF8URxXfnRJTYC4gBFFFAERWkKKAiShVQsGAXrBFLNMbeSxKNMUaM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         "]], Polygon3DBox[CompressedData["
1:eJwtlnmcj1UUh3/v/Y2xhSQymBga+1qWyZixZAbZjTIiSrayTHbJvpZhMnZj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         "]]}]}, {}, {}, {}}, {
     Line3DBox[{122, 1, 417, 12, 429, 430, 23, 450, 34, 462, 463, 45, 483, 56,
       494, 67, 506, 507, 78, 527, 89, 539, 540, 100, 560, 111, 262, 112, 263,
       264, 113, 265, 114, 266, 267, 115, 268, 116, 269, 117, 270, 271, 118, 
      272, 119, 273, 274, 120, 275, 121, 569, 110, 558, 557, 99, 536, 88, 525,
       524, 77, 503, 66, 492, 55, 481, 480, 44, 459, 33, 448, 447, 22, 426, 
      11, 148, 10, 145, 144, 9, 142, 8, 139, 138, 7, 136, 6, 134, 5, 131, 130,
       4, 128, 3, 125, 124, 2, 122}], {
      Line3DBox[{417, 276, 416, 682, 610, 766, 418, 683, 570, 419, 684, 611, 
       767, 420, 685, 571, 421, 283, 422, 686, 612, 768, 423, 687, 572, 424, 
       688, 613, 769, 425, 689, 573, 426}], 
      Line3DBox[{430, 690, 574, 428, 691, 292, 432, 692, 575, 434, 694, 695, 
       576, 436, 696, 577, 438, 697, 578, 440, 698, 299, 442, 699, 579, 444, 
       701, 702, 580, 446, 703, 581, 448}], 
      Line3DBox[{447, 779, 621, 445, 778, 620, 700, 443, 777, 619, 441, 776, 
       298, 439, 775, 618, 437, 774, 617, 435, 773, 616, 693, 433, 772, 615, 
       431, 771, 291, 427, 770, 614, 429}], 
      Line3DBox[{450, 622, 780, 449, 704, 623, 781, 451, 307, 452, 705, 624, 
       782, 453, 706, 582, 454, 625, 783, 455, 707, 626, 784, 456, 314, 457, 
       708, 627, 785, 458, 709, 583, 459}], 
      Line3DBox[{463, 710, 584, 461, 711, 630, 789, 465, 712, 585, 467, 713, 
       323, 469, 714, 586, 471, 715, 587, 473, 716, 635, 796, 475, 717, 588, 
       477, 718, 330, 479, 719, 589, 481}], 
      Line3DBox[{480, 799, 637, 478, 798, 329, 476, 797, 636, 474, 795, 794, 
       634, 472, 793, 633, 470, 792, 632, 468, 791, 322, 466, 790, 631, 464, 
       788, 787, 629, 460, 786, 628, 462}], 
      Line3DBox[{56, 192, 57, 193, 194, 58, 195, 59, 196, 197, 60, 198, 61, 
       199, 62, 200, 201, 63, 202, 64, 203, 204, 65, 205, 66}], 
      Line3DBox[{483, 638, 800, 482, 720, 639, 801, 484, 640, 802, 485, 721, 
       641, 803, 486, 338, 487, 642, 804, 488, 722, 643, 805, 489, 644, 806, 
       490, 723, 645, 807, 491, 345, 492}], 
      Line3DBox[{494, 346, 493, 724, 646, 808, 495, 725, 590, 496, 726, 647, 
       809, 497, 727, 591, 498, 353, 499, 728, 648, 810, 500, 729, 592, 501, 
       730, 649, 811, 502, 731, 593, 503}], 
      Line3DBox[{507, 732, 594, 505, 733, 362, 509, 734, 595, 511, 736, 737, 
       596, 513, 738, 597, 515, 739, 598, 517, 740, 369, 519, 741, 599, 521, 
       743, 744, 600, 523, 745, 601, 525}], 
      Line3DBox[{524, 821, 657, 522, 820, 656, 742, 520, 819, 655, 518, 818, 
       368, 516, 817, 654, 514, 816, 653, 512, 815, 652, 735, 510, 814, 651, 
       508, 813, 361, 504, 812, 650, 506}], 
      Line3DBox[{527, 658, 822, 526, 746, 659, 823, 528, 377, 529, 747, 660, 
       824, 530, 748, 602, 531, 661, 825, 532, 749, 662, 826, 533, 384, 534, 
       750, 663, 827, 535, 751, 603, 536}], 
      Line3DBox[{540, 752, 604, 538, 753, 666, 831, 542, 754, 605, 544, 755, 
       393, 546, 756, 606, 548, 757, 607, 550, 758, 671, 838, 552, 759, 608, 
       554, 760, 400, 556, 761, 609, 558}], 
      Line3DBox[{557, 841, 673, 555, 840, 399, 553, 839, 672, 551, 837, 836, 
       670, 549, 835, 669, 547, 834, 668, 545, 833, 392, 543, 832, 667, 541, 
       830, 829, 665, 537, 828, 664, 539}], 
      Line3DBox[{560, 674, 842, 559, 762, 675, 843, 561, 676, 844, 562, 763, 
       677, 845, 563, 408, 564, 678, 846, 565, 764, 679, 847, 566, 680, 848, 
       567, 765, 681, 849, 568, 415, 569}]}, {
      Line3DBox[{122, 276, 123, 770, 290, 690, 150, 780, 304, 164, 786, 318, 
       710, 178, 800, 332, 192, 346, 206, 812, 360, 732, 220, 822, 374, 234, 
       828, 388, 752, 248, 842, 402, 262}], 
      Line3DBox[{124, 277, 682, 126, 291, 691, 151, 305, 704, 165, 787, 319, 
       711, 179, 333, 720, 193, 347, 724, 207, 361, 733, 221, 375, 746, 235, 
       829, 389, 753, 249, 403, 762, 263}], 
      Line3DBox[{128, 279, 683, 129, 772, 293, 692, 153, 307, 167, 790, 321, 
       712, 181, 802, 335, 195, 349, 725, 209, 814, 363, 734, 223, 377, 237, 
       832, 391, 754, 251, 844, 405, 265}], 
      Line3DBox[{130, 280, 684, 132, 294, 693, 694, 154, 308, 705, 168, 322, 
       713, 182, 336, 721, 196, 350, 726, 210, 364, 735, 736, 224, 378, 747, 
       238, 392, 755, 252, 406, 763, 266}], 
      Line3DBox[{134, 282, 685, 135, 774, 296, 696, 156, 310, 706, 170, 792, 
       324, 714, 184, 338, 198, 352, 727, 212, 816, 366, 738, 226, 380, 748, 
       240, 834, 394, 756, 254, 408, 268}], 
      Line3DBox[{6, 421, 17, 437, 438, 28, 454, 39, 470, 471, 50, 487, 61, 
       498, 72, 514, 515, 83, 531, 94, 547, 548, 105, 564, 116}], 
      Line3DBox[{136, 283, 137, 775, 297, 697, 157, 783, 311, 171, 793, 325, 
       715, 185, 804, 339, 199, 353, 213, 817, 367, 739, 227, 825, 381, 241, 
       835, 395, 757, 255, 846, 409, 269}], 
      Line3DBox[{138, 284, 686, 140, 298, 698, 158, 312, 707, 172, 794, 326, 
       716, 186, 340, 722, 200, 354, 728, 214, 368, 740, 228, 382, 749, 242, 
       836, 396, 758, 256, 410, 764, 270}], 
      Line3DBox[{142, 286, 687, 143, 777, 300, 699, 160, 314, 174, 797, 328, 
       717, 188, 806, 342, 202, 356, 729, 216, 819, 370, 741, 230, 384, 244, 
       839, 398, 759, 258, 848, 412, 272}], 
      Line3DBox[{144, 287, 688, 146, 301, 700, 701, 161, 315, 708, 175, 329, 
       718, 189, 343, 723, 203, 357, 730, 217, 371, 742, 743, 231, 385, 750, 
       245, 399, 760, 259, 413, 765, 273}], 
      Line3DBox[{148, 289, 689, 149, 779, 303, 703, 163, 317, 709, 177, 799, 
       331, 719, 191, 345, 205, 359, 731, 219, 821, 373, 745, 233, 387, 751, 
       247, 841, 401, 761, 261, 415, 275}], 
      Line3DBox[{264, 404, 843, 250, 390, 831, 830, 236, 376, 823, 222, 362, 
       813, 208, 348, 808, 194, 334, 801, 180, 320, 789, 788, 166, 306, 781, 
       152, 292, 771, 127, 278, 766, 125}], 
      Line3DBox[{267, 407, 845, 253, 393, 833, 239, 379, 824, 225, 737, 365, 
       815, 211, 351, 809, 197, 337, 803, 183, 323, 791, 169, 309, 782, 155, 
       695, 295, 773, 133, 281, 767, 131}], 
      Line3DBox[{271, 411, 847, 257, 397, 838, 837, 243, 383, 826, 229, 369, 
       818, 215, 355, 810, 201, 341, 805, 187, 327, 796, 795, 173, 313, 784, 
       159, 299, 776, 141, 285, 768, 139}], 
      Line3DBox[{274, 414, 849, 260, 400, 840, 246, 386, 827, 232, 744, 372, 
       820, 218, 358, 811, 204, 344, 807, 190, 330, 798, 176, 316, 785, 162, 
       702, 302, 778, 147, 288, 769, 145}]}, {}, {}}},
   VertexNormals->CompressedData["
1:eJyVeglUjuvXfioyz2OniRKZZyJ2hIREpmSWMTPlkENpoDKEkFQnEgeZSYNy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    "]],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  ImageMargins->0.,
  ImageSize->{300, Automatic},
  Method->{
   "RotationControl" -> "Globe", "SpherePoints" -> Automatic, 
    "CylinderPoints" -> Automatic},
  PlotRange->{{1., 11.}, {1., 11.}, {0., 116.307453837571}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  ViewAngle->Automatic,
  ViewCenter->Automatic,
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0., 0., 1.}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{304, 235},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->154227288,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->928516537],

Cell[TextData[{
 "The canonical rotational distribution function for linear molecules ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[CapitalOmega]", "(", "\[Beta]", ")"}], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"j", "=", "0"}], "\[Infinity]"], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "j"}], "+", "1"}], ")"}], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[Beta]"}], " ", "j", " ", 
        RowBox[{"(", 
         RowBox[{"j", "+", "1"}], ")"}]}]]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->801701225],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalOmega]", "[", "\[Beta]_", "]"}], ":=", 
  RowBox[{
   FractionBox["1", "2"], "-", 
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
    RowBox[{
     RowBox[{
      FractionBox["1", 
       RowBox[{"8", " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox["t", 
         RowBox[{"3", "/", "2"}]]}]], 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "t"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", "t", " ", 
          RowBox[{"EllipticTheta", "[", 
           RowBox[{"3", ",", "0", ",", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"-", 
              FractionBox[
               RowBox[{"\[Beta]", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"4", " ", "t"}], "+", "\[Beta]"}], ")"}]}], 
               RowBox[{"4", " ", "t"}]]}]]}], "]"}]}], "+", 
         RowBox[{"\[Beta]", " ", 
          RowBox[{
           SuperscriptBox["EllipticThetaPrime", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"3", ",", "0", ",", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"-", 
              FractionBox[
               RowBox[{"\[Beta]", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"4", " ", "t"}], "+", "\[Beta]"}], ")"}]}], 
               RowBox[{"4", " ", "t"}]]}]]}], "]"}]}]}], ")"}]}]}], 
     RowBox[{"\[DifferentialD]", "t"}]}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->384039142],

Cell["Plot a numerical approximation of the partition function:", \
"ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->410633290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalOmega]", "[", "\[Beta]", "]"}], "/.", 
     RowBox[{
      RowBox[{"Integrate", "[", 
       RowBox[{"a_", ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "b_", ",", "c_"}], "}"}]}], "]"}], 
      "\[RuleDelayed]", 
      RowBox[{"NIntegrate", "[", 
       RowBox[{"a", ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"10", "^", 
           RowBox[{"-", "3"}]}], ",", "10"}], "}"}]}], "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Beta]", ",", 
      RowBox[{"1", "/", "4"}], ",", "3", ",", 
      RowBox[{"1", "/", "4"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15554230],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{2.42902603367869, 2.07597010861109}, {3., 1.7079585786641}, {4.,
      1.40060025233263}, {5., 1.23118093879244}, {6., 1.13213730153564}, {7., 
     1.07288920516434}, {8., 1.03713733523548}, {9., 1.0154937986162}, {10., 
     1.0023755250816}, {11., 0.99442096628793}, {12., 0.989596764737681}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  Axes->True,
  PlotRange->{{0., 12.}, {0.989596764737681, 2.07597010861109}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{184, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->639245297]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->667242018],

Cell["\<\
Machine-precision input is insufficient to give a correct answer:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->42269019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticThetaPrime", "[", 
  RowBox[{"1", ",", 
   RowBox[{"10.", "^", "30"}], ",", 
   RowBox[{"1", "/", "Pi"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->344907347],

Cell[BoxData["1.3643670368218006`"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->103442793]
}, Open  ]],

Cell["\<\
Use arbitrary-precision arithmetic to obtain the correct result:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->424743380],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"EllipticThetaPrime", "[", 
    RowBox[{"1", ",", 
     RowBox[{"10", "^", "30"}], ",", 
     RowBox[{"1", "/", "Pi"}]}], "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->256858139],

Cell[BoxData[
 RowBox[{"-", "1.0631618540330814986628966266079418782`20."}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{159, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->739680170]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->290423661],

Cell["\<\
The first argument must be an explicit integer between 1 and 4:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->44290551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticThetaPrime", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"E", "+", "1"}], ")"}], "^", "2"}], "-", 
    RowBox[{"E", "^", "2"}], "-", 
    RowBox[{"2", "E"}], "-", "1"}], ",", "3.", ",", 
   RowBox[{"1", "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->98154720],

Cell[BoxData[
 RowBox[{"EllipticThetaPrime", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", "\[ExponentialE]"}], "-", 
    SuperscriptBox["\[ExponentialE]", "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "\[ExponentialE]"}], ")"}], "2"]}], ",", "3.`", ",", 
   FractionBox["1", "2"]}], "]"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{301, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->65819787]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->48102012],

Cell[BoxData[
 RowBox[{"-", "0.6139584271516076`"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->175691332]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->78777467],

Cell["Different argument conventions exist:", "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->196076998],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"EllipticThetaPrime", "[", 
      RowBox[{"1", ",", "z", ",", 
       RowBox[{"1", "/", "2"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"EllipticThetaPrime", "[", 
      RowBox[{"1", ",", 
       RowBox[{"z", "/", 
        RowBox[{"(", 
         RowBox[{"2", "Pi"}], ")"}]}], ",", 
       RowBox[{"1", "/", "2"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->656260729],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{386, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->156887301]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"EllipticThetaPrime", "[", 
      RowBox[{"1", ",", "2", ",", "q"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"q", ",", "0.1", ",", " ", "0.8"}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"EllipticThetaPrime", "[", 
      RowBox[{"1", ",", "2", ",", 
       RowBox[{"Exp", "[", 
        RowBox[{"I", " ", "Pi", " ", 
         RowBox[{"(", 
          RowBox[{"I", " ", "\[Tau]"}], ")"}]}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Tau]", ",", "0.1", ",", " ", "0.8"}], "}"}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->166177691],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{386, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->202050773]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->318493502],

Cell["Visualize a function with a boundary of analyticity:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->367011776],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"R", "=", "0.99"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"z_", "?", "NumberQ"}], "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Abs", "[", "z", "]"}], ">", "R"}], ",", "0", ",", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{
          RowBox[{"Arg", "[", 
           RowBox[{"EllipticThetaPrime", "[", 
            RowBox[{"2", ",", " ", "1", ",", "z"}], "]"}], "]"}], "/", "2"}], 
         "]"}], "^", "2"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"DensityPlot", "[", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"qx", "+", 
        RowBox[{"I", " ", "qy"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"qx", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"qy", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"Frame", "->", "False"}], ",", 
      RowBox[{"RegionFunction", "->", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Norm", "[", 
           RowBox[{"{", 
            RowBox[{"#1", ",", "#2"}], "}"}], "]"}], "<", "R"}], "&"}], 
        ")"}]}], ",", 
      RowBox[{"ColorFunction", "->", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Hue", "[", 
          RowBox[{"2.72", " ", "#"}], "]"}], "&"}], ")"}]}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->74486971],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->67806446]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3888],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["EllipticTheta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticTheta"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->12316]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1225],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->29187]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->62727260],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->166397526]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EllipticThetaPrime - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 40, 16.6986378}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "EllipticThetaPrime[a, u, q] gives the derivative with respect to u of \
the theta function \\[CurlyTheta]_a (u, q) (a = 1, ..., 4). ", 
    "synonyms" -> {"elliptic theta prime"}, "title" -> "EllipticThetaPrime", 
    "type" -> "Symbol", "uri" -> "ref/EllipticThetaPrime"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4945, 170, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->262715595]},
 "XRef-2005-4-26-23-37-1.8558342"->{
  Cell[166046, 3404, 125, 2, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342",
   CellID->196076998]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 243661, 4814},
 {"XRef-2005-4-26-23-37-1.8558342", 243818, 4818}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1818, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2441, 75, 55, 1, 70, "ObjectName",
 CellID->9409],
Cell[2499, 78, 1039, 33, 70, "Usage",
 CellID->16772]
}, Open  ]],
Cell[CellGroupData[{
Cell[3575, 116, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4053, 133, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4176, 139, 267, 8, 70, "Notes",
 CellID->97661197],
Cell[4446, 149, 238, 7, 70, "Notes",
 CellID->31226],
Cell[4687, 158, 221, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[4945, 170, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->262715595],
Cell[CellGroupData[{
Cell[5330, 184, 148, 5, 70, "ExampleSection",
 CellID->150710694],
Cell[5481, 191, 201, 5, 70, "ExampleText",
 CellID->133493648],
Cell[CellGroupData[{
Cell[5707, 200, 173, 5, 28, "Input",
 CellID->294689000],
Cell[5883, 207, 193, 6, 36, "Output",
 CellID->788300114]
}, Open  ]],
Cell[6091, 216, 125, 3, 70, "ExampleDelimiter",
 CellID->208026797],
Cell[CellGroupData[{
Cell[6241, 223, 310, 10, 28, "Input",
 CellID->138555544],
Cell[6554, 235, 4356, 75, 160, "Output",
 Evaluatable->False,
 CellID->368359619]
}, Open  ]],
Cell[10925, 313, 125, 3, 70, "ExampleDelimiter",
 CellID->279107200],
Cell[11053, 318, 196, 5, 70, "ExampleText",
 CellID->62645436],
Cell[CellGroupData[{
Cell[11274, 327, 265, 8, 70, "Input",
 CellID->28879004],
Cell[11542, 337, 1075, 34, 36, "Output",
 CellID->60152370]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12666, 377, 220, 7, 70, "ExampleSection",
 CellID->400558285],
Cell[12889, 386, 86, 1, 70, "ExampleText",
 CellID->343325960],
Cell[CellGroupData[{
Cell[13000, 391, 223, 7, 70, "Input",
 CellID->79019813],
Cell[13226, 400, 319, 9, 36, "Output",
 CellID->249384895]
}, Open  ]],
Cell[13560, 412, 125, 3, 70, "ExampleDelimiter",
 CellID->631840797],
Cell[13688, 417, 206, 5, 70, "ExampleText",
 CellID->51044900],
Cell[CellGroupData[{
Cell[13919, 426, 227, 7, 70, "Input",
 CellID->10346012],
Cell[14149, 435, 283, 9, 36, "Output",
 CellID->270698764]
}, Open  ]],
Cell[14447, 447, 123, 3, 70, "ExampleDelimiter",
 CellID->4668185],
Cell[14573, 452, 113, 3, 70, "ExampleText",
 CellID->120883321],
Cell[CellGroupData[{
Cell[14711, 459, 183, 5, 70, "Input",
 CellID->337259340],
Cell[14897, 466, 228, 6, 36, "Output",
 CellID->482073870]
}, Open  ]],
Cell[15140, 475, 125, 3, 70, "ExampleDelimiter",
 CellID->180401608],
Cell[15268, 480, 367, 11, 70, "ExampleText",
 CellID->348000296],
Cell[CellGroupData[{
Cell[15660, 495, 218, 7, 70, "Input",
 CellID->62319027],
Cell[15881, 504, 595, 17, 54, "Output",
 CellID->22302931]
}, Open  ]],
Cell[CellGroupData[{
Cell[16513, 526, 247, 8, 70, "Input",
 CellID->49595525],
Cell[16763, 536, 385, 13, 51, "Output",
 CellID->403973719]
}, Open  ]],
Cell[17163, 552, 124, 3, 70, "ExampleDelimiter",
 CellID->45603933],
Cell[17290, 557, 379, 11, 70, "ExampleText",
 CellID->58128579],
Cell[CellGroupData[{
Cell[17694, 572, 259, 8, 70, "Input",
 CellID->399383430],
Cell[17956, 582, 270, 9, 36, "Output",
 CellID->11449874]
}, Open  ]],
Cell[18241, 594, 125, 3, 70, "ExampleDelimiter",
 CellID->138545402],
Cell[18369, 599, 340, 11, 70, "ExampleText",
 CellID->71912863],
Cell[CellGroupData[{
Cell[18734, 614, 199, 6, 70, "Input",
 CellID->171860489],
Cell[18936, 622, 393, 13, 52, "Output",
 CellID->498348549]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19378, 641, 243, 7, 70, "ExampleSection",
 CellID->840504613],
Cell[19624, 650, 229, 7, 70, "ExampleText",
 CellID->474501127],
Cell[CellGroupData[{
Cell[19878, 661, 284, 9, 70, "Input",
 CellID->3584952],
Cell[20165, 672, 1286, 42, 51, "Output",
 CellID->191857]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21500, 720, 227, 7, 70, "ExampleSection",
 CellID->479448484],
Cell[21730, 729, 524, 17, 70, "ExampleText",
 CellID->25120583],
Cell[22257, 748, 1286, 43, 70, "Input",
 CellID->24714760],
Cell[23546, 793, 213, 5, 70, "ExampleText",
 CellID->5605209],
Cell[CellGroupData[{
Cell[23784, 802, 392, 14, 70, "Input",
 CellID->50181466],
Cell[24179, 818, 1237, 40, 84, "Output",
 CellID->562821391]
}, Open  ]],
Cell[25431, 861, 209, 5, 70, "ExampleText",
 CellID->23206133],
Cell[CellGroupData[{
Cell[25665, 870, 436, 13, 70, "Input",
 CellID->210231804],
Cell[26104, 885, 38728, 639, 70, "Output",
 Evaluatable->False,
 CellID->626790144]
}, Open  ]],
Cell[64847, 1527, 124, 3, 70, "ExampleDelimiter",
 CellID->74996794],
Cell[64974, 1532, 268, 8, 70, "ExampleText",
 CellID->5884973],
Cell[65245, 1542, 2857, 72, 70, "Input",
 CellID->415565633],
Cell[68105, 1616, 249, 7, 70, "ExampleText",
 CellID->7548498],
Cell[CellGroupData[{
Cell[68379, 1627, 548, 17, 70, "Input",
 CellID->351150088],
Cell[68930, 1646, 89011, 1468, 256, 35446, 584, "CachedBoxData", "BoxData", \
"Output",
 CellID->154227288]
}, Open  ]],
Cell[157956, 3117, 125, 3, 70, "ExampleDelimiter",
 CellID->928516537],
Cell[158084, 3122, 777, 25, 70, "ExampleText",
 CellID->801701225],
Cell[158864, 3149, 1731, 50, 70, "Input",
 CellID->384039142],
Cell[160598, 3201, 239, 6, 70, "ExampleText",
 CellID->410633290],
Cell[CellGroupData[{
Cell[160862, 3211, 755, 23, 70, "Input",
 CellID->15554230],
Cell[161620, 3236, 794, 20, 136, "Output",
 CellID->639245297]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[162463, 3262, 230, 7, 70, "ExampleSection",
 CellID->667242018],
Cell[162696, 3271, 252, 7, 70, "ExampleText",
 CellID->42269019],
Cell[CellGroupData[{
Cell[162973, 3282, 199, 6, 70, "Input",
 CellID->344907347],
Cell[163175, 3290, 224, 7, 36, "Output",
 CellID->103442793]
}, Open  ]],
Cell[163414, 3300, 252, 7, 70, "ExampleText",
 CellID->424743380],
Cell[CellGroupData[{
Cell[163691, 3311, 257, 8, 70, "Input",
 CellID->256858139],
Cell[163951, 3321, 266, 8, 36, "Output",
 CellID->739680170]
}, Open  ]],
Cell[164232, 3332, 125, 3, 70, "ExampleDelimiter",
 CellID->290423661],
Cell[164360, 3337, 250, 7, 70, "ExampleText",
 CellID->44290551],
Cell[CellGroupData[{
Cell[164635, 3348, 348, 11, 70, "Input",
 CellID->98154720],
Cell[164986, 3361, 534, 17, 51, "Output",
 CellID->65819787]
}, Open  ]],
Cell[CellGroupData[{
Cell[165557, 3383, 103, 3, 70, "Input",
 CellID->48102012],
Cell[165663, 3388, 241, 8, 36, "Output",
 CellID->175691332]
}, Open  ]],
Cell[165919, 3399, 124, 3, 70, "ExampleDelimiter",
 CellID->78777467],
Cell[166046, 3404, 125, 2, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->196076998],
Cell[CellGroupData[{
Cell[166196, 3410, 735, 23, 70, "Input",
 CellID->656260729],
Cell[166934, 3435, 4925, 86, 70, "Output",
 Evaluatable->False,
 CellID->156887301]
}, Open  ]],
Cell[CellGroupData[{
Cell[171896, 3526, 719, 22, 70, "Input",
 CellID->166177691],
Cell[172618, 3550, 4038, 71, 70, "Output",
 Evaluatable->False,
 CellID->202050773]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[176705, 3627, 228, 7, 70, "ExampleSection",
 CellID->318493502],
Cell[176936, 3636, 232, 5, 70, "ExampleText",
 CellID->367011776],
Cell[CellGroupData[{
Cell[177193, 3645, 1557, 48, 70, "Input",
 CellID->74486971],
Cell[178753, 3695, 62122, 1024, 70, "Output",
 Evaluatable->False,
 CellID->67806446]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[240936, 4726, 310, 9, 70, "SeeAlsoSection",
 CellID->3888],
Cell[241249, 4737, 206, 6, 70, "SeeAlso",
 CellID->12316]
}, Open  ]],
Cell[CellGroupData[{
Cell[241492, 4748, 313, 9, 70, "TutorialsSection",
 CellID->1225],
Cell[241808, 4759, 192, 4, 70, "Tutorials",
 CellID->29187]
}, Open  ]],
Cell[CellGroupData[{
Cell[242037, 4768, 318, 9, 70, "MoreAboutSection",
 CellID->62727260],
Cell[242358, 4779, 147, 3, 70, "MoreAbout",
 CellID->166397526]
}, Open  ]],
Cell[242520, 4785, 27, 0, 70, "History"],
Cell[242550, 4787, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

