(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14983,        554]
NotebookOptionsPosition[     11415,        432]
NotebookOutlinePosition[     12705,        470]
CellTagsIndexPosition[     12620,        465]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica Packages" :> 
          Documentation`HelpLookup["paclet:tutorial/MathematicaPackages"], 
          "Setting Up Mathematica Packages" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SettingUpMathematicaPackages"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Mathematica Packages\"\>", 
       2->"\<\"Setting Up Mathematica Packages\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Begin" :> Documentation`HelpLookup["paclet:ref/Begin"], 
          "BeginPackage" :> 
          Documentation`HelpLookup["paclet:ref/BeginPackage"], "EndPackage" :> 
          Documentation`HelpLookup["paclet:ref/EndPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Begin\"\>", 
       2->"\<\"BeginPackage\"\>", 
       3->"\<\"EndPackage\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Namespace Management" :> 
          Documentation`HelpLookup["paclet:guide/NamespaceManagement"], 
          "Package Development" :> 
          Documentation`HelpLookup["paclet:guide/PackageDevelopment"], 
          "Scoping Constructs" :> 
          Documentation`HelpLookup["paclet:guide/ScopingConstructs"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Namespace Management\"\>", 
       2->"\<\"Package Development\"\>", 
       3->"\<\"Scoping Constructs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["End", "ObjectName",
 CellID->19177],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["End",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/End"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the present context, and reverts to the \
previous one. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2180]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Every call to ",
 Cell[BoxData[
  ButtonBox["End",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/End"]], "InlineFormula"],
 " must be balanced by an earlier call to ",
 Cell[BoxData[
  ButtonBox["Begin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Begin"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18766],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["End",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/End"], "[", "]"}]], "InlineFormula"],
 " resets the value of ",
 Cell[BoxData[
  ButtonBox["$Context",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Context"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17937],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["End",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/End"], "[", "]"}]], "InlineFormula"],
 " returns the present context name as a string of the form ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"context\", \"TI\"]`\)]\)\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20115],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["End",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/End"], "[", "]"}]], "InlineFormula"],
 " does not modify ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17435]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->549474833],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->33072622],

Cell[TextData[{
 "Define a function ",
 Cell[BoxData["f"], "InlineFormula"],
 " in the ",
 Cell[BoxData["MyContext`"], "InlineFormula"],
 " ",
 Cell[BoxData[
  ButtonBox["Context",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Context"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellContext->"Global`",
 CellID->60875029],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"originalcontext", " ", "=", " ", 
  RowBox[{"Context", "[", "]"}]}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[1]:=",
 CellID->55648128],

Cell[BoxData["\<\"Global`\"\>"], "Output",
 CellContext->"Global`",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->413707865]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Begin", "[", "\"\<MyContext`\>\"", "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[2]:=",
 CellID->596713305],

Cell[BoxData["\<\"MyContext`\"\>"], "Output",
 CellContext->"Global`",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->146065855]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"x", "^", "2"}], " ", "+", " ", "1"}]}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[3]:=",
 CellID->601317634],

Cell["Restore the context:", "ExampleText",
 CellContext->"Global`",
 CellID->165022018],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"End", "[", "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[4]:=",
 CellID->31808584],

Cell[BoxData["\<\"MyContext`\"\>"], "Output",
 CellContext->"Global`",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->47988772]
}, Open  ]],

Cell[TextData[{
 "The context is now what it was before ",
 Cell[BoxData[
  ButtonBox["Begin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Begin"]], "InlineFormula"],
 " was used:"
}], "ExampleText",
 CellContext->"Global`",
 CellID->103634702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Context", "[", "]"}], " ", "===", " ", 
  "originalcontext"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[5]:=",
 CellID->173105151],

Cell[BoxData["True"], "Output",
 CellContext->"Global`",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->217818416]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11591],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Begin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Begin"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BeginPackage",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BeginPackage"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EndPackage",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EndPackage"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3035]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21519],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaPackages"],
  FontSlant->"Italic"],
 ButtonBox[" Packages",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaPackages"]
}], "Tutorials",
 CellID->135714781],

Cell[TextData[{
 ButtonBox["Setting Up ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SettingUpMathematicaPackages"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SettingUpMathematicaPackages"],
  FontSlant->"Italic"],
 ButtonBox[" Packages",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SettingUpMathematicaPackages"]
}], "Tutorials",
 CellID->14716]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Namespace Management",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NamespaceManagement"]], "MoreAbout",
 CellID->360946651],

Cell[TextData[ButtonBox["Package Development",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageDevelopment"]], "MoreAbout",
 CellID->671455658],

Cell[TextData[ButtonBox["Scoping Constructs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ScopingConstructs"]], "MoreAbout",
 CellID->761453082]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"End - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 40, 20.1674766}", "context" -> "System`", 
    "keywords" -> {
     "hidden symbols", "private symbols", "begin context", "set context", 
      "namespace", "Begin", "End"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "End[] returns the present context, and reverts to the previous one. ", 
    "synonyms" -> {}, "title" -> "End", "type" -> "Symbol", "uri" -> 
    "ref/End"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5469, 186, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->549474833]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12477, 458}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2426, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3049, 84, 41, 1, 70, "ObjectName",
 CellID->19177],
Cell[3093, 87, 466, 15, 70, "Usage",
 CellID->2180]
}, Open  ]],
Cell[CellGroupData[{
Cell[3596, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4074, 124, 336, 13, 70, "Notes",
 CellID->18766],
Cell[4413, 139, 330, 13, 70, "Notes",
 CellID->17937],
Cell[4746, 154, 349, 12, 70, "Notes",
 CellID->20115],
Cell[5098, 168, 334, 13, 70, "Notes",
 CellID->17435]
}, Closed]],
Cell[CellGroupData[{
Cell[5469, 186, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->549474833],
Cell[CellGroupData[{
Cell[5854, 200, 147, 5, 70, "ExampleSection",
 CellID->33072622],
Cell[6004, 207, 327, 13, 70, "ExampleText",
 CellID->60875029],
Cell[CellGroupData[{
Cell[6356, 224, 169, 5, 28, "Input",
 CellID->55648128],
Cell[6528, 231, 197, 6, 36, "Output",
 CellID->413707865]
}, Open  ]],
Cell[CellGroupData[{
Cell[6762, 242, 143, 4, 28, "Input",
 CellID->596713305],
Cell[6908, 248, 200, 6, 36, "Output",
 CellID->146065855]
}, Open  ]],
Cell[7123, 257, 214, 7, 70, "Input",
 CellID->601317634],
Cell[7340, 266, 88, 2, 70, "ExampleText",
 CellID->165022018],
Cell[CellGroupData[{
Cell[7453, 272, 118, 4, 70, "Input",
 CellID->31808584],
Cell[7574, 278, 199, 6, 36, "Output",
 CellID->47988772]
}, Open  ]],
Cell[7788, 287, 249, 9, 70, "ExampleText",
 CellID->103634702],
Cell[CellGroupData[{
Cell[8062, 300, 175, 6, 70, "Input",
 CellID->173105151],
Cell[8240, 308, 186, 6, 36, "Output",
 CellID->217818416]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8487, 321, 311, 9, 70, "SeeAlsoSection",
 CellID->11591],
Cell[8801, 332, 701, 26, 70, "SeeAlso",
 CellID->3035]
}, Open  ]],
Cell[CellGroupData[{
Cell[9539, 363, 314, 9, 70, "TutorialsSection",
 CellID->21519],
Cell[9856, 374, 284, 9, 70, "Tutorials",
 CellID->135714781],
Cell[10143, 385, 408, 12, 70, "Tutorials",
 CellID->14716]
}, Open  ]],
Cell[CellGroupData[{
Cell[10588, 402, 299, 8, 70, "MoreAboutSection"],
Cell[10890, 412, 151, 3, 70, "MoreAbout",
 CellID->360946651],
Cell[11044, 417, 149, 3, 70, "MoreAbout",
 CellID->671455658],
Cell[11196, 422, 147, 3, 70, "MoreAbout",
 CellID->761453082]
}, Open  ]],
Cell[11358, 428, 27, 0, 70, "History"],
Cell[11388, 430, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

