(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11933,        450]
NotebookOptionsPosition[      8378,        330]
NotebookOutlinePosition[      9715,        368]
CellTagsIndexPosition[      9631,        363]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink and External Program Communication" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]}\
, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"MathLink and External Program Communication\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BeginDialogPacket" :> 
          Documentation`HelpLookup["paclet:ref/BeginDialogPacket"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"BeginDialogPacket\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EndDialogPacket", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["EndDialogPacket",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/EndDialogPacket"], "[", 
       StyleBox["integer", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]is a ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " packet indicating the end of the ",
     Cell[BoxData[
      ButtonBox["Dialog",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Dialog"]], "InlineFormula"],
     " subsession referenced by ",
     StyleBox["integer", "TI"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->324988791],

Cell[TextData[{
 "Launch a subsidiary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel process:"
}], "ExampleText",
 CellID->1215824468],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"link", "=", 
  RowBox[{"LinkLaunch", "[", 
   RowBox[{
    RowBox[{"First", "[", "$CommandLine", "]"}], " ", "<>", " ", 
    "\"\< -mathlink\>\""}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->312144257],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"MathKernel -mathlink\"\>", ",", "333", ",", "7"}], 
  "]"}]], "Output",
 ImageSize->{279, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8836219]
}, Open  ]],

Cell["Read the first packet:", "ExampleText",
 CellID->625050465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2053461425],

Cell[BoxData[
 RowBox[{"InputNamePacket", "[", "\<\"In[1]:= \"\>", "]"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->195105400]
}, Open  ]],

Cell[TextData[{
 "Write the packet representing the text ",
 Cell[BoxData["\"\<Dialog[]\>\""], "InlineFormula"],
 " to enter:"
}], "ExampleText",
 CellID->316479038],

Cell[BoxData[
 RowBox[{"LinkWrite", "[", 
  RowBox[{"link", ",", 
   RowBox[{"EnterTextPacket", "[", "\"\<Dialog[]\>\"", "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1893681694],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1420596703],

Cell[BoxData[
 RowBox[{"BeginDialogPacket", "[", "1", "]"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->629134974]
}, Open  ]],

Cell[TextData[{
 "Write the packet representing the text ",
 Cell[BoxData["\"\<Return[]\>\""], "InlineFormula"],
 " to enter:"
}], "ExampleText",
 CellID->1163626052],

Cell[BoxData[
 RowBox[{"LinkWrite", "[", 
  RowBox[{"link", ",", 
   RowBox[{"EnterTextPacket", "[", "\"\<Return[]\>\"", "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->781618903],

Cell[TextData[{
 "Read the ",
 Cell[BoxData[
  ButtonBox["EndDialogPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EndDialogPacket"]], "InlineFormula"],
 " expression indicating the end of a dialog subsession:"
}], "ExampleText",
 CellID->1400582518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->511434022],

Cell[BoxData[
 RowBox[{"InputNamePacket", "[", "\<\" In[2]:= \"\>", "]"}]], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->545456118]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->75255178],

Cell[BoxData[
 RowBox[{"EndDialogPacket", "[", "1", "]"}]], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->848484773]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->1418284669],

Cell[BoxData[
 RowBox[{"InputNamePacket", "[", "\<\"In[2]:= \"\>", "]"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->3215167]
}, Open  ]],

Cell["Close the link:", "ExampleText",
 CellID->1054932471],

Cell[BoxData[
 RowBox[{"LinkClose", "[", "link", "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->1396673512]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["BeginDialogPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BeginDialogPacket"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]
}], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EndDialogPacket - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 40, 19.9330956}", "context" -> "System`", 
    "keywords" -> {
     "MathLink packet", "end dialog packet", "subsession packet"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "EndDialogPacket[integer] is a MathLink packet indicating the end of the \
Dialog subsession referenced by integer.", 
    "synonyms" -> {"end dialog packet"}, "title" -> "EndDialogPacket", "type" -> 
    "Symbol", "uri" -> "ref/EndDialogPacket"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2766, 93, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9497, 356}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1268, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1891, 60, 58, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[1952, 63, 777, 25, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[2766, 93, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3143, 107, 148, 5, 70, "ExampleSection",
 CellID->324988791],
Cell[3294, 114, 149, 6, 70, "ExampleText",
 CellID->1215824468],
Cell[CellGroupData[{
Cell[3468, 124, 234, 7, 28, "Input",
 CellID->312144257],
Cell[3705, 133, 258, 8, 36, "Output",
 CellID->8836219]
}, Open  ]],
Cell[3978, 144, 65, 1, 70, "ExampleText",
 CellID->625050465],
Cell[CellGroupData[{
Cell[4068, 149, 108, 3, 28, "Input",
 CellID->2053461425],
Cell[4179, 154, 215, 6, 36, "Output",
 CellID->195105400]
}, Open  ]],
Cell[4409, 163, 165, 5, 70, "ExampleText",
 CellID->316479038],
Cell[4577, 170, 193, 6, 70, "Input",
 CellID->1893681694],
Cell[CellGroupData[{
Cell[4795, 180, 108, 3, 70, "Input",
 CellID->1420596703],
Cell[4906, 185, 202, 6, 36, "Output",
 CellID->629134974]
}, Open  ]],
Cell[5123, 194, 166, 5, 70, "ExampleText",
 CellID->1163626052],
Cell[5292, 201, 192, 6, 70, "Input",
 CellID->781618903],
Cell[5487, 209, 260, 8, 70, "ExampleText",
 CellID->1400582518],
Cell[CellGroupData[{
Cell[5772, 221, 107, 3, 70, "Input",
 CellID->511434022],
Cell[5882, 226, 216, 6, 36, "Output",
 CellID->545456118]
}, Open  ]],
Cell[CellGroupData[{
Cell[6135, 237, 106, 3, 70, "Input",
 CellID->75255178],
Cell[6244, 242, 200, 6, 36, "Output",
 CellID->848484773]
}, Open  ]],
Cell[CellGroupData[{
Cell[6481, 253, 108, 3, 70, "Input",
 CellID->1418284669],
Cell[6592, 258, 213, 6, 36, "Output",
 CellID->3215167]
}, Open  ]],
Cell[6820, 267, 59, 1, 70, "ExampleText",
 CellID->1054932471],
Cell[6882, 270, 109, 3, 70, "Input",
 CellID->1396673512]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7040, 279, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[7359, 290, 218, 6, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[7614, 301, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[7935, 312, 371, 11, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[8321, 326, 27, 0, 70, "History"],
Cell[8351, 328, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

