(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11240,        396]
NotebookOptionsPosition[      8358,        299]
NotebookOutlinePosition[      9599,        335]
CellTagsIndexPosition[      9515,        330]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/StringPatterns"], 
          "Working with String Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithStringPatternsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"String Patterns\"\>", 
       2->"\<\"Working with String Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StartOfLine" :> 
          Documentation`HelpLookup["paclet:ref/StartOfLine"], "EndOfString" :> 
          Documentation`HelpLookup["paclet:ref/EndOfString"], 
          "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"StartOfLine\"\>", 
       2->"\<\"EndOfString\"\>", 
       3->"\<\"StringExpression\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Patterns" :> 
          Documentation`HelpLookup["paclet:guide/StringPatterns"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"String Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EndOfLine", "ObjectName",
 CellID->20496],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["EndOfLine",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/EndOfLine"]], "InlineFormula"],
     " \[LineSeparator]represents the end of a line in a string for purposes \
of matching in ",
     Cell[BoxData[
      ButtonBox["StringExpression",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10943]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EndOfLine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EndOfLine"]], "InlineFormula"],
 " is taken to occur at the end of a string, and immediately before every ",
 Cell[BoxData["\\n"], "InlineFormula"],
 " newline in the string."
}], "Notes",
 CellID->53]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->278394260],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->150750524],

Cell["Split a string at the end of a line:", "ExampleText",
 CellID->59390377],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StringSplit", "[", 
   RowBox[{"\"\<line1\\nline2\\nline3\>\"", ",", "EndOfLine"}], "]"}], "//", 
  "InputForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26754310],

Cell["{\"line1\", \"\\nline2\", \"\\nline3\"}", "Output",
 ImageSize->{217, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//InputForm=",
 CellID->24036050]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->223571101],

Cell["Find how many paragraphs are in the U.S. Constitution: ", "ExampleText",
 CellID->337344107],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCount", "[", 
  RowBox[{
   RowBox[{"Import", "[", "\"\<ExampleData/USConstitution.txt\>\"", "]"}], 
   ",", 
   RowBox[{"\"\<.\>\"", "~~", "EndOfLine"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->178578801],

Cell[BoxData["130"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8883155]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26767],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StartOfLine",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StartOfLine"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EndOfString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EndOfString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24320]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7986],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "Tutorials",
 CellID->8153],

Cell[TextData[ButtonBox["Working with String Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/WorkingWithStringPatternsOverview"]], "Tutorials",
 CellID->22514736]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->312129715],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "MoreAbout",
 CellID->548437576]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EndOfLine - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 40, 20.6049878}", "context" -> "System`", 
    "keywords" -> {"eol"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "EndOfLine represents the end of a line in a string for purposes of \
matching in StringExpression.", "synonyms" -> {"end of line"}, "title" -> 
    "EndOfLine", "type" -> "Symbol", "uri" -> "ref/EndOfLine"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4298, 138, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->278394260]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9372, 323}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2149, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2772, 80, 47, 1, 70, "ObjectName",
 CellID->20496],
Cell[2822, 83, 618, 19, 70, "Usage",
 CellID->10943]
}, Open  ]],
Cell[CellGroupData[{
Cell[3477, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3955, 124, 306, 9, 70, "Notes",
 CellID->53]
}, Closed]],
Cell[CellGroupData[{
Cell[4298, 138, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->278394260],
Cell[CellGroupData[{
Cell[4683, 152, 148, 5, 70, "ExampleSection",
 CellID->150750524],
Cell[4834, 159, 78, 1, 70, "ExampleText",
 CellID->59390377],
Cell[CellGroupData[{
Cell[4937, 164, 201, 6, 28, "Input",
 CellID->26754310],
Cell[5141, 172, 198, 5, 50, "Output",
 CellID->24036050]
}, Open  ]],
Cell[5354, 180, 125, 3, 70, "ExampleDelimiter",
 CellID->223571101],
Cell[5482, 185, 98, 1, 70, "ExampleText",
 CellID->337344107],
Cell[CellGroupData[{
Cell[5605, 190, 246, 7, 70, "Input",
 CellID->178578801],
Cell[5854, 199, 158, 5, 36, "Output",
 CellID->8883155]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6073, 211, 311, 9, 70, "SeeAlsoSection",
 CellID->26767],
Cell[6387, 222, 724, 26, 70, "SeeAlso",
 CellID->24320]
}, Open  ]],
Cell[CellGroupData[{
Cell[7148, 253, 313, 9, 70, "TutorialsSection",
 CellID->7986],
Cell[7464, 264, 139, 3, 70, "Tutorials",
 CellID->8153],
Cell[7606, 269, 178, 4, 70, "Tutorials",
 CellID->22514736]
}, Open  ]],
Cell[CellGroupData[{
Cell[7821, 278, 319, 9, 70, "MoreAboutSection",
 CellID->312129715],
Cell[8143, 289, 141, 3, 70, "MoreAbout",
 CellID->548437576]
}, Open  ]],
Cell[8299, 295, 29, 0, 70, "History"],
Cell[8331, 297, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

